package App::Zealc::Command;

use 5.014000;
use strict;
use warnings;

our $VERSION = '0.000_001';

use parent qw/App::Cmd::Command/;
use App::Zealc::UsageExtractor;

sub description {
	my ($self) = @_;
	my ($file) = (ref $self) =~ s,::,/,gr;
	my $parser = App::Zealc::UsageExtractor->new;
	$parser->parse_file($INC{"$file.pm"});
	return $parser->usage
}

1;
__END__

=encoding utf-8

=head1 NAME

App::Zealc::Command - Base class for zealc commands

=head1 SYNOPSIS

  package App::Zealc::Command::foo;
  use App::Zealc '-command';

=head1 DESCRIPTION

App::Zealc::Command is the base class of all zealc commands. Its only
role is to supply a default C<description> method that extracts the
SYNOPSIS and DESCRIPTION sections using L<App::Zealc::UsageExtractor>.

=head1 SEE ALSO

L<App::Zealc::UsageExtractor>, L<zealc>, L<Zeal>

=head1 AUTHOR

Marius Gavrilescu, E<lt>marius@ieval.roE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2015 by Marius Gavrilescu

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.20.1 or,
at your option, any later version of Perl 5 you may have available.


=cut
