#########################################################################################
# Package        HiPi::Graphics::BitmapFont::SerifEPD50
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Graphics::BitmapFont::SerifEPD50;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Graphics::BitmapFont);

our $VERSION ='0.01';

my $gap_width = 0;
my $char_height = 50;
my $line_spacing = 0;
my $name = 'Serif 50';
my $space_width = 14;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 5, 
        'xoffset'  => 6, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x20, ##    0  
            0xF0, ##  0000 
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 11, 
        'xoffset'  => 4, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xE0, 0xE0, ##  000     000
            0xE0, 0xE0, ##  000     000
            0xE0, 0xE0, ##  000     000
            0xE0, 0xE0, ##  000     000
            0xE0, 0xE0, ##  000     000
            0xE0, 0xE0, ##  000     000
            0xE0, 0xE0, ##  000     000
            0xE0, 0xE0, ##  000     000
            0xE0, 0xE0, ##  000     000
            0xE0, 0xE0, ##  000     000
            0xE0, 0xE0, ##  000     000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 29, 
        'xoffset'  => 3, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0E, 0x07, 0x80, ##              000      0000    
            0x00, 0x1E, 0x07, 0x80, ##             0000      0000    
            0x00, 0x1E, 0x07, 0x80, ##             0000      0000    
            0x00, 0x1E, 0x07, 0x00, ##             0000      000     
            0x00, 0x1C, 0x0F, 0x00, ##             000      0000     
            0x00, 0x3C, 0x0F, 0x00, ##            0000      0000     
            0x00, 0x3C, 0x0F, 0x00, ##            0000      0000     
            0x00, 0x3C, 0x0E, 0x00, ##            0000      000      
            0x00, 0x38, 0x1E, 0x00, ##            000      0000      
            0x3F, 0xFF, 0xFF, 0xF8, ##    000000000000000000000000000
            0x3F, 0xFF, 0xFF, 0xF8, ##    000000000000000000000000000
            0x3F, 0xFF, 0xFF, 0xF8, ##    000000000000000000000000000
            0x00, 0x70, 0x3C, 0x00, ##           000      0000       
            0x00, 0xF0, 0x3C, 0x00, ##          0000      0000       
            0x00, 0xF0, 0x38, 0x00, ##          0000      000        
            0x00, 0xF0, 0x38, 0x00, ##          0000      000        
            0x00, 0xE0, 0x78, 0x00, ##          000      0000        
            0x01, 0xE0, 0x78, 0x00, ##         0000      0000        
            0x01, 0xE0, 0x70, 0x00, ##         0000      000         
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000  
            0x03, 0xC0, 0xE0, 0x00, ##        0000      000          
            0x03, 0x81, 0xE0, 0x00, ##        000      0000          
            0x03, 0x81, 0xE0, 0x00, ##        000      0000          
            0x07, 0x81, 0xE0, 0x00, ##       0000      0000          
            0x07, 0x81, 0xC0, 0x00, ##       0000      000           
            0x07, 0x03, 0xC0, 0x00, ##       000      0000           
            0x07, 0x03, 0xC0, 0x00, ##       000      0000           
            0x0F, 0x03, 0xC0, 0x00, ##      0000      0000           
            0x0F, 0x03, 0x80, 0x00, ##      0000      000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 20, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x07, 0xFE, 0x00, ##       0000000000     
            0x1F, 0xFF, 0xC0, ##     000000000000000  
            0x3C, 0x67, 0xC0, ##    0000   00  00000  
            0x78, 0x63, 0xC0, ##   0000    00   0000  
            0x70, 0x61, 0xC0, ##   000     00    000  
            0xF0, 0x61, 0xC0, ##  0000     00    000  
            0xF0, 0x60, 0xC0, ##  0000     00     00  
            0xF0, 0x60, 0x00, ##  0000     00         
            0xF8, 0x60, 0x00, ##  00000    00         
            0xFC, 0x60, 0x00, ##  000000   00         
            0x7F, 0x60, 0x00, ##   0000000 00         
            0x7F, 0xE0, 0x00, ##   0000000000         
            0x3F, 0xFC, 0x00, ##    000000000000      
            0x0F, 0xFF, 0x00, ##      000000000000    
            0x03, 0xFF, 0xC0, ##        000000000000  
            0x00, 0x7F, 0xE0, ##           0000000000 
            0x00, 0x6F, 0xE0, ##           00 0000000 
            0x00, 0x63, 0xF0, ##           00   000000
            0x00, 0x63, 0xF0, ##           00   000000
            0x00, 0x61, 0xF0, ##           00    00000
            0xC0, 0x61, 0xF0, ##  00       00    00000
            0xC0, 0x61, 0xF0, ##  00       00    00000
            0xE0, 0x61, 0xF0, ##  000      00    00000
            0xE0, 0x63, 0xE0, ##  000      00   00000 
            0xF0, 0x63, 0xC0, ##  0000     00   0000  
            0xFF, 0xFF, 0x80, ##  00000000000000000   
            0x1F, 0xFF, 0x00, ##     0000000000000    
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x60, 0x00, ##           00         
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 36, 
        'xoffset'  => 2, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x3C, 0x00, ##                            0000      
            0x1F, 0xE0, 0x00, 0x38, 0x00, ##     00000000               000       
            0x3F, 0xF0, 0x00, 0x70, 0x00, ##    0000000000             000        
            0x78, 0x78, 0x00, 0xF0, 0x00, ##   0000    0000           0000        
            0x70, 0x38, 0x00, 0xE0, 0x00, ##   000      000           000         
            0xE0, 0x1C, 0x01, 0xE0, 0x00, ##  000        000         0000         
            0xE0, 0x1C, 0x01, 0xC0, 0x00, ##  000        000         000          
            0xE0, 0x1C, 0x03, 0x80, 0x00, ##  000        000        000           
            0xE0, 0x1C, 0x07, 0x80, 0x00, ##  000        000       0000           
            0xE0, 0x1C, 0x07, 0x00, 0x00, ##  000        000       000            
            0xE0, 0x1C, 0x0E, 0x00, 0x00, ##  000        000      000             
            0xE0, 0x1C, 0x1E, 0x00, 0x00, ##  000        000     0000             
            0x70, 0x38, 0x1C, 0x00, 0x00, ##   000      000      000              
            0x70, 0x38, 0x3C, 0x00, 0x00, ##   000      000     0000              
            0x38, 0x70, 0x38, 0x00, 0x00, ##    000    000      000               
            0x1F, 0xE0, 0x70, 0x3F, 0x00, ##     00000000      000      000000    
            0x0F, 0xC0, 0xF0, 0x7F, 0x80, ##      000000      0000     00000000   
            0x00, 0x00, 0xE0, 0xE1, 0xC0, ##                  000     000    000  
            0x00, 0x01, 0xC1, 0xC0, 0xE0, ##                 000     000      000 
            0x00, 0x03, 0xC1, 0xC0, 0xE0, ##                0000     000      000 
            0x00, 0x03, 0x83, 0x80, 0x70, ##                000     000        000
            0x00, 0x07, 0x83, 0x80, 0x70, ##               0000     000        000
            0x00, 0x07, 0x03, 0x80, 0x70, ##               000      000        000
            0x00, 0x0E, 0x03, 0x80, 0x70, ##              000       000        000
            0x00, 0x1E, 0x03, 0x80, 0x70, ##             0000       000        000
            0x00, 0x1C, 0x03, 0x80, 0x70, ##             000        000        000
            0x00, 0x38, 0x03, 0x80, 0x70, ##            000         000        000
            0x00, 0x38, 0x03, 0x80, 0xE0, ##            000         000       000 
            0x00, 0x70, 0x01, 0xC0, 0xE0, ##           000           000      000 
            0x00, 0xF0, 0x01, 0xE1, 0xE0, ##          0000           0000    0000 
            0x00, 0xE0, 0x00, 0xFF, 0xC0, ##          000             0000000000  
            0x01, 0xC0, 0x00, 0x7F, 0x80, ##         000               00000000   
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 33, 
        'xoffset'  => 3, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0xFF, 0xE0, 0x00, 0x00, ##          00000000000              
            0x03, 0xFF, 0xF0, 0x00, 0x00, ##        00000000000000             
            0x07, 0xC0, 0xF0, 0x00, 0x00, ##       00000      0000             
            0x07, 0x80, 0x70, 0x00, 0x00, ##       0000        000             
            0x0F, 0x00, 0x30, 0x00, 0x00, ##      0000          00             
            0x0F, 0x00, 0x30, 0x00, 0x00, ##      0000          00             
            0x0F, 0x00, 0x00, 0x00, 0x00, ##      0000                         
            0x0F, 0x00, 0x00, 0x00, 0x00, ##      0000                         
            0x0F, 0x80, 0x00, 0x00, 0x00, ##      00000                        
            0x07, 0xC0, 0x00, 0x00, 0x00, ##       00000                       
            0x07, 0xC0, 0x00, 0x00, 0x00, ##       00000                       
            0x03, 0xE0, 0x00, 0x00, 0x00, ##        00000                      
            0x07, 0xF0, 0x00, 0x00, 0x00, ##       0000000                     
            0x0E, 0xF8, 0x03, 0xFF, 0x00, ##      000 00000         0000000000 
            0x1C, 0x7C, 0x03, 0xFF, 0x00, ##     000   00000        0000000000 
            0x3C, 0x3E, 0x00, 0x30, 0x00, ##    0000    00000           00     
            0x78, 0x1F, 0x00, 0x30, 0x00, ##   0000      00000          00     
            0x78, 0x0F, 0x80, 0x70, 0x00, ##   0000       00000        000     
            0xF0, 0x0F, 0xC0, 0x70, 0x00, ##  0000        000000       000     
            0xF0, 0x07, 0xE0, 0x60, 0x00, ##  0000         000000      00      
            0xF0, 0x03, 0xF0, 0xE0, 0x00, ##  0000          000000    000      
            0xF0, 0x01, 0xF8, 0xC0, 0x00, ##  0000           000000   00       
            0xF0, 0x00, 0xFD, 0xC0, 0x00, ##  0000            000000 000       
            0xF0, 0x00, 0x7F, 0x80, 0x00, ##  0000             00000000        
            0xF8, 0x00, 0x3F, 0x80, 0x00, ##  00000             0000000        
            0x78, 0x00, 0x1F, 0x80, 0x00, ##   0000              000000        
            0x7C, 0x00, 0x0F, 0xC0, 0x00, ##   00000              000000       
            0x3E, 0x00, 0x1F, 0xC0, 0x00, ##    00000            0000000       
            0x1F, 0x00, 0x7B, 0xE0, 0x00, ##     00000         0000 00000      
            0x0F, 0xFF, 0xE1, 0xFF, 0x80, ##      000000000000000    0000000000
            0x03, 0xFF, 0x80, 0xFF, 0x80, ##        00000000000       000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 3, 
        'xoffset'  => 4, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 11, 
        'xoffset'  => 3, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x20, ##            0
            0x00, 0xE0, ##          000
            0x01, 0xC0, ##         000 
            0x03, 0x80, ##        000  
            0x07, 0x00, ##       000   
            0x0E, 0x00, ##      000    
            0x1E, 0x00, ##     0000    
            0x1C, 0x00, ##     000     
            0x3C, 0x00, ##    0000     
            0x38, 0x00, ##    000      
            0x78, 0x00, ##   0000      
            0x78, 0x00, ##   0000      
            0x78, 0x00, ##   0000      
            0x70, 0x00, ##   000       
            0xF0, 0x00, ##  0000       
            0xF0, 0x00, ##  0000       
            0xF0, 0x00, ##  0000       
            0xF0, 0x00, ##  0000       
            0xF0, 0x00, ##  0000       
            0xF0, 0x00, ##  0000       
            0xF0, 0x00, ##  0000       
            0xF0, 0x00, ##  0000       
            0xF0, 0x00, ##  0000       
            0xF0, 0x00, ##  0000       
            0xF0, 0x00, ##  0000       
            0xF0, 0x00, ##  0000       
            0x70, 0x00, ##   000       
            0x78, 0x00, ##   0000      
            0x78, 0x00, ##   0000      
            0x78, 0x00, ##   0000      
            0x38, 0x00, ##    000      
            0x3C, 0x00, ##    0000     
            0x1C, 0x00, ##     000     
            0x1E, 0x00, ##     0000    
            0x0E, 0x00, ##      000    
            0x07, 0x00, ##       000   
            0x03, 0x80, ##        000  
            0x01, 0xC0, ##         000 
            0x00, 0xE0, ##          000
            0x00, 0x20, ##            0
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 11, 
        'xoffset'  => 3, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x80, 0x00, ##  0          
            0xC0, 0x00, ##  00         
            0xF0, 0x00, ##  0000       
            0x78, 0x00, ##   0000      
            0x3C, 0x00, ##    0000     
            0x1E, 0x00, ##     0000    
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x07, 0x80, ##       0000  
            0x07, 0x80, ##       0000  
            0x07, 0xC0, ##       00000 
            0x07, 0xC0, ##       00000 
            0x07, 0xC0, ##       00000 
            0x03, 0xC0, ##        0000 
            0x03, 0xE0, ##        00000
            0x03, 0xE0, ##        00000
            0x03, 0xE0, ##        00000
            0x03, 0xE0, ##        00000
            0x03, 0xE0, ##        00000
            0x03, 0xE0, ##        00000
            0x03, 0xE0, ##        00000
            0x03, 0xE0, ##        00000
            0x03, 0xE0, ##        00000
            0x03, 0xE0, ##        00000
            0x03, 0xE0, ##        00000
            0x03, 0xE0, ##        00000
            0x03, 0xC0, ##        0000 
            0x07, 0xC0, ##       00000 
            0x07, 0xC0, ##       00000 
            0x07, 0xC0, ##       00000 
            0x07, 0x80, ##       0000  
            0x07, 0x80, ##       0000  
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x1E, 0x00, ##     0000    
            0x3C, 0x00, ##    0000     
            0x78, 0x00, ##   0000      
            0xF0, 0x00, ##  0000       
            0xC0, 0x00, ##  00         
            0x80, 0x00, ##  0          
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 21, 
        'xoffset'  => 0, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x70, 0x00, ##           000         
            0x00, 0x70, 0x00, ##           000         
            0x00, 0x70, 0x00, ##           000         
            0x00, 0x70, 0x00, ##           000         
            0x70, 0x70, 0x70, ##   000     000     000 
            0xF8, 0x70, 0xF8, ##  00000    000    00000
            0x3E, 0x73, 0xE0, ##    00000  000  00000  
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x03, 0xFE, 0x00, ##        000000000      
            0x00, 0xF8, 0x00, ##          00000        
            0x03, 0xFE, 0x00, ##        000000000      
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x3E, 0x73, 0xE0, ##    00000  000  00000  
            0xF8, 0x70, 0xF8, ##  00000    000    00000
            0x70, 0x70, 0x70, ##   000     000     000 
            0x00, 0x70, 0x00, ##           000         
            0x00, 0x70, 0x00, ##           000         
            0x00, 0x70, 0x00, ##           000         
            0x00, 0x70, 0x00, ##           000         
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 27, 
        'xoffset'  => 5, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x0F, ##      0000
            0x0F, ##      0000
            0x0F, ##      0000
            0x0F, ##      0000
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x1C, ##     000  
            0x3C, ##    0000  
            0x78, ##   0000   
            0x70, ##   000    
            0x00, ##          
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 5, 
        'xoffset'  => 4, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x20, ##    0  
            0xF0, ##  0000 
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x1C, ##             000
            0x00, 0x1C, ##             000
            0x00, 0x3C, ##            0000
            0x00, 0x38, ##            000 
            0x00, 0x38, ##            000 
            0x00, 0x78, ##           0000 
            0x00, 0x70, ##           000  
            0x00, 0x70, ##           000  
            0x00, 0xF0, ##          0000  
            0x00, 0xF0, ##          0000  
            0x00, 0xE0, ##          000   
            0x00, 0xE0, ##          000   
            0x01, 0xE0, ##         0000   
            0x01, 0xC0, ##         000    
            0x01, 0xC0, ##         000    
            0x03, 0xC0, ##        0000    
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0x07, 0x80, ##       0000     
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x0F, 0x00, ##      0000      
            0x0E, 0x00, ##      000       
            0x0E, 0x00, ##      000       
            0x1E, 0x00, ##     0000       
            0x1E, 0x00, ##     0000       
            0x1C, 0x00, ##     000        
            0x3C, 0x00, ##    0000        
            0x3C, 0x00, ##    0000        
            0x38, 0x00, ##    000         
            0x38, 0x00, ##    000         
            0x78, 0x00, ##   0000         
            0x70, 0x00, ##   000          
            0x70, 0x00, ##   000          
            0xF0, 0x00, ##  0000          
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 22, 
        'xoffset'  => 3, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                        
            0x01, 0xFE, 0x00, ##         00000000       
            0x07, 0xFF, 0x80, ##       000000000000     
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x1E, 0x01, 0xE0, ##     0000        0000   
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x78, 0x00, 0xF8, ##   0000           00000 
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1E, 0x01, 0xE0, ##     0000        0000   
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x07, 0xFF, 0x80, ##       000000000000     
            0x01, 0xFF, 0x00, ##         000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 16, 
        'xoffset'  => 5, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x01, 0xE0, ##         0000     
            0x03, 0xE0, ##        00000     
            0x0F, 0xE0, ##      0000000     
            0x3F, 0xE0, ##    000000000     
            0x7D, 0xE0, ##   00000 0000     
            0xF1, 0xE0, ##  0000   0000     
            0xC1, 0xE0, ##  00     0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x7F, 0xFF, ##   000000000000000
            0x7F, 0xFF, ##   000000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0x1F, 0xFE, 0x00, ##     000000000000     
            0x7F, 0xFF, 0x80, ##   0000000000000000   
            0xF8, 0x0F, 0xC0, ##  00000       000000  
            0xF0, 0x03, 0xE0, ##  0000          00000 
            0xE0, 0x03, 0xE0, ##  000           00000 
            0xE0, 0x01, 0xF0, ##  000            00000
            0xC0, 0x01, 0xF0, ##  00             00000
            0x00, 0x01, 0xF0, ##                 00000
            0x00, 0x01, 0xF0, ##                 00000
            0x00, 0x01, 0xF0, ##                 00000
            0x00, 0x01, 0xF0, ##                 00000
            0x00, 0x01, 0xE0, ##                 0000 
            0x00, 0x03, 0xE0, ##                00000 
            0x00, 0x03, 0xC0, ##                0000  
            0x00, 0x07, 0xC0, ##               00000  
            0x00, 0x07, 0x80, ##               0000   
            0x00, 0x0F, 0x00, ##              0000    
            0x00, 0x1E, 0x00, ##             0000     
            0x00, 0x3C, 0x00, ##            0000      
            0x00, 0x78, 0x00, ##           0000       
            0x00, 0xF0, 0x00, ##          0000        
            0x01, 0xE0, 0x00, ##         0000         
            0x03, 0xC0, 0x00, ##        0000          
            0x07, 0x80, 0x00, ##       0000           
            0x0F, 0x00, 0x30, ##      0000          00
            0x1E, 0x00, 0x30, ##     0000           00
            0x3C, 0x00, 0x30, ##    0000            00
            0x78, 0x00, 0x30, ##   0000             00
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 21, 
        'xoffset'  => 3, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                       
            0x1F, 0xFF, 0x00, ##     0000000000000     
            0x7F, 0xFF, 0x80, ##   0000000000000000    
            0x78, 0x07, 0xC0, ##   0000        00000   
            0x70, 0x03, 0xE0, ##   000          00000  
            0x60, 0x01, 0xF0, ##   00            00000 
            0x60, 0x01, 0xF0, ##   00            00000 
            0x60, 0x01, 0xF0, ##   00            00000 
            0x00, 0x01, 0xF0, ##                 00000 
            0x00, 0x01, 0xF0, ##                 00000 
            0x00, 0x01, 0xE0, ##                 0000  
            0x00, 0x03, 0xE0, ##                00000  
            0x00, 0x07, 0xC0, ##               00000   
            0x00, 0x1F, 0x00, ##             00000     
            0x01, 0xFC, 0x00, ##         0000000       
            0x01, 0xFE, 0x00, ##         00000000      
            0x00, 0x0F, 0x80, ##              00000    
            0x00, 0x03, 0xE0, ##                00000  
            0x00, 0x01, 0xE0, ##                 0000  
            0x00, 0x01, 0xF0, ##                 00000 
            0x00, 0x00, 0xF8, ##                  00000
            0x00, 0x00, 0xF8, ##                  00000
            0x00, 0x00, 0xF8, ##                  00000
            0x00, 0x00, 0xF8, ##                  00000
            0xC0, 0x00, 0xF8, ##  00              00000
            0xC0, 0x00, 0xF8, ##  00              00000
            0xC0, 0x01, 0xF8, ##  00             000000
            0xE0, 0x01, 0xF0, ##  000            00000 
            0xE0, 0x03, 0xF0, ##  000           000000 
            0xF8, 0x07, 0xE0, ##  00000        000000  
            0xFF, 0xFF, 0xC0, ##  000000000000000000   
            0x1F, 0xFF, 0x00, ##     0000000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xC0, ##                0000      
            0x00, 0x07, 0xC0, ##               00000      
            0x00, 0x0F, 0xC0, ##              000000      
            0x00, 0x0F, 0xC0, ##              000000      
            0x00, 0x1F, 0xC0, ##             0000000      
            0x00, 0x3B, 0xC0, ##            000 0000      
            0x00, 0x3B, 0xC0, ##            000 0000      
            0x00, 0x73, 0xC0, ##           000  0000      
            0x00, 0xE3, 0xC0, ##          000   0000      
            0x00, 0xE3, 0xC0, ##          000   0000      
            0x01, 0xC3, 0xC0, ##         000    0000      
            0x03, 0x83, 0xC0, ##        000     0000      
            0x03, 0x83, 0xC0, ##        000     0000      
            0x07, 0x03, 0xC0, ##       000      0000      
            0x0E, 0x03, 0xC0, ##      000       0000      
            0x0E, 0x03, 0xC0, ##      000       0000      
            0x1C, 0x03, 0xC0, ##     000        0000      
            0x38, 0x03, 0xC0, ##    000         0000      
            0x38, 0x03, 0xC0, ##    000         0000      
            0x70, 0x03, 0xC0, ##   000          0000      
            0xE0, 0x03, 0xC0, ##  000           0000      
            0xFF, 0xFF, 0xFF, ##  000000000000000000000000
            0xFF, 0xFF, 0xFF, ##  000000000000000000000000
            0x00, 0x03, 0xC0, ##                0000      
            0x00, 0x03, 0xC0, ##                0000      
            0x00, 0x03, 0xC0, ##                0000      
            0x00, 0x03, 0xC0, ##                0000      
            0x00, 0x03, 0xC0, ##                0000      
            0x00, 0x03, 0xC0, ##                0000      
            0x00, 0x03, 0xC0, ##                0000      
            0x00, 0x7F, 0xFE, ##           00000000000000 
            0x00, 0x7F, 0xFE, ##           00000000000000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 21, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x3F, 0xFF, 0xC0, ##    0000000000000000   
            0x3F, 0xFF, 0xC0, ##    0000000000000000   
            0x3F, 0xFF, 0xC0, ##    0000000000000000   
            0x30, 0x00, 0x00, ##    00                 
            0x30, 0x00, 0x00, ##    00                 
            0x30, 0x00, 0x00, ##    00                 
            0x30, 0x00, 0x00, ##    00                 
            0x30, 0x00, 0x00, ##    00                 
            0x30, 0x00, 0x00, ##    00                 
            0x30, 0x00, 0x00, ##    00                 
            0x33, 0xFC, 0x00, ##    00  00000000       
            0x3F, 0xFF, 0x00, ##    00000000000000     
            0x3C, 0x0F, 0xC0, ##    0000      000000   
            0x38, 0x07, 0xE0, ##    000        000000  
            0x30, 0x03, 0xE0, ##    00          00000  
            0x00, 0x01, 0xF0, ##                 00000 
            0x00, 0x01, 0xF0, ##                 00000 
            0x00, 0x00, 0xF8, ##                  00000
            0x00, 0x00, 0xF8, ##                  00000
            0x00, 0x00, 0xF8, ##                  00000
            0x00, 0x00, 0xF8, ##                  00000
            0x00, 0x00, 0xF8, ##                  00000
            0x00, 0x00, 0xF8, ##                  00000
            0xC0, 0x00, 0xF8, ##  00              00000
            0xC0, 0x00, 0xF0, ##  00              0000 
            0xC0, 0x01, 0xF0, ##  00             00000 
            0xE0, 0x01, 0xF0, ##  000            00000 
            0xE0, 0x03, 0xE0, ##  000           00000  
            0xF8, 0x07, 0xC0, ##  00000        00000   
            0xFF, 0xFF, 0x80, ##  00000000000000000    
            0x1F, 0xFE, 0x00, ##     000000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 22, 
        'xoffset'  => 3, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                        
            0x00, 0xFF, 0xE0, ##          00000000000   
            0x03, 0xFF, 0xF0, ##        00000000000000  
            0x07, 0x00, 0xF0, ##       000        0000  
            0x0E, 0x00, 0x70, ##      000          000  
            0x1C, 0x00, 0x70, ##     000           000  
            0x3C, 0x00, 0x00, ##    0000                
            0x38, 0x00, 0x00, ##    000                 
            0x78, 0x00, 0x00, ##   0000                 
            0x78, 0x00, 0x00, ##   0000                 
            0x78, 0x00, 0x00, ##   0000                 
            0x70, 0xFE, 0x00, ##   000    0000000       
            0xF3, 0xFF, 0x80, ##  0000  00000000000     
            0xF7, 0x87, 0xE0, ##  0000 0000    000000   
            0xFE, 0x01, 0xF0, ##  0000000        00000  
            0xFC, 0x00, 0xF0, ##  000000          0000  
            0xFC, 0x00, 0xF8, ##  000000          00000 
            0xF8, 0x00, 0xF8, ##  00000           00000 
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x78, 0x00, 0x7C, ##   0000            00000
            0x78, 0x00, 0x7C, ##   0000            00000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x3C, 0x00, 0xF8, ##    0000          00000 
            0x3C, 0x00, 0xF8, ##    0000          00000 
            0x1E, 0x01, 0xF0, ##     0000        00000  
            0x0F, 0x03, 0xE0, ##      0000      00000   
            0x07, 0xFF, 0xC0, ##       0000000000000    
            0x03, 0xFF, 0x00, ##        0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 21, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000 
            0xC0, 0x00, 0x70, ##  00               000 
            0xC0, 0x00, 0xE0, ##  00              000  
            0xC0, 0x00, 0xE0, ##  00              000  
            0xC0, 0x01, 0xE0, ##  00             0000  
            0x00, 0x01, 0xC0, ##                 000   
            0x00, 0x03, 0xC0, ##                0000   
            0x00, 0x03, 0x80, ##                000    
            0x00, 0x03, 0x80, ##                000    
            0x00, 0x07, 0x00, ##               000     
            0x00, 0x07, 0x00, ##               000     
            0x00, 0x0F, 0x00, ##              0000     
            0x00, 0x0E, 0x00, ##              000      
            0x00, 0x1E, 0x00, ##             0000      
            0x00, 0x1C, 0x00, ##             000       
            0x00, 0x1C, 0x00, ##             000       
            0x00, 0x38, 0x00, ##            000        
            0x00, 0x38, 0x00, ##            000        
            0x00, 0x78, 0x00, ##           0000        
            0x00, 0x70, 0x00, ##           000         
            0x00, 0xF0, 0x00, ##          0000         
            0x00, 0xE0, 0x00, ##          000          
            0x00, 0xE0, 0x00, ##          000          
            0x01, 0xC0, 0x00, ##         000           
            0x01, 0xC0, 0x00, ##         000           
            0x03, 0xC0, 0x00, ##        0000           
            0x03, 0x80, 0x00, ##        000            
            0x07, 0x80, 0x00, ##       0000            
            0x07, 0x00, 0x00, ##       000             
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 22, 
        'xoffset'  => 3, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x00, ##        0000000000      
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x7C, 0x00, 0xF0, ##   00000          0000  
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1E, 0x01, 0xF0, ##     0000        00000  
            0x0F, 0x87, 0xE0, ##      00000    000000   
            0x03, 0xFF, 0x80, ##        00000000000     
            0x03, 0xFE, 0x00, ##        000000000       
            0x0F, 0x03, 0xC0, ##      0000      0000    
            0x3E, 0x01, 0xE0, ##    00000        0000   
            0x7C, 0x00, 0xF0, ##   00000          0000  
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x7C, 0x01, 0xF8, ##   00000         000000 
            0x3E, 0x03, 0xF0, ##    00000       000000  
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x07, 0xFF, 0x80, ##       000000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 22, 
        'xoffset'  => 3, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x00, ##        0000000000      
            0x0F, 0xFF, 0x80, ##      0000000000000     
            0x1F, 0x03, 0xC0, ##     00000      0000    
            0x3E, 0x01, 0xE0, ##    00000        0000   
            0x7C, 0x01, 0xF0, ##   00000         00000  
            0x7C, 0x00, 0xF0, ##   00000          0000  
            0xF8, 0x00, 0xF8, ##  00000           00000 
            0xF8, 0x00, 0xF8, ##  00000           00000 
            0xF8, 0x00, 0xF8, ##  00000           00000 
            0xF8, 0x00, 0xFC, ##  00000           000000
            0xF8, 0x00, 0xFC, ##  00000           000000
            0xF8, 0x00, 0xFC, ##  00000           000000
            0xF8, 0x00, 0xFC, ##  00000           000000
            0xF8, 0x00, 0xFC, ##  00000           000000
            0x7C, 0x00, 0xFC, ##   00000          000000
            0x7C, 0x01, 0xFC, ##   00000         0000000
            0x3E, 0x03, 0xFC, ##    00000       00000000
            0x1F, 0x07, 0x7C, ##     00000     000 00000
            0x0F, 0xFE, 0x7C, ##      00000000000  00000
            0x03, 0xF8, 0x7C, ##        0000000    00000
            0x00, 0x00, 0x78, ##                   0000 
            0x00, 0x00, 0x78, ##                   0000 
            0x00, 0x00, 0x78, ##                   0000 
            0x00, 0x00, 0xF8, ##                  00000 
            0x00, 0x00, 0xF0, ##                  0000  
            0x38, 0x00, 0xF0, ##    000           0000  
            0x38, 0x01, 0xE0, ##    000          0000   
            0x38, 0x03, 0xC0, ##    000         0000    
            0x3C, 0x07, 0x80, ##    0000       0000     
            0x3F, 0xFF, 0x00, ##    00000000000000      
            0x1F, 0xFC, 0x00, ##     00000000000        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 5, 
        'xoffset'  => 4, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000 
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0x70, ##   000 
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x20, ##    0  
            0xF0, ##  0000 
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 8, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x0E, ##      000 
            0x1F, ##     00000
            0x1F, ##     00000
            0x1F, ##     00000
            0x0E, ##      000 
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x0F, ##      0000
            0x0F, ##      0000
            0x0F, ##      0000
            0x0F, ##      0000
            0x0E, ##      000 
            0x1E, ##     0000 
            0x1E, ##     0000 
            0x3C, ##    0000  
            0x78, ##   0000   
            0xF0, ##  0000    
            0x60, ##   00     
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 27, 
        'xoffset'  => 5, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x60, ##                           00
            0x00, 0x00, 0x01, 0xE0, ##                         0000
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000
            0x00, 0x00, 0x7F, 0xE0, ##                   0000000000
            0x00, 0x03, 0xFF, 0x00, ##                0000000000   
            0x00, 0x0F, 0xFC, 0x00, ##              0000000000     
            0x00, 0x7F, 0xE0, 0x00, ##           0000000000        
            0x03, 0xFF, 0x00, 0x00, ##        0000000000           
            0x1F, 0xF8, 0x00, 0x00, ##     0000000000              
            0x7F, 0xE0, 0x00, 0x00, ##   0000000000                
            0xFF, 0x00, 0x00, 0x00, ##  00000000                   
            0xF8, 0x00, 0x00, 0x00, ##  00000                      
            0xFF, 0x00, 0x00, 0x00, ##  00000000                   
            0x7F, 0xE0, 0x00, 0x00, ##   0000000000                
            0x0F, 0xF8, 0x00, 0x00, ##      000000000              
            0x03, 0xFF, 0x00, 0x00, ##        0000000000           
            0x00, 0x7F, 0xE0, 0x00, ##           0000000000        
            0x00, 0x0F, 0xFC, 0x00, ##              0000000000     
            0x00, 0x01, 0xFF, 0x00, ##                 000000000   
            0x00, 0x00, 0x7F, 0xE0, ##                   0000000000
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000
            0x00, 0x00, 0x01, 0xE0, ##                         0000
            0x00, 0x00, 0x00, 0x20, ##                            0
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 27, 
        'xoffset'  => 5, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 27, 
        'xoffset'  => 5, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xC0, 0x00, 0x00, 0x00, ##  00                         
            0xF0, 0x00, 0x00, 0x00, ##  0000                       
            0xFE, 0x00, 0x00, 0x00, ##  0000000                    
            0xFF, 0xC0, 0x00, 0x00, ##  0000000000                 
            0x1F, 0xF8, 0x00, 0x00, ##     0000000000              
            0x07, 0xFE, 0x00, 0x00, ##       0000000000            
            0x00, 0xFF, 0xC0, 0x00, ##          0000000000         
            0x00, 0x1F, 0xF8, 0x00, ##             0000000000      
            0x00, 0x03, 0xFF, 0x00, ##                0000000000   
            0x00, 0x00, 0xFF, 0xC0, ##                  0000000000 
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x03, 0xE0, ##                        00000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0xFF, 0xC0, ##                  0000000000 
            0x00, 0x03, 0xFE, 0x00, ##                000000000    
            0x00, 0x1F, 0xF8, 0x00, ##             0000000000      
            0x00, 0xFF, 0xC0, 0x00, ##          0000000000         
            0x07, 0xFE, 0x00, 0x00, ##       0000000000            
            0x1F, 0xF0, 0x00, 0x00, ##     000000000               
            0xFF, 0xC0, 0x00, 0x00, ##  0000000000                 
            0xFE, 0x00, 0x00, 0x00, ##  0000000                    
            0xF0, 0x00, 0x00, 0x00, ##  0000                       
            0x80, 0x00, 0x00, 0x00, ##  0                          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 18, 
        'xoffset'  => 3, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                    
            0x3F, 0xF8, 0x00, ##    00000000000     
            0xFF, 0xFE, 0x00, ##  000000000000000   
            0xF0, 0x1F, 0x00, ##  0000       00000  
            0xE0, 0x0F, 0x80, ##  000         00000 
            0xC0, 0x0F, 0x80, ##  00          00000 
            0xC0, 0x07, 0xC0, ##  00           00000
            0xC0, 0x07, 0xC0, ##  00           00000
            0x00, 0x07, 0xC0, ##               00000
            0x00, 0x07, 0xC0, ##               00000
            0x00, 0x07, 0xC0, ##               00000
            0x00, 0x07, 0xC0, ##               00000
            0x00, 0x0F, 0x80, ##              00000 
            0x00, 0x0F, 0x80, ##              00000 
            0x00, 0x1F, 0x00, ##             00000  
            0x00, 0x7E, 0x00, ##           000000   
            0x01, 0xFC, 0x00, ##         0000000    
            0x07, 0xF0, 0x00, ##       0000000      
            0x07, 0x80, 0x00, ##       0000         
            0x07, 0x00, 0x00, ##       000          
            0x07, 0x00, 0x00, ##       000          
            0x07, 0x00, 0x00, ##       000          
            0x07, 0x00, 0x00, ##       000          
            0x07, 0x00, 0x00, ##       000          
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x02, 0x00, 0x00, ##        0           
            0x0F, 0x00, 0x00, ##      0000          
            0x0F, 0x80, 0x00, ##      00000         
            0x0F, 0x80, 0x00, ##      00000         
            0x0F, 0x80, 0x00, ##      00000         
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 37, 
        'xoffset'  => 3, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xFF, 0x00, 0x00, ##                 000000000             
            0x00, 0x0F, 0xFF, 0xE0, 0x00, ##              000000000000000          
            0x00, 0x3F, 0x00, 0xF8, 0x00, ##            000000        00000        
            0x00, 0xF8, 0x00, 0x1E, 0x00, ##          00000              0000      
            0x01, 0xE0, 0x00, 0x07, 0x00, ##         0000                  000     
            0x03, 0xC0, 0x00, 0x03, 0x80, ##        0000                    000    
            0x07, 0x80, 0x00, 0x01, 0xC0, ##       0000                      000   
            0x0F, 0x00, 0x00, 0x00, 0xC0, ##      0000                        00   
            0x1E, 0x00, 0x00, 0x00, 0x60, ##     0000                          00  
            0x3C, 0x00, 0x00, 0x00, 0x70, ##    0000                           000 
            0x3C, 0x01, 0xF8, 0xE0, 0x30, ##    0000         000000   000       00 
            0x78, 0x07, 0xFE, 0xE0, 0x30, ##   0000        0000000000 000       00 
            0x78, 0x0F, 0x87, 0xE0, 0x18, ##   0000       00000    000000        00
            0x78, 0x1F, 0x03, 0xE0, 0x18, ##   0000      00000      00000        00
            0xF0, 0x1E, 0x01, 0xE0, 0x18, ##  0000       0000        0000        00
            0xF0, 0x3E, 0x00, 0xE0, 0x18, ##  0000      00000         000        00
            0xF0, 0x3C, 0x00, 0xE0, 0x18, ##  0000      0000          000        00
            0xF0, 0x3C, 0x00, 0xE0, 0x18, ##  0000      0000          000        00
            0xF0, 0x3C, 0x00, 0xE0, 0x18, ##  0000      0000          000        00
            0xF0, 0x3C, 0x00, 0xE0, 0x18, ##  0000      0000          000        00
            0xF0, 0x3C, 0x00, 0xE0, 0x30, ##  0000      0000          000       00 
            0xF0, 0x3C, 0x00, 0xE0, 0x30, ##  0000      0000          000       00 
            0xF0, 0x1C, 0x00, 0xE0, 0x60, ##  0000       000          000      00  
            0xF0, 0x1E, 0x01, 0xE0, 0xE0, ##  0000       0000        0000     000  
            0x78, 0x1F, 0x03, 0xE1, 0xC0, ##   0000      00000      00000    000   
            0x78, 0x0F, 0x87, 0xE7, 0x80, ##   0000       00000    000000  0000    
            0x78, 0x07, 0xFE, 0xFE, 0x00, ##   0000        0000000000 0000000      
            0x3C, 0x01, 0xF8, 0xF0, 0x00, ##    0000         000000   0000         
            0x3C, 0x00, 0x00, 0x00, 0x00, ##    0000                               
            0x1E, 0x00, 0x00, 0x00, 0x00, ##     0000                              
            0x0F, 0x00, 0x00, 0x00, 0x00, ##      0000                             
            0x0F, 0x80, 0x00, 0x00, 0x00, ##      00000                            
            0x07, 0xC0, 0x00, 0x00, 0x00, ##       00000                           
            0x03, 0xE0, 0x00, 0x1C, 0x00, ##        00000                000       
            0x00, 0xF8, 0x00, 0x38, 0x00, ##          00000             000        
            0x00, 0x7F, 0x01, 0xF0, 0x00, ##           0000000       00000         
            0x00, 0x1F, 0xFF, 0xC0, 0x00, ##             000000000000000           
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000              
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 32, 
        'xoffset'  => 0, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xC0, 0x00, ##                0000              
            0x00, 0x03, 0xE0, 0x00, ##                00000             
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x07, 0xF0, 0x00, ##               0000000            
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x0C, 0xF0, 0x00, ##              00  0000            
            0x00, 0x1C, 0xF8, 0x00, ##             000  00000           
            0x00, 0x1C, 0xF8, 0x00, ##             000  00000           
            0x00, 0x18, 0x7C, 0x00, ##             00    00000          
            0x00, 0x38, 0x7C, 0x00, ##            000    00000          
            0x00, 0x30, 0x3C, 0x00, ##            00      0000          
            0x00, 0x70, 0x3E, 0x00, ##           000      00000         
            0x00, 0x70, 0x3E, 0x00, ##           000      00000         
            0x00, 0x60, 0x1F, 0x00, ##           00        00000        
            0x00, 0xE0, 0x1F, 0x00, ##          000        00000        
            0x00, 0xC0, 0x0F, 0x00, ##          00          0000        
            0x01, 0xC0, 0x0F, 0x80, ##         000          00000       
            0x01, 0xC0, 0x0F, 0x80, ##         000          00000       
            0x01, 0x80, 0x07, 0x80, ##         00            0000       
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0x00, 0x03, 0xE0, ##       000              00000     
            0x07, 0x00, 0x03, 0xE0, ##       000              00000     
            0x06, 0x00, 0x01, 0xE0, ##       00                0000     
            0x0E, 0x00, 0x01, 0xF0, ##      000                00000    
            0x0C, 0x00, 0x01, 0xF0, ##      00                 00000    
            0x1C, 0x00, 0x00, 0xF0, ##     000                  0000    
            0x1C, 0x00, 0x00, 0xF8, ##     000                  00000   
            0xFF, 0x80, 0x07, 0xFF, ##  000000000            00000000000
            0xFF, 0x80, 0x07, 0xFF, ##  000000000            00000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 27, 
        'xoffset'  => 2, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF0, 0x00, ##  00000000000000000000       
            0xFF, 0xFF, 0xFC, 0x00, ##  0000000000000000000000     
            0x0F, 0x80, 0x7E, 0x00, ##      00000        000000    
            0x0F, 0x80, 0x1F, 0x00, ##      00000          00000   
            0x0F, 0x80, 0x1F, 0x00, ##      00000          00000   
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000  
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000  
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000  
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000  
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000  
            0x0F, 0x80, 0x1F, 0x00, ##      00000          00000   
            0x0F, 0x80, 0x1F, 0x00, ##      00000          00000   
            0x0F, 0x80, 0x7E, 0x00, ##      00000        000000    
            0x0F, 0xFF, 0xF0, 0x00, ##      0000000000000000       
            0x0F, 0xFF, 0xF8, 0x00, ##      00000000000000000      
            0x0F, 0x80, 0x3F, 0x00, ##      00000         000000   
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000  
            0x0F, 0x80, 0x07, 0xC0, ##      00000            00000 
            0x0F, 0x80, 0x07, 0xC0, ##      00000            00000 
            0x0F, 0x80, 0x03, 0xE0, ##      00000             00000
            0x0F, 0x80, 0x03, 0xE0, ##      00000             00000
            0x0F, 0x80, 0x03, 0xE0, ##      00000             00000
            0x0F, 0x80, 0x03, 0xE0, ##      00000             00000
            0x0F, 0x80, 0x03, 0xE0, ##      00000             00000
            0x0F, 0x80, 0x03, 0xE0, ##      00000             00000
            0x0F, 0x80, 0x07, 0xC0, ##      00000            00000 
            0x0F, 0x80, 0x07, 0xC0, ##      00000            00000 
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000  
            0x0F, 0x80, 0x3F, 0x00, ##      00000         000000   
            0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000    
            0xFF, 0xFF, 0xF0, 0x00, ##  00000000000000000000       
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 28, 
        'xoffset'  => 2, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##                              
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000      
            0x01, 0xFF, 0xFF, 0xC0, ##         0000000000000000000  
            0x03, 0xE0, 0x0F, 0xE0, ##        00000         0000000 
            0x07, 0x80, 0x03, 0xE0, ##       0000             00000 
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000 
            0x1E, 0x00, 0x01, 0xE0, ##     0000                0000 
            0x3E, 0x00, 0x00, 0xE0, ##    00000                 000 
            0x3C, 0x00, 0x00, 0xE0, ##    0000                  000 
            0x7C, 0x00, 0x00, 0xE0, ##   00000                  000 
            0x7C, 0x00, 0x00, 0x00, ##   00000                      
            0x78, 0x00, 0x00, 0x00, ##   0000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0x78, 0x00, 0x00, 0x00, ##   0000                       
            0x7C, 0x00, 0x00, 0x00, ##   00000                      
            0x7C, 0x00, 0x00, 0x00, ##   00000                      
            0x3C, 0x00, 0x00, 0xF0, ##    0000                  0000
            0x3E, 0x00, 0x01, 0xE0, ##    00000                0000 
            0x1E, 0x00, 0x01, 0xE0, ##     0000                0000 
            0x0F, 0x00, 0x03, 0xC0, ##      0000              0000  
            0x07, 0x80, 0x07, 0x80, ##       0000            0000   
            0x03, 0xC0, 0x0F, 0x00, ##        0000          0000    
            0x01, 0xFF, 0xFE, 0x00, ##         0000000000000000     
            0x00, 0x7F, 0xF8, 0x00, ##           000000000000       
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 30, 
        'xoffset'  => 2, 
        'xadvance' => 34, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xC0, 0x00, ##  000000000000000000            
            0xFF, 0xFF, 0xF8, 0x00, ##  000000000000000000000         
            0x0F, 0x80, 0x7E, 0x00, ##      00000        000000       
            0x0F, 0x80, 0x1F, 0x80, ##      00000          000000     
            0x0F, 0x80, 0x07, 0xC0, ##      00000            00000    
            0x0F, 0x80, 0x03, 0xE0, ##      00000             00000   
            0x0F, 0x80, 0x01, 0xE0, ##      00000              0000   
            0x0F, 0x80, 0x01, 0xF0, ##      00000              00000  
            0x0F, 0x80, 0x00, 0xF8, ##      00000               00000 
            0x0F, 0x80, 0x00, 0xF8, ##      00000               00000 
            0x0F, 0x80, 0x00, 0xF8, ##      00000               00000 
            0x0F, 0x80, 0x00, 0x7C, ##      00000                00000
            0x0F, 0x80, 0x00, 0x7C, ##      00000                00000
            0x0F, 0x80, 0x00, 0x7C, ##      00000                00000
            0x0F, 0x80, 0x00, 0x7C, ##      00000                00000
            0x0F, 0x80, 0x00, 0x7C, ##      00000                00000
            0x0F, 0x80, 0x00, 0x7C, ##      00000                00000
            0x0F, 0x80, 0x00, 0x7C, ##      00000                00000
            0x0F, 0x80, 0x00, 0x7C, ##      00000                00000
            0x0F, 0x80, 0x00, 0x7C, ##      00000                00000
            0x0F, 0x80, 0x00, 0xF8, ##      00000               00000 
            0x0F, 0x80, 0x00, 0xF8, ##      00000               00000 
            0x0F, 0x80, 0x00, 0xF8, ##      00000               00000 
            0x0F, 0x80, 0x01, 0xF0, ##      00000              00000  
            0x0F, 0x80, 0x01, 0xF0, ##      00000              00000  
            0x0F, 0x80, 0x03, 0xE0, ##      00000             00000   
            0x0F, 0x80, 0x07, 0xC0, ##      00000            00000    
            0x0F, 0x80, 0x1F, 0x80, ##      00000          000000     
            0x0F, 0x80, 0x7E, 0x00, ##      00000        000000       
            0xFF, 0xFF, 0xF8, 0x00, ##  000000000000000000000         
            0xFF, 0xFF, 0xC0, 0x00, ##  000000000000000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 26, 
        'xoffset'  => 2, 
        'xadvance' => 31, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0xFF, 0xF8, 0x00, ##      00000000000000000     
            0x0F, 0xFF, 0xF8, 0x00, ##      00000000000000000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 26, 
        'xoffset'  => 2, 
        'xadvance' => 30, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x1C, 0x00, ##      00000          000    
            0x0F, 0x80, 0x1C, 0x00, ##      00000          000    
            0x0F, 0x80, 0x1C, 0x00, ##      00000          000    
            0x0F, 0x80, 0x1C, 0x00, ##      00000          000    
            0x0F, 0xFF, 0xFC, 0x00, ##      000000000000000000    
            0x0F, 0xFF, 0xFC, 0x00, ##      000000000000000000    
            0x0F, 0x80, 0x1C, 0x00, ##      00000          000    
            0x0F, 0x80, 0x1C, 0x00, ##      00000          000    
            0x0F, 0x80, 0x1C, 0x00, ##      00000          000    
            0x0F, 0x80, 0x1C, 0x00, ##      00000          000    
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0xFF, 0xF8, 0x00, 0x00, ##  0000000000000             
            0xFF, 0xF8, 0x00, 0x00, ##  0000000000000             
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 29, 
        'xoffset'  => 2, 
        'xadvance' => 34, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x3F, 0xFE, 0x00, ##            0000000000000      
            0x01, 0xFF, 0xFF, 0xE0, ##         00000000000000000000  
            0x03, 0xE0, 0x0F, 0xF0, ##        00000         00000000 
            0x07, 0x80, 0x03, 0xF0, ##       0000             000000 
            0x0F, 0x00, 0x01, 0xF0, ##      0000               00000 
            0x1E, 0x00, 0x00, 0xF0, ##     0000                 0000 
            0x3E, 0x00, 0x00, 0xF0, ##    00000                 0000 
            0x3C, 0x00, 0x00, 0x70, ##    0000                   000 
            0x7C, 0x00, 0x00, 0x70, ##   00000                   000 
            0x7C, 0x00, 0x00, 0x00, ##   00000                       
            0x78, 0x00, 0x00, 0x00, ##   0000                        
            0xF8, 0x00, 0x00, 0x00, ##  00000                        
            0xF8, 0x00, 0x00, 0x00, ##  00000                        
            0xF8, 0x00, 0x00, 0x00, ##  00000                        
            0xF8, 0x00, 0x00, 0x00, ##  00000                        
            0xF8, 0x00, 0x00, 0x00, ##  00000                        
            0xF8, 0x00, 0x00, 0x00, ##  00000                        
            0xF8, 0x00, 0x3F, 0xF8, ##  00000             00000000000
            0xF8, 0x00, 0x3F, 0xF8, ##  00000             00000000000
            0xF8, 0x00, 0x00, 0xF8, ##  00000                   00000
            0x78, 0x00, 0x00, 0xF8, ##   0000                   00000
            0x7C, 0x00, 0x00, 0xF8, ##   00000                  00000
            0x7C, 0x00, 0x00, 0xF8, ##   00000                  00000
            0x3C, 0x00, 0x00, 0xF8, ##    0000                  00000
            0x3E, 0x00, 0x00, 0xF8, ##    00000                 00000
            0x1E, 0x00, 0x00, 0xF8, ##     0000                 00000
            0x0F, 0x00, 0x00, 0xF8, ##      0000                00000
            0x07, 0x80, 0x01, 0xF8, ##       0000              000000
            0x03, 0xE0, 0x07, 0xF8, ##        00000          00000000
            0x01, 0xFF, 0xFF, 0xE0, ##         00000000000000000000  
            0x00, 0x3F, 0xFF, 0x00, ##            00000000000000     
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 33, 
        'xoffset'  => 2, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xF0, 0x07, 0xFF, 0x80, ##  000000000000         000000000000
            0xFF, 0xF0, 0x07, 0xFF, 0x80, ##  000000000000         000000000000
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0xFF, 0xFF, 0xF8, 0x00, ##      0000000000000000000000000    
            0x0F, 0xFF, 0xFF, 0xF8, 0x00, ##      0000000000000000000000000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0x0F, 0x80, 0x00, 0xF8, 0x00, ##      00000               00000    
            0xFF, 0xF0, 0x07, 0xFF, 0x80, ##  000000000000         000000000000
            0xFF, 0xF0, 0x07, 0xFF, 0x80, ##  000000000000         000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 19, 
        'xoffset'  => -3, 
        'xadvance' => 18, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xFF, 0xE0, ##        0000000000000
            0x03, 0xFF, 0xE0, ##        0000000000000
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x3E, 0x00, ##            00000    
            0xC0, 0x3E, 0x00, ##  00        00000    
            0xC0, 0x7C, 0x00, ##  00       00000     
            0xE0, 0x7C, 0x00, ##  000      00000     
            0xF0, 0xF8, 0x00, ##  0000    00000      
            0xFF, 0xF0, 0x00, ##  000000000000       
            0x3F, 0xC0, 0x00, ##    00000000         
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 31, 
        'xoffset'  => 2, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xF0, 0x1F, 0xF8, ##  000000000000       0000000000  
            0xFF, 0xF0, 0x1F, 0xF8, ##  000000000000       0000000000  
            0x0F, 0x80, 0x03, 0x80, ##      00000             000      
            0x0F, 0x80, 0x07, 0x00, ##      00000            000       
            0x0F, 0x80, 0x1E, 0x00, ##      00000          0000        
            0x0F, 0x80, 0x3C, 0x00, ##      00000         0000         
            0x0F, 0x80, 0x70, 0x00, ##      00000        000           
            0x0F, 0x80, 0xE0, 0x00, ##      00000       000            
            0x0F, 0x81, 0xC0, 0x00, ##      00000      000             
            0x0F, 0x83, 0x80, 0x00, ##      00000     000              
            0x0F, 0x87, 0x00, 0x00, ##      00000    000               
            0x0F, 0x8C, 0x00, 0x00, ##      00000   00                 
            0x0F, 0x98, 0x00, 0x00, ##      00000  00                  
            0x0F, 0xF0, 0x00, 0x00, ##      00000000                   
            0x0F, 0xF0, 0x00, 0x00, ##      00000000                   
            0x0F, 0xF8, 0x00, 0x00, ##      000000000                  
            0x0F, 0xFC, 0x00, 0x00, ##      0000000000                 
            0x0F, 0xBE, 0x00, 0x00, ##      00000 00000                
            0x0F, 0x9F, 0x00, 0x00, ##      00000  00000               
            0x0F, 0x8F, 0x80, 0x00, ##      00000   00000              
            0x0F, 0x87, 0xC0, 0x00, ##      00000    00000             
            0x0F, 0x83, 0xE0, 0x00, ##      00000     00000            
            0x0F, 0x81, 0xF0, 0x00, ##      00000      00000           
            0x0F, 0x80, 0xFC, 0x00, ##      00000       000000         
            0x0F, 0x80, 0x7E, 0x00, ##      00000        000000        
            0x0F, 0x80, 0x3F, 0x00, ##      00000         000000       
            0x0F, 0x80, 0x1F, 0x80, ##      00000          000000      
            0x0F, 0x80, 0x0F, 0xC0, ##      00000           000000     
            0x0F, 0x80, 0x07, 0xE0, ##      00000            000000    
            0xFF, 0xF0, 0x03, 0xFE, ##  000000000000          000000000
            0xFF, 0xF0, 0x01, 0xFE, ##  000000000000           00000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 25, 
        'xoffset'  => 2, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xF0, 0x00, 0x00, ##  000000000000             
            0xFF, 0xF0, 0x00, 0x00, ##  000000000000             
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x03, 0x80, ##      00000             000
            0x0F, 0x80, 0x03, 0x80, ##      00000             000
            0x0F, 0x80, 0x03, 0x80, ##      00000             000
            0x0F, 0x80, 0x03, 0x80, ##      00000             000
            0x0F, 0x80, 0x03, 0x80, ##      00000             000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 39, 
        'xoffset'  => 2, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xC0, 0x00, 0x01, 0xFE, ##  0000000000                     00000000
            0xFF, 0xC0, 0x00, 0x03, 0xFE, ##  0000000000                    000000000
            0x0F, 0xE0, 0x00, 0x03, 0xF0, ##      0000000                   000000   
            0x0F, 0xE0, 0x00, 0x07, 0xF0, ##      0000000                  0000000   
            0x0F, 0xF0, 0x00, 0x07, 0xF0, ##      00000000                 0000000   
            0x0F, 0xF0, 0x00, 0x0F, 0xF0, ##      00000000                00000000   
            0x0E, 0xF0, 0x00, 0x0D, 0xF0, ##      000 0000                00 00000   
            0x0E, 0xF8, 0x00, 0x1D, 0xF0, ##      000 00000              000 00000   
            0x0E, 0x78, 0x00, 0x19, 0xF0, ##      000  0000              00  00000   
            0x0E, 0x7C, 0x00, 0x39, 0xF0, ##      000  00000            000  00000   
            0x0E, 0x3C, 0x00, 0x31, 0xF0, ##      000   0000            00   00000   
            0x0E, 0x3E, 0x00, 0x71, 0xF0, ##      000   00000          000   00000   
            0x0E, 0x1E, 0x00, 0x61, 0xF0, ##      000    0000          00    00000   
            0x0E, 0x1F, 0x00, 0xE1, 0xF0, ##      000    00000        000    00000   
            0x0E, 0x0F, 0x00, 0xC1, 0xF0, ##      000     0000        00     00000   
            0x0E, 0x0F, 0x81, 0xC1, 0xF0, ##      000     00000      000     00000   
            0x0E, 0x07, 0x81, 0x81, 0xF0, ##      000      0000      00      00000   
            0x0E, 0x07, 0xC3, 0x81, 0xF0, ##      000      00000    000      00000   
            0x0E, 0x03, 0xC3, 0x01, 0xF0, ##      000       0000    00       00000   
            0x0E, 0x03, 0xE7, 0x01, 0xF0, ##      000       00000  000       00000   
            0x0E, 0x01, 0xE6, 0x01, 0xF0, ##      000        0000  00        00000   
            0x0E, 0x01, 0xFE, 0x01, 0xF0, ##      000        00000000        00000   
            0x0E, 0x00, 0xFC, 0x01, 0xF0, ##      000         000000         00000   
            0x0E, 0x00, 0xFC, 0x01, 0xF0, ##      000         000000         00000   
            0x0E, 0x00, 0x78, 0x01, 0xF0, ##      000          0000          00000   
            0x0E, 0x00, 0x78, 0x01, 0xF0, ##      000          0000          00000   
            0x0E, 0x00, 0x78, 0x01, 0xF0, ##      000          0000          00000   
            0x0E, 0x00, 0x00, 0x01, 0xF0, ##      000                        00000   
            0x0E, 0x00, 0x00, 0x01, 0xF0, ##      000                        00000   
            0xFF, 0xE0, 0x00, 0x1F, 0xFE, ##  00000000000                000000000000
            0xFF, 0xE0, 0x00, 0x1F, 0xFE, ##  00000000000                000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 34, 
        'xoffset'  => 2, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x80, 0x01, 0xFF, 0xC0, ##  000000000              00000000000
            0xFF, 0x80, 0x01, 0xFF, 0xC0, ##  000000000              00000000000
            0x0F, 0xC0, 0x00, 0x1C, 0x00, ##      000000                 000    
            0x0F, 0xE0, 0x00, 0x1C, 0x00, ##      0000000                000    
            0x0F, 0xF0, 0x00, 0x1C, 0x00, ##      00000000               000    
            0x0F, 0xF0, 0x00, 0x1C, 0x00, ##      00000000               000    
            0x0E, 0xF8, 0x00, 0x1C, 0x00, ##      000 00000              000    
            0x0E, 0x7C, 0x00, 0x1C, 0x00, ##      000  00000             000    
            0x0E, 0x7E, 0x00, 0x1C, 0x00, ##      000  000000            000    
            0x0E, 0x3E, 0x00, 0x1C, 0x00, ##      000   00000            000    
            0x0E, 0x1F, 0x00, 0x1C, 0x00, ##      000    00000           000    
            0x0E, 0x0F, 0x80, 0x1C, 0x00, ##      000     00000          000    
            0x0E, 0x07, 0xC0, 0x1C, 0x00, ##      000      00000         000    
            0x0E, 0x07, 0xC0, 0x1C, 0x00, ##      000      00000         000    
            0x0E, 0x03, 0xE0, 0x1C, 0x00, ##      000       00000        000    
            0x0E, 0x01, 0xF0, 0x1C, 0x00, ##      000        00000       000    
            0x0E, 0x00, 0xF8, 0x1C, 0x00, ##      000         00000      000    
            0x0E, 0x00, 0xFC, 0x1C, 0x00, ##      000         000000     000    
            0x0E, 0x00, 0x7C, 0x1C, 0x00, ##      000          00000     000    
            0x0E, 0x00, 0x3E, 0x1C, 0x00, ##      000           00000    000    
            0x0E, 0x00, 0x1F, 0x1C, 0x00, ##      000            00000   000    
            0x0E, 0x00, 0x1F, 0x9C, 0x00, ##      000            000000  000    
            0x0E, 0x00, 0x0F, 0x9C, 0x00, ##      000             00000  000    
            0x0E, 0x00, 0x07, 0xDC, 0x00, ##      000              00000 000    
            0x0E, 0x00, 0x03, 0xFC, 0x00, ##      000               00000000    
            0x0E, 0x00, 0x03, 0xFC, 0x00, ##      000               00000000    
            0x0E, 0x00, 0x01, 0xFC, 0x00, ##      000                0000000    
            0x0E, 0x00, 0x00, 0xFC, 0x00, ##      000                 000000    
            0x0E, 0x00, 0x00, 0x7C, 0x00, ##      000                  00000    
            0xFF, 0xE0, 0x00, 0x3C, 0x00, ##  00000000000               0000    
            0xFF, 0xE0, 0x00, 0x3C, 0x00, ##  00000000000               0000    
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 31, 
        'xoffset'  => 2, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0x00, 0x00, ##                 0               
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000          
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000       
            0x03, 0xE0, 0x0F, 0x80, ##        00000         00000      
            0x07, 0x80, 0x03, 0xC0, ##       0000             0000     
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000    
            0x1E, 0x00, 0x00, 0xF0, ##     0000                 0000   
            0x3E, 0x00, 0x00, 0xF8, ##    00000                 00000  
            0x3C, 0x00, 0x00, 0x78, ##    0000                   0000  
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x78, 0x00, 0x00, 0x3C, ##   0000                     0000 
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0x78, 0x00, 0x00, 0x3C, ##   0000                     0000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x3C, 0x00, 0x00, 0x78, ##    0000                   0000  
            0x3E, 0x00, 0x00, 0xF8, ##    00000                 00000  
            0x1E, 0x00, 0x00, 0xF0, ##     0000                 0000   
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000    
            0x07, 0x80, 0x03, 0xC0, ##       0000             0000     
            0x03, 0xE0, 0x0F, 0x80, ##        00000         00000      
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000       
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 25, 
        'xoffset'  => 2, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xE0, 0x00, ##  0000000000000000000      
            0xFF, 0xFF, 0xF8, 0x00, ##  000000000000000000000    
            0x0F, 0x80, 0x7C, 0x00, ##      00000        00000   
            0x0F, 0x80, 0x3E, 0x00, ##      00000         00000  
            0x0F, 0x80, 0x1F, 0x00, ##      00000          00000 
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000
            0x0F, 0x80, 0x1F, 0x00, ##      00000          00000 
            0x0F, 0x80, 0x3E, 0x00, ##      00000         00000  
            0x0F, 0x80, 0x7E, 0x00, ##      00000        000000  
            0x0F, 0xFF, 0xF8, 0x00, ##      00000000000000000    
            0x0F, 0xFF, 0xE0, 0x00, ##      000000000000000      
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0xFF, 0xF8, 0x00, 0x00, ##  0000000000000            
            0xFF, 0xF8, 0x00, 0x00, ##  0000000000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 31, 
        'xoffset'  => 2, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0x00, 0x00, ##                 0               
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000          
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000       
            0x03, 0xE0, 0x0F, 0x80, ##        00000         00000      
            0x07, 0x80, 0x03, 0xC0, ##       0000             0000     
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000    
            0x1E, 0x00, 0x00, 0xF0, ##     0000                 0000   
            0x3E, 0x00, 0x00, 0xF8, ##    00000                 00000  
            0x3C, 0x00, 0x00, 0x78, ##    0000                   0000  
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x78, 0x00, 0x00, 0x3C, ##   0000                     0000 
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0x78, 0x00, 0x00, 0x3C, ##   0000                     0000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x3C, 0x00, 0x00, 0x78, ##    0000                   0000  
            0x3E, 0x00, 0x00, 0xF8, ##    00000                 00000  
            0x1E, 0x00, 0x00, 0xF0, ##     0000                 0000   
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000    
            0x07, 0x80, 0x03, 0xC0, ##       0000             0000     
            0x03, 0xE0, 0x0F, 0x80, ##        00000         00000      
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000       
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000          
            0x00, 0x00, 0xE0, 0x00, ##                  000            
            0x00, 0x00, 0x70, 0x00, ##                   000           
            0x00, 0x00, 0x7C, 0x00, ##                   00000         
            0x00, 0x00, 0x3F, 0xC0, ##                    00000000     
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000     
            0x00, 0x00, 0x0F, 0xC0, ##                      000000     
            0x00, 0x00, 0x01, 0xC0, ##                         000     
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 31, 
        'xoffset'  => 2, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF0, 0x00, ##  00000000000000000000           
            0xFF, 0xFF, 0xFC, 0x00, ##  0000000000000000000000         
            0x0F, 0x80, 0x3F, 0x00, ##      00000         000000       
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000      
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000      
            0x0F, 0x80, 0x07, 0xC0, ##      00000            00000     
            0x0F, 0x80, 0x07, 0xC0, ##      00000            00000     
            0x0F, 0x80, 0x07, 0xC0, ##      00000            00000     
            0x0F, 0x80, 0x07, 0xC0, ##      00000            00000     
            0x0F, 0x80, 0x07, 0xC0, ##      00000            00000     
            0x0F, 0x80, 0x07, 0xC0, ##      00000            00000     
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000      
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000      
            0x0F, 0x80, 0x3F, 0x00, ##      00000         000000       
            0x0F, 0xFF, 0xFE, 0x00, ##      0000000000000000000        
            0x0F, 0xFF, 0xF0, 0x00, ##      0000000000000000           
            0x0F, 0x80, 0xF8, 0x00, ##      00000       00000          
            0x0F, 0x80, 0x7C, 0x00, ##      00000        00000         
            0x0F, 0x80, 0x3C, 0x00, ##      00000         0000         
            0x0F, 0x80, 0x1E, 0x00, ##      00000          0000        
            0x0F, 0x80, 0x1F, 0x00, ##      00000          00000       
            0x0F, 0x80, 0x0F, 0x00, ##      00000           0000       
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000      
            0x0F, 0x80, 0x07, 0x80, ##      00000            0000      
            0x0F, 0x80, 0x07, 0x80, ##      00000            0000      
            0x0F, 0x80, 0x03, 0xC0, ##      00000             0000     
            0x0F, 0x80, 0x03, 0xC0, ##      00000             0000     
            0x0F, 0x80, 0x03, 0xE0, ##      00000             00000    
            0x0F, 0x80, 0x01, 0xE0, ##      00000              0000    
            0xFF, 0xF8, 0x01, 0xFE, ##  0000000000000          00000000
            0xFF, 0xF8, 0x00, 0xFE, ##  0000000000000           0000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 23, 
        'xoffset'  => 4, 
        'xadvance' => 30, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                         
            0x07, 0xFF, 0xE0, ##       00000000000000    
            0x1F, 0xFF, 0xFC, ##     0000000000000000000 
            0x3C, 0x00, 0xFC, ##    0000          000000 
            0x78, 0x00, 0x7C, ##   0000            00000 
            0x70, 0x00, 0x3C, ##   000              0000 
            0xF0, 0x00, 0x1C, ##  0000               000 
            0xF0, 0x00, 0x1C, ##  0000               000 
            0xF0, 0x00, 0x1C, ##  0000               000 
            0xF0, 0x00, 0x00, ##  0000                   
            0xF8, 0x00, 0x00, ##  00000                  
            0xFC, 0x00, 0x00, ##  000000                 
            0x7E, 0x00, 0x00, ##   000000                
            0x7F, 0xC0, 0x00, ##   000000000             
            0x3F, 0xFC, 0x00, ##    000000000000         
            0x1F, 0xFF, 0x80, ##     00000000000000      
            0x07, 0xFF, 0xE0, ##       00000000000000    
            0x00, 0xFF, 0xF0, ##          000000000000   
            0x00, 0x1F, 0xF8, ##             0000000000  
            0x00, 0x03, 0xFC, ##                00000000 
            0x00, 0x00, 0x7E, ##                   000000
            0x00, 0x00, 0x3E, ##                    00000
            0x00, 0x00, 0x1E, ##                     0000
            0x00, 0x00, 0x1E, ##                     0000
            0x60, 0x00, 0x1E, ##   00                0000
            0x60, 0x00, 0x1E, ##   00                0000
            0x60, 0x00, 0x1E, ##   00                0000
            0x70, 0x00, 0x3C, ##   000              0000 
            0x78, 0x00, 0x3C, ##   0000             0000 
            0x7C, 0x00, 0xF8, ##   00000          00000  
            0x7F, 0xFF, 0xF0, ##   0000000000000000000   
            0x0F, 0xFF, 0xC0, ##      00000000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 28, 
        'xoffset'  => 1, 
        'xadvance' => 30, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xF0, ##  0000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xF0, ##  0000000000000000000000000000
            0xE0, 0x0F, 0x00, 0x70, ##  000         0000         000
            0xE0, 0x0F, 0x00, 0x70, ##  000         0000         000
            0xE0, 0x0F, 0x00, 0x70, ##  000         0000         000
            0xE0, 0x0F, 0x00, 0x70, ##  000         0000         000
            0xE0, 0x0F, 0x00, 0x70, ##  000         0000         000
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0xFF, 0xF0, 0x00, ##          000000000000        
            0x00, 0xFF, 0xF0, 0x00, ##          000000000000        
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 32, 
        'xoffset'  => 2, 
        'xadvance' => 36, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xF0, 0x07, 0xFF, ##  000000000000         00000000000
            0xFF, 0xF0, 0x07, 0xFF, ##  000000000000         00000000000
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x80, 0x00, 0xF0, ##      00000               0000    
            0x07, 0x80, 0x00, 0xE0, ##       0000               000     
            0x07, 0x80, 0x00, 0xE0, ##       0000               000     
            0x07, 0xC0, 0x01, 0xE0, ##       00000             0000     
            0x03, 0xF0, 0x07, 0xC0, ##        000000         00000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000        
            0x00, 0x3F, 0xFC, 0x00, ##            000000000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 32, 
        'xoffset'  => 0, 
        'xadvance' => 31, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xE0, 0x01, 0xFF, ##  00000000000            000000000
            0xFF, 0xE0, 0x01, 0xFF, ##  00000000000            000000000
            0x1F, 0x00, 0x00, 0x38, ##     00000                  000   
            0x0F, 0x00, 0x00, 0x30, ##      0000                  00    
            0x0F, 0x80, 0x00, 0x70, ##      00000                000    
            0x0F, 0x80, 0x00, 0x70, ##      00000                000    
            0x07, 0x80, 0x00, 0x60, ##       0000                00     
            0x07, 0xC0, 0x00, 0xE0, ##       00000              000     
            0x07, 0xC0, 0x00, 0xE0, ##       00000              000     
            0x03, 0xE0, 0x01, 0xC0, ##        00000            000      
            0x03, 0xE0, 0x01, 0xC0, ##        00000            000      
            0x01, 0xE0, 0x01, 0x80, ##         0000            00       
            0x01, 0xF0, 0x03, 0x80, ##         00000          000       
            0x01, 0xF0, 0x03, 0x80, ##         00000          000       
            0x00, 0xF8, 0x03, 0x00, ##          00000         00        
            0x00, 0xF8, 0x07, 0x00, ##          00000        000        
            0x00, 0xF8, 0x06, 0x00, ##          00000        00         
            0x00, 0x7C, 0x0E, 0x00, ##           00000      000         
            0x00, 0x7C, 0x0E, 0x00, ##           00000      000         
            0x00, 0x3C, 0x0C, 0x00, ##            0000      00          
            0x00, 0x3E, 0x1C, 0x00, ##            00000    000          
            0x00, 0x3E, 0x18, 0x00, ##            00000    00           
            0x00, 0x1F, 0x38, 0x00, ##             00000  000           
            0x00, 0x1F, 0x38, 0x00, ##             00000  000           
            0x00, 0x0F, 0x30, 0x00, ##              0000  00            
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x07, 0xC0, 0x00, ##               00000              
            0x00, 0x03, 0xC0, 0x00, ##                0000              
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 44, 
        'xoffset'  => 1, 
        'xadvance' => 46, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xE0, 0x07, 0x80, 0x1F, 0xF0, ##  00000000000          0000          000000000
            0xFF, 0xE0, 0x07, 0x80, 0x1F, 0xF0, ##  00000000000          0000          000000000
            0x1E, 0x00, 0x0F, 0x80, 0x03, 0x80, ##     0000             00000             000   
            0x1F, 0x00, 0x0F, 0xC0, 0x03, 0x80, ##     00000            000000            000   
            0x0F, 0x00, 0x0F, 0xC0, 0x03, 0x00, ##      0000            000000            00    
            0x0F, 0x00, 0x1F, 0xC0, 0x03, 0x00, ##      0000           0000000            00    
            0x0F, 0x80, 0x1F, 0xC0, 0x07, 0x00, ##      00000          0000000           000    
            0x0F, 0x80, 0x1B, 0xE0, 0x06, 0x00, ##      00000          00 00000          00     
            0x07, 0x80, 0x19, 0xE0, 0x06, 0x00, ##       0000          00  0000          00     
            0x07, 0x80, 0x39, 0xE0, 0x0E, 0x00, ##       0000         000  0000         000     
            0x07, 0xC0, 0x31, 0xF0, 0x0E, 0x00, ##       00000        00   00000        000     
            0x03, 0xC0, 0x31, 0xF0, 0x0C, 0x00, ##        0000        00   00000        00      
            0x03, 0xC0, 0x70, 0xF0, 0x0C, 0x00, ##        0000       000    0000        00      
            0x03, 0xC0, 0x60, 0xF0, 0x1C, 0x00, ##        0000       00     0000       000      
            0x03, 0xE0, 0x60, 0xF8, 0x18, 0x00, ##        00000      00     00000      00       
            0x01, 0xE0, 0xE0, 0x78, 0x18, 0x00, ##         0000     000      0000      00       
            0x01, 0xE0, 0xE0, 0x78, 0x38, 0x00, ##         0000     000      0000     000       
            0x01, 0xF0, 0xC0, 0x7C, 0x38, 0x00, ##         00000    00       00000    000       
            0x01, 0xF0, 0xC0, 0x3C, 0x30, 0x00, ##         00000    00        0000    00        
            0x00, 0xF1, 0xC0, 0x3C, 0x30, 0x00, ##          0000   000        0000    00        
            0x00, 0xF1, 0x80, 0x3E, 0x70, 0x00, ##          0000   00         00000  000        
            0x00, 0xF9, 0x80, 0x3E, 0x60, 0x00, ##          00000  00         00000  00         
            0x00, 0x7B, 0x80, 0x1E, 0x60, 0x00, ##           0000 000          0000  00         
            0x00, 0x7B, 0x80, 0x1E, 0xE0, 0x00, ##           0000 000          0000 000         
            0x00, 0x7F, 0x00, 0x1F, 0xE0, 0x00, ##           0000000           00000000         
            0x00, 0x7F, 0x00, 0x0F, 0xC0, 0x00, ##           0000000            000000          
            0x00, 0x3F, 0x00, 0x0F, 0xC0, 0x00, ##            000000            000000          
            0x00, 0x3E, 0x00, 0x0F, 0xC0, 0x00, ##            00000             000000          
            0x00, 0x3E, 0x00, 0x0F, 0x80, 0x00, ##            00000             00000           
            0x00, 0x3E, 0x00, 0x07, 0x80, 0x00, ##            00000              0000           
            0x00, 0x1E, 0x00, 0x07, 0x80, 0x00, ##             0000              0000           
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 30, 
        'xoffset'  => 1, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xF8, 0x1F, 0xF8, ##  0000000000000      0000000000 
            0xFF, 0xF8, 0x1F, 0xF8, ##  0000000000000      0000000000 
            0x0F, 0x80, 0x01, 0x80, ##      00000              00     
            0x0F, 0xC0, 0x03, 0x80, ##      000000            000     
            0x07, 0xC0, 0x07, 0x00, ##       00000           000      
            0x03, 0xE0, 0x0E, 0x00, ##        00000         000       
            0x01, 0xF0, 0x0C, 0x00, ##         00000        00        
            0x01, 0xF8, 0x1C, 0x00, ##         000000      000        
            0x00, 0xF8, 0x38, 0x00, ##          00000     000         
            0x00, 0x7C, 0x30, 0x00, ##           00000    00          
            0x00, 0x7E, 0x70, 0x00, ##           000000  000          
            0x00, 0x3E, 0xE0, 0x00, ##            00000 000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000            
            0x00, 0x1F, 0xC0, 0x00, ##             0000000            
            0x00, 0x0F, 0x80, 0x00, ##              00000             
            0x00, 0x07, 0xC0, 0x00, ##               00000            
            0x00, 0x07, 0xE0, 0x00, ##               000000           
            0x00, 0x0F, 0xE0, 0x00, ##              0000000           
            0x00, 0x1D, 0xF0, 0x00, ##             000 00000          
            0x00, 0x39, 0xF8, 0x00, ##            000  000000         
            0x00, 0x30, 0xF8, 0x00, ##            00    00000         
            0x00, 0x60, 0x7C, 0x00, ##           00      00000        
            0x00, 0xE0, 0x7E, 0x00, ##          000      000000       
            0x01, 0xC0, 0x3E, 0x00, ##         000        00000       
            0x01, 0x80, 0x1F, 0x00, ##         00          00000      
            0x03, 0x80, 0x1F, 0x80, ##        000          000000     
            0x07, 0x00, 0x0F, 0x80, ##       000            00000     
            0x06, 0x00, 0x07, 0xC0, ##       00              00000    
            0x0C, 0x00, 0x03, 0xE0, ##      00                00000   
            0xFF, 0xC0, 0x3F, 0xFC, ##  0000000000        000000000000
            0xFF, 0xC0, 0x3F, 0xFC, ##  0000000000        000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 29, 
        'xoffset'  => 0, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xF0, 0x0F, 0xF8, ##  000000000000        000000000
            0xFF, 0xF0, 0x0F, 0xF8, ##  000000000000        000000000
            0x1F, 0x80, 0x01, 0xC0, ##     000000              000   
            0x0F, 0x80, 0x01, 0x80, ##      00000              00    
            0x07, 0xC0, 0x03, 0x80, ##       00000            000    
            0x07, 0xC0, 0x03, 0x00, ##       00000            00     
            0x03, 0xE0, 0x06, 0x00, ##        00000          00      
            0x01, 0xF0, 0x0E, 0x00, ##         00000        000      
            0x01, 0xF0, 0x0C, 0x00, ##         00000        00       
            0x00, 0xF8, 0x1C, 0x00, ##          00000      000       
            0x00, 0xF8, 0x18, 0x00, ##          00000      00        
            0x00, 0x7C, 0x30, 0x00, ##           00000    00         
            0x00, 0x3E, 0x70, 0x00, ##            00000  000         
            0x00, 0x3E, 0x60, 0x00, ##            00000  00          
            0x00, 0x1F, 0xE0, 0x00, ##             00000000          
            0x00, 0x0F, 0xC0, 0x00, ##              000000           
            0x00, 0x0F, 0x80, 0x00, ##              00000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x7F, 0xF8, 0x00, ##           000000000000        
            0x00, 0x7F, 0xF8, 0x00, ##           000000000000        
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 26, 
        'xoffset'  => 2, 
        'xadvance' => 30, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000 
            0xE0, 0x00, 0x1F, 0x00, ##  000                00000  
            0xE0, 0x00, 0x3E, 0x00, ##  000               00000   
            0xE0, 0x00, 0x7E, 0x00, ##  000              000000   
            0xE0, 0x00, 0xFC, 0x00, ##  000             000000    
            0xE0, 0x00, 0xF8, 0x00, ##  000             00000     
            0x00, 0x01, 0xF8, 0x00, ##                 000000     
            0x00, 0x03, 0xF0, 0x00, ##                000000      
            0x00, 0x03, 0xE0, 0x00, ##                00000       
            0x00, 0x07, 0xE0, 0x00, ##               000000       
            0x00, 0x0F, 0xC0, 0x00, ##              000000        
            0x00, 0x0F, 0x80, 0x00, ##              00000         
            0x00, 0x1F, 0x00, 0x00, ##             00000          
            0x00, 0x3F, 0x00, 0x00, ##            000000          
            0x00, 0x7E, 0x00, 0x00, ##           000000           
            0x00, 0x7C, 0x00, 0x00, ##           00000            
            0x00, 0xFC, 0x00, 0x00, ##          000000            
            0x01, 0xF8, 0x00, 0x00, ##         000000             
            0x01, 0xF0, 0x00, 0x00, ##         00000              
            0x03, 0xF0, 0x00, 0x00, ##        000000              
            0x07, 0xE0, 0x00, 0x00, ##       000000               
            0x07, 0xC0, 0x00, 0x00, ##       00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x1F, 0x80, 0x01, 0xC0, ##     000000              000
            0x1F, 0x00, 0x01, 0xC0, ##     00000               000
            0x3E, 0x00, 0x01, 0xC0, ##    00000                000
            0x7E, 0x00, 0x01, 0xC0, ##   000000                000
            0xFC, 0x00, 0x01, 0xC0, ##  000000                 000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 10, 
        'xoffset'  => 4, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xF0, 0x00, ##  0000      
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 14, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0x00, ##  0000          
            0xF0, 0x00, ##  0000          
            0x70, 0x00, ##   000          
            0x70, 0x00, ##   000          
            0x78, 0x00, ##   0000         
            0x38, 0x00, ##    000         
            0x38, 0x00, ##    000         
            0x3C, 0x00, ##    0000        
            0x1C, 0x00, ##     000        
            0x1C, 0x00, ##     000        
            0x1E, 0x00, ##     0000       
            0x0E, 0x00, ##      000       
            0x0E, 0x00, ##      000       
            0x0F, 0x00, ##      0000      
            0x07, 0x00, ##       000      
            0x07, 0x00, ##       000      
            0x07, 0x80, ##       0000     
            0x07, 0x80, ##       0000     
            0x03, 0x80, ##        000     
            0x03, 0x80, ##        000     
            0x03, 0xC0, ##        0000    
            0x01, 0xC0, ##         000    
            0x01, 0xC0, ##         000    
            0x01, 0xE0, ##         0000   
            0x00, 0xE0, ##          000   
            0x00, 0xE0, ##          000   
            0x00, 0xF0, ##          0000  
            0x00, 0x70, ##           000  
            0x00, 0x70, ##           000  
            0x00, 0x78, ##           0000 
            0x00, 0x38, ##            000 
            0x00, 0x38, ##            000 
            0x00, 0x3C, ##            0000
            0x00, 0x3C, ##            0000
            0x00, 0x1C, ##             000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 10, 
        'xoffset'  => 3, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0x03, 0xC0, ##        0000
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 26, 
        'xoffset'  => 5, 
        'xadvance' => 36, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1E, 0x00, 0x00, ##             0000           
            0x00, 0x3F, 0x00, 0x00, ##            000000          
            0x00, 0x7F, 0x80, 0x00, ##           00000000         
            0x00, 0xFF, 0xC0, 0x00, ##          0000000000        
            0x01, 0xFF, 0xE0, 0x00, ##         000000000000       
            0x03, 0xE1, 0xF0, 0x00, ##        00000    00000      
            0x07, 0xC0, 0xF8, 0x00, ##       00000      00000     
            0x0F, 0x80, 0x7C, 0x00, ##      00000        00000    
            0x1E, 0x00, 0x1E, 0x00, ##     0000            0000   
            0x3C, 0x00, 0x0F, 0x00, ##    0000              0000  
            0x78, 0x00, 0x07, 0x80, ##   0000                0000 
            0xE0, 0x00, 0x01, 0xC0, ##  000                    000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 22, 
        'xoffset'  => 0, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 9, 
        'xoffset'  => 4, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0x00, ##  0000     
            0x78, 0x00, ##   0000    
            0x38, 0x00, ##    000    
            0x1C, 0x00, ##     000   
            0x0E, 0x00, ##      000  
            0x0E, 0x00, ##      000  
            0x07, 0x00, ##       000 
            0x03, 0x80, ##        000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                        
            0x0F, 0xFE, 0x00, ##      00000000000       
            0x3F, 0xFF, 0x00, ##    00000000000000      
            0x3C, 0x07, 0x80, ##    0000       0000     
            0x38, 0x03, 0xC0, ##    000         0000    
            0x38, 0x01, 0xC0, ##    000          000    
            0x00, 0x01, 0xE0, ##                 0000   
            0x00, 0x01, 0xE0, ##                 0000   
            0x00, 0x01, 0xE0, ##                 0000   
            0x07, 0xFF, 0xE0, ##       00000000000000   
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x3F, 0x01, 0xE0, ##    000000       0000   
            0x7C, 0x01, 0xE0, ##   00000         0000   
            0xFC, 0x01, 0xE0, ##  000000         0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x03, 0xE0, ##  00000         00000   
            0x7C, 0x03, 0xE0, ##   00000        00000   
            0x7E, 0x07, 0xE0, ##   000000      000000   
            0x3F, 0xFD, 0xFC, ##    000000000000 0000000
            0x0F, 0xF9, 0xFC, ##      000000000  0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 24, 
        'xoffset'  => 2, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFE, 0x00, 0x00, ##  0000000                 
            0xFE, 0x00, 0x00, ##  0000000                 
            0x1E, 0x00, 0x00, ##     0000                 
            0x1E, 0x00, 0x00, ##     0000                 
            0x1E, 0x00, 0x00, ##     0000                 
            0x1E, 0x00, 0x00, ##     0000                 
            0x1E, 0x00, 0x00, ##     0000                 
            0x1E, 0x00, 0x00, ##     0000                 
            0x1E, 0x00, 0x00, ##     0000                 
            0x1E, 0x00, 0x00, ##     0000                 
            0x1E, 0x00, 0x00, ##     0000                 
            0x1E, 0x3F, 0xE0, ##     0000   000000000     
            0x1E, 0xFF, 0xF0, ##     0000 000000000000    
            0x1F, 0xC0, 0xF8, ##     0000000      00000   
            0x1F, 0x80, 0x7C, ##     000000        00000  
            0x1F, 0x00, 0x3E, ##     00000          00000 
            0x1F, 0x00, 0x3E, ##     00000          00000 
            0x1E, 0x00, 0x1E, ##     0000            0000 
            0x1E, 0x00, 0x1F, ##     0000            00000
            0x1E, 0x00, 0x1F, ##     0000            00000
            0x1E, 0x00, 0x1F, ##     0000            00000
            0x1E, 0x00, 0x1F, ##     0000            00000
            0x1E, 0x00, 0x1F, ##     0000            00000
            0x1E, 0x00, 0x1F, ##     0000            00000
            0x1E, 0x00, 0x1F, ##     0000            00000
            0x1E, 0x00, 0x1F, ##     0000            00000
            0x1E, 0x00, 0x3E, ##     0000           00000 
            0x1F, 0x00, 0x3E, ##     00000          00000 
            0x1F, 0x00, 0x3E, ##     00000          00000 
            0x1F, 0x80, 0x7C, ##     000000        00000  
            0x1E, 0xC0, 0xF8, ##     0000 00      00000   
            0xFE, 0xFF, 0xF0, ##  0000000 000000000000    
            0xFE, 0x3F, 0xE0, ##  0000000   000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 20, 
        'xoffset'  => 2, 
        'xadvance' => 24, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0x03, 0xFF, 0x80, ##        00000000000   
            0x0F, 0xFF, 0xE0, ##      000000000000000 
            0x1F, 0x01, 0xE0, ##     00000       0000 
            0x3E, 0x00, 0xE0, ##    00000         000 
            0x3C, 0x00, 0xE0, ##    0000          000 
            0x7C, 0x00, 0x60, ##   00000           00 
            0x78, 0x00, 0x60, ##   0000            00 
            0xF8, 0x00, 0x00, ##  00000               
            0xF8, 0x00, 0x00, ##  00000               
            0xF8, 0x00, 0x00, ##  00000               
            0xF8, 0x00, 0x00, ##  00000               
            0xF8, 0x00, 0x00, ##  00000               
            0xF8, 0x00, 0x00, ##  00000               
            0xF8, 0x00, 0x00, ##  00000               
            0xF8, 0x00, 0x00, ##  00000               
            0x78, 0x00, 0x70, ##   0000            000
            0x7C, 0x00, 0xE0, ##   00000          000 
            0x3C, 0x00, 0xE0, ##    0000          000 
            0x3E, 0x01, 0xE0, ##    00000        0000 
            0x1F, 0x03, 0xC0, ##     00000      0000  
            0x0F, 0xFF, 0x80, ##      0000000000000   
            0x03, 0xFE, 0x00, ##        000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 24, 
        'xoffset'  => 2, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xF0, ##               0000000    
            0x00, 0x07, 0xF0, ##               0000000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x07, 0xF8, 0xF0, ##       00000000   0000    
            0x0F, 0xFE, 0xF0, ##      00000000000 0000    
            0x1F, 0x03, 0xF0, ##     00000      000000    
            0x3E, 0x03, 0xF0, ##    00000       000000    
            0x7C, 0x01, 0xF0, ##   00000         00000    
            0x7C, 0x01, 0xF0, ##   00000         00000    
            0x78, 0x00, 0xF0, ##   0000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0x78, 0x00, 0xF0, ##   0000           0000    
            0x7C, 0x01, 0xF0, ##   00000         00000    
            0x7C, 0x01, 0xF0, ##   00000         00000    
            0x3E, 0x03, 0xF0, ##    00000       000000    
            0x1F, 0x03, 0xF0, ##     00000      000000    
            0x0F, 0xFE, 0xFF, ##      00000000000 00000000
            0x07, 0xF8, 0xFF, ##       00000000   00000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                       
            0x03, 0xFF, 0x00, ##        0000000000     
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0x03, 0xC0, ##     00000      0000   
            0x3E, 0x01, 0xE0, ##    00000        0000  
            0x3C, 0x01, 0xF0, ##    0000         00000 
            0x7C, 0x00, 0xF0, ##   00000          0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xF8, 0x00, 0x00, ##  00000                
            0xF8, 0x00, 0x00, ##  00000                
            0xF8, 0x00, 0x00, ##  00000                
            0xF8, 0x00, 0x00, ##  00000                
            0x78, 0x00, 0x78, ##   0000            0000
            0x7C, 0x00, 0x70, ##   00000           000 
            0x3C, 0x00, 0xF0, ##    0000          0000 
            0x3E, 0x00, 0xE0, ##    00000         000  
            0x1F, 0x01, 0xE0, ##     00000       0000  
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x03, 0xFF, 0x00, ##        0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 17, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xFE, 0x00, ##          0000000  
            0x03, 0xFF, 0x80, ##        00000000000
            0x07, 0xC3, 0x80, ##       00000    000
            0x07, 0x81, 0x80, ##       0000      00
            0x0F, 0x01, 0x80, ##      0000       00
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0xFF, 0xFC, 0x00, ##  00000000000000   
            0xFF, 0xFC, 0x00, ##  00000000000000   
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0xFF, 0xF8, 0x00, ##  0000000000000    
            0xFF, 0xF8, 0x00, ##  0000000000000    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 24, 
        'xoffset'  => 2, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                          
            0x07, 0xF8, 0xFF, ##       00000000   00000000
            0x0F, 0xFE, 0xFF, ##      00000000000 00000000
            0x1F, 0x02, 0xF0, ##     00000      0 0000    
            0x3E, 0x03, 0xF0, ##    00000       000000    
            0x7C, 0x01, 0xF0, ##   00000         00000    
            0x7C, 0x01, 0xF0, ##   00000         00000    
            0x78, 0x00, 0xF0, ##   0000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0x78, 0x00, 0xF0, ##   0000           0000    
            0x7C, 0x01, 0xF0, ##   00000         00000    
            0x7C, 0x01, 0xF0, ##   00000         00000    
            0x3E, 0x03, 0xF0, ##    00000       000000    
            0x1F, 0x03, 0xF0, ##     00000      000000    
            0x0F, 0xFE, 0xF0, ##      00000000000 0000    
            0x07, 0xF8, 0xF0, ##       00000000   0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x38, 0x00, 0xE0, ##    000           000     
            0x38, 0x01, 0xE0, ##    000          0000     
            0x38, 0x01, 0xE0, ##    000          0000     
            0x3C, 0x03, 0xC0, ##    0000        0000      
            0x3F, 0xFF, 0x80, ##    000000000000000       
            0x0F, 0xFE, 0x00, ##      00000000000         
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 25, 
        'xoffset'  => 2, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFE, 0x00, 0x00, 0x00, ##  0000000                  
            0xFE, 0x00, 0x00, 0x00, ##  0000000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x3F, 0xC0, 0x00, ##     0000   00000000       
            0x1E, 0x7F, 0xE0, 0x00, ##     0000  0000000000      
            0x1E, 0xFF, 0xF0, 0x00, ##     0000 000000000000     
            0x1F, 0x80, 0xF0, 0x00, ##     000000       0000     
            0x1F, 0x00, 0xF8, 0x00, ##     00000        00000    
            0x1F, 0x00, 0x78, 0x00, ##     00000         0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0xFF, 0xE3, 0xFF, 0x80, ##  00000000000   00000000000
            0xFF, 0xE3, 0xFF, 0x80, ##  00000000000   00000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##             
            0x1C, 0x00, ##     000     
            0x3E, 0x00, ##    00000    
            0x3E, 0x00, ##    00000    
            0x3E, 0x00, ##    00000    
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0xFE, 0x00, ##  0000000    
            0xFE, 0x00, ##  0000000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0x1E, 0x00, ##     0000    
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 13, 
        'xoffset'  => -4, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##               
            0x00, 0x70, ##           000 
            0x00, 0xF8, ##          00000
            0x00, 0xF8, ##          00000
            0x00, 0xF8, ##          00000
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x07, 0xF8, ##       00000000
            0x07, 0xF8, ##       00000000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0x00, 0x78, ##           0000
            0xC0, 0x78, ##  00       0000
            0xC0, 0xF0, ##  00      0000 
            0xE0, 0xF0, ##  000     0000 
            0xFF, 0xE0, ##  00000000000  
            0xFF, 0xC0, ##  0000000000   
            0x00, 0x00, ##  
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 25, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFE, 0x00, 0x00, 0x00, ##  0000000                  
            0xFE, 0x00, 0x00, 0x00, ##  0000000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x00, 0x00, 0x00, ##     0000                  
            0x1E, 0x03, 0xFF, 0x00, ##     0000       0000000000 
            0x1E, 0x03, 0xFF, 0x00, ##     0000       0000000000 
            0x1E, 0x00, 0xF0, 0x00, ##     0000         0000     
            0x1E, 0x01, 0xE0, 0x00, ##     0000        0000      
            0x1E, 0x03, 0x80, 0x00, ##     0000       000        
            0x1E, 0x07, 0x00, 0x00, ##     0000      000         
            0x1E, 0x0E, 0x00, 0x00, ##     0000     000          
            0x1E, 0x1C, 0x00, 0x00, ##     0000    000           
            0x1E, 0x3C, 0x00, 0x00, ##     0000   0000           
            0x1E, 0xFE, 0x00, 0x00, ##     0000 0000000          
            0x1F, 0xFE, 0x00, 0x00, ##     000000000000          
            0x1F, 0xDF, 0x00, 0x00, ##     0000000 00000         
            0x1F, 0x0F, 0x80, 0x00, ##     00000    00000        
            0x1E, 0x07, 0x80, 0x00, ##     0000      0000        
            0x1E, 0x07, 0xC0, 0x00, ##     0000      00000       
            0x1E, 0x03, 0xE0, 0x00, ##     0000       00000      
            0x1E, 0x01, 0xF0, 0x00, ##     0000        00000     
            0x1E, 0x01, 0xF0, 0x00, ##     0000        00000     
            0x1E, 0x00, 0xF8, 0x00, ##     0000         00000    
            0x1E, 0x00, 0x7C, 0x00, ##     0000          00000   
            0xFF, 0xE3, 0xFF, 0x80, ##  00000000000   00000000000
            0xFF, 0xE3, 0xFF, 0x80, ##  00000000000   00000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 11, 
        'xoffset'  => 1, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x00, ##  00000000   
            0xFF, 0x00, ##  00000000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0x0F, 0x00, ##      0000   
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 39, 
        'xoffset'  => 2, 
        'xadvance' => 42, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0xFE, 0x3F, 0xC0, 0xFF, 0x00, ##  0000000   00000000      00000000       
            0xFE, 0x7F, 0xE1, 0xFF, 0x80, ##  0000000  0000000000    0000000000      
            0xFE, 0xFF, 0xF3, 0xFF, 0xC0, ##  0000000 000000000000  000000000000     
            0x1F, 0x80, 0xF6, 0x03, 0xC0, ##     000000       0000 00       0000     
            0x1F, 0x00, 0xFC, 0x03, 0xE0, ##     00000        000000        00000    
            0x1F, 0x00, 0x7C, 0x01, 0xE0, ##     00000         00000         0000    
            0x1E, 0x00, 0x78, 0x01, 0xE0, ##     0000          0000          0000    
            0x1E, 0x00, 0x78, 0x01, 0xE0, ##     0000          0000          0000    
            0x1E, 0x00, 0x78, 0x01, 0xE0, ##     0000          0000          0000    
            0x1E, 0x00, 0x78, 0x01, 0xE0, ##     0000          0000          0000    
            0x1E, 0x00, 0x78, 0x01, 0xE0, ##     0000          0000          0000    
            0x1E, 0x00, 0x78, 0x01, 0xE0, ##     0000          0000          0000    
            0x1E, 0x00, 0x78, 0x01, 0xE0, ##     0000          0000          0000    
            0x1E, 0x00, 0x78, 0x01, 0xE0, ##     0000          0000          0000    
            0x1E, 0x00, 0x78, 0x01, 0xE0, ##     0000          0000          0000    
            0x1E, 0x00, 0x78, 0x01, 0xE0, ##     0000          0000          0000    
            0x1E, 0x00, 0x78, 0x01, 0xE0, ##     0000          0000          0000    
            0x1E, 0x00, 0x78, 0x01, 0xE0, ##     0000          0000          0000    
            0x1E, 0x00, 0x78, 0x01, 0xE0, ##     0000          0000          0000    
            0x1E, 0x00, 0x78, 0x01, 0xE0, ##     0000          0000          0000    
            0xFF, 0xE7, 0xFF, 0x0F, 0xFE, ##  00000000000  00000000000    00000000000
            0xFF, 0xE7, 0xFF, 0x0F, 0xFE, ##  00000000000  00000000000    00000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 25, 
        'xoffset'  => 2, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##                           
            0xFE, 0x3F, 0xC0, 0x00, ##  0000000   00000000       
            0xFE, 0x7F, 0xE0, 0x00, ##  0000000  0000000000      
            0xFE, 0xFF, 0xF0, 0x00, ##  0000000 000000000000     
            0x1F, 0x80, 0xF0, 0x00, ##     000000       0000     
            0x1F, 0x00, 0xF8, 0x00, ##     00000        00000    
            0x1F, 0x00, 0x78, 0x00, ##     00000         0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0xFF, 0xE3, 0xFF, 0x80, ##  00000000000   00000000000
            0xFF, 0xE3, 0xFF, 0x80, ##  00000000000   00000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x00, ##        0000000000      
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x03, 0xFF, 0x00, ##        0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                          
            0xFF, 0x1F, 0xE0, ##  00000000   00000000     
            0xFF, 0x7F, 0xF0, ##  00000000 00000000000    
            0x0F, 0xC0, 0xF8, ##      000000      00000   
            0x0F, 0xC0, 0x7C, ##      000000       00000  
            0x0F, 0x80, 0x3E, ##      00000         00000 
            0x0F, 0x80, 0x3E, ##      00000         00000 
            0x0F, 0x00, 0x1E, ##      0000           0000 
            0x0F, 0x00, 0x1F, ##      0000           00000
            0x0F, 0x00, 0x1F, ##      0000           00000
            0x0F, 0x00, 0x1F, ##      0000           00000
            0x0F, 0x00, 0x1F, ##      0000           00000
            0x0F, 0x00, 0x1F, ##      0000           00000
            0x0F, 0x00, 0x1F, ##      0000           00000
            0x0F, 0x00, 0x1F, ##      0000           00000
            0x0F, 0x00, 0x1F, ##      0000           00000
            0x0F, 0x00, 0x1E, ##      0000           0000 
            0x0F, 0x80, 0x3E, ##      00000         00000 
            0x0F, 0x80, 0x3E, ##      00000         00000 
            0x0F, 0x80, 0x7C, ##      00000        00000  
            0x0F, 0xC0, 0xF8, ##      000000      00000   
            0x0F, 0x7F, 0xF0, ##      0000 00000000000    
            0x0F, 0x1F, 0xE0, ##      0000   00000000     
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0xFF, 0xE0, 0x00, ##  00000000000             
            0xFF, 0xE0, 0x00, ##  00000000000             
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 24, 
        'xoffset'  => 2, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                          
            0x07, 0xF8, 0xFF, ##       00000000   00000000
            0x0F, 0xFE, 0xFF, ##      00000000000 00000000
            0x1F, 0x02, 0xF0, ##     00000      0 0000    
            0x3E, 0x03, 0xF0, ##    00000       000000    
            0x7C, 0x01, 0xF0, ##   00000         00000    
            0x7C, 0x01, 0xF0, ##   00000         00000    
            0x78, 0x00, 0xF0, ##   0000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0xF8, 0x00, 0xF0, ##  00000           0000    
            0x78, 0x00, 0xF0, ##   0000           0000    
            0x7C, 0x01, 0xF0, ##   00000         00000    
            0x7C, 0x01, 0xF0, ##   00000         00000    
            0x3E, 0x03, 0xF0, ##    00000       000000    
            0x1F, 0x03, 0xF0, ##     00000      000000    
            0x0F, 0xFE, 0xF0, ##      00000000000 0000    
            0x07, 0xF8, 0xF0, ##       00000000   0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x00, 0xF0, ##                  0000    
            0x00, 0x07, 0xFF, ##               00000000000
            0x00, 0x07, 0xFF, ##               00000000000
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 19, 
        'xoffset'  => 2, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                     
            0xFE, 0x3F, 0xE0, ##  0000000   000000000
            0xFE, 0x7F, 0xE0, ##  0000000  0000000000
            0xFE, 0xFF, 0xE0, ##  0000000 00000000000
            0x1F, 0xC0, 0xE0, ##     0000000      000
            0x1F, 0x80, 0x60, ##     000000        00
            0x1F, 0x00, 0x60, ##     00000         00
            0x1F, 0x00, 0x00, ##     00000           
            0x1E, 0x00, 0x00, ##     0000            
            0x1E, 0x00, 0x00, ##     0000            
            0x1E, 0x00, 0x00, ##     0000            
            0x1E, 0x00, 0x00, ##     0000            
            0x1E, 0x00, 0x00, ##     0000            
            0x1E, 0x00, 0x00, ##     0000            
            0x1E, 0x00, 0x00, ##     0000            
            0x1E, 0x00, 0x00, ##     0000            
            0x1E, 0x00, 0x00, ##     0000            
            0x1E, 0x00, 0x00, ##     0000            
            0x1E, 0x00, 0x00, ##     0000            
            0x1E, 0x00, 0x00, ##     0000            
            0x1E, 0x00, 0x00, ##     0000            
            0xFF, 0xF0, 0x00, ##  000000000000       
            0xFF, 0xF0, 0x00, ##  000000000000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 17, 
        'xoffset'  => 2, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                   
            0x1F, 0xFC, 0x00, ##     00000000000   
            0x3F, 0xFF, 0x00, ##    00000000000000 
            0x78, 0x0F, 0x00, ##   0000       0000 
            0xF0, 0x07, 0x00, ##  0000         000 
            0xF0, 0x03, 0x00, ##  0000          00 
            0xF0, 0x03, 0x00, ##  0000          00 
            0xF0, 0x00, 0x00, ##  0000             
            0xF8, 0x00, 0x00, ##  00000            
            0x7F, 0x00, 0x00, ##   0000000         
            0x7F, 0xE0, 0x00, ##   0000000000      
            0x1F, 0xF8, 0x00, ##     0000000000    
            0x07, 0xFE, 0x00, ##       0000000000  
            0x00, 0xFF, 0x00, ##          00000000 
            0x00, 0x3F, 0x80, ##            0000000
            0x00, 0x0F, 0x80, ##              00000
            0x00, 0x07, 0x80, ##               0000
            0xC0, 0x07, 0x80, ##  00           0000
            0xC0, 0x07, 0x80, ##  00           0000
            0xE0, 0x07, 0x00, ##  000          000 
            0xF0, 0x0F, 0x00, ##  0000        0000 
            0xFF, 0xFE, 0x00, ##  000000000000000  
            0x3F, 0xF8, 0x00, ##    00000000000    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 17, 
        'xoffset'  => 1, 
        'xadvance' => 19, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0xFF, 0xFE, 0x00, ##  000000000000000  
            0xFF, 0xFE, 0x00, ##  000000000000000  
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x00, 0x00, ##      0000         
            0x0F, 0x03, 0x80, ##      0000      000
            0x0F, 0x03, 0x80, ##      0000      000
            0x07, 0x07, 0x80, ##       000     0000
            0x07, 0xFF, 0x00, ##       00000000000 
            0x03, 0xFE, 0x00, ##        000000000  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 25, 
        'xoffset'  => 2, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFE, 0x03, 0xF8, 0x00, ##  0000000       0000000    
            0xFE, 0x03, 0xF8, 0x00, ##  0000000       0000000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0xF8, 0x00, ##     0000         00000    
            0x1F, 0x00, 0xF8, 0x00, ##     00000        00000    
            0x0F, 0x01, 0xF8, 0x00, ##      0000       000000    
            0x0F, 0x83, 0x78, 0x00, ##      00000     00 0000    
            0x07, 0xFE, 0x7F, 0x80, ##       0000000000  00000000
            0x03, 0xFC, 0x7F, 0x80, ##        00000000   00000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 24, 
        'xoffset'  => 0, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xC0, 0xFF, ##  0000000000      00000000
            0xFF, 0xC0, 0xFF, ##  0000000000      00000000
            0x1E, 0x00, 0x18, ##     0000            00   
            0x1E, 0x00, 0x18, ##     0000            00   
            0x1F, 0x00, 0x38, ##     00000          000   
            0x0F, 0x00, 0x30, ##      0000          00    
            0x0F, 0x00, 0x70, ##      0000         000    
            0x07, 0x80, 0x60, ##       0000        00     
            0x07, 0x80, 0xE0, ##       0000       000     
            0x07, 0xC0, 0xE0, ##       00000      000     
            0x03, 0xC0, 0xC0, ##        0000      00      
            0x03, 0xC1, 0xC0, ##        0000     000      
            0x01, 0xE1, 0x80, ##         0000    00       
            0x01, 0xE3, 0x80, ##         0000   000       
            0x01, 0xF3, 0x80, ##         00000  000       
            0x00, 0xF3, 0x00, ##          0000  00        
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x3E, 0x00, ##            00000         
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 36, 
        'xoffset'  => 1, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xC0, 0x70, 0x0F, 0xF0, ##  0000000000       000        00000000
            0xFF, 0xC0, 0x78, 0x0F, 0xF0, ##  0000000000       0000       00000000
            0x1E, 0x00, 0x78, 0x01, 0x80, ##     0000          0000          00   
            0x1E, 0x00, 0xF8, 0x01, 0x80, ##     0000         00000          00   
            0x1E, 0x00, 0xFC, 0x03, 0x80, ##     0000         000000        000   
            0x0F, 0x01, 0xFC, 0x03, 0x00, ##      0000       0000000        00    
            0x0F, 0x01, 0xFC, 0x03, 0x00, ##      0000       0000000        00    
            0x0F, 0x01, 0x9E, 0x07, 0x00, ##      0000       00  0000      000    
            0x07, 0x83, 0x9E, 0x06, 0x00, ##       0000     000  0000      00     
            0x07, 0x83, 0x1E, 0x06, 0x00, ##       0000     00   0000      00     
            0x07, 0x83, 0x0F, 0x0E, 0x00, ##       0000     00    0000    000     
            0x03, 0xC7, 0x0F, 0x0C, 0x00, ##        0000   000    0000    00      
            0x03, 0xC6, 0x0F, 0x8C, 0x00, ##        0000   00     00000   00      
            0x03, 0xC6, 0x07, 0x9C, 0x00, ##        0000   00      0000  000      
            0x01, 0xEE, 0x07, 0x98, 0x00, ##         0000 000      0000  00       
            0x01, 0xEC, 0x07, 0xD8, 0x00, ##         0000 00       00000 00       
            0x01, 0xEC, 0x03, 0xF8, 0x00, ##         0000 00        0000000       
            0x00, 0xFC, 0x03, 0xF0, 0x00, ##          000000        000000        
            0x00, 0xF8, 0x03, 0xF0, 0x00, ##          00000         000000        
            0x00, 0xF8, 0x01, 0xF0, 0x00, ##          00000          00000        
            0x00, 0x78, 0x01, 0xE0, 0x00, ##           0000          0000         
            0x00, 0x70, 0x01, 0xE0, 0x00, ##           000           0000         
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 23, 
        'xoffset'  => 1, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xC7, 0xFC, ##  0000000000   000000000 
            0xFF, 0xC7, 0xFC, ##  0000000000   000000000 
            0x0F, 0x00, 0xE0, ##      0000        000    
            0x0F, 0x01, 0xC0, ##      0000       000     
            0x07, 0x83, 0x80, ##       0000     000      
            0x03, 0xC3, 0x00, ##        0000    00       
            0x03, 0xC7, 0x00, ##        0000   000       
            0x01, 0xEE, 0x00, ##         0000 000        
            0x00, 0xFC, 0x00, ##          000000         
            0x00, 0xFC, 0x00, ##          000000         
            0x00, 0x78, 0x00, ##           0000          
            0x00, 0x3C, 0x00, ##            0000         
            0x00, 0x7E, 0x00, ##           000000        
            0x00, 0xFE, 0x00, ##          0000000        
            0x00, 0xCF, 0x00, ##          00  0000       
            0x01, 0x8F, 0x80, ##         00   00000      
            0x03, 0x87, 0x80, ##        000    0000      
            0x07, 0x03, 0xC0, ##       000      0000     
            0x06, 0x03, 0xE0, ##       00       00000    
            0x0E, 0x01, 0xF0, ##      000        00000   
            0x7F, 0x87, 0xFE, ##   00000000    0000000000
            0x7F, 0x87, 0xFE, ##   00000000    0000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 24, 
        'xoffset'  => 0, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xC0, 0xFF, ##  0000000000      00000000
            0xFF, 0xC0, 0xFF, ##  0000000000      00000000
            0x1E, 0x00, 0x18, ##     0000            00   
            0x1E, 0x00, 0x18, ##     0000            00   
            0x1F, 0x00, 0x38, ##     00000          000   
            0x0F, 0x00, 0x30, ##      0000          00    
            0x0F, 0x00, 0x70, ##      0000         000    
            0x07, 0x80, 0x60, ##       0000        00     
            0x07, 0x80, 0x60, ##       0000        00     
            0x03, 0xC0, 0xE0, ##        0000      000     
            0x03, 0xC0, 0xC0, ##        0000      00      
            0x03, 0xC1, 0xC0, ##        0000     000      
            0x01, 0xE1, 0x80, ##         0000    00       
            0x01, 0xE3, 0x80, ##         0000   000       
            0x00, 0xF3, 0x80, ##          0000  000       
            0x00, 0xF3, 0x00, ##          0000  00        
            0x00, 0xF7, 0x00, ##          0000 000        
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x3E, 0x00, ##            00000         
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x18, 0x00, ##             00           
            0x00, 0x38, 0x00, ##            000           
            0x00, 0x30, 0x00, ##            00            
            0x00, 0x30, 0x00, ##            00            
            0x00, 0x70, 0x00, ##           000            
            0x60, 0x60, 0x00, ##   00      00             
            0x70, 0xE0, 0x00, ##   000    000             
            0x7F, 0xC0, 0x00, ##   000000000              
            0x7F, 0x80, 0x00, ##   00000000               
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 19, 
        'xoffset'  => 2, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xC0, 0x07, 0xC0, ##  00           00000 
            0xC0, 0x07, 0x80, ##  00           0000  
            0xC0, 0x0F, 0x00, ##  00          0000   
            0xC0, 0x1F, 0x00, ##  00         00000   
            0x00, 0x3E, 0x00, ##            00000    
            0x00, 0x7C, 0x00, ##           00000     
            0x00, 0x78, 0x00, ##           0000      
            0x00, 0xF0, 0x00, ##          0000       
            0x01, 0xF0, 0x00, ##         00000       
            0x03, 0xE0, 0x00, ##        00000        
            0x03, 0xC0, 0x00, ##        0000         
            0x07, 0x80, 0x00, ##       0000          
            0x0F, 0x80, 0x00, ##      00000          
            0x1F, 0x00, 0x00, ##     00000           
            0x3E, 0x00, 0x60, ##    00000          00
            0x3C, 0x00, 0x60, ##    0000           00
            0x78, 0x00, 0x60, ##   0000            00
            0xF8, 0x00, 0x60, ##  00000            00
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 16, 
        'xoffset'  => 6, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x3F, ##            000000
            0x00, 0xFF, ##          00000000
            0x01, 0xF0, ##         00000    
            0x01, 0xE0, ##         0000     
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x07, 0x80, ##       0000       
            0x0F, 0x00, ##      0000        
            0xFE, 0x00, ##  0000000         
            0xFE, 0x00, ##  0000000         
            0x0F, 0x00, ##      0000        
            0x07, 0x80, ##       0000       
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x03, 0xC0, ##        0000      
            0x01, 0xE0, ##         0000     
            0x01, 0xE0, ##         0000     
            0x00, 0xFF, ##          00000000
            0x00, 0x3F, ##            000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 3, 
        'xoffset'  => 6, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 17, 
        'xoffset'  => 5, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFC, 0x00, 0x00, ##  000000           
            0xFF, 0x00, 0x00, ##  00000000         
            0x0F, 0x80, 0x00, ##      00000        
            0x07, 0x80, 0x00, ##       0000        
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x01, 0xE0, 0x00, ##         0000      
            0x00, 0xF0, 0x00, ##          0000     
            0x00, 0x7F, 0x80, ##           00000000
            0x00, 0x7F, 0x80, ##           00000000
            0x00, 0xF0, 0x00, ##          0000     
            0x01, 0xE0, 0x00, ##         0000      
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x03, 0xC0, 0x00, ##        0000       
            0x07, 0x80, 0x00, ##       0000        
            0x07, 0x80, 0x00, ##       0000        
            0xFF, 0x00, 0x00, ##  00000000         
            0xFC, 0x00, 0x00, ##  000000           
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 27, 
        'xoffset'  => 5, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x07, 0xE0, 0x00, 0x20, ##       000000               0
            0x3F, 0xFC, 0x00, 0x60, ##    000000000000           00
            0x7F, 0xFF, 0x81, 0xE0, ##   0000000000000000      0000
            0xF0, 0x3F, 0xFF, 0xC0, ##  0000      0000000000000000 
            0xC0, 0x07, 0xFF, 0x80, ##  00           000000000000  
            0x80, 0x00, 0xFC, 0x00, ##  0               000000     
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '160' => {    # ' '
        'width'    => 0, 
        'xoffset'  => 0, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
        ], 
    }, 
    '161' => {    # '¡'
        'width'    => 5, 
        'xoffset'  => 6, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x20, ##    0  
            0xF0, ##  0000 
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0x20, ##    0  
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x00, ##       
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0x70, ##   000 
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '162' => {    # '¢'
        'width'    => 20, 
        'xoffset'  => 3, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x30, 0x00, ##            00        
            0x00, 0x30, 0x00, ##            00        
            0x00, 0x30, 0x00, ##            00        
            0x00, 0x30, 0x00, ##            00        
            0x00, 0x30, 0x00, ##            00        
            0x00, 0x30, 0x00, ##            00        
            0x03, 0xFF, 0x00, ##        0000000000    
            0x07, 0xFF, 0xE0, ##       00000000000000 
            0x1F, 0x33, 0xE0, ##     00000  00  00000 
            0x3E, 0x31, 0xE0, ##    00000   00   0000 
            0x3C, 0x30, 0xE0, ##    0000    00    000 
            0x7C, 0x30, 0xE0, ##   00000    00    000 
            0x7C, 0x30, 0x60, ##   00000    00     00 
            0xF8, 0x30, 0x60, ##  00000     00     00 
            0xF8, 0x30, 0x00, ##  00000     00        
            0xF8, 0x30, 0x00, ##  00000     00        
            0xF8, 0x30, 0x00, ##  00000     00        
            0xF8, 0x30, 0x00, ##  00000     00        
            0xF8, 0x30, 0x00, ##  00000     00        
            0xF8, 0x30, 0x00, ##  00000     00        
            0xF8, 0x30, 0x00, ##  00000     00        
            0xF8, 0x30, 0x00, ##  00000     00        
            0x7C, 0x30, 0x70, ##   00000    00     000
            0x7C, 0x30, 0xE0, ##   00000    00    000 
            0x3C, 0x30, 0xE0, ##    0000    00    000 
            0x3E, 0x31, 0xC0, ##    00000   00   000  
            0x1F, 0x33, 0xC0, ##     00000  00  0000  
            0x07, 0xFF, 0x80, ##       000000000000   
            0x03, 0xFE, 0x00, ##        000000000     
            0x00, 0x30, 0x00, ##            00        
            0x00, 0x30, 0x00, ##            00        
            0x00, 0x30, 0x00, ##            00        
            0x00, 0x30, 0x00, ##            00        
            0x00, 0x30, 0x00, ##            00        
            0x00, 0x30, 0x00, ##            00        
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '163' => {    # '£'
        'width'    => 21, 
        'xoffset'  => 3, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                       
            0x00, 0xFF, 0xF8, ##          0000000000000
            0x01, 0xFF, 0xF8, ##         00000000000000
            0x03, 0xC0, 0x78, ##        0000       0000
            0x07, 0x80, 0x38, ##       0000         000
            0x07, 0x80, 0x38, ##       0000         000
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0xFF, 0xFF, 0x80, ##  00000000000000000    
            0xFF, 0xFF, 0x80, ##  00000000000000000    
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x00, ##      0000             
            0x0F, 0x00, 0x18, ##      0000           00
            0x0F, 0x00, 0x18, ##      0000           00
            0x0F, 0x00, 0x18, ##      0000           00
            0x0F, 0x00, 0x18, ##      0000           00
            0x0F, 0x00, 0x18, ##      0000           00
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '164' => {    # '¤'
        'width'    => 24, 
        'xoffset'  => 2, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x20, 0x00, 0x00, ##    0                     
            0x60, 0x00, 0x0E, ##   00                 000 
            0x70, 0x00, 0x1E, ##   000               0000 
            0x38, 0x7E, 0x3C, ##    000    000000   0000  
            0x1D, 0xFF, 0xF8, ##     000 00000000000000   
            0x0F, 0xFF, 0xF0, ##      0000000000000000    
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x1E, 0x00, 0x70, ##     0000          000    
            0x1C, 0x00, 0x38, ##     000            000   
            0x1C, 0x00, 0x38, ##     000            000   
            0x1C, 0x00, 0x38, ##     000            000   
            0x1C, 0x00, 0x38, ##     000            000   
            0x1C, 0x00, 0x38, ##     000            000   
            0x0E, 0x00, 0x70, ##      000          000    
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x0F, 0xFF, 0xF0, ##      0000000000000000    
            0x1D, 0xFF, 0xB8, ##     000 0000000000 000   
            0x38, 0x7E, 0x1C, ##    000    000000    000  
            0x70, 0x00, 0x0F, ##   000                0000
            0x60, 0x00, 0x06, ##   00                  00 
            0x20, 0x00, 0x00, ##    0                     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '165' => {    # '¥'
        'width'    => 28, 
        'xoffset'  => 0, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xF0, 0x1F, 0xF0, ##  000000000000       000000000
            0xFF, 0xF0, 0x1F, 0xF0, ##  000000000000       000000000
            0x0F, 0x00, 0x03, 0x80, ##      0000              000   
            0x0F, 0x80, 0x07, 0x00, ##      00000            000    
            0x07, 0xC0, 0x07, 0x00, ##       00000           000    
            0x07, 0xC0, 0x0E, 0x00, ##       00000          000     
            0x03, 0xE0, 0x0C, 0x00, ##        00000         00      
            0x01, 0xE0, 0x1C, 0x00, ##         0000        000      
            0x01, 0xF0, 0x38, 0x00, ##         00000      000       
            0x00, 0xF0, 0x38, 0x00, ##          0000      000       
            0x00, 0xF8, 0x70, 0x00, ##          00000    000        
            0x00, 0x7C, 0x60, 0x00, ##           00000   00         
            0x0F, 0xFC, 0xFF, 0x80, ##      0000000000  000000000   
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000   
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x1F, 0x80, 0x00, ##             000000           
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000   
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000   
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0x0F, 0x00, 0x00, ##              0000            
            0x00, 0xFF, 0xF0, 0x00, ##          000000000000        
            0x00, 0xFF, 0xF0, 0x00, ##          000000000000        
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '166' => {    # '¦'
        'width'    => 3, 
        'xoffset'  => 6, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0x00, ##     
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '167' => {    # '§'
        'width'    => 17, 
        'xoffset'  => 2, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                   
            0x0F, 0xFE, 0x00, ##      00000000000  
            0x1F, 0xFE, 0x00, ##     000000000000  
            0x3C, 0x0E, 0x00, ##    0000      000  
            0x78, 0x06, 0x00, ##   0000        00  
            0x78, 0x06, 0x00, ##   0000        00  
            0x78, 0x00, 0x00, ##   0000            
            0x78, 0x00, 0x00, ##   0000            
            0x7C, 0x00, 0x00, ##   00000           
            0x3E, 0x00, 0x00, ##    00000          
            0x1F, 0x80, 0x00, ##     000000        
            0x0F, 0xC0, 0x00, ##      000000       
            0x1F, 0xF0, 0x00, ##     000000000     
            0x70, 0xFC, 0x00, ##   000    000000   
            0x60, 0x7E, 0x00, ##   00      000000  
            0xE0, 0x1F, 0x00, ##  000        00000 
            0xE0, 0x0F, 0x00, ##  000         0000 
            0xE0, 0x07, 0x80, ##  000          0000
            0xF0, 0x03, 0x80, ##  0000          000
            0x78, 0x03, 0x80, ##   0000         000
            0x7C, 0x03, 0x80, ##   00000        000
            0x3E, 0x03, 0x00, ##    00000       00 
            0x1F, 0x87, 0x00, ##     000000    000 
            0x07, 0xFE, 0x00, ##       0000000000  
            0x03, 0xF8, 0x00, ##        0000000    
            0x00, 0xFC, 0x00, ##          000000   
            0x00, 0x7E, 0x00, ##           000000  
            0x00, 0x1E, 0x00, ##             0000  
            0x00, 0x1F, 0x00, ##             00000 
            0x00, 0x0F, 0x00, ##              0000 
            0x00, 0x0F, 0x00, ##              0000 
            0x60, 0x0F, 0x00, ##   00         0000 
            0x60, 0x1E, 0x00, ##   00        0000  
            0x78, 0x3E, 0x00, ##   0000     00000  
            0x7F, 0xFC, 0x00, ##   0000000000000   
            0x1F, 0xF0, 0x00, ##     000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '168' => {    # '¨'
        'width'    => 13, 
        'xoffset'  => 4, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x70, 0x70, ##   000     000 
            0xF8, 0xF8, ##  00000   00000
            0xF8, 0xF8, ##  00000   00000
            0xF8, 0xF8, ##  00000   00000
            0x70, 0x70, ##   000     000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '169' => {    # '©'
        'width'    => 31, 
        'xoffset'  => 6, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xE0, 0x00, ##              0000000            
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000         
            0x01, 0xF0, 0x1F, 0x00, ##         00000       00000       
            0x03, 0x80, 0x03, 0x80, ##        000             000      
            0x07, 0x00, 0x01, 0xC0, ##       000               000     
            0x0C, 0x00, 0x00, 0x60, ##      00                   00    
            0x18, 0x07, 0xE0, 0x30, ##     00        000000       00   
            0x38, 0x1F, 0xFC, 0x38, ##    000      00000000000    000  
            0x30, 0x7C, 0x3E, 0x18, ##    00     00000    00000    00  
            0x60, 0x78, 0x0E, 0x0C, ##   00      0000       000     00 
            0x60, 0xF0, 0x0E, 0x0C, ##   00     0000        000     00 
            0xE0, 0xF0, 0x06, 0x0C, ##  000     0000         00     00 
            0xC1, 0xE0, 0x00, 0x06, ##  00     0000                  00
            0xC1, 0xE0, 0x00, 0x06, ##  00     0000                  00
            0xC1, 0xE0, 0x00, 0x06, ##  00     0000                  00
            0xC1, 0xE0, 0x00, 0x06, ##  00     0000                  00
            0xC1, 0xE0, 0x00, 0x06, ##  00     0000                  00
            0xC1, 0xE0, 0x00, 0x06, ##  00     0000                  00
            0xC1, 0xE0, 0x00, 0x06, ##  00     0000                  00
            0xE0, 0xE0, 0x06, 0x0E, ##  000     000          00     000
            0x60, 0xF0, 0x0E, 0x0C, ##   00     0000        000     00 
            0x60, 0x70, 0x0C, 0x0C, ##   00      000        00      00 
            0x30, 0x7C, 0x3C, 0x18, ##    00     00000    0000     00  
            0x38, 0x1F, 0xF8, 0x38, ##    000      0000000000     000  
            0x18, 0x07, 0xE0, 0x30, ##     00        000000       00   
            0x0C, 0x00, 0x00, 0x60, ##      00                   00    
            0x07, 0x00, 0x01, 0xC0, ##       000               000     
            0x03, 0x80, 0x03, 0x80, ##        000             000      
            0x01, 0xF0, 0x1F, 0x00, ##         00000       00000       
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000         
            0x00, 0x1F, 0xF0, 0x00, ##             000000000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '170' => {    # 'ª'
        'width'    => 17, 
        'xoffset'  => 3, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x1F, 0xE0, 0x00, ##     00000000      
            0x78, 0x38, 0x00, ##   0000     000    
            0x60, 0x1C, 0x00, ##   00        000   
            0x60, 0x0C, 0x00, ##   00         00   
            0x00, 0x0E, 0x00, ##              000  
            0x00, 0x0E, 0x00, ##              000  
            0x0F, 0xFE, 0x00, ##      00000000000  
            0x38, 0x0E, 0x00, ##    000       000  
            0x70, 0x0E, 0x00, ##   000        000  
            0xE0, 0x0E, 0x00, ##  000         000  
            0xE0, 0x0E, 0x00, ##  000         000  
            0xE0, 0x0E, 0x00, ##  000         000  
            0xF0, 0x1E, 0x00, ##  0000       0000  
            0x78, 0x3E, 0x00, ##   0000     00000  
            0x3F, 0xEF, 0x80, ##    000000000 00000
            0x1F, 0xCF, 0x80, ##     0000000  00000
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x7F, 0xFF, 0x00, ##   000000000000000 
            0x7F, 0xFF, 0x00, ##   000000000000000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '171' => {    # '«'
        'width'    => 19, 
        'xoffset'  => 3, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x40, 0x20, ##           0        0
            0x00, 0xC0, 0x60, ##          00       00
            0x01, 0xC0, 0xE0, ##         000      000
            0x03, 0x81, 0xC0, ##        000      000 
            0x07, 0x03, 0x80, ##       000      000  
            0x1E, 0x0F, 0x00, ##     0000     0000   
            0x3C, 0x1E, 0x00, ##    0000     0000    
            0x78, 0x3C, 0x00, ##   0000     0000     
            0xF0, 0x7C, 0x00, ##  0000     00000     
            0xF0, 0x78, 0x00, ##  0000     0000      
            0xF8, 0x7C, 0x00, ##  00000    00000     
            0x78, 0x3E, 0x00, ##   0000     00000    
            0x1C, 0x0F, 0x00, ##     000      0000   
            0x0E, 0x07, 0x00, ##      000      000   
            0x07, 0x03, 0x80, ##       000      000  
            0x03, 0x81, 0xC0, ##        000      000 
            0x01, 0xC0, 0xE0, ##         000      000
            0x00, 0xC0, 0x60, ##          00       00
            0x00, 0x40, 0x20, ##           0        0
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '172' => {    # '¬'
        'width'    => 26, 
        'xoffset'  => 5, 
        'xadvance' => 36, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0x00, 0x00, 0x01, 0xC0, ##                         000
            0x00, 0x00, 0x01, 0xC0, ##                         000
            0x00, 0x00, 0x01, 0xC0, ##                         000
            0x00, 0x00, 0x01, 0xC0, ##                         000
            0x00, 0x00, 0x01, 0xC0, ##                         000
            0x00, 0x00, 0x01, 0xC0, ##                         000
            0x00, 0x00, 0x01, 0xC0, ##                         000
            0x00, 0x00, 0x01, 0xC0, ##                         000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '173' => {    # '­'
        'width'    => 11, 
        'xoffset'  => 2, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '174' => {    # '®'
        'width'    => 31, 
        'xoffset'  => 6, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xE0, 0x00, ##              0000000            
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000         
            0x01, 0xF0, 0x1F, 0x00, ##         00000       00000       
            0x03, 0x80, 0x03, 0x80, ##        000             000      
            0x07, 0x00, 0x01, 0xC0, ##       000               000     
            0x0C, 0x00, 0x00, 0x60, ##      00                   00    
            0x18, 0xFF, 0xE0, 0x30, ##     00   00000000000       00   
            0x38, 0xFF, 0xF8, 0x38, ##    000   0000000000000     000  
            0x30, 0x38, 0x3C, 0x18, ##    00      000     0000     00  
            0x60, 0x38, 0x1C, 0x0C, ##   00       000      000      00 
            0x60, 0x38, 0x1C, 0x0C, ##   00       000      000      00 
            0xE0, 0x38, 0x1C, 0x0C, ##  000       000      000      00 
            0xC0, 0x38, 0x1C, 0x06, ##  00        000      000       00
            0xC0, 0x38, 0x38, 0x06, ##  00        000     000        00
            0xC0, 0x3F, 0xE0, 0x06, ##  00        000000000          00
            0xC0, 0x3F, 0xE0, 0x06, ##  00        000000000          00
            0xC0, 0x38, 0xF0, 0x06, ##  00        000   0000         00
            0xC0, 0x38, 0x78, 0x06, ##  00        000    0000        00
            0xC0, 0x38, 0x38, 0x06, ##  00        000     000        00
            0xE0, 0x38, 0x3C, 0x0E, ##  000       000     0000      000
            0x60, 0x38, 0x1C, 0x0C, ##   00       000      000      00 
            0x60, 0x38, 0x1E, 0x0C, ##   00       000      0000     00 
            0x30, 0xFE, 0x0F, 0x98, ##    00    0000000     00000  00  
            0x38, 0xFE, 0x0F, 0xB8, ##    000   0000000     00000 000  
            0x18, 0x00, 0x00, 0x30, ##     00                     00   
            0x0C, 0x00, 0x00, 0x60, ##      00                   00    
            0x07, 0x00, 0x01, 0xC0, ##       000               000     
            0x03, 0x80, 0x03, 0x80, ##        000             000      
            0x01, 0xF0, 0x1F, 0x00, ##         00000       00000       
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000         
            0x00, 0x1F, 0xF0, 0x00, ##             000000000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '175' => {    # '¯'
        'width'    => 13, 
        'xoffset'  => 4, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0xFF, 0xF8, ##  0000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 13, 
        'xoffset'  => 4, 
        'xadvance' => 21, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0x80, ##      00000    
            0x3F, 0xE0, ##    000000000  
            0x7F, 0xF0, ##   00000000000 
            0x78, 0xF0, ##   0000   0000 
            0xF0, 0x78, ##  0000     0000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xE0, 0x38, ##  000       000
            0xF0, 0x78, ##  0000     0000
            0x78, 0xF0, ##   0000   0000 
            0x7F, 0xF0, ##   00000000000 
            0x3F, 0xE0, ##    000000000  
            0x0F, 0x80, ##      00000    
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '177' => {    # '±'
        'width'    => 27, 
        'xoffset'  => 5, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '178' => {    # '²'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x7F, 0x00, ##   0000000    
            0xE1, 0xC0, ##  000    000  
            0xC0, 0xE0, ##  00      000 
            0x80, 0x70, ##  0        000
            0x00, 0x70, ##           000
            0x00, 0x70, ##           000
            0x00, 0x70, ##           000
            0x00, 0xE0, ##          000 
            0x00, 0xC0, ##          00  
            0x01, 0xC0, ##         000  
            0x03, 0x80, ##        000   
            0x07, 0x00, ##       000    
            0x0C, 0x00, ##      00      
            0x18, 0x00, ##     00       
            0x70, 0x10, ##   000       0
            0xE0, 0x10, ##  000        0
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '179' => {    # '³'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x3F, 0x80, ##    0000000    
            0x70, 0xE0, ##   000    000  
            0x60, 0x70, ##   00      000 
            0x60, 0x70, ##   00      000 
            0x00, 0x70, ##           000 
            0x00, 0x70, ##           000 
            0x00, 0xE0, ##          000  
            0x01, 0xC0, ##         000   
            0x07, 0x00, ##       000     
            0x00, 0xE0, ##          000  
            0x00, 0x70, ##           000 
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0x00, 0x38, ##            000
            0xC0, 0x38, ##  00        000
            0xC0, 0x70, ##  00       000 
            0xF0, 0xF0, ##  0000    0000 
            0x7F, 0xC0, ##   000000000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '180' => {    # '´'
        'width'    => 10, 
        'xoffset'  => 8, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0x80, ##       0000 
            0x07, 0x80, ##       0000 
            0x0F, 0x00, ##      0000  
            0x1E, 0x00, ##     0000   
            0x1C, 0x00, ##     000    
            0x38, 0x00, ##    000     
            0x70, 0x00, ##   000      
            0x60, 0x00, ##   00       
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '181' => {    # 'µ'
        'width'    => 25, 
        'xoffset'  => 1, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x03, 0xFC, 0x00, ##  00000000      00000000   
            0xFF, 0x03, 0xFC, 0x00, ##  00000000      00000000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000   
            0x0F, 0x00, 0x3C, 0x00, ##      0000          0000   
            0x0F, 0x00, 0x7C, 0x00, ##      0000         00000   
            0x0F, 0x80, 0x7C, 0x00, ##      00000        00000   
            0x0F, 0x80, 0xFC, 0x00, ##      00000       000000   
            0x0F, 0xC1, 0xBC, 0x00, ##      000000     00 0000   
            0x0F, 0xFF, 0x3F, 0x80, ##      000000000000  0000000
            0x0F, 0xFE, 0x3F, 0x80, ##      00000000000   0000000
            0x0F, 0x00, 0x00, 0x00, ##      0000                 
            0x0F, 0x00, 0x00, 0x00, ##      0000                 
            0x0F, 0x00, 0x00, 0x00, ##      0000                 
            0x0F, 0x00, 0x00, 0x00, ##      0000                 
            0x0F, 0x00, 0x00, 0x00, ##      0000                 
            0x0F, 0x00, 0x00, 0x00, ##      0000                 
            0x0F, 0x00, 0x00, 0x00, ##      0000                 
            0xFF, 0xE0, 0x00, 0x00, ##  00000000000              
            0xFF, 0xE0, 0x00, 0x00, ##  00000000000              
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '182' => {    # '¶'
        'width'    => 21, 
        'xoffset'  => 4, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xFF, 0xF8, ##        000000000000000
            0x0F, 0xFF, 0xF8, ##      00000000000000000
            0x3F, 0xE0, 0xC0, ##    000000000     00   
            0x7F, 0xE0, 0xC0, ##   0000000000     00   
            0x7F, 0xE0, 0xC0, ##   0000000000     00   
            0xFF, 0xE0, 0xC0, ##  00000000000     00   
            0xFF, 0xE0, 0xC0, ##  00000000000     00   
            0xFF, 0xE0, 0xC0, ##  00000000000     00   
            0xFF, 0xE0, 0xC0, ##  00000000000     00   
            0xFF, 0xE0, 0xC0, ##  00000000000     00   
            0xFF, 0xE0, 0xC0, ##  00000000000     00   
            0xFF, 0xE0, 0xC0, ##  00000000000     00   
            0xFF, 0xE0, 0xC0, ##  00000000000     00   
            0x7F, 0xE0, 0xC0, ##   0000000000     00   
            0x3F, 0xE0, 0xC0, ##    000000000     00   
            0x1F, 0xE0, 0xC0, ##     00000000     00   
            0x0F, 0xE0, 0xC0, ##      0000000     00   
            0x00, 0xE0, 0xC0, ##          000     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x60, 0xC0, ##           00     00   
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '183' => {    # '·'
        'width'    => 5, 
        'xoffset'  => 4, 
        'xadvance' => 13, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000 
            0xF8, ##  00000
            0xF8, ##  00000
            0xF8, ##  00000
            0x70, ##   000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '184' => {    # '¸'
        'width'    => 9, 
        'xoffset'  => 6, 
        'xadvance' => 22, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0C, 0x00, ##      00   
            0x06, 0x00, ##       00  
            0x07, 0x00, ##       000 
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x03, 0x80, ##        000
            0x87, 0x80, ##  0    0000
            0xFF, 0x00, ##  00000000 
            0xFE, 0x00, ##  0000000  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '185' => {    # '¹'
        'width'    => 10, 
        'xoffset'  => 4, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0E, 0x00, ##      000   
            0x3E, 0x00, ##    00000   
            0xFE, 0x00, ##  0000000   
            0xCE, 0x00, ##  00  000   
            0x0E, 0x00, ##      000   
            0x0E, 0x00, ##      000   
            0x0E, 0x00, ##      000   
            0x0E, 0x00, ##      000   
            0x0E, 0x00, ##      000   
            0x0E, 0x00, ##      000   
            0x0E, 0x00, ##      000   
            0x0E, 0x00, ##      000   
            0x0E, 0x00, ##      000   
            0x0E, 0x00, ##      000   
            0x0E, 0x00, ##      000   
            0x0E, 0x00, ##      000   
            0xFF, 0xC0, ##  0000000000
            0xFF, 0xC0, ##  0000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '186' => {    # 'º'
        'width'    => 16, 
        'xoffset'  => 2, 
        'xadvance' => 20, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0xE0, ##       000000     
            0x1C, 0x38, ##     000    000   
            0x38, 0x1C, ##    000      000  
            0x78, 0x1E, ##   0000      0000 
            0x70, 0x0E, ##   000        000 
            0xF0, 0x0F, ##  0000        0000
            0xF0, 0x0F, ##  0000        0000
            0xF0, 0x0F, ##  0000        0000
            0xF0, 0x0F, ##  0000        0000
            0xF0, 0x0F, ##  0000        0000
            0xF0, 0x0F, ##  0000        0000
            0x70, 0x0E, ##   000        000 
            0x78, 0x1E, ##   0000      0000 
            0x38, 0x1C, ##    000      000  
            0x1C, 0x38, ##     000    000   
            0x07, 0xE0, ##       000000     
            0x00, 0x00, ##                  
            0x00, 0x00, ##                  
            0x7F, 0xFE, ##   00000000000000 
            0x7F, 0xFE, ##   00000000000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '187' => {    # '»'
        'width'    => 19, 
        'xoffset'  => 4, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x80, 0x40, 0x00, ##  0        0         
            0xC0, 0x60, 0x00, ##  00       00        
            0xE0, 0x70, 0x00, ##  000      000       
            0x70, 0x38, 0x00, ##   000      000      
            0x38, 0x1C, 0x00, ##    000      000     
            0x1E, 0x0F, 0x00, ##     0000     0000   
            0x0F, 0x07, 0x80, ##      0000     0000  
            0x07, 0x83, 0xC0, ##       0000     0000 
            0x07, 0xC1, 0xE0, ##       00000     0000
            0x03, 0xC1, 0xE0, ##        0000     0000
            0x07, 0xC3, 0xE0, ##       00000    00000
            0x0F, 0x83, 0xC0, ##      00000     0000 
            0x1E, 0x07, 0x00, ##     0000      000   
            0x1C, 0x0E, 0x00, ##     000      000    
            0x38, 0x1C, 0x00, ##    000      000     
            0x70, 0x38, 0x00, ##   000      000      
            0xE0, 0x70, 0x00, ##  000      000       
            0xC0, 0x60, 0x00, ##  00       00        
            0x80, 0x40, 0x00, ##  0        0         
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '188' => {    # '¼'
        'width'    => 37, 
        'xoffset'  => 4, 
        'xadvance' => 42, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x06, 0x00, 0x00, 0x70, 0x00, ##       00                  000         
            0x1E, 0x00, 0x00, 0xF0, 0x00, ##     0000                 0000         
            0x7E, 0x00, 0x00, 0xE0, 0x00, ##   000000                 000          
            0xEE, 0x00, 0x01, 0xC0, 0x00, ##  000 000                000           
            0x8E, 0x00, 0x01, 0xC0, 0x00, ##  0   000                000           
            0x0E, 0x00, 0x03, 0x80, 0x00, ##      000               000            
            0x0E, 0x00, 0x03, 0x80, 0x00, ##      000               000            
            0x0E, 0x00, 0x07, 0x00, 0x00, ##      000              000             
            0x0E, 0x00, 0x0E, 0x00, 0x00, ##      000             000              
            0x0E, 0x00, 0x0E, 0x00, 0x00, ##      000             000              
            0x0E, 0x00, 0x1C, 0x00, 0x00, ##      000            000               
            0x0E, 0x00, 0x1C, 0x00, 0x00, ##      000            000               
            0x0E, 0x00, 0x38, 0x00, 0x00, ##      000           000                
            0x0E, 0x00, 0x70, 0x00, 0x00, ##      000          000                 
            0x0E, 0x00, 0x70, 0x03, 0x80, ##      000          000          000    
            0x0E, 0x00, 0xE0, 0x07, 0x80, ##      000         000          0000    
            0xFF, 0xC0, 0xE0, 0x0F, 0x80, ##  0000000000      000         00000    
            0xFF, 0xC1, 0xC0, 0x0F, 0x80, ##  0000000000     000          00000    
            0x00, 0x03, 0x80, 0x1B, 0x80, ##                000          00 000    
            0x00, 0x03, 0x80, 0x33, 0x80, ##                000         00  000    
            0x00, 0x07, 0x00, 0x63, 0x80, ##               000         00   000    
            0x00, 0x07, 0x00, 0x63, 0x80, ##               000         00   000    
            0x00, 0x0E, 0x00, 0xC3, 0x80, ##              000         00    000    
            0x00, 0x1C, 0x01, 0x83, 0x80, ##             000         00     000    
            0x00, 0x1C, 0x03, 0x03, 0x80, ##             000        00      000    
            0x00, 0x38, 0x03, 0xFF, 0xF8, ##            000         000000000000000
            0x00, 0x30, 0x03, 0xFF, 0xF8, ##            00          000000000000000
            0x00, 0x70, 0x00, 0x03, 0x80, ##           000                  000    
            0x00, 0xE0, 0x00, 0x03, 0x80, ##          000                   000    
            0x00, 0xE0, 0x00, 0x03, 0x80, ##          000                   000    
            0x01, 0xC0, 0x00, 0x1F, 0xF0, ##         000                 000000000 
            0x01, 0x80, 0x00, 0x1F, 0xF0, ##         00                  000000000 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '189' => {    # '½'
        'width'    => 35, 
        'xoffset'  => 4, 
        'xadvance' => 42, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x06, 0x00, 0x00, 0x70, 0x00, ##       00                  000       
            0x1E, 0x00, 0x00, 0xF0, 0x00, ##     0000                 0000       
            0x7E, 0x00, 0x00, 0xE0, 0x00, ##   000000                 000        
            0xEE, 0x00, 0x01, 0xC0, 0x00, ##  000 000                000         
            0x8E, 0x00, 0x01, 0xC0, 0x00, ##  0   000                000         
            0x0E, 0x00, 0x03, 0x80, 0x00, ##      000               000          
            0x0E, 0x00, 0x03, 0x80, 0x00, ##      000               000          
            0x0E, 0x00, 0x07, 0x00, 0x00, ##      000              000           
            0x0E, 0x00, 0x0E, 0x00, 0x00, ##      000             000            
            0x0E, 0x00, 0x0E, 0x00, 0x00, ##      000             000            
            0x0E, 0x00, 0x1C, 0x00, 0x00, ##      000            000             
            0x0E, 0x00, 0x1C, 0x00, 0x00, ##      000            000             
            0x0E, 0x00, 0x38, 0x00, 0x00, ##      000           000              
            0x0E, 0x00, 0x70, 0x00, 0x00, ##      000          000               
            0x0E, 0x00, 0x70, 0x3E, 0x00, ##      000          000      00000    
            0x0E, 0x00, 0xE1, 0xFF, 0x80, ##      000         000    0000000000  
            0xFF, 0xC0, 0xE1, 0xC3, 0xC0, ##  0000000000      000    000    0000 
            0xFF, 0xC1, 0xC1, 0x81, 0xE0, ##  0000000000     000     00      0000
            0x00, 0x03, 0x81, 0x00, 0xE0, ##                000      0        000
            0x00, 0x03, 0x80, 0x00, 0xE0, ##                000               000
            0x00, 0x07, 0x00, 0x00, 0xE0, ##               000                000
            0x00, 0x07, 0x00, 0x00, 0xC0, ##               000                00 
            0x00, 0x0E, 0x00, 0x01, 0x80, ##              000                00  
            0x00, 0x1C, 0x00, 0x03, 0x80, ##             000                000  
            0x00, 0x1C, 0x00, 0x07, 0x00, ##             000               000   
            0x00, 0x38, 0x00, 0x0E, 0x00, ##            000               000    
            0x00, 0x38, 0x00, 0x18, 0x00, ##            000              00      
            0x00, 0x70, 0x00, 0x30, 0x00, ##           000              00       
            0x00, 0xE0, 0x00, 0x60, 0x20, ##          000              00       0
            0x00, 0xE0, 0x00, 0xC0, 0x20, ##          000             00        0
            0x01, 0xC0, 0x01, 0xFF, 0xE0, ##         000             000000000000
            0x01, 0x80, 0x01, 0xFF, 0xE0, ##         00              000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '190' => {    # '¾'
        'width'    => 38, 
        'xoffset'  => 2, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x1F, 0x80, 0x00, 0x1C, 0x00, ##     000000                  000        
            0x7F, 0xE0, 0x00, 0x3C, 0x00, ##   0000000000               0000        
            0x70, 0xF0, 0x00, 0x38, 0x00, ##   000    0000              000         
            0x60, 0x70, 0x00, 0x70, 0x00, ##   00      000             000          
            0x00, 0x70, 0x00, 0xF0, 0x00, ##           000            0000          
            0x00, 0x70, 0x00, 0xE0, 0x00, ##           000            000           
            0x00, 0xE0, 0x01, 0xC0, 0x00, ##          000            000            
            0x07, 0xC0, 0x01, 0xC0, 0x00, ##       00000             000            
            0x07, 0xC0, 0x03, 0x80, 0x00, ##       00000            000             
            0x00, 0xF0, 0x07, 0x80, 0x00, ##          0000         0000             
            0x00, 0x70, 0x07, 0x00, 0x00, ##           000         000              
            0x00, 0x38, 0x0E, 0x00, 0x00, ##            000       000               
            0x00, 0x38, 0x0E, 0x00, 0x00, ##            000       000               
            0xC0, 0x38, 0x1C, 0x00, 0x00, ##  00        000      000                
            0xC0, 0x78, 0x3C, 0x00, 0xE0, ##  00       0000     0000          000   
            0xE0, 0xF0, 0x38, 0x01, 0xE0, ##  000     0000      000          0000   
            0xFF, 0xE0, 0x70, 0x03, 0xE0, ##  00000000000      000          00000   
            0x1F, 0x80, 0xF0, 0x06, 0xE0, ##     000000       0000         00 000   
            0x00, 0x00, 0xE0, 0x0C, 0xE0, ##                  000         00  000   
            0x00, 0x01, 0xE0, 0x1C, 0xE0, ##                 0000        000  000   
            0x00, 0x01, 0xC0, 0x18, 0xE0, ##                 000         00   000   
            0x00, 0x03, 0x80, 0x30, 0xE0, ##                000         00    000   
            0x00, 0x07, 0x80, 0x60, 0xE0, ##               0000        00     000   
            0x00, 0x07, 0x00, 0xC0, 0xE0, ##               000        00      000   
            0x00, 0x0E, 0x01, 0xC0, 0xE0, ##              000        000      000   
            0x00, 0x0E, 0x01, 0xFF, 0xFC, ##              000        000000000000000
            0x00, 0x1C, 0x01, 0xFF, 0xFC, ##             000         000000000000000
            0x00, 0x3C, 0x00, 0x00, 0xE0, ##            0000                  000   
            0x00, 0x38, 0x00, 0x00, 0xE0, ##            000                   000   
            0x00, 0x70, 0x00, 0x00, 0xE0, ##           000                    000   
            0x00, 0x70, 0x00, 0x07, 0xFC, ##           000                 000000000
            0x00, 0xE0, 0x00, 0x07, 0xFC, ##          000                  000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '191' => {    # '¿'
        'width'    => 18, 
        'xoffset'  => 3, 
        'xadvance' => 23, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x20, 0x00, ##            0       
            0x00, 0xF0, 0x00, ##          0000      
            0x00, 0xF8, 0x00, ##          00000     
            0x00, 0xF8, 0x00, ##          00000     
            0x00, 0xF8, 0x00, ##          00000     
            0x00, 0x20, 0x00, ##            0       
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x00, 0x00, ##                    
            0x00, 0x70, 0x00, ##           000      
            0x00, 0x70, 0x00, ##           000      
            0x00, 0x70, 0x00, ##           000      
            0x00, 0x70, 0x00, ##           000      
            0x00, 0x70, 0x00, ##           000      
            0x00, 0xF0, 0x00, ##          0000      
            0x07, 0xF0, 0x00, ##       0000000      
            0x0F, 0xC0, 0x00, ##      000000        
            0x3F, 0x00, 0x00, ##    000000          
            0x3E, 0x00, 0x00, ##    00000           
            0x7C, 0x00, 0x00, ##   00000            
            0x7C, 0x00, 0x00, ##   00000            
            0xF8, 0x00, 0x00, ##  00000             
            0xF8, 0x00, 0x00, ##  00000             
            0xF8, 0x00, 0x00, ##  00000             
            0xF8, 0x00, 0x00, ##  00000             
            0xF8, 0x00, 0xC0, ##  00000           00
            0xF8, 0x01, 0xC0, ##  00000          000
            0x7C, 0x01, 0xC0, ##   00000         000
            0x7C, 0x03, 0xC0, ##   00000        0000
            0x3E, 0x03, 0xC0, ##    00000       0000
            0x1F, 0xFF, 0xC0, ##     000000000000000
            0x07, 0xFF, 0x00, ##       00000000000  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '192' => {    # 'À'
        'width'    => 32, 
        'xoffset'  => 0, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x1E, 0x00, 0x00, ##             0000                 
            0x00, 0x0F, 0x00, 0x00, ##              0000                
            0x00, 0x07, 0x80, 0x00, ##               0000               
            0x00, 0x03, 0x80, 0x00, ##                000               
            0x00, 0x01, 0xC0, 0x00, ##                 000              
            0x00, 0x00, 0xE0, 0x00, ##                  000             
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x03, 0xC0, 0x00, ##                0000              
            0x00, 0x03, 0xE0, 0x00, ##                00000             
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x07, 0xF0, 0x00, ##               0000000            
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x0C, 0xF0, 0x00, ##              00  0000            
            0x00, 0x1C, 0xF8, 0x00, ##             000  00000           
            0x00, 0x1C, 0xF8, 0x00, ##             000  00000           
            0x00, 0x18, 0x7C, 0x00, ##             00    00000          
            0x00, 0x38, 0x7C, 0x00, ##            000    00000          
            0x00, 0x30, 0x3C, 0x00, ##            00      0000          
            0x00, 0x70, 0x3E, 0x00, ##           000      00000         
            0x00, 0x70, 0x3E, 0x00, ##           000      00000         
            0x00, 0x60, 0x1F, 0x00, ##           00        00000        
            0x00, 0xE0, 0x1F, 0x00, ##          000        00000        
            0x00, 0xC0, 0x0F, 0x00, ##          00          0000        
            0x01, 0xC0, 0x0F, 0x80, ##         000          00000       
            0x01, 0xC0, 0x0F, 0x80, ##         000          00000       
            0x01, 0x80, 0x07, 0x80, ##         00            0000       
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0x00, 0x03, 0xE0, ##       000              00000     
            0x07, 0x00, 0x03, 0xE0, ##       000              00000     
            0x06, 0x00, 0x01, 0xE0, ##       00                0000     
            0x0E, 0x00, 0x01, 0xF0, ##      000                00000    
            0x0C, 0x00, 0x01, 0xF0, ##      00                 00000    
            0x1C, 0x00, 0x00, 0xF0, ##     000                  0000    
            0x1C, 0x00, 0x00, 0xF8, ##     000                  00000   
            0xFF, 0x80, 0x07, 0xFF, ##  000000000            00000000000
            0xFF, 0x80, 0x07, 0xFF, ##  000000000            00000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '193' => {    # 'Á'
        'width'    => 32, 
        'xoffset'  => 0, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x78, 0x00, ##                   0000           
            0x00, 0x00, 0x70, 0x00, ##                   000            
            0x00, 0x00, 0xE0, 0x00, ##                  000             
            0x00, 0x01, 0xC0, 0x00, ##                 000              
            0x00, 0x03, 0x80, 0x00, ##                000               
            0x00, 0x03, 0x00, 0x00, ##                00                
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x03, 0xC0, 0x00, ##                0000              
            0x00, 0x03, 0xE0, 0x00, ##                00000             
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x07, 0xF0, 0x00, ##               0000000            
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x0C, 0xF0, 0x00, ##              00  0000            
            0x00, 0x1C, 0xF8, 0x00, ##             000  00000           
            0x00, 0x1C, 0xF8, 0x00, ##             000  00000           
            0x00, 0x18, 0x7C, 0x00, ##             00    00000          
            0x00, 0x38, 0x7C, 0x00, ##            000    00000          
            0x00, 0x30, 0x3C, 0x00, ##            00      0000          
            0x00, 0x70, 0x3E, 0x00, ##           000      00000         
            0x00, 0x70, 0x3E, 0x00, ##           000      00000         
            0x00, 0x60, 0x1F, 0x00, ##           00        00000        
            0x00, 0xE0, 0x1F, 0x00, ##          000        00000        
            0x00, 0xC0, 0x0F, 0x00, ##          00          0000        
            0x01, 0xC0, 0x0F, 0x80, ##         000          00000       
            0x01, 0xC0, 0x0F, 0x80, ##         000          00000       
            0x01, 0x80, 0x07, 0x80, ##         00            0000       
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0x00, 0x03, 0xE0, ##       000              00000     
            0x07, 0x00, 0x03, 0xE0, ##       000              00000     
            0x06, 0x00, 0x01, 0xE0, ##       00                0000     
            0x0E, 0x00, 0x01, 0xF0, ##      000                00000    
            0x0C, 0x00, 0x01, 0xF0, ##      00                 00000    
            0x1C, 0x00, 0x00, 0xF0, ##     000                  0000    
            0x1C, 0x00, 0x00, 0xF8, ##     000                  00000   
            0xFF, 0x80, 0x07, 0xFF, ##  000000000            00000000000
            0xFF, 0x80, 0x07, 0xFF, ##  000000000            00000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '194' => {    # 'Â'
        'width'    => 32, 
        'xoffset'  => 0, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x03, 0xE0, 0x00, ##                00000             
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x0F, 0x70, 0x00, ##              0000 000            
            0x00, 0x1C, 0x38, 0x00, ##             000    000           
            0x00, 0x38, 0x1C, 0x00, ##            000      000          
            0x00, 0x70, 0x06, 0x00, ##           000         00         
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x03, 0xC0, 0x00, ##                0000              
            0x00, 0x03, 0xE0, 0x00, ##                00000             
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x07, 0xF0, 0x00, ##               0000000            
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x0C, 0xF0, 0x00, ##              00  0000            
            0x00, 0x1C, 0xF8, 0x00, ##             000  00000           
            0x00, 0x1C, 0xF8, 0x00, ##             000  00000           
            0x00, 0x18, 0x7C, 0x00, ##             00    00000          
            0x00, 0x38, 0x7C, 0x00, ##            000    00000          
            0x00, 0x30, 0x3C, 0x00, ##            00      0000          
            0x00, 0x70, 0x3E, 0x00, ##           000      00000         
            0x00, 0x70, 0x3E, 0x00, ##           000      00000         
            0x00, 0x60, 0x1F, 0x00, ##           00        00000        
            0x00, 0xE0, 0x1F, 0x00, ##          000        00000        
            0x00, 0xC0, 0x0F, 0x00, ##          00          0000        
            0x01, 0xC0, 0x0F, 0x80, ##         000          00000       
            0x01, 0xC0, 0x0F, 0x80, ##         000          00000       
            0x01, 0x80, 0x07, 0x80, ##         00            0000       
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0x00, 0x03, 0xE0, ##       000              00000     
            0x07, 0x00, 0x03, 0xE0, ##       000              00000     
            0x06, 0x00, 0x01, 0xE0, ##       00                0000     
            0x0E, 0x00, 0x01, 0xF0, ##      000                00000    
            0x0C, 0x00, 0x01, 0xF0, ##      00                 00000    
            0x1C, 0x00, 0x00, 0xF0, ##     000                  0000    
            0x1C, 0x00, 0x00, 0xF8, ##     000                  00000   
            0xFF, 0x80, 0x07, 0xFF, ##  000000000            00000000000
            0xFF, 0x80, 0x07, 0xFF, ##  000000000            00000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '195' => {    # 'Ã'
        'width'    => 32, 
        'xoffset'  => 0, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x1E, 0x06, 0x00, ##             0000      00         
            0x00, 0x3F, 0x06, 0x00, ##            000000     00         
            0x00, 0x73, 0xCE, 0x00, ##           000  0000  000         
            0x00, 0x60, 0xFC, 0x00, ##           00     000000          
            0x00, 0x60, 0x78, 0x00, ##           00      0000           
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x03, 0xC0, 0x00, ##                0000              
            0x00, 0x03, 0xE0, 0x00, ##                00000             
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x07, 0xF0, 0x00, ##               0000000            
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x0C, 0xF0, 0x00, ##              00  0000            
            0x00, 0x1C, 0xF8, 0x00, ##             000  00000           
            0x00, 0x1C, 0xF8, 0x00, ##             000  00000           
            0x00, 0x18, 0x7C, 0x00, ##             00    00000          
            0x00, 0x38, 0x7C, 0x00, ##            000    00000          
            0x00, 0x30, 0x3C, 0x00, ##            00      0000          
            0x00, 0x70, 0x3E, 0x00, ##           000      00000         
            0x00, 0x70, 0x3E, 0x00, ##           000      00000         
            0x00, 0x60, 0x1E, 0x00, ##           00        0000         
            0x00, 0xE0, 0x1F, 0x00, ##          000        00000        
            0x00, 0xC0, 0x0F, 0x00, ##          00          0000        
            0x01, 0xC0, 0x0F, 0x80, ##         000          00000       
            0x01, 0xC0, 0x0F, 0x80, ##         000          00000       
            0x01, 0x80, 0x07, 0x80, ##         00            0000       
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0x00, 0x03, 0xC0, ##       000              0000      
            0x07, 0x00, 0x03, 0xE0, ##       000              00000     
            0x06, 0x00, 0x03, 0xE0, ##       00               00000     
            0x0E, 0x00, 0x01, 0xF0, ##      000                00000    
            0x0C, 0x00, 0x01, 0xF0, ##      00                 00000    
            0x1C, 0x00, 0x00, 0xF0, ##     000                  0000    
            0x1C, 0x00, 0x00, 0xF8, ##     000                  00000   
            0xFF, 0x80, 0x07, 0xFF, ##  000000000            00000000000
            0xFF, 0x80, 0x07, 0xFF, ##  000000000            00000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '196' => {    # 'Ä'
        'width'    => 32, 
        'xoffset'  => 0, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x38, 0x38, 0x00, ##            000     000           
            0x00, 0x7C, 0x7C, 0x00, ##           00000   00000          
            0x00, 0x7C, 0x7C, 0x00, ##           00000   00000          
            0x00, 0x7C, 0x7C, 0x00, ##           00000   00000          
            0x00, 0x38, 0x38, 0x00, ##            000     000           
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x03, 0x80, 0x00, ##                000               
            0x00, 0x07, 0xC0, 0x00, ##               00000              
            0x00, 0x07, 0xC0, 0x00, ##               00000              
            0x00, 0x0F, 0xC0, 0x00, ##              000000              
            0x00, 0x0F, 0xE0, 0x00, ##              0000000             
            0x00, 0x0D, 0xE0, 0x00, ##              00 0000             
            0x00, 0x1D, 0xF0, 0x00, ##             000 00000            
            0x00, 0x1C, 0xF0, 0x00, ##             000  0000            
            0x00, 0x18, 0xF0, 0x00, ##             00   0000            
            0x00, 0x38, 0xF8, 0x00, ##            000   00000           
            0x00, 0x30, 0x78, 0x00, ##            00     0000           
            0x00, 0x70, 0x7C, 0x00, ##           000     00000          
            0x00, 0x70, 0x3C, 0x00, ##           000      0000          
            0x00, 0x60, 0x3C, 0x00, ##           00       0000          
            0x00, 0xE0, 0x1E, 0x00, ##          000        0000         
            0x00, 0xE0, 0x1E, 0x00, ##          000        0000         
            0x00, 0xC0, 0x1F, 0x00, ##          00         00000        
            0x01, 0xC0, 0x0F, 0x00, ##         000          0000        
            0x01, 0xC0, 0x0F, 0x80, ##         000          00000       
            0x03, 0x80, 0x07, 0x80, ##        000            0000       
            0x03, 0xFF, 0xFF, 0x80, ##        0000000000000000000       
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0x00, 0x03, 0xC0, ##       000              0000      
            0x07, 0x00, 0x03, 0xE0, ##       000              00000     
            0x0E, 0x00, 0x03, 0xE0, ##      000               00000     
            0x0E, 0x00, 0x01, 0xE0, ##      000                0000     
            0x0C, 0x00, 0x01, 0xF0, ##      00                 00000    
            0x1C, 0x00, 0x01, 0xF0, ##     000                 00000    
            0x1C, 0x00, 0x01, 0xF8, ##     000                 000000   
            0xFF, 0x80, 0x07, 0xFF, ##  000000000            00000000000
            0xFF, 0x80, 0x07, 0xFF, ##  000000000            00000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '197' => {    # 'Å'
        'width'    => 32, 
        'xoffset'  => 0, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x03, 0xC0, 0x00, ##                0000              
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x1C, 0x78, 0x00, ##             000   0000           
            0x00, 0x3C, 0x3C, 0x00, ##            0000    0000          
            0x00, 0x38, 0x1C, 0x00, ##            000      000          
            0x00, 0x38, 0x1C, 0x00, ##            000      000          
            0x00, 0x38, 0x1C, 0x00, ##            000      000          
            0x00, 0x38, 0x3C, 0x00, ##            000     0000          
            0x00, 0x1C, 0x38, 0x00, ##             000    000           
            0x00, 0x1F, 0xF8, 0x00, ##             0000000000           
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x0F, 0xE0, 0x00, ##              0000000             
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x0C, 0xF0, 0x00, ##              00  0000            
            0x00, 0x1C, 0xF8, 0x00, ##             000  00000           
            0x00, 0x1C, 0xF8, 0x00, ##             000  00000           
            0x00, 0x38, 0x78, 0x00, ##            000    0000           
            0x00, 0x38, 0x7C, 0x00, ##            000    00000          
            0x00, 0x30, 0x3C, 0x00, ##            00      0000          
            0x00, 0x70, 0x3E, 0x00, ##           000      00000         
            0x00, 0x70, 0x3E, 0x00, ##           000      00000         
            0x00, 0x60, 0x1E, 0x00, ##           00        0000         
            0x00, 0xE0, 0x1F, 0x00, ##          000        00000        
            0x00, 0xC0, 0x0F, 0x00, ##          00          0000        
            0x01, 0xC0, 0x0F, 0x80, ##         000          00000       
            0x01, 0xC0, 0x0F, 0x80, ##         000          00000       
            0x01, 0x80, 0x07, 0x80, ##         00            0000       
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0x00, 0x03, 0xC0, ##       000              0000      
            0x07, 0x00, 0x03, 0xE0, ##       000              00000     
            0x06, 0x00, 0x01, 0xE0, ##       00                0000     
            0x0E, 0x00, 0x01, 0xF0, ##      000                00000    
            0x0C, 0x00, 0x01, 0xF0, ##      00                 00000    
            0x1C, 0x00, 0x00, 0xF0, ##     000                  0000    
            0x1C, 0x00, 0x00, 0xF8, ##     000                  00000   
            0xFF, 0x80, 0x07, 0xFF, ##  000000000            00000000000
            0xFF, 0x80, 0x07, 0xFF, ##  000000000            00000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '198' => {    # 'Æ'
        'width'    => 42, 
        'xoffset'  => -1, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0x80, ##             000000000000000000000000000000 
            0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0x80, ##             000000000000000000000000000000 
            0x00, 0x01, 0xCF, 0x00, 0x03, 0x80, ##                 000  0000              000 
            0x00, 0x03, 0x8F, 0x00, 0x03, 0x80, ##                000   0000              000 
            0x00, 0x03, 0x8F, 0x00, 0x03, 0x80, ##                000   0000              000 
            0x00, 0x07, 0x0F, 0x00, 0x03, 0x80, ##               000    0000              000 
            0x00, 0x07, 0x0F, 0x00, 0x03, 0x80, ##               000    0000              000 
            0x00, 0x06, 0x0F, 0x00, 0x00, 0x00, ##               00     0000                  
            0x00, 0x0E, 0x0F, 0x00, 0x00, 0x00, ##              000     0000                  
            0x00, 0x0C, 0x0F, 0x00, 0x38, 0x00, ##              00      0000          000     
            0x00, 0x1C, 0x0F, 0x00, 0x38, 0x00, ##             000      0000          000     
            0x00, 0x1C, 0x0F, 0x00, 0x38, 0x00, ##             000      0000          000     
            0x00, 0x38, 0x0F, 0x00, 0x38, 0x00, ##            000       0000          000     
            0x00, 0x38, 0x0F, 0xFF, 0xF8, 0x00, ##            000       00000000000000000     
            0x00, 0x70, 0x0F, 0xFF, 0xF8, 0x00, ##           000        00000000000000000     
            0x00, 0x70, 0x0F, 0x00, 0x38, 0x00, ##           000        0000          000     
            0x00, 0xE0, 0x0F, 0x00, 0x38, 0x00, ##          000         0000          000     
            0x00, 0xE0, 0x0F, 0x00, 0x38, 0x00, ##          000         0000          000     
            0x00, 0xC0, 0x0F, 0x00, 0x38, 0x00, ##          00          0000          000     
            0x01, 0xC0, 0x0F, 0x00, 0x00, 0x00, ##         000          0000                  
            0x01, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##         00000000000000000                  
            0x03, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##        000000000000000000                  
            0x03, 0x80, 0x0F, 0x00, 0x00, 0x00, ##        000           0000                  
            0x07, 0x00, 0x0F, 0x00, 0x00, 0x00, ##       000            0000                  
            0x07, 0x00, 0x0F, 0x00, 0x01, 0xC0, ##       000            0000               000
            0x0E, 0x00, 0x0F, 0x00, 0x01, 0xC0, ##      000             0000               000
            0x0E, 0x00, 0x0F, 0x00, 0x01, 0xC0, ##      000             0000               000
            0x1C, 0x00, 0x0F, 0x00, 0x01, 0xC0, ##     000              0000               000
            0x1C, 0x00, 0x0F, 0x00, 0x01, 0xC0, ##     000              0000               000
            0xFF, 0x80, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000       00000000000000000000000000
            0xFF, 0x80, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000       00000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '199' => {    # 'Ç'
        'width'    => 28, 
        'xoffset'  => 2, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##                              
            0x00, 0x7F, 0xFC, 0x00, ##           0000000000000      
            0x01, 0xFF, 0xFF, 0xC0, ##         0000000000000000000  
            0x03, 0xC0, 0x0F, 0xE0, ##        0000          0000000 
            0x07, 0x80, 0x03, 0xE0, ##       0000             00000 
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000 
            0x1E, 0x00, 0x01, 0xE0, ##     0000                0000 
            0x3E, 0x00, 0x00, 0xE0, ##    00000                 000 
            0x3C, 0x00, 0x00, 0xE0, ##    0000                  000 
            0x7C, 0x00, 0x00, 0xE0, ##   00000                  000 
            0x7C, 0x00, 0x00, 0x00, ##   00000                      
            0x78, 0x00, 0x00, 0x00, ##   0000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0xF8, 0x00, 0x00, 0x00, ##  00000                       
            0x78, 0x00, 0x00, 0x00, ##   0000                       
            0x7C, 0x00, 0x00, 0x00, ##   00000                      
            0x7C, 0x00, 0x00, 0x00, ##   00000                      
            0x3C, 0x00, 0x00, 0xF0, ##    0000                  0000
            0x3E, 0x00, 0x01, 0xE0, ##    00000                0000 
            0x1E, 0x00, 0x01, 0xE0, ##     0000                0000 
            0x0F, 0x00, 0x03, 0xC0, ##      0000              0000  
            0x07, 0x80, 0x07, 0x80, ##       0000            0000   
            0x03, 0xC0, 0x0F, 0x00, ##        0000          0000    
            0x01, 0xFF, 0xFE, 0x00, ##         0000000000000000     
            0x00, 0x7F, 0xF8, 0x00, ##           000000000000       
            0x00, 0x03, 0x80, 0x00, ##                000           
            0x00, 0x01, 0xC0, 0x00, ##                 000          
            0x00, 0x00, 0xC0, 0x00, ##                  00          
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x00, 0xE0, 0x00, ##                  000         
            0x00, 0x21, 0xE0, 0x00, ##            0    0000         
            0x00, 0x3F, 0xC0, 0x00, ##            00000000          
            0x00, 0x3F, 0x80, 0x00, ##            0000000           
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '200' => {    # 'È'
        'width'    => 26, 
        'xoffset'  => 2, 
        'xadvance' => 31, 
        'bitmap'   => [ 
            0x00, 0x70, 0x00, 0x00, ##           000              
            0x00, 0x38, 0x00, 0x00, ##            000             
            0x00, 0x1C, 0x00, 0x00, ##             000            
            0x00, 0x0C, 0x00, 0x00, ##              00            
            0x00, 0x0E, 0x00, 0x00, ##              000           
            0x00, 0x07, 0x00, 0x00, ##               000          
            0x00, 0x00, 0x00, 0x00, ##                            
            0x00, 0x00, 0x00, 0x00, ##                            
            0x00, 0x00, 0x00, 0x00, ##                            
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0xFF, 0xF8, 0x00, ##      00000000000000000     
            0x0F, 0xFF, 0xF8, 0x00, ##      00000000000000000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '201' => {    # 'É'
        'width'    => 26, 
        'xoffset'  => 2, 
        'xadvance' => 31, 
        'bitmap'   => [ 
            0x00, 0x03, 0xC0, 0x00, ##                0000        
            0x00, 0x03, 0x80, 0x00, ##                000         
            0x00, 0x07, 0x00, 0x00, ##               000          
            0x00, 0x0E, 0x00, 0x00, ##              000           
            0x00, 0x0C, 0x00, 0x00, ##              00            
            0x00, 0x18, 0x00, 0x00, ##             00             
            0x00, 0x00, 0x00, 0x00, ##                            
            0x00, 0x00, 0x00, 0x00, ##                            
            0x00, 0x00, 0x00, 0x00, ##                            
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0xFF, 0xF8, 0x00, ##      00000000000000000     
            0x0F, 0xFF, 0xF8, 0x00, ##      00000000000000000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '202' => {    # 'Ê'
        'width'    => 26, 
        'xoffset'  => 2, 
        'xadvance' => 31, 
        'bitmap'   => [ 
            0x00, 0x1F, 0x00, 0x00, ##             00000          
            0x00, 0x1F, 0x00, 0x00, ##             00000          
            0x00, 0x3B, 0x80, 0x00, ##            000 000         
            0x00, 0x71, 0xC0, 0x00, ##           000   000        
            0x00, 0xE0, 0xE0, 0x00, ##          000     000       
            0x01, 0xC0, 0x70, 0x00, ##         000       000      
            0x00, 0x00, 0x00, 0x00, ##                            
            0x00, 0x00, 0x00, 0x00, ##                            
            0x00, 0x00, 0x00, 0x00, ##                            
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0xFF, 0xF8, 0x00, ##      00000000000000000     
            0x0F, 0xFF, 0xF8, 0x00, ##      00000000000000000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '203' => {    # 'Ë'
        'width'    => 26, 
        'xoffset'  => 2, 
        'xadvance' => 31, 
        'bitmap'   => [ 
            0x00, 0xE0, 0xE0, 0x00, ##          000     000       
            0x01, 0xF1, 0xF0, 0x00, ##         00000   00000      
            0x01, 0xF1, 0xF0, 0x00, ##         00000   00000      
            0x01, 0xF1, 0xF0, 0x00, ##         00000   00000      
            0x00, 0xE0, 0xE0, 0x00, ##          000     000       
            0x00, 0x00, 0x00, 0x00, ##                            
            0x00, 0x00, 0x00, 0x00, ##                            
            0x00, 0x00, 0x00, 0x00, ##                            
            0x00, 0x00, 0x00, 0x00, ##                            
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x03, 0x80, ##      00000             000 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0xFF, 0xF8, 0x00, ##      00000000000000000     
            0x0F, 0xFF, 0xF8, 0x00, ##      00000000000000000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x38, 0x00, ##      00000         000     
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x00, 0x00, ##      00000                 
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0x0F, 0x80, 0x01, 0xC0, ##      00000              000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '204' => {    # 'Ì'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x78, 0x00, ##   0000       
            0x3C, 0x00, ##    0000      
            0x1E, 0x00, ##     0000     
            0x0F, 0x00, ##      0000    
            0x07, 0x00, ##       000    
            0x03, 0x80, ##        000   
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '205' => {    # 'Í'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x00, 0xE0, ##          000 
            0x01, 0xC0, ##         000  
            0x03, 0x80, ##        000   
            0x07, 0x00, ##       000    
            0x0E, 0x00, ##      000     
            0x0E, 0x00, ##      000     
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0x0F, 0x80, ##      00000   
            0xFF, 0xF0, ##  000000000000
            0xFF, 0xF0, ##  000000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '206' => {    # 'Î'
        'width'    => 14, 
        'xoffset'  => 1, 
        'xadvance' => 16, 
        'bitmap'   => [ 
            0x07, 0xC0, ##       00000    
            0x0F, 0xE0, ##      0000000   
            0x1E, 0xE0, ##     0000 000   
            0x3C, 0x70, ##    0000   000  
            0x70, 0x38, ##   000      000 
            0xE0, 0x0C, ##  000         00
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x00, 0x00, ##                
            0x7F, 0xF8, ##   000000000000 
            0x7F, 0xF8, ##   000000000000 
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x07, 0xC0, ##       00000    
            0x7F, 0xF8, ##   000000000000 
            0x7F, 0xF8, ##   000000000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '207' => {    # 'Ï'
        'width'    => 13, 
        'xoffset'  => 2, 
        'xadvance' => 17, 
        'bitmap'   => [ 
            0x70, 0x70, ##   000     000 
            0xF8, 0xF8, ##  00000   00000
            0xF8, 0xF8, ##  00000   00000
            0xF8, 0xF8, ##  00000   00000
            0x70, 0x70, ##   000     000 
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0xFF, 0xF0, ##  000000000000 
            0xFF, 0xF0, ##  000000000000 
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0x0F, 0x80, ##      00000    
            0xFF, 0xF0, ##  000000000000 
            0xFF, 0xF0, ##  000000000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '208' => {    # 'Ð'
        'width'    => 30, 
        'xoffset'  => 3, 
        'xadvance' => 36, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xC0, 0x00, ##  000000000000000000            
            0xFF, 0xFF, 0xF8, 0x00, ##  000000000000000000000         
            0x0F, 0x00, 0xFE, 0x00, ##      0000        0000000       
            0x0F, 0x00, 0x1F, 0x80, ##      0000           000000     
            0x0F, 0x00, 0x07, 0xC0, ##      0000             00000    
            0x0F, 0x00, 0x03, 0xE0, ##      0000              00000   
            0x0F, 0x00, 0x03, 0xE0, ##      0000              00000   
            0x0F, 0x00, 0x01, 0xF0, ##      0000               00000  
            0x0F, 0x00, 0x00, 0xF8, ##      0000                00000 
            0x0F, 0x00, 0x00, 0xF8, ##      0000                00000 
            0x0F, 0x00, 0x00, 0xF8, ##      0000                00000 
            0x0F, 0x00, 0x00, 0x7C, ##      0000                 00000
            0x0F, 0x00, 0x00, 0x7C, ##      0000                 00000
            0x0F, 0x00, 0x00, 0x7C, ##      0000                 00000
            0xFF, 0xFE, 0x00, 0x7C, ##  000000000000000          00000
            0xFF, 0xFE, 0x00, 0x7C, ##  000000000000000          00000
            0x0F, 0x00, 0x00, 0x7C, ##      0000                 00000
            0x0F, 0x00, 0x00, 0x7C, ##      0000                 00000
            0x0F, 0x00, 0x00, 0x7C, ##      0000                 00000
            0x0F, 0x00, 0x00, 0x7C, ##      0000                 00000
            0x0F, 0x00, 0x00, 0xF8, ##      0000                00000 
            0x0F, 0x00, 0x00, 0xF8, ##      0000                00000 
            0x0F, 0x00, 0x00, 0xF8, ##      0000                00000 
            0x0F, 0x00, 0x01, 0xF0, ##      0000               00000  
            0x0F, 0x00, 0x03, 0xF0, ##      0000              000000  
            0x0F, 0x00, 0x03, 0xE0, ##      0000              00000   
            0x0F, 0x00, 0x07, 0xC0, ##      0000             00000    
            0x0F, 0x00, 0x1F, 0x80, ##      0000           000000     
            0x0F, 0x00, 0xFE, 0x00, ##      0000        0000000       
            0xFF, 0xFF, 0xF8, 0x00, ##  000000000000000000000         
            0xFF, 0xFF, 0xC0, 0x00, ##  000000000000000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '209' => {    # 'Ñ'
        'width'    => 34, 
        'xoffset'  => 2, 
        'xadvance' => 38, 
        'bitmap'   => [ 
            0x00, 0x0F, 0x03, 0x00, 0x00, ##              0000      00          
            0x00, 0x1F, 0x83, 0x00, 0x00, ##             000000     00          
            0x00, 0x39, 0xE7, 0x00, 0x00, ##            000  0000  000          
            0x00, 0x30, 0xFE, 0x00, 0x00, ##            00    0000000           
            0x00, 0x30, 0x3C, 0x00, 0x00, ##            00      0000            
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0xFF, 0x80, 0x01, 0xFF, 0xC0, ##  000000000              00000000000
            0xFF, 0x80, 0x01, 0xFF, 0xC0, ##  000000000              00000000000
            0x0F, 0xC0, 0x00, 0x1C, 0x00, ##      000000                 000    
            0x0F, 0xE0, 0x00, 0x1C, 0x00, ##      0000000                000    
            0x0F, 0xF0, 0x00, 0x1C, 0x00, ##      00000000               000    
            0x0F, 0xF0, 0x00, 0x1C, 0x00, ##      00000000               000    
            0x0E, 0xF8, 0x00, 0x1C, 0x00, ##      000 00000              000    
            0x0E, 0x7C, 0x00, 0x1C, 0x00, ##      000  00000             000    
            0x0E, 0x7E, 0x00, 0x1C, 0x00, ##      000  000000            000    
            0x0E, 0x3E, 0x00, 0x1C, 0x00, ##      000   00000            000    
            0x0E, 0x1F, 0x00, 0x1C, 0x00, ##      000    00000           000    
            0x0E, 0x0F, 0x80, 0x1C, 0x00, ##      000     00000          000    
            0x0E, 0x07, 0xC0, 0x1C, 0x00, ##      000      00000         000    
            0x0E, 0x07, 0xC0, 0x1C, 0x00, ##      000      00000         000    
            0x0E, 0x03, 0xE0, 0x1C, 0x00, ##      000       00000        000    
            0x0E, 0x01, 0xF0, 0x1C, 0x00, ##      000        00000       000    
            0x0E, 0x00, 0xF8, 0x1C, 0x00, ##      000         00000      000    
            0x0E, 0x00, 0xFC, 0x1C, 0x00, ##      000         000000     000    
            0x0E, 0x00, 0x7C, 0x1C, 0x00, ##      000          00000     000    
            0x0E, 0x00, 0x3E, 0x1C, 0x00, ##      000           00000    000    
            0x0E, 0x00, 0x1F, 0x1C, 0x00, ##      000            00000   000    
            0x0E, 0x00, 0x1F, 0x9C, 0x00, ##      000            000000  000    
            0x0E, 0x00, 0x0F, 0x9C, 0x00, ##      000             00000  000    
            0x0E, 0x00, 0x07, 0xDC, 0x00, ##      000              00000 000    
            0x0E, 0x00, 0x03, 0xFC, 0x00, ##      000               00000000    
            0x0E, 0x00, 0x03, 0xFC, 0x00, ##      000               00000000    
            0x0E, 0x00, 0x01, 0xFC, 0x00, ##      000                0000000    
            0x0E, 0x00, 0x00, 0xFC, 0x00, ##      000                 000000    
            0x0E, 0x00, 0x00, 0x7C, 0x00, ##      000                  00000    
            0xFF, 0xE0, 0x00, 0x3C, 0x00, ##  00000000000               0000    
            0xFF, 0xE0, 0x00, 0x3C, 0x00, ##  00000000000               0000    
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '210' => {    # 'Ò'
        'width'    => 31, 
        'xoffset'  => 2, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x3C, 0x00, 0x00, ##            0000                 
            0x00, 0x1E, 0x00, 0x00, ##             0000                
            0x00, 0x0F, 0x00, 0x00, ##              0000               
            0x00, 0x07, 0x80, 0x00, ##               0000              
            0x00, 0x03, 0x80, 0x00, ##                000              
            0x00, 0x01, 0xC0, 0x00, ##                 000             
            0x00, 0x00, 0x00, 0x00, ##                                 
            0x00, 0x00, 0x00, 0x00, ##                                 
            0x00, 0x01, 0x00, 0x00, ##                 0               
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000          
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000       
            0x03, 0xE0, 0x0F, 0x80, ##        00000         00000      
            0x07, 0x80, 0x03, 0xC0, ##       0000             0000     
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000    
            0x1E, 0x00, 0x00, 0xF0, ##     0000                 0000   
            0x3E, 0x00, 0x00, 0xF8, ##    00000                 00000  
            0x3C, 0x00, 0x00, 0x78, ##    0000                   0000  
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x78, 0x00, 0x00, 0x3C, ##   0000                     0000 
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0x78, 0x00, 0x00, 0x3C, ##   0000                     0000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x3C, 0x00, 0x00, 0x78, ##    0000                   0000  
            0x3E, 0x00, 0x00, 0xF8, ##    00000                 00000  
            0x1E, 0x00, 0x00, 0xF0, ##     0000                 0000   
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000    
            0x07, 0x80, 0x03, 0xC0, ##       0000             0000     
            0x03, 0xE0, 0x0F, 0x80, ##        00000         00000      
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000       
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '211' => {    # 'Ó'
        'width'    => 31, 
        'xoffset'  => 2, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x00, 0xF8, 0x00, ##                  00000          
            0x00, 0x00, 0xF0, 0x00, ##                  0000           
            0x00, 0x01, 0xE0, 0x00, ##                 0000            
            0x00, 0x03, 0xC0, 0x00, ##                0000             
            0x00, 0x03, 0x00, 0x00, ##                00               
            0x00, 0x06, 0x00, 0x00, ##               00                
            0x00, 0x00, 0x00, 0x00, ##                                 
            0x00, 0x00, 0x00, 0x00, ##                                 
            0x00, 0x01, 0x00, 0x00, ##                 0               
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000          
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000       
            0x03, 0xE0, 0x0F, 0x80, ##        00000         00000      
            0x07, 0x80, 0x03, 0xC0, ##       0000             0000     
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000    
            0x1E, 0x00, 0x00, 0xF0, ##     0000                 0000   
            0x3E, 0x00, 0x00, 0xF8, ##    00000                 00000  
            0x3C, 0x00, 0x00, 0x78, ##    0000                   0000  
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x78, 0x00, 0x00, 0x3C, ##   0000                     0000 
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0x78, 0x00, 0x00, 0x3C, ##   0000                     0000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x3C, 0x00, 0x00, 0x78, ##    0000                   0000  
            0x3E, 0x00, 0x00, 0xF8, ##    00000                 00000  
            0x1E, 0x00, 0x00, 0xF0, ##     0000                 0000   
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000    
            0x07, 0x80, 0x03, 0xC0, ##       0000             0000     
            0x03, 0xE0, 0x0F, 0x80, ##        00000         00000      
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000       
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '212' => {    # 'Ô'
        'width'    => 31, 
        'xoffset'  => 2, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x07, 0xC0, 0x00, ##               00000             
            0x00, 0x0F, 0xE0, 0x00, ##              0000000            
            0x00, 0x1E, 0xF0, 0x00, ##             0000 0000           
            0x00, 0x1C, 0x70, 0x00, ##             000   000           
            0x00, 0x30, 0x18, 0x00, ##            00       00          
            0x00, 0x60, 0x0C, 0x00, ##           00         00         
            0x00, 0x00, 0x00, 0x00, ##                                 
            0x00, 0x00, 0x00, 0x00, ##                                 
            0x00, 0x01, 0x00, 0x00, ##                 0               
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000          
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000       
            0x03, 0xE0, 0x0F, 0x80, ##        00000         00000      
            0x07, 0x80, 0x03, 0xC0, ##       0000             0000     
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000    
            0x1E, 0x00, 0x00, 0xF0, ##     0000                 0000   
            0x3E, 0x00, 0x00, 0xF8, ##    00000                 00000  
            0x3C, 0x00, 0x00, 0x78, ##    0000                   0000  
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x78, 0x00, 0x00, 0x3C, ##   0000                     0000 
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0x78, 0x00, 0x00, 0x3C, ##   0000                     0000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x3C, 0x00, 0x00, 0x78, ##    0000                   0000  
            0x3E, 0x00, 0x00, 0xF8, ##    00000                 00000  
            0x1E, 0x00, 0x00, 0xF0, ##     0000                 0000   
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000    
            0x07, 0x80, 0x03, 0xC0, ##       0000             0000     
            0x03, 0xE0, 0x0F, 0x80, ##        00000         00000      
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000       
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '213' => {    # 'Õ'
        'width'    => 31, 
        'xoffset'  => 2, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x3C, 0x0C, 0x00, ##            0000      00         
            0x00, 0x7F, 0x0C, 0x00, ##           0000000    00         
            0x00, 0x63, 0x9C, 0x00, ##           00   000  000         
            0x00, 0x61, 0xF8, 0x00, ##           00    000000          
            0x00, 0xC0, 0xF0, 0x00, ##          00      0000           
            0x00, 0x00, 0x00, 0x00, ##                                 
            0x00, 0x00, 0x00, 0x00, ##                                 
            0x00, 0x00, 0x00, 0x00, ##                                 
            0x00, 0x01, 0x00, 0x00, ##                 0               
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000          
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000       
            0x03, 0xE0, 0x0F, 0x80, ##        00000         00000      
            0x07, 0x80, 0x03, 0xC0, ##       0000             0000     
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000    
            0x1E, 0x00, 0x00, 0xF0, ##     0000                 0000   
            0x3E, 0x00, 0x00, 0xF8, ##    00000                 00000  
            0x3C, 0x00, 0x00, 0x78, ##    0000                   0000  
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x78, 0x00, 0x00, 0x3C, ##   0000                     0000 
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0x78, 0x00, 0x00, 0x3C, ##   0000                     0000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x3C, 0x00, 0x00, 0x78, ##    0000                   0000  
            0x3E, 0x00, 0x00, 0xF8, ##    00000                 00000  
            0x1E, 0x00, 0x00, 0xF0, ##     0000                 0000   
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000    
            0x07, 0x80, 0x03, 0xC0, ##       0000             0000     
            0x03, 0xE0, 0x0F, 0x80, ##        00000         00000      
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000       
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '214' => {    # 'Ö'
        'width'    => 31, 
        'xoffset'  => 2, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x38, 0x38, 0x00, ##            000     000          
            0x00, 0x7C, 0x7C, 0x00, ##           00000   00000         
            0x00, 0x7C, 0x7C, 0x00, ##           00000   00000         
            0x00, 0x7C, 0x7C, 0x00, ##           00000   00000         
            0x00, 0x38, 0x38, 0x00, ##            000     000          
            0x00, 0x00, 0x00, 0x00, ##                                 
            0x00, 0x00, 0x00, 0x00, ##                                 
            0x00, 0x00, 0x00, 0x00, ##                                 
            0x00, 0x01, 0x00, 0x00, ##                 0               
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000          
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000       
            0x03, 0xE0, 0x0F, 0x80, ##        00000         00000      
            0x07, 0x80, 0x03, 0xC0, ##       0000             0000     
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000    
            0x1E, 0x00, 0x00, 0xF0, ##     0000                 0000   
            0x3E, 0x00, 0x00, 0xF8, ##    00000                 00000  
            0x3C, 0x00, 0x00, 0x78, ##    0000                   0000  
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x78, 0x00, 0x00, 0x3C, ##   0000                     0000 
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0xF8, 0x00, 0x00, 0x3E, ##  00000                     00000
            0x78, 0x00, 0x00, 0x3C, ##   0000                     0000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x7C, 0x00, 0x00, 0x7C, ##   00000                   00000 
            0x3C, 0x00, 0x00, 0x78, ##    0000                   0000  
            0x3E, 0x00, 0x00, 0xF8, ##    00000                 00000  
            0x1E, 0x00, 0x00, 0xF0, ##     0000                 0000   
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000    
            0x07, 0x80, 0x03, 0xC0, ##       0000             0000     
            0x03, 0xE0, 0x0F, 0x80, ##        00000         00000      
            0x01, 0xFF, 0xFF, 0x00, ##         00000000000000000       
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '215' => {    # '×'
        'width'    => 24, 
        'xoffset'  => 6, 
        'xadvance' => 36, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                          
            0x60, 0x00, 0x06, ##   00                  00 
            0xF0, 0x00, 0x0F, ##  0000                0000
            0x78, 0x00, 0x1E, ##   0000              0000 
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x1E, 0x00, 0x78, ##     0000          0000   
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x00, 0xFF, 0x00, ##          00000000        
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0xFF, 0x00, ##          00000000        
            0x01, 0xE7, 0x80, ##         0000  0000       
            0x03, 0xC3, 0xC0, ##        0000    0000      
            0x07, 0x81, 0xE0, ##       0000      0000     
            0x0F, 0x00, 0xF0, ##      0000        0000    
            0x1E, 0x00, 0x78, ##     0000          0000   
            0x3C, 0x00, 0x3C, ##    0000            0000  
            0x78, 0x00, 0x1E, ##   0000              0000 
            0xF0, 0x00, 0x0F, ##  0000                0000
            0x60, 0x00, 0x06, ##   00                  00 
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '216' => {    # 'Ø'
        'width'    => 31, 
        'xoffset'  => 2, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x04, ##                               0 
            0x00, 0x3F, 0xF8, 0x0E, ##            00000000000       000
            0x01, 0xFF, 0xFF, 0x1C, ##         00000000000000000   000 
            0x03, 0xE0, 0x0F, 0xB8, ##        00000         00000 000  
            0x07, 0x80, 0x03, 0xF0, ##       0000             000000   
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000    
            0x1E, 0x00, 0x01, 0xF0, ##     0000                00000   
            0x3E, 0x00, 0x03, 0xF8, ##    00000               0000000  
            0x3C, 0x00, 0x07, 0x78, ##    0000               000 0000  
            0x7C, 0x00, 0x0E, 0x7C, ##   00000              000  00000 
            0x7C, 0x00, 0x1E, 0x7C, ##   00000             0000  00000 
            0x78, 0x00, 0x3C, 0x3C, ##   0000             0000    0000 
            0xF8, 0x00, 0x38, 0x3E, ##  00000             000     00000
            0xF8, 0x00, 0x70, 0x3E, ##  00000            000      00000
            0xF8, 0x00, 0xE0, 0x3E, ##  00000           000       00000
            0xF8, 0x01, 0xC0, 0x3E, ##  00000          000        00000
            0xF8, 0x03, 0x80, 0x3E, ##  00000         000         00000
            0xF8, 0x07, 0x00, 0x3E, ##  00000        000          00000
            0xF8, 0x0E, 0x00, 0x3E, ##  00000       000           00000
            0xF8, 0x1C, 0x00, 0x3E, ##  00000      000            00000
            0xF8, 0x38, 0x00, 0x3E, ##  00000     000             00000
            0x78, 0x70, 0x00, 0x3C, ##   0000    000              0000 
            0x7C, 0xF0, 0x00, 0x7C, ##   00000  0000             00000 
            0x7C, 0xE0, 0x00, 0x7C, ##   00000  000              00000 
            0x3D, 0xC0, 0x00, 0x78, ##    0000 000               0000  
            0x3F, 0x80, 0x00, 0xF8, ##    0000000               00000  
            0x1F, 0x00, 0x00, 0xF0, ##     00000                0000   
            0x0F, 0x00, 0x01, 0xE0, ##      0000               0000    
            0x1F, 0x80, 0x03, 0xC0, ##     000000             0000     
            0x3B, 0xE0, 0x0F, 0x80, ##    000 00000         00000      
            0x71, 0xFF, 0xFF, 0x00, ##   000   00000000000000000       
            0xE0, 0x3F, 0xFC, 0x00, ##  000       000000000000         
            0x40, 0x00, 0x00, 0x00, ##   0                             
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '217' => {    # 'Ù'
        'width'    => 32, 
        'xoffset'  => 2, 
        'xadvance' => 36, 
        'bitmap'   => [ 
            0x00, 0x0E, 0x00, 0x00, ##              000                 
            0x00, 0x07, 0x00, 0x00, ##               000                
            0x00, 0x07, 0x80, 0x00, ##               0000               
            0x00, 0x03, 0x80, 0x00, ##                000               
            0x00, 0x01, 0xC0, 0x00, ##                 000              
            0x00, 0x00, 0xE0, 0x00, ##                  000             
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0xFF, 0xF0, 0x07, 0xFF, ##  000000000000         00000000000
            0xFF, 0xF0, 0x07, 0xFF, ##  000000000000         00000000000
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x80, 0x00, 0xF0, ##      00000               0000    
            0x07, 0x80, 0x00, 0xE0, ##       0000               000     
            0x07, 0x80, 0x00, 0xE0, ##       0000               000     
            0x07, 0xC0, 0x01, 0xE0, ##       00000             0000     
            0x03, 0xF0, 0x07, 0xC0, ##        000000         00000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000        
            0x00, 0x3F, 0xFC, 0x00, ##            000000000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '218' => {    # 'Ú'
        'width'    => 32, 
        'xoffset'  => 2, 
        'xadvance' => 36, 
        'bitmap'   => [ 
            0x00, 0x00, 0x78, 0x00, ##                   0000           
            0x00, 0x00, 0x70, 0x00, ##                   000            
            0x00, 0x00, 0xE0, 0x00, ##                  000             
            0x00, 0x01, 0xC0, 0x00, ##                 000              
            0x00, 0x01, 0x80, 0x00, ##                 00               
            0x00, 0x03, 0x00, 0x00, ##                00                
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0xFF, 0xF0, 0x07, 0xFF, ##  000000000000         00000000000
            0xFF, 0xF0, 0x07, 0xFF, ##  000000000000         00000000000
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x80, 0x00, 0xF0, ##      00000               0000    
            0x07, 0x80, 0x00, 0xE0, ##       0000               000     
            0x07, 0x80, 0x00, 0xE0, ##       0000               000     
            0x07, 0xC0, 0x01, 0xE0, ##       00000             0000     
            0x03, 0xF0, 0x07, 0xC0, ##        000000         00000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000        
            0x00, 0x3F, 0xFC, 0x00, ##            000000000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '219' => {    # 'Û'
        'width'    => 32, 
        'xoffset'  => 2, 
        'xadvance' => 36, 
        'bitmap'   => [ 
            0x00, 0x03, 0xE0, 0x00, ##                00000             
            0x00, 0x07, 0xE0, 0x00, ##               000000             
            0x00, 0x07, 0x70, 0x00, ##               000 000            
            0x00, 0x0E, 0x38, 0x00, ##              000   000           
            0x00, 0x1C, 0x1C, 0x00, ##             000     000          
            0x00, 0x30, 0x06, 0x00, ##            00         00         
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0xFF, 0xF0, 0x07, 0xFF, ##  000000000000         00000000000
            0xFF, 0xF0, 0x07, 0xFF, ##  000000000000         00000000000
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x80, 0x00, 0xF0, ##      00000               0000    
            0x07, 0x80, 0x00, 0xE0, ##       0000               000     
            0x07, 0x80, 0x00, 0xE0, ##       0000               000     
            0x07, 0xC0, 0x01, 0xE0, ##       00000             0000     
            0x03, 0xF0, 0x07, 0xC0, ##        000000         00000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000        
            0x00, 0x3F, 0xFC, 0x00, ##            000000000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '220' => {    # 'Ü'
        'width'    => 32, 
        'xoffset'  => 2, 
        'xadvance' => 36, 
        'bitmap'   => [ 
            0x00, 0x1C, 0x0E, 0x00, ##             000      000         
            0x00, 0x3E, 0x1F, 0x00, ##            00000    00000        
            0x00, 0x3E, 0x1F, 0x00, ##            00000    00000        
            0x00, 0x3E, 0x1F, 0x00, ##            00000    00000        
            0x00, 0x1C, 0x0E, 0x00, ##             000      000         
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0xFF, 0xF0, 0x07, 0xFF, ##  000000000000         00000000000
            0xFF, 0xF0, 0x07, 0xFF, ##  000000000000         00000000000
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x00, 0x00, 0x70, ##      0000                 000    
            0x0F, 0x80, 0x00, 0xF0, ##      00000               0000    
            0x07, 0x80, 0x00, 0xE0, ##       0000               000     
            0x07, 0x80, 0x00, 0xE0, ##       0000               000     
            0x07, 0xC0, 0x01, 0xE0, ##       00000             0000     
            0x03, 0xF0, 0x07, 0xC0, ##        000000         00000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0xFF, 0xFF, 0x00, ##          0000000000000000        
            0x00, 0x3F, 0xFC, 0x00, ##            000000000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '221' => {    # 'Ý'
        'width'    => 29, 
        'xoffset'  => 0, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, 0xF0, 0x00, ##                  0000         
            0x00, 0x01, 0xE0, 0x00, ##                 0000          
            0x00, 0x01, 0xC0, 0x00, ##                 000           
            0x00, 0x03, 0x80, 0x00, ##                000            
            0x00, 0x07, 0x00, 0x00, ##               000             
            0x00, 0x06, 0x00, 0x00, ##               00              
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0xFF, 0xF0, 0x0F, 0xF8, ##  000000000000        000000000
            0xFF, 0xF0, 0x0F, 0xF8, ##  000000000000        000000000
            0x1F, 0x80, 0x01, 0xC0, ##     000000              000   
            0x0F, 0x80, 0x01, 0x80, ##      00000              00    
            0x07, 0xC0, 0x03, 0x80, ##       00000            000    
            0x07, 0xC0, 0x03, 0x00, ##       00000            00     
            0x03, 0xE0, 0x06, 0x00, ##        00000          00      
            0x01, 0xF0, 0x0E, 0x00, ##         00000        000      
            0x01, 0xF0, 0x0C, 0x00, ##         00000        00       
            0x00, 0xF8, 0x1C, 0x00, ##          00000      000       
            0x00, 0xF8, 0x18, 0x00, ##          00000      00        
            0x00, 0x7C, 0x30, 0x00, ##           00000    00         
            0x00, 0x3E, 0x70, 0x00, ##            00000  000         
            0x00, 0x3E, 0x60, 0x00, ##            00000  00          
            0x00, 0x1F, 0xE0, 0x00, ##             00000000          
            0x00, 0x0F, 0xC0, 0x00, ##              000000           
            0x00, 0x0F, 0x80, 0x00, ##              00000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x07, 0x80, 0x00, ##               0000            
            0x00, 0x7F, 0xF8, 0x00, ##           000000000000        
            0x00, 0x7F, 0xF8, 0x00, ##           000000000000        
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '222' => {    # 'Þ'
        'width'    => 25, 
        'xoffset'  => 2, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xF8, 0x00, 0x00, ##  0000000000000            
            0xFF, 0xF8, 0x00, 0x00, ##  0000000000000            
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0xFF, 0xE0, 0x00, ##      000000000000000      
            0x0F, 0xFF, 0xF8, 0x00, ##      00000000000000000    
            0x0F, 0x80, 0x7E, 0x00, ##      00000        000000  
            0x0F, 0x80, 0x3E, 0x00, ##      00000         00000  
            0x0F, 0x80, 0x1F, 0x00, ##      00000          00000 
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000
            0x0F, 0x80, 0x0F, 0x80, ##      00000           00000
            0x0F, 0x80, 0x1F, 0x00, ##      00000          00000 
            0x0F, 0x80, 0x3E, 0x00, ##      00000         00000  
            0x0F, 0x80, 0x7E, 0x00, ##      00000        000000  
            0x0F, 0xFF, 0xF8, 0x00, ##      00000000000000000    
            0x0F, 0xFF, 0xE0, 0x00, ##      000000000000000      
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0x0F, 0x80, 0x00, 0x00, ##      00000                
            0xFF, 0xF8, 0x00, 0x00, ##  0000000000000            
            0xFF, 0xF8, 0x00, 0x00, ##  0000000000000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '223' => {    # 'ß'
        'width'    => 25, 
        'xoffset'  => 2, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x7F, 0x00, 0x00, ##           0000000         
            0x03, 0xFF, 0xE0, 0x00, ##        0000000000000      
            0x07, 0xC1, 0xF0, 0x00, ##       00000     00000     
            0x0F, 0x00, 0x78, 0x00, ##      0000         0000    
            0x0F, 0x00, 0x78, 0x00, ##      0000         0000    
            0x1E, 0x00, 0x3C, 0x00, ##     0000           0000   
            0x1E, 0x00, 0x3C, 0x00, ##     0000           0000   
            0x1E, 0x00, 0x7C, 0x00, ##     0000          00000   
            0x1E, 0x03, 0xFC, 0x00, ##     0000       00000000   
            0x1E, 0x07, 0xC0, 0x00, ##     0000      00000       
            0x1E, 0x0F, 0x00, 0x00, ##     0000     0000         
            0x1E, 0x1E, 0x00, 0x00, ##     0000    0000          
            0x1E, 0x1E, 0x00, 0x00, ##     0000    0000          
            0x1E, 0x1E, 0x00, 0x00, ##     0000    0000          
            0x1E, 0x1E, 0x00, 0x00, ##     0000    0000          
            0x1E, 0x1F, 0x00, 0x00, ##     0000    00000         
            0x1E, 0x0F, 0x80, 0x00, ##     0000     00000        
            0x1E, 0x0F, 0xE0, 0x00, ##     0000     0000000      
            0x1E, 0x07, 0xF0, 0x00, ##     0000      0000000     
            0x1E, 0x01, 0xF8, 0x00, ##     0000        000000    
            0x1E, 0x00, 0xFE, 0x00, ##     0000         0000000  
            0x1E, 0x00, 0x3E, 0x00, ##     0000           00000  
            0x1E, 0x00, 0x1F, 0x00, ##     0000            00000 
            0x1E, 0x00, 0x0F, 0x80, ##     0000             00000
            0x1E, 0x00, 0x07, 0x80, ##     0000              0000
            0x1E, 0x00, 0x07, 0x80, ##     0000              0000
            0x1E, 0x00, 0x07, 0x80, ##     0000              0000
            0x1E, 0x60, 0x07, 0x80, ##     0000  00          0000
            0x1E, 0x60, 0x07, 0x80, ##     0000  00          0000
            0x1E, 0x60, 0x0F, 0x00, ##     0000  00         0000 
            0x1E, 0x70, 0x1E, 0x00, ##     0000  000       0000  
            0xFE, 0x7F, 0xFC, 0x00, ##  0000000  0000000000000   
            0xFE, 0x3F, 0xF8, 0x00, ##  0000000   00000000000    
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '224' => {    # 'à'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x1F, 0x00, 0x00, ##     00000              
            0x0F, 0x00, 0x00, ##      0000              
            0x07, 0x80, 0x00, ##       0000             
            0x03, 0xC0, 0x00, ##        0000            
            0x01, 0xC0, 0x00, ##         000            
            0x00, 0xE0, 0x00, ##          000           
            0x00, 0x60, 0x00, ##           00           
            0x00, 0x30, 0x00, ##            00          
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x0F, 0xFE, 0x00, ##      00000000000       
            0x3F, 0xFF, 0x00, ##    00000000000000      
            0x3C, 0x07, 0x80, ##    0000       0000     
            0x38, 0x03, 0xC0, ##    000         0000    
            0x30, 0x01, 0xC0, ##    00           000    
            0x00, 0x01, 0xE0, ##                 0000   
            0x00, 0x01, 0xE0, ##                 0000   
            0x00, 0x01, 0xE0, ##                 0000   
            0x07, 0xFF, 0xE0, ##       00000000000000   
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x3F, 0x01, 0xE0, ##    000000       0000   
            0x7C, 0x01, 0xE0, ##   00000         0000   
            0xFC, 0x01, 0xE0, ##  000000         0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x03, 0xE0, ##  00000         00000   
            0x7C, 0x03, 0xE0, ##   00000        00000   
            0x7E, 0x07, 0xE0, ##   000000      000000   
            0x3F, 0xFD, 0xFC, ##    000000000000 0000000
            0x0F, 0xF9, 0xFC, ##      000000000  0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '225' => {    # 'á'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0x80, ##               0000     
            0x00, 0x0F, 0x00, ##              0000      
            0x00, 0x0E, 0x00, ##              000       
            0x00, 0x1C, 0x00, ##             000        
            0x00, 0x3C, 0x00, ##            0000        
            0x00, 0x38, 0x00, ##            000         
            0x00, 0x70, 0x00, ##           000          
            0x00, 0xE0, 0x00, ##          000           
            0x00, 0xC0, 0x00, ##          00            
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x0F, 0xFE, 0x00, ##      00000000000       
            0x3F, 0xFF, 0x00, ##    00000000000000      
            0x3C, 0x07, 0x80, ##    0000       0000     
            0x38, 0x03, 0xC0, ##    000         0000    
            0x38, 0x01, 0xC0, ##    000          000    
            0x00, 0x01, 0xE0, ##                 0000   
            0x00, 0x01, 0xE0, ##                 0000   
            0x00, 0x01, 0xE0, ##                 0000   
            0x07, 0xFF, 0xE0, ##       00000000000000   
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x3F, 0x01, 0xE0, ##    000000       0000   
            0x7C, 0x01, 0xE0, ##   00000         0000   
            0xFC, 0x01, 0xE0, ##  000000         0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x03, 0xE0, ##  00000         00000   
            0x7C, 0x03, 0xE0, ##   00000        00000   
            0x7E, 0x07, 0xE0, ##   000000      000000   
            0x3F, 0xFD, 0xFC, ##    000000000000 0000000
            0x0F, 0xF9, 0xFC, ##      000000000  0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '226' => {    # 'â'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xF0, 0x00, ##          0000          
            0x00, 0xF0, 0x00, ##          0000          
            0x01, 0xF8, 0x00, ##         000000         
            0x01, 0xDC, 0x00, ##         000 000        
            0x03, 0x9C, 0x00, ##        000  000        
            0x07, 0x0E, 0x00, ##       000    000       
            0x07, 0x06, 0x00, ##       000     00       
            0x0E, 0x07, 0x00, ##      000      000      
            0x0C, 0x03, 0x80, ##      00        000     
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x0F, 0xFE, 0x00, ##      00000000000       
            0x3F, 0xFF, 0x00, ##    00000000000000      
            0x3C, 0x07, 0x80, ##    0000       0000     
            0x38, 0x03, 0xC0, ##    000         0000    
            0x38, 0x01, 0xC0, ##    000          000    
            0x00, 0x01, 0xE0, ##                 0000   
            0x00, 0x01, 0xE0, ##                 0000   
            0x00, 0x01, 0xE0, ##                 0000   
            0x07, 0xFF, 0xE0, ##       00000000000000   
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x3F, 0x01, 0xE0, ##    000000       0000   
            0x7C, 0x01, 0xE0, ##   00000         0000   
            0xFC, 0x01, 0xE0, ##  000000         0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x03, 0xE0, ##  00000         00000   
            0x7C, 0x03, 0xE0, ##   00000        00000   
            0x7E, 0x07, 0xE0, ##   000000      000000   
            0x3F, 0xFD, 0xFC, ##    000000000000 0000000
            0x0F, 0xF9, 0xFC, ##      000000000  0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '227' => {    # 'ã'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0x81, 0x80, ##       0000      00     
            0x0F, 0xE1, 0x80, ##      0000000    00     
            0x1C, 0xF3, 0x80, ##     000  0000  000     
            0x18, 0x7F, 0x00, ##     00    0000000      
            0x18, 0x1E, 0x00, ##     00      0000       
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x0F, 0xFE, 0x00, ##      00000000000       
            0x3F, 0xFF, 0x00, ##    00000000000000      
            0x3C, 0x07, 0x80, ##    0000       0000     
            0x38, 0x03, 0xC0, ##    000         0000    
            0x30, 0x01, 0xC0, ##    00           000    
            0x00, 0x01, 0xE0, ##                 0000   
            0x00, 0x01, 0xE0, ##                 0000   
            0x00, 0x01, 0xE0, ##                 0000   
            0x07, 0xFF, 0xE0, ##       00000000000000   
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x3F, 0x01, 0xE0, ##    000000       0000   
            0x7C, 0x01, 0xE0, ##   00000         0000   
            0xFC, 0x01, 0xE0, ##  000000         0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x03, 0xE0, ##  00000         00000   
            0x7C, 0x03, 0xE0, ##   00000        00000   
            0x7E, 0x07, 0xE0, ##   000000      000000   
            0x3F, 0xFD, 0xFC, ##    000000000000 0000000
            0x0F, 0xF9, 0xFC, ##      000000000  0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '228' => {    # 'ä'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0E, 0x0E, 0x00, ##      000     000       
            0x1F, 0x1F, 0x00, ##     00000   00000      
            0x1F, 0x1F, 0x00, ##     00000   00000      
            0x1F, 0x1F, 0x00, ##     00000   00000      
            0x0E, 0x0E, 0x00, ##      000     000       
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x1F, 0xFE, 0x00, ##     000000000000       
            0x3F, 0xFF, 0x00, ##    00000000000000      
            0x3C, 0x07, 0x80, ##    0000       0000     
            0x38, 0x03, 0xC0, ##    000         0000    
            0x30, 0x01, 0xC0, ##    00           000    
            0x00, 0x01, 0xE0, ##                 0000   
            0x00, 0x01, 0xE0, ##                 0000   
            0x00, 0x01, 0xE0, ##                 0000   
            0x07, 0xFF, 0xE0, ##       00000000000000   
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x3F, 0x01, 0xE0, ##    000000       0000   
            0x7C, 0x01, 0xE0, ##   00000         0000   
            0xFC, 0x01, 0xE0, ##  000000         0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x03, 0xE0, ##  00000         00000   
            0x7C, 0x03, 0xE0, ##   00000        00000   
            0x7E, 0x07, 0xE0, ##   000000      000000   
            0x3F, 0xFD, 0xFC, ##    000000000000 0000000
            0x0F, 0xF9, 0xFC, ##      000000000  0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '229' => {    # 'å'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xF8, 0x00, ##         000000         
            0x03, 0xFC, 0x00, ##        00000000        
            0x07, 0x0E, 0x00, ##       000    000       
            0x0F, 0x0F, 0x00, ##      0000    0000      
            0x0E, 0x07, 0x00, ##      000      000      
            0x0E, 0x07, 0x00, ##      000      000      
            0x0E, 0x07, 0x00, ##      000      000      
            0x0E, 0x0F, 0x00, ##      000     0000      
            0x07, 0x0E, 0x00, ##       000    000       
            0x03, 0xFC, 0x00, ##        00000000        
            0x01, 0xF8, 0x00, ##         000000         
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x0F, 0xFE, 0x00, ##      00000000000       
            0x3F, 0xFF, 0x00, ##    00000000000000      
            0x38, 0x07, 0x80, ##    000        0000     
            0x30, 0x03, 0xC0, ##    00          0000    
            0x30, 0x01, 0xC0, ##    00           000    
            0x00, 0x01, 0xE0, ##                 0000   
            0x00, 0x01, 0xE0, ##                 0000   
            0x00, 0x01, 0xE0, ##                 0000   
            0x07, 0xFF, 0xE0, ##       00000000000000   
            0x1F, 0xFF, 0xE0, ##     0000000000000000   
            0x3F, 0x01, 0xE0, ##    000000       0000   
            0x7C, 0x01, 0xE0, ##   00000         0000   
            0xFC, 0x01, 0xE0, ##  000000         0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x01, 0xE0, ##  00000          0000   
            0xF8, 0x03, 0xE0, ##  00000         00000   
            0x7C, 0x03, 0xE0, ##   00000        00000   
            0x7E, 0x07, 0xE0, ##   000000      000000   
            0x3F, 0xFD, 0xFC, ##    000000000000 0000000
            0x0F, 0xF9, 0xFC, ##      000000000  0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '230' => {    # 'æ'
        'width'    => 36, 
        'xoffset'  => 2, 
        'xadvance' => 40, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x0F, 0xFE, 0x07, 0xFE, 0x00, ##      00000000000      0000000000     
            0x3F, 0xFF, 0x1F, 0xFF, 0x00, ##    00000000000000   0000000000000    
            0x3C, 0x07, 0xBE, 0x07, 0x80, ##    0000       0000 00000      0000   
            0x38, 0x03, 0xFC, 0x03, 0xC0, ##    000         00000000        0000  
            0x38, 0x01, 0xF8, 0x03, 0xE0, ##    000          000000         00000 
            0x00, 0x01, 0xF8, 0x01, 0xE0, ##                 000000          0000 
            0x00, 0x01, 0xF0, 0x01, 0xE0, ##                 00000           0000 
            0x00, 0x01, 0xF0, 0x01, 0xF0, ##                 00000           00000
            0x07, 0xFF, 0xF0, 0x01, 0xF0, ##       000000000000000           00000
            0x1F, 0xFF, 0xFF, 0xFF, 0xF0, ##     000000000000000000000000000000000
            0x3F, 0x01, 0xFF, 0xFF, 0xF0, ##    000000       000000000000000000000
            0x7C, 0x01, 0xF0, 0x00, 0x00, ##   00000         00000                
            0xFC, 0x01, 0xF0, 0x00, 0x00, ##  000000         00000                
            0xF8, 0x01, 0xF0, 0x00, 0x00, ##  00000          00000                
            0xF8, 0x01, 0xF0, 0x00, 0x00, ##  00000          00000                
            0xF8, 0x01, 0xF0, 0x00, 0xF0, ##  00000          00000            0000
            0xF8, 0x01, 0xF8, 0x00, 0xE0, ##  00000          000000           000 
            0xF8, 0x03, 0xF8, 0x01, 0xE0, ##  00000         0000000          0000 
            0x7C, 0x03, 0xFC, 0x01, 0xC0, ##   00000        00000000         000  
            0x7E, 0x07, 0x3E, 0x03, 0x80, ##   000000      000  00000       000   
            0x3F, 0xFE, 0x1F, 0xFF, 0x00, ##    0000000000000    0000000000000    
            0x0F, 0xFC, 0x07, 0xFE, 0x00, ##      0000000000       0000000000     
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '231' => {    # 'ç'
        'width'    => 20, 
        'xoffset'  => 2, 
        'xadvance' => 24, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                      
            0x03, 0xFF, 0x80, ##        00000000000   
            0x0F, 0xFF, 0xE0, ##      000000000000000 
            0x1F, 0x01, 0xE0, ##     00000       0000 
            0x3E, 0x00, 0xE0, ##    00000         000 
            0x3C, 0x00, 0xE0, ##    0000          000 
            0x7C, 0x00, 0x60, ##   00000           00 
            0x78, 0x00, 0x60, ##   0000            00 
            0xF8, 0x00, 0x00, ##  00000               
            0xF8, 0x00, 0x00, ##  00000               
            0xF8, 0x00, 0x00, ##  00000               
            0xF8, 0x00, 0x00, ##  00000               
            0xF8, 0x00, 0x00, ##  00000               
            0xF8, 0x00, 0x00, ##  00000               
            0xF8, 0x00, 0x00, ##  00000               
            0xF8, 0x00, 0x00, ##  00000               
            0x78, 0x00, 0x70, ##   0000            000
            0x7C, 0x00, 0x60, ##   00000           00 
            0x3C, 0x00, 0xE0, ##    0000          000 
            0x3E, 0x00, 0xE0, ##    00000         000 
            0x1F, 0x01, 0xC0, ##     00000       000  
            0x0F, 0xFF, 0x80, ##      0000000000000   
            0x03, 0xFE, 0x00, ##        000000000     
            0x00, 0x38, 0x00, ##            000       
            0x00, 0x1C, 0x00, ##             000      
            0x00, 0x0C, 0x00, ##              00      
            0x00, 0x0E, 0x00, ##              000     
            0x00, 0x0E, 0x00, ##              000     
            0x02, 0x1E, 0x00, ##        0    0000     
            0x03, 0xFC, 0x00, ##        00000000      
            0x03, 0xF8, 0x00, ##        0000000       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '232' => {    # 'è'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0x00, 0x00, ##      0000             
            0x07, 0x00, 0x00, ##       000             
            0x07, 0x80, 0x00, ##       0000            
            0x03, 0xC0, 0x00, ##        0000           
            0x01, 0xC0, 0x00, ##         000           
            0x00, 0xE0, 0x00, ##          000          
            0x00, 0x70, 0x00, ##           000         
            0x00, 0x30, 0x00, ##            00         
            0x00, 0x18, 0x00, ##             00        
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x03, 0xFF, 0x00, ##        0000000000     
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0x03, 0xC0, ##     00000      0000   
            0x3E, 0x01, 0xE0, ##    00000        0000  
            0x3C, 0x01, 0xF0, ##    0000         00000 
            0x7C, 0x00, 0xF0, ##   00000          0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xF8, 0x00, 0x00, ##  00000                
            0xF8, 0x00, 0x00, ##  00000                
            0xF8, 0x00, 0x00, ##  00000                
            0xF8, 0x00, 0x00, ##  00000                
            0x78, 0x00, 0x78, ##   0000            0000
            0x7C, 0x00, 0x70, ##   00000           000 
            0x3C, 0x00, 0xF0, ##    0000          0000 
            0x3E, 0x00, 0xE0, ##    00000         000  
            0x1F, 0x01, 0xE0, ##     00000       0000  
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x03, 0xFF, 0x00, ##        0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '233' => {    # 'é'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0x80, ##               0000    
            0x00, 0x07, 0x00, ##               000     
            0x00, 0x0F, 0x00, ##              0000     
            0x00, 0x1E, 0x00, ##             0000      
            0x00, 0x1C, 0x00, ##             000       
            0x00, 0x38, 0x00, ##            000        
            0x00, 0x70, 0x00, ##           000         
            0x00, 0x60, 0x00, ##           00          
            0x00, 0xE0, 0x00, ##          000          
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x03, 0xFF, 0x00, ##        0000000000     
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0x03, 0xC0, ##     00000      0000   
            0x3E, 0x01, 0xE0, ##    00000        0000  
            0x3C, 0x01, 0xF0, ##    0000         00000 
            0x7C, 0x00, 0xF0, ##   00000          0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xF8, 0x00, 0x00, ##  00000                
            0xF8, 0x00, 0x00, ##  00000                
            0xF8, 0x00, 0x00, ##  00000                
            0xF8, 0x00, 0x00, ##  00000                
            0x78, 0x00, 0x78, ##   0000            0000
            0x7C, 0x00, 0x70, ##   00000           000 
            0x3C, 0x00, 0xF0, ##    0000          0000 
            0x3E, 0x00, 0xE0, ##    00000         000  
            0x1F, 0x01, 0xE0, ##     00000       0000  
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x03, 0xFF, 0x00, ##        0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '234' => {    # 'ê'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x70, 0x00, ##           000         
            0x00, 0xF8, 0x00, ##          00000        
            0x00, 0xF8, 0x00, ##          00000        
            0x01, 0xDC, 0x00, ##         000 000       
            0x01, 0x8C, 0x00, ##         00   00       
            0x03, 0x8E, 0x00, ##        000   000      
            0x07, 0x07, 0x00, ##       000     000     
            0x06, 0x03, 0x00, ##       00       00     
            0x0E, 0x03, 0x80, ##      000       000    
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x03, 0xFF, 0x00, ##        0000000000     
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0x03, 0xC0, ##     00000      0000   
            0x3E, 0x01, 0xE0, ##    00000        0000  
            0x3C, 0x01, 0xF0, ##    0000         00000 
            0x7C, 0x00, 0xF0, ##   00000          0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xF8, 0x00, 0x00, ##  00000                
            0xF8, 0x00, 0x00, ##  00000                
            0xF8, 0x00, 0x00, ##  00000                
            0xF8, 0x00, 0x00, ##  00000                
            0x78, 0x00, 0x78, ##   0000            0000
            0x7C, 0x00, 0x70, ##   00000           000 
            0x3C, 0x00, 0xF0, ##    0000          0000 
            0x3E, 0x00, 0xE0, ##    00000         000  
            0x1F, 0x01, 0xE0, ##     00000       0000  
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x03, 0xFF, 0x00, ##        0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '235' => {    # 'ë'
        'width'    => 21, 
        'xoffset'  => 2, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0x07, 0x00, ##       000     000     
            0x0F, 0x8F, 0x80, ##      00000   00000    
            0x0F, 0x8F, 0x80, ##      00000   00000    
            0x0F, 0x8F, 0x80, ##      00000   00000    
            0x07, 0x07, 0x00, ##       000     000     
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##                       
            0x03, 0xFF, 0x00, ##        0000000000     
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x1F, 0x03, 0xC0, ##     00000      0000   
            0x3E, 0x01, 0xE0, ##    00000        0000  
            0x3C, 0x01, 0xF0, ##    0000         00000 
            0x7C, 0x00, 0xF0, ##   00000          0000 
            0x78, 0x00, 0xF0, ##   0000           0000 
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xF8, 0x00, 0xF8, ##  00000           00000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xFF, 0xFF, 0xF8, ##  000000000000000000000
            0xF8, 0x00, 0x00, ##  00000                
            0xF8, 0x00, 0x00, ##  00000                
            0xF8, 0x00, 0x00, ##  00000                
            0xF8, 0x00, 0x00, ##  00000                
            0x78, 0x00, 0x78, ##   0000            0000
            0x7C, 0x00, 0x70, ##   00000           000 
            0x3C, 0x00, 0x70, ##    0000           000 
            0x3E, 0x00, 0xE0, ##    00000         000  
            0x1F, 0x01, 0xE0, ##     00000       0000  
            0x0F, 0xFF, 0x80, ##      0000000000000    
            0x03, 0xFF, 0x00, ##        0000000000     
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '236' => {    # 'ì'
        'width'    => 13, 
        'xoffset'  => 0, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xF0, 0x00, ##  0000         
            0x78, 0x00, ##   0000        
            0x3C, 0x00, ##    0000       
            0x1E, 0x00, ##     0000      
            0x0E, 0x00, ##      000      
            0x07, 0x00, ##       000     
            0x03, 0x80, ##        000    
            0x01, 0x80, ##         00    
            0x00, 0xC0, ##          00   
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x3F, 0xC0, ##    00000000   
            0x3F, 0xC0, ##    00000000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x03, 0xC0, ##        0000   
            0x3F, 0xF8, ##    00000000000
            0x3F, 0xF8, ##    00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '237' => {    # 'í'
        'width'    => 12, 
        'xoffset'  => 2, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x70, ##           000
            0x00, 0xE0, ##          000 
            0x01, 0xE0, ##         0000 
            0x03, 0xC0, ##        0000  
            0x03, 0x80, ##        000   
            0x07, 0x00, ##       000    
            0x0E, 0x00, ##      000     
            0x0C, 0x00, ##      00      
            0x1C, 0x00, ##     000      
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0x00, 0x00, ##              
            0xFF, 0x00, ##  00000000    
            0xFF, 0x00, ##  00000000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0x0F, 0x00, ##      0000    
            0xFF, 0xE0, ##  00000000000 
            0xFF, 0xE0, ##  00000000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '238' => {    # 'î'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 14, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x07, 0x80, ##       0000    
            0x0F, 0x80, ##      00000    
            0x0F, 0xC0, ##      000000   
            0x1D, 0xC0, ##     000 000   
            0x38, 0xE0, ##    000   000  
            0x38, 0x60, ##    000    00  
            0x70, 0x70, ##   000     000 
            0xE0, 0x30, ##  000       00 
            0xC0, 0x18, ##  00         00
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x7F, 0x80, ##   00000000    
            0x7F, 0x80, ##   00000000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x7F, 0xF0, ##   00000000000 
            0x7F, 0xF0, ##   00000000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '239' => {    # 'ï'
        'width'    => 13, 
        'xoffset'  => 1, 
        'xadvance' => 15, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x70, 0x70, ##   000     000 
            0xF8, 0xF8, ##  00000   00000
            0xF8, 0xF8, ##  00000   00000
            0xF8, 0xF8, ##  00000   00000
            0x70, 0x70, ##   000     000 
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x00, 0x00, ##               
            0x7F, 0x80, ##   00000000    
            0x7F, 0x80, ##   00000000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x07, 0x80, ##       0000    
            0x7F, 0xF0, ##   00000000000 
            0x7F, 0xF0, ##   00000000000 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '240' => {    # 'ð'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x08, 0x00, 0x00, ##      0                 
            0x0F, 0x00, 0x20, ##      0000          0   
            0x07, 0xC0, 0xF0, ##       00000      0000  
            0x01, 0xE3, 0xC0, ##         0000   0000    
            0x00, 0x7F, 0x00, ##           0000000      
            0x00, 0x3C, 0x00, ##            0000        
            0x00, 0xFE, 0x00, ##          0000000       
            0x03, 0xCF, 0x00, ##        0000  0000      
            0x0F, 0x07, 0x80, ##      0000     0000     
            0x04, 0x07, 0xC0, ##       0       00000    
            0x00, 0x03, 0xC0, ##                0000    
            0x01, 0xFF, 0xE0, ##         000000000000   
            0x07, 0xFF, 0xF0, ##       000000000000000  
            0x0F, 0x81, 0xF0, ##      00000      00000  
            0x1E, 0x00, 0xF8, ##     0000         00000 
            0x3C, 0x00, 0xF8, ##    0000          00000 
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x7C, 0x00, 0xFC, ##   00000          000000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x78, 0x00, 0xF8, ##   0000           00000 
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x03, 0xFF, 0x00, ##        0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '241' => {    # 'ñ'
        'width'    => 25, 
        'xoffset'  => 2, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x01, 0xE0, 0x60, 0x00, ##         0000      00      
            0x03, 0xF8, 0x60, 0x00, ##        0000000    00      
            0x07, 0x3C, 0xE0, 0x00, ##       000  0000  000      
            0x06, 0x1F, 0xC0, 0x00, ##       00    0000000       
            0x06, 0x07, 0x80, 0x00, ##       00      0000        
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0xFE, 0x3F, 0xC0, 0x00, ##  0000000   00000000       
            0xFE, 0x7F, 0xE0, 0x00, ##  0000000  0000000000      
            0xFE, 0xFF, 0xF0, 0x00, ##  0000000 000000000000     
            0x1F, 0x80, 0xF0, 0x00, ##     000000       0000     
            0x1F, 0x00, 0xF8, 0x00, ##     00000        00000    
            0x1F, 0x00, 0x78, 0x00, ##     00000         0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0xFF, 0xE3, 0xFF, 0x80, ##  00000000000   00000000000
            0xFF, 0xE3, 0xFF, 0x80, ##  00000000000   00000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '242' => {    # 'ò'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x0F, 0x00, 0x00, ##      0000              
            0x07, 0x80, 0x00, ##       0000             
            0x03, 0x80, 0x00, ##        000             
            0x01, 0xC0, 0x00, ##         000            
            0x01, 0xE0, 0x00, ##         0000           
            0x00, 0xE0, 0x00, ##          000           
            0x00, 0x70, 0x00, ##           000          
            0x00, 0x38, 0x00, ##            000         
            0x00, 0x18, 0x00, ##             00         
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x00, ##        0000000000      
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x03, 0xFF, 0x00, ##        0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '243' => {    # 'ó'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xC0, ##                0000    
            0x00, 0x07, 0x80, ##               0000     
            0x00, 0x0F, 0x00, ##              0000      
            0x00, 0x0E, 0x00, ##              000       
            0x00, 0x1C, 0x00, ##             000        
            0x00, 0x1C, 0x00, ##             000        
            0x00, 0x38, 0x00, ##            000         
            0x00, 0x70, 0x00, ##           000          
            0x00, 0x60, 0x00, ##           00           
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x00, ##        0000000000      
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x03, 0xFF, 0x00, ##        0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '244' => {    # 'ô'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0x78, 0x00, ##           0000         
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x01, 0xCE, 0x00, ##         000  000       
            0x03, 0x87, 0x00, ##        000    000      
            0x03, 0x03, 0x00, ##        00      00      
            0x07, 0x03, 0x80, ##       000      000     
            0x06, 0x01, 0x80, ##       00        00     
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x00, ##        0000000000      
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x03, 0xFF, 0x00, ##        0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '245' => {    # 'õ'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xC0, 0xC0, ##        0000      00    
            0x07, 0xF0, 0xC0, ##       0000000    00    
            0x0E, 0x79, 0xC0, ##      000  0000  000    
            0x0C, 0x3F, 0x80, ##      00    0000000     
            0x0C, 0x0F, 0x00, ##      00      0000      
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x00, ##        0000000000      
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x03, 0xFF, 0x00, ##        0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '246' => {    # 'ö'
        'width'    => 22, 
        'xoffset'  => 2, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x07, 0x07, 0x00, ##       000     000      
            0x0F, 0x8F, 0x80, ##      00000   00000     
            0x0F, 0x8F, 0x80, ##      00000   00000     
            0x0F, 0x8F, 0x80, ##      00000   00000     
            0x07, 0x07, 0x00, ##       000     000      
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x00, 0x00, 0x00, ##                        
            0x03, 0xFF, 0x00, ##        0000000000      
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x78, 0x00, 0x78, ##   0000            0000 
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0xF8, 0x00, 0x7C, ##  00000            00000
            0x78, 0x00, 0x78, ##   0000            0000 
            0x7C, 0x00, 0xF8, ##   00000          00000 
            0x3C, 0x00, 0xF0, ##    0000          0000  
            0x3E, 0x01, 0xF0, ##    00000        00000  
            0x1F, 0x03, 0xE0, ##     00000      00000   
            0x0F, 0xFF, 0xC0, ##      00000000000000    
            0x03, 0xFF, 0x00, ##        0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '247' => {    # '÷'
        'width'    => 27, 
        'xoffset'  => 5, 
        'xadvance' => 37, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x1F, 0x00, 0x00, ##             00000           
            0x00, 0x1F, 0x00, 0x00, ##             00000           
            0x00, 0x1F, 0x00, 0x00, ##             00000           
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x1F, 0x00, 0x00, ##             00000           
            0x00, 0x1F, 0x00, 0x00, ##             00000           
            0x00, 0x1F, 0x00, 0x00, ##             00000           
            0x00, 0x0E, 0x00, 0x00, ##              000            
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '248' => {    # 'ø'
        'width'    => 23, 
        'xoffset'  => 1, 
        'xadvance' => 26, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x04, ##                       0 
            0x00, 0x00, 0x0E, ##                      000
            0x01, 0xFF, 0x9E, ##         0000000000  0000
            0x07, 0xFF, 0xFC, ##       00000000000000000 
            0x0F, 0x80, 0xF8, ##      00000       00000  
            0x1F, 0x00, 0x78, ##     00000         0000  
            0x1E, 0x00, 0xF8, ##     0000         00000  
            0x3E, 0x00, 0xFC, ##    00000         000000 
            0x3C, 0x01, 0xBC, ##    0000         00 0000 
            0x7C, 0x03, 0x3E, ##   00000        00  00000
            0x7C, 0x06, 0x3E, ##   00000       00   00000
            0x7C, 0x0C, 0x3E, ##   00000      00    00000
            0x7C, 0x18, 0x3E, ##   00000     00     00000
            0x7C, 0x38, 0x3E, ##   00000    000     00000
            0x7C, 0x70, 0x3E, ##   00000   000      00000
            0x7C, 0x60, 0x3E, ##   00000   00       00000
            0x7C, 0xC0, 0x3E, ##   00000  00        00000
            0x3D, 0x80, 0x7C, ##    0000 00        00000 
            0x3F, 0x00, 0x7C, ##    000000         00000 
            0x1E, 0x00, 0x78, ##     0000          0000  
            0x1E, 0x00, 0xF8, ##     0000         00000  
            0x1F, 0x01, 0xF0, ##     00000       00000   
            0x3B, 0xFF, 0xE0, ##    000 0000000000000    
            0x71, 0xFF, 0x80, ##   000   0000000000      
            0xE0, 0x00, 0x00, ##  000                    
            0x20, 0x00, 0x00, ##    0                    
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '249' => {    # 'ù'
        'width'    => 25, 
        'xoffset'  => 2, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x1F, 0x00, 0x00, 0x00, ##     00000                 
            0x0F, 0x00, 0x00, 0x00, ##      0000                 
            0x07, 0x80, 0x00, 0x00, ##       0000                
            0x03, 0xC0, 0x00, 0x00, ##        0000               
            0x01, 0xC0, 0x00, 0x00, ##         000               
            0x00, 0xE0, 0x00, 0x00, ##          000              
            0x00, 0x70, 0x00, 0x00, ##           000             
            0x00, 0x30, 0x00, 0x00, ##            00             
            0x00, 0x18, 0x00, 0x00, ##             00            
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0xFE, 0x03, 0xF8, 0x00, ##  0000000       0000000    
            0xFE, 0x03, 0xF8, 0x00, ##  0000000       0000000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0xF8, 0x00, ##     0000         00000    
            0x1F, 0x00, 0xF8, 0x00, ##     00000        00000    
            0x0F, 0x01, 0xF8, 0x00, ##      0000       000000    
            0x0F, 0x83, 0x78, 0x00, ##      00000     00 0000    
            0x07, 0xFE, 0x7F, 0x80, ##       0000000000  00000000
            0x03, 0xFC, 0x7F, 0x80, ##        00000000   00000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '250' => {    # 'ú'
        'width'    => 25, 
        'xoffset'  => 2, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xC0, 0x00, ##                0000       
            0x00, 0x07, 0x80, 0x00, ##               0000        
            0x00, 0x0F, 0x00, 0x00, ##              0000         
            0x00, 0x0E, 0x00, 0x00, ##              000          
            0x00, 0x1C, 0x00, 0x00, ##             000           
            0x00, 0x38, 0x00, 0x00, ##            000            
            0x00, 0x30, 0x00, 0x00, ##            00             
            0x00, 0x70, 0x00, 0x00, ##           000             
            0x00, 0xE0, 0x00, 0x00, ##          000              
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0xFE, 0x03, 0xF8, 0x00, ##  0000000       0000000    
            0xFE, 0x03, 0xF8, 0x00, ##  0000000       0000000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0xF8, 0x00, ##     0000         00000    
            0x1F, 0x00, 0xF8, 0x00, ##     00000        00000    
            0x0F, 0x01, 0xF8, 0x00, ##      0000       000000    
            0x0F, 0x83, 0x78, 0x00, ##      00000     00 0000    
            0x07, 0xFE, 0x7F, 0x80, ##       0000000000  00000000
            0x03, 0xFC, 0x7F, 0x80, ##        00000000   00000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '251' => {    # 'û'
        'width'    => 25, 
        'xoffset'  => 2, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x70, 0x00, 0x00, ##           000             
            0x00, 0xF8, 0x00, 0x00, ##          00000            
            0x00, 0xFC, 0x00, 0x00, ##          000000           
            0x01, 0xDC, 0x00, 0x00, ##         000 000           
            0x03, 0xCE, 0x00, 0x00, ##        0000  000          
            0x03, 0x87, 0x00, 0x00, ##        000    000         
            0x07, 0x07, 0x00, 0x00, ##       000     000         
            0x06, 0x03, 0x80, 0x00, ##       00       000        
            0x0C, 0x01, 0x80, 0x00, ##      00         00        
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0xFE, 0x03, 0xF8, 0x00, ##  0000000       0000000    
            0xFE, 0x03, 0xF8, 0x00, ##  0000000       0000000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0xF8, 0x00, ##     0000         00000    
            0x1F, 0x00, 0xF8, 0x00, ##     00000        00000    
            0x0F, 0x01, 0xF8, 0x00, ##      0000       000000    
            0x0F, 0x83, 0x78, 0x00, ##      00000     00 0000    
            0x07, 0xFE, 0x7F, 0x80, ##       0000000000  00000000
            0x03, 0xFC, 0x7F, 0x80, ##        00000000   00000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '252' => {    # 'ü'
        'width'    => 25, 
        'xoffset'  => 2, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x07, 0x07, 0x00, 0x00, ##       000     000         
            0x0F, 0x8F, 0x80, 0x00, ##      00000   00000        
            0x0F, 0x8F, 0x80, 0x00, ##      00000   00000        
            0x0F, 0x8F, 0x80, 0x00, ##      00000   00000        
            0x07, 0x07, 0x00, 0x00, ##       000     000         
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0xFE, 0x07, 0xF8, 0x00, ##  0000000      00000000    
            0xFE, 0x07, 0xF8, 0x00, ##  0000000      00000000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0x78, 0x00, ##     0000          0000    
            0x1E, 0x00, 0xF8, 0x00, ##     0000         00000    
            0x1F, 0x00, 0xF8, 0x00, ##     00000        00000    
            0x0F, 0x01, 0xF8, 0x00, ##      0000       000000    
            0x0F, 0x83, 0x78, 0x00, ##      00000     00 0000    
            0x07, 0xFE, 0x7F, 0x80, ##       0000000000  00000000
            0x03, 0xFC, 0x7F, 0x80, ##        00000000   00000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '253' => {    # 'ý'
        'width'    => 24, 
        'xoffset'  => 0, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xE0, ##                 0000     
            0x00, 0x01, 0xC0, ##                 000      
            0x00, 0x03, 0xC0, ##                0000      
            0x00, 0x07, 0x80, ##               0000       
            0x00, 0x0F, 0x00, ##              0000        
            0x00, 0x0E, 0x00, ##              000         
            0x00, 0x1C, 0x00, ##             000          
            0x00, 0x38, 0x00, ##            000           
            0x00, 0x30, 0x00, ##            00            
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0xFF, 0xC0, 0xFF, ##  0000000000      00000000
            0xFF, 0xC0, 0xFF, ##  0000000000      00000000
            0x1E, 0x00, 0x18, ##     0000            00   
            0x1E, 0x00, 0x18, ##     0000            00   
            0x1F, 0x00, 0x38, ##     00000          000   
            0x0F, 0x00, 0x30, ##      0000          00    
            0x0F, 0x00, 0x70, ##      0000         000    
            0x07, 0x80, 0x60, ##       0000        00     
            0x07, 0x80, 0x60, ##       0000        00     
            0x03, 0xC0, 0xE0, ##        0000      000     
            0x03, 0xC0, 0xC0, ##        0000      00      
            0x03, 0xC1, 0xC0, ##        0000     000      
            0x01, 0xE1, 0x80, ##         0000    00       
            0x01, 0xE3, 0x80, ##         0000   000       
            0x00, 0xF3, 0x80, ##          0000  000       
            0x00, 0xF3, 0x00, ##          0000  00        
            0x00, 0xF7, 0x00, ##          0000 000        
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x3E, 0x00, ##            00000         
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x18, 0x00, ##             00           
            0x00, 0x38, 0x00, ##            000           
            0x00, 0x30, 0x00, ##            00            
            0x00, 0x30, 0x00, ##            00            
            0x00, 0x70, 0x00, ##           000            
            0x60, 0x60, 0x00, ##   00      00             
            0x70, 0xE0, 0x00, ##   000    000             
            0x7F, 0xC0, 0x00, ##   000000000              
            0x7F, 0x80, 0x00, ##   00000000               
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '254' => {    # 'þ'
        'width'    => 24, 
        'xoffset'  => 1, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x00, ##  00000000                
            0xFF, 0x00, 0x00, ##  00000000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x1F, 0xE0, ##      0000   00000000     
            0x0F, 0x7F, 0xF0, ##      0000 00000000000    
            0x0F, 0xC0, 0xF8, ##      000000      00000   
            0x0F, 0xC0, 0x7C, ##      000000       00000  
            0x0F, 0x80, 0x3E, ##      00000         00000 
            0x0F, 0x80, 0x3E, ##      00000         00000 
            0x0F, 0x00, 0x1E, ##      0000           0000 
            0x0F, 0x00, 0x1F, ##      0000           00000
            0x0F, 0x00, 0x1F, ##      0000           00000
            0x0F, 0x00, 0x1F, ##      0000           00000
            0x0F, 0x00, 0x1F, ##      0000           00000
            0x0F, 0x00, 0x1F, ##      0000           00000
            0x0F, 0x00, 0x1F, ##      0000           00000
            0x0F, 0x00, 0x1F, ##      0000           00000
            0x0F, 0x00, 0x1F, ##      0000           00000
            0x0F, 0x00, 0x1E, ##      0000           0000 
            0x0F, 0x80, 0x3E, ##      00000         00000 
            0x0F, 0x80, 0x3E, ##      00000         00000 
            0x0F, 0x80, 0x7C, ##      00000        00000  
            0x0F, 0xC0, 0xF8, ##      000000      00000   
            0x0F, 0x7F, 0xF0, ##      0000 00000000000    
            0x0F, 0x1F, 0xE0, ##      0000   00000000     
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0x0F, 0x00, 0x00, ##      0000                
            0xFF, 0xE0, 0x00, ##  00000000000             
            0xFF, 0xE0, 0x00, ##  00000000000             
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '255' => {    # 'ÿ'
        'width'    => 24, 
        'xoffset'  => 0, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x01, 0xC1, 0xC0, ##         000     000      
            0x03, 0xE3, 0xE0, ##        00000   00000     
            0x03, 0xE3, 0xE0, ##        00000   00000     
            0x03, 0xE3, 0xE0, ##        00000   00000     
            0x01, 0xC1, 0xC0, ##         000     000      
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0x00, 0x00, 0x00, ##                          
            0xFF, 0xC0, 0xFF, ##  0000000000      00000000
            0xFF, 0xC0, 0xFF, ##  0000000000      00000000
            0x1E, 0x00, 0x1C, ##     0000            000  
            0x1E, 0x00, 0x18, ##     0000            00   
            0x0F, 0x00, 0x38, ##      0000          000   
            0x0F, 0x00, 0x30, ##      0000          00    
            0x0F, 0x80, 0x30, ##      00000         00    
            0x07, 0x80, 0x70, ##       0000        000    
            0x07, 0x80, 0x60, ##       0000        00     
            0x03, 0xC0, 0xE0, ##        0000      000     
            0x03, 0xC0, 0xC0, ##        0000      00      
            0x01, 0xE0, 0xC0, ##         0000     00      
            0x01, 0xE1, 0x80, ##         0000    00       
            0x01, 0xF1, 0x80, ##         00000   00       
            0x00, 0xF3, 0x80, ##          0000  000       
            0x00, 0xF3, 0x00, ##          0000  00        
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x7E, 0x00, ##           000000         
            0x00, 0x3E, 0x00, ##            00000         
            0x00, 0x3C, 0x00, ##            0000          
            0x00, 0x1C, 0x00, ##             000          
            0x00, 0x18, 0x00, ##             00           
            0x00, 0x18, 0x00, ##             00           
            0x00, 0x38, 0x00, ##            000           
            0x00, 0x30, 0x00, ##            00            
            0x00, 0x70, 0x00, ##           000            
            0x30, 0x60, 0x00, ##    00     00             
            0x30, 0xE0, 0x00, ##    00    000             
            0x3F, 0xC0, 0x00, ##    00000000              
            0x3F, 0x80, 0x00, ##    0000000               
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { '84' => -2, '86' => -3, '87' => -2, '88' => -2, '89' => -5, '221' => -5, },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { '84' => -2, '86' => -2, '87' => -2, '89' => -2, '102' => -1, '116' => -1, '118' => -2, '119' => -2, '121' => -2, '221' => -2, '253' => -2, '255' => -2, },  # A
    '66' => { '45' => 1, '67' => 1, '71' => 1, '79' => 1, '89' => -1, '199' => 1, '210' => 1, '211' => 1, '212' => 1, '213' => 1, '214' => 1, '216' => 1, '221' => -1, },  # B
    '67' => { '44' => -2, '46' => -2, },  # C
    '68' => { '44' => -2, '45' => 1, '46' => -2, '86' => -1, },  # D
    '69' => { '45' => 1, },  # E
    '70' => { '44' => -7, '45' => -2, '46' => -7, '58' => -2, '59' => -2, '65' => -4, '97' => -3, '101' => -2, '111' => -2, '192' => -4, '193' => -4, '194' => -4, '195' => -4, '196' => -4, '224' => -3, '225' => -3, '226' => -3, '227' => -3, '228' => -3, '229' => -3, '230' => -3, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '248' => -2, },  # F
    '71' => { '44' => -2, '45' => 1, '46' => -2, '89' => -1, '221' => -1, },  # G
    '72' => { },  # H
    '73' => { },  # I
    '74' => { '44' => -3, '46' => -3, '58' => -2, '59' => -2, },  # J
    '75' => { '45' => -3, '65' => -2, '67' => -1, '79' => -1, '85' => -2, '87' => -2, '89' => -1, '101' => -1, '111' => -1, '117' => -1, '121' => -3, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '216' => -1, '217' => -2, '218' => -2, '219' => -2, '220' => -2, '221' => -1, '232' => -1, '233' => -1, '234' => -1, '235' => -1, '242' => -1, '243' => -1, '244' => -1, '245' => -1, '246' => -1, '248' => -1, '249' => -1, '250' => -1, '251' => -1, '252' => -1, '253' => -3, '255' => -3, },  # K
    '76' => { '84' => -3, '85' => -2, '86' => -5, '87' => -4, '89' => -3, '121' => -1, '217' => -2, '218' => -2, '219' => -2, '220' => -2, '221' => -3, '253' => -1, '255' => -1, },  # L
    '77' => { },  # M
    '78' => { '44' => -3, '46' => -3, '58' => -2, '59' => -2, },  # N
    '79' => { '44' => -3, '45' => 2, '46' => -3, '86' => -1, '88' => -1, },  # O
    '80' => { '44' => -9, '45' => -2, '46' => -9, '58' => -2, '59' => -2, '65' => -4, '85' => -1, '97' => -2, '101' => -2, '111' => -2, '115' => -1, '192' => -4, '193' => -4, '194' => -4, '195' => -4, '196' => -4, '217' => -1, '218' => -1, '219' => -1, '220' => -1, '224' => -2, '225' => -2, '226' => -2, '227' => -2, '228' => -2, '229' => -2, '230' => -2, '232' => -2, '233' => -2, '234' => -2, '235' => -2, '242' => -2, '243' => -2, '244' => -2, '245' => -2, '246' => -2, '248' => -2, },  # P
    '81' => { '44' => -2, '45' => 2, '46' => -2, },  # Q
    '82' => { '84' => -1, '86' => -2, '87' => -1, '89' => -1, '97' => 1, '121' => -1, '221' => -1, '224' => 1, '225' => 1, '226' => 1, '227' => 1, '228' => 1, '229' => 1, '230' => 1, '248' => 1, '253' => -1, '255' => -1, },  # R
    '83' => { '44' => -2, '45' => 2, '46' => -2, },  # S
    '84' => { '44' => -6, '45' => -6, '46' => -6, '58' => -2, '59' => -2, '65' => -2, '97' => -3, '99' => -3, '101' => -3, '111' => -3, '115' => -3, '119' => -2, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, '224' => -3, '225' => -3, '226' => -3, '227' => -3, '228' => -3, '229' => -3, '230' => -3, '231' => -3, '232' => -3, '233' => -3, '234' => -3, '235' => -3, '242' => -3, '243' => -3, '244' => -3, '245' => -3, '246' => -3, '248' => -3, },  # T
    '85' => { '44' => -4, '45' => -1, '46' => -4, '58' => -2, '59' => -2, '65' => -1, '74' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, },  # U
    '86' => { '44' => -8, '45' => -4, '46' => -8, '58' => -4, '59' => -4, '65' => -3, '79' => -1, '97' => -4, '101' => -4, '105' => -1, '111' => -4, '117' => -3, '121' => -2, '192' => -3, '193' => -3, '194' => -3, '195' => -3, '196' => -3, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '216' => -1, '224' => -4, '225' => -4, '226' => -4, '227' => -4, '228' => -4, '229' => -4, '230' => -4, '232' => -4, '233' => -4, '234' => -4, '235' => -4, '242' => -4, '243' => -4, '244' => -4, '245' => -4, '246' => -4, '248' => -4, '249' => -3, '250' => -3, '251' => -3, '252' => -3, '253' => -2, '255' => -2, },  # V
    '87' => { '44' => -8, '45' => -3, '46' => -8, '58' => -4, '59' => -4, '65' => -2, '97' => -4, '101' => -3, '105' => -1, '111' => -3, '114' => -2, '117' => -2, '121' => -1, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, '224' => -4, '225' => -4, '226' => -4, '227' => -4, '228' => -4, '229' => -4, '230' => -3, '232' => -3, '233' => -3, '234' => -3, '235' => -3, '242' => -3, '243' => -3, '244' => -3, '245' => -3, '246' => -3, '248' => -3, '249' => -2, '250' => -2, '251' => -2, '252' => -2, '253' => -1, '255' => -1, },  # W
    '88' => { '45' => -2, '65' => -2, '67' => -1, '79' => -1, '192' => -2, '193' => -2, '194' => -2, '195' => -2, '196' => -2, '199' => -1, '210' => -1, '211' => -1, '212' => -1, '213' => -1, '214' => -1, '216' => -1, },  # X
    '89' => { '44' => -6, '45' => -5, '46' => -6, '58' => -5, '59' => -5, '65' => -3, '67' => -1, '97' => -3, '101' => -4, '105' => -1, '111' => -4, '117' => -4, '192' => -3, '193' => -3, '194' => -3, '195' => -3, '196' => -3, '199' => -1, '224' => -3, '225' => -3, '226' => -3, '227' => -3, '228' => -3, '229' => -3, '230' => -4, '232' => -4, '233' => -4, '234' => -4, '235' => -4, '242' => -4, '243' => -4, '244' => -4, '245' => -4, '246' => -4, '248' => -4, '249' => -4, '250' => -4, '251' => -4, '252' => -4, },  # Y
    '90' => { '44' => -1, '46' => -1, },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { },  # e
    '102' => { '44' => -2, '45' => -2, '46' => -2, },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { '45' => -1, },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { '46' => -1, },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { '44' => -5, '46' => -5, },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { '44' => -5, '46' => -5, },  # v
    '119' => { '44' => -5, '46' => -5, },  # w
    '120' => { '45' => -1, },  # x
    '121' => { '44' => -6, '46' => -6, },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '160' => { },  #  
    '161' => { },  # ¡
    '162' => { },  # ¢
    '163' => { },  # £
    '164' => { },  # ¤
    '165' => { },  # ¥
    '166' => { },  # ¦
    '167' => { },  # §
    '168' => { },  # ¨
    '169' => { },  # ©
    '170' => { },  # ª
    '171' => { },  # «
    '172' => { },  # ¬
    '173' => { },  # ­
    '174' => { },  # ®
    '175' => { },  # ¯
    '176' => { },  # °
    '177' => { },  # ±
    '178' => { },  # ²
    '179' => { },  # ³
    '180' => { },  # ´
    '181' => { },  # µ
    '182' => { },  # ¶
    '183' => { },  # ·
    '184' => { },  # ¸
    '185' => { },  # ¹
    '186' => { },  # º
    '187' => { },  # »
    '188' => { },  # ¼
    '189' => { },  # ½
    '190' => { },  # ¾
    '191' => { },  # ¿
    '192' => { '84' => -2, '86' => -2, '87' => -2, '89' => -2, '102' => -1, '116' => -1, '118' => -2, '119' => -2, '121' => -2, '221' => -2, '253' => -2, '255' => -2, },  # À
    '193' => { '84' => -2, '86' => -2, '87' => -2, '89' => -2, '102' => -1, '116' => -1, '118' => -2, '119' => -2, '121' => -2, '221' => -2, '253' => -2, '255' => -2, },  # Á
    '194' => { '84' => -2, '86' => -2, '87' => -2, '89' => -2, '102' => -1, '116' => -1, '118' => -2, '119' => -2, '121' => -2, '221' => -2, '253' => -2, '255' => -2, },  # Â
    '195' => { '84' => -2, '86' => -2, '87' => -2, '89' => -2, '102' => -1, '116' => -1, '118' => -2, '119' => -2, '121' => -2, '221' => -2, '253' => -2, '255' => -2, },  # Ã
    '196' => { '84' => -2, '86' => -2, '87' => -2, '89' => -2, '102' => -1, '116' => -1, '118' => -2, '119' => -2, '121' => -2, '221' => -2, '253' => -2, '255' => -2, },  # Ä
    '197' => { },  # Å
    '198' => { '45' => 1, },  # Æ
    '199' => { '44' => -2, '46' => -2, },  # Ç
    '200' => { '45' => 1, },  # È
    '201' => { '45' => 1, },  # É
    '202' => { '45' => 1, },  # Ê
    '203' => { '45' => 1, },  # Ë
    '204' => { },  # Ì
    '205' => { },  # Í
    '206' => { },  # Î
    '207' => { },  # Ï
    '208' => { '44' => -2, '45' => 2, '46' => -2, '65' => -1, '86' => -1, '89' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, '221' => -1, },  # Ð
    '209' => { '44' => -3, '46' => -3, '58' => -2, '59' => -2, },  # Ñ
    '210' => { '44' => -3, '45' => 2, '46' => -3, '86' => -1, '88' => -1, },  # Ò
    '211' => { '44' => -3, '45' => 2, '46' => -3, '86' => -1, '88' => -1, },  # Ó
    '212' => { '44' => -3, '45' => 2, '46' => -3, '86' => -1, '88' => -1, },  # Ô
    '213' => { '44' => -3, '45' => 2, '46' => -3, '86' => -1, '88' => -1, },  # Õ
    '214' => { '44' => -3, '45' => 2, '46' => -3, '86' => -1, '88' => -1, },  # Ö
    '215' => { },  # ×
    '216' => { '44' => -3, '45' => 2, '46' => -3, '86' => -1, '88' => -1, },  # Ø
    '217' => { '44' => -4, '45' => -1, '46' => -4, '58' => -2, '59' => -2, '65' => -1, '74' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, },  # Ù
    '218' => { '44' => -4, '45' => -1, '46' => -4, '58' => -2, '59' => -2, '65' => -1, '74' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, },  # Ú
    '219' => { '44' => -4, '45' => -1, '46' => -4, '58' => -2, '59' => -2, '65' => -1, '74' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, },  # Û
    '220' => { '44' => -4, '45' => -1, '46' => -4, '58' => -2, '59' => -2, '65' => -1, '74' => -1, '192' => -1, '193' => -1, '194' => -1, '195' => -1, '196' => -1, },  # Ü
    '221' => { '44' => -6, '45' => -5, '46' => -6, '58' => -5, '59' => -5, '65' => -3, '67' => -1, '97' => -3, '101' => -4, '105' => -1, '111' => -4, '117' => -4, '192' => -3, '193' => -3, '194' => -3, '195' => -3, '196' => -3, '199' => -1, '224' => -3, '225' => -3, '226' => -3, '227' => -3, '228' => -3, '229' => -3, '230' => -4, '232' => -4, '233' => -4, '234' => -4, '235' => -4, '242' => -4, '243' => -4, '244' => -4, '245' => -4, '246' => -4, '248' => -4, '249' => -4, '250' => -4, '251' => -4, '252' => -4, },  # Ý
    '222' => { '44' => -7, '45' => 1, '46' => -7, },  # Þ
    '223' => { },  # ß
    '224' => { },  # à
    '225' => { },  # á
    '226' => { },  # â
    '227' => { },  # ã
    '228' => { },  # ä
    '229' => { },  # å
    '230' => { },  # æ
    '231' => { },  # ç
    '232' => { },  # è
    '233' => { },  # é
    '234' => { },  # ê
    '235' => { },  # ë
    '236' => { },  # ì
    '237' => { },  # í
    '238' => { },  # î
    '239' => { },  # ï
    '240' => { '46' => -1, },  # ð
    '241' => { },  # ñ
    '242' => { '46' => -1, },  # ò
    '243' => { '46' => -1, },  # ó
    '244' => { '46' => -1, },  # ô
    '245' => { '46' => -1, },  # õ
    '246' => { '46' => -1, },  # ö
    '247' => { },  # ÷
    '248' => { '46' => -1, },  # ø
    '249' => { },  # ù
    '250' => { },  # ú
    '251' => { },  # û
    '252' => { },  # ü
    '253' => { '44' => -6, '46' => -6, },  # ý
    '254' => { '44' => -1, '46' => -2, },  # þ
    '255' => { '44' => -6, '46' => -6, },  # ÿ
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
