# Generated by default/object.tt
package Paws::SageMaker::EdgePresetDeploymentOutput;
  use Moose;
  has Artifact => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has StatusMessage => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::EdgePresetDeploymentOutput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::EdgePresetDeploymentOutput object:

  $service_obj->Method(Att1 => { Artifact => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::EdgePresetDeploymentOutput object:

  $result = $service_obj->Method(...);
  $result->Att1->Artifact

=head1 DESCRIPTION

The output of a SageMaker Edge Manager deployable resource.

=head1 ATTRIBUTES


=head2 Artifact => Str

The Amazon Resource Name (ARN) of the generated deployable resource.


=head2 Status => Str

The status of the deployable resource.


=head2 StatusMessage => Str

Returns a message describing the status of the deployed resource.


=head2 B<REQUIRED> Type => Str

The deployment type created by SageMaker Edge Manager. Currently only
supports Amazon Web Services IoT Greengrass Version 2 components.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

