/*
 * Decompiled with CFR 0.152.
 */
package com.vizdom.util;

import com.vizdom.util.AssertionFailedException;
import com.vizdom.util.UnreachableCodeException;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;

public class Debug {
    public static final boolean DEBUG = false;
    public static final boolean ASSERT = false;
    public static final int SILENT = 0;
    public static final int BRIEF = 1;
    public static final int VERBOSE = 2;
    public static final int TEDIOUS = 3;
    public static final int ABUSIVE = 4;
    private static int gVerbosity = 1;
    private static PrintWriter gLogWriter;
    private static PrintStream gLogStream;
    private static final PrintWriter gNullLogWriter;
    private static final PrintStream gNullLogStream;

    public static synchronized void setLogWriter(Writer aLogWriter) {
        gLogWriter = new PrintWriter(aLogWriter, true);
        gLogStream = gNullLogStream;
    }

    public static synchronized PrintWriter getLogWriter() {
        return gLogWriter;
    }

    public static synchronized PrintWriter getLogWriter(int aVerbosity) {
        return aVerbosity <= gVerbosity ? gLogWriter : gNullLogWriter;
    }

    public static synchronized void setLogStream(OutputStream aLogStream) {
        gLogWriter = new PrintWriter(aLogStream, true);
        gLogStream = new PrintStream(aLogStream);
    }

    @Deprecated
    public static synchronized PrintStream getLogStream() {
        return gLogStream;
    }

    @Deprecated
    public static synchronized PrintStream getLogStream(int aVerbosity) {
        return aVerbosity <= gVerbosity ? gLogStream : gNullLogStream;
    }

    public static synchronized int getVerbosity() {
        return gVerbosity;
    }

    public static synchronized void setVerbosity(int aVerbosity) {
        gVerbosity = aVerbosity;
    }

    public static synchronized void setVerbosity(String aVerbosity) {
        if (aVerbosity.equalsIgnoreCase("silent")) {
            gVerbosity = 0;
        } else if (aVerbosity.equalsIgnoreCase("brief")) {
            gVerbosity = 1;
        } else if (aVerbosity.equalsIgnoreCase("verbose")) {
            gVerbosity = 2;
        } else if (aVerbosity.equalsIgnoreCase("tedious")) {
            gVerbosity = 3;
        } else if (aVerbosity.equalsIgnoreCase("abusive")) {
            gVerbosity = 4;
        }
    }

    public static final void assertTrue(boolean aCondition) {
        if (!aCondition) {
            throw new AssertionFailedException();
        }
    }

    public static final void assertParameter(int aPosition, boolean aCondition) {
        if (!aCondition) {
            throw new IllegalArgumentException(Integer.toString(aPosition));
        }
    }

    private Debug() {
        throw new UnreachableCodeException();
    }

    static {
        gNullLogWriter = new PrintWriter(System.err){

            @Override
            public void write(int b) {
            }

            @Override
            public void write(char[] buf, int off, int len) {
            }

            @Override
            public void write(String s, int off, int len) {
            }

            @Override
            public void println() {
            }

            @Override
            public void println(boolean b) {
            }

            @Override
            public void println(char c) {
            }

            @Override
            public void println(char[] c) {
            }

            @Override
            public void println(double d) {
            }

            @Override
            public void println(float f) {
            }

            @Override
            public void println(int i) {
            }

            @Override
            public void println(long l) {
            }

            @Override
            public void println(Object o) {
            }

            @Override
            public void println(String s) {
            }
        };
        gNullLogStream = new PrintStream(System.err){

            @Override
            public void write(int b) {
            }

            @Override
            public void write(byte[] buf, int off, int len) {
            }

            @Override
            public void println() {
            }

            @Override
            public void println(boolean b) {
            }

            @Override
            public void println(char c) {
            }

            @Override
            public void println(char[] c) {
            }

            @Override
            public void println(double d) {
            }

            @Override
            public void println(float f) {
            }

            @Override
            public void println(int i) {
            }

            @Override
            public void println(long l) {
            }

            @Override
            public void println(Object o) {
            }

            @Override
            public void println(String s) {
            }
        };
        PrintStream defaultStream = System.err;
        String logFile = System.getProperty("debug.log");
        if (logFile == null) {
            gLogStream = defaultStream;
        } else {
            try {
                FileOutputStream fout = new FileOutputStream(logFile, true);
                BufferedOutputStream out = new BufferedOutputStream(fout);
                gLogStream = new PrintStream(out);
            }
            catch (FileNotFoundException e) {
                gLogStream = defaultStream;
            }
        }
        gLogWriter = new PrintWriter(gLogStream, true);
    }
}

