package Business::EDI::CodeList::EventTimeReferenceCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.01;
my $list_number = 2475;
my $usage       = 'B';

# 2475  Event time reference code                               [B]
# Desc: Code specifying a time that references an event that
# will or has occurred.
# Repr: an..3

my %code_hash = (
'1' => [ 'Date of order',
    'Payment time reference is date of order.' ],
'2' => [ 'Date of confirmation',
    'Payment time reference is date of confirmation.' ],
'3' => [ 'Date of contract',
    'Payment time reference is date of contract.' ],
'4' => [ 'Date of signature of contract',
    'Payment time reference is date of signature of contract.' ],
'5' => [ 'Date of invoice',
    'Payment time reference is date of invoice.' ],
'6' => [ 'Date of credit note',
    'Payment time reference is date of credit note.' ],
'7' => [ 'Date of present document',
    'Payment time reference is date of present document.' ],
'8' => [ 'Date of confirmation of order received',
    'Payment time reference is date of confirmation received.' ],
'9' => [ 'Date invoice received',
    'Payment time reference is date of invoice received.' ],
'11' => [ 'Date credit note received',
    'Payment time reference is date of credit note received.' ],
'12' => [ 'Date present document received',
    'Payment time reference is date of present document received.' ],
'13' => [ 'Date of resale by buyer',
    'Payment time reference is date of resale by the buyer.' ],
'14' => [ 'Date proceeds of resale collected by buyer',
    'Payment time reference is date of resale proceeds are collected by buyer. "buyer" is a retailer. Retailer will pay his supplier when having sold goods and money received.' ],
'21' => [ 'Date goods received by buyer',
    'Payment time reference is date when goods are received by buyer.' ],
'22' => [ "Date goods received by buyer's agent",
    "Payment time reference is date when goods are received by buyer's agent." ],
'23' => [ 'Date goods received by carrier',
    'Payment time reference is date when goods are received by carrier.' ],
'24' => [ 'Date ex-works',
    'Payment time reference is date when goods are leaving the sellers factory.' ],
'25' => [ 'Date goods handed over for shipment by seller or agent',
    'Payment time reference is the date when goods are handed over for shipment by the seller or his agent.' ],
'26' => [ 'Date of arrival of transport',
    'Date the transport arrived at the agreed destination.' ],
'27' => [ 'Date of outward frontier crossing',
    'Date the goods are crossing the border of the exporters country.' ],
'28' => [ 'Date of inward frontier crossing',
    'Date the goods are crossing the border of the importers country.' ],
'29' => [ 'Date of delivery of goods to establishments/domicile/site',
    'Date the goods are delivered at agreed place of destination.' ],
'31' => [ 'Stipulated date for payment of documentary credit',
    'Date as per agreement when documentary credit is due for payment.' ],
'32' => [ 'Stipulated date for acceptance of documentary credit',
    'Date as per agreement when documentary credit is accepted.' ],
'33' => [ 'Stipulated date for negotiation of documentary credit',
    'Date as per agreement when documentary credit is negotiated.' ],
'41' => [ 'Date of delivery to buyer of documents representing goods',
    'Date when documents representing goods are received by buyer .' ],
'42' => [ "Date of delivery to buyer's agent of documents representing",
    "goods Date when documents representing goods are received by buyer's agent." ],
'43' => [ 'Date of delivery to carrier of documents representing goods',
    'Date when documents representing goods are received by carrier.' ],
'44' => [ 'Date of delivery to intermediary bank of documents',
    'representing good Date when documents representing goods are received by intermediary bank.' ],
'45' => [ 'Date of bill of lading, consignment note or other transport',
    'document The date of issuance of a bill of lading, consignment note or similar transport document.' ],
'46' => [ "Date of receipt for loading (mate's receipt)",
    "Date when goods are expedited to a ship confirmed by mate's received." ],
'47' => [ 'Date of negotiable instrument (draft, promissory note,',
    'bank) Payment time reference is the date of the negotiable instrument.' ],
'48' => [ 'Date of receipt of tool dependent initial samples plus',
    'unlimited absolute bank guarantee plus value added tax Payment time reference is date of receipt of tool dependent initial samples and unlimited absolute bank guarantee of a third party, who is liable to the full amount of the tooling (which is owned by the customer).' ],
'52' => [ 'Due date of negotiable instrument',
    'Date when the negotiable instrument is due for payment.' ],
'53' => [ 'Date of presentation of negotiable instrument',
    'Date when the negotiable instrument is presented or will be presented to drawee.' ],
'54' => [ 'Date of acceptance of negotiable instrument',
    'Date when the negotiable instrument is accepted or will be accepted by drawee.' ],
'55' => [ 'Date of acceptance of tooling',
    'Payment time reference is date of acceptance of tooling or set of tooling.' ],
'56' => [ 'Date of receipt of tooling',
    'Payment time reference is date of receipt of tooling or set of tooling.' ],
'57' => [ 'Date of acceptance of first samples produced under',
    'production conditions Payment time reference is date of acceptance of first samples produced under production conditions.' ],
'60' => [ 'Date of start of work',
    'Payment time reference is the date when work begins.' ],
'61' => [ 'Date of end of work',
    'Payment time reference is the date when work ends.' ],
'62' => [ 'Date of provisional reception of work',
    'Date of temporary acceptance of work until final reception will take place.' ],
'63' => [ 'Date of final acceptance of work',
    'Payment time reference is the date of final acceptance of work.' ],
'64' => [ 'Date of certificate of preliminary acceptance',
    'Date of certificate of temporary acceptance of work until final reception will take place.' ],
'65' => [ 'Date of certificate of final acceptance',
    'Payment time reference is the date of the certificate of final acceptance.' ],
'66' => [ 'Specified date',
    'Date specified elsewhere.' ],
'67' => [ 'Anticipated delivery date',
    'The date on which delivery is anticipated to take place.' ],
'68' => [ 'Effective date',
    'The date on which an action or event becomes effective.' ],
'69' => [ 'Invoice transmission date',
    'Payment time reference is the date of invoice transmission.' ],
'70' => [ 'Date of issue of transport document(s)',
    'The date on which a transport document(s) is issued.' ],
'71' => [ 'Date of presentation of documents',
    'Payment time reference is the date when documents are presented.' ],
'72' => [ 'Payment date',
    'Date when a payment was made.' ],
'73' => [ 'Draft(s) at ... days sight',
    'Draft(s) is/are due after a specific number of days after sight.' ],
'74' => [ 'Draft(s) at ... days date',
    'Draft(s) is/are due after a specific number of days after date.' ],
'75' => [ 'Draft(s) at ... days after date of issuance of transport',
    'document(s) Draft(s) is/are due after a specific number of days after date of issuance of transport document(s).' ],
'76' => [ 'Draft(s) at ... days after date of presentation of',
    'documents Draft(s) is/are due after a specific number of days after date of presentation of documents.' ],
'77' => [ 'Specified draft date',
    'Draft at specified date.' ],
'78' => [ 'Customs clearance date (import)',
    'Date when goods clear Customs in the importing country.' ],
'79' => [ 'Customs clearance date (export)',
    'Date when goods clear Customs in the exporting country.' ],
'80' => [ 'Date of salary payment',
    'Date when a salary payment was made.' ],
'81' => [ 'Date of shipment as evidenced by the transport document(s)',
    'Date of shipment as evidenced by the transport document(s).' ],
'82' => [ 'Payment due date',
    'Date on which a payment is due.' ],
'83' => [ 'Requested date of delivery',
    'Payment terms apply from the requested date of delivery.' ],
'ZZZ' => [ 'Other reference date agreed upon between the parties',
    'A code assigned within a code list to be used on an interim basis and as defined among trading partners until a precise code can be assigned to the code list.' ],
);
sub get_codes { return \%code_hash; }

1;
