package Business::EDI::CodeList::MonetaryAmountTypeCodeQualifier;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {5025;}
my $usage       = 'C';

# 5025  Monetary amount type code qualifier                     [C]
# Desc: Code qualifying the type of monetary amount.
# Repr: an..3

my %code_hash = (
'1' => [ 'VAT, 1st value',
    'First VAT value if, for the same rate of VAT, there are 1 to 3 different ways to set this value.' ],
'2' => [ 'VAT, 2nd value',
    'Second VAT value if, for the same rate of VAT, there are 2 or 3 different ways to set this value.' ],
'3' => [ 'VAT, 3rd value',
    'Third VAT value if, for the same rate of VAT, there are 3 different ways to set this value.' ],
'4' => [ 'Additional royalties (Customs)',
    'Royalties relating to the imported goods that the buyer must pay, either directly or indirectly, as a condition of sale, to the extent that they are not included in the price actually paid or payable.' ],
'5' => [ 'Adjusted amount',
    'The amount specified is the adjusted amount.' ],
'6' => [ 'Amount reference currency',
    'The owing amount in the currency used as reference in the transaction.' ],
'7' => [ 'Agreed charge',
    'Charges which parties agreed upon.' ],
'8' => [ 'Allowance or charge amount',
    'Total amount of allowance or charge.' ],
'9' => [ 'Amount due/amount payable',
    'Amount to be paid.' ],
'10' => [ 'Amount in charge currency',
    'Indicates that the amount is based on the charged currency.' ],
'11' => [ 'Amount paid',
    'Amount that has been paid.' ],
'12' => [ 'Amount remitted',
    'Amount which was remitted (see remittance advice).' ],
'13' => [ 'Amount subject to total monetary discount',
    'The amount is subject to a total monetary discount.' ],
'14' => [ 'Amount target currency',
    'The amount in the currency in which the amount is paid or has to be paid.' ],
'15' => [ 'Average ledger balance',
    'The addition of the balance all accounts divided by the number of accounts.' ],
'16' => [ 'Bank release fee',
    'The fee that a bank charges for releasing monies.' ],
'17' => [ 'Batch total',
    'The complete quantity of anything needed for or made in one operation or lot.' ],
'18' => [ 'Brokerage',
    'Fee charged by a broker for acting on behalf of a third party.' ],
'19' => [ 'Buying commission',
    'Commission paid by the importer to his/her agent for the service of representing him/her in the purchase.' ],
'20' => [ 'Data value on carrier media (Customs)',
    'Value of data contained on the carrier media (e.g. magnetic tape).' ],
'21' => [ 'Cash discount',
    'Cash discount given by the seller to the buyer.' ],
'22' => [ 'Consignment cash on delivery amount',
    '[5017] Monetary amount to be paid at time of delivery.' ],
'23' => [ 'Charge amount',
    'The amount of money charged for the provision of a service or product.' ],
'24' => [ 'Charge summary total',
    'Code to indicate the total charges relating to a consignment.' ],
'25' => [ 'Charge/allowance basis',
    'The amount specified is the basis for calculation of charges/allowance.' ],
'26' => [ 'Charges collect fee',
    'The fee a party charges for collecting charges.' ],
'27' => [ 'Charges in destination currency',
    'Collect charges payable in the currency of the country of destination.' ],
'28' => [ 'Collect charge summary total',
    'A summary total of collection charges.' ],
'29' => [ 'Collect charges in destination currency',
    'Collect charges payable in the currency of the country of destination.' ],
'30' => [ 'Collect freight charge including VAT',
    'This is the total amount that has to be collected from the consignee or other intermediary intervening party - Including VAT-.' ],
'31' => [ 'Collect freight charge without VAT',
    'For legal accounting reasons the amount without VAT has to be announced, together with the amount of VAT.' ],
'32' => [ 'Collect other charges due agent total',
    'The total of other charges that are due to the agent.' ],
'33' => [ 'Collect taxes total',
    'The total amount of taxes to be collected.' ],
'34' => [ 'Collected balance required',
    'A certain sum of money that must be kept in an account.' ],
'35' => [ 'Container cost',
    'The cost of providing a container.' ],
'36' => [ 'Converted amount',
    'The amount is converted from another currency.' ],
'37' => [ 'Credit on consignment',
    'Credit deducted from the total invoice amount for the value of goods not included in a consignment but included in the invoice.' ],
'39' => [ 'Invoice total amount',
    '[5214] Amount, debited by the seller and being the total of related article item amounts in a commercial invoice.' ],
'40' => [ 'Goods item for customs declared value amount',
    '[5032] Amount declared for customs purposes of those goods in a consignment which are subject to the same customs procedure, and have the same tariff/statistical heading, country information and duty regime.' ],
'41' => [ 'Assigned Customs value',
    'Goods value assigned by Customs.' ],
'42' => [ 'Total cash payments received by factor',
    'Total allocated amount of cash payments received by a factor.' ],
'43' => [ 'Consignment for customs total amount',
    '[5070] Total amount for customs purposes of all goods in a consignment, whether or not they are subject to the same customs procedure, and have the same tariff/statistical heading, country information and duty regime.' ],
'44' => [ 'Goods item for carriage declared value amount',
    "[5036] Value, declared by the shipper or his agent solely for the purpose of varying the carrier's level of liability from that provided in the contract of carriage, in case of loss or damage to goods or delayed delivery." ],
'45' => [ 'Deductible after importation charges (Customs)',
    'Charges (e.g. construction, assembly, erection, maintenance or technical assistance) after importation, which are included in the total invoice price, that may be deducted to arrive at a Customs value.' ],
'46' => [ 'Customs allowable deduction basis amount',
    '[5020] Allowable deductions from the price payable for calculating Customs value.' ],
'47' => [ 'Delivery fee',
    'Fees incurred by delivery.' ],
'48' => [ 'Deposit total',
    'The whole amount of money that one entrusts for safekeeping.' ],
'49' => [ 'Development necessary for production of imported goods',
    '(Customs) Value of engineering, development, artwork, design work and plans and sketches carried out elsewhere than in the Customs territory and necessary for the production of the imported goods.' ],
'50' => [ 'Disbursements',
    'Amount of disbursements to be collected by the carrier according to the order given by the shipper.' ],
'51' => [ 'Disbursements fee',
    'Fee charged for the collection of disbursements.' ],
'52' => [ 'Discount amount',
    '(5014) The amount specified is the discount amount.' ],
'53' => [ 'Discount amount due',
    'The amount of discount that is due.' ],
'54' => [ 'Distribution service fee',
    'The fee charged for the provision of distribution services.' ],
'55' => [ 'Duty amount',
    'The amount of duty.' ],
'56' => [ 'Duty/tax/fee basis amount',
    'The amount specified is the basis for duty/tax or fee.' ],
'57' => [ 'Equivalent amount',
    'This amount is equivalent to the amount to be transferred, but in another currency.' ],
'58' => [ 'Fee amount',
    'The amount of a fee.' ],
'59' => [ 'Fees paid year to date',
    'Payments made for goods thus far.' ],
'60' => [ 'Final (posted) amount',
    'The amount posted to an account, finally, after charges/allowances.' ],
'61' => [ 'Float (e.g. "cash float")',
    'The status of funds in the process of collection.' ],
'62' => [ 'Total payments on account received by a factor',
    'Total unallocated amount of payments received by a factor.' ],
'63' => [ 'FOB value',
    'Identifies the value of the shipment free on board, named port of shipment (see FOB Incoterm of ICC).' ],
'64' => [ 'Freight charge',
    'Amount to be paid for moving goods, by whatever means, from one place to another, inclusive discounts, allowances, rebates, adjustment factors and additional cost relating to freight costs (UN/ECE Recommendation no 23).' ],
'65' => [ 'Total indirect amount payments made to a seller or his',
    'agent instead of to a factor Total indirect amount of payments made to a seller or his agent instead of to a factor.' ],
'66' => [ 'Goods item total',
    'Net price x quantity for the line item.' ],
'67' => [ 'Insurance amount',
    'Amount of insurance.' ],
'68' => [ 'Insurance and transport charges (Customs)',
    '(5488)+(5290) Sum total of transport and insurance charges (CCC).' ],
'69' => [ 'Insurance and transport charges incurred outside Customs',
    'territory (5488)+(5290) Insurance and transport charges incurred outside a Customs territory (or a Customs union).' ],
'70' => [ 'Consignment to importation location insurance amount',
    '[5488] Amount of premium payable to the insurance company to insure the goods to the port or place of importation.' ],
'71' => [ 'Insurance charges incurred outside of Customs territory',
    '(5488) Insurance charges incurred outside a Customs territory (or a Customs union).' ],
'72' => [ 'Internal charges (Customs)',
    'Charges incurred within a Customs territory (or a Customs union).' ],
'73' => [ 'Total amount of payments booked to the collateral account',
    'Total amount of payments booked to the collateral account.' ],
'74' => [ 'Amount to be paid in advance',
    'Amount which is to be paid before goods are delivered or the service is rendered.' ],
'75' => [ 'Registered capital',
    'Registered amount of equity of a company.' ],
'76' => [ 'Investable balance',
    'To put left over money in something offering profitable returns.' ],
'77' => [ 'Invoice line item amount',
    '[5068] Total sum charged with respect to a single line item of an invoice.' ],
'78' => [ 'Landing charges',
    'The charges incurred in landing the goods into store in the country of importation, excluding Customs duties and taxes.' ],
'79' => [ 'Total line items amount',
    'The sum of all the line item amounts.' ],
'80' => [ 'Licence fees related to imported goods (Customs)',
    'Licence fees relating to the imported goods that the buyer must pay, either directly or indirectly, as a condition of sale, to the extent that they are not included in the price actually paid or payable.' ],
'81' => [ 'Loading and handling cost',
    'Cost incurred by loading and handling.' ],
'82' => [ 'Lock box total',
    'The complete amount of funds that customers mailed in to a specific location. Often times funds are sent to a post-office lock box in their city.' ],
'83' => [ 'Lumpsum',
    'An agreed sum of money, which is paid in full at one time. This term is often used in connection with charter parties.' ],
'84' => [ 'Material consumed in production of imported goods (Customs)',
    'Value of materials consumed in the production of the imported goods.' ],
'85' => [ 'Maximum charge',
    'The maximum amount that can be charged for a service or product.' ],
'86' => [ 'Message total monetary amount',
    'The total of all monetary amounts contained within the message.' ],
'87' => [ 'Minimum charge',
    'The minimum amount that can be charged for a service or product.' ],
'88' => [ 'National preference basis amount',
    'Amount giving the basis for national preference calculation.' ],
'89' => [ 'Negative collected balance',
    'Having a quantity of less than zero in an account.' ],
'90' => [ 'Negative ledger balance',
    "For an asset account, this would be when the account had a credit balance. For liability and owner's equity accounts, it would be when the account had a debit balance." ],
'91' => [ 'Net adjustment',
    'The end-of-the-period total amount which is left after recording appropriate adjusting entries.' ],
'92' => [ 'Net fee position',
    'The payments left over after deductions or allowances have been made.' ],
'93' => [ 'Net year to date excess (deficit)',
    'A negative amount of an item.' ],
'94' => [ 'No amount of insurance',
    'No amount of insurance has been declared for a consignment.' ],
'95' => [ 'No declared value for carriage',
    'No value has been declared for purposes of carriage.' ],
'96' => [ 'No declared value for Customs',
    'No value has been declared for Customs purposes.' ],
'97' => [ 'Quotation total amount',
    '[5210] Total monetary amount of a quotation.' ],
'98' => [ 'Original amount',
    'Original amount, without charges, allowances or adjustment.' ],
'99' => [ 'Other charges at destination',
    'Code to indicate charges levied at destination.' ],
'100' => [ 'Other charges due agent',
    'Code to indicate that certain charges accrue to an agent.' ],
'101' => [ 'Other charges due carrier',
    'Code to indicate that certain charges accrue to a carrier.' ],
'102' => [ 'Other commissions',
    'Other commissions paid by the importer to his/her agent in relation to the goods being imported.' ],
'103' => [ 'Other deductible charges',
    'Other charges deducted from the total invoice value.' ],
'104' => [ 'Other transport charges',
    '(5290) Other charges paid for transport.' ],
'105' => [ 'Other valuation charges (Customs)',
    'Other valuation charges which are payable by reason of the importation or sale of the goods in the Customs territory.' ],
'106' => [ 'Packing cost',
    'Cost for packing concerning labour and/or material.' ],
'107' => [ 'Transport equipment total for customs packing cost amount',
    '[5448] Costs incurred for all containers and coverings of whatever nature which are considered as being one for Customs purposes with the goods, and the cost of packing whether for labour or material.' ],
'108' => [ 'Parts incorporated in imported goods (Customs)',
    'Materials, components, parts and similar items incorporated in the imported goods.' ],
'109' => [ 'Payment discount amount',
    'Discount for paying early.' ],
'110' => [ 'Pick-up fee',
    'Fee incurring if item has been or will be picked up.' ],
'111' => [ 'Positive collected balance',
    'Having a quantity of greater than zero in an account.' ],
'112' => [ 'Positive ledger balance',
    "For an asset account, this would be when the account had a debit balance. For liability and owner's equity accounts, it would be when the account had a credit balance." ],
'113' => [ 'Prepaid amount',
    '(5302) Amount which has been prepaid in advance.' ],
'114' => [ 'Prepaid charge summary total',
    'Total of all prepaid charges.' ],
'115' => [ 'Prepaid taxes total',
    'Total of all prepaid taxes.' ],
'116' => [ 'Purchase amount',
    'The cost of buying goods or services.' ],
'117' => [ 'Quantity discount',
    'Discount given for purchase of goods in bulk.' ],
'118' => [ 'Quota value',
    'The monetary value of a quota.' ],
'119' => [ 'Received amount',
    'The amount is what the bank received, and the one before charges/allowances.' ],
'120' => [ 'Sales tax',
    'Identifies the amount of sales tax payable.' ],
'121' => [ 'Shipment value in domestic currency',
    'The cost of transportation in domestic currency.' ],
'122' => [ 'Specific amount payable',
    'Amount that the consignor agrees to be invoiced or to pay. This amount is part of the total charges applied to the consignment.' ],
'123' => [ 'Goods item for statistics declared value amount',
    '[5218] Value declared for statistical purposes of those goods in a consignment which have the same statistical heading.' ],
'124' => [ 'Tax amount',
    'Tax imposed by government or other official authority related to the weight/volume charge or valuation charge.' ],
'125' => [ 'Taxable amount',
    'Amount on which a tax has to be applied.' ],
'126' => [ 'To collect',
    'Amount that has to be collected.' ],
'127' => [ 'Tools used in production of imported goods (Customs)',
    'Tools, dies, moulds and similar items used in the production of the imported goods.' ],
'128' => [ 'Total amount',
    'The amount specified is the total amount.' ],
'129' => [ 'Total amount subject to payment discount',
    'Part of the invoice amount which is subject to payment discount.' ],
'130' => [ 'Total charge due',
    'Total amount of charges payable to the carrier.' ],
'131' => [ 'Total charges/allowances',
    'The amount specified is the total of all charges/allowances.' ],
'132' => [ 'Total collect charges',
    'Total charges to be collected.' ],
'133' => [ 'Total collect charges at destination',
    'Total charges to be collected at destination.' ],
'134' => [ 'Total declared',
    'The total value of declared amounts.' ],
'135' => [ 'Total freight due',
    'Total amount of freight costs payable to the carrier.' ],
'136' => [ 'Total invoice additional amount',
    '(5140) Amount to be added to the sum of invoice line amounts to arrive at the total invoice amount.' ],
'137' => [ 'Damage protection plan coverage',
    'Indicates the amount of damage coverage provided under the Damage Protection Plan (DPP).' ],
'138' => [ 'Total monetary discount amount',
    'Total of monetary discount amounts.' ],
'139' => [ 'Total payment amount',
    'A complete charge for goods or services rendered.' ],
'140' => [ 'Total service charge',
    'The complete payment owed to one who has performed work for another.' ],
'141' => [ 'Cost, insurance and freight (CIF) value',
    'Identifies the value of cost, insurance and freight. (Refer to ICC Incoterm CIF for an expanded definition).' ],
'142' => [ 'Trade discount',
    'Discount given to any purchaser at a particular commercial level e.g. at wholesale or retail level.' ],
'143' => [ 'Transfer amount',
    'The amount which has been transferred from buyer to the sellers bank.' ],
'144' => [ 'Transport charges (Customs)',
    '(5290) Cost incurred by shipper in moving goods, by whatever means, from one place to another under the terms of the contract of carriage, see UN/ECE Recommendation No 23. Synonym: freight charges (Customs).' ],
'145' => [ 'Transport charges incurred outside Customs territory',
    '(5290) Transport charges incurred outside a Customs territory (or a Customs union).' ],
'146' => [ 'Unit price',
    '(5110) Reporting monetary amount is a "per unit" amount.' ],
'147' => [ 'Acceptable quotation fluctuation amount',
    'The maximum increase or decrease in constituent material fluctuation which will not result in an item price renegotiation.' ],
'148' => [ 'Total payments under guarantee',
    "Total amount paid under guarantee, such as under a factor's guarantee." ],
'149' => [ 'Valuation charge',
    'A charge based on the value of goods or cargo.' ],
'150' => [ 'Value added tax amount',
    '[5490] Amount in national currency resulting from the application, at the appropriate rate, of value added tax (or similar tax) to the invoice amount subject to such tax.' ],
'151' => [ 'Consignment insured value amount',
    '[5011] Representation in figures of the total sum covered by an insurance for a particular shipment.' ],
'152' => [ 'Subsequent resale of imported goods (Customs)',
    'Value of any part of the proceeds of any subsequent resale, disposal or use of the imported goods that accrues, directly or indirectly, to the seller.' ],
'153' => [ 'Weight charge',
    'A charge based on the weight of goods or cargo.' ],
'154' => [ 'Amount to be collected',
    'The monetary amount that is to be collected.' ],
'155' => [ 'Standard duty',
    'Standard Customs duty that would apply if special provisions did not apply.' ],
'156' => [ 'G-Amount',
    'Amount out of total invoice amount being paid into a blocked account.' ],
'157' => [ 'Insurance value',
    '(5010) Value for which the goods are insured.' ],
'158' => [ 'Insurance and transport charges incurred inside Customs',
    'territory (5488)+(5290) Charges to be paid for moving goods, by whatever means, from the point of entry into the Customs territory (within a Customs union: to the point of entry in the final destination country).' ],
'159' => [ 'Licence (value deducted)',
    'Amount in the currency of the licence to be written off from the total licence value.' ],
'160' => [ 'Other costs',
    '(5346) Costs, other than packing, freight and insurance costs, specified separately.' ],
'161' => [ 'Duty, tax or fee amount',
    'Amount of duty, tax or fee.' ],
'162' => [ 'Customs duty paid',
    'Amount which can be deducted from the stated invoice price where that price includes the Customs duty amount.' ],
'163' => [ 'Wage tax share',
    'Wage tax share of total amount to be paid directly to tax collector.' ],
'164' => [ 'Social securities premiums share',
    'Social securities share of total amount to be paid directly to the social securities collector.' ],
'165' => [ 'Adjustment amount',
    'Amount being the balance of the amount to be adjusted and the adjusted amount.' ],
'166' => [ 'Guarantee amount (Customs)',
    'Amount of the guarantee placed with Customs.' ],
'167' => [ 'Actual versus calculated price difference',
    'Difference between actual and calculated price.' ],
'168' => [ 'Tax sub-totals',
    'A sub total of tax values.' ],
'169' => [ 'Alternate currency total amount',
    'The total amount as expressed in an alternate currency.' ],
'170' => [ 'Document amount',
    'The monetary value stated within a related document.' ],
'171' => [ 'Total reassignments of factored invoices',
    'Total amount of factored invoices and credit notes reassigned to the seller or to another factor.' ],
'172' => [ 'Stated amount',
    'The monetary amount that has been declared.' ],
'173' => [ 'Minimum amount',
    'Lowest possible value; minimum.' ],
'174' => [ 'Balance brought forward',
    '[5190] Opening balance of the account brought forward from the prior accounting period.' ],
'175' => [ 'Message total additional amount',
    'An amount in addition to the total message value.' ],
'176' => [ 'Message total duty/tax/fee amount',
    'Total of all duty/tax/fee amounts.' ],
'177' => [ 'Message total amount prepaid',
    'Total of all prepaid amounts within the message.' ],
'178' => [ 'Exact amount',
    'Specific amount.' ],
'179' => [ 'Maximum amount',
    'Highest possible value; maximum.' ],
'180' => [ 'Amount up to',
    'Highest possible value; up to.' ],
'181' => [ 'Amount not exceeding',
    'Highest possible value; not exceeding.' ],
'182' => [ 'Any other specification/tolerance',
    'Any further qualification of the amount.' ],
'183' => [ 'No specification/tolerance',
    'No further qualification of the amount.' ],
'184' => [ 'Final net acquisition cost',
    'The final cost of acquisition, net of all add-ons and discounts.' ],
'185' => [ 'Labour cost',
    'The cost of providing labour to complete a task.' ],
'186' => [ 'Material cost',
    'The cost of materials needed to complete a task.' ],
'187' => [ 'Other cost',
    'Non specific costs for an item in addition to those stated explicitly.' ],
'188' => [ 'Overhead cost',
    'The cost of overhead when completing a task.' ],
'189' => [ 'Packaging cost',
    'The cost of packaging an item.' ],
'190' => [ 'Prototype set up cost',
    'The cost of setting up a prototype.' ],
'191' => [ 'Authorized cleaning amount',
    'Amount of money authorized for cleaning services.' ],
'192' => [ 'Raw material per cart cost',
    'The cost of raw material expressed per cart.' ],
'193' => [ 'Raw material per unit of measure cost',
    'The cost of raw material expressed per unit of measure.' ],
'194' => [ 'Total die model cost',
    'The total of costs for a die model.' ],
'195' => [ 'Total gauge cost',
    'The total of costs for a gauge.' ],
'196' => [ 'Total material including purchased components cost',
    'The total cost of materials for an item, including components purchased externally.' ],
'197' => [ 'Total purchased components cost',
    'The total cost of components purchased externally.' ],
'198' => [ 'Total tooling cost',
    'The total of costs relating to tooling.' ],
'199' => [ 'Delivery limitation amount',
    'The monetary limitation amount for a delivery.' ],
'200' => [ 'Minimum amount due',
    'The minimum amount that must be paid on an amount now due for payment.' ],
'201' => [ 'Penalty amount',
    'The penalty charge incurred if or because conditions are not met.' ],
'202' => [ 'Interest amount',
    'The amount of interest charged or paid on a debit or credit balance.' ],
'203' => [ 'Line item amount',
    'Goods item total minus allowances plus charges for line item. See also Code 66.' ],
'204' => [ 'Allowance amount',
    'The amount of an allowance.' ],
'205' => [ 'Additional amount covered: freight costs',
    'Additional amount (freight costs) which is also covered under the documentary credit.' ],
'206' => [ 'Additional amount covered: inspection costs',
    'Additional amount (inspection costs) which is also covered under the documentary credit.' ],
'207' => [ 'Additional amount covered: insurance costs',
    'Additional amount (insurance costs) which is also covered under the documentary credit.' ],
'208' => [ 'Additional amount covered: interest',
    'Additional amount (interest) which is also covered under the documentary credit.' ],
'209' => [ 'Agent commission amount',
    'Amount which has to be paid to an agent.' ],
'210' => [ 'Credit note amount',
    'Amount of a credit note.' ],
'211' => [ 'Debit note amount',
    'Amount of a debit note.' ],
'212' => [ 'Documentary credit amount',
    'Amount of the documentary credit.' ],
'213' => [ 'Part of documentary credit amount',
    'Part of documentary credit amount subject to sight payment, deferred payment or acceptance when the documentary credit is available by mixed payment.' ],
'214' => [ 'Advance payment at the beginning of works',
    'Amount paid to the contractor at the beginning of works in the construction to be deducted later.' ],
'215' => [ 'Deduction of advance payment amount at the beginning of',
    'works Progressive deduction of advance payment, as works go on.' ],
'216' => [ 'Advance payment amount on building material',
    'An amount paid in advance for the purchase of building material.' ],
'217' => [ 'Deduction of the advance payment amount on building',
    'material The cost of building material less any monies paid in advance.' ],
'218' => [ 'Advance payment amount on stock',
    'An amount paid in advance for the purchase of stock.' ],
'219' => [ 'Deduction of the advance payment amount on stock',
    'The cost of stock less any monies paid in advance.' ],
'220' => [ 'Amount subject to guarantee retention',
    'Amount participating in the assessment basis of a guarantee retention.' ],
'221' => [ 'Amount not subject of guarantee retention',
    'Amount not participating in the assessment basis of a guarantee retention.' ],
'222' => [ 'Amount subject to contractual retention',
    'Amount participating in the assessment basis of a contractual retention.' ],
'223' => [ 'Works amount, initial',
    'Total amount of works in the initial contract.' ],
'224' => [ 'Works amount, variations',
    'Total amount of contract variations, not including the amount planned on initial contract.' ],
'225' => [ 'Works amount, total',
    'Total amount of works, including initial contract and variations.' ],
'226' => [ 'Retention amount',
    'The amount of money that has been or is to be retained.' ],
'227' => [ 'Deposit',
    'Part of the amount of retention, not covered by guarantee of retention, and thus deducted from the amount paid to the contractor until release of retention.' ],
'228' => [ 'Deposit refund',
    'Refund of deposit, due to an increase of the guarantee of retention amount, or a decrease of the amount of retention.' ],
'229' => [ 'Guarantee on retention refund',
    'Refund of deposit, due to partial or complete release of retention.' ],
'230' => [ 'Amount subject to escalation',
    'Amount which is used as the basis for the calculation of the escalation.' ],
'231' => [ 'Amount subject to escalation, initial',
    'Amount in the initial contract which is used as the basis for the calculation of the escalation.' ],
'232' => [ 'Amount of variations subject to escalation',
    'Amount of variations which is used as the basis for the calculation of the escalation.' ],
'233' => [ 'Amount not subject to escalation',
    'Amount which is not included in the calculation of the escalation.' ],
'234' => [ 'Amount not subject to escalation, initial',
    'Amount in the initial contract which is not included in the calculation of the escalation.' ],
'235' => [ 'Amount of variations not subject to escalation',
    'Amount of variations which is not included in the calculation of the escalation.' ],
'236' => [ 'Amount subject to price adjustment',
    'Amount which is used as the basis for price adjustment calculation.' ],
'237' => [ 'Amount subject to price adjustment, initial',
    'Amount in the initial contract which is used as the basis for the price adjustment calculation.' ],
'238' => [ 'Amount of variations subject to price adjustment',
    'Amount of variations which is used as the basis for price adjustment calculation.' ],
'239' => [ 'Amount not subject to price adjustment',
    'Amount which is not included in the calculation of the price adjustment.' ],
'240' => [ 'Amount not subject to price adjustment, initial',
    'Amount in the initial contract which is not included in the calculation of the price adjustment.' ],
'241' => [ 'Amount of variations not subject to price adjustment',
    'Amount of variations which is not included in the calculation of the price adjustment.' ],
'242' => [ 'Escalation amount',
    'Difference between initial amount and current amount.' ],
'243' => [ 'Provisional escalation amount',
    'Difference between initial amount and provisional current amount.' ],
'244' => [ 'Price adjustment amount',
    'Difference between initial amount and revised amount.' ],
'245' => [ 'Provisional price adjustment amount',
    'Difference between initial amount and provisional revised amount.' ],
'246' => [ 'Price revaluation amount',
    'Amount of escalation and price adjustment.' ],
'247' => [ 'Provisional price revaluation amount',
    'Provisional amount of escalation and price adjustment.' ],
'248' => [ 'Contractual retention amount total',
    'Retention on a basis contractually fixed.' ],
'249' => [ 'Valuation amount',
    'Amount of valuation.' ],
'250' => [ 'Deduction amount of direct payments to subcontractors',
    'Deduction of amounts directly paid to subcontractors.' ],
'251' => [ 'Amortization total amount',
    'Indication of final monetary amount for amortization.' ],
'252' => [ 'Amortization order amount',
    'Indication of actual share of the monetary amount for amortization.' ],
'253' => [ 'Amortization cumulated amount',
    'Indication of actual cumulated monetary amount of previous and actual amortization order amount.' ],
'254' => [ 'Current credit cover',
    'Limit for current credit cover.' ],
'255' => [ 'New credit cover',
    'Limit for new credit cover.' ],
'256' => [ 'Order cover',
    'Credit cover for an individual order or shipment.' ],
'257' => [ 'Amount subject to dispute',
    'The amount that is being disputed.' ],
'258' => [ 'Charge amount for information',
    'The stated charge amount is only for information. The amount will be debited due to agreement.' ],
'259' => [ 'Total charges',
    'The total amount of all the charges.' ],
'260' => [ 'Total allowances',
    'The total amount of all the allowances.' ],
'261' => [ 'Alternate currency amount',
    'The amount as expressed in an alternate currency.' ],
'262' => [ 'Instalment amount',
    'Amount paid or due for a single instalment of an instalment payment scheme.' ],
'263' => [ 'Outstanding amount',
    'Amount still remaining outstanding for payment.' ],
'264' => [ 'Gross contribution amount',
    'Gross amount contributed. This may include commissions or allowances.' ],
'265' => [ 'Commission amount',
    'Amount of any commission.' ],
'266' => [ 'Net contribution amount',
    'Amount contributed net of any commission or other allowances .' ],
'267' => [ 'Regular contribution amount',
    'Specified contribution amount regularly paid.' ],
'268' => [ 'Previous regular contribution amount',
    'Specified contribution amount regularly paid before a change .' ],
'269' => [ 'Variation amount',
    'Difference from a nominated amount.' ],
'270' => [ 'Notional salary',
    'A salary amount specified for a particular category of employees.' ],
'271' => [ 'Nominal salary',
    'The salary amount without special allowances or other cash benefits.' ],
'272' => [ 'Taxable salary',
    'The salary amount which is taxable.' ],
'273' => [ 'Superannuation salary',
    'Salary used for superannuation benefit/contribution purposes .' ],
'274' => [ 'Total remuneration',
    "The amount of the total value of a person's remuneration." ],
'275' => [ 'Other salary',
    'The amount of other salary or allowances in addition to a base salary.' ],
'276' => [ 'Annual salary',
    'The total amount of wages paid during a year.' ],
'277' => [ 'Total contributions amount',
    'Sum of individual contributions.' ],
'278' => [ 'Voluntary contribution amount',
    'The amount is for a non-compulsory contribution.' ],
'279' => [ 'Instalment first amount',
    'First of a number of due amounts if payment by instalment is agreed.' ],
'280' => [ 'Instalment current amount',
    'Current amount of a number of due amounts if payment by instalment is agreed.' ],
'281' => [ 'Instalment last amount',
    'Last of a number of due amounts if payment by instalment is agreed.' ],
'282' => [ 'Current maintenance fee',
    'Current amount of a number of amounts due on maintenance contract.' ],
'283' => [ 'Current leasing fee',
    'Current amount of a number of amounts due on lease contracts.' ],
'284' => [ 'Day works amount',
    'The amount of work calculated on the basis of manpower time and supply cost.' ],
'285' => [ "Manufacturer's bonus",
    "Allowance given as a manufacturer's bonus." ],
'286' => [ 'Administration charge',
    'Charge made for an administration activity.' ],
'287' => [ 'Fuel charge',
    'Charge relating to fuel supplied.' ],
'288' => [ 'Registration plate charge',
    'The charge relating to the normal supply of vehicle registration plates.' ],
'289' => [ 'Subtotal amount',
    'Total amount of money that is part of a complete amount.' ],
'290' => [ 'Dumping export value',
    'The export value calculated for the purposes of assessing dumping duty.' ],
'291' => [ 'Foreign inland freight',
    'The amount of inland freight incurred in delivering the goods to the place of export.' ],
'292' => [ 'Concession amount',
    'The amount of any concession. To allow the nomination of the difference between the amount of duty plus tax paid and the amount that would have been payable without an end-use security being applied.' ],
'293' => [ 'Chargeback',
    'Invoice amount charged back to seller.' ],
'294' => [ 'Charge per credit cover',
    'Unit charge per credit cover established.' ],
'295' => [ 'Charge per unused credit cover',
    'Unit charge per unused credit cover.' ],
'296' => [ 'Total authorised deduction',
    'Total amount of authorised deductions.' ],
'297' => [ 'Total chargebacks',
    'Total amount charged back to the seller.' ],
'298' => [ 'Total offsets',
    "Total amount offset against other items on the seller's or buyer's account." ],
'299' => [ 'Total special entries',
    'Total amount to be treated as special booking entry by the beneficiary.' ],
'300' => [ 'Balance carried forward',
    'Closing balance of the account to be carried forward to the next accounting period.' ],
'301' => [ 'Total outstanding invoices past due',
    'Total amount of outstanding invoices past due.' ],
'302' => [ 'Off balance disputed items',
    'Total amount of disputed invoices/credit notes.' ],
'303' => [ 'Commission invoices',
    'Amount of commission invoices.' ],
'304' => [ 'Other charges',
    'Miscellaneous charges.' ],
'305' => [ 'Amount remittances',
    'Amount of money remitted.' ],
'306' => [ 'Total amount of payment commission invoices',
    'Total amount of commission invoices paid.' ],
'307' => [ 'Total amount of payment other charges invoices',
    'Total amount of invoices for miscellaneous charges paid.' ],
'308' => [ 'Total amount credit notes',
    'Total amount of credit notes.' ],
'309' => [ 'Total adjustment invoices',
    'Total amount of adjustments to invoices.' ],
'310' => [ 'Total adjustment credit notes',
    'Total amount of adjustments to credit notes.' ],
'311' => [ 'Total adjustment payments',
    'Total amount of adjustments to payments.' ],
'312' => [ 'Base unit value',
    'Value per base unit.' ],
'313' => [ 'International freight',
    'The amount of freight paid for moving goods between place of export and place of import.' ],
'314' => [ 'Own risk amount',
    'Amount for own credit risk, not covered by credit cover.' ],
'315' => [ 'Opening balance',
    'The amount of the opening balance.' ],
'316' => [ 'Insurance premium',
    'Premium amount including commission without insurance tax and fees.' ],
'317' => [ 'Insurance commission',
    'Amount due to an intermediary to be chargeable to an insurer for obtaining insurance business.' ],
'318' => [ 'Insurance tax',
    'Insurance tax amount on insurance premium and fees.' ],
'319' => [ 'Fee of insurer',
    'Amount to be paid to an insurer as a handling charge.' ],
'320' => [ 'Fee of intermediary',
    'Amount to be paid to an intermediary as a handling fee.' ],
'321' => [ 'Debit flow',
    'Debit flow amount applying to an account.' ],
'322' => [ 'Closing balance payable',
    'Outstanding payable amount of the account at the end of the reporting period.' ],
'323' => [ 'Opening balance payable',
    'Outstanding payable amount of the account at the beginning of the reporting period.' ],
'324' => [ 'Opening balance receivable',
    'Outstanding receivable amount of the account at the beginning of the reporting period.' ],
'325' => [ 'Closing balance receivable',
    'Outstanding receivable payable amount of the account at the end of the reporting period.' ],
'326' => [ 'Net assets and liabilities',
    'Position amount of the assets and liabilities at reporting date.' ],
'327' => [ 'Adjustment to debit flow',
    'Adjustment to debit flow amount.' ],
'328' => [ 'Adjustment to credit flow',
    'Adjustment to a credit flow amount.' ],
'329' => [ 'Credit flow',
    'Credit flow amount applying to an account.' ],
'330' => [ 'Total prepaid other charges due carrier',
    'The total of prepaid other charges due to carrier.' ],
'331' => [ 'Total collect weight charge',
    'The total collect charge based on weight.' ],
'332' => [ 'Total prepaid weight charge',
    'The total prepaid charge based on weight.' ],
'333' => [ 'Total collect other charges due carrier',
    'The total of collect other charges due to carrier.' ],
'334' => [ 'Total prepaid other charges due agent',
    'The total of prepaid other charges due to agent.' ],
'335' => [ 'Total collect valuation charge',
    'The total collect valuation charge.' ],
'336' => [ 'Total prepaid valuation charge',
    'The total prepaid valuation charge.' ],
'337' => [ 'Authorized cleaning charges excluded from insurance',
    'Indicates the amount of cleaning charges authorized which are not covered by insurance.' ],
'338' => [ 'Escalated value',
    'Indicates the escalated value derived by application of an escalation factor to an original monetary value.' ],
'339' => [ 'Original invoice gross total value',
    'Indicates the gross total value of an original invoice.' ],
'340' => [ 'Original total net invoice value',
    'Indicates the net value of an original invoice after deduction or addition of all allowances or charges.' ],
'341' => [ 'Offset value',
    'Indicates the value of an offset.' ],
'342' => [ 'Non-taxable amount',
    'Monetary amount which is not subject to taxation.' ],
'343' => [ 'Closing balance',
    'The closing balance is the last balance for a reporting period.' ],
'344' => [ 'Value date balance',
    'This is the balance on value date.' ],
'345' => [ 'Cost information for providing the statement',
    'Cost information for providing the statement.' ],
'346' => [ 'Total credits',
    'The total of all credit items reported.' ],
'347' => [ 'Total debits',
    'The total of all debit items reported.' ],
'348' => [ 'Booked amount on the account',
    'Booked amount on the account.' ],
'349' => [ 'Pending amount to be booked on the account',
    'Pending amount to be booked on the account.' ],
'350' => [ 'Damage repair cost',
    'Cost incurred by repair of the damage.' ],
'351' => [ 'Labour rate per hour',
    'Amount of labour rate per hour.' ],
'352' => [ 'Total equipment labour costs for wear and tear',
    'The total amount of the labour costs of the repair of the equipment damage due to normal wear and tear.' ],
'353' => [ 'Total equipment repair material costs for wear and tear',
    'The total of the material costs of the repair of the equipment damage due to normal wear and tear.' ],
'354' => [ 'Add to make market value',
    'Addition to the base value of an item for customs duty computation purposes.' ],
'355' => [ 'Pro-ratable value',
    'The value is pro-ratable.' ],
'356' => [ 'Deduct to make market value',
    'Deduction from the base value of an item for customs duty computation purposes.' ],
'357' => [ 'Interim opening balance',
    'The opening balance of a consecutive statement.' ],
'358' => [ 'Interim closing balance',
    'The closing balance of a consecutive statement.' ],
'359' => [ 'Balance to be confirmed for audit reasons',
    'Balance to be confirmed for audit reasons.' ],
'360' => [ 'Accrued debit interest',
    'Accrued debit interest.' ],
'361' => [ 'Accrued credit interest',
    'Accrued credit interest.' ],
'362' => [ 'Part of booked amount',
    'The amount is contained within the booked amount.' ],
'363' => [ 'Increase of documentary credit amount',
    'Amount of increase of the documentary credit.' ],
'364' => [ 'Decrease of documentary credit amount',
    'Amount of decrease of the documentary credit.' ],
'365' => [ 'New documentary credit amount after amendment',
    'New amount of the documentary credit after an amendment.' ],
'366' => [ 'Rounding amount',
    'The amount by which an amount is being rounded.' ],
'367' => [ 'Labour sales tax',
    'Amount of sales tax applicable to the cost of labour.' ],
'368' => [ 'Material sales tax',
    'Amount of sales tax applicable to the cost of materials.' ],
'369' => [ 'Goods and services tax',
    'Amount charged as tax on goods and services.' ],
'370' => [ 'State or province sales tax',
    'Amount charged as state or province sales tax.' ],
'371' => [ 'Amount to be transferred',
    'The exact amount payable after any adjustments.' ],
'372' => [ 'Direct debit transfer amount',
    'The transfer amount of a direct debit.' ],
'373' => [ 'Total amount of negative credit entries',
    'Total amount of negative credit entries.' ],
'374' => [ 'Total amount of positive credit entries',
    'Total amount of positive credit entries.' ],
'375' => [ 'Total amount of positive debit entries',
    'Total amount of positive debit entries.' ],
'376' => [ 'Accounting entry amount',
    'Amount concerning an accounting entry.' ],
'377' => [ "Entry's expected amount",
    'Expected amount of an entry.' ],
'378' => [ 'Closing date credit balance',
    'The credit balance to be carried forward at closing date.' ],
'379' => [ 'Closing date debit balance',
    'The debit balance to be carried forward at closing date.' ],
'380' => [ 'Total amount of negative debit entries',
    'Total amount of negative debit entries.' ],
'381' => [ 'Budget cost',
    'The amount specified is the budget cost.' ],
'382' => [ 'Actual cost',
    'The amount specified is the actual cost.' ],
'383' => [ 'Estimate cost',
    'Amount specified is the estimate cost.' ],
'384' => [ 'Earned value cost',
    'Amount specified is the earned value cost.' ],
'385' => [ 'Warranty repair coverage',
    'The amount of repair covered under warranty.' ],
'386' => [ 'Maximum amount including Value Added Tax (VAT)',
    'The maximum monetary amount which includes the Value Added Tax (VAT).' ],
'387' => [ 'Minimum amount including Value Added Tax (VAT)',
    'The minimum monetary amount which includes the Value Added Tax (VAT).' ],
'388' => [ 'Total amount including Value Added Tax (VAT)',
    'The total monetary amount which includes the Value Added Tax (VAT).' ],
'389' => [ 'Amount excluding Value Added Tax (VAT)',
    'The monetary amount which excludes the Value Added Tax (VAT).' ],
'390' => [ 'Minimum amount excluding Value Added Tax (VAT)',
    'The minimum monetary amount which excludes the Value Added Tax (VAT).' ],
'391' => [ 'Indemnity amount',
    'The monetary amount which is used as an indemnity.' ],
'392' => [ 'Sub-contracted amount',
    'The monetary amount which will be sub-contracted.' ],
'393' => [ 'Amount due for work completed during a specified time',
    'period Monetary amount due for work completed during a specified time period.' ],
'394' => [ 'Minimum order or contract amount permitting a fixed sum',
    'advance The minimum monetary amount of an order or a contract which enables the payment of a fixed sum advance.' ],
'395' => [ 'Vending machine refund amount',
    'An amount refunded by a vending machine as change in a purchase.' ],
'396' => [ 'Total price subsidy value',
    'The total value of all price subsidies.' ],
'397' => [ 'Advertising amount',
    'Amount related to advertising.' ],
'398' => [ 'Fixed sum advance base amount',
    'The base amount on which a fixed sum advance is calculated.' ],
'399' => [ 'Optional advance amount',
    'The monetary amount which may be advanced on a payment.' ],
'400' => [ 'Rebate amount',
    'The amount of a rebate.' ],
'401' => [ 'Penalty basis amount',
    'Amount used as the basis to calculate a penalty.' ],
'402' => [ 'Total retail value',
    'The total retail value of all products.' ],
'403' => [ 'Exemption amount',
    'To specify an exempted amount.' ],
'404' => [ 'Budget amount',
    'To specify the amount of a budget.' ],
'405' => [ 'Value of services remaining to be carried out',
    'To specify the monetary amount for which services remain to be carried out.' ],
'406' => [ 'Maximum amount excluding value added tax',
    'The maximum amount without the addition of a value added tax.' ],
'407' => [ 'Annual revenue',
    'The amount of revenue received in a year.' ],
'408' => [ 'Co-insurance commission',
    'The commission paid to the lead insurer for co- insurance.' ],
'409' => [ 'Negotiated cost',
    'The current cost value to which all parties have negotiated and agreed.' ],
'410' => [ 'Estimated cost, authorized unpriced work',
    'The estimated cost for work for which written authorization has been received, but the work has not been priced.' ],
'411' => [ 'Contract target profit',
    'The profit that will be realised if a contract target is met.' ],
'412' => [ 'Contract target fee',
    'The incentive fee amount that will apply if the contract target is met.' ],
'413' => [ 'Contract target price',
    'The negotiated contract cost, plus profit or incentive fees paid for meeting contract target objectives.' ],
'414' => [ 'Final contract price, estimated',
    'The estimated final contract price based on the most likely estimate of cost at completion.' ],
'415' => [ 'Contract ceiling price',
    'The upper price limit on a contract.' ],
'416' => [ 'Contract ceiling price, estimated',
    'The estimated upper price limit on a contract.' ],
'417' => [ 'Contract cost to completion, estimated',
    'The estimated cost to complete the contract.' ],
'418' => [ 'Contract cost at contract completion, estimated',
    'The estimated cost of the contract when it is complete.' ],
'419' => [ 'Contract cost at completion, best case estimate',
    'The best case estimated cost of the contract when it is complete.' ],
'420' => [ 'Contract cost at completion, worst case estimate',
    'The worst case estimated cost of the contract when it is complete.' ],
'421' => [ 'Contract cost at completion, most likely estimate',
    'The most likely estimated cost of the contract when it is complete.' ],
'422' => [ 'Contract budget base',
    'The budget base cost for a contract.' ],
'423' => [ 'Contract cost of money',
    'The cost of money applicable to a contract.' ],
'424' => [ 'General and administrative costs',
    'Costs attributed to general and administrative activities.' ],
'425' => [ 'Contract undistributed budget cost',
    'Budget cost not assigned or distributed to contract activities.' ],
'426' => [ 'Contract management reserve',
    'Amount of the contract budget withheld for management purposes.' ],
'427' => [ 'Budget performance',
    'The budget baseline amount against which performance is measured.' ],
'428' => [ 'Budget cost, cumulative to date',
    'The cumulative to date cost of planned work.' ],
'429' => [ 'Actual cost, cumulative to date',
    'Cumulative to date amount of actual costs.' ],
'430' => [ 'Earned value cost, cumulative to date',
    'The cumulative to date value of costs earned as work is completed.' ],
'431' => [ 'Cost variance',
    'The difference between the actual cost incurred to complete work and the budget cost of the work completed (earned value) for a given reporting period.' ],
'432' => [ 'Cost variance, cumulative to date',
    'The cumulative to date difference between the actual cost incurred to complete work and the budget cost of the work completed (earned value) for a given reporting period.' ],
'433' => [ 'Contract replanning adjustment, cost variance',
    'The amount of adjustment made to cost variances when it is necessary to replan the remaining work on a contract.' ],
'434' => [ 'Contract replanning adjustment, budget',
    'The amount of adjustments made to a budget baseline when it is necessary to replan the remaining work on a contract.' ],
'435' => [ 'Budget cost at completion',
    'The cost of the budget at the completion of a contract or project.' ],
'436' => [ 'Contract negotiated cost, original',
    'The original cost value for a contract that all parties involved have negotiated and agreed to.' ],
'437' => [ 'Contract target price, initial',
    'The initial negotiated contract costs, plus profit or incentive fees, paid for meeting contract target objectives.' ],
'438' => [ 'Contract ceiling price, initial',
    'The initial upper price limit on a contract.' ],
'439' => [ 'Contract target price, adjusted',
    'The adjusted negotiated contract cost plus target or incentive fees paid for meeting contract target objectives.' ],
'440' => [ 'Contract ceiling price, adjusted',
    'The adjusted upper price limit on a contract.' ],
'441' => [ 'Open commitment amount',
    'Estimated obligations to vendors.' ],
'442' => [ 'Accrued expenditure',
    'Recorded or incurred expenditures.' ],
'443' => [ 'Contract funds authorized, to date',
    'Cost value of contract funds authorized from the beginning of the contract or from a specific fiscal year through the current reporting period.' ],
'444' => [ 'Contract billing, forecast',
    'The amount expected to be billed for a contract.' ],
'445' => [ 'Contract termination costs, estimated',
    'The estimate of the costs that would be incurred to liquidate all obligations if the contract were to be terminated.' ],
'446' => [ 'Contract funds forecast, unauthorized work',
    'A forecast of the funds required for unauthorized work on a contract.' ],
'447' => [ 'Contract funds forecast, additional work',
    'A forecast of the funds required for additional work on a contract.' ],
'448' => [ 'Contract total funds required, estimated',
    'Estimate of the total funds required for a contract.' ],
'449' => [ 'Contract funds carried forward',
    'Amount of contract funds carried forward.' ],
'450' => [ 'Contract net funds required, estimated',
    'Estimate of net funds required for a contract based on total funding requirements less any funds carried over from a previous year.' ],
'451' => [ 'Cost variance at completion',
    'The cost difference between budget at completion and estimate at completion.' ],
'452' => [ 'Harmonized tariff schedule mixture, composite or set value',
    'The value of a mixture, composite, or set as defined by the harmonized tariff schedule general rules of interpretation 3(b) or 3(c).' ],
'453' => [ 'Agreed monetary amount debit line limit',
    'Limit of the agreed monetary amount debit line.' ],
'454' => [ 'Total debit charges, not included in debit amount',
    'Total debit related charges, not included in debit amount.' ],
'455' => [ 'Total debit allowances, not included in debit amount',
    'Total debit related allowances, not included in debit amount.' ],
'456' => [ 'Total debit charges, included in debit amount',
    'Total debit related charges, included in debit amount.' ],
'457' => [ 'Total debit allowances, included in debit amount',
    'Total debit related allowances, included in debit amount.' ],
'458' => [ 'Total debit charges, not included in debit amount, to be',
    'booked simultaneously with debit amount Total debit related charges, not included in debit amount, to be booked at the same time as the debit amount.' ],
'459' => [ 'Total debit allowances, not included in debit amount, to be',
    'booked simultaneously with debit amount Total debit related allowances, not included in debit amount, to be booked at the same time as the debit amount.' ],
'460' => [ 'Total debit charges, not included in debit amount, to be',
    'booked separately from debit amount Total debit related charges, not included in debit amount, not to be booked together with the debit amount.' ],
'461' => [ 'Total debit allowances, not included in debit amount, to be',
    'booked separately from debit amount Total debit related allowances, not included in debit amount, not to be booked together with the debit amount.' ],
'462' => [ 'Annual turnover',
    'The annual turnover.' ],
'463' => [ 'Dispensing fee',
    'Fee for dispensing.' ],
'464' => [ 'Gross premium',
    'The total premium including all commission and fees but excluding external taxes.' ],
'465' => [ 'Net premium',
    'The premium net of all additions.' ],
'466' => [ 'Engineering fee amount',
    'The amount of engineering fees.' ],
'467' => [ 'Insurer paid tax amount',
    'The amount of tax that is paid by the insurer and not included in the premium.' ],
'468' => [ 'Insurance fixed co-payment',
    'The fixed contribution required to be paid by the insured person.' ],
'469' => [ 'Insurance variable co-payment',
    'The variable contribution required to be paid by the insured person.' ],
'470' => [ 'Negotiated contract changes',
    'The cumulative cost, excluding any fee or profit, applicable to defined contract changes that have occurred since the beginning of the contract and have been negotiated and agreed to.' ],
'471' => [ 'Pre-invoiced amount',
    'Amount that is, or will be pre-invoiced.' ],
'472' => [ 'Amount accumulated to deductible',
    'Amount paid toward the deductible amount.' ],
'473' => [ 'Deductible amount remaining',
    'The amount of the deductible remaining.' ],
'474' => [ 'Postage',
    'The amount for postage.' ],
'475' => [ 'Earlier debit amount',
    'Amount which has been debited earlier.' ],
'476' => [ 'Opening value date balance',
    'Opening balance on the value date.' ],
'477' => [ 'Closing value date balance',
    'Closing balance on the value date.' ],
'478' => [ 'Schedule variance amount',
    'The difference between the amount of work scheduled or planned (the budget) and the work completed (earned value) in cost terms for a given reporting period.' ],
'479' => [ 'Schedule variance amount, cumulative to date',
    'The cumulative to date difference between the amount of work scheduled or planned (the budget) and the work completed (earned value) in cost terms.' ],
'480' => [ 'Total debit charges, not included in credit amount',
    'Total debit-related charges, not yet included in credit amount.' ],
'481' => [ 'Total credit allowances, not included in credit amount',
    'Total credit-related allowances, not yet included in credit amount.' ],
'482' => [ 'Total debit charges, included in credit amount',
    'Total debit-related charges, already included in credit amount.' ],
'483' => [ 'Total credit allowances, included in credit amount',
    'Total credit-related allowances, already included in credit amount.' ],
'484' => [ 'Total debit charges, not included in credit amount, to be',
    'booked simultaneously with credit amount Total debit-related charges, not yet inlcuded in credit amount, will be booked at the same time as the credit amount.' ],
'485' => [ 'Total credit allowances, not included in credit amount, to',
    'be booked simultaneously with credit amount Total credit-related allowances, not yet included in credit amount, will be booked at the same time as the credit amount.' ],
'486' => [ 'Total debit charges, not included in credit amount, to be',
    'booked separately from credit amount Total debit-related charges, not yet included in credit amount, will not be booked together with the credit amount.' ],
'487' => [ 'Total credit allowances, not included in credit amount, to',
    'be booked separately from credit amount Total credit-related allowances, not yet included in credit amount, will not be booked together with the credit amount.' ],
'488' => [ 'Total charges, not included in transaction amount',
    'Total charges which are not included in the transaction amount.' ],
'489' => [ 'Total allowances, not included in transaction amount',
    'Total allowances which are not included in the transaction amount.' ],
'490' => [ 'Late delivery penalty',
    'Amount to be paid in case of late delivery.' ],
'491' => [ 'Debt financing charge',
    'A charge amount related to the financing of a debt.' ],
'492' => [ 'Debt financing allowance',
    'An allowance amount related to the financing of a debt.' ],
'493' => [ 'Cancellation charge',
    'The amount charged because of a cancellation.' ],
'494' => [ 'Incurred cost',
    'The amount which has been incurred.' ],
'495' => [ 'Accrued overdraft interest',
    'Interest amount accrued through overdraft.' ],
'496' => [ 'Total returnable packaging deposit amount',
    'Total deposit amount for returnable packaging.' ],
'497' => [ 'Goods and services total amount excluding returnable goods',
    'deposits Total amount of goods and services excluding deposits for returnable goods.' ],
'498' => [ 'Waiting time indemnity amount',
    'The monetary amount which is used as an indemnity for waiting.' ],
'499' => [ 'Total net amount excluding Value Added Tax (VAT)',
    'The total net monetary amount excluding Value Added Tax (VAT).' ],
'500' => [ 'Interest on late payment of solidarity fund contribution',
    'Interest to pay because payment date of contribution solidarity fund was exceeded.' ],
'501' => [ "Interest on late payment of employee's additional",
    "contribution to solidarity fund Interest to pay because payment date of employee's additional contribution is exceeded." ],
'502' => [ 'Taxable disbursement amount',
    'Amount of disbursement on which tax must be applied.' ],
'503' => [ 'Contract total amount',
    '[5060] Total value of a contract.' ],
'504' => [ 'Daily contribution',
    'Amount paid on a daily basis.' ],
'505' => [ 'Rental amount',
    'The amount to be paid for the right to use a place, product or service.' ],
'506' => [ 'Gross progress payment amount',
    'Gross monetary amount paid or to be paid at intervals.' ],
'507' => [ 'Net progress payment amount',
    'Net monetary amount paid or to be paid at intervals.' ],
'508' => [ 'Value of returned product',
    'Value of product returned by the customer.' ],
'509' => [ 'Unit allowance amount',
    'The monetary amount of an allowance for each unit.' ],
'510' => [ 'Remaining available overdraft',
    'The amount still available within the limit of the overdraft.' ],
'511' => [ 'Unit charge amount',
    'The monetary amount of a charge for each unit.' ],
'512' => [ 'Agreed monetary amount credit line limit',
    'Limit of the agreed monetary amount credit line.' ],
'513' => [ 'Dossier amount',
    'The amount of the dossier.' ],
'514' => [ 'Amount for pre-advising',
    'The amount is for pre-advising only.' ],
'515' => [ 'Supplement',
    'The monetary amount represents the price of extra cost to pay in addition to the normal price.' ],
'516' => [ 'Debit balance at closing date of accounting period under',
    'review The monetary amonunt is the debit balance at the closing date of the accounting period under review.' ],
'517' => [ 'Credit balance at closing date of accounting period under',
    'review The monetary amount is the credit balance at the closing date of the accounting period under review.' ],
'518' => [ 'Debit balance at starting date of accounting period under',
    'review The monetary amount is the debit balance at the starting date of the accounting period under review.' ],
'519' => [ 'Credit balance at starting date of accounting period under',
    'review The monetary amount is the credit balance at the starting date of the accounting period under review.' ],
'520' => [ 'Total of debit balances at closing date of accounting',
    'period under review The monetary amount is the total of debit balances at the closing date of the accounting period under review.' ],
'521' => [ 'Total of credit balances at closing date of accounting',
    'period under review The monetary amount is the total of credit balances at the closing date of the accounting period under review.' ],
'522' => [ 'Total of debit balances at starting date of accounting',
    'period under review The monetary amount is the total of debit balances at the starting date of the accounting period under review.' ],
'523' => [ 'Total of credit balances at starting date of accounting',
    'period under review The monetary amount is the total of credit balances at the starting date of the accounting period under review.' ],
'524' => [ 'Cost accounting entry amount',
    'Code identifying the amount of a cost accounting entry.' ],
'525' => [ 'Tariff',
    'The monetary amount represents the tariff.' ],
'526' => [ 'Volume discount',
    'A discount for reaching or exceeding an agreed volume.' ],
'527' => [ 'Product range discount',
    'Discount for the purchase of a whole range of products.' ],
'528' => [ 'Calculation basis excluding all taxes',
    'The amount used as the basis for calculation excludes all taxes.' ],
'529' => [ 'Calculation basis which includes all taxes except VAT',
    'The amount, used as the basis for calculation, which includes all taxes except Value Added Tax (VAT).' ],
'530' => [ 'Refund',
    'The monetary amount being reimbursed.' ],
'531' => [ 'Total returnable packaging rental amount',
    'Total rental amount for returnable packaging.' ],
'532' => [ 'Total Marine Diesel Oil on board amount, on arrival',
    'Total amount of Marine Diesel Oil (MDO) on board when vessel arrives in port.' ],
'533' => [ 'Total Marine Diesel Oil amount, loaded',
    'Total amount of Marine Diesel Oil (MDO) taken on in the port.' ],
'534' => [ 'Total Intermediate Fuel Oil on board amount, on arrival',
    'Total amount of Intermediate Fuel Oil (IFO) on board when vessel arrives in port.' ],
'535' => [ 'Total Intermediate Fuel Oil amount, loaded',
    'Total amount of Intermediate Fuel Oil (IFO) taken on in the port.' ],
'536' => [ 'Total Bunker C oil on board amount, on arrival',
    'Total amount of Bunker C, or Number 6 fuel oil on board when vessel arrives in port.' ],
'537' => [ 'Total Bunker C oil amount, loaded',
    'Total amount of Bunker C or Number 6 fuel oil on board when vessel arrives in port.' ],
'538' => [ 'Government agency valuation commodity value',
    'The value of the commodity for the purposes of a government agency valuation.' ],
'539' => [ 'Valuation adjustment amount',
    'Amount of adjustments to the valuation, e.g. price influence, royalties, assists, proceeds and commissions.' ],
'540' => [ 'Damage allowance',
    'An allowance made in the value to the extent of the damage or defect.' ],
'541' => [ 'Air transport freight cost',
    'Charges relating to the air transport of the goods which represent the freight charges only (i.e. not including the handling charges, agency fees etc.).' ],
'ZZZ' => [ 'Mutually defined',
    'Mutually defined monetary amount.' ],
);
sub get_codes { return \%code_hash; }

1;
