# Generated by default/object.tt
package Paws::ApplicationAutoScaling::StepScalingPolicyConfiguration;
  use Moose;
  has AdjustmentType => (is => 'ro', isa => 'Str');
  has Cooldown => (is => 'ro', isa => 'Int');
  has MetricAggregationType => (is => 'ro', isa => 'Str');
  has MinAdjustmentMagnitude => (is => 'ro', isa => 'Int');
  has StepAdjustments => (is => 'ro', isa => 'ArrayRef[Paws::ApplicationAutoScaling::StepAdjustment]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApplicationAutoScaling::StepScalingPolicyConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApplicationAutoScaling::StepScalingPolicyConfiguration object:

  $service_obj->Method(Att1 => { AdjustmentType => $value, ..., StepAdjustments => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApplicationAutoScaling::StepScalingPolicyConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AdjustmentType

=head1 DESCRIPTION

Represents a step scaling policy configuration to use with Application
Auto Scaling.

=head1 ATTRIBUTES


=head2 AdjustmentType => Str

Specifies how the C<ScalingAdjustment> value in a StepAdjustment
(https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepAdjustment.html)
is interpreted (for example, an absolute number or a percentage). The
valid values are C<ChangeInCapacity>, C<ExactCapacity>, and
C<PercentChangeInCapacity>.

C<AdjustmentType> is required if you are adding a new step scaling
policy configuration.


=head2 Cooldown => Int

The amount of time, in seconds, to wait for a previous scaling activity
to take effect.

With scale-out policies, the intention is to continuously (but not
excessively) scale out. After Application Auto Scaling successfully
scales out using a step scaling policy, it starts to calculate the
cooldown time. The scaling policy won't increase the desired capacity
again unless either a larger scale out is triggered or the cooldown
period ends. While the cooldown period is in effect, capacity added by
the initiating scale-out activity is calculated as part of the desired
capacity for the next scale-out activity. For example, when an alarm
triggers a step scaling policy to increase the capacity by 2, the
scaling activity completes successfully, and a cooldown period starts.
If the alarm triggers again during the cooldown period but at a more
aggressive step adjustment of 3, the previous increase of 2 is
considered part of the current capacity. Therefore, only 1 is added to
the capacity.

With scale-in policies, the intention is to scale in conservatively to
protect your applicationE<rsquo>s availability, so scale-in activities
are blocked until the cooldown period has expired. However, if another
alarm triggers a scale-out activity during the cooldown period after a
scale-in activity, Application Auto Scaling scales out the target
immediately. In this case, the cooldown period for the scale-in
activity stops and doesn't complete.

Application Auto Scaling provides a default value of 300 for the
following scalable targets:

=over

=item *

ECS services

=item *

Spot Fleet requests

=item *

EMR clusters

=item *

AppStream 2.0 fleets

=item *

Aurora DB clusters

=item *

Amazon SageMaker endpoint variants

=item *

Custom resources

=back

For all other scalable targets, the default value is 0:

=over

=item *

DynamoDB tables

=item *

DynamoDB global secondary indexes

=item *

Amazon Comprehend document classification and entity recognizer
endpoints

=item *

Lambda provisioned concurrency

=item *

Amazon Keyspaces tables

=item *

Amazon MSK broker storage

=back



=head2 MetricAggregationType => Str

The aggregation type for the CloudWatch metrics. Valid values are
C<Minimum>, C<Maximum>, and C<Average>. If the aggregation type is
null, the value is treated as C<Average>.


=head2 MinAdjustmentMagnitude => Int

The minimum value to scale by when the adjustment type is
C<PercentChangeInCapacity>. For example, suppose that you create a step
scaling policy to scale out an Amazon ECS service by 25 percent and you
specify a C<MinAdjustmentMagnitude> of 2. If the service has 4 tasks
and the scaling policy is performed, 25 percent of 4 is 1. However,
because you specified a C<MinAdjustmentMagnitude> of 2, Application
Auto Scaling scales out the service by 2 tasks.


=head2 StepAdjustments => ArrayRef[L<Paws::ApplicationAutoScaling::StepAdjustment>]

A set of adjustments that enable you to scale based on the size of the
alarm breach.

At least one step adjustment is required if you are adding a new step
scaling policy configuration.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApplicationAutoScaling>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

