package Faker::Plugin::LoremWord;

use 5.018;

use strict;
use warnings;

use Venus::Class 'base';

base 'Faker::Plugin';

# VERSION

our $VERSION = '1.18';

# METHODS

sub execute {
  my ($self, $data) = @_;

  return $self->faker->random->select(data_for_lorem_word());
}

sub data_for_lorem_word {
  state $lorem_word = [
    'alias',
    'consequatur',
    'aut',
    'perferendis',
    'sit',
    'voluptatem',
    'accusantium',
    'doloremque',
    'aperiam',
    'eaque',
    'ipsa',
    'quae',
    'ab',
    'illo',
    'inventore',
    'veritatis',
    'et',
    'quasi',
    'architecto',
    'beatae',
    'vitae',
    'dicta',
    'sunt',
    'explicabo',
    'aspernatur',
    'aut',
    'odit',
    'aut',
    'fugit',
    'sed',
    'quia',
    'consequuntur',
    'magni',
    'dolores',
    'eos',
    'qui',
    'ratione',
    'voluptatem',
    'sequi',
    'nesciunt',
    'neque',
    'dolorem',
    'ipsum',
    'quia',
    'dolor',
    'sit',
    'amet',
    'consectetur',
    'adipisci',
    'velit',
    'sed',
    'quia',
    'non',
    'numquam',
    'eius',
    'modi',
    'tempora',
    'incidunt',
    'ut',
    'labore',
    'et',
    'dolore',
    'magnam',
    'aliquam',
    'quaerat',
    'voluptatem',
    'ut',
    'enim',
    'ad',
    'minima',
    'veniam',
    'quis',
    'nostrum',
    'exercitationem',
    'ullam',
    'corporis',
    'nemo',
    'enim',
    'ipsam',
    'voluptatem',
    'quia',
    'voluptas',
    'sit',
    'suscipit',
    'laboriosam',
    'nisi',
    'ut',
    'aliquid',
    'ex',
    'ea',
    'commodi',
    'consequatur',
    'quis',
    'autem',
    'vel',
    'eum',
    'iure',
    'reprehenderit',
    'qui',
    'in',
    'ea',
    'voluptate',
    'velit',
    'esse',
    'quam',
    'nihil',
    'molestiae',
    'et',
    'iusto',
    'odio',
    'dignissimos',
    'ducimus',
    'qui',
    'blanditiis',
    'praesentium',
    'laudantium',
    'totam',
    'rem',
    'voluptatum',
    'deleniti',
    'atque',
    'corrupti',
    'quos',
    'dolores',
    'et',
    'quas',
    'molestias',
    'excepturi',
    'sint',
    'occaecati',
    'cupiditate',
    'non',
    'provident',
    'sed',
    'ut',
    'perspiciatis',
    'unde',
    'omnis',
    'iste',
    'natus',
    'error',
    'similique',
    'sunt',
    'in',
    'culpa',
    'qui',
    'officia',
    'deserunt',
    'mollitia',
    'animi',
    'id',
    'est',
    'laborum',
    'et',
    'dolorum',
    'fuga',
    'et',
    'harum',
    'quidem',
    'rerum',
    'facilis',
    'est',
    'et',
    'expedita',
    'distinctio',
    'nam',
    'libero',
    'tempore',
    'cum',
    'soluta',
    'nobis',
    'est',
    'eligendi',
    'optio',
    'cumque',
    'nihil',
    'impedit',
    'quo',
    'porro',
    'quisquam',
    'est',
    'qui',
    'minus',
    'id',
    'quod',
    'maxime',
    'placeat',
    'facere',
    'possimus',
    'omnis',
    'voluptas',
    'assumenda',
    'est',
    'omnis',
    'dolor',
    'repellendus',
    'temporibus',
    'autem',
    'quibusdam',
    'et',
    'aut',
    'consequatur',
    'vel',
    'illum',
    'qui',
    'dolorem',
    'eum',
    'fugiat',
    'quo',
    'voluptas',
    'nulla',
    'pariatur',
    'at',
    'vero',
    'eos',
    'et',
    'accusamus',
    'officiis',
    'debitis',
    'aut',
    'rerum',
    'necessitatibus',
    'saepe',
    'eveniet',
    'ut',
    'et',
    'voluptates',
    'repudiandae',
    'sint',
    'et',
    'molestiae',
    'non',
    'recusandae',
    'itaque',
    'earum',
    'rerum',
    'hic',
    'tenetur',
    'a',
    'sapiente',
    'delectus',
    'ut',
    'aut',
    'reiciendis',
    'voluptatibus',
    'maiores',
    'doloribus',
    'asperiores',
    'repellat',
  ]
}

1;



=head1 NAME

Faker::Plugin::LoremWord - Lorem Word

=cut

=head1 ABSTRACT

Lorem Word for Faker

=cut

=head1 VERSION

1.18

=cut

=head1 SYNOPSIS

  package main;

  use Faker::Plugin::LoremWord;

  my $plugin = Faker::Plugin::LoremWord->new;

  # bless(..., "Faker::Plugin::LoremWord")

=cut

=head1 DESCRIPTION

This package provides methods for generating fake data for lorem word.

=encoding utf8

=cut

=head1 INHERITS

This package inherits behaviors from:

L<Faker::Plugin>

=cut

=head1 METHODS

This package provides the following methods:

=cut

=head2 execute

  execute(HashRef $data) (Str)

The execute method returns a returns a random fake lorem word.

I<Since C<1.10>>

=over 4

=item execute example 1

  package main;

  use Faker::Plugin::LoremWord;

  my $plugin = Faker::Plugin::LoremWord->new;

  # bless(..., "Faker::Plugin::LoremWord")

  # my $result = $plugin->execute;

  # "nisi";

  # my $result = $plugin->execute;

  # "nihil";

  # my $result = $plugin->execute;

  # "vero";

=back

=cut

=head2 new

  new(HashRef $data) (Plugin)

The new method returns a new instance of the class.

I<Since C<1.10>>

=over 4

=item new example 1

  package main;

  use Faker::Plugin::LoremWord;

  my $plugin = Faker::Plugin::LoremWord->new;

  # bless(..., "Faker::Plugin::LoremWord")

=back

=cut

=head1 AUTHORS

Awncorp, C<awncorp@cpan.org>

=cut

=head1 LICENSE

Copyright (C) 2000, Al Newkirk.

This program is free software, you can redistribute it and/or modify it under
the terms of the Apache license version 2.0.

=cut