package Daje::Workflow::GeneratePerl::Generate::BaseClass;
use Mojo::Base 'Daje::Workflow::GeneratePerl::Base::Common' ,-base, -signatures;

# =head1 NAME
#
# Daje::Workflow::GeneratePerl::Generate::BaseClass - Create base class
#
#
# REQUIRES
# ========
#
#    use Mojo::Base
#
#
# SYNOPSIS
# ========
#
#   use Daje::Workflow::GeneratePerl::Generate::BaseClass;
#
#
# METHODS
# =======
#
#   generate($self)
#

our $VERSION = '0.01';

sub generate($self) {
    my $tpl = $self->templates->get_data_section('baseclass');

    my $base_name_space = $self->context->{context}->{perl}->{base_name_space};

    my $date = localtime();
    $tpl =~ s/<<date>>/$date/ig;
    $tpl =~ s/<<base_name_space>>/$base_name_space/ig;

    my $data->{file} = $self->context->{context}->{perl}->{base_space_dir} . "Base.pm";
    $data->{data} = $tpl;
    $data->{path} = 1;
    push(@{$self->context->{context}->{perlfiles}}, $data);
}

1;


#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Workflow::GeneratePerl::Generate::BaseClass


=head1 SYNOPSIS


  use Daje::Workflow::GeneratePerl::Generate::BaseClass;




=head1 DESCRIPTION

=head1 NAME

Daje::Workflow::GeneratePerl::Generate::BaseClass - Create base class




=head1 REQUIRES


   use Mojo::Base




=head1 METHODS


  generate($self)



=cut

