package Devel::Optic::Lens::Perlish;
use strict;
use warnings;

use Devel::Optic::Lens::Perlish::Parser qw(parse);
use Devel::Optic::Lens::Perlish::Interpreter qw(run);

sub new {
    my ($class) = @_;
    my $self = {};
    bless $self, $class;
}

sub inspect {
    my ($self, $scope, $query) = @_;
    my $ast = parse($query);
    return run($scope, $ast);
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Devel::Optic::Lens::Perlish

=head1 VERSION

version 0.007

=head1 AUTHOR

Ben Tyler <btyler@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2019 by Ben Tyler.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
