//============================================================================
//	File:	HLI.xs
//	Author:	Fame, h2xs and Dave Oberholtzer (daveo@obernet.com)
//			Copyright (c)2001, FISI, David Oberholtzer and Measurisk.
//	Date:	2001/04/18
//	Use:	Import the FAME #define vars into the FameHLI::API::HLI package.
//	Usage:	use FameHLI::API::HLI;
//============================================================================
//	This file was generated by running h2xs on the Fame hli.h header
//	file which comes with FAME.  Some additional masaging was necessary
//	to make it work properly, most notably MISSING VALUES.
//============================================================================
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "hli.h"

static int
not_here(char *s)
{
    croak("%s not implemented on this architecture", s);
    return -1;
}

static double
constant_HNAM(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'E':
	if (strEQ(name + 4, "EL")) {	/* HNAM removed */
#ifdef HNAMEL
	    return HNAMEL;
#else
	    goto not_there;
#endif
	}
    case 'L':
	if (strEQ(name + 4, "LEN")) {	/* HNAM removed */
#ifdef HNAMLEN
	    return HNAMLEN;
#else
	    goto not_there;
#endif
	}
    case 'S':
	if (strEQ(name + 4, "SIZ")) {	/* HNAM removed */
#ifdef HNAMSIZ
	    return HNAMSIZ;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HNA(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'M':
	return constant_HNAM(name, len, arg);
    case 'V':
	if (strEQ(name + 3, "VAL")) {	/* HNA removed */
#ifdef HNAVAL
	    return HNAVAL;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HNC(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'O':
	if (strEQ(name + 3, "ONN")) {	/* HNC removed */
#ifdef HNCONN
	    return HNCONN;
#else
	    goto not_there;
#endif
	}
    case 'V':
	if (strEQ(name + 3, "VAL")) {	/* HNC removed */
#ifdef HNCVAL
	    return HNCVAL;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HNE(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'M':
	if (strEQ(name + 3, "MPT")) {	/* HNE removed */
#ifdef HNEMPT
	    return HNEMPT;
#else
	    goto not_there;
#endif
	}
    case 'T':
	if (strEQ(name + 3, "TCN")) {	/* HNE removed */
#ifdef HNETCN
	    return HNETCN;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HNF(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'A':
	if (strEQ(name + 3, "AME")) {	/* HNF removed */
#ifdef HNFAME
	    return HNFAME;
#else
	    goto not_there;
#endif
	}
    case 'I':
	if (strEQ(name + 3, "ILE")) {	/* HNF removed */
#ifdef HNFILE
	    return HNFILE;
#else
	    goto not_there;
#endif
	}
    case 'M':
	if (strEQ(name + 3, "MDB")) {	/* HNF removed */
#ifdef HNFMDB
	    return HNFMDB;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HNL(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'A':
	if (strEQ(name + 3, "ALL")) {	/* HNL removed */
#ifdef HNLALL
	    return HNLALL;
#else
	    goto not_there;
#endif
	}
    case 'O':
	if (strEQ(name + 3, "OCL")) {	/* HNL removed */
#ifdef HNLOCL
	    return HNLOCL;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HNM(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'C':
	if (strEQ(name + 3, "CA")) {	/* HNM removed */
#ifdef HNMCA
	    return HNMCA;
#else
	    goto not_there;
#endif
	}
    case 'V':
	if (strEQ(name + 3, "VAL")) {	/* HNM removed */
#ifdef HNMVAL
	    return HNMVAL;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HNO(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case '\0':
	if (strEQ(name + 3, "")) {	/* HNO removed */
#ifdef HNO
	    return HNO;
#else
	    goto not_there;
#endif
	}
    case 'M':
	if (strEQ(name + 3, "MEM")) {	/* HNO removed */
#ifdef HNOMEM
	    return HNOMEM;
#else
	    goto not_there;
#endif
	}
    case 'O':
	if (strEQ(name + 3, "OBJ")) {	/* HNO removed */
#ifdef HNOOBJ
	    return HNOOBJ;
#else
	    goto not_there;
#endif
	}
    case 'V':
	if (strEQ(name + 3, "V")) {	/* HNO removed */
#ifdef HNOV
	    return HNOV;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HNT(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'M':
	if (strEQ(name + 3, "MIS")) {	/* HNT removed */
#ifdef HNTMIS
	    return HNTMIS;
#else
	    goto not_there;
#endif
	}
    case 'W':
	if (strEQ(name + 3, "WIC")) {	/* HNT removed */
#ifdef HNTWIC
	    return HNTWIC;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HNU(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'F':
	if (strEQ(name + 3, "FRD")) {	/* HNU removed */
#ifdef HNUFRD
	    return HNUFRD;
#else
	    goto not_there;
#endif
	}
    case 'L':
	if (strEQ(name + 3, "LLP")) {	/* HNU removed */
#ifdef HNULLP
	    return HNULLP;
#else
	    goto not_there;
#endif
	}
    case 'M':
	if (strEQ(name + 3, "MRC")) {	/* HNU removed */
#ifdef HNUMRC
	    return HNUMRC;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HNW(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'F':
	if (strEQ(name + 3, "FEA")) {	/* HNW removed */
#ifdef HNWFEA
	    return HNWFEA;
#else
	    goto not_there;
#endif
	}
    case 'I':
	if (strEQ(name + 3, "ILD")) {	/* HNW removed */
#ifdef HNWILD
	    return HNWILD;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HN(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'A':
	return constant_HNA(name, len, arg);
    case 'B':
	if (strEQ(name + 2, "BACK")) {	/* HN removed */
#ifdef HNBACK
	    return HNBACK;
#else
	    goto not_there;
#endif
	}
    case 'C':
	return constant_HNC(name, len, arg);
    case 'D':
	if (strEQ(name + 2, "DVAL")) {	/* HN removed */
#ifdef HNDVAL
	    return HNDVAL;
#else
	    goto not_there;
#endif
	}
    case 'E':
	return constant_HNE(name, len, arg);
    case 'F':
	return constant_HNF(name, len, arg);
    case 'I':
	if (strEQ(name + 2, "INIT")) {	/* HN removed */
#ifdef HNINIT
	    return HNINIT;
#else
	    goto not_there;
#endif
	}
    case 'L':
	return constant_HNL(name, len, arg);
    case 'M':
	return constant_HNM(name, len, arg);
    case 'O':
	return constant_HNO(name, len, arg);
    case 'P':
	if (strEQ(name + 2, "POST")) {	/* HN removed */
#ifdef HNPOST
	    return HNPOST;
#else
	    goto not_there;
#endif
	}
    case 'R':
	if (strEQ(name + 2, "RESW")) {	/* HN removed */
#ifdef HNRESW
	    return HNRESW;
#else
	    goto not_there;
#endif
	}
    case 'S':
	if (strEQ(name + 2, "SUPP")) {	/* HN removed */
#ifdef HNSUPP
	    return HNSUPP;
#else
	    goto not_there;
#endif
	}
    case 'T':
	return constant_HNT(name, len, arg);
    case 'U':
	return constant_HNU(name, len, arg);
    case 'W':
	return constant_HNW(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HOBA(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'N':
	if (strEQ(name + 4, "NN")) {	/* HOBA removed */
#ifdef HOBANN
	    return HOBANN;
#else
	    goto not_there;
#endif
	}
    case 'V':
	if (strEQ(name + 4, "VG")) {	/* HOBA removed */
#ifdef HOBAVG
	    return HOBAVG;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HOB(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'A':
	return constant_HOBA(name, len, arg);
    case 'B':
	if (strEQ(name + 3, "BEG")) {	/* HOB removed */
#ifdef HOBBEG
	    return HOBBEG;
#else
	    goto not_there;
#endif
	}
    case 'E':
	if (strEQ(name + 3, "END")) {	/* HOB removed */
#ifdef HOBEND
	    return HOBEND;
#else
	    goto not_there;
#endif
	}
    case 'F':
	if (strEQ(name + 3, "FRM")) {	/* HOB removed */
#ifdef HOBFRM
	    return HOBFRM;
#else
	    goto not_there;
#endif
	}
    case 'H':
	if (strEQ(name + 3, "HI")) {	/* HOB removed */
#ifdef HOBHI
	    return HOBHI;
#else
	    goto not_there;
#endif
	}
    case 'L':
	if (strEQ(name + 3, "LO")) {	/* HOB removed */
#ifdef HOBLO
	    return HOBLO;
#else
	    goto not_there;
#endif
	}
    case 'S':
	if (strEQ(name + 3, "SUM")) {	/* HOB removed */
#ifdef HOBSUM
	    return HOBSUM;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 3, "UND")) {	/* HOB removed */
#ifdef HOBUND
	    return HOBUND;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HOP(char *name, int len, int arg)
{
    if (3 + 2 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[3 + 2]) {
    case 'D':
	if (strEQ(name + 3, "END")) {	/* HOP removed */
#ifdef HOPEND
	    return HOPEND;
#else
	    goto not_there;
#endif
	}
    case 'W':
	if (strEQ(name + 3, "ENW")) {	/* HOP removed */
#ifdef HOPENW
	    return HOPENW;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HO(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'B':
	return constant_HOB(name, len, arg);
    case 'C':
	if (strEQ(name + 2, "CT")) {	/* HO removed */
#ifdef HOCT
	    return HOCT;
#else
	    goto not_there;
#endif
	}
    case 'E':
	if (strEQ(name + 2, "EXI")) {	/* HO removed */
#ifdef HOEXI
	    return HOEXI;
#else
	    goto not_there;
#endif
	}
    case 'L':
	if (strEQ(name + 2, "LDDB")) {	/* HO removed */
#ifdef HOLDDB
	    return HOLDDB;
#else
	    goto not_there;
#endif
	}
    case 'M':
	if (strEQ(name + 2, "MODE")) {	/* HO removed */
#ifdef HOMODE
	    return HOMODE;
#else
	    goto not_there;
#endif
	}
    case 'P':
	return constant_HOP(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HPR(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'E':
	if (strEQ(name + 3, "ECN")) {	/* HPR removed */
#ifdef HPRECN
	    return HPRECN;
#else
	    goto not_there;
#endif
	}
    case 'O':
	if (strEQ(name + 3, "OTOTYPES_SUPPORTED")) {	/* HPR removed */
#ifdef HPROTOTYPES_SUPPORTED
	    return HPROTOTYPES_SUPPORTED;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HP(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case '1':
	if (strEQ(name + 2, "1REQ")) {	/* HP removed */
#ifdef HP1REQ
	    return HP1REQ;
#else
	    goto not_there;
#endif
	}
    case '2':
	if (strEQ(name + 2, "2REQ")) {	/* HP removed */
#ifdef HP2REQ
	    return HP2REQ;
#else
	    goto not_there;
#endif
	}
    case 'A':
	if (strEQ(name + 2, "ACK")) {	/* HP removed */
#ifdef HPACK
	    return HPACK;
#else
	    goto not_there;
#endif
	}
    case 'R':
	return constant_HPR(name, len, arg);
    case 'W':
	if (strEQ(name + 2, "WWOU")) {	/* HP removed */
#ifdef HPWWOU
	    return HPWWOU;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HQT(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'D':
	if (strEQ(name + 3, "DEC")) {	/* HQT removed */
#ifdef HQTDEC
	    return HQTDEC;
#else
	    goto not_there;
#endif
	}
    case 'N':
	if (strEQ(name + 3, "NOV")) {	/* HQT removed */
#ifdef HQTNOV
	    return HQTNOV;
#else
	    goto not_there;
#endif
	}
    case 'O':
	if (strEQ(name + 3, "OCT")) {	/* HQT removed */
#ifdef HQTOCT
	    return HQTOCT;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HQ(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'T':
	return constant_HQT(name, len, arg);
    case 'U':
	if (strEQ(name + 2, "UOTA")) {	/* HQ removed */
#ifdef HQUOTA
	    return HQUOTA;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HAF(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'R':
	if (strEQ(name + 3, "RI")) {	/* HAF removed */
#ifdef HAFRI
	    return HAFRI;
#else
	    goto not_there;
#endif
	}
    case 'T':
	if (strEQ(name + 3, "TER")) {	/* HAF removed */
#ifdef HAFTER
	    return HAFTER;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HANA(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'P':
	if (strEQ(name + 4, "PR")) {	/* HANA removed */
#ifdef HANAPR
	    return HANAPR;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 4, "UG")) {	/* HANA removed */
#ifdef HANAUG
	    return HANAUG;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HANJU(char *name, int len, int arg)
{
    switch (name[5 + 0]) {
    case 'L':
	if (strEQ(name + 5, "L")) {	/* HANJU removed */
#ifdef HANJUL
	    return HANJUL;
#else
	    goto not_there;
#endif
	}
    case 'N':
	if (strEQ(name + 5, "N")) {	/* HANJU removed */
#ifdef HANJUN
	    return HANJUN;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HANJ(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'A':
	if (strEQ(name + 4, "AN")) {	/* HANJ removed */
#ifdef HANJAN
	    return HANJAN;
#else
	    goto not_there;
#endif
	}
    case 'U':
	return constant_HANJU(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HANM(char *name, int len, int arg)
{
    if (4 + 1 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[4 + 1]) {
    case 'R':
	if (strEQ(name + 4, "AR")) {	/* HANM removed */
#ifdef HANMAR
	    return HANMAR;
#else
	    goto not_there;
#endif
	}
    case 'Y':
	if (strEQ(name + 4, "AY")) {	/* HANM removed */
#ifdef HANMAY
	    return HANMAY;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HAN(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'A':
	return constant_HANA(name, len, arg);
    case 'D':
	if (strEQ(name + 3, "DEC")) {	/* HAN removed */
#ifdef HANDEC
	    return HANDEC;
#else
	    goto not_there;
#endif
	}
    case 'F':
	if (strEQ(name + 3, "FEB")) {	/* HAN removed */
#ifdef HANFEB
	    return HANFEB;
#else
	    goto not_there;
#endif
	}
    case 'J':
	return constant_HANJ(name, len, arg);
    case 'M':
	return constant_HANM(name, len, arg);
    case 'N':
	if (strEQ(name + 3, "NOV")) {	/* HAN removed */
#ifdef HANNOV
	    return HANNOV;
#else
	    goto not_there;
#endif
	}
    case 'O':
	if (strEQ(name + 3, "OCT")) {	/* HAN removed */
#ifdef HANOCT
	    return HANOCT;
#else
	    goto not_there;
#endif
	}
    case 'S':
	if (strEQ(name + 3, "SEP")) {	/* HAN removed */
#ifdef HANSEP
	    return HANSEP;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HAP(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'O':
	if (strEQ(name + 3, "OST")) {	/* HAP removed */
#ifdef HAPOST
	    return HAPOST;
#else
	    goto not_there;
#endif
	}
    case 'P':
	if (strEQ(name + 3, "PY")) {	/* HAP removed */
#ifdef HAPPY
	    return HAPPY;
#else
	    goto not_there;
#endif
	}
    case 'R':
	if (strEQ(name + 3, "R")) {	/* HAP removed */
#ifdef HAPR
	    return HAPR;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HAS(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'A':
	if (strEQ(name + 3, "AT")) {	/* HAS removed */
#ifdef HASAT
	    return HASAT;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 3, "UN")) {	/* HAS removed */
#ifdef HASUN
	    return HASUN;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HAT(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'H':
	if (strEQ(name + 3, "HU")) {	/* HAT removed */
#ifdef HATHU
	    return HATHU;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 3, "UE")) {	/* HAT removed */
#ifdef HATUE
	    return HATUE;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HA(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'B':
	if (strEQ(name + 2, "BORT")) {	/* HA removed */
#ifdef HABORT
	    return HABORT;
#else
	    goto not_there;
#endif
	}
    case 'F':
	return constant_HAF(name, len, arg);
    case 'L':
	if (strEQ(name + 2, "LL")) {	/* HA removed */
#ifdef HALL
	    return HALL;
#else
	    goto not_there;
#endif
	}
    case 'M':
	if (strEQ(name + 2, "MON")) {	/* HA removed */
#ifdef HAMON
	    return HAMON;
#else
	    goto not_there;
#endif
	}
    case 'N':
	return constant_HAN(name, len, arg);
    case 'P':
	return constant_HAP(name, len, arg);
    case 'S':
	return constant_HAS(name, len, arg);
    case 'T':
	return constant_HAT(name, len, arg);
    case 'U':
	if (strEQ(name + 2, "UG")) {	/* HA removed */
#ifdef HAUG
	    return HAUG;
#else
	    goto not_there;
#endif
	}
    case 'W':
	if (strEQ(name + 2, "WED")) {	/* HA removed */
#ifdef HAWED
	    return HAWED;
#else
	    goto not_there;
#endif
	}
    case 'Y':
	if (strEQ(name + 2, "YPP")) {	/* HA removed */
#ifdef HAYPP
	    return HAYPP;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HREA(char *name, int len, int arg)
{
    if (4 + 1 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[4 + 1]) {
    case '\0':
	if (strEQ(name + 4, "D")) {	/* HREA removed */
#ifdef HREAD
	    return HREAD;
#else
	    goto not_there;
#endif
	}
    case 'O':
	if (strEQ(name + 4, "DO")) {	/* HREA removed */
#ifdef HREADO
	    return HREADO;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HRE(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'A':
	return constant_HREA(name, len, arg);
    case 'C':
	if (strEQ(name + 3, "CRD")) {	/* HRE removed */
#ifdef HRECRD
	    return HRECRD;
#else
	    goto not_there;
#endif
	}
    case 'S':
	if (strEQ(name + 3, "SFD")) {	/* HRE removed */
#ifdef HRESFD
	    return HRESFD;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HRM(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'K':
	if (strEQ(name + 3, "KEY")) {	/* HRM removed */
#ifdef HRMKEY
	    return HRMKEY;
#else
	    goto not_there;
#endif
	}
    case 'O':
	if (strEQ(name + 3, "ODE")) {	/* HRM removed */
#ifdef HRMODE
	    return HRMODE;
#else
	    goto not_there;
#endif
	}
    case 'T':
	if (strEQ(name + 3, "TDB")) {	/* HRM removed */
#ifdef HRMTDB
	    return HRMTDB;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HR(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'E':
	return constant_HRE(name, len, arg);
    case 'M':
	return constant_HRM(name, len, arg);
    case 'N':
	if (strEQ(name + 2, "NEXI")) {	/* HR removed */
#ifdef HRNEXI
	    return HRNEXI;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBAT(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'T':
	if (strEQ(name + 4, "TR")) {	/* HBAT removed */
#ifdef HBATTR
	    return HBATTR;
#else
	    goto not_there;
#endif
	}
    case 'Y':
	if (strEQ(name + 4, "YP")) {	/* HBAT removed */
#ifdef HBATYP
	    return HBATYP;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBA(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'S':
	if (strEQ(name + 3, "SRT")) {	/* HBA removed */
#ifdef HBASRT
	    return HBASRT;
#else
	    goto not_there;
#endif
	}
    case 'T':
	return constant_HBAT(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBC(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'L':
	if (strEQ(name + 3, "LAS")) {	/* HBC removed */
#ifdef HBCLAS
	    return HBCLAS;
#else
	    goto not_there;
#endif
	}
    case 'N':
	if (strEQ(name + 3, "NTX")) {	/* HBC removed */
#ifdef HBCNTX
	    return HBCNTX;
#else
	    goto not_there;
#endif
	}
    case 'O':
	if (strEQ(name + 3, "ONN")) {	/* HBC removed */
#ifdef HBCONN
	    return HBCONN;
#else
	    goto not_there;
#endif
	}
    case 'P':
	if (strEQ(name + 3, "PU")) {	/* HBC removed */
#ifdef HBCPU
	    return HBCPU;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBD(char *name, int len, int arg)
{
    if (3 + 1 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[3 + 1]) {
    case 'T':
	if (strEQ(name + 3, "ATE")) {	/* HBD removed */
#ifdef HBDATE
	    return HBDATE;
#else
	    goto not_there;
#endif
	}
    case 'Y':
	if (strEQ(name + 3, "AY")) {	/* HBD removed */
#ifdef HBDAY
	    return HBDAY;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBE(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'F':
	if (strEQ(name + 3, "FOR")) {	/* HBE removed */
#ifdef HBEFOR
	    return HBEFOR;
#else
	    goto not_there;
#endif
	}
    case 'G':
	if (strEQ(name + 3, "GIN")) {	/* HBE removed */
#ifdef HBEGIN
	    return HBEGIN;
#else
	    goto not_there;
#endif
	}
    case 'R':
	if (strEQ(name + 3, "RNG")) {	/* HBE removed */
#ifdef HBERNG
	    return HBERNG;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBFR(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'E':
	if (strEQ(name + 4, "EQ")) {	/* HBFR removed */
#ifdef HBFREQ
	    return HBFREQ;
#else
	    goto not_there;
#endif
	}
    case 'I':
	if (strEQ(name + 4, "I")) {	/* HBFR removed */
#ifdef HBFRI
	    return HBFRI;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBFL(char *name, int len, int arg)
{
    if (4 + 1 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[4 + 1]) {
    case 'B':
	if (strEQ(name + 4, "AB")) {	/* HBFL removed */
#ifdef HBFLAB
	    return HBFLAB;
#else
	    goto not_there;
#endif
	}
    case 'G':
	if (strEQ(name + 4, "AG")) {	/* HBFL removed */
#ifdef HBFLAG
	    return HBFLAG;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBF(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'I':
	if (strEQ(name + 3, "ILE")) {	/* HBF removed */
#ifdef HBFILE
	    return HBFILE;
#else
	    goto not_there;
#endif
	}
    case 'L':
	return constant_HBFL(name, len, arg);
    case 'M':
	if (strEQ(name + 3, "MON")) {	/* HBF removed */
#ifdef HBFMON
	    return HBFMON;
#else
	    goto not_there;
#endif
	}
    case 'R':
	return constant_HBFR(name, len, arg);
    case 'U':
	if (strEQ(name + 3, "UNC")) {	/* HBF removed */
#ifdef HBFUNC
	    return HBFUNC;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBGR(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'O':
	if (strEQ(name + 4, "OW")) {	/* HBGR removed */
#ifdef HBGROW
	    return HBGROW;
#else
	    goto not_there;
#endif
	}
    case 'P':
	if (strEQ(name + 4, "P")) {	/* HBGR removed */
#ifdef HBGRP
	    return HBGRP;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBG(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'L':
	if (strEQ(name + 3, "LNM")) {	/* HBG removed */
#ifdef HBGLNM
	    return HBGLNM;
#else
	    goto not_there;
#endif
	}
    case 'R':
	return constant_HBGR(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBI(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'M':
	if (strEQ(name + 3, "MON")) {	/* HBI removed */
#ifdef HBIMON
	    return HBIMON;
#else
	    goto not_there;
#endif
	}
    case 'N':
	if (strEQ(name + 3, "NDX")) {	/* HBI removed */
#ifdef HBINDX
	    return HBINDX;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBMON(char *name, int len, int arg)
{
    switch (name[5 + 0]) {
    case '\0':
	if (strEQ(name + 5, "")) {	/* HBMON removed */
#ifdef HBMON
	    return HBMON;
#else
	    goto not_there;
#endif
	}
    case 'T':
	if (strEQ(name + 5, "T")) {	/* HBMON removed */
#ifdef HBMONT
	    return HBMONT;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBMO(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'D':
	if (strEQ(name + 4, "DE")) {	/* HBMO removed */
#ifdef HBMODE
	    return HBMODE;
#else
	    goto not_there;
#endif
	}
    case 'N':
	return constant_HBMON(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBM(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'I':
	if (strEQ(name + 3, "ISS")) {	/* HBM removed */
#ifdef HBMISS
	    return HBMISS;
#else
	    goto not_there;
#endif
	}
    case 'N':
	if (strEQ(name + 3, "NOV")) {	/* HBM removed */
#ifdef HBMNOV
	    return HBMNOV;
#else
	    goto not_there;
#endif
	}
    case 'O':
	return constant_HBMO(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBN(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'C':
	if (strEQ(name + 3, "CHR")) {	/* HBN removed */
#ifdef HBNCHR
	    return HBNCHR;
#else
	    goto not_there;
#endif
	}
    case 'R':
	if (strEQ(name + 3, "RNG")) {	/* HBN removed */
#ifdef HBNRNG
	    return HBNRNG;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBOP(char *name, int len, int arg)
{
    if (4 + 1 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[4 + 1]) {
    case '\0':
	if (strEQ(name + 4, "T")) {	/* HBOP removed */
#ifdef HBOPT
	    return HBOPT;
#else
	    goto not_there;
#endif
	}
    case 'V':
	if (strEQ(name + 4, "TV")) {	/* HBOP removed */
#ifdef HBOPTV
	    return HBOPTV;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBOB(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'J':
	if (strEQ(name + 4, "JT")) {	/* HBOB removed */
#ifdef HBOBJT
	    return HBOBJT;
#else
	    goto not_there;
#endif
	}
    case 'S':
	if (strEQ(name + 4, "SV")) {	/* HBOB removed */
#ifdef HBOBSV
	    return HBOBSV;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBO(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'B':
	return constant_HBOB(name, len, arg);
    case 'O':
	if (strEQ(name + 3, "OLN")) {	/* HBO removed */
#ifdef HBOOLN
	    return HBOOLN;
#else
	    goto not_there;
#endif
	}
    case 'P':
	return constant_HBOP(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBPR(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'O':
	if (strEQ(name + 4, "OD")) {	/* HBPR removed */
#ifdef HBPROD
	    return HBPROD;
#else
	    goto not_there;
#endif
	}
    case 'S':
	if (strEQ(name + 4, "SP")) {	/* HBPR removed */
#ifdef HBPRSP
	    return HBPRSP;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBP(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'E':
	if (strEQ(name + 3, "ER")) {	/* HBP removed */
#ifdef HBPER
	    return HBPER;
#else
	    goto not_there;
#endif
	}
    case 'H':
	if (strEQ(name + 3, "HAS")) {	/* HBP removed */
#ifdef HBPHAS
	    return HBPHAS;
#else
	    goto not_there;
#endif
	}
    case 'R':
	return constant_HBPR(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBR(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'E':
	if (strEQ(name + 3, "EL")) {	/* HBR removed */
#ifdef HBREL
	    return HBREL;
#else
	    goto not_there;
#endif
	}
    case 'N':
	if (strEQ(name + 3, "NG")) {	/* HBR removed */
#ifdef HBRNG
	    return HBRNG;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBSR(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'N':
	if (strEQ(name + 4, "NG")) {	/* HBSR removed */
#ifdef HBSRNG
	    return HBSRNG;
#else
	    goto not_there;
#endif
	}
    case 'V':
	if (strEQ(name + 4, "VR")) {	/* HBSR removed */
#ifdef HBSRVR
	    return HBSRVR;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBSU(char *name, int len, int arg)
{
    if (4 + 1 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[4 + 1]) {
    case '\0':
	if (strEQ(name + 4, "N")) {	/* HBSU removed */
#ifdef HBSUN
	    return HBSUN;
#else
	    goto not_there;
#endif
	}
    case 'D':
	if (strEQ(name + 4, "ND")) {	/* HBSU removed */
#ifdef HBSUND
	    return HBSUND;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBS(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'A':
	if (strEQ(name + 3, "AT")) {	/* HBS removed */
#ifdef HBSAT
	    return HBSAT;
#else
	    goto not_there;
#endif
	}
    case 'B':
	if (strEQ(name + 3, "BUS")) {	/* HBS removed */
#ifdef HBSBUS
	    return HBSBUS;
#else
	    goto not_there;
#endif
	}
    case 'D':
	if (strEQ(name + 3, "DAY")) {	/* HBS removed */
#ifdef HBSDAY
	    return HBSDAY;
#else
	    goto not_there;
#endif
	}
    case 'E':
	if (strEQ(name + 3, "EL")) {	/* HBS removed */
#ifdef HBSEL
	    return HBSEL;
#else
	    goto not_there;
#endif
	}
    case 'R':
	return constant_HBSR(name, len, arg);
    case 'U':
	return constant_HBSU(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBT(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'H':
	if (strEQ(name + 3, "HU")) {	/* HBT removed */
#ifdef HBTHU
	    return HBTHU;
#else
	    goto not_there;
#endif
	}
    case 'I':
	if (strEQ(name + 3, "IME")) {	/* HBT removed */
#ifdef HBTIME
	    return HBTIME;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 3, "UE")) {	/* HBT removed */
#ifdef HBTUE
	    return HBTUE;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBUS(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'E':
	if (strEQ(name + 4, "ER")) {	/* HBUS removed */
#ifdef HBUSER
	    return HBUSER;
#else
	    goto not_there;
#endif
	}
    case 'N':
	if (strEQ(name + 4, "NS")) {	/* HBUS removed */
#ifdef HBUSNS
	    return HBUSNS;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HBU(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'N':
	if (strEQ(name + 3, "NIT")) {	/* HBU removed */
#ifdef HBUNIT
	    return HBUNIT;
#else
	    goto not_there;
#endif
	}
    case 'S':
	return constant_HBUS(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HB(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'A':
	return constant_HBA(name, len, arg);
    case 'B':
	if (strEQ(name + 2, "BASI")) {	/* HB removed */
#ifdef HBBASI
	    return HBBASI;
#else
	    goto not_there;
#endif
	}
    case 'C':
	return constant_HBC(name, len, arg);
    case 'D':
	return constant_HBD(name, len, arg);
    case 'E':
	return constant_HBE(name, len, arg);
    case 'F':
	return constant_HBF(name, len, arg);
    case 'G':
	return constant_HBG(name, len, arg);
    case 'I':
	return constant_HBI(name, len, arg);
    case 'K':
	if (strEQ(name + 2, "KEY")) {	/* HB removed */
#ifdef HBKEY
	    return HBKEY;
#else
	    goto not_there;
#endif
	}
    case 'L':
	if (strEQ(name + 2, "LEN")) {	/* HB removed */
#ifdef HBLEN
	    return HBLEN;
#else
	    goto not_there;
#endif
	}
    case 'M':
	return constant_HBM(name, len, arg);
    case 'N':
	return constant_HBN(name, len, arg);
    case 'O':
	return constant_HBO(name, len, arg);
    case 'P':
	return constant_HBP(name, len, arg);
    case 'R':
	return constant_HBR(name, len, arg);
    case 'S':
	return constant_HBS(name, len, arg);
    case 'T':
	return constant_HBT(name, len, arg);
    case 'U':
	return constant_HBU(name, len, arg);
    case 'V':
	if (strEQ(name + 2, "VER")) {	/* HB removed */
#ifdef HBVER
	    return HBVER;
#else
	    goto not_there;
#endif
	}
    case 'W':
	if (strEQ(name + 2, "WED")) {	/* HB removed */
#ifdef HBWED
	    return HBWED;
#else
	    goto not_there;
#endif
	}
    case 'Y':
	if (strEQ(name + 2, "YEAR")) {	/* HB removed */
#ifdef HBYEAR
	    return HBYEAR;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HSC(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'A':
	if (strEQ(name + 3, "ALA")) {	/* HSC removed */
#ifdef HSCALA
	    return HSCALA;
#else
	    goto not_there;
#endif
	}
    case 'L':
	if (strEQ(name + 3, "LLM")) {	/* HSC removed */
#ifdef HSCLLM
	    return HSCLLM;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HSER(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'I':
	if (strEQ(name + 4, "IE")) {	/* HSER removed */
#ifdef HSERIE
	    return HSERIE;
#else
	    goto not_there;
#endif
	}
    case 'V':
	if (strEQ(name + 4, "VR")) {	/* HSER removed */
#ifdef HSERVR
	    return HSERVR;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HSE(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'C':
	if (strEQ(name + 3, "C")) {	/* HSE removed */
#ifdef HSEC
	    return HSEC;
#else
	    goto not_there;
#endif
	}
    case 'P':
	if (strEQ(name + 3, "P")) {	/* HSE removed */
#ifdef HSEP
	    return HSEP;
#else
	    goto not_there;
#endif
	}
    case 'R':
	return constant_HSER(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HSMO(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'C':
	if (strEQ(name + 4, "CT")) {	/* HSMO removed */
#ifdef HSMOCT
	    return HSMOCT;
#else
	    goto not_there;
#endif
	}
    case 'D':
	if (strEQ(name + 4, "DE")) {	/* HSMO removed */
#ifdef HSMODE
	    return HSMODE;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HSM(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'A':
	if (strEQ(name + 3, "AUG")) {	/* HSM removed */
#ifdef HSMAUG
	    return HSMAUG;
#else
	    goto not_there;
#endif
	}
    case 'D':
	if (strEQ(name + 3, "DEC")) {	/* HSM removed */
#ifdef HSMDEC
	    return HSMDEC;
#else
	    goto not_there;
#endif
	}
    case 'F':
	if (strEQ(name + 3, "FIL")) {	/* HSM removed */
#ifdef HSMFIL
	    return HSMFIL;
#else
	    goto not_there;
#endif
	}
    case 'J':
	if (strEQ(name + 3, "JUL")) {	/* HSM removed */
#ifdef HSMJUL
	    return HSMJUL;
#else
	    goto not_there;
#endif
	}
    case 'L':
	if (strEQ(name + 3, "LEN")) {	/* HSM removed */
#ifdef HSMLEN
	    return HSMLEN;
#else
	    goto not_there;
#endif
	}
    case 'N':
	if (strEQ(name + 3, "NOV")) {	/* HSM removed */
#ifdef HSMNOV
	    return HSMNOV;
#else
	    goto not_there;
#endif
	}
    case 'O':
	return constant_HSMO(name, len, arg);
    case 'S':
	if (strEQ(name + 3, "SEP")) {	/* HSM removed */
#ifdef HSMSEP
	    return HSMSEP;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HSU(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'C':
	if (strEQ(name + 3, "CC")) {	/* HSU removed */
#ifdef HSUCC
	    return HSUCC;
#else
	    goto not_there;
#endif
	}
    case 'N':
	if (strEQ(name + 3, "N")) {	/* HSU removed */
#ifdef HSUN
	    return HSUN;
#else
	    goto not_there;
#endif
	}
    case 'S':
	if (strEQ(name + 3, "SPN")) {	/* HSU removed */
#ifdef HSUSPN
	    return HSUSPN;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HS(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'A':
	if (strEQ(name + 2, "AT")) {	/* HS removed */
#ifdef HSAT
	    return HSAT;
#else
	    goto not_there;
#endif
	}
    case 'C':
	return constant_HSC(name, len, arg);
    case 'E':
	return constant_HSE(name, len, arg);
    case 'M':
	return constant_HSM(name, len, arg);
    case 'N':
	if (strEQ(name + 2, "NFIL")) {	/* HS removed */
#ifdef HSNFIL
	    return HSNFIL;
#else
	    goto not_there;
#endif
	}
    case 'P':
	if (strEQ(name + 2, "PCDB")) {	/* HS removed */
#ifdef HSPCDB
	    return HSPCDB;
#else
	    goto not_there;
#endif
	}
    case 'R':
	if (strEQ(name + 2, "RVST")) {	/* HS removed */
#ifdef HSRVST
	    return HSRVST;
#else
	    goto not_there;
#endif
	}
    case 'T':
	if (strEQ(name + 2, "TRNG")) {	/* HS removed */
#ifdef HSTRNG
	    return HSTRNG;
#else
	    goto not_there;
#endif
	}
    case 'U':
	return constant_HSU(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HCH(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'A':
	if (strEQ(name + 3, "ANL")) {	/* HCH removed */
#ifdef HCHANL
	    return HCHANL;
#else
	    goto not_there;
#endif
	}
    case 'G':
	if (strEQ(name + 3, "GAC")) {	/* HCH removed */
#ifdef HCHGAC
	    return HCHGAC;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HCLN(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'L':
	if (strEQ(name + 4, "LM")) {	/* HCLN removed */
#ifdef HCLNLM
	    return HCLNLM;
#else
	    goto not_there;
#endif
	}
    case 'T':
	if (strEQ(name + 4, "T")) {	/* HCLN removed */
#ifdef HCLNT
	    return HCLNT;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HCL(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'C':
	if (strEQ(name + 3, "CHN")) {	/* HCL removed */
#ifdef HCLCHN
	    return HCLCHN;
#else
	    goto not_there;
#endif
	}
    case 'N':
	return constant_HCLN(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HC(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'A':
	if (strEQ(name + 2, "ASEX")) {	/* HC removed */
#ifdef HCASEX
	    return HCASEX;
#else
	    goto not_there;
#endif
	}
    case 'E':
	if (strEQ(name + 2, "EXI")) {	/* HC removed */
#ifdef HCEXI
	    return HCEXI;
#else
	    goto not_there;
#endif
	}
    case 'H':
	return constant_HCH(name, len, arg);
    case 'L':
	return constant_HCL(name, len, arg);
    case 'M':
	if (strEQ(name + 2, "MODE")) {	/* HC removed */
#ifdef HCMODE
	    return HCMODE;
#else
	    goto not_there;
#endif
	}
    case 'O':
	if (strEQ(name + 2, "ONT")) {	/* HC removed */
#ifdef HCONT
	    return HCONT;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HTM(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'I':
	if (strEQ(name + 3, "IS")) {	/* HTM removed */
#ifdef HTMIS
	    return HTMIS;
#else
	    goto not_there;
#endif
	}
    case 'O':
	if (strEQ(name + 3, "OUT")) {	/* HTM removed */
#ifdef HTMOUT
	    return HTMOUT;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HT(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'E':
	if (strEQ(name + 2, "ENDA")) {	/* HT removed */
#ifdef HTENDA
	    return HTENDA;
#else
	    goto not_there;
#endif
	}
    case 'H':
	if (strEQ(name + 2, "HU")) {	/* HT removed */
#ifdef HTHU
	    return HTHU;
#else
	    goto not_there;
#endif
	}
    case 'M':
	return constant_HTM(name, len, arg);
    case 'R':
	if (strEQ(name + 2, "RUNC")) {	/* HT removed */
#ifdef HTRUNC
	    return HTRUNC;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 2, "UE")) {	/* HT removed */
#ifdef HTUE
	    return HTUE;
#else
	    goto not_there;
#endif
	}
    case 'W':
	if (strEQ(name + 2, "WICM")) {	/* HT removed */
#ifdef HTWICM
	    return HTWICM;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HDA(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'I':
	if (strEQ(name + 3, "ILY")) {	/* HDA removed */
#ifdef HDAILY
	    return HDAILY;
#else
	    goto not_there;
#endif
	}
    case 'T':
	if (strEQ(name + 3, "TE")) {	/* HDA removed */
#ifdef HDATE
	    return HDATE;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HDU(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'P':
	if (strEQ(name + 3, "P")) {	/* HDU removed */
#ifdef HDUP
	    return HDUP;
#else
	    goto not_there;
#endif
	}
    case 'T':
	if (strEQ(name + 3, "TAR")) {	/* HDU removed */
#ifdef HDUTAR
	    return HDUTAR;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HD(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'A':
	return constant_HDA(name, len, arg);
    case 'B':
	if (strEQ(name + 2, "BCLM")) {	/* HD removed */
#ifdef HDBCLM
	    return HDBCLM;
#else
	    goto not_there;
#endif
	}
    case 'E':
	if (strEQ(name + 2, "EC")) {	/* HD removed */
#ifdef HDEC
	    return HDEC;
#else
	    goto not_there;
#endif
	}
    case 'H':
	if (strEQ(name + 2, "HOST")) {	/* HD removed */
#ifdef HDHOST
	    return HDHOST;
#else
	    goto not_there;
#endif
	}
    case 'M':
	if (strEQ(name + 2, "MODE")) {	/* HD removed */
#ifdef HDMODE
	    return HDMODE;
#else
	    goto not_there;
#endif
	}
    case 'P':
	if (strEQ(name + 2, "PRMC")) {	/* HD removed */
#ifdef HDPRMC
	    return HDPRMC;
#else
	    goto not_there;
#endif
	}
    case 'U':
	return constant_HDU(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HUND(char *name, int len, int arg)
{
    if (4 + 1 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[4 + 1]) {
    case 'T':
	if (strEQ(name + 4, "FT")) {	/* HUND removed */
#ifdef HUNDFT
	    return HUNDFT;
#else
	    goto not_there;
#endif
	}
    case 'X':
	if (strEQ(name + 4, "FX")) {	/* HUND removed */
#ifdef HUNDFX
	    return HUNDFX;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HUN(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'C':
	if (strEQ(name + 3, "CHG")) {	/* HUN removed */
#ifdef HUNCHG
	    return HUNCHG;
#else
	    goto not_there;
#endif
	}
    case 'D':
	return constant_HUND(name, len, arg);
    case 'E':
	if (strEQ(name + 3, "EXP")) {	/* HUN removed */
#ifdef HUNEXP
	    return HUNEXP;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HU(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'M':
	if (strEQ(name + 2, "MODE")) {	/* HU removed */
#ifdef HUMODE
	    return HUMODE;
#else
	    goto not_there;
#endif
	}
    case 'N':
	return constant_HUN(name, len, arg);
    case 'P':
	if (strEQ(name + 2, "PDRD")) {	/* HU removed */
#ifdef HUPDRD
	    return HUPDRD;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HE(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'N':
	if (strEQ(name + 2, "ND")) {	/* HE removed */
#ifdef HEND
	    return HEND;
#else
	    goto not_there;
#endif
	}
    case 'X':
	if (strEQ(name + 2, "XPIR")) {	/* HE removed */
#ifdef HEXPIR
	    return HEXPIR;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HFR(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'I':
	if (strEQ(name + 3, "I")) {	/* HFR removed */
#ifdef HFRI
	    return HFRI;
#else
	    goto not_there;
#endif
	}
    case 'M':
	if (strEQ(name + 3, "MLA")) {	/* HFR removed */
#ifdef HFRMLA
	    return HFRMLA;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HFYAU(char *name, int len, int arg)
{
    switch (name[5 + 0]) {
    case 'G':
	if (strEQ(name + 5, "G")) {	/* HFYAU removed */
#ifdef HFYAUG
	    return HFYAUG;
#else
	    goto not_there;
#endif
	}
    case 'T':
	if (strEQ(name + 5, "T")) {	/* HFYAU removed */
#ifdef HFYAUT
	    return HFYAUT;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HFYA(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'P':
	if (strEQ(name + 4, "PR")) {	/* HFYA removed */
#ifdef HFYAPR
	    return HFYAPR;
#else
	    goto not_there;
#endif
	}
    case 'U':
	return constant_HFYAU(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HFYF(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'E':
	if (strEQ(name + 4, "EB")) {	/* HFYF removed */
#ifdef HFYFEB
	    return HFYFEB;
#else
	    goto not_there;
#endif
	}
    case 'S':
	if (strEQ(name + 4, "ST")) {	/* HFYF removed */
#ifdef HFYFST
	    return HFYFST;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HFYJU(char *name, int len, int arg)
{
    switch (name[5 + 0]) {
    case 'L':
	if (strEQ(name + 5, "L")) {	/* HFYJU removed */
#ifdef HFYJUL
	    return HFYJUL;
#else
	    goto not_there;
#endif
	}
    case 'N':
	if (strEQ(name + 5, "N")) {	/* HFYJU removed */
#ifdef HFYJUN
	    return HFYJUN;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HFYJ(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'A':
	if (strEQ(name + 4, "AN")) {	/* HFYJ removed */
#ifdef HFYJAN
	    return HFYJAN;
#else
	    goto not_there;
#endif
	}
    case 'U':
	return constant_HFYJU(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HFYM(char *name, int len, int arg)
{
    if (4 + 1 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[4 + 1]) {
    case 'R':
	if (strEQ(name + 4, "AR")) {	/* HFYM removed */
#ifdef HFYMAR
	    return HFYMAR;
#else
	    goto not_there;
#endif
	}
    case 'Y':
	if (strEQ(name + 4, "AY")) {	/* HFYM removed */
#ifdef HFYMAY
	    return HFYMAY;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HFY(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'A':
	return constant_HFYA(name, len, arg);
    case 'D':
	if (strEQ(name + 3, "DEC")) {	/* HFY removed */
#ifdef HFYDEC
	    return HFYDEC;
#else
	    goto not_there;
#endif
	}
    case 'F':
	return constant_HFYF(name, len, arg);
    case 'J':
	return constant_HFYJ(name, len, arg);
    case 'L':
	if (strEQ(name + 3, "LST")) {	/* HFY removed */
#ifdef HFYLST
	    return HFYLST;
#else
	    goto not_there;
#endif
	}
    case 'M':
	return constant_HFYM(name, len, arg);
    case 'N':
	if (strEQ(name + 3, "NOV")) {	/* HFY removed */
#ifdef HFYNOV
	    return HFYNOV;
#else
	    goto not_there;
#endif
	}
    case 'O':
	if (strEQ(name + 3, "OCT")) {	/* HFY removed */
#ifdef HFYOCT
	    return HFYOCT;
#else
	    goto not_there;
#endif
	}
    case 'S':
	if (strEQ(name + 3, "SEP")) {	/* HFY removed */
#ifdef HFYSEP
	    return HFYSEP;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HF(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'A':
	if (strEQ(name + 2, "AMER")) {	/* HF removed */
#ifdef HFAMER
	    return HFAMER;
#else
	    goto not_there;
#endif
	}
    case 'E':
	if (strEQ(name + 2, "EB")) {	/* HF removed */
#ifdef HFEB
	    return HFEB;
#else
	    goto not_there;
#endif
	}
    case 'I':
	if (strEQ(name + 2, "IN")) {	/* HF removed */
#ifdef HFIN
	    return HFIN;
#else
	    goto not_there;
#endif
	}
    case 'M':
	if (strEQ(name + 2, "MENV")) {	/* HF removed */
#ifdef HFMENV
	    return HFMENV;
#else
	    goto not_there;
#endif
	}
    case 'R':
	return constant_HFR(name, len, arg);
    case 'U':
	if (strEQ(name + 2, "USE")) {	/* HF removed */
#ifdef HFUSE
	    return HFUSE;
#else
	    goto not_there;
#endif
	}
    case 'Y':
	return constant_HFY(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HWAS(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'A':
	if (strEQ(name + 4, "AT")) {	/* HWAS removed */
#ifdef HWASAT
	    return HWASAT;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 4, "UN")) {	/* HWAS removed */
#ifdef HWASUN
	    return HWASUN;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HWAT(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'H':
	if (strEQ(name + 4, "HU")) {	/* HWAT removed */
#ifdef HWATHU
	    return HWATHU;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 4, "UE")) {	/* HWAT removed */
#ifdef HWATUE
	    return HWATUE;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HWA(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'F':
	if (strEQ(name + 3, "FRI")) {	/* HWA removed */
#ifdef HWAFRI
	    return HWAFRI;
#else
	    goto not_there;
#endif
	}
    case 'M':
	if (strEQ(name + 3, "MON")) {	/* HWA removed */
#ifdef HWAMON
	    return HWAMON;
#else
	    goto not_there;
#endif
	}
    case 'S':
	return constant_HWAS(name, len, arg);
    case 'T':
	return constant_HWAT(name, len, arg);
    case 'W':
	if (strEQ(name + 3, "WED")) {	/* HWA removed */
#ifdef HWAWED
	    return HWAWED;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HWBS(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'A':
	if (strEQ(name + 4, "AT")) {	/* HWBS removed */
#ifdef HWBSAT
	    return HWBSAT;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 4, "UN")) {	/* HWBS removed */
#ifdef HWBSUN
	    return HWBSUN;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HWBT(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'H':
	if (strEQ(name + 4, "HU")) {	/* HWBT removed */
#ifdef HWBTHU
	    return HWBTHU;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 4, "UE")) {	/* HWBT removed */
#ifdef HWBTUE
	    return HWBTUE;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HWB(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'F':
	if (strEQ(name + 3, "FRI")) {	/* HWB removed */
#ifdef HWBFRI
	    return HWBFRI;
#else
	    goto not_there;
#endif
	}
    case 'M':
	if (strEQ(name + 3, "MON")) {	/* HWB removed */
#ifdef HWBMON
	    return HWBMON;
#else
	    goto not_there;
#endif
	}
    case 'S':
	return constant_HWBS(name, len, arg);
    case 'T':
	return constant_HWBT(name, len, arg);
    case 'W':
	if (strEQ(name + 3, "WED")) {	/* HWB removed */
#ifdef HWBWED
	    return HWBWED;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HWKS(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'A':
	if (strEQ(name + 4, "AT")) {	/* HWKS removed */
#ifdef HWKSAT
	    return HWKSAT;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 4, "UN")) {	/* HWKS removed */
#ifdef HWKSUN
	    return HWKSUN;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HWKT(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'H':
	if (strEQ(name + 4, "HU")) {	/* HWKT removed */
#ifdef HWKTHU
	    return HWKTHU;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 4, "UE")) {	/* HWKT removed */
#ifdef HWKTUE
	    return HWKTUE;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HWK(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'F':
	if (strEQ(name + 3, "FRI")) {	/* HWK removed */
#ifdef HWKFRI
	    return HWKFRI;
#else
	    goto not_there;
#endif
	}
    case 'M':
	if (strEQ(name + 3, "MON")) {	/* HWK removed */
#ifdef HWKMON
	    return HWKMON;
#else
	    goto not_there;
#endif
	}
    case 'O':
	if (strEQ(name + 3, "OPN")) {	/* HWK removed */
#ifdef HWKOPN
	    return HWKOPN;
#else
	    goto not_there;
#endif
	}
    case 'S':
	return constant_HWKS(name, len, arg);
    case 'T':
	return constant_HWKT(name, len, arg);
    case 'W':
	if (strEQ(name + 3, "WED")) {	/* HWK removed */
#ifdef HWKWED
	    return HWKWED;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HW(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'A':
	return constant_HWA(name, len, arg);
    case 'B':
	return constant_HWB(name, len, arg);
    case 'E':
	if (strEQ(name + 2, "ED")) {	/* HW removed */
#ifdef HWED
	    return HWED;
#else
	    goto not_there;
#endif
	}
    case 'K':
	return constant_HWK(name, len, arg);
    case 'M':
	if (strEQ(name + 2, "MODE")) {	/* HW removed */
#ifdef HWMODE
	    return HWMODE;
#else
	    goto not_there;
#endif
	}
    case 'R':
	if (strEQ(name + 2, "RITE")) {	/* HW removed */
#ifdef HWRITE
	    return HWRITE;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HG(char *name, int len, int arg)
{
    if (2 + 1 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[2 + 1]) {
    case 'F':
	if (strEQ(name + 2, "LFOR")) {	/* HG removed */
#ifdef HGLFOR
	    return HGLFOR;
#else
	    goto not_there;
#endif
	}
    case 'N':
	if (strEQ(name + 2, "LNAM")) {	/* HG removed */
#ifdef HGLNAM
	    return HGLNAM;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HIN(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'I':
	if (strEQ(name + 3, "ITD")) {	/* HIN removed */
#ifdef HINITD
	    return HINITD;
#else
	    goto not_there;
#endif
	}
    case 'T':
	if (strEQ(name + 3, "TVL")) {	/* HIN removed */
#ifdef HINTVL
	    return HINTVL;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HI(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'F':
	if (strEQ(name + 2, "FAIL")) {	/* HI removed */
#ifdef HIFAIL
	    return HIFAIL;
#else
	    goto not_there;
#endif
	}
    case 'N':
	return constant_HIN(name, len, arg);
    case 'T':
	if (strEQ(name + 2, "TEM")) {	/* HI removed */
#ifdef HITEM
	    return HITEM;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HJU(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'L':
	if (strEQ(name + 3, "L")) {	/* HJU removed */
#ifdef HJUL
	    return HJUL;
#else
	    goto not_there;
#endif
	}
    case 'N':
	if (strEQ(name + 3, "N")) {	/* HJU removed */
#ifdef HJUN
	    return HJUN;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HJ(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'A':
	if (strEQ(name + 2, "AN")) {	/* HJ removed */
#ifdef HJAN
	    return HJAN;
#else
	    goto not_there;
#endif
	}
    case 'U':
	return constant_HJU(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HLIC(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'F':
	if (strEQ(name + 4, "FL")) {	/* HLIC removed */
#ifdef HLICFL
	    return HLICFL;
#else
	    goto not_there;
#endif
	}
    case 'N':
	if (strEQ(name + 4, "NS")) {	/* HLIC removed */
#ifdef HLICNS
	    return HLICNS;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HLI(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'C':
	return constant_HLIC(name, len, arg);
    case '_':
	if (strEQ(name + 3, "_INCLUDED")) {	/* HLI removed */
#ifdef HLI_INCLUDED
	    return HLI_INCLUDED;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HL(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'I':
	return constant_HLI(name, len, arg);
    case 'O':
	if (strEQ(name + 2, "OCKD")) {	/* HL removed */
#ifdef HLOCKD
	    return HLOCKD;
#else
	    goto not_there;
#endif
	}
    case 'R':
	if (strEQ(name + 2, "RESV")) {	/* HL removed */
#ifdef HLRESV
	    return HLRESV;
#else
	    goto not_there;
#endif
	}
    case 'S':
	if (strEQ(name + 2, "SERV")) {	/* HL removed */
#ifdef HLSERV
	    return HLSERV;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HMA(char *name, int len, int arg)
{
    switch (name[3 + 0]) {
    case 'R':
	if (strEQ(name + 3, "R")) {	/* HMA removed */
#ifdef HMAR
	    return HMAR;
#else
	    goto not_there;
#endif
	}
    case 'X':
	if (strEQ(name + 3, "XSCMD")) {	/* HMA removed */
#ifdef HMAXSCMD
	    return HMAXSCMD;
#else
	    goto not_there;
#endif
	}
    case 'Y':
	if (strEQ(name + 3, "Y")) {	/* HMA removed */
#ifdef HMAY
	    return HMAY;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HMO(char *name, int len, int arg)
{
    if (3 + 1 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[3 + 1]) {
    case '\0':
	if (strEQ(name + 3, "N")) {	/* HMO removed */
#ifdef HMON
	    return HMON;
#else
	    goto not_there;
#endif
	}
    case 'T':
	if (strEQ(name + 3, "NTH")) {	/* HMO removed */
#ifdef HMONTH
	    return HMONTH;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_HM(char *name, int len, int arg)
{
    switch (name[2 + 0]) {
    case 'A':
	return constant_HMA(name, len, arg);
    case 'F':
	if (strEQ(name + 2, "FILE")) {	/* HM removed */
#ifdef HMFILE
	    return HMFILE;
#else
	    goto not_there;
#endif
	}
    case 'G':
	if (strEQ(name + 2, "GVAL")) {	/* HM removed */
#ifdef HMGVAL
	    return HMGVAL;
#else
	    goto not_there;
#endif
	}
    case 'I':
	if (strEQ(name + 2, "IN")) {	/* HM removed */
#ifdef HMIN
	    return HMIN;
#else
	    goto not_there;
#endif
	}
    case 'O':
	return constant_HMO(name, len, arg);
    case 'P':
	if (strEQ(name + 2, "POST")) {	/* HM removed */
#ifdef HMPOST
	    return HMPOST;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_H(char *name, int len, int arg)
{
    switch (name[1 + 0]) {
    case 'A':
	return constant_HA(name, len, arg);
    case 'B':
	return constant_HB(name, len, arg);
    case 'C':
	return constant_HC(name, len, arg);
    case 'D':
	return constant_HD(name, len, arg);
    case 'E':
	return constant_HE(name, len, arg);
    case 'F':
	return constant_HF(name, len, arg);
    case 'G':
	return constant_HG(name, len, arg);
    case 'H':
	if (strEQ(name + 1, "HOUR")) {	/* H removed */
#ifdef HHOUR
	    return HHOUR;
#else
	    goto not_there;
#endif
	}
    case 'I':
	return constant_HI(name, len, arg);
    case 'J':
	return constant_HJ(name, len, arg);
    case 'L':
	return constant_HL(name, len, arg);
    case 'M':
	return constant_HM(name, len, arg);
    case 'N':
	return constant_HN(name, len, arg);
    case 'O':
	return constant_HO(name, len, arg);
    case 'P':
	return constant_HP(name, len, arg);
    case 'Q':
	return constant_HQ(name, len, arg);
    case 'R':
	return constant_HR(name, len, arg);
    case 'S':
	return constant_HS(name, len, arg);
    case 'T':
	return constant_HT(name, len, arg);
    case 'U':
	return constant_HU(name, len, arg);
    case 'W':
	return constant_HW(name, len, arg);
    case 'Y':
	if (strEQ(name + 1, "YES")) {	/* H removed */
#ifdef HYES
	    return HYES;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant(char *name, int len, int arg)
{
    errno = 0;
    switch (name[0 + 0]) {
    case 'F':
	if (strEQ(name + 0, "FNUMND")) {	/*  removed */
	    return FNUMND;
	} else if (strEQ(name + 0, "FPRCND")) {	/*  removed */
	    return FPRCND;
	}
    case 'G':
	if (strEQ(name + 0, "GLOBAL")) {	/*  removed */
#ifdef GLOBAL
	    return GLOBAL;
#else
	    goto not_there;
#endif
	}
    case 'H':
	return constant_H(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}


MODULE = FameHLI::API::HLI		PACKAGE = FameHLI::API::HLI		


double
constant(sv,arg)
    PREINIT:
	STRLEN		len;
    INPUT:
	SV *		sv
	char *		s = SvPV(sv, len);
	int		arg
    CODE:
	RETVAL = constant(s,len,arg);
    OUTPUT:
	RETVAL

