package WordList::ZH::HSK6;

our $DATE = '2016-02-04'; # DATE
our $VERSION = '0.01'; # VERSION

use utf8;

use WordList;
our @ISA = qw(WordList);

our %STATS = ("shortest_word_len",1,"num_words_contains_nonword_chars",0,"avg_word_len",2.04401760704282,"longest_word_len",4,"num_words_contains_whitespace",0,"num_words",2499,"num_words_contains_unicode",2499); # STATS

1;
# ABSTRACT: HSK (level 6 only) words

=pod

=encoding UTF-8

=head1 NAME

WordList::ZH::HSK6 - HSK (level 6 only) words

=head1 VERSION

This document describes version 0.01 of WordList::ZH::HSK6 (from Perl distribution WordList-ZH-HSK), released on 2016-02-04.

=head1 SYNOPSIS

 use WordList::ZH::HSK6;

 my $wl = WordList::ZH::HSK6->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

=head1 STATISTICS

 +----------------------------------+------------------+
 | key                              | value            |
 +----------------------------------+------------------+
 | avg_word_len                     | 2.04401760704282 |
 | longest_word_len                 | 4                |
 | num_words                        | 2499             |
 | num_words_contains_nonword_chars | 0                |
 | num_words_contains_unicode       | 2499             |
 | num_words_contains_whitespace    | 0                |
 | shortest_word_len                | 1                |
 +----------------------------------+------------------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-ZH-HSK>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-ZH-HSK>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-ZH-HSK>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<WordList::ZH::HSK>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
一丝不苟
一举两得
一向
一如既往
一帆风顺
一度
一流
一目了然
一贯
丁
万分
上任
上游
上瘾
上级
上进
下属
不像话
不免
不可思议
不堪
不妨
不屑一顾
不得已
不惜
不愧
不择手段
不敢当
不料
不时
不止
不由得
不相上下
不禁
不言而喻
不顾
与日俱增
丑恶
专利
专程
专长
专题
世代
丘陵
丙
丛
东张西望
东道主
丢三落四
丢人
严厉
严密
严寒
严峻
严禁
丧失
个体
中央
中断
中立
丰收
丰满
丰盛
串
临床
丸
为期
为难
主义
主办
主导
主权
主流
主管
举世瞩目
举动
举足轻重
之际
乌黑
乐意
乐谱
乐趣
乘
乞丐
习俗
乡镇
书法
书籍
书记
书面
争先恐后
争夺
争气
争端
争议
事业
事件
事务
事态
事故
事迹
事项
二氧化碳
亏待
亏损
井
亚军
交代
交叉
交易
交涉
亦
产业
亭子
亲密
亲热
人为
人士
人家
人工
人性
人格
人质
人道
人间
仁慈
仍旧
从容
仓促
仓库
代价
代理
以便
以免
以往
以至
以致
仪器
仪式
任命
任性
任意
任重道远
企图
众所周知
优先
优异
优胜劣汰
优越
会晤
传单
传授
传记
传达
伤脑筋
伪造
伯母
伴侣
伴随
伶俐
伺候
住宅
体积
体系
体裁
体谅
体面
作废
作弊
作息
作风
佳肴
使命
侃侃而谈
侄子
例外
供不应求
供给
依托
依据
依旧
依赖
依靠
侥幸
侦探
侧面
侮辱
侵犯
侵略
便于
便利
便条
俗话
俘虏
保养
保卫
保姆
保守
保密
保管
保重
保障
信仰
信念
信誉
信赖
修养
修复
修建
俯视
倒闭
倔强
倘若
候选
借助
借鉴
倡导
倡议
债券
值班
倾向
倾听
倾斜
偏偏
偏僻
偏差
偏见
做主
停泊
停滞
停顿
健全
偶像
偿还
储备
储存
储蓄
僵硬
儒家
元宵节
元素
元首
充实
充当
充沛
充足
先前
先进
光彩
光芒
光荣
光辉
克制
免得
免疫
兑现
党
兜
兢兢业业
全力以赴
全局
公关
公务
公告
公安局
公式
公正
公民
公然
公认
公证
公道
共和国
共计
共鸣
关怀
关照
兴旺
兴致勃勃
兴隆
兴高采烈
典型
典礼
内在
内幕
内涵
再接再厉
冒充
冒犯
军队
农历
冤枉
冰雹
冲击
冲动
冲突
决策
况且
冷却
冷落
冷酷
冻结
凄凉
准则
凌晨
凑合
凝固
凝聚
凝视
凡是
凶恶
凶手
凹凸
出卖
出息
出神
出路
出身
分寸
分散
分明
分歧
分泌
分红
分裂
分解
分辨
分量
切实
刊物
刊登
刑事
划分
列举
创业
创作
创新
创立
初步
判决
利害
别墅
别扭
别致
制服
制止
制约
制裁
刹车
刹那
刺
刻不容缓
削
削弱
前提
前景
剑
剥削
剧本
剧烈
剪彩
副
割
劈
力争
力所能及
力求
功劳
功效
加剧
加工
务必
动力
动员
动态
动手
动机
动脉
动荡
动身
动静
助手
助理
势力
势必
勇于
勉励
勉强
勘探
勤俭
勤劳
勾结
包围
包庇
包袱
包装
化妆
化石
化肥
化验
北极
区分
区域
十足
千方百计
半途而废
华丽
华侨
协会
协助
协商
协议
协调
卑鄙
卓越
南辕北辙
博大精深
博览会
占据
占领
卡通
卫星
危机
即便
即将
卷
历代
历来
压制
压岁钱
压抑
压榨
压缩
压迫
厌恶
原先
原告
原始
原理
参照
参谋
及早
双胞胎
反之
反射
反常
反思
反感
反抗
反问
反面
反馈
反驳
发动
发呆
发射
发布
发扬
发炎
发育
发行
发觉
发誓
发财
取缔
受罪
变故
变质
变迁
口头
口气
口腔
口音
古怪
古董
叮嘱
可口
可恶
可行
可观
台风
号召
司令
司法
叹气
叼
吃力
吃苦
各抒己见
合伙
合并
合成
合算
吉祥
吊
同志
同胞
名副其实
名次
名誉
名额
后代
后勤
后顾之忧
向导
向往
向来
君子
吝啬
吞吞吐吐
否决
吩咐
含义
含糊
启事
启示
启程
启蒙
吹捧
吹牛
吼
呈现
告诫
告辞
呕吐
周密
周年
周折
周期
周转
周边
呵
呻吟
呼吁
呼唤
呼啸
命名
咀嚼
咋
和气
和睦
和蔼
和解
和谐
品尝
品德
品种
品质
哄
哆嗦
哇
响亮
响应
哦
哨
哭泣
哺乳
哼
唠叨
唯独
唾弃
啃
商标
啥
啦
啰唆
喂
喇叭
喉咙
喘气
喜悦
喜闻乐见
喧哗
嗅觉
嗨
嘈杂
嘛
嘱咐
嘲笑
嘴唇
嘿
器官
器材
噪音
嚷
四肢
回报
回收
回避
回顾
团体
团圆
团结
园林
固体
固执
固有
固然
国务院
国防
图案
圆满
圈套
土壤
在意
地势
地步
地质
场合
场所
场面
坑
坚固
坚定
坚实
坚硬
坚韧
坟墓
坠
坡
坦白
垂直
垄断
垫
埋伏
埋怨
埋没
埋葬
城堡
培育
基因
基地
基金
堆积
堕落
堤坝
堵塞
塌
塑造
塔
境界
增添
墨水儿
壮丽
壮烈
壮观
声势
声明
声誉
处分
处境
处置
备份
备忘录
复兴
复活
夕阳
外向
外界
外行
外表
多元化
大不了
大伙儿
大体
大意
大肆
大臣
大致
天伦之乐
天堂
天才
天文
天然气
天生
天赋
太空
夫人
夫妇
失事
失误
失踪
夹杂
奇妙
奉献
奔波
奔驰
奖励
奖赏
奠定
奢侈
奥秘
奴隶
妄想
妥协
妥善
妥当
姑且
委员
委托
姿态
威信
威力
威望
威风
娃娃
娇气
婴儿
媒介
媳妇
嫂子
嫉妒
嫌
嫌疑
子弹
孔
孕育
季军
季度
孤独
孤立
学位
学说
宁愿
宁肯
宇宙
守护
安宁
安置
安详
完备
完毕
宏伟
宏观
宗教
宗旨
官方
定义
定期
实事求是
实力
实惠
实施
实行
实质
审判
审查
审理
审美
客户
宣扬
宣誓
宪法
宫殿
宰
家伙
家喻户晓
家属
家常
容器
容忍
容纳
容貌
宽容
宽敞
寂静
寄托
密封
密度
富裕
寒暄
寓言
对付
对应
对抗
对照
对称
对立
对策
对联
寺庙
寻觅
导向
导弹
导航
封建
封锁
封闭
将军
将就
将近
尊严
小心翼翼
尖端
尖锐
尚且
尝试
就业
就职
就近
尴尬
尸体
局势
局部
局限
局面
屁股
层出不穷
层次
居住
居民
屈服
屏幕
屏障
屑
展望
展现
展示
屡次
履行
山脉
岁月
岂有此理
岔
岗位
岩石
岳母
峡谷
崇拜
崇敬
崇高
崩溃
崭新
川流不息
州
巡逻
巢穴
工艺品
巩固
差别
巴不得
巴结
巷
布告
布局
布置
师范
帐篷
带领
幅度
幢
干劲
干扰
干旱
干涉
干预
平凡
平原
平坦
平庸
平行
平面
年度
并列
并非
幼稚
广阔
庄严
庄稼
庄重
床单
序言
应邀
应酬
庞大
废墟
废寝忘食
废除
座右铭
庸俗
廉洁
延伸
延期
延续
开展
开拓
开支
开明
开朗
开辟
开采
开阔
开除
异常
弊病
弊端
引导
引擎
引用
弥漫
弥补
弦
弱点
弹性
强制
强迫
归根到底
归还
当事人
当代
当初
当前
当务之急
当场
当选
当面
形态
彩票
往事
往常
征收
征服
徒弟
得不偿失
得力
得天独厚
得罪
徘徊
循序渐进
循环
微不足道
微观
心得
心态
心灵
心甘情愿
心疼
心眼儿
心血
忌讳
忍受
忍耐
志气
忙碌
忠实
忠诚
忧郁
快活
忽略
思念
思索
思维
怠慢
急于求成
急切
急剧
急功近利
急躁
性命
性感
性能
总和
总而言之
恍然大悟
恐吓
恐怖
恐惧
恨不得
恩怨
恭敬
恰到好处
恰巧
恰当
恳切
恶化
恶心
恼火
悔恨
患者
悬崖峭壁
悬念
悬挂
悬殊
悲哀
悲惨
情形
情报
情理
情节
惊动
惊奇
惊讶
惋惜
惦记
惩罚
惯例
想方设法
惹祸
愈
意向
意味着
意图
意志
意料
意识
愚昧
愚蠢
感慨
感染
愣
愤怒
慈善
慈祥
慎重
慢性
慰问
慷慨
憋
懒惰
成交
成员
成天
成心
成效
成本
戒备
战役
战斗
战术
战略
截止
截至
扁
手势
手法
手艺
才干
扎
扎实
扑
扒
打仗
打击
打包
打官司
打架
打猎
打量
托运
扛
扣
执着
执行
扩充
扩张
扩散
扭转
扮演
扰乱
批判
批发
承办
承包
承诺
技巧
把关
把手
投掷
投机
投票
投诉
投降
抗议
折
折磨
折腾
抚养
抚摸
抛弃
抢劫
抢救
报仇
报复
报答
报警
报酬
报销
抱负
抵制
抵抗
抵达
抹杀
拄
担保
拐杖
拔苗助长
拖延
拘束
拘留
招收
招标
拜年
拜托
拜访
拟定
拣
拥护
拥有
拧
拨
拳头
拼命
拼搏
拽
拾
拿手
持久
指令
指南针
指定
指望
指标
指甲
指示
指责
按摩
挎
挑剔
挑拨
挑衅
挖掘
挣扎
挥霍
挪
挫折
振兴
振奋
挺拔
挽回
挽救
捆绑
捍卫
捎
捏
捕捉
捞
损坏
捣乱
捧
据悉
掀起
授予
掏
掐
排放
排斥
排练
排除
掠夺
探望
探测
探索
探讨
接连
推测
推理
推翻
推论
推销
掩护
掩盖
掩饰
掰
揉
揍
描绘
提拔
提炼
提示
提议
插座
揭露
搀
搁
搂
搅拌
搏斗
搓
搭
搭档
搭配
携带
摄氏度
摆脱
摇摆
摇滚
摊
摘要
摧残
摩擦
摸索
撇
撒谎
撤退
撤销
播种
擅自
擅长
操作
操劳
操纵
操练
攀登
攒
支出
支援
支撑
支柱
支流
支配
收益
收缩
收藏
收音机
改良
攻克
攻击
放大
放射
政权
政策
故乡
故障
效益
敌视
敏捷
敏锐
救济
教养
敞开
散发
散布
散文
敬业
敬礼
数额
整顿
敷衍
文凭
文物
文献
文艺
文雅
斑
斗争
斟酌
斩钉截铁
断定
断绝
斯文
新娘
新郎
新陈代谢
新颖
方位
方圆
方言
方针
施加
施展
旋律
旋转
旗帜
旗袍
无偿
无动于衷
无微不至
无忧无虑
无比
无理取闹
无知
无穷无尽
无精打采
无耻
无能为力
无赖
无辜
无非
日新月异
日益
时事
时光
时常
时机
时而
旷课
昂贵
昌盛
明明
明智
昏迷
昔日
是非
昼夜
显著
晃
晋升
普及
晴朗
智力
智商
智能
晾
暂且
暗示
暧昧
暴力
暴露
曝光
曲子
曲折
更新
更正
有条不紊
服从
服气
朝代
朝气蓬勃
期望
期限
未免
本事
本人
本能
本身
本钱
朴实
朴素
机动
机密
机智
机构
机械
机灵
机遇
杂交
杂技
权威
权衡
杜绝
束
束缚
杠杆
条款
条理
条约
来历
来源
杰出
极端
极限
构思
枕头
枚
果断
枝
枯燥
枯萎
染
柔和
查获
柴油
标本
标记
标题
栋
栏目
树立
株
样品
根深蒂固
根源
格局
格式
栽培
框架
案件
案例
档案
档次
桥梁
桨
梢
检讨
检验
棉花
棍棒
棕色
椭圆
榜样
模型
模式
模样
模范
横
橙
次品
次序
欢乐
欣慰
欣欣向荣
欲望
欺负
欺骗
款式
款待
歌颂
正义
正宗
正当
正月
正气
正经
正规
正负
步伐
武侠
武器
武装
歧视
歪曲
歹徒
死亡
残忍
残留
残疾
残酷
殖民地
殴打
毁灭
毅力
毅然
母语
毒品
比喻
比方
比重
毫无
毫米
民主
民间
气功
气势
气压
气味
气概
气色
气象
气质
气魄
氧气
水利
水泥
水龙头
永恒
汇报
污蔑
汹涌
沉思
沉淀
沉着
沉重
沉闷
沐浴
沮丧
沸腾
油漆
油腻
治安
治理
沼泽
沾光
沿海
泄气
泄露
法人
泛滥
泡沫
波浪
波涛
注射
注视
注释
注重
泰斗
泼
津津有味
洪水
活力
活该
洽谈
派别
派遣
流氓
流浪
流通
流露
测量
浑身
浓厚
海拔
海滨
浸泡
涂抹
消毒
消灭
消耗
消防
消除
涉及
涌现
涮火锅
液体
淋
淘汰
淡季
淡水
深奥
深情厚谊
深沉
混乱
混合
混浊
混淆
淹没
清晨
清晰
清洁
清澈
清理
清真
清醒
清除
渔民
渗透
渠道
渣
温和
温带
港口
港湾
渴望
渺小
湖泊
溅
源泉
溜
溪
溶解
滋味
滋润
滔滔不绝
滞留
漂浮
演习
演变
演奏
演绎
漫画
漫长
潇洒
潜力
潜水
潜移默化
潮流
澄清
激励
激发
激情
濒临
瀑布
灌溉
火焰
火箭
火药
灭亡
灯笼
灵感
灵敏
灵魂
灾难
灿烂
炉灶
炊烟
炎热
炫耀
点缀
烘
烟花爆竹
热泪盈眶
热门
烹饪
焦急
焦点
煎
照样
照耀
熄灭
熏陶
熨
熬
爆发
爆炸
爱不释手
爱戴
爽快
片刻
片断
版本
牢固
牢骚
物业
物美价廉
物资
牲畜
牵
牵制
牵扯
特定
特意
特长
牺牲
犬
犹如
狠心
独裁
狭窄
狭隘
狼吞虎咽
狼狈
猛烈
率领
玉
玩弄
玩意儿
环节
现场
现成
现状
珍珠
珍稀
珍贵
理所当然
理智
理直气壮
理睬
琢磨
瓦解
生存
生态
生效
生机
生物
生理
生疏
生肖
生育
生锈
用户
甭
田径
田野
申报
电源
画蛇添足
畅通
畅销
界限
畏惧
畔
留念
留恋
留神
畜牧
番
疏忽
疏远
疑惑
疙瘩
疤
疲倦
疲惫
疾病
症状
痕迹
瘫痪
瘸
癌症
登录
登陆
皆
皇后
皇帝
皮革
皱纹
盆地
盈利
监狱
监督
监视
盖章
盗窃
盘旋
盛
盛产
盛开
盛情
盛行
目光
目睹
盯
盲目
直径
直播
相声
相差
相应
相等
相辅相成
省会
看待
真挚
真理
真相
眨
眯
眼光
眼神
眼色
着想
着手
着迷
着重
督促
瞄准
瞪
瞬间
瞻仰
知觉
知足常乐
短促
石油
矿产
码头
砍伐
砖
破例
砸
确保
确信
确切
确立
磁带
磅
磋商
磕
磨合
示威
示意
示范
礼尚往来
礼节
社区
祖先
祖国
祖父
神仙
神圣
神奇
神态
神气
神经
福利
福气
私自
秃
种子
种族
种植
科目
租赁
秤
称号
称心如意
稠密
稻谷
稿件
空前绝后
空想
空洞
空白
空虚
空隙
穿越
突破
窍门
窜
窝
立交桥
立体
立场
立方
立足
竖
竞赛
竞选
章程
童话
竭尽全力
端
端午节
端正
符号
笨拙
笼罩
等候
等级
筐
答复
答辩
策划
策略
筛选
筹备
签署
简体字
简化
简要
简陋
算数
管辖
籍贯
类似
粉末
粉碎
粉色
粒
粗鲁
粥
精华
精密
精心
精打细算
精益求精
精确
精简
精致
精通
糟蹋
系列
素质
素食
索取
索性
紧迫
繁体字
繁华
繁忙
繁殖
纠正
纠纷
纤维
约束
级别
纪要
纯洁
纯粹
纲领
纳闷儿
纵横
纺织
纽扣儿
线索
绅士
细胞
细致
细菌
终止
终点
终究
终身
经纬
经费
绑架
结局
结晶
结算
给予
络绎不绝
绝望
统治
统筹兼顾
统统
统计
绣
继承
维护
维持
维生素
缓和
编织
缘故
缠绕
缴纳
缺口
缺席
缺陷
罐
罕见
罢工
罪犯
美妙
美满
美观
羞耻
群众
羽绒服
翘
翼
耀眼
考古
考察
考核
考验
而已
耍
耐用
耕地
耗费
耸
聋哑
职位
职务
职能
联想
联欢
联盟
联络
聚精会神
肆无忌惮
肖像
股东
股份
肥沃
肺
肿瘤
胆怯
背叛
背诵
胜负
胡乱
胡须
胸怀
胸膛
能量
脂肪
脆弱
脉搏
脱离
腐朽
腐烂
腐蚀
腐败
腥
腹泻
膜
膝盖
臂
自主
自力更生
自卑
自发
自满
致使
致力
致辞
舆论
舌头
舒畅
舔
舞蹈
舟
航天
航空
航行
舰艇
舱
船舶
艘
良心
艰难
节制
节奏
花瓣
花蕾
苍白
苏醒
若干
苦尽甘来
苦涩
英勇
英明
茂盛
范畴
茎
茫然
茫茫
草案
草率
荒凉
荒唐
荒谬
荣幸
荣誉
荤
莫名其妙
萌芽
落实
落成
著作
董事长
蒸发
蔑视
蔓延
蔚蓝
蕴藏
薄弱
薪水
藐视
虐待
虚伪
虚假
虚荣
蚂蚁
蛋白质
蜡烛
融化
融洽
血压
行列
行政
衔接
衣裳
补偿
补救
补贴
表决
表彰
表态
衬托
衰老
衰退
衷心
被动
被告
袭击
裁判
裁员
裁缝
装卸
装备
要命
要点
要素
覆盖
见义勇为
见多识广
见解
见闻
观光
规划
规格
规章
规范
视力
视线
视野
视频
觉悟
觉醒
角落
解体
解剖
解放
解散
解除
解雇
触犯
言论
警告
警惕
譬如
计较
认可
认定
讥笑
讨好
让步
记性
记载
许可
论坛
论证
设想
设立
设置
访问
证书
证实
评估
评论
识别
诈骗
诉讼
试图
试验
诚挚
话筒
诞生
诞辰
诧异
诬陷
误差
误解
诱惑
请帖
请教
请柬
请示
诸位
诽谤
课题
调剂
调动
调和
调料
调节
调解
谅解
谋求
谜语
谢绝
谣言
谦逊
谴责
豪迈
贝壳
负担
财务
财富
财政
责怪
贤惠
败坏
货币
贩卖
贪婪
贪污
贫乏
贫困
贬义
贬低
贯彻
贵族
贼
贿赂
资产
资助
资本
资深
赋予
赌博
赞助
赞叹
赠送
赤字
赤道
走廊
走漏
走私
起伏
起初
起哄
起源
起码
起草
超越
趣味
足以
趴
跌
跟前
跟踪
跟随
跨
跪
跳跃
践踏
踊跃
踏实
踪迹
蹦
蹬
轨道
转折
转移
转让
转达
轮廓
轮胎
轮船
轰动
较量
辅助
辉煌
辐射
辛勤
辜负
辨认
辩护
辩解
辩证
辫子
边境
边界
边疆
边缘
辽阔
达成
迁就
迁徙
迄今为止
过于
过失
过奖
过度
过渡
过滤
过瘾
过问
迈
迎面
运算
运行
近来
还原
进化
进展
进攻
进而
违背
连同
连年
连锁
迟疑
迟缓
迟钝
迫不及待
迫害
迷人
迷信
迷惑
迸发
迹象
追悼
追究
适宜
逆行
选举
选手
选拔
透露
逐年
递增
途径
通俗
通用
通缉
通讯
通货膨胀
逝世
造型
逢
逮捕
逼迫
遍布
遏制
遗产
遗传
遗失
遗留
遥控
遥远
遭受
遭殃
遭遇
遮挡
遵循
郑重
部位
部署
鄙视
配偶
配备
配套
酒精
酗酒
酝酿
采纳
采购
采集
释放
里程碑
重叠
重心
野心
野蛮
金融
鉴于
鉴别
鉴定
钙
钞票
钦佩
钩子
钻石
钻研
铜
铸造
铺
销毁
锋利
锤
锦上添花
锲而不舍
镇定
镇静
镜头
镶嵌
闪烁
闭塞
问世
闲话
间接
间谍
间隔
阐述
队伍
防守
防御
防止
防治
阴谋
阵地
阵容
阶层
阻拦
阻挠
阻碍
附件
附和
附属
陈列
陈旧
陈述
降临
陡峭
除
陶瓷
陶醉
陷入
陷害
陷阱
隆重
随即
随意
隐患
隐瞒
隐私
隐约
隐蔽
隔离
隔阂
障碍
隧道
难堪
难得
难能可贵
雄伟
雄厚
集团
雇佣
雌雄
雕刻
雕塑
雪上加霜
零星
雷达
需求
震惊
震撼
霞
霸道
非法
靠拢
面子
面貌
革命
鞠躬
鞭策
音响
须知
顽固
顽强
顾虑
顾问
顿时
颁发
颁布
预兆
预先
预料
预期
预算
预言
领事馆
领会
领先
领土
领悟
领袖
颇
颈椎
频率
频繁
题材
额外
颠倒
颠簸
颤抖
风光
风味
风土人情
风度
风暴
风气
风趣
飘扬
飞禽走兽
飞翔
飞跃
饥饿
饮食
饱和
饱经沧桑
饲养
饶恕
馅儿
馋
首要
首饰
驱逐
驻扎
验收
验证
骚扰
骨干
高尚
高峰
高明
高涨
高潮
高超
魄力
魔术
魔鬼
鲜明
鸦雀无声
鸽子
麻木
麻痹
麻醉
黄昏
黎明
默默
鼓动
鼻涕
齐全
齐心协力
