#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::CharitySellerStatusCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CharitySellerStatusCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::CharitySellerStatusCodeType

=head1 DESCRIPTION

CharitySellerStatusCodeType - Type declaration to be used by other schema.
Indicates the status of the seller's charity seller account.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 Suspended

The seller's charity seller account is suspended.



=cut


use constant Suspended => scalar('Suspended');


=head2 Registered

The seller is a registered charity seller.



=cut


use constant Registered => scalar('Registered');


=head2 Closed

The seller is no longer a registered charity seller. The account with the eBay Giving Works provider is closed.



=cut


use constant Closed => scalar('Closed');


=head2 CreditCardExpired

The credit card associated with a seller's charity seller account has expired.



=cut


use constant CreditCardExpired => scalar('CreditCardExpired');


=head2 TokenExpired

The token associated with a seller's charity seller account has expired.



=cut


use constant TokenExpired => scalar('TokenExpired');


=head2 CreditCardAboutToExpire

The credit card associated with a seller's charity seller account will expire in 15 (or fewer) days.



=cut


use constant CreditCardAboutToExpire => scalar('CreditCardAboutToExpire');


=head2 RegisteredNoCreditCard

(deprecated) The seller is a registered charity seller, but has no credit card associated with the charity seller account.
This value will be deprecated after e557, please use RegisteredDirectSeller or RegisteredNoPaymentMethod.



=cut


use constant RegisteredNoCreditCard => scalar('RegisteredNoCreditCard');


=head2 NotRegisteredLostDirectSellerStatus

(in/out)	The seller is no longer a registered charity seller and has lost direct seller status.



=cut


use constant NotRegisteredLostDirectSellerStatus => scalar('NotRegisteredLostDirectSellerStatus');


=head2 DirectDebitRejected

(deprecated) The seller's direct debit card was rejected.



=cut


use constant DirectDebitRejected => scalar('DirectDebitRejected');


=head2 RegisteredDirectSeller

The seller is a registered direct seller, but has no credit card associated with the charity seller account.



=cut


use constant RegisteredDirectSeller => scalar('RegisteredDirectSeller');


=head2 RegisteredNoPaymentMethod

The seller is a registered charity seller with no donation payment method on file.



=cut


use constant RegisteredNoPaymentMethod => scalar('RegisteredNoPaymentMethod');


=head2 CustomCode

(out) Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
