use strict;
use warnings;
use Test::Base;

use Geo::Converter::WKT2KML;

plan tests => 1*blocks;

filters {
    input    => [qw/chomp/],
    expected => [qw/chomp/],
};

run {
    my $block = shift;

    is (wkt2kml($block->input),$block->expected);
};

__END__

=== test point
--- input
MULTIPOLYGON(((141.3984375 39.7526041666667,141.40234375 39.7526041666667,141.40234375 39.75,141.3984375 39.75,141.3984375 39.7473958333333,141.3984375 39.7447916666667,141.40234375 39.7447916666667,141.40234375 39.7421875,141.40234375 39.7395833333333,141.40234375 39.7369791666667,141.3984375 39.7369791666667,141.3984375 39.734375,141.39453125 39.734375,141.39453125 39.7317708333333,141.39453125 39.7291666666667,141.39453125 39.7265625,141.3984375 39.7265625,141.3984375 39.7239583333333,141.3984375 39.7213541666667,141.3984375 39.71875,141.3984375 39.7161458333333,141.39453125 39.7161458333333,141.39453125 39.7135416666667,141.39453125 39.7109375,141.39453125 39.7083333333333,141.3984375 39.7083333333333,141.3984375 39.7057291666667,141.40234375 39.7057291666667,141.40234375 39.703125,141.40625 39.703125,141.41015625 39.703125,141.41015625 39.7005208333333,141.41015625 39.6979166666667,141.41015625 39.6953125,141.40625 39.6953125,141.40625 39.6927083333333,141.41015625 39.6927083333333,141.41015625 39.6901041666667,141.40625 39.6901041666667,141.40625 39.6875,141.40234375 39.6875,141.40234375 39.6848958333333,141.3984375 39.6848958333333,141.39453125 39.6848958333333,141.39453125 39.6822916666667,141.39453125 39.6796875,141.390625 39.6796875,141.390625 39.6770833333333,141.38671875 39.6770833333333,141.38671875 39.6744791666667,141.38671875 39.671875,141.3828125 39.671875,141.37890625 39.671875,141.375 39.671875,141.375 39.6692708333333,141.37109375 39.6692708333333,141.3671875 39.6692708333333,141.36328125 39.6692708333333,141.36328125 39.6666666666667,141.359375 39.6666666666667,141.359375 39.6640625,141.359375 39.6614583333333,141.35546875 39.6614583333333,141.35546875 39.6588541666667,141.3515625 39.6588541666667,141.3515625 39.65625,141.34765625 39.65625,141.34765625 39.6536458333333,141.34765625 39.6510416666667,141.34375 39.6510416666667,141.34375 39.6484375,141.34375 39.6458333333333,141.33984375 39.6458333333333,141.33984375 39.6432291666667,141.3359375 39.6432291666667,141.3359375 39.640625,141.33984375 39.640625,141.33984375 39.6380208333333,141.33984375 39.6354166666667,141.33984375 39.6328125,141.33984375 39.6302083333333,141.34375 39.6302083333333,141.34375 39.6276041666667,141.34765625 39.6276041666667,141.34765625 39.625,141.3515625 39.625,141.35546875 39.625,141.35546875 39.6223958333333,141.359375 39.6223958333333,141.359375 39.6197916666667,141.36328125 39.6197916666667,141.3671875 39.6197916666667,141.3671875 39.6171875,141.37109375 39.6171875,141.375 39.6171875,141.375 39.6145833333333,141.37890625 39.6145833333333,141.3828125 39.6145833333333,141.3828125 39.6119791666667,141.38671875 39.6119791666667,141.390625 39.6119791666667,141.390625 39.609375,141.39453125 39.609375,141.39453125 39.6067708333333,141.3984375 39.6067708333333,141.3984375 39.6041666666667,141.40234375 39.6041666666667,141.40625 39.6041666666667,141.40625 39.6015625,141.41015625 39.6015625,141.41015625 39.5989583333333,141.41015625 39.5963541666667,141.4140625 39.5963541666667,141.4140625 39.59375,141.4140625 39.5911458333333,141.41796875 39.5911458333333,141.41796875 39.5885416666667,141.421875 39.5885416666667,141.42578125 39.5885416666667,141.42578125 39.5859375,141.4296875 39.5859375,141.4296875 39.5833333333333,141.43359375 39.5833333333333,141.43359375 39.5807291666667,141.43359375 39.578125,141.43359375 39.5755208333333,141.43359375 39.5729166666667,141.43359375 39.5703125,141.43359375 39.5677083333333,141.4296875 39.5677083333333,141.4296875 39.5651041666667,141.42578125 39.5651041666667,141.421875 39.5651041666667,141.41796875 39.5651041666667,141.41796875 39.5677083333333,141.4140625 39.5677083333333,141.4140625 39.5703125,141.4140625 39.5729166666667,141.41015625 39.5729166666667,141.41015625 39.5755208333333,141.40625 39.5755208333333,141.40234375 39.5755208333333,141.40234375 39.578125,141.3984375 39.578125,141.3984375 39.5755208333333,141.39453125 39.5755208333333,141.390625 39.5755208333333,141.38671875 39.5755208333333,141.3828125 39.5755208333333,141.3828125 39.5729166666667,141.37890625 39.5729166666667,141.37890625 39.5755208333333,141.375 39.5755208333333,141.37109375 39.5755208333333,141.3671875 39.5755208333333,141.3671875 39.5729166666667,141.36328125 39.5729166666667,141.359375 39.5729166666667,141.359375 39.5703125,141.35546875 39.5703125,141.35546875 39.5677083333333,141.3515625 39.5677083333333,141.34765625 39.5677083333333,141.34375 39.5677083333333,141.33984375 39.5677083333333,141.3359375 39.5677083333333,141.33203125 39.5677083333333,141.33203125 39.5703125,141.328125 39.5703125,141.32421875 39.5703125,141.32421875 39.5729166666667,141.3203125 39.5729166666667,141.3203125 39.5755208333333,141.31640625 39.5755208333333,141.31640625 39.5729166666667,141.3125 39.5729166666667,141.3125 39.5755208333333,141.30859375 39.5755208333333,141.30859375 39.578125,141.30859375 39.5807291666667,141.3046875 39.5807291666667,141.3046875 39.5833333333333,141.3046875 39.5859375,141.3046875 39.5885416666667,141.30078125 39.5885416666667,141.30078125 39.5911458333333,141.296875 39.5911458333333,141.296875 39.59375,141.296875 39.5963541666667,141.29296875 39.5963541666667,141.29296875 39.5989583333333,141.29296875 39.6015625,141.2890625 39.6015625,141.2890625 39.6041666666667,141.2890625 39.6067708333333,141.28515625 39.6067708333333,141.28515625 39.609375,141.28515625 39.6119791666667,141.28515625 39.6145833333333,141.28515625 39.6171875,141.28125 39.6171875,141.28125 39.6197916666667,141.28125 39.6223958333333,141.27734375 39.6223958333333,141.2734375 39.6223958333333,141.2734375 39.625,141.26953125 39.625,141.26953125 39.6276041666667,141.265625 39.6276041666667,141.265625 39.6302083333333,141.26171875 39.6302083333333,141.26171875 39.6328125,141.26171875 39.6354166666667,141.2578125 39.6354166666667,141.2578125 39.6380208333333,141.25390625 39.6380208333333,141.25390625 39.640625,141.25390625 39.6432291666667,141.25 39.6432291666667,141.25 39.6458333333333,141.24609375 39.6458333333333,141.2421875 39.6458333333333,141.23828125 39.6458333333333,141.234375 39.6458333333333,141.23046875 39.6458333333333,141.23046875 39.6484375,141.234375 39.6484375,141.234375 39.6510416666667,141.23046875 39.6510416666667,141.23046875 39.6536458333333,141.2265625 39.6536458333333,141.22265625 39.6536458333333,141.22265625 39.65625,141.21875 39.65625,141.21484375 39.65625,141.2109375 39.65625,141.20703125 39.65625,141.203125 39.65625,141.203125 39.6536458333333,141.19921875 39.6536458333333,141.19921875 39.6510416666667,141.1953125 39.6510416666667,141.1953125 39.6484375,141.19140625 39.6484375,141.19140625 39.6510416666667,141.1875 39.6510416666667,141.1875 39.6536458333333,141.18359375 39.6536458333333,141.18359375 39.65625,141.1796875 39.65625,141.1796875 39.6588541666667,141.17578125 39.6588541666667,141.17578125 39.6614583333333,141.171875 39.6614583333333,141.16796875 39.6614583333333,141.1640625 39.6614583333333,141.1640625 39.6640625,141.1640625 39.6666666666667,141.16015625 39.6666666666667,141.16015625 39.6692708333333,141.15625 39.6692708333333,141.15234375 39.6692708333333,141.1484375 39.6692708333333,141.14453125 39.6692708333333,141.140625 39.6692708333333,141.13671875 39.6692708333333,141.1328125 39.6692708333333,141.12890625 39.6692708333333,141.12890625 39.6666666666667,141.125 39.6666666666667,141.12109375 39.6666666666667,141.1171875 39.6666666666667,141.1171875 39.6640625,141.11328125 39.6640625,141.11328125 39.6614583333333,141.109375 39.6614583333333,141.109375 39.6588541666667,141.10546875 39.6588541666667,141.10546875 39.65625,141.10546875 39.6536458333333,141.1015625 39.6536458333333,141.1015625 39.6510416666667,141.09765625 39.6510416666667,141.09375 39.6510416666667,141.09375 39.6484375,141.08984375 39.6484375,141.0859375 39.6484375,141.0859375 39.6458333333333,141.08203125 39.6458333333333,141.078125 39.6458333333333,141.078125 39.6432291666667,141.07421875 39.6432291666667,141.0703125 39.6432291666667,141.0703125 39.640625,141.06640625 39.640625,141.0625 39.640625,141.05859375 39.640625,141.05859375 39.6432291666667,141.0546875 39.6432291666667,141.05078125 39.6432291666667,141.05078125 39.6458333333333,141.046875 39.6458333333333,141.046875 39.6484375,141.05078125 39.6484375,141.05078125 39.6510416666667,141.05078125 39.6536458333333,141.046875 39.6536458333333,141.046875 39.65625,141.046875 39.6588541666667,141.04296875 39.6588541666667,141.04296875 39.6614583333333,141.0390625 39.6614583333333,141.0390625 39.6588541666667,141.0390625 39.65625,141.0390625 39.6536458333333,141.03515625 39.6536458333333,141.03125 39.6536458333333,141.03125 39.6510416666667,141.02734375 39.6510416666667,141.02734375 39.6484375,141.0234375 39.6484375,141.01953125 39.6484375,141.01953125 39.6510416666667,141.015625 39.6510416666667,141.015625 39.6536458333333,141.01171875 39.6536458333333,141.01171875 39.65625,141.01171875 39.6588541666667,141.01171875 39.6614583333333,141.0078125 39.6614583333333,141.00390625 39.6614583333333,141.00390625 39.6640625,141 39.6640625,140.99609375 39.6640625,140.99609375 39.6666666666667,141 39.6666666666667,141 39.6692708333333,141.00390625 39.6692708333333,141.00390625 39.671875,141.0078125 39.671875,141.0078125 39.6744791666667,141.0078125 39.6770833333333,141.01171875 39.6770833333333,141.01171875 39.6796875,141.015625 39.6796875,141.015625 39.6822916666667,141.01171875 39.6822916666667,141.01171875 39.6848958333333,141.01171875 39.6875,141.01171875 39.6901041666667,141.01171875 39.6927083333333,141.015625 39.6927083333333,141.015625 39.6953125,141.01953125 39.6953125,141.01953125 39.6979166666667,141.0234375 39.6979166666667,141.0234375 39.7005208333333,141.02734375 39.7005208333333,141.03125 39.7005208333333,141.03515625 39.7005208333333,141.03515625 39.6979166666667,141.0390625 39.6979166666667,141.0390625 39.6953125,141.0390625 39.6927083333333,141.04296875 39.6927083333333,141.046875 39.6927083333333,141.046875 39.6901041666667,141.05078125 39.6901041666667,141.05078125 39.6927083333333,141.0546875 39.6927083333333,141.0546875 39.6953125,141.05859375 39.6953125,141.0625 39.6953125,141.0625 39.6979166666667,141.06640625 39.6979166666667,141.0703125 39.6979166666667,141.07421875 39.6979166666667,141.07421875 39.7005208333333,141.078125 39.7005208333333,141.078125 39.703125,141.08203125 39.703125,141.0859375 39.703125,141.0859375 39.7057291666667,141.08203125 39.7057291666667,141.078125 39.7057291666667,141.078125 39.7083333333333,141.078125 39.7109375,141.078125 39.7135416666667,141.078125 39.7161458333333,141.078125 39.71875,141.08203125 39.71875,141.08203125 39.7213541666667,141.078125 39.7213541666667,141.078125 39.7239583333333,141.07421875 39.7239583333333,141.07421875 39.7265625,141.078125 39.7265625,141.08203125 39.7265625,141.08203125 39.7239583333333,141.0859375 39.7239583333333,141.0859375 39.7213541666667,141.08984375 39.7213541666667,141.08984375 39.7239583333333,141.09375 39.7239583333333,141.09765625 39.7239583333333,141.09765625 39.7265625,141.09765625 39.7291666666667,141.09765625 39.7317708333333,141.1015625 39.7317708333333,141.10546875 39.7317708333333,141.10546875 39.734375,141.10546875 39.7369791666667,141.10546875 39.7395833333333,141.10546875 39.7421875,141.109375 39.7421875,141.109375 39.7447916666667,141.11328125 39.7447916666667,141.11328125 39.7473958333333,141.1171875 39.7473958333333,141.12109375 39.7473958333333,141.12109375 39.75,141.1171875 39.75,141.1171875 39.7526041666667,141.1171875 39.7552083333333,141.12109375 39.7552083333333,141.12109375 39.7578125,141.12109375 39.7604166666667,141.125 39.7604166666667,141.125 39.7630208333333,141.125 39.765625,141.12890625 39.765625,141.12890625 39.7682291666667,141.1328125 39.7682291666667,141.13671875 39.7682291666667,141.13671875 39.7708333333333,141.140625 39.7708333333333,141.14453125 39.7708333333333,141.1484375 39.7708333333333,141.1484375 39.7682291666667,141.1484375 39.765625,141.15234375 39.765625,141.15625 39.765625,141.16015625 39.765625,141.1640625 39.765625,141.1640625 39.7682291666667,141.16796875 39.7682291666667,141.171875 39.7682291666667,141.17578125 39.7682291666667,141.1796875 39.7682291666667,141.1796875 39.765625,141.18359375 39.765625,141.18359375 39.7630208333333,141.1875 39.7630208333333,141.19140625 39.7630208333333,141.1953125 39.7630208333333,141.1953125 39.765625,141.19921875 39.765625,141.19921875 39.7682291666667,141.203125 39.7682291666667,141.203125 39.7708333333333,141.20703125 39.7708333333333,141.2109375 39.7708333333333,141.21484375 39.7708333333333,141.21875 39.7708333333333,141.22265625 39.7708333333333,141.2265625 39.7708333333333,141.23046875 39.7708333333333,141.234375 39.7708333333333,141.23828125 39.7708333333333,141.2421875 39.7708333333333,141.24609375 39.7708333333333,141.24609375 39.7682291666667,141.25 39.7682291666667,141.25 39.765625,141.25 39.7630208333333,141.25 39.7604166666667,141.25390625 39.7604166666667,141.2578125 39.7604166666667,141.2578125 39.7578125,141.26171875 39.7578125,141.265625 39.7578125,141.26953125 39.7578125,141.26953125 39.7604166666667,141.2734375 39.7604166666667,141.2734375 39.7630208333333,141.27734375 39.7630208333333,141.28125 39.7630208333333,141.28515625 39.7630208333333,141.28515625 39.765625,141.2890625 39.765625,141.29296875 39.765625,141.29296875 39.7682291666667,141.296875 39.7682291666667,141.296875 39.7708333333333,141.30078125 39.7708333333333,141.3046875 39.7708333333333,141.3046875 39.7682291666667,141.3046875 39.765625,141.30078125 39.765625,141.30078125 39.7630208333333,141.30078125 39.7604166666667,141.30078125 39.7578125,141.3046875 39.7578125,141.30859375 39.7578125,141.30859375 39.7604166666667,141.3125 39.7604166666667,141.31640625 39.7604166666667,141.3203125 39.7604166666667,141.3203125 39.7578125,141.32421875 39.7578125,141.32421875 39.7552083333333,141.328125 39.7552083333333,141.328125 39.7526041666667,141.33203125 39.7526041666667,141.33203125 39.7552083333333,141.3359375 39.7552083333333,141.33984375 39.7552083333333,141.34375 39.7552083333333,141.34375 39.7526041666667,141.34765625 39.7526041666667,141.3515625 39.7526041666667,141.35546875 39.7526041666667,141.359375 39.7526041666667,141.36328125 39.7526041666667,141.3671875 39.7526041666667,141.3671875 39.7552083333333,141.37109375 39.7552083333333,141.375 39.7552083333333,141.37890625 39.7552083333333,141.3828125 39.7552083333333,141.38671875 39.7552083333333,141.390625 39.7552083333333,141.39453125 39.7552083333333,141.39453125 39.7526041666667,141.3984375 39.7526041666667)),((141.0703125 39.7265625,141.0703125 39.7291666666667,141.07421875 39.7291666666667,141.07421875 39.7265625,141.0703125 39.7265625)))
--- expected
<MultiGeometry>
<Polygon>
<outerBoundaryIs><LinearRing><coordinates>141.3984375,39.7526041666667
141.40234375,39.7526041666667
141.40234375,39.75
141.3984375,39.75
141.3984375,39.7473958333333
141.3984375,39.7447916666667
141.40234375,39.7447916666667
141.40234375,39.7421875
141.40234375,39.7395833333333
141.40234375,39.7369791666667
141.3984375,39.7369791666667
141.3984375,39.734375
141.39453125,39.734375
141.39453125,39.7317708333333
141.39453125,39.7291666666667
141.39453125,39.7265625
141.3984375,39.7265625
141.3984375,39.7239583333333
141.3984375,39.7213541666667
141.3984375,39.71875
141.3984375,39.7161458333333
141.39453125,39.7161458333333
141.39453125,39.7135416666667
141.39453125,39.7109375
141.39453125,39.7083333333333
141.3984375,39.7083333333333
141.3984375,39.7057291666667
141.40234375,39.7057291666667
141.40234375,39.703125
141.40625,39.703125
141.41015625,39.703125
141.41015625,39.7005208333333
141.41015625,39.6979166666667
141.41015625,39.6953125
141.40625,39.6953125
141.40625,39.6927083333333
141.41015625,39.6927083333333
141.41015625,39.6901041666667
141.40625,39.6901041666667
141.40625,39.6875
141.40234375,39.6875
141.40234375,39.6848958333333
141.3984375,39.6848958333333
141.39453125,39.6848958333333
141.39453125,39.6822916666667
141.39453125,39.6796875
141.390625,39.6796875
141.390625,39.6770833333333
141.38671875,39.6770833333333
141.38671875,39.6744791666667
141.38671875,39.671875
141.3828125,39.671875
141.37890625,39.671875
141.375,39.671875
141.375,39.6692708333333
141.37109375,39.6692708333333
141.3671875,39.6692708333333
141.36328125,39.6692708333333
141.36328125,39.6666666666667
141.359375,39.6666666666667
141.359375,39.6640625
141.359375,39.6614583333333
141.35546875,39.6614583333333
141.35546875,39.6588541666667
141.3515625,39.6588541666667
141.3515625,39.65625
141.34765625,39.65625
141.34765625,39.6536458333333
141.34765625,39.6510416666667
141.34375,39.6510416666667
141.34375,39.6484375
141.34375,39.6458333333333
141.33984375,39.6458333333333
141.33984375,39.6432291666667
141.3359375,39.6432291666667
141.3359375,39.640625
141.33984375,39.640625
141.33984375,39.6380208333333
141.33984375,39.6354166666667
141.33984375,39.6328125
141.33984375,39.6302083333333
141.34375,39.6302083333333
141.34375,39.6276041666667
141.34765625,39.6276041666667
141.34765625,39.625
141.3515625,39.625
141.35546875,39.625
141.35546875,39.6223958333333
141.359375,39.6223958333333
141.359375,39.6197916666667
141.36328125,39.6197916666667
141.3671875,39.6197916666667
141.3671875,39.6171875
141.37109375,39.6171875
141.375,39.6171875
141.375,39.6145833333333
141.37890625,39.6145833333333
141.3828125,39.6145833333333
141.3828125,39.6119791666667
141.38671875,39.6119791666667
141.390625,39.6119791666667
141.390625,39.609375
141.39453125,39.609375
141.39453125,39.6067708333333
141.3984375,39.6067708333333
141.3984375,39.6041666666667
141.40234375,39.6041666666667
141.40625,39.6041666666667
141.40625,39.6015625
141.41015625,39.6015625
141.41015625,39.5989583333333
141.41015625,39.5963541666667
141.4140625,39.5963541666667
141.4140625,39.59375
141.4140625,39.5911458333333
141.41796875,39.5911458333333
141.41796875,39.5885416666667
141.421875,39.5885416666667
141.42578125,39.5885416666667
141.42578125,39.5859375
141.4296875,39.5859375
141.4296875,39.5833333333333
141.43359375,39.5833333333333
141.43359375,39.5807291666667
141.43359375,39.578125
141.43359375,39.5755208333333
141.43359375,39.5729166666667
141.43359375,39.5703125
141.43359375,39.5677083333333
141.4296875,39.5677083333333
141.4296875,39.5651041666667
141.42578125,39.5651041666667
141.421875,39.5651041666667
141.41796875,39.5651041666667
141.41796875,39.5677083333333
141.4140625,39.5677083333333
141.4140625,39.5703125
141.4140625,39.5729166666667
141.41015625,39.5729166666667
141.41015625,39.5755208333333
141.40625,39.5755208333333
141.40234375,39.5755208333333
141.40234375,39.578125
141.3984375,39.578125
141.3984375,39.5755208333333
141.39453125,39.5755208333333
141.390625,39.5755208333333
141.38671875,39.5755208333333
141.3828125,39.5755208333333
141.3828125,39.5729166666667
141.37890625,39.5729166666667
141.37890625,39.5755208333333
141.375,39.5755208333333
141.37109375,39.5755208333333
141.3671875,39.5755208333333
141.3671875,39.5729166666667
141.36328125,39.5729166666667
141.359375,39.5729166666667
141.359375,39.5703125
141.35546875,39.5703125
141.35546875,39.5677083333333
141.3515625,39.5677083333333
141.34765625,39.5677083333333
141.34375,39.5677083333333
141.33984375,39.5677083333333
141.3359375,39.5677083333333
141.33203125,39.5677083333333
141.33203125,39.5703125
141.328125,39.5703125
141.32421875,39.5703125
141.32421875,39.5729166666667
141.3203125,39.5729166666667
141.3203125,39.5755208333333
141.31640625,39.5755208333333
141.31640625,39.5729166666667
141.3125,39.5729166666667
141.3125,39.5755208333333
141.30859375,39.5755208333333
141.30859375,39.578125
141.30859375,39.5807291666667
141.3046875,39.5807291666667
141.3046875,39.5833333333333
141.3046875,39.5859375
141.3046875,39.5885416666667
141.30078125,39.5885416666667
141.30078125,39.5911458333333
141.296875,39.5911458333333
141.296875,39.59375
141.296875,39.5963541666667
141.29296875,39.5963541666667
141.29296875,39.5989583333333
141.29296875,39.6015625
141.2890625,39.6015625
141.2890625,39.6041666666667
141.2890625,39.6067708333333
141.28515625,39.6067708333333
141.28515625,39.609375
141.28515625,39.6119791666667
141.28515625,39.6145833333333
141.28515625,39.6171875
141.28125,39.6171875
141.28125,39.6197916666667
141.28125,39.6223958333333
141.27734375,39.6223958333333
141.2734375,39.6223958333333
141.2734375,39.625
141.26953125,39.625
141.26953125,39.6276041666667
141.265625,39.6276041666667
141.265625,39.6302083333333
141.26171875,39.6302083333333
141.26171875,39.6328125
141.26171875,39.6354166666667
141.2578125,39.6354166666667
141.2578125,39.6380208333333
141.25390625,39.6380208333333
141.25390625,39.640625
141.25390625,39.6432291666667
141.25,39.6432291666667
141.25,39.6458333333333
141.24609375,39.6458333333333
141.2421875,39.6458333333333
141.23828125,39.6458333333333
141.234375,39.6458333333333
141.23046875,39.6458333333333
141.23046875,39.6484375
141.234375,39.6484375
141.234375,39.6510416666667
141.23046875,39.6510416666667
141.23046875,39.6536458333333
141.2265625,39.6536458333333
141.22265625,39.6536458333333
141.22265625,39.65625
141.21875,39.65625
141.21484375,39.65625
141.2109375,39.65625
141.20703125,39.65625
141.203125,39.65625
141.203125,39.6536458333333
141.19921875,39.6536458333333
141.19921875,39.6510416666667
141.1953125,39.6510416666667
141.1953125,39.6484375
141.19140625,39.6484375
141.19140625,39.6510416666667
141.1875,39.6510416666667
141.1875,39.6536458333333
141.18359375,39.6536458333333
141.18359375,39.65625
141.1796875,39.65625
141.1796875,39.6588541666667
141.17578125,39.6588541666667
141.17578125,39.6614583333333
141.171875,39.6614583333333
141.16796875,39.6614583333333
141.1640625,39.6614583333333
141.1640625,39.6640625
141.1640625,39.6666666666667
141.16015625,39.6666666666667
141.16015625,39.6692708333333
141.15625,39.6692708333333
141.15234375,39.6692708333333
141.1484375,39.6692708333333
141.14453125,39.6692708333333
141.140625,39.6692708333333
141.13671875,39.6692708333333
141.1328125,39.6692708333333
141.12890625,39.6692708333333
141.12890625,39.6666666666667
141.125,39.6666666666667
141.12109375,39.6666666666667
141.1171875,39.6666666666667
141.1171875,39.6640625
141.11328125,39.6640625
141.11328125,39.6614583333333
141.109375,39.6614583333333
141.109375,39.6588541666667
141.10546875,39.6588541666667
141.10546875,39.65625
141.10546875,39.6536458333333
141.1015625,39.6536458333333
141.1015625,39.6510416666667
141.09765625,39.6510416666667
141.09375,39.6510416666667
141.09375,39.6484375
141.08984375,39.6484375
141.0859375,39.6484375
141.0859375,39.6458333333333
141.08203125,39.6458333333333
141.078125,39.6458333333333
141.078125,39.6432291666667
141.07421875,39.6432291666667
141.0703125,39.6432291666667
141.0703125,39.640625
141.06640625,39.640625
141.0625,39.640625
141.05859375,39.640625
141.05859375,39.6432291666667
141.0546875,39.6432291666667
141.05078125,39.6432291666667
141.05078125,39.6458333333333
141.046875,39.6458333333333
141.046875,39.6484375
141.05078125,39.6484375
141.05078125,39.6510416666667
141.05078125,39.6536458333333
141.046875,39.6536458333333
141.046875,39.65625
141.046875,39.6588541666667
141.04296875,39.6588541666667
141.04296875,39.6614583333333
141.0390625,39.6614583333333
141.0390625,39.6588541666667
141.0390625,39.65625
141.0390625,39.6536458333333
141.03515625,39.6536458333333
141.03125,39.6536458333333
141.03125,39.6510416666667
141.02734375,39.6510416666667
141.02734375,39.6484375
141.0234375,39.6484375
141.01953125,39.6484375
141.01953125,39.6510416666667
141.015625,39.6510416666667
141.015625,39.6536458333333
141.01171875,39.6536458333333
141.01171875,39.65625
141.01171875,39.6588541666667
141.01171875,39.6614583333333
141.0078125,39.6614583333333
141.00390625,39.6614583333333
141.00390625,39.6640625
141,39.6640625
140.99609375,39.6640625
140.99609375,39.6666666666667
141,39.6666666666667
141,39.6692708333333
141.00390625,39.6692708333333
141.00390625,39.671875
141.0078125,39.671875
141.0078125,39.6744791666667
141.0078125,39.6770833333333
141.01171875,39.6770833333333
141.01171875,39.6796875
141.015625,39.6796875
141.015625,39.6822916666667
141.01171875,39.6822916666667
141.01171875,39.6848958333333
141.01171875,39.6875
141.01171875,39.6901041666667
141.01171875,39.6927083333333
141.015625,39.6927083333333
141.015625,39.6953125
141.01953125,39.6953125
141.01953125,39.6979166666667
141.0234375,39.6979166666667
141.0234375,39.7005208333333
141.02734375,39.7005208333333
141.03125,39.7005208333333
141.03515625,39.7005208333333
141.03515625,39.6979166666667
141.0390625,39.6979166666667
141.0390625,39.6953125
141.0390625,39.6927083333333
141.04296875,39.6927083333333
141.046875,39.6927083333333
141.046875,39.6901041666667
141.05078125,39.6901041666667
141.05078125,39.6927083333333
141.0546875,39.6927083333333
141.0546875,39.6953125
141.05859375,39.6953125
141.0625,39.6953125
141.0625,39.6979166666667
141.06640625,39.6979166666667
141.0703125,39.6979166666667
141.07421875,39.6979166666667
141.07421875,39.7005208333333
141.078125,39.7005208333333
141.078125,39.703125
141.08203125,39.703125
141.0859375,39.703125
141.0859375,39.7057291666667
141.08203125,39.7057291666667
141.078125,39.7057291666667
141.078125,39.7083333333333
141.078125,39.7109375
141.078125,39.7135416666667
141.078125,39.7161458333333
141.078125,39.71875
141.08203125,39.71875
141.08203125,39.7213541666667
141.078125,39.7213541666667
141.078125,39.7239583333333
141.07421875,39.7239583333333
141.07421875,39.7265625
141.078125,39.7265625
141.08203125,39.7265625
141.08203125,39.7239583333333
141.0859375,39.7239583333333
141.0859375,39.7213541666667
141.08984375,39.7213541666667
141.08984375,39.7239583333333
141.09375,39.7239583333333
141.09765625,39.7239583333333
141.09765625,39.7265625
141.09765625,39.7291666666667
141.09765625,39.7317708333333
141.1015625,39.7317708333333
141.10546875,39.7317708333333
141.10546875,39.734375
141.10546875,39.7369791666667
141.10546875,39.7395833333333
141.10546875,39.7421875
141.109375,39.7421875
141.109375,39.7447916666667
141.11328125,39.7447916666667
141.11328125,39.7473958333333
141.1171875,39.7473958333333
141.12109375,39.7473958333333
141.12109375,39.75
141.1171875,39.75
141.1171875,39.7526041666667
141.1171875,39.7552083333333
141.12109375,39.7552083333333
141.12109375,39.7578125
141.12109375,39.7604166666667
141.125,39.7604166666667
141.125,39.7630208333333
141.125,39.765625
141.12890625,39.765625
141.12890625,39.7682291666667
141.1328125,39.7682291666667
141.13671875,39.7682291666667
141.13671875,39.7708333333333
141.140625,39.7708333333333
141.14453125,39.7708333333333
141.1484375,39.7708333333333
141.1484375,39.7682291666667
141.1484375,39.765625
141.15234375,39.765625
141.15625,39.765625
141.16015625,39.765625
141.1640625,39.765625
141.1640625,39.7682291666667
141.16796875,39.7682291666667
141.171875,39.7682291666667
141.17578125,39.7682291666667
141.1796875,39.7682291666667
141.1796875,39.765625
141.18359375,39.765625
141.18359375,39.7630208333333
141.1875,39.7630208333333
141.19140625,39.7630208333333
141.1953125,39.7630208333333
141.1953125,39.765625
141.19921875,39.765625
141.19921875,39.7682291666667
141.203125,39.7682291666667
141.203125,39.7708333333333
141.20703125,39.7708333333333
141.2109375,39.7708333333333
141.21484375,39.7708333333333
141.21875,39.7708333333333
141.22265625,39.7708333333333
141.2265625,39.7708333333333
141.23046875,39.7708333333333
141.234375,39.7708333333333
141.23828125,39.7708333333333
141.2421875,39.7708333333333
141.24609375,39.7708333333333
141.24609375,39.7682291666667
141.25,39.7682291666667
141.25,39.765625
141.25,39.7630208333333
141.25,39.7604166666667
141.25390625,39.7604166666667
141.2578125,39.7604166666667
141.2578125,39.7578125
141.26171875,39.7578125
141.265625,39.7578125
141.26953125,39.7578125
141.26953125,39.7604166666667
141.2734375,39.7604166666667
141.2734375,39.7630208333333
141.27734375,39.7630208333333
141.28125,39.7630208333333
141.28515625,39.7630208333333
141.28515625,39.765625
141.2890625,39.765625
141.29296875,39.765625
141.29296875,39.7682291666667
141.296875,39.7682291666667
141.296875,39.7708333333333
141.30078125,39.7708333333333
141.3046875,39.7708333333333
141.3046875,39.7682291666667
141.3046875,39.765625
141.30078125,39.765625
141.30078125,39.7630208333333
141.30078125,39.7604166666667
141.30078125,39.7578125
141.3046875,39.7578125
141.30859375,39.7578125
141.30859375,39.7604166666667
141.3125,39.7604166666667
141.31640625,39.7604166666667
141.3203125,39.7604166666667
141.3203125,39.7578125
141.32421875,39.7578125
141.32421875,39.7552083333333
141.328125,39.7552083333333
141.328125,39.7526041666667
141.33203125,39.7526041666667
141.33203125,39.7552083333333
141.3359375,39.7552083333333
141.33984375,39.7552083333333
141.34375,39.7552083333333
141.34375,39.7526041666667
141.34765625,39.7526041666667
141.3515625,39.7526041666667
141.35546875,39.7526041666667
141.359375,39.7526041666667
141.36328125,39.7526041666667
141.3671875,39.7526041666667
141.3671875,39.7552083333333
141.37109375,39.7552083333333
141.375,39.7552083333333
141.37890625,39.7552083333333
141.3828125,39.7552083333333
141.38671875,39.7552083333333
141.390625,39.7552083333333
141.39453125,39.7552083333333
141.39453125,39.7526041666667
141.3984375,39.7526041666667</coordinates></LinearRing></outerBoundaryIs>
</Polygon>
<Polygon>
<outerBoundaryIs><LinearRing><coordinates>141.0703125,39.7265625
141.0703125,39.7291666666667
141.07421875,39.7291666666667
141.07421875,39.7265625
141.0703125,39.7265625</coordinates></LinearRing></outerBoundaryIs>
</Polygon>
</MultiGeometry>



