/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLAccumulator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class XSLAccumulatorRule
extends StyleElement {
    private Pattern match;
    private boolean postDescent;
    private Expression select;

    public void prepareAttributes() throws XPathException {
        String matchAtt = null;
        String newValueAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("match")) {
                matchAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("select")) {
                newValueAtt = atts.getValue(a);
                this.select = this.makeExpression(newValueAtt, a);
                continue;
            }
            if (f.equals("phase")) {
                String phaseAtt = Whitespace.trim(atts.getValue(a));
                if ("start".equals(phaseAtt)) {
                    this.postDescent = false;
                    continue;
                }
                if ("end".equals(phaseAtt)) {
                    this.postDescent = true;
                    continue;
                }
                this.postDescent = true;
                this.compileError("phase must be 'start' or 'end'", "XTSE0020");
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (matchAtt == null) {
            this.reportAbsence("match");
            matchAtt = "non-existent-element";
        }
        this.match = this.makePattern(matchAtt, "match");
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        this.select = this.typeCheck("select", this.select);
        this.match = this.typeCheck("match", this.match);
        if (this.select != null && this.iterateAxis((byte)3).next() != null) {
            this.compileError("If the xsl:accumulator-rule element has a select attribute then it must have no children");
        }
    }

    public Expression getNewValueExpression(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        if (this.select == null) {
            this.select = this.compileSequenceConstructor(compilation, decl, true);
        }
        return this.select;
    }

    public Pattern getMatch() {
        return this.match;
    }

    public void setMatch(Pattern match) {
        this.match = match;
    }

    public boolean isPostDescent() {
        return this.postDescent;
    }

    public void setPostDescent(boolean postDescent) {
        this.postDescent = postDescent;
    }

    public Expression getSelect() {
        return this.select;
    }

    public void setSelect(Expression select) {
        this.select = select;
    }

    public SourceBinding hasImplicitBinding(StructuredQName name) {
        if (name.getLocalPart().equals("value") && name.hasURI("")) {
            SourceBinding sb = new SourceBinding(this);
            sb.setVariableQName(new StructuredQName("", "", "value"));
            assert ((XSLAccumulator)this.getParent() != null);
            sb.setDeclaredType(((XSLAccumulator)this.getParent()).getResultType());
            sb.setProperty(8192, true);
            return sb;
        }
        return null;
    }
}

