# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::RU;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250605193636;

my $formatters = [
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '[0-79]',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                [0-356]2|
                4[29]|
                7|
                8[27]
              )|
              2(?:
                13[03-69]|
                62[013-9]
              )
            )|
            72[1-57-9]2
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                0(?:
                  [356]|
                  4[023]
                )|
                [18]|
                2(?:
                  3[013-9]|
                  5
                )|
                3[45]|
                43[013-79]|
                5(?:
                  3[1-8]|
                  4[1-7]|
                  5
                )|
                6(?:
                  3[0-35-9]|
                  [4-6]
                )
              )|
              2(?:
                1(?:
                  3[178]|
                  [45]
                )|
                [24-689]|
                3[35]|
                7[457]
              )
            )|
            7(?:
              14|
              23
            )4[0-8]|
            71(?:
              33|
              45
            )[1-79]
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{5})(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3-$4',
                  'leading_digits' => '
            [349]|
            8(?:
              [02-7]|
              1[1-8]
            )
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '8',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'geographic' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'mobile' => '9\\d{9}',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(80[39]\\d{7})',
                'toll_free' => '
          8(?:
            0[04]|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{ru} = {"7487", "Тульская\ обл\.",
"772132", "Нуринский\ р\-н",
"77272983", "Каскелен",
"771144", "Казталовский\ р\-н",
"771638", "Аккольский\ р\-н",
"7343", "Свердловская\ обл",
"7485", "Ярославская\ обл\.",
"772938", "Тупкараганский\ р\-н",
"7302", "Забайкальский\ край",
"771640", "Сандыктауский\ р\-н",
"7391", "Красноярский\ край",
"772643", "Шуский\ р\-н",
"7342", "Пермский\ край",
"772137", "Сарань",
"77106", "Сатпаев",
"77224", "Эмельтау",
"772777", "Райымбекский\ р\-н",
"7834", "Республика\ Мордовия",
"772548", "Шаян",
"7491", "Рязанская\ обл\.",
"771238", "Кзылкогинский\ р\-н",
"771043", "Жайрем\ \(поселок\)",
"771340", "Хобдинский\ р\-н",
"771838", "Майский\ р\-он",
"772438", "Казалинский\ р\-н",
"772343", "Курчумский\ р\-н",
"772146", "Каркаралинск",
"7472", "Белгородская\ обл\.",
"772843", "Лепсы",
"771443", "Мендыкаринский\ р\-н",
"771840", "Баянаульский\ р\-н",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"771135", "Жанибекский\ р\-н",
"771539", "Кызылжарский\ р\-н",
"771455", "Костанайский\ р\-н",
"77152", "Петропавловск",
"7821", "Республика\ Коми",
"771449", "Тарановский\ р\-н",
"7473", "Воронежская\ обл\.",
"772530", "Темирлановка",
"7385", "Алтайский\ край",
"772772", "Капчагай",
"771533", "Айыртауский\ р\-н",
"7301", "Республика\ Бурятия",
"772332", "Шемонаихинский\ р\-н",
"771032", "Каражал",
"77149", "Костанай",
"772837", "Алакольский\ р\-н",
"771437", "Камыстинский\ р\-н",
"772237", "Аязог",
"7341", "Республика\ Удмуртская",
"772641", "Таласский\ р\-н",
"771547", "Жамбылский\ р\-н",
"771635", "Жаксынский\ р\-н",
"77187", "Экибастуз",
"771542", "Уалихановский\ р\-н",
"772935", "Каракиянский\ р\-н",
"771844", "Иртышский\ р\-н",
"7415", "Камчатский\ край",
"772534", "Жетысай",
"772832", "Аксуский\ р\-н",
"771037", "Актогайский\ р\-н",
"7496", "г\.\ Москва",
"772337", "Серебрянск",
"771235", "Макатский\ р\-н",
"772545", "Икан",
"772637", "Байзакский\ р\-н",
"771531", "Магжана\ Жумабаева\ р\-н",
"7493", "Ивановская\ обл\.",
"7814", "Республика\ Карелия",
"772149", "Осакаровский\ р\-н",
"772759", "Алматинская\ область",
"772346", "Тарбагатайский\ р\-н",
"771140", "Бокейординский\ р\-н",
"772435", "Жанакорганский\ р\-н",
"771441", "Карабалыкский\ р\-н",
"772841", "Аксуский\ р\-н",
"771644", "Аршалынский\ р\-н",
"771446", "Узункольский\ р\-н",
"771458", "Костанайская\ область",
"733", "Байконыр",
"771041", "Актау\,\ Жезказган",
"771138", "Казталовский\ р\-н",
"7492", "Владимирская\ обл\.",
"772341", "Катон\-Карагайский\ р\-н",
"771335", "Шалкарский\ р\-н",
"7498", "Московская\ обл\.",
"7471", "Курская\ обл\.",
"772632", "Меркенский\ р\-н",
"771536", "Тайыншинский\ р\-н",
"772533", "Туркестан",
"7865", "Ставропольский\ край",
"7833", "Кировская\ обл\.",
"77252", "Шымкент",
"7811", "Псковская\ обл\.",
"772539", "Казыгурт",
"771141", "Жангалинский\ р\-н",
"771440", "Амангельдинский\ р\-н",
"772840", "Кербулакский\ р\-н",
"771038", "Сыры\-Шаган",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"77272", "Алма\-Ата",
"772338", "Уланский\ р\-н",
"771843", "Майский\ р\-н",
"771146", "Акжаикский\ р\-н",
"7349", "Ямало\-Ненецкий\ АО",
"771040", "Жайрем\ \(ГОК\)",
"771438", "Амангельдинский\ р\-н",
"771343", "Иргизский\ р\-н",
"772838", "Коксуский\ р\-н",
"772340", "Зайсанский\ р\-н",
"77273", "Алма\-Ата",
"7717", "Астана",
"7474", "Липецкая\ обл\.",
"771349", "Шалкарский\ р\-н",
"771457", "Джангильдинский\ р\-н",
"771649", "Жаксынский\ р\-н",
"7847", "Республика\ Калмыкия",
"771137", "Чингирлауский\ р\-н",
"7877", "Республика\ Адыгея",
"7845", "Саратовская\ обл\.",
"771643", "Атбасарский\ р\-н",
"772640", "Мойынкумский\ р\-н",
"772257", "Шульбинск",
"772638", "Шуский\ р\-н",
"772252", "Абайский\ р\-н",
"772775", "Енбекшиказахский\ р\-н",
"772144", "Нуринский\ р\-н",
"7836", "Республика\ Марий\ Эл",
"771132", "Теректинский\ р\-н",
"771452", "Карасуский\ р\-н",
"772536", "Кентау",
"7820", "Вологодская\ обл\.",
"772937", "Каракиянский\ р\-н",
"7831", "Нижегородская\ обл\.",
"771632", "Зерендинский\ р\-н",
"7813", "Ленинградская\ обл\.",
"7494", "Костромская\ обл\.",
"771341", "Хобдинский\ р\-н",
"772335", "Зыряновск",
"772138", "Бухар\-Жырауский\ р\-н",
"771035", "Улытауский\ р\-н",
"77145834", "Красногорск",
"772644", "Таласский\ р\-н",
"771143", "Теректинский\ р\-н",
"772835", "Текели",
"771841", "Актогайский\ р\-н",
"771435", "Житикаринский\ р\-н",
"771346", "Темирский\ р\-н",
"7812", "г\.\ Санкт\-Петербург",
"771149", "Акжаикский\ р\-н",
"7818", "Архангельская\ обл\.",
"771637", "Коргалжынский\ р\-н",
"771545", "Жамбылский\ р\-н",
"772531", "Аксукент",
"772932", "Бейнеуский\ р\-н",
"771337", "Алгинский\ р\-н",
"7427", "Чукотский\ АО",
"771832", "Иртышский\ р\-н",
"772432", "Шиелийский\ р\-н",
"771534", "Шал\ Акына\ р\-н",
"771444", "Узункольский\ р\-н",
"771646", "Буландинский\ р\-н",
"771232", "Атырауская\ область",
"7851", "Астраханская\ обл\.",
"772542", "Асыката",
"7390", "Республика\ Хакасия",
"772778", "Уйгурский\ р\-н",
"772344", "Тарбагатайский\ р\-н",
"772547", "Ленгер",
"772635", "Жуалынский\ р\-н",
"771641", "Астраханский\ р\-н",
"7394", "Республика\ Тыва",
"771237", "Жылыойский\ р\-н",
"772437", "Кармакшинский\ р\-н",
"771837", "Аксуский\ р\-н",
"7499", "г\.\ Москва",
"7816", "Новгородская\ обл\.",
"771332", "Уилский\ р\-н",
"7426", "Еврейская\ автономная\ обл\.",
"771546", "Акжарский\ р\-н",
"772642", "Мойынкумский\ р\-н",
"772236", "Бескарагайский\ р\-н",
"77125", "Атырауская\ область",
"77245", "Кызылординская\ область",
"77185", "Шалдай",
"771345", "Байганинский\ р\-н",
"772331", "Глубоковский\ р\-н",
"771031", "Шетский\ р\-н",
"772725", "Отеген\-Батыр",
"77213", "Темиртау",
"772836", "Ескельдинский\ р\-н",
"7712302", "Тенгизшевройл",
"771436", "Тарановский\ р\-н",
"77135", "Актюбинская\ область",
"772934", "Жанаозен",
"771130", "Зеленовский\ р\-н",
"771431", "Рудный",
"771845", "Павлодар",
"772831", "Панфиловский\ р\-н",
"772336", "Риддер",
"7815", "Мурманская\ обл\.",
"7861", "Краснодарский\ край",
"77212", "Караганда",
"771036", "Балхаш",
"771541", "Мамлютский\ р\-н",
"772535", "Шардара",
"7817", "Вологодская\ обл\.",
"772347", "Жарминский\ р\-н",
"772779", "Райымбекский\ р\-н",
"771442", "Федоровский\ р\-н",
"771234", "Индерский\ р\-н",
"772842", "Кербулакский\ р\-н",
"772544", "Шаульдер",
"771834", "Успенский\ р\-н",
"772636", "Кордай",
"772773", "Балхашский\ р\-н",
"771532", "Аккайынский\ р\-н",
"772154", "Бухар\-Жырауский\ р\-н",
"771334", "Мугалжарский\ р\-н",
"772631", "Турара\ Рыскулова\ р\-н",
"771645", "Степногорск",
"771537", "Тимирязевский\ р\-н",
"7841", "Пензенская\ обл\.",
"771447", "Карабалыкский\ р\-н",
"771042", "Акой",
"7871", "Республика\ Чеченская",
"7423", "Приморский\ край",
"772342", "Катон\-Карагайский\ р\-н",
"7846", "Самарская\ обл\.",
"771230", "Атырауская\ область",
"771543", "Есильский\ р\-н",
"772540", "Арыс",
"7862", "Краснодарский\ край",
"77222", "Семипалатинск",
"771439", "Джангильдинский\ р\-н",
"772839", "Саркандский\ р\-н",
"77142", "Костанай",
"77282", "Талдыкорган",
"772239", "Урджарский\ р\-н",
"772131", "Абайский\ р\-н",
"771145", "Каратобинский\ р\-н",
"7384", "Кемеровская\ обл\.",
"772833", "Алакольский\ р\-н",
"771348", "Шалкарский\ р\-н",
"771433", "Лисаковск",
"77102", "Жезказган",
"77232", "Усть\-Каменогорск",
"7863", "Ростовская\ обл\.",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"772333", "Кокпектинский\ р\-н",
"771330", "Хромтауский\ р\-н",
"771033", "Шетский\ р\-н",
"772538", "имени\ Турара\ Рыскулова",
"772339", "Курчумский\ р\-н",
"771039", "Приозерск",
"772639", "Сарысуский\ р\-н",
"7878", "Республика\ Карачаево\-Черкесская",
"772147", "Каркаралинский\ р\-н",
"772757", "Акший",
"7848", "Самарская\ обл\.",
"772633", "Жамбылский\ р\-н",
"772776", "Енбекшиказахский\ р\-н",
"7842", "Ульяновская\ обл\.",
"771630", "Боровое",
"77262", "Тараз",
"7872", "Республика\ Дагестан",
"7866", "Республика\ Кабардино\-Балкарская",
"771651", "Целиноградский\ р\-н",
"771648", "Жаркаинский\ р\-н",
"771454", "Наурзумский\ р\-н",
"772771", "Карасайский\ р\-н",
"771134", "Сырымский\ р\-н",
"7421", "Хабаровский\ край",
"7873", "Республика\ Ингушетия",
"7855", "Республика\ Татарстан",
"772752", "Илийский\ р\-н",
"7843", "Республика\ Татарстан",
"7484", "Калужская\ обл\.",
"771342", "Каргалинский\ р\-н",
"7413", "Магаданская\ обл\.",
"7395", "Иркутская\ обл\.",
"77279", "Алматы",
"771631", "Шортандинский\ р\-н",
"772537", "Сарыагаш",
"772334", "Уланский\ р\-н",
"771034", "Улытауский\ р\-н",
"772532", "Абая",
"772931", "Мангистауский\ р\-н",
"772770", "Жамбылский\ р\-н",
"771434", "Денисовский\ р\-н",
"772834", "Каратальский\ р\-н",
"771636", "Щучинский\ р\-н",
"7424", "Сахалинская\ обл\.",
"771544", "Жамбылский\ р\-н",
"7351", "Челябинская\ обл\.",
"771842", "Майский\ р\-он",
"771347", "Айтекебийский\ р\-н",
"7712303", "Тензиз",
"7481", "Смоленская\ обл\.",
"771231", "Исатайский\ р\-н",
"771647", "Есильский\ р\-н",
"772541", "Мырзакент",
"771535", "Габита\ Мусрепова\ р\-н",
"771459", "Костанайская\ область",
"736", "Республика\ Крым",
"771139", "Таскалинский\ р\-н",
"77112", "Уральск",
"771336", "Хромтауский\ р\-н",
"771453", "Аулиекольский\ р\-н",
"771831", "Железинский\ р\-н",
"771445", "Алтынсаринский\ р\-н",
"772431", "Жалагашский\ р\-н",
"7381", "Омская\ обл\.",
"771133", "Бурлинский\ р\-н",
"772436", "Сырдарьинский\ р\-н",
"772353", "Бородулихинский\ р\-н",
"772634", "Жанатас",
"771836", "Щербактинский\ р\-н",
"740", "Калининградская\ обл\.",
"772148", "Осакаровский\ р\-н",
"772156", "Шахтинск",
"7495", "Московская\ обл\.",
"771331", "Мартукский\ р\-н",
"772345", "Жарминский\ р\-н",
"771642", "Егиндыкольский\ р\-н",
"771236", "Махамбетский\ р\-н",
"772546", "Шолаккорган",
"7416", "Амурская\ обл\.",
"771142", "Акжаикский\ р\-н",
"7411", "Республика\ Саха\ \/Якутия\/",
"7352", "Курганская\ обл\.",
"7482", "Тверская\ обл\.",
"7869", "г\.\ Севастополь",
"77292", "Актау",
"7347", "Республика\ Башкортостан",
"77162", "Кокшетау",
"771633", "Ерейментауский\ р\-н",
"7844", "Волгоградская\ обл\.",
"7483", "Брянская\ обл\.",
"7345", "Тюменская\ обл\.",
"771147", "Акжаикский\ р\-н",
"7353", "Оренбургская\ обл\.",
"771639", "Енбекшилдерский\ р\-н",
"771339", "Айтекебийский\ р\-н",
"771538", "Кызылжарский\ р\-н",
"772256", "Алгабас",
"7879", "Ставропольский\ край",
"7486", "Орловская\ обл\.",
"77272956", "Талгар",
"7383", "Новосибирская\ обл\.",
"77274", "Карасайский\ р\-н",
"772330", "Зыряновский\ р\-н",
"771333", "Мугалжарский\ р\-н",
"771456", "Качар",
"771448", "Карасуский\ р\-н",
"771030", "Жана\-Аркинский\ р\-н",
"7475", "Тамбовская\ обл\.",
"77132", "Актобе\/Актюбинск",
"772351", "Бородулихинский\ р\-н",
"771136", "Акжаикский\ р\-н",
"772348", "Кокпектинский\ р\-н",
"772433", "Аральский\ р\-н",
"771833", "Качирский\ р\-н",
"772774", "Талгарский\ р\-н",
"7388", "Республика\ Алтай",
"771430", "Аркалык",
"771131", "Зеленовский\ р\-н",
"772830", "Алакольский\ р\-н",
"771239", "Макатский\ р\-н",
"772153", "Абайский\ р\-н",
"77182", "Павлодар",
"771451", "Сарыкольский\ р\-н",
"77242", "Кызылорда",
"771839", "Лебяжинский\ р\-н",
"772439", "Аральский\ р\-н",
"77122", "Атырау",
"772251", "Курчатов",
"772159", "Карагандинская\ область",
"771233", "Курмангазинский\ р\-н",
"771540", "Уалихановский\ р\-н",
"7382", "Томская\ обл\.",
"772543", "Аксумбе",
"772230", "Урджарский\ р\-н",};
$areanames{en} = {"771647", "Esil",
"772541", "Myrzakent",
"771459", "Kostanai\ Region",
"771535", "Novoishimski",
"771231", "Akkystau",
"771139", "Taskala",
"736", "Simferopol",
"771453", "Auliekol",
"771336", "Khromtau",
"77112", "Uralsk",
"771133", "Aksai",
"7381", "Omsk",
"771445", "Ubaganskoye",
"772431", "Zhalagash",
"771831", "Zhelezinka",
"740", "Kaliningrad",
"771836", "Sharbakty",
"772634", "Zhanatas",
"772436", "Terenozek",
"772353", "Novaya\ Shulba",
"772345", "Shar",
"771331", "Martuk",
"7495", "Moscow",
"772148", "Molodezhnoye",
"772156", "Shakhtinsk",
"7416", "Amur\ Region",
"772546", "Sholakkorgan",
"771236", "Makhambet",
"771642", "Egendykol",
"7413", "Magadan",
"771342", "Badamsha",
"77279", "Almaty",
"7395", "Irkutsk",
"772537", "Saryagash",
"771631", "Shortandy",
"771034", "Zhezdy",
"772334", "Tavricheskoye",
"771636", "Shuchinsk",
"772834", "Ushtobe",
"771434", "Denisovka",
"772770", "Uzynagash",
"772931", "Shetpe",
"772532", "Abai",
"771842", "Koktobe",
"7351", "Chelyabinsk",
"7424", "Sakhalin\ Region",
"771544", "Presnovka",
"7481", "Smolensk",
"7712303", "Tengizs",
"771347", "Aitekebisky\ District",
"771339", "Komsomolskoye",
"7486", "Orel",
"7879", "Mineranye\ Vody",
"772256", "Kainar",
"771538", "Beskol",
"771030", "Atasu",
"771456", "Kachar",
"771448", "Oktyabrskoye",
"771333", "Kandyagash",
"772330", "Zyryanovsky\ District",
"77274", "Karassaisky\ District",
"7383", "Novosibirsk",
"77272956", "Talgar",
"771136", "Chapayev",
"772351", "Borodulikha",
"77132", "Aktobe\/Kargalinskoye",
"7475", "Tambov",
"772830", "Alakolsky\ District",
"771430", "Arkalyk",
"771131", "Darinskoye",
"7388", "Republic\ of\ Altai",
"772774", "Talgar",
"771833", "Terenkol",
"772433", "Aralsk",
"772348", "Kokpekty",
"77242", "Kyzylorda",
"771451", "Sarykol",
"77182", "Pavlodar",
"771239", "Makat",
"772153", "Topar",
"77122", "Atyrau",
"772251", "Kurchatov",
"772439", "Aralsky\ District",
"771839", "Akku",
"772230", "Urdzhar",
"772543", "Aqsumbe",
"7382", "Tomsk",
"771540", "Kishkenekol",
"772159", "Karaganda\ Region",
"771233", "Ganyushkino",
"7411", "Republic\ of\ Sakha",
"771142", "Taipak",
"7352", "Kurgan",
"7869", "Sevastopol",
"7482", "Tver",
"77292", "Aktau",
"77162", "Kokshetau\/Krasni\ Yar",
"7347", "Republic\ of\ Bashkortostan",
"771633", "Ereimentau",
"771147", "Akzhaiksky\ District",
"7345", "Tyumen",
"7483", "Bryansk",
"7844", "Volgograd",
"771639", "Stepnyak",
"7353", "Orenburg",
"772779", "Narynkol",
"772347", "Kalbatau",
"772544", "Shaulder",
"772842", "Kogaly",
"771234", "Indernborski",
"771442", "Fyodorovka",
"771532", "Smirnovo",
"772773", "Bakanas",
"772636", "Kordai",
"771834", "Uspenka",
"772154", "Botakara",
"771334", "Emba",
"771645", "Stepnogorsk",
"772631", "Kulan",
"771537", "Timiryazevo",
"771447", "Karabalyksky\ District",
"7841", "Penza",
"772342", "Katon\-Karagai",
"7423", "Primorie\ territory",
"7871", "Chechen\ Republic",
"771042", "Zharyk",
"772642", "Moiynkum",
"772236", "Beskaragai",
"771546", "Talshik",
"7426", "Jewish\ Autonomous\ Region",
"77125", "Atyrau\ Region",
"771031", "Aksu\-Ayuly",
"772331", "Glubokoye",
"771345", "Karauylkeldy",
"77185", "Shaldai",
"77245", "Kyzylorda\ Region",
"771436", "Taranovskoye",
"7712302", "Tengizshevroil",
"772836", "Karabulak",
"77213", "Aktau\/Temirtau",
"772725", "Otegen\ Batyra",
"771845", "Pavlodar\ Area",
"772831", "Zharkent",
"771130", "Peremetnoye",
"771431", "Rudny",
"77135", "Aktobe\ Region",
"772934", "Zhanaozen",
"771036", "Balkhash",
"7815", "Murmansk",
"7861", "Krasnodar\ Territory",
"77212", "Karaganda",
"772336", "Ridder",
"7817", "Vologda",
"771541", "Mamlutka",
"772535", "Shardara",
"7878", "Karachayevo\-Cherkessian\ Republic",
"772639", "Saudakent",
"7848", "Tolyatti",
"772757", "Akshi",
"772147", "Egindybulak",
"771630", "Burabay",
"7842", "Ulyanovsk",
"772776", "Shelek",
"772633", "Asa",
"7866", "Kabardino\-Balkarian\ Republic",
"7872", "Republic\ of\ Daghestan",
"77262", "Taraz",
"771651", "Kabanbai\ Batyr",
"771454", "Karamendy",
"771648", "Derzhavinsk",
"771134", "Zhympity",
"772771", "Kaskelen",
"772752", "Otegen\ Batyra",
"7855", "Naberezhnye\ Chelny",
"7873", "Ingushi\ Republic",
"7421", "Khabarovsk\ Territory",
"7484", "Kaluga",
"7843", "Republic\ of\ Tatarstan",
"772540", "Arys",
"771230", "Atyrau\ Region",
"7846", "Samara",
"771543", "Yavlenka",
"772839", "Sarkand",
"771439", "Torgai",
"77222", "Semey",
"7862", "Sochi",
"772239", "Makanchi",
"77282", "Taldykorgan",
"77142", "Kostanai",
"771348", "Shalkarsky\ District",
"771433", "Lisakovsk",
"772833", "Usharal",
"7384", "Kemerovo",
"772131", "Abai",
"771145", "Karatobe\ District",
"7863", "Rostov",
"77232", "Ust\-Kamenogorsk",
"7835", "Chuvashi\ Republic",
"77102", "Zhezkazgan",
"771033", "Agadyr",
"771330", "Khromtau\ District",
"772333", "Samarskoye",
"772538", "Turara\ Ryskulova",
"771039", "Priozersk",
"772339", "Kurchum",
"7847", "Republic\ of\ Kalmykia",
"771457", "Dzhangildinsky\ District",
"771649", "Zhaksynsky\ District",
"7877", "Republic\ of\ Adygeya",
"771137", "Chingirlau",
"772640", "Moiynkumsky\ District",
"7845", "Saratov",
"771643", "Atbasar",
"772257", "Shulbinsk",
"772638", "Tole\ bi",
"772252", "Karaul",
"772144", "Kiyevka",
"772775", "Esik",
"771132", "Fyodorovka",
"7836", "Republic\ of\ Marij\ El",
"771452", "Karasu",
"772533", "Turkestan",
"7811", "Pskov",
"7865", "Stavropol\ territory",
"7833", "Kirov",
"77252", "Shymkent",
"772539", "Kazygurt",
"771843", "Maisky\ District",
"772338", "Bozanbai\/Molodezhnyi",
"7867", "Republic\ of\ North\ Ossetia",
"77272", "Almaty",
"771038", "Shashubai",
"772840", "Saryozek",
"771141", "Zhangala",
"771440", "Amangeldy",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"771146", "Akzhaiksky\ District",
"772340", "Zaisan",
"77273", "Almaty",
"772838", "Balpyk\ bi",
"771438", "Amangeldy",
"771343", "Irgiz",
"771040", "Zhairem\ \(GOK\)",
"7717", "Astana",
"771349", "Shalkarsky\ District",
"7474", "Lipetsk",
"7427", "Chukotka\ Autonomous\ District",
"771337", "Alga",
"771534", "Sergeyevka",
"772432", "Shiyeli",
"771832", "Irtyshsk",
"772542", "Asykata",
"7851", "Astrakhan",
"771232", "Atyrau\ Region",
"771646", "Makinsk",
"771444", "Uzunkol",
"7390", "Republic\ of\ Khakassia",
"772344", "Akzhar",
"772778", "Chundzha",
"771237", "Kulsary",
"7394", "Republic\ of\ Tuva",
"772547", "Lenger",
"771641", "Astrakhanka",
"772635", "Bauyrzhan\ Mamyshuly",
"771837", "Aksu",
"772437", "Zhosaly",
"7816", "Veliky\ Novgorod",
"771332", "Uil",
"7499", "Moscow",
"7831", "Nizhni\ Novgorod",
"7813", "Leningrad\ region",
"771632", "Zerenda",
"772937", "Kuryk",
"7820", "Cherepovets",
"772536", "Kentau",
"7494", "Kostroma",
"771035", "Ulytau",
"772138", "Gabidena\ Mustafina",
"772335", "Zyryanovsk",
"771341", "Khobda",
"772644", "Karatau",
"77145834", "Krasnogorsk",
"771435", "Zhitikara",
"772835", "Tekeli",
"771841", "Aktogai",
"771143", "Akzhaik",
"771346", "Shubarkuduk",
"7812", "St\ Petersburg",
"7818", "Arkhangelsk",
"771149", "Zelenovsky\ District",
"772932", "Beineu",
"771637", "Korgalzhyn",
"771545", "Zhambylsky\ District",
"772531", "Aksukent",
"7834", "Republic\ of\ Mordovia",
"772777", "Kegen",
"77224", "Barshatas",
"771238", "Miyaly",
"7491", "Ryazan",
"772548", "Shayan",
"772343", "Terekty",
"772438", "Aiteke\ bi",
"771838", "Koktobe",
"771340", "Khobdinsky\ District",
"771043", "Zhairem",
"7472", "Belgorod",
"772146", "Karkaralinsk",
"771135", "Zhanibek",
"771840", "Bayanaul",
"7346", "Surgut",
"771443", "Borovskoi",
"772843", "Lepsy",
"771539", "Beskol",
"771455", "Zatobolsk",
"7473", "Voronezh",
"7821", "Komi\ Republic",
"771449", "Taranovskoye",
"77152", "Petropavlovsk",
"771533", "Saumalkol",
"772772", "Kapchagai",
"7385", "Altai\ Territory",
"772530", "Temirlanovka",
"77272983", "Kaskelen",
"772132", "Nurinsky\ District",
"7487", "Tula",
"771144", "Kaztalovka",
"7485", "Yaroslavl",
"7343", "Ekaterinburg",
"771638", "Akkol",
"7302", "Chita",
"772938", "Fort\ Shevchenko",
"772643", "Shu",
"7391", "Krasnoyarsk\ Territory",
"771640", "Balkashino",
"772137", "Saran",
"7342", "Perm",
"77106", "Satpaev",
"772637", "Sarykemer",
"772545", "Ikan",
"771531", "Bulayevo",
"771235", "Dossor",
"772759", "Almaty\ Region",
"772149", "Osakarovka",
"7814", "Republic\ of\ Karelia",
"772346", "Aksuat",
"772841", "Kapal",
"771140", "Saikhin",
"772435", "Zhanakorgan",
"771441", "Karabalyk",
"733", "Baikonur",
"771446", "Uzunkolsky\ District",
"771458", "Kostanai\ Region",
"771644", "Arshaly",
"772341", "Ulken\ Naryn",
"771335", "Shalkar",
"7492", "Vladimir",
"771138", "Zhalpaktal",
"771041", "Aktau\,\ Zhezkazgan",
"7498", "Moscow",
"771536", "Taiynsha",
"772632", "Merke",
"7471", "Kursk",
"77149", "Kostanai",
"771032", "Karazhal",
"772332", "Shemonaikha",
"7301", "Republic\ of\ Buryatia",
"771437", "Kamysty",
"772837", "Kabanbai",
"771635", "Zhaksy",
"771547", "Zhambylsky\ District",
"772641", "Akkol",
"7341", "Udmurtian\ Republic",
"772237", "Ayagoz",
"77187", "Ekibastuz",
"7415", "Kamchatka\ Region",
"771844", "Irtyshsky\ District",
"772935", "Zhetybai",
"771542", "Kishkenekol",
"772832", "Zhansugurov",
"772534", "Zhetysai",
"772337", "Serebryansk",
"7496", "Moscow",
"771037", "Aktogai",};
my $timezones = {
               '' => [
                       'Asia/Almaty',
                       'Asia/Anadyr',
                       'Asia/Aqtobe',
                       'Asia/Irkutsk',
                       'Asia/Kamchatka',
                       'Asia/Krasnoyarsk',
                       'Asia/Magadan',
                       'Asia/Novosibirsk',
                       'Asia/Omsk',
                       'Asia/Sakhalin',
                       'Asia/Vladivostok',
                       'Asia/Yakutsk',
                       'Asia/Yekaterinburg',
                       'Europe/Bucharest',
                       'Europe/Moscow',
                       'Europe/Samara'
                     ],
               '301' => [
                          'Asia/Irkutsk'
                        ],
               '302' => [
                          'Asia/Yakutsk'
                        ],
               '33' => [
                         'Asia/Almaty'
                       ],
               '34' => [
                         'Asia/Yekaterinburg'
                       ],
               '341' => [
                          'Europe/Samara'
                        ],
               '35' => [
                         'Asia/Yekaterinburg'
                       ],
               '36' => [
                         'Europe/Moscow'
                       ],
               '381' => [
                          'Asia/Omsk'
                        ],
               '382' => [
                          'Asia/Novosibirsk'
                        ],
               '383' => [
                          'Asia/Novosibirsk'
                        ],
               '384' => [
                          'Asia/Krasnoyarsk'
                        ],
               '385' => [
                          'Asia/Krasnoyarsk'
                        ],
               '388' => [
                          'Asia/Krasnoyarsk'
                        ],
               '390' => [
                          'Asia/Krasnoyarsk'
                        ],
               '391' => [
                          'Asia/Krasnoyarsk'
                        ],
               '394' => [
                          'Asia/Krasnoyarsk'
                        ],
               '395' => [
                          'Asia/Irkutsk'
                        ],
               '40' => [
                         'Europe/Bucharest'
                       ],
               '411' => [
                          'Asia/Yakutsk'
                        ],
               '413' => [
                          'Asia/Magadan'
                        ],
               '415' => [
                          'Asia/Kamchatka'
                        ],
               '416' => [
                          'Asia/Yakutsk'
                        ],
               '421' => [
                          'Asia/Vladivostok'
                        ],
               '423' => [
                          'Asia/Vladivostok'
                        ],
               '424' => [
                          'Asia/Sakhalin'
                        ],
               '426' => [
                          'Asia/Vladivostok'
                        ],
               '427' => [
                          'Asia/Anadyr'
                        ],
               '47' => [
                         'Europe/Moscow'
                       ],
               '48' => [
                         'Europe/Moscow'
                       ],
               '49' => [
                         'Europe/Moscow'
                       ],
               '7' => [
                        'Asia/Almaty',
                        'Asia/Aqtobe'
                      ],
               '71' => [
                         'Asia/Almaty'
                       ],
               '711' => [
                          'Asia/Aqtobe'
                        ],
               '712' => [
                          'Asia/Aqtobe'
                        ],
               '713' => [
                          'Asia/Aqtobe'
                        ],
               '72' => [
                         'Asia/Almaty'
                       ],
               '729' => [
                          'Asia/Aqtobe'
                        ],
               '79' => [
                         'Asia/Almaty'
                       ],
               '800' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '803' => [
                          'Europe/Moscow'
                        ],
               '804' => [
                          'Europe/Moscow'
                        ],
               '808' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '809' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '81' => [
                         'Europe/Moscow'
                       ],
               '810' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '82' => [
                         'Europe/Moscow'
                       ],
               '83' => [
                         'Europe/Moscow'
                       ],
               '840' => [
                          'Europe/Bucharest',
                          'Europe/Moscow'
                        ],
               '841' => [
                          'Europe/Moscow'
                        ],
               '842' => [
                          'Europe/Samara'
                        ],
               '843' => [
                          'Europe/Moscow'
                        ],
               '844' => [
                          'Europe/Moscow'
                        ],
               '845' => [
                          'Europe/Moscow'
                        ],
               '846' => [
                          'Europe/Samara'
                        ],
               '847' => [
                          'Europe/Moscow'
                        ],
               '848' => [
                          'Europe/Samara'
                        ],
               '851' => [
                          'Europe/Samara'
                        ],
               '855' => [
                          'Europe/Moscow'
                        ],
               '86' => [
                         'Europe/Moscow'
                       ],
               '87' => [
                         'Europe/Moscow'
                       ],
               '9' => [
                        'Europe/Moscow'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;