% -----------------------------------------------------------------------------
% perlre.erl
% -----------------------------------------------------------------------------
% Mastering programmed by YAMASHINA Hio
%
% Copyright 2007 YAMASHINA Hio
% -----------------------------------------------------------------------------
% $Id
% -----------------------------------------------------------------------------
-module(perlre).
-export([match/2]).
-export([start/0, start/1, stop/0]).
-import(perlport, [call/2]).

% -----------------------------------------------------------------------------
% match(String, Regexp).
%
match(String, Regexp) ->
	start(),
	call([match, String, Regexp], perlre).

% -----------------------------------------------------------------------------
% start().
% start(Script).
%
start() ->
	start("perlre.pl").
start(Script) ->
  perlport:start(Script, perlre).

% -----------------------------------------------------------------------------
% stop().
%
stop() ->
	perlport:stop(perlre).

% -----------------------------------------------------------------------------
% End of Module.
% -----------------------------------------------------------------------------
