/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.dcoref.CorefChain;
import edu.stanford.nlp.dcoref.CorefCoreAnnotations;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CustomAnnotationSerializer
implements AnnotationSerializer {
    private final boolean compress;
    private final boolean haveExplicitAntecedent;
    private static final Object LOCK = new Object();
    private static final String SPACE_HOLDER = "##";

    public CustomAnnotationSerializer() {
        this(true, false);
    }

    public CustomAnnotationSerializer(boolean compress, boolean haveAnte) {
        this.compress = compress;
        this.haveExplicitAntecedent = haveAnte;
    }

    @Override
    public Annotation load(InputStream is) throws IOException, ClassNotFoundException, ClassCastException {
        String line;
        is = new BufferedInputStream(is);
        if (this.compress) {
            is = new GZIPInputStream(is);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        Annotation doc = new Annotation("");
        Map<Integer, CorefChain> chains = CustomAnnotationSerializer.loadCorefChains(reader);
        if (chains != null) {
            doc.set(CorefCoreAnnotations.CorefChainAnnotation.class, chains);
        }
        if ((line = reader.readLine().trim()).length() > 0) {
            String[] bits = line.split(" ");
            if (bits.length % 4 != 0) {
                throw new RuntimeIOException("ERROR: Incorrect format for the serialized coref graph: " + line);
            }
            ArrayList<Pair<IntTuple, IntTuple>> corefGraph = new ArrayList<Pair<IntTuple, IntTuple>>();
            for (int i = 0; i < bits.length; i += 4) {
                IntTuple src = new IntTuple(2);
                IntTuple dst = new IntTuple(2);
                src.set(0, Integer.parseInt(bits[i]));
                src.set(1, Integer.parseInt(bits[i + 1]));
                dst.set(0, Integer.parseInt(bits[i + 2]));
                dst.set(1, Integer.parseInt(bits[i + 3]));
                corefGraph.add(new Pair<IntTuple, IntTuple>(src, dst));
            }
            doc.set(CorefCoreAnnotations.CorefGraphAnnotation.class, corefGraph);
        }
        ArrayList<Annotation> sentences = new ArrayList<Annotation>();
        while ((line = reader.readLine()) != null) {
            Annotation sentence = new Annotation("");
            Tree tree = new PennTreeReader(new StringReader(line), new LabeledScoredTreeFactory(CoreLabel.factory())).readTree();
            sentence.set(TreeCoreAnnotations.TreeAnnotation.class, tree);
            IntermediateSemanticGraph intermCollapsedDeps = CustomAnnotationSerializer.loadDependencyGraph(reader);
            IntermediateSemanticGraph intermUncollapsedDeps = CustomAnnotationSerializer.loadDependencyGraph(reader);
            IntermediateSemanticGraph intermCcDeps = CustomAnnotationSerializer.loadDependencyGraph(reader);
            ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>();
            while ((line = reader.readLine()) != null && line.length() != 0) {
                CoreLabel token = CustomAnnotationSerializer.loadToken(line, this.haveExplicitAntecedent);
                tokens.add(token);
            }
            sentence.set(CoreAnnotations.TokensAnnotation.class, tokens);
            SemanticGraph collapsedDeps = CustomAnnotationSerializer.convertIntermediateGraph(intermCollapsedDeps, tokens);
            sentence.set(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, collapsedDeps);
            SemanticGraph uncollapsedDeps = CustomAnnotationSerializer.convertIntermediateGraph(intermUncollapsedDeps, tokens);
            sentence.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, uncollapsedDeps);
            SemanticGraph ccDeps = CustomAnnotationSerializer.convertIntermediateGraph(intermCcDeps, tokens);
            sentence.set(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, ccDeps);
            sentences.add(sentence);
        }
        doc.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        reader.close();
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SemanticGraph convertIntermediateGraph(IntermediateSemanticGraph ig, List<CoreLabel> sentence) {
        SemanticGraph graph = new SemanticGraph();
        HashMap<Integer, IndexedWord> nodes = new HashMap<Integer, IndexedWord>();
        for (IntermediateNode in : ig.nodes) {
            CoreLabel token = sentence.get(in.index - 1);
            IndexedWord word = new IndexedWord(in.docId, in.sentIndex, in.index, token);
            word.set(CoreAnnotations.ValueAnnotation.class, word.get(CoreAnnotations.TextAnnotation.class));
            if (in.copyAnnotation >= 0) {
                word.set(CoreAnnotations.CopyAnnotation.class, in.copyAnnotation);
            }
            nodes.put(word.index(), word);
        }
        for (IndexedWord node : nodes.values()) {
            graph.addVertex(node);
        }
        for (IntermediateEdge ie : ig.edges) {
            IndexedWord source = (IndexedWord)nodes.get(ie.source);
            assert (source != null);
            IndexedWord target = (IndexedWord)nodes.get(ie.target);
            assert (target != null);
            Object object = LOCK;
            synchronized (object) {
                GrammaticalRelation rel = GrammaticalRelation.valueOf(ie.dep);
                graph.addEdge(source, target, rel, 1.0);
            }
        }
        if (!graph.isEmpty()) {
            graph.resetRoots();
        }
        return graph;
    }

    private static IntermediateSemanticGraph loadDependencyGraph(BufferedReader reader) throws IOException {
        String[] bbits;
        String[] bits;
        IntermediateSemanticGraph graph = new IntermediateSemanticGraph();
        String line = reader.readLine().trim();
        if (line.length() > 0) {
            bits = line.split("\t");
            if (bits.length < 3) {
                throw new RuntimeException("ERROR: Invalid dependency node line: " + line);
            }
            String docId = bits[0];
            if (docId.equals("-")) {
                docId = "";
            }
            int sentIndex = Integer.valueOf(bits[1]);
            for (int i = 2; i < bits.length; ++i) {
                String bit = bits[i];
                bbits = bit.split("-");
                int copyAnnotation = -1;
                if (bbits.length > 2) {
                    throw new RuntimeException("ERROR: Invalid format for dependency graph: " + line);
                }
                if (bbits.length == 2) {
                    copyAnnotation = Integer.valueOf(bbits[1]);
                }
                int index = Integer.valueOf(bbits[0]);
                graph.nodes.add(new IntermediateNode(docId, sentIndex, index, copyAnnotation));
            }
        }
        if ((line = reader.readLine().trim()).length() > 0) {
            for (String bit : bits = line.split("\t")) {
                bbits = bit.split(" ");
                if (bbits.length != 3) {
                    throw new RuntimeException("ERROR: Invalid format for dependency graph: " + line);
                }
                String dep = bbits[0];
                int source = Integer.valueOf(bbits[1]);
                int target = Integer.valueOf(bbits[2]);
                graph.edges.add(new IntermediateEdge(dep, source, target));
            }
        }
        return graph;
    }

    private static void saveDependencyGraph(SemanticGraph graph, PrintWriter pw) {
        if (graph == null) {
            pw.println();
            pw.println();
            return;
        }
        boolean outputHeader = false;
        for (IndexedWord node : graph.vertexSet()) {
            if (!outputHeader) {
                String docId = (String)node.get(CoreAnnotations.DocIDAnnotation.class);
                if (docId != null && docId.length() > 0) {
                    pw.print(docId);
                } else {
                    pw.print("-");
                }
                pw.print("\t");
                pw.print(node.get(CoreAnnotations.SentenceIndexAnnotation.class));
                outputHeader = true;
            }
            pw.print("\t");
            pw.print(node.index());
            if (!node.containsKey(CoreAnnotations.CopyAnnotation.class)) continue;
            pw.print("-");
            pw.print(node.get(CoreAnnotations.CopyAnnotation.class));
        }
        pw.println();
        boolean first = true;
        for (SemanticGraphEdge edge : graph.edgeIterable()) {
            if (!first) {
                pw.print("\t");
            }
            String rel = edge.getRelation().toString();
            rel = rel.replaceAll("\\s+", "");
            pw.print(rel);
            pw.print(" ");
            pw.print(edge.getSource().index());
            pw.print(" ");
            pw.print(edge.getTarget().index());
            first = false;
        }
        pw.println();
    }

    private static void saveCorefChains(Map<Integer, CorefChain> chains, PrintWriter pw) {
        if (chains == null) {
            pw.println();
            return;
        }
        pw.println(chains.size());
        for (Integer cid : chains.keySet()) {
            CorefChain cluster = chains.get(cid);
            CustomAnnotationSerializer.saveCorefChain(pw, cid, cluster);
        }
        pw.println();
    }

    private static int countMentions(CorefChain cluster) {
        int count = 0;
        for (IntPair mid : cluster.getMentionMap().keySet()) {
            count += cluster.getMentionMap().get(mid).size();
        }
        return count;
    }

    public static void saveCorefChain(PrintWriter pw, int cid, CorefChain cluster) {
        pw.println(cid + " " + CustomAnnotationSerializer.countMentions(cluster));
        Map<IntPair, Set<CorefChain.CorefMention>> mentionMap = cluster.getMentionMap();
        for (IntPair mid : mentionMap.keySet()) {
            Set<CorefChain.CorefMention> mentions = mentionMap.get(mid);
            for (CorefChain.CorefMention mention : mentions) {
                pw.print(mid.getSource() + " " + mid.getTarget());
                if (mention == cluster.getRepresentativeMention()) {
                    pw.print(" 1");
                } else {
                    pw.print(" 0");
                }
                pw.print(" " + (Object)((Object)mention.mentionType));
                pw.print(" " + (Object)((Object)mention.number));
                pw.print(" " + (Object)((Object)mention.gender));
                pw.print(" " + (Object)((Object)mention.animacy));
                pw.print(" " + mention.startIndex);
                pw.print(" " + mention.endIndex);
                pw.print(" " + mention.headIndex);
                pw.print(" " + mention.corefClusterID);
                pw.print(" " + mention.mentionID);
                pw.print(" " + mention.sentNum);
                pw.print(" " + mention.position.length());
                for (int i = 0; i < mention.position.length(); ++i) {
                    pw.print(" " + mention.position.get(i));
                }
                pw.print(" " + CustomAnnotationSerializer.escapeSpace(mention.mentionSpan));
                pw.println();
            }
        }
    }

    private static String escapeSpace(String s) {
        return s.replaceAll("\\s", SPACE_HOLDER);
    }

    private static String unescapeSpace(String s) {
        return s.replaceAll(SPACE_HOLDER, " ");
    }

    private static Dictionaries.MentionType parseMentionType(String s) {
        if (s.equals("PRONOMINAL")) {
            return Dictionaries.MentionType.PRONOMINAL;
        }
        if (s.equals("NOMINAL")) {
            return Dictionaries.MentionType.NOMINAL;
        }
        if (s.equals("PROPER")) {
            return Dictionaries.MentionType.PROPER;
        }
        throw new RuntimeException("Unknown value: " + s);
    }

    private static Dictionaries.Number parseNumber(String s) {
        if (s.equals("SINGULAR")) {
            return Dictionaries.Number.SINGULAR;
        }
        if (s.equals("PLURAL")) {
            return Dictionaries.Number.PLURAL;
        }
        if (s.equals("UNKNOWN")) {
            return Dictionaries.Number.UNKNOWN;
        }
        throw new RuntimeException("Unknown value: " + s);
    }

    private static Dictionaries.Gender parseGender(String s) {
        if (s.equals("MALE")) {
            return Dictionaries.Gender.MALE;
        }
        if (s.equals("FEMALE")) {
            return Dictionaries.Gender.FEMALE;
        }
        if (s.equals("NEUTRAL")) {
            return Dictionaries.Gender.NEUTRAL;
        }
        if (s.equals("UNKNOWN")) {
            return Dictionaries.Gender.UNKNOWN;
        }
        throw new RuntimeException("Unknown value: " + s);
    }

    private static Dictionaries.Animacy parseAnimacy(String s) {
        if (s.equals("ANIMATE")) {
            return Dictionaries.Animacy.ANIMATE;
        }
        if (s.equals("INANIMATE")) {
            return Dictionaries.Animacy.INANIMATE;
        }
        if (s.equals("UNKNOWN")) {
            return Dictionaries.Animacy.UNKNOWN;
        }
        throw new RuntimeException("Unknown value: " + s);
    }

    private static Map<Integer, CorefChain> loadCorefChains(BufferedReader reader) throws IOException {
        String line = reader.readLine().trim();
        if (line.length() == 0) {
            return null;
        }
        int clusterCount = Integer.valueOf(line);
        HashMap<Integer, CorefChain> chains = new HashMap<Integer, CorefChain>();
        for (int c = 0; c < clusterCount; ++c) {
            line = reader.readLine().trim();
            String[] bits = line.split("\\s");
            int cid = Integer.valueOf(bits[0]);
            int mentionCount = Integer.valueOf(bits[1]);
            HashMap<IntPair, Set<CorefChain.CorefMention>> mentionMap = new HashMap<IntPair, Set<CorefChain.CorefMention>>();
            CorefChain.CorefMention representative = null;
            for (int m = 0; m < mentionCount; ++m) {
                line = reader.readLine();
                bits = line.split("\\s");
                IntPair key = new IntPair(Integer.valueOf(bits[0]), Integer.valueOf(bits[1]));
                boolean rep = bits[2].equals("1");
                Dictionaries.MentionType mentionType = CustomAnnotationSerializer.parseMentionType(bits[3]);
                Dictionaries.Number number = CustomAnnotationSerializer.parseNumber(bits[4]);
                Dictionaries.Gender gender = CustomAnnotationSerializer.parseGender(bits[5]);
                Dictionaries.Animacy animacy = CustomAnnotationSerializer.parseAnimacy(bits[6]);
                int startIndex = Integer.valueOf(bits[7]);
                int endIndex = Integer.valueOf(bits[8]);
                int headIndex = Integer.valueOf(bits[9]);
                int clusterID = Integer.valueOf(bits[10]);
                int mentionID = Integer.valueOf(bits[11]);
                int sentNum = Integer.valueOf(bits[12]);
                int posLen = Integer.valueOf(bits[13]);
                int[] posElems = new int[posLen];
                for (int i = 0; i < posLen; ++i) {
                    posElems[i] = Integer.valueOf(bits[14 + i]);
                }
                IntTuple position = new IntTuple(posElems);
                String span = CustomAnnotationSerializer.unescapeSpace(bits[14 + posLen]);
                CorefChain.CorefMention mention = new CorefChain.CorefMention(mentionType, number, gender, animacy, startIndex, endIndex, headIndex, clusterID, mentionID, sentNum, position, span);
                HashSet<CorefChain.CorefMention> mentionsWithThisHead = (HashSet<CorefChain.CorefMention>)mentionMap.get(key);
                if (mentionsWithThisHead == null) {
                    mentionsWithThisHead = new HashSet<CorefChain.CorefMention>();
                    mentionMap.put(key, mentionsWithThisHead);
                }
                mentionsWithThisHead.add(mention);
                if (!rep) continue;
                representative = mention;
            }
            CorefChain chain = new CorefChain(cid, mentionMap, representative);
            chains.put(cid, chain);
        }
        reader.readLine();
        return chains;
    }

    @Override
    public void save(Annotation corpus, OutputStream os) throws IOException {
        os = new BufferedOutputStream(os);
        if (this.compress) {
            os = new GZIPOutputStream(os);
        }
        PrintWriter pw = new PrintWriter(os);
        Map chains = (Map)corpus.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        CustomAnnotationSerializer.saveCorefChains(chains, pw);
        List corefGraph = (List)corpus.get(CorefCoreAnnotations.CorefGraphAnnotation.class);
        if (corefGraph != null) {
            boolean first = true;
            for (Pair arc : corefGraph) {
                if (!first) {
                    pw.print(" ");
                }
                pw.printf("%d %d %d %d", ((IntTuple)arc.first).get(0), ((IntTuple)arc.first).get(1), ((IntTuple)arc.second).get(0), ((IntTuple)arc.second).get(1));
                first = false;
            }
        }
        pw.println();
        List sentences = (List)corpus.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap sent : sentences) {
            Tree tree = (Tree)sent.get(TreeCoreAnnotations.TreeAnnotation.class);
            if (tree != null) {
                String treeString = tree.toString();
                treeString = treeString.replaceAll("\n", " ");
                pw.println(treeString);
            } else {
                pw.println();
            }
            SemanticGraph collapsedDeps = (SemanticGraph)sent.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class);
            CustomAnnotationSerializer.saveDependencyGraph(collapsedDeps, pw);
            SemanticGraph uncollapsedDeps = (SemanticGraph)sent.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
            CustomAnnotationSerializer.saveDependencyGraph(uncollapsedDeps, pw);
            SemanticGraph ccDeps = (SemanticGraph)sent.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class);
            CustomAnnotationSerializer.saveDependencyGraph(ccDeps, pw);
            List tokens = (List)sent.get(CoreAnnotations.TokensAnnotation.class);
            if (tokens != null) {
                for (CoreLabel token : tokens) {
                    CustomAnnotationSerializer.saveToken(token, this.haveExplicitAntecedent, pw);
                    pw.println();
                }
            }
            pw.println();
        }
        pw.close();
    }

    private static CoreLabel loadToken(String line, boolean haveExplicitAntecedent) {
        String aa;
        CoreLabel token = new CoreLabel();
        String[] bits = line.split("\t", -1);
        if (bits.length < 7) {
            throw new RuntimeIOException("ERROR: Invalid format token for serialized token (only " + bits.length + " tokens): " + line);
        }
        String word = bits[0].replaceAll(SPACE_HOLDER, " ");
        token.set(CoreAnnotations.TextAnnotation.class, word);
        if (bits[1].length() > 0 || bits[0].length() == 0) {
            String lemma = bits[1].replaceAll(SPACE_HOLDER, " ");
            token.set(CoreAnnotations.LemmaAnnotation.class, lemma);
        }
        if (bits[2].length() > 0) {
            token.set(CoreAnnotations.PartOfSpeechAnnotation.class, bits[2]);
        }
        if (bits[3].length() > 0) {
            token.set(CoreAnnotations.NamedEntityTagAnnotation.class, bits[3]);
        }
        if (bits[4].length() > 0) {
            token.set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, bits[4]);
        }
        if (bits[5].length() > 0) {
            token.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, Integer.parseInt(bits[5]));
        }
        if (bits[6].length() > 0) {
            token.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, Integer.parseInt(bits[6]));
        }
        if (haveExplicitAntecedent && bits.length > 7 && (aa = bits[7].replaceAll(SPACE_HOLDER, " ")).length() > 0) {
            token.set(CoreAnnotations.AntecedentAnnotation.class, aa);
        }
        return token;
    }

    private static void saveToken(CoreLabel token, boolean haveExplicitAntecedent, PrintWriter pw) {
        String aa;
        String word = (String)token.get(CoreAnnotations.TextAnnotation.class);
        if (word != null) {
            word = word.replaceAll("\\s+", SPACE_HOLDER);
            pw.print(word);
        }
        pw.print("\t");
        String lemma = (String)token.get(CoreAnnotations.LemmaAnnotation.class);
        if (lemma != null) {
            lemma = lemma.replaceAll("\\s+", SPACE_HOLDER);
            pw.print(lemma);
        }
        pw.print("\t");
        String pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
        if (pos != null) {
            pw.print(pos);
        }
        pw.print("\t");
        String ner = (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class);
        if (ner != null) {
            pw.print(ner);
        }
        pw.print("\t");
        String normNer = (String)token.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
        if (normNer != null) {
            pw.print(normNer);
        }
        pw.print("\t");
        Integer charBegin = (Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        if (charBegin != null) {
            pw.print(charBegin);
        }
        pw.print("\t");
        Integer charEnd = (Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        if (charEnd != null) {
            pw.print(charEnd);
        }
        if (haveExplicitAntecedent && (aa = (String)token.get(CoreAnnotations.AntecedentAnnotation.class)) != null) {
            pw.print("\t");
            aa = aa.replaceAll("\\s+", SPACE_HOLDER);
            pw.print(aa);
        }
    }

    public static void main(String[] args) throws Exception {
        Properties props = StringUtils.argsToProperties(args);
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        String file = props.getProperty("file");
        String loadFile = props.getProperty("loadFile");
        if (loadFile != null && !loadFile.equals("")) {
            CustomAnnotationSerializer ser = new CustomAnnotationSerializer(false, false);
            FileInputStream is = new FileInputStream(loadFile);
            Annotation anno = ser.load(is);
            System.out.println(anno.toShorterString(new String[0]));
            ((InputStream)is).close();
        } else if (file != null && !file.equals("")) {
            String text = IOUtils.slurpFile(file);
            Annotation doc = new Annotation(text);
            pipeline.annotate(doc);
            CustomAnnotationSerializer ser = new CustomAnnotationSerializer(false, false);
            PrintStream os = new PrintStream(new FileOutputStream(file + ".ser"));
            ser.save(doc, os);
            os.close();
            System.err.println("Serialized annotation saved in " + file + ".ser");
        } else {
            System.err.println("usage: CustomAnnotationSerializer [-file file] [-loadFile file]");
        }
    }

    private static class IntermediateEdge {
        int source;
        int target;
        String dep;

        IntermediateEdge(String dep, int source, int target) {
            this.dep = dep;
            this.source = source;
            this.target = target;
        }
    }

    private static class IntermediateNode {
        String docId;
        int sentIndex;
        int index;
        int copyAnnotation;

        IntermediateNode(String docId, int sentIndex, int index, int copy) {
            this.docId = docId;
            this.sentIndex = sentIndex;
            this.index = index;
            this.copyAnnotation = copy;
        }
    }

    private static class IntermediateSemanticGraph {
        List<IntermediateNode> nodes = new ArrayList<IntermediateNode>();
        List<IntermediateEdge> edges = new ArrayList<IntermediateEdge>();

        IntermediateSemanticGraph() {
        }
    }
}

