/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CRFCliqueTree;
import edu.stanford.nlp.ie.crf.CRFLabel;
import edu.stanford.nlp.ie.crf.NonLinearCliquePotentialFunction;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.optimization.AbstractCachingDiffFunction;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Triple;
import java.util.Arrays;
import java.util.Random;

public class CRFNonLinearLogConditionalObjectiveFunction
extends AbstractCachingDiffFunction {
    public static final int NO_PRIOR = 0;
    public static final int QUADRATIC_PRIOR = 1;
    public static final int HUBER_PRIOR = 2;
    public static final int QUARTIC_PRIOR = 3;
    Index<Integer> nodeFeatureIndicesMap;
    Index<Integer> edgeFeatureIndicesMap;
    boolean useOutputLayer;
    boolean useHiddenLayer;
    boolean useSigmoid;
    SeqClassifierFlags flags;
    int count = 0;
    protected int prior;
    protected double sigma;
    protected double epsilon;
    Random random = new Random(Integer.MAX_VALUE);
    Index<CRFLabel>[] labelIndices;
    Index<String> classIndex;
    double[][] Ehat;
    double[][] Uhat;
    double[][] What;
    int window;
    int numClasses;
    int numHiddenUnits;
    int[] map;
    int[][][][] data;
    int[][] docWindowLabels;
    int[][] labels;
    int domainDimension = -1;
    int inputLayerSize = -1;
    int outputLayerSize = -1;
    int edgeParamCount = -1;
    int numNodeFeatures = -1;
    int numEdgeFeatures = -1;
    int beforeOutputWeights = -1;
    int originalFeatureCount = -1;
    int[][] weightIndices;
    String backgroundSymbol;
    public static boolean VERBOSE = false;

    public static int getPriorType(String priorTypeStr) {
        if (priorTypeStr == null) {
            return 1;
        }
        if ("QUADRATIC".equalsIgnoreCase(priorTypeStr)) {
            return 1;
        }
        if ("HUBER".equalsIgnoreCase(priorTypeStr)) {
            return 2;
        }
        if ("QUARTIC".equalsIgnoreCase(priorTypeStr)) {
            return 3;
        }
        if ("NONE".equalsIgnoreCase(priorTypeStr)) {
            return 0;
        }
        throw new IllegalArgumentException("Unknown prior type: " + priorTypeStr);
    }

    CRFNonLinearLogConditionalObjectiveFunction(int[][][][] data, int[][] labels, int window, Index classIndex, Index[] labelIndices, int[] map, SeqClassifierFlags flags, Index<Integer> nodeFeatureIndicesMap, Index<Integer> edgeFeatureIndicesMap) {
        this(data, labels, window, classIndex, labelIndices, map, 1, flags, nodeFeatureIndicesMap, edgeFeatureIndicesMap);
    }

    CRFNonLinearLogConditionalObjectiveFunction(int[][][][] data, int[][] labels, int window, Index<String> classIndex, Index[] labelIndices, int[] map, int prior, SeqClassifierFlags flags, Index<Integer> nodeFeatureIndicesMap, Index<Integer> edgeFeatureIndicesMap) {
        this.window = window;
        this.classIndex = classIndex;
        this.numClasses = classIndex.size();
        this.labelIndices = labelIndices;
        this.data = data;
        this.flags = flags;
        this.map = map;
        this.labels = labels;
        this.prior = prior;
        this.backgroundSymbol = flags.backgroundSymbol;
        this.sigma = flags.sigma;
        this.nodeFeatureIndicesMap = nodeFeatureIndicesMap;
        this.edgeFeatureIndicesMap = edgeFeatureIndicesMap;
        this.outputLayerSize = this.numClasses;
        this.numHiddenUnits = flags.numHiddenUnits;
        this.inputLayerSize = this.numHiddenUnits * this.numClasses;
        this.numNodeFeatures = nodeFeatureIndicesMap.size();
        this.numEdgeFeatures = edgeFeatureIndicesMap.size();
        this.useOutputLayer = flags.useOutputLayer;
        this.useHiddenLayer = flags.useHiddenLayer;
        this.useSigmoid = flags.useSigmoid;
        this.docWindowLabels = new int[data.length][];
        if (!this.useOutputLayer) {
            System.err.println("Output layer not activated, inputLayerSize must be equal to numClasses, setting it to " + this.numClasses);
            this.inputLayerSize = this.numClasses;
        } else if (flags.softmaxOutputLayer && !flags.sparseOutputLayer && !flags.tieOutputLayer) {
            throw new RuntimeException("flags.softmaxOutputLayer == true, but neither flags.sparseOutputLayer or flags.tieOutputLayer is true");
        }
        this.empiricalCounts();
    }

    @Override
    public int domainDimension() {
        if (this.domainDimension < 0) {
            this.domainDimension = 0;
            this.edgeParamCount = this.numEdgeFeatures * this.labelIndices[1].size();
            this.originalFeatureCount = 0;
            for (int i = 0; i < this.map.length; ++i) {
                int s = this.labelIndices[this.map[i]].size();
                this.originalFeatureCount += s;
            }
            this.domainDimension += this.edgeParamCount;
            this.domainDimension += this.inputLayerSize * this.numNodeFeatures;
            this.beforeOutputWeights = this.domainDimension;
            if (this.useOutputLayer) {
                this.domainDimension = this.flags.sparseOutputLayer ? (this.domainDimension += this.outputLayerSize * this.numHiddenUnits) : (this.flags.tieOutputLayer ? (this.domainDimension += 1 * this.numHiddenUnits) : (this.domainDimension += this.outputLayerSize * this.inputLayerSize));
            }
            System.err.println("edgeParamCount: " + this.edgeParamCount);
            System.err.println("originalFeatureCount: " + this.originalFeatureCount);
            System.err.println("beforeOutputWeights: " + this.beforeOutputWeights);
            System.err.println("domainDimension: " + this.domainDimension);
        }
        return this.domainDimension;
    }

    @Override
    public double[] initial() {
        double[] initial = new double[this.domainDimension()];
        if (this.useHiddenLayer || this.useOutputLayer) {
            int j;
            int i;
            double epsilon = 0.1;
            double twoEpsilon = epsilon * 2.0;
            int count = 0;
            double val = 0.0;
            if (this.flags.blockInitialize) {
                for (i = 0; i < this.edgeParamCount; ++i) {
                    val = this.random.nextDouble() * twoEpsilon - epsilon;
                    initial[count++] = val;
                }
                int interval = this.numNodeFeatures / this.numHiddenUnits;
                for (int i2 = 0; i2 < this.numHiddenUnits; ++i2) {
                    int lower = i2 * interval;
                    int upper = (i2 + 1) * interval;
                    if (i2 == this.numHiddenUnits - 1) {
                        upper = this.numNodeFeatures;
                    }
                    for (j = 0; j < this.outputLayerSize; ++j) {
                        for (int k = 0; k < this.numNodeFeatures; ++k) {
                            val = 0.0;
                            if (k >= lower && k < upper) {
                                val = this.random.nextDouble() * twoEpsilon - epsilon;
                            }
                            initial[count++] = val;
                        }
                    }
                }
                if (count != this.beforeOutputWeights) {
                    throw new RuntimeException("after blockInitialize, param Index (" + count + ") not equal to beforeOutputWeights (" + this.beforeOutputWeights + ")");
                }
            } else {
                for (i = 0; i < this.beforeOutputWeights; ++i) {
                    val = this.random.nextDouble() * twoEpsilon - epsilon;
                    initial[count++] = val;
                }
            }
            if (this.flags.sparseOutputLayer) {
                for (i = 0; i < this.outputLayerSize; ++i) {
                    double total = 1.0;
                    for (int j2 = 0; j2 < this.numHiddenUnits - 1; ++j2) {
                        val = this.random.nextDouble() * total;
                        initial[count++] = val;
                        total -= val;
                    }
                    initial[count++] = total;
                }
            } else if (this.flags.tieOutputLayer) {
                double total = 1.0;
                double sum = 0.0;
                for (j = 0; j < this.numHiddenUnits - 1; ++j) {
                    val = this.random.nextDouble() * total;
                    initial[count++] = val;
                    total -= val;
                }
                initial[count++] = total;
            } else {
                for (i = this.beforeOutputWeights; i < this.domainDimension(); ++i) {
                    val = this.random.nextDouble() * twoEpsilon - epsilon;
                    initial[count++] = val;
                }
            }
            if (count != this.domainDimension()) {
                throw new RuntimeException("after param initialization, param Index (" + count + ") not equal to domainDimension (" + this.domainDimension() + ")");
            }
        }
        return initial;
    }

    private void empiricalCounts() {
        this.Ehat = this.empty2D();
        for (int m = 0; m < this.data.length; ++m) {
            int[][][] docData = this.data[m];
            int[] docLabels = this.labels[m];
            int[] windowLabels = new int[this.window];
            Arrays.fill(windowLabels, this.classIndex.indexOf(this.backgroundSymbol));
            if (docLabels.length > docData.length) {
                System.arraycopy(docLabels, 0, windowLabels, 0, windowLabels.length);
                int[] newDocLabels = new int[docData.length];
                System.arraycopy(docLabels, docLabels.length - newDocLabels.length, newDocLabels, 0, newDocLabels.length);
                docLabels = newDocLabels;
            }
            for (int i = 0; i < docData.length; ++i) {
                System.arraycopy(windowLabels, 1, windowLabels, 0, this.window - 1);
                windowLabels[this.window - 1] = docLabels[i];
                int j = 1;
                int[] cliqueLabel = new int[j + 1];
                System.arraycopy(windowLabels, this.window - 1 - j, cliqueLabel, 0, j + 1);
                CRFLabel crfLabel = new CRFLabel(cliqueLabel);
                int labelIndex = this.labelIndices[j].indexOf(crfLabel);
                int[] cliqueFeatures = docData[i][j];
                for (int n = 0; n < cliqueFeatures.length; ++n) {
                    double[] dArray = this.Ehat[cliqueFeatures[n]];
                    int n2 = labelIndex;
                    dArray[n2] = dArray[n2] + 1.0;
                }
            }
        }
    }

    private double[][] emptyU() {
        int innerSize = this.inputLayerSize;
        if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
            innerSize = this.numHiddenUnits;
        }
        int outerSize = this.outputLayerSize;
        if (this.flags.tieOutputLayer) {
            outerSize = 1;
        }
        double[][] temp = new double[outerSize][innerSize];
        for (int i = 0; i < outerSize; ++i) {
            temp[i] = new double[innerSize];
        }
        return temp;
    }

    private double[][] emptyW() {
        double[][] temp = new double[this.inputLayerSize][this.numNodeFeatures];
        for (int i = 0; i < this.inputLayerSize; ++i) {
            temp[i] = new double[this.numNodeFeatures];
        }
        return temp;
    }

    public Triple<double[][], double[][], double[][]> separateWeights(double[] x) {
        double[] linearWeights = new double[this.edgeParamCount];
        System.arraycopy(x, 0, linearWeights, 0, this.edgeParamCount);
        double[][] linearWeights2D = this.to2D(linearWeights);
        int index = this.edgeParamCount;
        double[][] inputLayerWeights = this.emptyW();
        for (int i = 0; i < inputLayerWeights.length; ++i) {
            for (int j = 0; j < inputLayerWeights[i].length; ++j) {
                inputLayerWeights[i][j] = x[index++];
            }
        }
        double[][] outputLayerWeights = this.emptyU();
        for (int i = 0; i < outputLayerWeights.length; ++i) {
            for (int j = 0; j < outputLayerWeights[i].length; ++j) {
                outputLayerWeights[i][j] = this.useOutputLayer ? x[index++] : 1.0;
            }
        }
        assert (index == x.length);
        return new Triple<double[][], double[][], double[][]>(linearWeights2D, inputLayerWeights, outputLayerWeights);
    }

    @Override
    public void calculate(double[] x) {
        block70: {
            int regSize;
            block71: {
                block69: {
                    int i;
                    double prob = 0.0;
                    Triple<double[][], double[][], double[][]> allParams = this.separateWeights(x);
                    double[][] linearWeights = allParams.first();
                    double[][] W = allParams.second();
                    double[][] U = allParams.third();
                    Object Y = null;
                    if (this.flags.softmaxOutputLayer) {
                        Y = new double[U.length][];
                        for (int i2 = 0; i2 < U.length; ++i2) {
                            Y[i2] = ArrayMath.softmax(U[i2]);
                        }
                    }
                    double[][] What = this.emptyW();
                    double[][] Uhat = this.emptyU();
                    double[][] E = this.empty2D();
                    double[][] eW = this.emptyW();
                    double[][] eU = this.emptyU();
                    for (int m = 0; m < this.data.length; ++m) {
                        int i3;
                        int[][][] docData = this.data[m];
                        int[] docLabels = this.labels[m];
                        CRFCliqueTree<String> cliqueTree = CRFCliqueTree.getCalibratedCliqueTree(docData, this.labelIndices, this.numClasses, this.classIndex, this.backgroundSymbol, new NonLinearCliquePotentialFunction(linearWeights, W, U, this.flags));
                        int[] given = new int[this.window - 1];
                        Arrays.fill(given, this.classIndex.indexOf(this.backgroundSymbol));
                        int[] windowLabels = new int[this.window];
                        Arrays.fill(windowLabels, this.classIndex.indexOf(this.backgroundSymbol));
                        if (docLabels.length > docData.length) {
                            System.arraycopy(docLabels, 0, given, 0, given.length);
                            System.arraycopy(docLabels, 0, windowLabels, 0, windowLabels.length);
                            int[] newDocLabels = new int[docData.length];
                            System.arraycopy(docLabels, docLabels.length - newDocLabels.length, newDocLabels, 0, newDocLabels.length);
                            docLabels = newDocLabels;
                        }
                        for (i3 = 0; i3 < docData.length; ++i3) {
                            int label = docLabels[i3];
                            double p = cliqueTree.condLogProbGivenPrevious(i3, label, given);
                            if (VERBOSE) {
                                System.err.println("P(" + label + "|" + ArrayMath.toString(given) + ")=" + p);
                            }
                            prob += p;
                            System.arraycopy(given, 1, given, 0, given.length - 1);
                            given[given.length - 1] = label;
                        }
                        for (i3 = 0; i3 < docData.length; ++i3) {
                            System.arraycopy(windowLabels, 1, windowLabels, 0, this.window - 1);
                            windowLabels[this.window - 1] = docLabels[i3];
                            for (int j = 0; j < docData[i3].length; ++j) {
                                Index<CRFLabel> labelIndex = this.labelIndices[j];
                                int[] cliqueFeatures = docData[i3][j];
                                double[] As = null;
                                double[] fDeriv = null;
                                double[][] yTimesA = null;
                                double[] sumOfYTimesA = null;
                                if (j == 0) {
                                    As = NonLinearCliquePotentialFunction.hiddenLayerOutput(W, cliqueFeatures, this.flags);
                                    fDeriv = new double[this.inputLayerSize];
                                    double fD = 0.0;
                                    for (int q = 0; q < this.inputLayerSize; ++q) {
                                        fD = this.useSigmoid ? As[q] * (1.0 - As[q]) : 1.0 - As[q] * As[q];
                                        fDeriv[q] = fD;
                                    }
                                    if (this.flags.softmaxOutputLayer) {
                                        double val = 0.0;
                                        yTimesA = new double[this.outputLayerSize][this.numHiddenUnits];
                                        for (int ii = 0; ii < this.outputLayerSize; ++ii) {
                                            yTimesA[ii] = new double[this.numHiddenUnits];
                                        }
                                        sumOfYTimesA = new double[this.outputLayerSize];
                                        for (int k = 0; k < this.outputLayerSize; ++k) {
                                            double[] Yk = null;
                                            Yk = this.flags.tieOutputLayer ? Y[0] : Y[k];
                                            double sum = 0.0;
                                            for (int q = 0; q < this.inputLayerSize; ++q) {
                                                if (q % this.outputLayerSize != k) continue;
                                                int hiddenUnitNo = q / this.outputLayerSize;
                                                yTimesA[k][hiddenUnitNo] = val = As[q] * Yk[hiddenUnitNo];
                                                sum += val;
                                            }
                                            sumOfYTimesA[k] = sum;
                                        }
                                    }
                                    int[] cliqueLabel = new int[j + 1];
                                    System.arraycopy(windowLabels, this.window - 1 - j, cliqueLabel, 0, j + 1);
                                    CRFLabel crfLabel = new CRFLabel(cliqueLabel);
                                    int givenLabelIndex = labelIndex.indexOf(crfLabel);
                                    double[] Uk = null;
                                    double[] UhatK = null;
                                    double[] Yk = null;
                                    double[] yTimesAK = null;
                                    double sumOfYTimesAK = 0.0;
                                    if (this.flags.tieOutputLayer) {
                                        Uk = U[0];
                                        UhatK = Uhat[0];
                                        if (this.flags.softmaxOutputLayer) {
                                            Yk = Y[0];
                                        }
                                    } else {
                                        Uk = U[givenLabelIndex];
                                        UhatK = Uhat[givenLabelIndex];
                                        if (this.flags.softmaxOutputLayer) {
                                            Yk = Y[givenLabelIndex];
                                        }
                                    }
                                    if (this.flags.softmaxOutputLayer) {
                                        yTimesAK = yTimesA[givenLabelIndex];
                                        sumOfYTimesAK = sumOfYTimesA[givenLabelIndex];
                                    }
                                    for (int k = 0; k < this.inputLayerSize; ++k) {
                                        int n;
                                        double deltaK = 1.0;
                                        if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
                                            if (k % this.outputLayerSize == givenLabelIndex) {
                                                int hiddenUnitNo = k / this.outputLayerSize;
                                                if (this.flags.softmaxOutputLayer) {
                                                    int n2 = hiddenUnitNo;
                                                    UhatK[n2] = UhatK[n2] + (yTimesAK[hiddenUnitNo] - Yk[hiddenUnitNo] * sumOfYTimesAK);
                                                    deltaK *= Yk[hiddenUnitNo];
                                                } else {
                                                    int n3 = hiddenUnitNo;
                                                    UhatK[n3] = UhatK[n3] + As[k];
                                                    deltaK *= Uk[hiddenUnitNo];
                                                }
                                            }
                                        } else {
                                            int n4 = k;
                                            UhatK[n4] = UhatK[n4] + As[k];
                                            if (this.useOutputLayer) {
                                                deltaK *= Uk[k];
                                            }
                                        }
                                        if (this.useHiddenLayer) {
                                            deltaK *= fDeriv[k];
                                        }
                                        if (this.useOutputLayer) {
                                            if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
                                                if (k % this.outputLayerSize != givenLabelIndex) continue;
                                                double[] WhatK = What[k];
                                                for (n = 0; n < cliqueFeatures.length; ++n) {
                                                    int n5 = cliqueFeatures[n];
                                                    WhatK[n5] = WhatK[n5] + deltaK;
                                                }
                                                continue;
                                            }
                                            double[] WhatK = What[k];
                                            for (n = 0; n < cliqueFeatures.length; ++n) {
                                                int n6 = cliqueFeatures[n];
                                                WhatK[n6] = WhatK[n6] + deltaK;
                                            }
                                            continue;
                                        }
                                        if (k != givenLabelIndex) continue;
                                        double[] WhatK = What[k];
                                        for (n = 0; n < cliqueFeatures.length; ++n) {
                                            int n7 = cliqueFeatures[n];
                                            WhatK[n7] = WhatK[n7] + deltaK;
                                        }
                                    }
                                }
                                for (int k = 0; k < labelIndex.size(); ++k) {
                                    int[] label = labelIndex.get(k).getLabel();
                                    double p = cliqueTree.prob(i3, label);
                                    if (j == 0) {
                                        double[] Uk = null;
                                        double[] eUK = null;
                                        double[] Yk = null;
                                        if (this.flags.tieOutputLayer) {
                                            Uk = U[0];
                                            eUK = eU[0];
                                            if (this.flags.softmaxOutputLayer) {
                                                Yk = Y[0];
                                            }
                                        } else {
                                            Uk = U[k];
                                            eUK = eU[k];
                                            if (this.flags.softmaxOutputLayer) {
                                                Yk = Y[k];
                                            }
                                        }
                                        if (this.useOutputLayer) {
                                            for (int q = 0; q < this.inputLayerSize; ++q) {
                                                int n;
                                                double deltaQ = 1.0;
                                                if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
                                                    if (q % this.outputLayerSize == k) {
                                                        int hiddenUnitNo = q / this.outputLayerSize;
                                                        if (this.flags.softmaxOutputLayer) {
                                                            int n8 = hiddenUnitNo;
                                                            eUK[n8] = eUK[n8] + (yTimesA[k][hiddenUnitNo] - Yk[hiddenUnitNo] * sumOfYTimesA[k]) * p;
                                                            deltaQ = Yk[hiddenUnitNo];
                                                        } else {
                                                            int n9 = hiddenUnitNo;
                                                            eUK[n9] = eUK[n9] + As[q] * p;
                                                            deltaQ = Uk[hiddenUnitNo];
                                                        }
                                                    }
                                                } else {
                                                    int n10 = q;
                                                    eUK[n10] = eUK[n10] + As[q] * p;
                                                    deltaQ = Uk[q];
                                                }
                                                if (this.useHiddenLayer) {
                                                    deltaQ *= fDeriv[q];
                                                }
                                                if (this.flags.sparseOutputLayer || this.flags.tieOutputLayer) {
                                                    if (q % this.outputLayerSize != k) continue;
                                                    double[] eWq = eW[q];
                                                    for (n = 0; n < cliqueFeatures.length; ++n) {
                                                        int n11 = cliqueFeatures[n];
                                                        eWq[n11] = eWq[n11] + deltaQ * p;
                                                    }
                                                    continue;
                                                }
                                                double[] eWq = eW[q];
                                                for (n = 0; n < cliqueFeatures.length; ++n) {
                                                    int n12 = cliqueFeatures[n];
                                                    eWq[n12] = eWq[n12] + deltaQ * p;
                                                }
                                            }
                                            continue;
                                        }
                                        double deltaK = 1.0;
                                        if (this.useHiddenLayer) {
                                            deltaK *= fDeriv[k];
                                        }
                                        double[] eWK = eW[k];
                                        for (int n = 0; n < cliqueFeatures.length; ++n) {
                                            int n13 = cliqueFeatures[n];
                                            eWK[n13] = eWK[n13] + deltaK * p;
                                        }
                                        continue;
                                    }
                                    for (int n = 0; n < cliqueFeatures.length; ++n) {
                                        double[] dArray = E[cliqueFeatures[n]];
                                        int n14 = k;
                                        dArray[n14] = dArray[n14] + p;
                                    }
                                }
                            }
                        }
                    }
                    if (Double.isNaN(prob)) {
                        throw new RuntimeException("Got NaN for prob in CRFNonLinearLogConditionalObjectiveFunction.calculate()");
                    }
                    this.value = -prob;
                    if (VERBOSE) {
                        System.err.println("value is " + this.value);
                    }
                    int index = 0;
                    for (i = 0; i < E.length; ++i) {
                        int originalIndex = this.edgeFeatureIndicesMap.get(i);
                        for (int j = 0; j < E[i].length; ++j) {
                            this.derivative[index++] = E[i][j] - this.Ehat[i][j];
                            if (!VERBOSE) continue;
                            System.err.println("linearWeights deriv(" + i + "," + j + ") = " + E[i][j] + " - " + this.Ehat[i][j] + " = " + this.derivative[index - 1]);
                        }
                    }
                    if (index != this.edgeParamCount) {
                        throw new RuntimeException("after edge derivative, index(" + index + ") != edgeParamCount(" + this.edgeParamCount + ")");
                    }
                    for (i = 0; i < eW.length; ++i) {
                        for (int j = 0; j < eW[i].length; ++j) {
                            this.derivative[index++] = eW[i][j] - What[i][j];
                            if (!VERBOSE) continue;
                            System.err.println("inputLayerWeights deriv(" + i + "," + j + ") = " + eW[i][j] + " - " + What[i][j] + " = " + this.derivative[index - 1]);
                        }
                    }
                    if (index != this.beforeOutputWeights) {
                        throw new RuntimeException("after W derivative, index(" + index + ") != beforeOutputWeights(" + this.beforeOutputWeights + ")");
                    }
                    if (this.useOutputLayer) {
                        for (i = 0; i < eU.length; ++i) {
                            for (int j = 0; j < eU[i].length; ++j) {
                                this.derivative[index++] = eU[i][j] - Uhat[i][j];
                                if (!VERBOSE) continue;
                                System.err.println("outputLayerWeights deriv(" + i + "," + j + ") = " + eU[i][j] + " - " + Uhat[i][j] + " = " + this.derivative[index - 1]);
                            }
                        }
                    }
                    if (index != x.length) {
                        throw new RuntimeException("after W derivative, index(" + index + ") != x.length(" + x.length + ")");
                    }
                    regSize = x.length;
                    if (this.flags.skipOutputRegularization || this.flags.softmaxOutputLayer) {
                        regSize = this.beforeOutputWeights;
                    }
                    if (this.prior != 1) break block69;
                    double sigmaSq = this.sigma * this.sigma;
                    int i4 = 0;
                    while (i4 < regSize) {
                        double k = 1.0;
                        double w = x[i4];
                        this.value += k * w * w / 2.0 / sigmaSq;
                        int n = i4++;
                        this.derivative[n] = this.derivative[n] + k * w / sigmaSq;
                    }
                    break block70;
                }
                if (this.prior != 2) break block71;
                double sigmaSq = this.sigma * this.sigma;
                for (int i = 0; i < regSize; ++i) {
                    double w = x[i];
                    double wabs = Math.abs(w);
                    if (wabs < this.epsilon) {
                        this.value += w * w / 2.0 / this.epsilon / sigmaSq;
                        int n = i;
                        this.derivative[n] = this.derivative[n] + w / this.epsilon / sigmaSq;
                        continue;
                    }
                    this.value += (wabs - this.epsilon / 2.0) / sigmaSq;
                    int n = i;
                    this.derivative[n] = this.derivative[n] + (w < 0.0 ? -1.0 : 1.0) / sigmaSq;
                }
                break block70;
            }
            if (this.prior != 3) break block70;
            double sigmaQu = this.sigma * this.sigma * this.sigma * this.sigma;
            int i = 0;
            while (i < regSize) {
                double k = 1.0;
                double w = x[i];
                this.value += k * w * w * w * w / 2.0 / sigmaQu;
                int n = i++;
                this.derivative[n] = this.derivative[n] + k * w / sigmaQu;
            }
        }
    }

    public double[][] to2D(double[] linearWeights) {
        double[][] newWeights = new double[this.numEdgeFeatures][];
        int index = 0;
        int labelIndicesSize = this.labelIndices[1].size();
        for (int i = 0; i < this.numEdgeFeatures; ++i) {
            newWeights[i] = new double[labelIndicesSize];
            System.arraycopy(linearWeights, index, newWeights[i], 0, labelIndicesSize);
            index += labelIndicesSize;
        }
        return newWeights;
    }

    public double[][] empty2D() {
        double[][] d = new double[this.numEdgeFeatures][];
        int labelIndicesSize = this.labelIndices[1].size();
        for (int i = 0; i < this.numEdgeFeatures; ++i) {
            d[i] = new double[labelIndicesSize];
        }
        return d;
    }

    public double[][] emptyFull2D() {
        double[][] d = new double[this.map.length][];
        for (int i = 0; i < this.map.length; ++i) {
            d[i] = new double[this.labelIndices[this.map[i]].size()];
        }
        return d;
    }
}

