/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.document;

import de.l3s.boilerpipe.document.TextBlock;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextDocument {
    final List<TextBlock> textBlocks;
    String title;

    public TextDocument(List<TextBlock> textBlocks) {
        this(null, textBlocks);
    }

    public TextDocument(String title, List<TextBlock> textBlocks) {
        this.title = title;
        this.textBlocks = textBlocks;
    }

    public List<TextBlock> getTextBlocks() {
        return this.textBlocks;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return this.getText(true, false);
    }

    public String getText(boolean includeContent, boolean includeNonContent) {
        StringBuilder sb = new StringBuilder();
        for (TextBlock block : this.getTextBlocks()) {
            if (block.isContent() ? !includeContent : !includeNonContent) continue;
            sb.append(block.getText());
            sb.append('\n');
        }
        return sb.toString();
    }

    public String debugString() {
        StringBuilder sb = new StringBuilder();
        for (TextBlock tb : this.getTextBlocks()) {
            sb.append(tb.toString());
            sb.append('\n');
        }
        return sb.toString();
    }
}

