/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.gui.handwritingRecognizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import net.sourceforge.javaocr.gui.GUIController;

public class HandwritingRecognizer
extends JPanel {
    public static final long serialVersionUID = 0L;
    private final GUIController guiController;
    private static final Logger LOG = Logger.getLogger(HandwritingRecognizer.class.getName());

    public HandwritingRecognizer(GUIController guiController) {
        this.guiController = guiController;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getDescription(), "North");
        this.add((Component)this.getInnerTabPane(), "Center");
    }

    private JTextArea getDescription() {
        TitledBorder border = new TitledBorder("Description");
        JTextArea textArea = new JTextArea();
        textArea.setBorder(border);
        textArea.setEditable(false);
        textArea.setBackground(this.getBackground());
        String desc = "This feature learns to recognize handwriting for a specific individual.";
        textArea.setText(desc);
        return textArea;
    }

    private JTabbedPane getInnerTabPane() {
        JTabbedPane pane = new JTabbedPane();
        pane.add("1. Train", this.guiController.getHandWriteTrainingPanel());
        pane.add("2. Configure", this.guiController.getHandWriteConfigPanel());
        pane.add("3. Process", this.guiController.getHandWriteProcess());
        return pane;
    }
}

