# Generated by default/object.tt
package Paws::AccessAnalyzer::CloudTrailDetails;
  use Moose;
  has AccessRole => (is => 'ro', isa => 'Str', request_name => 'accessRole', traits => ['NameInRequest'], required => 1);
  has EndTime => (is => 'ro', isa => 'Str', request_name => 'endTime', traits => ['NameInRequest']);
  has StartTime => (is => 'ro', isa => 'Str', request_name => 'startTime', traits => ['NameInRequest'], required => 1);
  has Trails => (is => 'ro', isa => 'ArrayRef[Paws::AccessAnalyzer::Trail]', request_name => 'trails', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::CloudTrailDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::CloudTrailDetails object:

  $service_obj->Method(Att1 => { AccessRole => $value, ..., Trails => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::CloudTrailDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->AccessRole

=head1 DESCRIPTION

Contains information about CloudTrail access.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AccessRole => Str

The ARN of the service role that Access Analyzer uses to access your
CloudTrail trail and service last accessed information.


=head2 EndTime => Str

The end of the time range for which Access Analyzer reviews your
CloudTrail events. Events with a timestamp after this time are not
considered to generate a policy. If this is not included in the
request, the default value is the current time.


=head2 B<REQUIRED> StartTime => Str

The start of the time range for which Access Analyzer reviews your
CloudTrail events. Events with a timestamp before this time are not
considered to generate a policy.


=head2 B<REQUIRED> Trails => ArrayRef[L<Paws::AccessAnalyzer::Trail>]

A C<Trail> object that contains settings for a trail.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

