# Copyright (c) 2005 - 2006 Hans Jeuken. All rights reserved.
# This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.

# This file was generated from the 'idconsole.xml' file of the syntax highlight
# engine of the kate text editor (http://www.kate-editor.org

#kate xml version 1.02
#kate version 2.1
#generated: Sun Feb  3 22:02:06 2008, localtime

package Syntax::Highlight::Engine::Kate::Quake_Script;

our $VERSION = '0.11';

use strict;
use warnings;
use base('Syntax::Highlight::Engine::Kate::Template');

sub new {
   my $proto = shift;
   my $class = ref($proto) || $proto;
   my $self = $class->SUPER::new(@_);
   $self->attributes({
      'Action' => 'Reserved',
      'Command' => 'Keyword',
      'Comment' => 'Comment',
      'Float' => 'Float',
      'Hex' => 'BaseN',
      'Identifier' => 'DataType',
      'Int' => 'Float',
      'Normal Text' => 'Normal',
      'String' => 'String',
      'String Char' => 'Char',
      'Symbol' => 'Others',
      'Variable' => 'Variable',
   });
   $self->listAdd('Actions',
      '+activate',
      '+alt1',
      '+attack',
      '+back',
      '+break',
      '+button0',
      '+button1',
      '+button10',
      '+button11',
      '+button12',
      '+button13',
      '+button14',
      '+button2',
      '+button3',
      '+button4',
      '+button5',
      '+button6',
      '+button7',
      '+button8',
      '+button9',
      '+camdistance',
      '+camin',
      '+cammousemove',
      '+camout',
      '+campitchdown',
      '+campitchup',
      '+camyawleft',
      '+camyawright',
      '+commandmenu',
      '+dropweapon',
      '+duck',
      '+forward',
      '+graph',
      '+jlook',
      '+jump',
      '+kick',
      '+klook',
      '+leanleft',
      '+leanright',
      '+left',
      '+lookdown',
      '+lookup',
      '+mlook',
      '+movedown',
      '+moveleft',
      '+moveright',
      '+moveup',
      '+nvgadjust',
      '+quickgren',
      '+reload',
      '+right',
      '+salute',
      '+score',
      '+showscores',
      '+speed',
      '+sprint',
      '+strafe',
      '+ttack2',
      '+use',
      '+useitem',
      '+voicerecord',
      '+wbutton7',
      '+zoom',
      '-activate',
      '-alt1',
      '-attack',
      '-attack2',
      '-back',
      '-break',
      '-button0',
      '-button1',
      '-button10',
      '-button11',
      '-button12',
      '-button13',
      '-button14',
      '-button2',
      '-button3',
      '-button4',
      '-button5',
      '-button6',
      '-button7',
      '-button8',
      '-button9',
      '-camdistance',
      '-camin',
      '-cammousemove',
      '-camout',
      '-campitchdown',
      '-campitchup',
      '-camyawleft',
      '-camyawright',
      '-commandmenu',
      '-dropweapon',
      '-duck',
      '-forward',
      '-graph',
      '-jlook',
      '-jump',
      '-kick',
      '-klook',
      '-leanleft',
      '-leanright',
      '-left',
      '-lookdown',
      '-lookup',
      '-mlook',
      '-movedown',
      '-moveleft',
      '-moveright',
      '-moveup',
      '-nvgadjust',
      '-quickgren',
      '-reload',
      '-right',
      '-salute',
      '-score',
      '-showscores',
      '-speed',
      '-sprint',
      '-strafe',
      '-use',
      '-useitem',
      '-voicerecord',
      '-wbutton7',
      '-zoom',
   );
   $self->listAdd('BindFamily',
      'bind',
      'unbind',
   );
   $self->listAdd('Commands',
      'ForceCloseComman',
      '_config_com_baud',
      '_config_com_modem',
      '_vid_default_mode',
      '_vid_default_mode_win',
      '_vid_wait_override',
      '_windowed_mouse',
      'addip',
      'addressbook',
      'adjust_crosshair',
      'advancedupdate',
      'allow_download',
      'allow_download_maps',
      'allow_download_models',
      'allow_download_skins',
      'allow_download_sounds',
      'allskins',
      'appenddemo',
      'autosave',
      'ban',
      'banClient',
      'banUser',
      'banid',
      'baseskin',
      'begin',
      'bf',
      'bgetmod',
      'bindlist',
      'block_switch',
      'bottomcolor',
      'buyNow',
      'buyequip',
      'cache_endgather',
      'cache_flush',
      'cache_mapchange',
      'cache_print',
      'cache_profile',
      'cache_setindex',
      'cache_startgather',
      'cache_usedfile',
      'cancelselect',
      'cd',
      'centerview',
      'changeVectors',
      'changelevel',
      'changelevel2',
      'changing',
      'chase_active',
      'cinematic',
      'cl_deadbodyfilter',
      'cl_gibfilter',
      'cl_hightrack',
      'cl_hudswap',
      'cl_messages',
      'cl_nodelta',
      'cl_nolerp',
      'cl_nopred',
      'cl_predict_players',
      'cl_rate',
      'cl_sbar',
      'cl_sbar_separator',
      'cl_shownet',
      'cl_sidespeed',
      'cl_solid_players',
      'cl_warncmd',
      'cl_writecfg',
      'clear',
      'clearplayers',
      'clientinfo',
      'clientkick',
      'cmd',
      'cmdline',
      'cmdlist',
      'color',
      'commands',
      'condebug',
      'condump',
      'configstrings',
      'confirm_quit',
      'connect',
      'contimes',
      'coop',
      'crash',
      'credits',
      'cropimages',
      'crosshair',
      'cvar_restart',
      'cvarlist',
      'd_mipcap',
      'd_subdiv16',
      'deathmatch',
      'delta_clear',
      'delta_stats',
      'demo',
      'demolist',
      'demomap',
      'demos',
      'developer',
      'devmap',
      'dir',
      'disconnect',
      'dlfile',
      'dmoptions',
      'download',
      'drawradar',
      'drop',
      'dropclient',
      'dumpuser',
      'edict',
      'edictcount',
      'edicts',
      'endmovie',
      'entities',
      'envmap',
      'error',
      'escape',
      'exec',
      'exit',
      'fastsprites',
      'fdir',
      'filterban',
      'firstperson',
      'floodprot',
      'floodprotmsg',
      'flush',
      'fly',
      'force_centerview',
      'fov',
      'fraglogfile',
      'freelook',
      'freeze',
      'front',
      'fs_openedList',
      'fs_referencedList',
      'fullinfo',
      'fullserverinfo',
      'game',
      'gameCompleteStatus',
      'gamedir',
      'gamemap',
      'gameversion',
      'getcertificate',
      'gfxinfo',
      'gg',
      'gib',
      'gibload',
      'gibstats',
      'give',
      'gl_affinemodels',
      'gl_clear',
      'gl_colorlights',
      'gl_constretch',
      'gl_cull',
      'gl_dlight_lightmap',
      'gl_dlight_polyblend',
      'gl_dlight_smooth',
      'gl_fb_bmodels',
      'gl_fb_models',
      'gl_finish',
      'gl_fires',
      'gl_flashblend',
      'gl_keeptjunctions',
      'gl_lerp_anim',
      'gl_lightmode',
      'gl_max_size',
      'gl_multitexture',
      'gl_nobind',
      'gl_nocolors',
      'gl_picmip',
      'gl_playermip',
      'gl_polyblend',
      'gl_reportjunctions',
      'gl_sky_clip',
      'gl_skymultipass',
      'gl_smoothmodels',
      'gl_texsort',
      'gl_texturemode',
      'gl_triplebuffer',
      'gl_ztrick',
      'globalservers',
      'god',
      'gun',
      'gun_model',
      'gun_next',
      'gun_prev',
      'gunsmoke',
      'heartbeat',
      'help',
      'hideconsole',
      'hideradar',
      'host_speeds',
      'hostname',
      'hpkextract',
      'hpklist',
      'hpkremove',
      'hpkval',
      'hud_centerid',
      'imagelist',
      'impulse',
      'imt',
      'in_bind',
      'in_paste_buffer',
      'in_restart',
      'in_unbind',
      'info',
      'interp',
      'invdrop',
      'inven',
      'invnext',
      'invnextp',
      'invnextw',
      'invprev',
      'invprevp',
      'invprevw',
      'invuse',
      'joinserver',
      'joy',
      'joy_advancedupdate',
      'joy_enable',
      'joyadvanced',
      'joyadvancedupdat',
      'joyadvancedupdate',
      'joyname',
      'joystick',
      'keys',
      'kick',
      'kill',
      'killserver',
      'lefthand',
      'link',
      'list',
      'listdemo',
      'listen',
      'listid',
      'listip',
      'listmaps',
      'load',
      'loadas8bit',
      'loadgame',
      'loading',
      'loadsky',
      'loadtranslations',
      'loc',
      'localinfo',
      'localservers',
      'log',
      'logaddress',
      'logfile',
      'lookspring',
      'lookstrafe',
      'm_filter',
      'main',
      'map',
      'map_restart',
      'maplist',
      'maps',
      'max_shells',
      'max_smokepuffs',
      'maxplayers',
      'mcache',
      'meminfo',
      'menu',
      'menu_addressbook',
      'menu_credits',
      'menu_dmoptions',
      'menu_game',
      'menu_help',
      'menu_joinserver',
      'menu_keys',
      'menu_load',
      'menu_loadgame',
      'menu_main',
      'menu_multiplayer',
      'menu_options',
      'menu_playerconfig',
      'menu_quit',
      'menu_save',
      'menu_savegame',
      'menu_select',
      'menu_setup',
      'menu_singleplayer',
      'menu_startserver',
      'menu_video',
      'messagemode',
      'messagemode2',
      'messagemode3',
      'messagemode4',
      'model',
      'modelist',
      'modellist',
      'msg',
      'multiplayer',
      'music',
      'name',
      'net_stats',
      'new',
      'next',
      'nextul',
      'nightvision',
      'no_pogo_stick',
      'noaim',
      'noclip',
      'noexit',
      'nomonsters',
      'noskins',
      'nosound',
      'notarget',
      'options',
      'packet',
      'password',
      'path',
      'pausable',
      'pause',
      'paused',
      'ping',
      'pingservers',
      'play',
      'playdemo',
      'playerconfig',
      'players',
      'playvol',
      'pointfile',
      'ppdemostart',
      'pr_boundscheck',
      'precache',
      'prespawn',
      'prev',
      'profile',
      'profilequit',
      'prog',
      'pushlatency',
      'quit',
      'r_drawentities',
      'r_drawflat',
      'r_draworder',
      'r_drawviewmodel',
      'r_dspeeds',
      'r_dynamic',
      'r_fullbright',
      'r_lightmap',
      'r_netgraph',
      'r_netgraph_box',
      'r_norefresh',
      'r_novis',
      'r_numedges',
      'r_numsurfs',
      'r_particles',
      'r_polymodelstats',
      'r_reportsurfout',
      'r_shadows',
      'r_speeds',
      'r_timegraph',
      'r_wateralpha',
      'r_waterripple',
      'r_waterwarp',
      'r_zgraph',
      'rcon',
      'rcon_password',
      'reconnect',
      'record',
      'registered',
      'reload',
      'removedemo',
      'removeid',
      'removeip',
      'rerecord',
      'reset',
      'resetrcon',
      'restart',
      'retry',
      's_disable_a3d',
      's_enable_a3d',
      's_info',
      's_list',
      's_stop',
      'samelevel',
      'save',
      'savegame',
      'savetranslations',
      'score',
      'screenshot',
      'screenshotJPEG',
      'sectorlist',
      'sendents',
      'serverinfo',
      'serverprofile',
      'serverrecord',
      'serverstatus',
      'serverstop',
      'setRecommended',
      'setdemoinfo',
      'setenv',
      'setinfo',
      'setmaster',
      'setrom',
      'shaderlist',
      'show_fps',
      'show_time',
      'showdrop',
      'showinfo',
      'showip',
      'showpackets',
      'showpause',
      'showram',
      'showturtle',
      'shutdownserver',
      'singlePlayLink',
      'sizedown',
      'sizeup',
      'skill',
      'skin',
      'skinlist',
      'skins',
      'sky',
      'skyboxlist',
      'slist',
      'slot1',
      'slot10',
      'slot2',
      'slot3',
      'slot4',
      'slot5',
      'slot6',
      'slot7',
      'slot8',
      'slot9',
      'snap',
      'snapall',
      'snapshot',
      'snapto',
      'snd',
      'snd_noextraupdate',
      'snd_restart',
      'snd_show',
      'soundfade',
      'soundinfo',
      'soundlist',
      'spawn',
      'spdevmap',
      'speak',
      'special',
      'specmode',
      'spectator',
      'spectator_password',
      'spk',
      'spmap',
      'startLimboMode',
      'startSingleplayer',
      'startdemos',
      'startmovie',
      'startserver',
      'stat',
      'stats',
      'status',
      'stop',
      'stopLimboMode',
      'stopdemo',
      'stoprecord',
      'stopsound',
      'stopul',
      'streamingsound',
      'stuffcmd',
      'stuffcmds',
      'sv',
      'sv_allow_log',
      'sv_allow_pings',
      'sv_allow_status',
      'sv_gamedir',
      'sv_highchars',
      'sv_mapcheck',
      'sv_maplist',
      'sv_nostep',
      'sv_spectatormaxspeed',
      'sv_spetalk',
      'swapdemo',
      'sys_cpuid',
      'sys_dead_sleep',
      'sys_extrasleep',
      'sys_nostdout',
      'systeminfo',
      'taginfo',
      'team',
      'teamplay',
      'tell',
      'test',
      'test2',
      'thirdperson',
      'time',
      'timedemo',
      'timeleft',
      'timerefresh',
      'toggle',
      'togglebrowser',
      'togglechat',
      'toggleconsole',
      'togglemenu',
      'topcolor',
      'touchFile',
      'trackplayer',
      'ui_restart',
      'unalias',
      'unbindall',
      'updatehunkusage',
      'updatescreen',
      'upload',
      'use',
      'user',
      'userinfo',
      'users',
      'v_centerspeed',
      'v_cshift',
      'v_idlescale',
      'version',
      'vid',
      'vid_center',
      'vid_config_x',
      'vid_describecurrentmode',
      'vid_describemode',
      'vid_describemodes',
      'vid_forcemode',
      'vid_front',
      'vid_fullscreen',
      'vid_fullscreen_mode',
      'vid_minimize',
      'vid_nopageflip',
      'vid_nummodes',
      'vid_restart',
      'vid_stretch_by_2',
      'vid_testmode',
      'vid_windowed',
      'vid_windowed_mode',
      'video',
      'viewframe',
      'viewmodel',
      'viewnext',
      'viewpos',
      'viewprev',
      'vminfo',
      'vmprofile',
      'voice_showbanned',
      'votemap',
      'vstr',
      'wait',
      'watervis',
      'wave',
      'weaplast',
      'weapnext',
      'weapon',
      'weapon_knife',
      'weapprev',
      'windowsr_drawentities',
      'writecfg',
      'writeconfig',
      'writeid',
      'writeip',
      'z_stats',
   );
   $self->listAdd('KeyTypes',
      '\\\'',
      '*',
      '+',
      ',',
      '-',
      '.',
      '/',
      '0',
      '1',
      '2',
      '3',
      '4',
      '5',
      '6',
      '7',
      '8',
      '9',
      '=',
      'ALT',
      'AUX1',
      'AUX10',
      'AUX11',
      'AUX12',
      'AUX13',
      'AUX14',
      'AUX15',
      'AUX16',
      'AUX17',
      'AUX18',
      'AUX2',
      'AUX20',
      'AUX21',
      'AUX22',
      'AUX23',
      'AUX24',
      'AUX25',
      'AUX26',
      'AUX27',
      'AUX28',
      'AUX29',
      'AUX3',
      'AUX30',
      'AUX31',
      'AUX32',
      'AUX4',
      'AUX5',
      'AUX6',
      'AUX7',
      'AUX8',
      'AUX9',
      'BACKSPACE',
      'CAPSLOCK',
      'CTRL',
      'DEL',
      'DOWNARROW',
      'END',
      'ENTER',
      'ESCAPE',
      'F1',
      'F10',
      'F11',
      'F12',
      'F2',
      'F3',
      'F4',
      'F5',
      'F6',
      'F7',
      'F8',
      'F9',
      'HOME',
      'INS',
      'JOY1',
      'JOY2',
      'JOY3',
      'JOY4',
      'KP_5',
      'KP_DEL',
      'KP_DOWNARROW',
      'KP_END',
      'KP_HOME',
      'KP_INS',
      'KP_LEFTARROW',
      'KP_PGDN',
      'KP_PGUP',
      'KP_RIGHTARROW',
      'KP_SLASH',
      'KP_UPARROW',
      'LEFTARROW',
      'MOUSE1',
      'MOUSE2',
      'MOUSE3',
      'MWHEELDOWN',
      'MWHEELUP',
      'PAUSE',
      'PGDN',
      'PGUP',
      'RIGHTARROW',
      'SEMICOLON',
      'SHIFT',
      'SPACE',
      'TAB',
      'UPARROW',
      '[',
      '\\\\',
      ']',
      '`',
      'a',
      'b',
      'c',
      'd',
      'e',
      'f',
      'g',
      'h',
      'i',
      'j',
      'k',
      'l',
      'm',
      'n',
      'o',
      'p',
      'q',
      'r',
      's',
      't',
      'u',
      'v',
      'w',
      'x',
      'y',
      'z',
      '~',
   );
   $self->listAdd('PrintsString',
      'echo',
      'say',
      'say_team',
   );
   $self->listAdd('Symbols',
      '$',
      ';',
   );
   $self->listAdd('Variables',
      'ActiveAction',
      '_cl_color',
      '_cl_name',
      '_config_com_baud',
      '_config_com_irq',
      '_config_com_modem',
      '_config_com_port',
      '_config_modem_clear',
      '_config_modem_dialtype',
      '_config_modem_hangup',
      '_config_modem_init',
      '_snd_mixahead',
      '_vid_default_mode',
      '_vid_default_mode_win',
      '_vid_wait_override',
      '_windowed_mouse',
      'address',
      'adr',
      'adr0',
      'adr1',
      'adr2',
      'adr3',
      'adr4',
      'adr5',
      'adr6',
      'adr7',
      'adr8',
      'advanced',
      'advaxisr',
      'advaxisu',
      'advaxisv',
      'advaxisx',
      'advaxisy',
      'advaxisz',
      'ah',
      'airaccelerate',
      'allow',
      'allow_download_players',
      'ambient_fade',
      'ambient_level',
      'anglespeedkey',
      'arch',
      'array',
      'arrays',
      'att',
      'auto',
      'autoskins',
      'b',
      'bgmbuffer',
      'bgmvolume',
      'bit',
      'bitdepth',
      'blend',
      'bob',
      'bob_pitch',
      'bob_roll',
      'bob_up',
      'bot_aasoptimize',
      'bot_challenge',
      'bot_debug',
      'bot_developer',
      'bot_enable',
      'bot_fastchat',
      'bot_forceclustering',
      'bot_forcereachability',
      'bot_forcewrite',
      'bot_grapple',
      'bot_groundonly',
      'bot_interbreedbots',
      'bot_interbreedchar',
      'bot_interbreedcycle',
      'bot_interbreedwrite',
      'bot_maxdebugpolys',
      'bot_miniplayers',
      'bot_minplayers',
      'bot_nochat',
      'bot_pause',
      'bot_reachability',
      'bot_reloadcharacters',
      'bot_report',
      'bot_rocketjump',
      'bot_saveroutingcache',
      'bot_testclusters',
      'bot_testichat',
      'bot_testrchat',
      'bot_testsolid',
      'bot_thinktime',
      'bot_visualizejumppads',
      'brighten',
      'brightness',
      'broken',
      'cd',
      'cd_loopcount',
      'cd_looptrack',
      'cd_nocd',
      'cd_plugin',
      'centermove',
      'centerspeed',
      'centertime',
      'cg_autoactivate',
      'cg_autoswitch',
      'cg_blinktime',
      'cg_bloodTime',
      'cg_bobpitch',
      'cg_bobroll',
      'cg_bobup',
      'cg_brassTime',
      'cg_cameraOrbitDelay',
      'cg_clipboardName',
      'cg_coronafardist',
      'cg_coronas',
      'cg_crosshairAlpha',
      'cg_crosshairHealth',
      'cg_crosshairSize',
      'cg_crosshairX',
      'cg_crosshairY',
      'cg_currentSelectedPlayer',
      'cg_currentSelectedPlayerName',
      'cg_cursorHints',
      'cg_cycleAllWeaps',
      'cg_deferPlayers',
      'cg_descriptiveText',
      'cg_draw2D',
      'cg_draw3dIcons',
      'cg_drawAllWeaps',
      'cg_drawAmmoWarning',
      'cg_drawAttacker',
      'cg_drawCompass',
      'cg_drawCrosshair',
      'cg_drawCrosshairNames',
      'cg_drawCrosshairPickups',
      'cg_drawFPGun',
      'cg_drawFPS',
      'cg_drawFrags',
      'cg_drawGun',
      'cg_drawIcons',
      'cg_drawNotifyText',
      'cg_drawRewards',
      'cg_drawSnapshot',
      'cg_drawSpreadScale',
      'cg_drawStatus',
      'cg_drawTeamOverlay',
      'cg_drawTimer',
      'cg_emptyswitch',
      'cg_forcemodel',
      'cg_fov',
      'cg_gibs',
      'cg_hudAlpha',
      'cg_hudFiles',
      'cg_lagometer',
      'cg_marks',
      'cg_marktime',
      'cg_noTaunt',
      'cg_noVoiceChats',
      'cg_noVoiceText',
      'cg_noplayeranims',
      'cg_nopredict',
      'cg_particleDist',
      'cg_particleLOD',
      'cg_popupLimboMenu',
      'cg_predictItems',
      'cg_quickMessageAlt',
      'cg_railTrailTime',
      'cg_recoilPitch',
      'cg_reticleBrightness',
      'cg_reticleType',
      'cg_runpitch',
      'cg_runroll',
      'cg_scorePlums',
      'cg_selectedPlayer',
      'cg_selectedPlayerName',
      'cg_shadows',
      'cg_showblood',
      'cg_simpleItems',
      'cg_skybox',
      'cg_stereoSeparation',
      'cg_teamChatHeight',
      'cg_teamChatTime',
      'cg_teamChatsOnly',
      'cg_thirdPersonAngle',
      'cg_thirdperson',
      'cg_thirdpersonrange',
      'cg_useWeapsForZoom',
      'cg_uselessNostalgia',
      'cg_viewsize',
      'cg_voiceSpriteTime',
      'cg_weaponCycleDelay',
      'cg_wolfparticles',
      'cg_zoomDefaultBinoc',
      'cg_zoomDefaultFG',
      'cg_zoomDefaultSniper',
      'cg_zoomDefaultSnooper',
      'cg_zoomStepBinoc',
      'cg_zoomStepFG',
      'cg_zoomStepSnooper',
      'cg_zoomfov',
      'cg_zoomstepsniper',
      'chase_active',
      'chase_back',
      'chase_right',
      'chase_up',
      'cheats',
      'cl',
      'cl_allowDownload',
      'cl_anglespeedkey',
      'cl_anonymous',
      'cl_autoexec',
      'cl_autoskins',
      'cl_avidemo',
      'cl_backspeed',
      'cl_blend',
      'cl_bob',
      'cl_bobcycle',
      'cl_bobup',
      'cl_bypassMouseInput',
      'cl_cacheGathering',
      'cl_camera_maxpitch',
      'cl_camera_maxyaw',
      'cl_chasecam',
      'cl_chatmode',
      'cl_conXOffset',
      'cl_crossx',
      'cl_crossy',
      'cl_cshift_bonus',
      'cl_cshift_content',
      'cl_cshift_damage',
      'cl_cshift_powerup',
      'cl_debugMove',
      'cl_debugTranslation',
      'cl_demospeed',
      'cl_entities',
      'cl_footsteps',
      'cl_forceavidemo',
      'cl_forwardspeed',
      'cl_freelook',
      'cl_freezeDemo',
      'cl_gun',
      'cl_hidefrags',
      'cl_hightrack',
      'cl_hudswap',
      'cl_language',
      'cl_lights',
      'cl_maxPing',
      'cl_maxfps',
      'cl_maxpackets',
      'cl_motd',
      'cl_motdString',
      'cl_mouseAccel',
      'cl_movespeedkey',
      'cl_nodelta',
      'cl_nofake',
      'cl_nolerp',
      'cl_nopred',
      'cl_noprint',
      'cl_noskins',
      'cl_observercrosshair',
      'cl_packetdup',
      'cl_parsesay',
      'cl_particles',
      'cl_paused',
      'cl_pitchspeed',
      'cl_predict',
      'cl_predict_players',
      'cl_predict_players2',
      'cl_quakerc',
      'cl_rollangle',
      'cl_rollspeed',
      'cl_run',
      'cl_running',
      'cl_serverStatusResendTime',
      'cl_showSend',
      'cl_showServerCommands',
      'cl_showTimeDelta',
      'cl_showfps',
      'cl_showmiss',
      'cl_showmouserate',
      'cl_shownet',
      'cl_shownuments',
      'cl_sidespeed',
      'cl_stats',
      'cl_stereo',
      'cl_stereo_separation',
      'cl_testblend',
      'cl_testentities',
      'cl_testlights',
      'cl_testparticles',
      'cl_timeNudge',
      'cl_timeout',
      'cl_upspeed',
      'cl_verstring',
      'cl_visibleClients',
      'cl_vwep',
      'cl_waitForFire',
      'cl_wavefilerecord',
      'cl_yawspeed',
      'clear',
      'clearcolor',
      'clientport',
      'cm_playerCurveClip',
      'cmd_highchars',
      'cmd_warncmd',
      'cmdlist',
      'color',
      'color1',
      'color2',
      'com_blood',
      'com_buildScript',
      'com_cameraMode',
      'com_dropsim',
      'com_hunkMegs',
      'com_hunkused',
      'com_introplayed',
      'com_maxfps',
      'com_recommendedSet',
      'com_showtrace',
      'com_soundMegs',
      'com_speeds',
      'com_zoneMegs',
      'compiled',
      'con_debug',
      'con_notifytime',
      'con_restricted',
      'conspeed',
      'contrast',
      'coop',
      'crosshair',
      'crosshaircolor',
      'cull',
      'd_mipcap',
      'd_mipscale',
      'deathmatch',
      'debug_protocol',
      'debuggraph',
      'dedicated',
      'devdll',
      'developer',
      'dlabs',
      'dm',
      'dmflags',
      'down',
      'download',
      'drawall',
      'drawbuffer',
      'drawentities',
      'drawflat',
      'draworder',
      'drawworld',
      'driver',
      'dspeeds',
      'dynamic',
      'easter_eggs',
      'edgefriction',
      'empty',
      'enforcetime',
      'entities',
      'entlatency',
      'ext',
      'filter',
      'filterban',
      'finish',
      'fixedtime',
      'flashblend',
      'flood',
      'flood_msgs',
      'flood_persecond',
      'flood_waitdelay',
      'flushmap',
      'footsteps',
      'forward',
      'forwardsensitivity',
      'forwardspeed',
      'forwardthreshold',
      'fov',
      'fraglimit',
      'freelook',
      'fs_basegame',
      'fs_basepath',
      'fs_cdpath',
      'fs_copyfiles',
      'fs_debug',
      'fs_game',
      'fs_globalcfg',
      'fs_homepath',
      'fs_pluginpath',
      'fs_restrict',
      'fs_sharepath',
      'fs_skinbase',
      'fs_usercfg',
      'fs_userpath',
      'fullbright',
      'fullscreen',
      'g_allowvote',
      'g_altStopwatchMode',
      'g_arenasFile',
      'g_blueTeam',
      'g_botsFile',
      'g_complaintlimit',
      'g_currentRound',
      'g_friendlyFire',
      'g_gameskill',
      'g_gametype',
      'g_maxlives',
      'g_minGameClients',
      'g_missionStats',
      'g_nextTimeLimit',
      'g_noTeamSwitching',
      'g_redTeam',
      'g_select_empty',
      'g_spAwards',
      'g_spScores1',
      'g_spScores2',
      'g_spScores3',
      'g_spScores4',
      'g_spScores5',
      'g_spSkill',
      'g_spVideos',
      'g_userAlliedRespawnTime',
      'g_userAxisRespawnTime',
      'g_userTimeLimit',
      'game',
      'gamecfg',
      'gamedate',
      'gamedir',
      'gamename',
      'gamestate',
      'gamma',
      'gender',
      'gender_auto',
      'gl_3dlabs_broken',
      'gl_allow_software',
      'gl_bitdepth',
      'gl_clear',
      'gl_conalpha',
      'gl_conspin',
      'gl_cshiftpercent',
      'gl_cull',
      'gl_drawbuffer',
      'gl_driver',
      'gl_dynamic',
      'gl_ext_compiled_vertex_array',
      'gl_ext_multitexture',
      'gl_ext_palettedtexture',
      'gl_ext_pointparameters',
      'gl_ext_swapinterval',
      'gl_finish',
      'gl_flashblend',
      'gl_keeptjunctions',
      'gl_lightmap',
      'gl_lightmap_align',
      'gl_lightmap_subimage',
      'gl_lockpvs',
      'gl_log',
      'gl_max_size',
      'gl_mesh_cache',
      'gl_mode',
      'gl_modulate',
      'gl_monolightmap',
      'gl_nobind',
      'gl_nocolors',
      'gl_nosubimage',
      'gl_occlusion',
      'gl_particle_att_a',
      'gl_particle_att_b',
      'gl_particle_att_c',
      'gl_particle_max_size',
      'gl_particle_min_size',
      'gl_particle_mip',
      'gl_particle_size',
      'gl_picmip',
      'gl_playermip',
      'gl_polyblend',
      'gl_reporttjunctions',
      'gl_round_down',
      'gl_saturatelighting',
      'gl_screenshot_byte_swap',
      'gl_shadows',
      'gl_showtris',
      'gl_sky_debug',
      'gl_sky_divide',
      'gl_skymip',
      'gl_smoothmodels',
      'gl_subdivide_size',
      'gl_swapinterval',
      'gl_texsort',
      'gl_texturealphamode',
      'gl_texturemode',
      'gl_texturesolidmode',
      'gl_triplebuffer',
      'gl_vertex_arrays',
      'gl_ztrick',
      'graphheight',
      'graphscale',
      'graphshift',
      'gravity',
      'gun',
      'gun_x',
      'gun_y',
      'gun_z',
      'hand',
      'handicap',
      'head',
      'headModel',
      'headmodel',
      'host',
      'host_framerate',
      'host_speeds',
      'hostname',
      'hostport',
      'hud_fastswitch',
      'in',
      'in_amp',
      'in_bind_imt',
      'in_debugjoystick',
      'in_dga',
      'in_dga_mouseaccel',
      'in_dgamouse',
      'in_grab',
      'in_joystick',
      'in_midi',
      'in_mouse',
      'in_mouse_amp',
      'in_mouse_filter',
      'in_mouse_pre_amp',
      'in_pre_amp',
      'initsound',
      'intensity',
      'ip',
      'ip_clientport',
      'ip_hostport',
      'ipx',
      'ipx_clientport',
      'ipx_hostport',
      'journal',
      'joy',
      'joy_advanced',
      'joy_advaxisr',
      'joy_advaxisu',
      'joy_advaxisv',
      'joy_advaxisx',
      'joy_advaxisy',
      'joy_advaxisz',
      'joy_amp',
      'joy_device',
      'joy_forwardsensitivity',
      'joy_forwardthreshold',
      'joy_name',
      'joy_pitchsensitivity',
      'joy_pitchthreshold',
      'joy_pre_amp',
      'joy_sensitivity',
      'joy_sidesensitivity',
      'joy_sidethreshold',
      'joy_threshold',
      'joy_upsensitivity',
      'joy_upthreshold',
      'joy_yawsensitivity',
      'joy_yawthreshold',
      'joyadvanced',
      'joyadvaxisr',
      'joyadvaxisu',
      'joyadvaxisv',
      'joyadvaxisx',
      'joyadvaxisy',
      'joyadvaxisz',
      'joyaxis1',
      'joyaxis2',
      'joyaxis3',
      'joyaxis4',
      'joyaxis5',
      'joyaxis6',
      'joyaxis7',
      'joyaxis8',
      'joyforwardsensitivity',
      'joyforwardthreshold',
      'joyname',
      'joypitchsensitivity',
      'joypitchthreshold',
      'joysidesensitivity',
      'joysidethreshold',
      'joystick',
      'joywwhack1',
      'joywwhack2',
      'joyyawsensitivity',
      'joyyawthreshold',
      'khz',
      'lcd_x',
      'lcd_yaw',
      'lerpmodels',
      'lightmap',
      'lights',
      'limit',
      'listen',
      'loadas',
      'loadas8bit',
      'localid',
      'lockpvs',
      'log',
      'log_stats',
      'logfile',
      'lookspring',
      'lookstrafe',
      'loopcount',
      'looptrack',
      'm_filter',
      'm_forward',
      'm_pitch',
      'm_side',
      'm_yaw',
      'mapname',
      'maps',
      'max',
      'maxclients',
      'maxedges',
      'maxentities',
      'maxfps',
      'maxplayers',
      'maxspectators',
      'maxsurfs',
      'maxvelocity',
      'min',
      'mipcap',
      'mipscale',
      'mixahead',
      'mode',
      'model',
      'models',
      'modex',
      'modulate',
      'monolightmap',
      'mouse',
      'mp_autokick',
      'mp_autoteambalance',
      'mp_c4timer',
      'mp_currentPlayerType',
      'mp_currentTeam',
      'mp_flashlight',
      'mp_footsteps',
      'mp_forcechasecam',
      'mp_freezetime',
      'mp_friendlyfire',
      'mp_hostagepenalty',
      'mp_limitteams',
      'mp_logmessages',
      'mp_mapvoteration',
      'mp_playerType',
      'mp_roundtime',
      'mp_team',
      'mp_timelimit',
      'mp_tkpunish',
      'mp_weapon',
      'msg',
      'msgs',
      'multitexture',
      'name',
      'net_graph',
      'net_ip',
      'net_messagetimeout',
      'net_noudp',
      'net_port',
      'net_qport',
      'net_restart',
      'netdosexpire',
      'netdosvalues',
      'netgraph',
      'nextdemo',
      'nextmap',
      'nextserver',
      'noalttab',
      'nobind',
      'nocd',
      'nocull',
      'nodelta',
      'noexit',
      'nomonsters',
      'norefresh',
      'noreload',
      'noskins',
      'nosound',
      'nosubimage',
      'novis',
      'palettedtexture',
      'particle',
      'particles',
      'password',
      'pausable',
      'persecond',
      'picmip',
      'pitch',
      'pitchsensitivity',
      'pitchspeed',
      'pitchthreshold',
      'playermip',
      'players',
      'pointparameters',
      'polyblend',
      'polymodelstats',
      'port',
      'pr_checkextensions',
      'pr_deadbeef_ents',
      'pr_deadbeef_locals',
      'pr_debug',
      'pr_source_path',
      'precache',
      'predict',
      'primary',
      'printspeed',
      'protocol',
      'public',
      'pushlatency',
      'qport',
      'r_aliastransadj',
      'r_aliastransbase',
      'r_allowExtensions',
      'r_allowSoftwareGL',
      'r_ambient',
      'r_ambientScale',
      'r_bonesDebug',
      'r_cache',
      'r_cacheModels',
      'r_cacheShaders',
      'r_clear',
      'r_clearcolor',
      'r_colorMipLevels',
      'r_colorbits',
      'r_compressModels',
      'r_customaspect',
      'r_customheight',
      'r_customwidth',
      'r_debugSort',
      'r_debugSurface',
      'r_debuglight',
      'r_depthbits',
      'r_detailtextures',
      'r_directedScale',
      'r_displayRefresh',
      'r_dlightBacks',
      'r_dlight_lightmap',
      'r_dlight_max',
      'r_drawBuffer',
      'r_drawSun',
      'r_drawentities',
      'r_drawexplosions',
      'r_drawflat',
      'r_draworder',
      'r_drawviewmodel',
      'r_drawworld',
      'r_dspeeds',
      'r_dynamic',
      'r_dynamiclight',
      'r_explosionclip',
      'r_exportCompressedModels',
      'r_ext_compiled_vertex_array',
      'r_ext_compress_textures',
      'r_ext_compressed_textures',
      'r_ext_gamma_control',
      'r_ext_multitexture',
      'r_ext_texture_env_add',
      'r_facePlaneCull',
      'r_fastsky',
      'r_finish',
      'r_firecolor',
      'r_flareFade',
      'r_flareSize',
      'r_flares',
      'r_fullbright',
      'r_fullscreen',
      'r_gamma',
      'r_glDriver',
      'r_glIgnoreWicked3D',
      'r_graphheight',
      'r_highQualit',
      'r_highQualityVideo',
      'r_ignore',
      'r_ignoreFastPath',
      'r_ignoreGLErrors',
      'r_ignorehwgamma',
      'r_inGameVideo',
      'r_intensity',
      'r_lastValidRenderer',
      'r_lerpmodels',
      'r_lightmap',
      'r_lightmap_components',
      'r_lockpvs',
      'r_lodCurveError',
      'r_lodbias',
      'r_lodscale',
      'r_logFile',
      'r_lowMemTextureSize',
      'r_lowMemTextureThreshold',
      'r_mapOverBrightBits',
      'r_maxedges',
      'r_maxpolys',
      'r_maxpolyverts',
      'r_maxsurfs',
      'r_measureOverdraw',
      'r_mirroralpha',
      'r_mode',
      'r_netgraph',
      'r_netgraph_alpha',
      'r_nobind',
      'r_nocull',
      'r_nocurves',
      'r_noportals',
      'r_norefresh',
      'r_novis',
      'r_numedges',
      'r_numsurfs',
      'r_offsetfactor',
      'r_offsetunits',
      'r_overBrightBits',
      'r_particles_max',
      'r_particles_style',
      'r_picmip',
      'r_picmip2',
      'r_polymodelstats',
      'r_portalOnly',
      'r_preloadTextures',
      'r_previousglDriver',
      'r_primitives',
      'r_printShaders',
      'r_railCoreWidth',
      'r_railSegmentLength',
      'r_railWidth',
      'r_reportedgeout',
      'r_reportsurfout',
      'r_rmse',
      'r_roundImagesDown',
      'r_saveFontData',
      'r_shadows',
      'r_showImages',
      'r_showSmp',
      'r_showcluster',
      'r_shownormals',
      'r_showsky',
      'r_showtris',
      'r_simpleMipMaps',
      'r_singleShader',
      'r_skipBackEnd',
      'r_skyname',
      'r_smp',
      'r_speeds',
      'r_stencilbits',
      'r_stereo',
      'r_subdivisions',
      'r_swapInterval',
      'r_textureMode',
      'r_texturebits',
      'r_timegraph',
      'r_uiFullScreen',
      'r_verbose',
      'r_vertexLight',
      'r_wateralpha',
      'r_waterwarp',
      'r_wolffog',
      'r_zfar',
      'r_znear',
      'rate',
      'rcon',
      'rconAddress',
      'rconPassword',
      'rcon_address',
      'rcon_password',
      'reconnect',
      'ref',
      'registered',
      'reportedgeout',
      'reportsurfout',
      'roll',
      'rollangle',
      'rollspeed',
      'round',
      'run',
      'run_pitch',
      'run_roll',
      's_compression',
      's_defaultsound',
      's_doppler',
      's_initsound',
      's_khz',
      's_loadas8bit',
      's_mixPreStep',
      's_mixahead',
      's_musicvolume',
      's_mute',
      's_nocompressed',
      's_primary',
      's_separation',
      's_show',
      's_testsound',
      's_usingA3D',
      's_volume',
      's_wavonly',
      'samelevel',
      'saturatelighting',
      'saved1',
      'saved2',
      'saved3',
      'saved4',
      'savedgamecfg',
      'scr',
      'scr_centertime',
      'scr_consize',
      'scr_conspeed',
      'scr_drawall',
      'scr_ofsx',
      'scr_ofsy',
      'scr_ofsz',
      'scr_printspeed',
      'scr_showpause',
      'scr_showturtle',
      'scratch1',
      'scratch2',
      'scratch3',
      'scratch4',
      'screenshot',
      'select',
      'sensitivity',
      'separation',
      'server1',
      'server10',
      'server11',
      'server12',
      'server13',
      'server14',
      'server15',
      'server16',
      'server2',
      'server3',
      'server4',
      'server5',
      'server6',
      'server7',
      'server8',
      'server9',
      'serverprofile',
      'sex',
      'shadows',
      'show',
      'showclamp',
      'showdrop',
      'showmiss',
      'shownet',
      'showpackets',
      'showpause',
      'showram',
      'showtrace',
      'showtris',
      'showturtle',
      'side',
      'sidesensitivity',
      'sidespeed',
      'sidethreshold',
      'size',
      'skill',
      'skin',
      'skymip',
      'snaps',
      'snd_bits',
      'snd_device',
      'snd_interp',
      'snd_loadas8bit',
      'snd_mixahead',
      'snd_noextraupdate',
      'snd_oss_mmaped',
      'snd_output',
      'snd_phasesep',
      'snd_rate',
      'snd_render',
      'snd_show',
      'snd_stereo',
      'snd_volumesep',
      'sndbits',
      'sndchannels',
      'snddevice',
      'sndspeed',
      'software',
      'sounds',
      'spectator',
      'spectator_password',
      'speeds',
      'stats',
      'stereo',
      'stipplealpha',
      'surfcacheoverride',
      'sv',
      'sv_accelerate',
      'sv_aim',
      'sv_airaccelerate',
      'sv_allowAnonymous',
      'sv_allowDownload',
      'sv_cheats',
      'sv_enforcetime',
      'sv_floodProtect',
      'sv_fps',
      'sv_friction',
      'sv_gravity',
      'sv_hostname',
      'sv_idealpitchscale',
      'sv_keywords',
      'sv_killserver',
      'sv_mapChecksum',
      'sv_master1',
      'sv_master2',
      'sv_master3',
      'sv_master4',
      'sv_master5',
      'sv_maxPing',
      'sv_maxRate',
      'sv_maxclients',
      'sv_maxrate',
      'sv_maxspeed',
      'sv_maxtic',
      'sv_maxvelocity',
      'sv_minPing',
      'sv_minqfversion',
      'sv_mintic',
      'sv_netdosprotect',
      'sv_noreload',
      'sv_nostep',
      'sv_onlyVisibleClients',
      'sv_padPackets',
      'sv_pakNames',
      'sv_paks',
      'sv_paused',
      'sv_phs',
      'sv_privateClients',
      'sv_privatePassword',
      'sv_progs',
      'sv_pure',
      'sv_reconnect_limit',
      'sv_reconnectlimit',
      'sv_referencedPakNames',
      'sv_referencedPaks',
      'sv_restartround',
      'sv_rollangle',
      'sv_rollspeed',
      'sv_running',
      'sv_serverid',
      'sv_showAverageBPS',
      'sv_showloss',
      'sv_spectalk',
      'sv_stopspeed',
      'sv_timefmt',
      'sv_timekick',
      'sv_timekick_fuzz',
      'sv_timekick_interval',
      'sv_timeout',
      'sv_timestamps',
      'sv_wateraccelerate',
      'sv_waterfriction',
      'sv_zombietime',
      'sw',
      'sw_allow_modex',
      'sw_clearcolor',
      'sw_drawflat',
      'sw_draworder',
      'sw_maxedges',
      'sw_maxsurfs',
      'sw_mipcap',
      'sw_mipscale',
      'sw_mode',
      'sw_polymodelstats',
      'sw_reportedgeout',
      'sw_reportsurfout',
      'sw_stipplealpha',
      'sw_surfcacheoverride',
      'sw_waterwarp',
      'swapinterval',
      'sys_cpustring',
      'sys_nostdout',
      'sys_sleep',
      'sys_ticrate',
      'team',
      'team_headmodel',
      'team_model',
      'teamplay',
      'teamtask',
      'temp1',
      'testblend',
      'testentities',
      'testlights',
      'testparticles',
      'testsound',
      'texturealphamode',
      'texturemode',
      'texturesolidmode',
      'timedemo',
      'timegraph',
      'timelimit',
      'timeout',
      'timescale',
      'topcolor',
      'triplebuffer',
      'ttycon',
      'ui_Q3Model',
      'ui_actualNetGametype',
      'ui_bigFont',
      'ui_browserGameType',
      'ui_browserMaster',
      'ui_browserShowEmpty',
      'ui_browserShowFriendlyFire',
      'ui_browserShowFull',
      'ui_browserShowMaxlives',
      'ui_browserShowTourney',
      'ui_browserSortKey',
      'ui_cdkeychecked',
      'ui_class',
      'ui_cmd',
      'ui_ctf_capturelimit',
      'ui_ctf_friendly',
      'ui_ctf_timelimit',
      'ui_currentMap',
      'ui_currentNetMap',
      'ui_dedicated',
      'ui_ffa_fraglimit',
      'ui_ffa_timelimit',
      'ui_gametype',
      'ui_glCustom',
      'ui_isSpectator',
      'ui_joinGametype',
      'ui_limboMode',
      'ui_limboObjective',
      'ui_limboOptions',
      'ui_limboPrevOptions',
      'ui_mapIndex',
      'ui_master',
      'ui_menuFiles',
      'ui_mousePitch',
      'ui_netGametype',
      'ui_netSource',
      'ui_notebookCurrentPage',
      'ui_objective',
      'ui_prevClass',
      'ui_prevTeam',
      'ui_prevWeapon',
      'ui_serverStatusTimeOut',
      'ui_singlePlayerActive',
      'ui_smallFont',
      'ui_spSelection',
      'ui_team',
      'ui_teamArenaFirstRun',
      'ui_team_fraglimit',
      'ui_team_friendly',
      'ui_team_timelimit',
      'ui_tourney_fraglimit',
      'ui_tourney_timelimit',
      'ui_userAlliedRespawnTime',
      'ui_userAxisRespawnTime',
      'ui_userTimeLimit',
      'ui_weapon',
      'up',
      'upsensitivity',
      'upspeed',
      'upthreshold',
      'username',
      'v_centermove',
      'v_centerspeed',
      'v_idlescale',
      'v_ipitch_cycle',
      'v_ipitch_level',
      'v_iroll_cycle',
      'v_iroll_level',
      'v_iuaw_cycle',
      'v_iyaw_cycle',
      'v_iyaw_level',
      'v_kickpitch',
      'v_kickroll',
      'v_kicktime',
      'version',
      'vertex',
      'vid',
      'vid_config_x',
      'vid_config_y',
      'vid_fullscreen',
      'vid_fullscreen_mode',
      'vid_gamma',
      'vid_height',
      'vid_mode',
      'vid_nopageflip',
      'vid_ref',
      'vid_system_gamma',
      'vid_use8bit',
      'vid_wait',
      'vid_width',
      'vid_window_x',
      'vid_window_y',
      'vid_windowed_mode',
      'vid_xpos',
      'vid_ypos',
      'viewlog',
      'viewsize',
      'vm_cgame',
      'vm_game',
      'vm_ui',
      'volume',
      'vwep',
      'waitdelay',
      'waterwarp',
      'wavonly',
      'win',
      'win_hinstance',
      'win_noalttab',
      'win_wndproc',
      'xpos',
      'yaw',
      'yawsensitivity',
      'yawspeed',
      'yawthreshold',
      'ypos',
      'zombietime',
      'ztrick',
   );
   $self->listAdd('setFamily',
      'set',
      'seta',
      'sets',
      'setu',
   );
   $self->contextdata({
      'Alias phrase' => {
         callback => \&parseAliasphrase,
         attribute => 'Identifier',
         lineending => 'Normal Text',
      },
      'Arg area' => {
         callback => \&parseArgarea,
         attribute => 'Normal Text',
         lineending => 'Normal Text',
      },
      'Arg area in sub phrase' => {
         callback => \&parseArgareainsubphrase,
         attribute => 'Normal Text',
         lineending => 'Normal Text',
      },
      'Bind phrase' => {
         callback => \&parseBindphrase,
         attribute => 'Normal Text',
         lineending => 'Normal Text',
      },
      'Comment' => {
         callback => \&parseComment,
         attribute => 'Comment',
         lineending => 'Normal Text',
      },
      'Echo' => {
         callback => \&parseEcho,
         attribute => 'String',
         lineending => 'Normal Text',
      },
      'Normal Text' => {
         callback => \&parseNormalText,
         attribute => 'Normal Text',
      },
      'String' => {
         callback => \&parseString,
         attribute => 'String',
         lineending => 'Normal Text',
      },
      'Sub phrase' => {
         callback => \&parseSubphrase,
         attribute => 'Normal Text',
         lineending => 'Normal Text',
      },
   });
   $self->deliminators('\\s||\\(|\\)|:|\\!|<|>|\\%|\\&|\\*|;|\\?|\\^|\\{|\\||\\}|,|\\+|\\~|-|=|\\/|\\\\|\\.|\\[|\\]|\\$');
   $self->basecontext('Normal Text');
   $self->keywordscase(0);
   $self->initialize;
   bless ($self, $class);
   return $self;
}

sub language {
   return 'Quake Script';
}

sub parseAliasphrase {
   my ($self, $text) = @_;
   # attribute => 'Identifier'
   # char => ' '
   # context => 'Sub phrase'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, ' ', 0, 0, 0, undef, 0, 'Sub phrase', 'Identifier')) {
      return 1
   }
   return 0;
};

sub parseArgarea {
   my ($self, $text) = @_;
   # attribute => 'String'
   # char => '"'
   # context => 'String'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '"', 0, 0, 0, undef, 0, 'String', 'String')) {
      return 1
   }
   # attribute => 'Float'
   # context => '#stay'
   # type => 'Float'
   if ($self->testFloat($text, 0, undef, 0, '#stay', 'Float')) {
      return 1
   }
   # attribute => 'Int'
   # context => '#stay'
   # type => 'Int'
   if ($self->testInt($text, 0, undef, 0, '#stay', 'Int')) {
      return 1
   }
   # attribute => 'Symbol'
   # char => ';'
   # context => '#pop'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, ';', 0, 0, 0, undef, 0, '#pop', 'Symbol')) {
      return 1
   }
   # attribute => 'Comment'
   # char => '/'
   # char1 => '/'
   # context => 'Comment'
   # type => 'Detect2Chars'
   if ($self->testDetect2Chars($text, '/', '/', 0, 0, 0, undef, 0, 'Comment', 'Comment')) {
      return 1
   }
   # attribute => 'Symbol'
   # char => '$'
   # context => 'Normal Text'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '$', 0, 0, 0, undef, 0, 'Normal Text', 'Symbol')) {
      return 1
   }
   return 0;
};

sub parseArgareainsubphrase {
   my ($self, $text) = @_;
   # attribute => 'Float'
   # context => '#stay'
   # type => 'Float'
   if ($self->testFloat($text, 0, undef, 0, '#stay', 'Float')) {
      return 1
   }
   # attribute => 'Int'
   # context => '#stay'
   # type => 'Int'
   if ($self->testInt($text, 0, undef, 0, '#stay', 'Int')) {
      return 1
   }
   # attribute => 'Comment'
   # char => '/'
   # char1 => '/'
   # context => 'Comment'
   # type => 'Detect2Chars'
   if ($self->testDetect2Chars($text, '/', '/', 0, 0, 0, undef, 0, 'Comment', 'Comment')) {
      return 1
   }
   # attribute => 'Symbol'
   # char => ';'
   # context => '#pop'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, ';', 0, 0, 0, undef, 0, '#pop', 'Symbol')) {
      return 1
   }
   return 0;
};

sub parseBindphrase {
   my ($self, $text) = @_;
   # String => 'KeyTypes'
   # attribute => 'Hex'
   # context => 'Sub phrase'
   # type => 'keyword'
   if ($self->testKeyword($text, 'KeyTypes', 0, undef, 0, 'Sub phrase', 'Hex')) {
      return 1
   }
   return 0;
};

sub parseComment {
   my ($self, $text) = @_;
   return 0;
};

sub parseEcho {
   my ($self, $text) = @_;
   # attribute => 'Symbol'
   # char => ';'
   # context => '#pop'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, ';', 0, 0, 0, undef, 0, '#pop', 'Symbol')) {
      return 1
   }
   # attribute => 'Comment'
   # char => '/'
   # char1 => '/'
   # context => 'Comment'
   # type => 'Detect2Chars'
   if ($self->testDetect2Chars($text, '/', '/', 0, 0, 0, undef, 0, 'Comment', 'Comment')) {
      return 1
   }
   return 0;
};

sub parseNormalText {
   my ($self, $text) = @_;
   # String => 'Commands'
   # attribute => 'Command'
   # context => 'Arg area'
   # type => 'keyword'
   if ($self->testKeyword($text, 'Commands', 0, undef, 0, 'Arg area', 'Command')) {
      return 1
   }
   # String => 'Variables'
   # attribute => 'Variable'
   # context => 'Arg area'
   # type => 'keyword'
   if ($self->testKeyword($text, 'Variables', 0, undef, 0, 'Arg area', 'Variable')) {
      return 1
   }
   # String => 'Actions'
   # attribute => 'Action'
   # context => '#stay'
   # type => 'keyword'
   if ($self->testKeyword($text, 'Actions', 0, undef, 0, '#stay', 'Action')) {
      return 1
   }
   # String => 'Symbols'
   # attribute => 'Symbol'
   # context => '#stay'
   # type => 'keyword'
   if ($self->testKeyword($text, 'Symbols', 0, undef, 0, '#stay', 'Symbol')) {
      return 1
   }
   # String => 'BindFamily'
   # attribute => 'Command'
   # context => 'Bind phrase'
   # type => 'keyword'
   if ($self->testKeyword($text, 'BindFamily', 0, undef, 0, 'Bind phrase', 'Command')) {
      return 1
   }
   # String => 'setFamily'
   # attribute => 'Command'
   # context => 'Alias phrase'
   # type => 'keyword'
   if ($self->testKeyword($text, 'setFamily', 0, undef, 0, 'Alias phrase', 'Command')) {
      return 1
   }
   # String => 'PrintsString'
   # attribute => 'Command'
   # context => 'Echo'
   # type => 'keyword'
   if ($self->testKeyword($text, 'PrintsString', 0, undef, 0, 'Echo', 'Command')) {
      return 1
   }
   # String => 'alias'
   # attribute => 'Command'
   # context => 'Alias phrase'
   # insensitive => 'TRUE'
   # type => 'StringDetect'
   if ($self->testStringDetect($text, 'alias', 1, 0, 0, undef, 0, 'Alias phrase', 'Command')) {
      return 1
   }
   # String => 'PrintsString'
   # attribute => 'Command'
   # context => 'Echo'
   # type => 'keyword'
   if ($self->testKeyword($text, 'PrintsString', 0, undef, 0, 'Echo', 'Command')) {
      return 1
   }
   # attribute => 'Symbol'
   # char => '$'
   # context => '#stay'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '$', 0, 0, 0, undef, 0, '#stay', 'Symbol')) {
      return 1
   }
   # attribute => 'Comment'
   # char => '/'
   # char1 => '/'
   # context => 'Comment'
   # type => 'Detect2Chars'
   if ($self->testDetect2Chars($text, '/', '/', 0, 0, 0, undef, 0, 'Comment', 'Comment')) {
      return 1
   }
   return 0;
};

sub parseString {
   my ($self, $text) = @_;
   # attribute => 'String'
   # char => '"'
   # context => '#pop'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, '"', 0, 0, 0, undef, 0, '#pop', 'String')) {
      return 1
   }
   return 0;
};

sub parseSubphrase {
   my ($self, $text) = @_;
   # String => 'Commands'
   # attribute => 'Command'
   # context => 'Arg area in sub phrase'
   # type => 'keyword'
   if ($self->testKeyword($text, 'Commands', 0, undef, 0, 'Arg area in sub phrase', 'Command')) {
      return 1
   }
   # String => 'Variables'
   # attribute => 'Variable'
   # context => 'Arg area in sub phrase'
   # type => 'keyword'
   if ($self->testKeyword($text, 'Variables', 0, undef, 0, 'Arg area in sub phrase', 'Variable')) {
      return 1
   }
   # String => 'Actions'
   # attribute => 'Action'
   # context => '#stay'
   # type => 'keyword'
   if ($self->testKeyword($text, 'Actions', 0, undef, 0, '#stay', 'Action')) {
      return 1
   }
   # String => 'Symbols'
   # attribute => 'Symbol'
   # context => '#stay'
   # type => 'keyword'
   if ($self->testKeyword($text, 'Symbols', 0, undef, 0, '#stay', 'Symbol')) {
      return 1
   }
   # String => 'BindFamily'
   # attribute => 'Command'
   # context => 'Bind phrase'
   # type => 'keyword'
   if ($self->testKeyword($text, 'BindFamily', 0, undef, 0, 'Bind phrase', 'Command')) {
      return 1
   }
   # String => 'setFamily'
   # attribute => 'Command'
   # context => 'Normal Text'
   # type => 'keyword'
   if ($self->testKeyword($text, 'setFamily', 0, undef, 0, 'Normal Text', 'Command')) {
      return 1
   }
   # String => 'PrintsString'
   # attribute => 'Command'
   # context => 'Echo'
   # type => 'keyword'
   if ($self->testKeyword($text, 'PrintsString', 0, undef, 0, 'Echo', 'Command')) {
      return 1
   }
   # String => 'alias'
   # attribute => 'Command'
   # context => 'Alias phrase'
   # type => 'StringDetect'
   if ($self->testStringDetect($text, 'alias', 0, 0, 0, undef, 0, 'Alias phrase', 'Command')) {
      return 1
   }
   # attribute => 'Comment'
   # char => '/'
   # char1 => '/'
   # context => 'Comment'
   # type => 'Detect2Chars'
   if ($self->testDetect2Chars($text, '/', '/', 0, 0, 0, undef, 0, 'Comment', 'Comment')) {
      return 1
   }
   # attribute => 'Symbol'
   # char => ';'
   # context => '#stay'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, ';', 0, 0, 0, undef, 0, '#stay', 'Symbol')) {
      return 1
   }
   # attribute => 'Int'
   # context => '#stay'
   # type => 'Int'
   if ($self->testInt($text, 0, undef, 0, '#stay', 'Int')) {
      return 1
   }
   # attribute => 'Symbol'
   # char => ';'
   # context => '#pop'
   # type => 'DetectChar'
   if ($self->testDetectChar($text, ';', 0, 0, 0, undef, 0, '#pop', 'Symbol')) {
      return 1
   }
   return 0;
};


1;

__END__

=head1 NAME

Syntax::Highlight::Engine::Kate::Quake_Script - a Plugin for Quake Script syntax highlighting

=head1 SYNOPSIS

 require Syntax::Highlight::Engine::Kate::Quake_Script;
 my $sh = new Syntax::Highlight::Engine::Kate::Quake_Script([
 ]);

=head1 DESCRIPTION

Syntax::Highlight::Engine::Kate::Quake_Script is a  plugin module that provides syntax highlighting
for Quake Script to the Syntax::Haghlight::Engine::Kate highlighting engine.

This code is generated from the syntax definition files used
by the Kate project.
It works quite fine, but can use refinement and optimization.

It inherits Syntax::Higlight::Engine::Kate::Template. See also there.

=head1 AUTHOR

Hans Jeuken (haje <at> toneel <dot> demon <dot> nl)

=head1 BUGS

Unknown. If you find any, please contact the author