use ExtUtils::MakeMaker;
use Tk::MMutil;
use Tk::Config;

my $LIBS = '-L/usr/local/lib -ljpeg';
my $INC  = '-I/usr/local/include';

if (eval { require Devel::CheckLib; 1; }) {
    my(@libpath) = map { s/^-L//; $_ } grep { /^-L/ } split / /, $LIBS;
    my(@lib)     = map { s/^-l//; $_ } grep { /^-l/ } split / /, $LIBS;
    Devel::CheckLib::check_lib_or_exit(lib => \@lib, libpath => \@libpath);
}

$min_eumm_version = 6.58;
$eumm_recent_enough = $ExtUtils::MakeMaker::VERSION >= $min_eumm_version;

if (!$eumm_recent_enough) {
    *MY::dist_core = sub {
        <<'EOF';
dist :
	$(NOECHO) $(ECHO) "Sorry, use a newer EUMM, at least version $min_eumm_version!"

EOF
    };
}

Tk::MMutil::TkExtMakefile(
    'NAME'         => 'Tk::JPEG::Lite', 
    'INC'          => $INC,
    'LIBS'         => [$LIBS],
    'EXE_FILES'    => ['tkjpeg-lite'],
    'PMLIBDIRS'    => [],
    'OBJECT'       => '$(O_FILES)',
    'VERSION_FROM' => 'Lite.pm',
    'DEFINE' => '-DHAVE_JPEGLIB_H',
    'XS_VERSION'   => $Tk::Config::VERSION,
    'dist'         => { COMPRESS => 'gzip -f9', SUFFIX => '.gz' },
    'PREREQ_PM'    => {'Tk' => 800.015 },
    ($eumm_recent_enough ?
      (META_MERGE => { resources => { repository => 'git://github.com/eserte/tk-jpeg-lite.git' },
		       configure_requires => { 
			   'Devel::CheckLib' => 0,
			   'Tk::MMutil' => 0,
			   # 'Tk::Config' => 0, - missing in CPAN indexes, because it's autogenerated
		       }
       }) : ()),
);

sub MY::postamble {
    my $postamble = "";

    if (defined $ENV{USER} && $ENV{USER} eq 'eserte' && $^O =~ /bsd/i && -f "../../perl.release.mk") {
	$postamble .= <<'EOF';

.include "../../perl.release.mk"
.include "../../perl.git.mk"

EOF
    }

    $postamble;
}
