%module uninum
/* Null terminated Unicode strings */
%typemap(in) wchar_t * %{
    $1 = Tcl_GetUnicode($input);
%}
%typemap(out) UCS2 * %{
      if($1 == NULL) result = "";
      Tcl_SetObjResult(interp,Tcl_NewUnicodeObj($1,uninum_utf16len($1)));
%}
/* This causes swig to generate code to free the result, preventing a memory leak. */
%newobject WNStrToUNStr;
%newobject UNStrToWNStr;
%newobject Tcl_ListNumberSystems;
%newobject UninumNumberSystemMaximumValue;
%{
/* Includes the header in the wrapper code */
#include "config.h"
#include "unicode.h"
#include "nsdefs.h"
extern char *UNStrToWNStr(wchar_t *,char *);
extern UCS2 *WNStrToUNStr(char *,char *);
extern char *StrGuessNumberSystem(wchar_t *);
extern char *Tcl_ListNumberSystems (int);
extern char *UninumNumberSystemMaximumValue(char *);
extern char *uninum_version(void);
%}
%include "nsdefs.h"
%include "unicode.h"
extern char *UNStrToWNStr(wchar_t *,char *);
extern UCS2 *WNStrToUNStr(char *,char *);
extern char *StrGuessNumberSystem(wchar_t *);
extern char *Tcl_ListNumberSystems (int);
extern char *uninum_version(void);
extern char *UninumNumberSystemMaximumValue(char *);
%inline %{
extern int uninum_err;
extern short uninum_ns_type;
extern UCS2 tcl_uninum_badchar;
extern int Uninum_Input_Base;
extern int Uninum_Output_Base;
extern int Uninum_Output_General_Group_Size;
extern int Uninum_Output_First_Group_Size;
extern int Uninum_Generate_Roman_With_Bar_P;
extern UCS2 Uninum_Output_Group_Separator;
%}

