#!/usr/bin/perl

# Before 'make install' is performed this script should be runnable with
# 'make test'. After 'make install' it should work as 'perl Regexp-CharClasses-Thai.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use 5.008;
use utf8;
use strict;
use warnings;
use FindBin qw($Bin);
use lib "$Bin/lib";
use blib './lib/';
use Regexp::CharClasses::Thai qw( :all );

use Test::More;
use Test::More::UTF8; #SCRIPT SHOULD RUN WITHOUT THIS, BUT WILL PRINT 'WIDE CHARACTER' WARNINGS

binmode STDOUT, ":utf8";

BEGIN {plan tests => 257};

# TWO TESTS FOR MODULE USES
BEGIN {use_ok('Regexp::CharClasses::Thai')};
BEGIN {use_ok('Test::More::UTF8')};

# TWENTY TESTS WITH KOKAI
is( 'ก' =~ /\p{IsThai}/,1,' Match for "ก" =~ /\p{IsThai}/' );
is( 'ก' =~ /\p{InThaiCons}/,1,' Match for "ก" =~ /\p{InThaiCons}/' );
is( 'ก' =~ /\p{InThaiMCons}/,1,' Match for "ก" =~ /\p{InThaiMCons}/' );
is( 'ก' =~ /\p{IsKokai}/,1,' Match for  "ก" =~ /\p{IsKokai}/');
is( 'ก' =~ /\p{InThai}/,1,' Match for  "ก" =~ /\p{InThai}/');
is( 'ก' =~ /\p{InThaiAlpha}/,1,' Match for  "ก" =~ /\p{InThaiAlpha}/');
is( 'ก' =~ /\p{InThaiCons}/,1,' Match for  "ก" =~ /\p{InThaiCons}/');
isnt( 'ก' =~ /\p{InThaiHCons}/,0,' No match for  "ก" =~ /\p{InThaiHCons}/');
is( 'ก' =~ /\p{InThaiMCons}/,1,' Match for  "ก" =~ /\p{InThaiMCons}/');
isnt( 'ก' =~ /\p{InThaiLCons}/,0,' No match for  "ก" =~ /\p{InThaiLCons}/');
isnt( 'ก' =~ /\p{InThaiDigit}/,0,' No match for  "ก" =~ /\p{InThaiDigit}/');
isnt( 'ก' =~ /\p{InThaiTone}/,0,' No match for  "ก" =~ /\p{InThaiTone}/');
isnt( 'ก' =~ /\p{InThaiVowel}/,0,' No match for  "ก" =~ /\p{InThaiVowel}/');
isnt( 'ก' =~ /\p{InThaiCompVowel}/,0,' No match for  "ก" =~ /\p{InThaiCompVowel}/');
isnt( 'ก' =~ /\p{InThaiPreVowel}/,0,' No match for  "ก" =~ /\p{InThaiPreVowel}/');
isnt( 'ก' =~ /\p{InThaiPostVowel}/,0,' No match for  "ก" =~ /\p{InThaiPostVowel}/');
isnt( 'ก' =~ /\p{InThaiPunct}/,0,' No match for  "ก" =~ /\p{InThaiPunct}/');
is( 'ก' =~ /\p{InThaiFinCons}/,1,' Match for  "ก" =~ /\p{InThaiFinCons}/');
isnt( 'ก' =~ /\p{InThaiMute}/,1,' No match for  "ก" =~ /\p{InThaiMute}/');
is( 'ก' =~ /\p{InThaiWord}/,1,' Match for  "ก" =~ /\p{InThaiWord}/');
 
# FIFTEEN TESTS WITH SARAAIMAIMALAI
is( 'ไ' =~ /\p{InThai}/,1,' Match for  "ไ" =~ /\p{InThai}/');
is( 'ไ' =~ /\p{InThaiAlpha}/,1,' Match for  "ไ" =~ /\p{InThaiAlpha}/');
is( 'ไ' =~ /\p{InThaiWord}/,1,' Match for  "ไ" =~ /\p{InThaiWord}/');
isnt( 'ไ' =~ /\p{InThaiCons}/,0,' No match for  "ไ" =~ /\p{InThaiCons}/');
isnt( 'ไ' =~ /\p{InThaiHCons}/,0,' No match for  "ไ" =~ /\p{InThaiHCons}/');
isnt( 'ไ' =~ /\p{InThaiMCons}/,0,' No match for  "ไ" =~ /\p{InThaiMCons}/');
isnt( 'ไ' =~ /\p{InThaiLCons}/,0,' No match for  "ไ" =~ /\p{InThaiLCons}/');
isnt( 'ไ' =~ /\p{InThaiDigit}/,0,' No match for  "ไ" =~ /\p{InThaiDigit}/');
isnt( 'ไ' =~ /\p{InThaiTone}/,0,' No match for  "ไ" =~ /\p{InThaiTone}/');
is( 'ไ' =~ /\p{InThaiVowel}/,1,' Match for  "ไ" =~ /\p{InThaiVowel}/');
isnt( 'ไ' =~ /\p{InThaiCompVowel}/,0,' No match for  "ไ" =~ /\p{InThaiCompVowel}/');
is( 'ไ' =~ /\p{InThaiPreVowel}/,1,' Match for  "ไ" =~ /\p{InThaiPreVowel}/');
isnt( 'ไ' =~ /\p{InThaiPostVowel}/,0,' No match for  "ไ" =~ /\p{InThaiPostVowel}/');
isnt( 'ไ' =~ /\p{InThaiPunct}/,0,' No match for  "ไ" =~ /\p{InThaiPunct}/');
is( 'ไ' =~ /\p{IsSaraaimaimalai}/,1,' Match for  "ไ" =~ /\p{IsSaraaimaimalai}/');


    my $pv = 'ข่าวนี้ได้แพร่สะพัดออกไปอย่างรวดเร็ว';
    my $prevowel_syllables = $pv  =~ s/
            (
            (?:\p{InThaiPreVowel})
            (?:
              (?:\p{InThaiDualC1}\p{InThaiDualC2})
              |
              (?:\p{InThaiCons}){1}
            )
            (?:[\p{InThaiTone}\p{InThaiCompVowel}\p{InThaiPostVowel}]){0,3}
              (?:
                (?:[\p{InThaiFinCons}\p{IsYoyak}\p{IsWowaen}]){0,5}
                (?!\p{InThaiPostVowel})
              )*
            (?:\p{InThaiMute})?
            )           
            /($1)/gx;

    print "Syllables with pre-vowels in 'ข่าวนี้ได้แพร่สะพัดออกไปอย่างรวดเร็ว' --> $pv: $prevowel_syllables\n";  # 4

#if ($prevowel_syllables == 4) { print "Syllables test succeeded.\n" } else { print "Syllables test FAILED.\n" };

# ONE TEST FOR SYLLABLE REGEX CHECK
is($prevowel_syllables, 4, "Pre-vowel syllables check (should be 4).\n");



# 42 CLASSES (BOTH In... and Is...) 
is( 'ก' =~ /\p{InThai}/,1,' Match for "ก" =~ /\p{InThai}/' );
is( 'ด' =~ /\p{InThaiAlpha}/,1,' Match for "ด" =~ /\p{InThaiAlpha}/' );
is( '้' =~ /\p{InThaiWord}/,1,' Match for "้" =~ /\p{InThaiWord}/' );
is( 'ฟ' =~ /\p{InThaiCons}/,1,' Match for "ฟ" =~ /\p{InThaiCons}/' );
is( 'ส' =~ /\p{InThaiHCons}/,1,' Match for "ส" =~ /\p{InThaiHCons}/' );
is( 'ก' =~ /\p{InThaiMCons}/,1,' Match for "ก" =~ /\p{InThaiMCons}/' );
is( 'ท' =~ /\p{InThaiLCons}/,1,' Match for "ท" =~ /\p{InThaiLCons}/' );
is( 'ใ' =~ /\p{InThaiVowel}/,1,' Match for "ใ" =~ /\p{InThaiVowel}/' );
is( 'เ' =~ /\p{InThaiPreVowel}/,1,' Match for "เ" =~ /\p{InThaiPreVowel}/' );
is( 'ะ' =~ /\p{InThaiPostVowel}/,1,' Match for "ะ" =~ /\p{InThaiPostVowel}/' );
is( 'ื' =~ /\p{InThaiCompVowel}/,1,' Match for "ื" =~ /\p{InThaiCompVowel}/' );
is( '๑' =~ /\p{InThaiDigit}/,1,' Match for "๑" =~ /\p{InThaiDigit}/' );
is( '่' =~ /\p{InThaiTone}/,1,' Match for "่" =~ /\p{InThaiTone}/' );
is( '์' =~ /\p{InThaiMute}/,1,' Match for "์" =~ /\p{InThaiMute}/' );
is( 'ๆ' =~ /\p{InThaiPunct}/,1,' Match for "ๆ" =~ /\p{InThaiPunct}/' );
is( '฿' =~ /\p{InThaiCurrency}/,1,' Match for "฿" =~ /\p{InThaiCurrency}/' );
is( 'ม' =~ /\p{InThaiFinCons}/,1,' Match for "ม" =~ /\p{InThaiFinCons}/' );
is( 'พ' =~ /\p{InThaiDualCons}/,1,' Match for "พ" =~ /\p{InThaiDualCons}/' );
is( 'พ' =~ /\p{InThaiDualC1}/,1,' Match for "พ" =~ /\p{InThaiDualC1}/' );
is( 'ร' =~ /\p{InThaiDualC2}/,1,' Match for "ร" =~ /\p{InThaiDualC2}/' );
is( 'อ' =~ /\p{InThaiConsVowel}/,1,' Match for "อ" =~ /\p{InThaiConsVowel}/' );
is( 'ก' =~ /\p{IsThai}/,1,' Match for "ก" =~ /\p{IsThai}/' );
is( 'ด' =~ /\p{IsThaiAlpha}/,1,' Match for "ด" =~ /\p{IsThaiAlpha}/' );
is( '้' =~ /\p{IsThaiWord}/,1,' Match for "้" =~ /\p{IsThaiWord}/' );
is( 'ฟ' =~ /\p{IsThaiCons}/,1,' Match for "ฟ" =~ /\p{IsThaiCons}/' );
is( 'ส' =~ /\p{IsThaiHCons}/,1,' Match for "ส" =~ /\p{IsThaiHCons}/' );
is( 'ก' =~ /\p{IsThaiMCons}/,1,' Match for "ก" =~ /\p{IsThaiMCons}/' );
is( 'ท' =~ /\p{IsThaiLCons}/,1,' Match for "ท" =~ /\p{IsThaiLCons}/' );
is( 'ใ' =~ /\p{IsThaiVowel}/,1,' Match for "ใ" =~ /\p{IsThaiVowel}/' );
is( 'เ' =~ /\p{IsThaiPreVowel}/,1,' Match for "เ" =~ /\p{IsThaiPreVowel}/' );
is( 'ะ' =~ /\p{IsThaiPostVowel}/,1,' Match for "ะ" =~ /\p{IsThaiPostVowel}/' );
is( 'ื' =~ /\p{IsThaiCompVowel}/,1,' Match for "ื" =~ /\p{IsThaiCompVowel}/' );
is( '๑' =~ /\p{IsThaiDigit}/,1,' Match for "๑" =~ /\p{IsThaiDigit}/' );
is( '่' =~ /\p{IsThaiTone}/,1,' Match for "่" =~ /\p{IsThaiTone}/' );
is( '์' =~ /\p{IsThaiMute}/,1,' Match for "์" =~ /\p{IsThaiMute}/' );
is( 'ๆ' =~ /\p{IsThaiPunct}/,1,' Match for "ๆ" =~ /\p{IsThaiPunct}/' );
is( '฿' =~ /\p{IsThaiCurrency}/,1,' Match for "฿" =~ /\p{IsThaiCurrency}/' );
is( 'ม' =~ /\p{IsThaiFinCons}/,1,' Match for "ม" =~ /\p{IsThaiFinCons}/' );
is( 'พ' =~ /\p{IsThaiDualCons}/,1,' Match for "พ" =~ /\p{IsThaiDualCons}/' );
is( 'พ' =~ /\p{IsThaiDualC1}/,1,' Match for "พ" =~ /\p{IsThaiDualC1}/' );
is( 'ร' =~ /\p{IsThaiDualC2}/,1,' Match for "ร" =~ /\p{IsThaiDualC2}/' );
is( 'อ' =~ /\p{IsThaiConsVowel}/,1,' Match for "อ" =~ /\p{IsThaiConsVowel}/' );


# 176 (88 EACH) Is... AND In... CHARACTERS
is( 'ก' =~ /\p{IsKokai}/,1,' Match for "ก" =~ /\p{IsKokai}/' );
is( 'ข' =~ /\p{IsKhokhai}/,1,' Match for "ข" =~ /\p{IsKhokhai}/' );
is( 'ฃ' =~ /\p{IsKhokhuat}/,1,' Match for "ฃ" =~ /\p{IsKhokhuat}/' );
is( 'ค' =~ /\p{IsKhokhwai}/,1,' Match for "ค" =~ /\p{IsKhokhwai}/' );
is( 'ฅ' =~ /\p{IsKhokhon}/,1,' Match for "ฅ" =~ /\p{IsKhokhon}/' );
is( 'ฆ' =~ /\p{IsKhorakhang}/,1,' Match for "ฆ" =~ /\p{IsKhorakhang}/' );
is( 'ง' =~ /\p{IsNgongu}/,1,' Match for "ง" =~ /\p{IsNgongu}/' );
is( 'จ' =~ /\p{IsChochan}/,1,' Match for "จ" =~ /\p{IsChochan}/' );
is( 'ฉ' =~ /\p{IsChoching}/,1,' Match for "ฉ" =~ /\p{IsChoching}/' );
is( 'ช' =~ /\p{IsChochang}/,1,' Match for "ช" =~ /\p{IsChochang}/' );
is( 'ซ' =~ /\p{IsSoso}/,1,' Match for "ซ" =~ /\p{IsSoso}/' );
is( 'ฌ' =~ /\p{IsShochoe}/,1,' Match for "ฌ" =~ /\p{IsShochoe}/' );
is( 'ญ' =~ /\p{IsYoying}/,1,' Match for "ญ" =~ /\p{IsYoying}/' );
is( 'ฎ' =~ /\p{IsDochada}/,1,' Match for "ฎ" =~ /\p{IsDochada}/' );
is( 'ฏ' =~ /\p{IsTopatak}/,1,' Match for "ฏ" =~ /\p{IsTopatak}/' );
is( 'ฐ' =~ /\p{IsThothan}/,1,' Match for "ฐ" =~ /\p{IsThothan}/' );
is( 'ฑ' =~ /\p{IsThonangmontho}/,1,' Match for "ฑ" =~ /\p{IsThonangmontho}/' );
is( 'ฒ' =~ /\p{IsThophuthao}/,1,' Match for "ฒ" =~ /\p{IsThophuthao}/' );
is( 'ณ' =~ /\p{IsNonen}/,1,' Match for "ณ" =~ /\p{IsNonen}/' );
is( 'ด' =~ /\p{IsDodek}/,1,' Match for "ด" =~ /\p{IsDodek}/' );
is( 'ต' =~ /\p{IsTotao}/,1,' Match for "ต" =~ /\p{IsTotao}/' );
is( 'ถ' =~ /\p{IsThothung}/,1,' Match for "ถ" =~ /\p{IsThothung}/' );
is( 'ท' =~ /\p{IsThothahan}/,1,' Match for "ท" =~ /\p{IsThothahan}/' );
is( 'ธ' =~ /\p{IsThothong}/,1,' Match for "ธ" =~ /\p{IsThothong}/' );
is( 'น' =~ /\p{IsNonu}/,1,' Match for "น" =~ /\p{IsNonu}/' );
is( 'บ' =~ /\p{IsBobaimai}/,1,' Match for "บ" =~ /\p{IsBobaimai}/' );
is( 'ป' =~ /\p{IsPopla}/,1,' Match for "ป" =~ /\p{IsPopla}/' );
is( 'ผ' =~ /\p{IsPhophung}/,1,' Match for "ผ" =~ /\p{IsPhophung}/' );
is( 'ฝ' =~ /\p{IsFofa}/,1,' Match for "ฝ" =~ /\p{IsFofa}/' );
is( 'พ' =~ /\p{IsPhophan}/,1,' Match for "พ" =~ /\p{IsPhophan}/' );
is( 'ฟ' =~ /\p{IsFofan}/,1,' Match for "ฟ" =~ /\p{IsFofan}/' );
is( 'ภ' =~ /\p{IsPhosamphao}/,1,' Match for "ภ" =~ /\p{IsPhosamphao}/' );
is( 'ม' =~ /\p{IsMoma}/,1,' Match for "ม" =~ /\p{IsMoma}/' );
is( 'ย' =~ /\p{IsYoyak}/,1,' Match for "ย" =~ /\p{IsYoyak}/' );
is( 'ร' =~ /\p{IsRorua}/,1,' Match for "ร" =~ /\p{IsRorua}/' );
is( 'ฤ' =~ /\p{IsRu}/,1,' Match for "ฤ" =~ /\p{IsRu}/' );
is( 'ล' =~ /\p{IsLoling}/,1,' Match for "ล" =~ /\p{IsLoling}/' );
is( 'ฦ' =~ /\p{IsLu}/,1,' Match for "ฦ" =~ /\p{IsLu}/' );
is( 'ว' =~ /\p{IsWowaen}/,1,' Match for "ว" =~ /\p{IsWowaen}/' );
is( 'ศ' =~ /\p{IsSosala}/,1,' Match for "ศ" =~ /\p{IsSosala}/' );
is( 'ษ' =~ /\p{IsSorusi}/,1,' Match for "ษ" =~ /\p{IsSorusi}/' );
is( 'ส' =~ /\p{IsSosua}/,1,' Match for "ส" =~ /\p{IsSosua}/' );
is( 'ห' =~ /\p{IsHohip}/,1,' Match for "ห" =~ /\p{IsHohip}/' );
is( 'ฬ' =~ /\p{IsLochula}/,1,' Match for "ฬ" =~ /\p{IsLochula}/' );
is( 'อ' =~ /\p{IsOang}/,1,' Match for "อ" =~ /\p{IsOang}/' );
is( 'ฮ' =~ /\p{IsHonokhuk}/,1,' Match for "ฮ" =~ /\p{IsHonokhuk}/' );
is( 'ฯ' =~ /\p{IsPaiyannoi}/,1,' Match for "ฯ" =~ /\p{IsPaiyannoi}/' );
is( 'ะ' =~ /\p{IsSaraa}/,1,' Match for "ะ" =~ /\p{IsSaraa}/' );
is( 'ั' =~ /\p{IsMaihanakat}/,1,' Match for "ั" =~ /\p{IsMaihanakat}/' );
is( 'า' =~ /\p{IsSaraaa}/,1,' Match for "า" =~ /\p{IsSaraaa}/' );
is( 'ำ' =~ /\p{IsSaraam}/,1,' Match for "ำ" =~ /\p{IsSaraam}/' );
is( 'ิ' =~ /\p{IsSarai}/,1,' Match for "ิ" =~ /\p{IsSarai}/' );
is( 'ี' =~ /\p{IsSaraii}/,1,' Match for "ี" =~ /\p{IsSaraii}/' );
is( 'ึ' =~ /\p{IsSaraue}/,1,' Match for "ึ" =~ /\p{IsSaraue}/' );
is( 'ื' =~ /\p{IsSarauee}/,1,' Match for "ื" =~ /\p{IsSarauee}/' );
is( 'ุ' =~ /\p{IsSarau}/,1,' Match for "ุ" =~ /\p{IsSarau}/' );
is( 'ู' =~ /\p{IsSarauu}/,1,' Match for "ู" =~ /\p{IsSarauu}/' );
is( 'ฺ' =~ /\p{IsPhinthu}/,1,' Match for "ฺ" =~ /\p{IsPhinthu}/' );
is( '฿' =~ /\p{IsBaht}/,1,' Match for "฿" =~ /\p{IsBaht}/' );
is( 'เ' =~ /\p{IsSarae}/,1,' Match for "เ" =~ /\p{IsSarae}/' );
is( 'แ' =~ /\p{IsSaraae}/,1,' Match for "แ" =~ /\p{IsSaraae}/' );
is( 'โ' =~ /\p{IsSarao}/,1,' Match for "โ" =~ /\p{IsSarao}/' );
is( 'ใ' =~ /\p{IsSaraaimaimuan}/,1,' Match for "ใ" =~ /\p{IsSaraaimaimuan}/' );
is( 'ไ' =~ /\p{IsSaraaimaimalai}/,1,' Match for "ไ" =~ /\p{IsSaraaimaimalai}/' );
is( 'ๅ' =~ /\p{IsLakkhangyao}/,1,' Match for "ๅ" =~ /\p{IsLakkhangyao}/' );
is( 'ๆ' =~ /\p{IsMaiyamok}/,1,' Match for "ๆ" =~ /\p{IsMaiyamok}/' );
is( '็' =~ /\p{IsMaitaikhu}/,1,' Match for "็" =~ /\p{IsMaitaikhu}/' );
is( '่' =~ /\p{IsMaiek}/,1,' Match for "่" =~ /\p{IsMaiek}/' );
is( '้' =~ /\p{IsMaitho}/,1,' Match for "้" =~ /\p{IsMaitho}/' );
is( '๊' =~ /\p{IsMaitri}/,1,' Match for "๊" =~ /\p{IsMaitri}/' );
is( '๋' =~ /\p{IsMaichattawa}/,1,' Match for "๋" =~ /\p{IsMaichattawa}/' );
is( '์' =~ /\p{IsThanthakhat}/,1,' Match for "์" =~ /\p{IsThanthakhat}/' );
is( '์' =~ /\p{IsGaran}/,1,' Match for "์" =~ /\p{IsGaran}/' );
is( 'ํ' =~ /\p{IsNikhahit}/,1,' Match for "ํ" =~ /\p{IsNikhahit}/' );
is( '๎' =~ /\p{IsYamakkan}/,1,' Match for "๎" =~ /\p{IsYamakkan}/' );
is( '๏' =~ /\p{IsFongman}/,1,' Match for "๏" =~ /\p{IsFongman}/' );
is( '๐' =~ /\p{IsThZero}/,1,' Match for "๐" =~ /\p{IsThZero}/' );
is( '๑' =~ /\p{IsThOne}/,1,' Match for "๑" =~ /\p{IsThOne}/' );
is( '๒' =~ /\p{IsThTwo}/,1,' Match for "๒" =~ /\p{IsThTwo}/' );
is( '๓' =~ /\p{IsThThree}/,1,' Match for "๓" =~ /\p{IsThThree}/' );
is( '๔' =~ /\p{IsThFour}/,1,' Match for "๔" =~ /\p{IsThFour}/' );
is( '๕' =~ /\p{IsThFive}/,1,' Match for "๕" =~ /\p{IsThFive}/' );
is( '๖' =~ /\p{IsThSix}/,1,' Match for "๖" =~ /\p{IsThSix}/' );
is( '๗' =~ /\p{IsThSeven}/,1,' Match for "๗" =~ /\p{IsThSeven}/' );
is( '๘' =~ /\p{IsThEight}/,1,' Match for "๘" =~ /\p{IsThEight}/' );
is( '๙' =~ /\p{IsThNine}/,1,' Match for "๙" =~ /\p{IsThNine}/' );
is( '๚' =~ /\p{IsAngkhankhu}/,1,' Match for "๚" =~ /\p{IsAngkhankhu}/' );
is( '๛' =~ /\p{IsKhomut}/,1,' Match for "๛" =~ /\p{IsKhomut}/' );

is( 'ก' =~ /\p{InKokai}/,1,' Match for "ก" =~ /\p{InKokai}/' );
is( 'ข' =~ /\p{InKhokhai}/,1,' Match for "ข" =~ /\p{InKhokhai}/' );
is( 'ฃ' =~ /\p{InKhokhuat}/,1,' Match for "ฃ" =~ /\p{InKhokhuat}/' );
is( 'ค' =~ /\p{InKhokhwai}/,1,' Match for "ค" =~ /\p{InKhokhwai}/' );
is( 'ฅ' =~ /\p{InKhokhon}/,1,' Match for "ฅ" =~ /\p{InKhokhon}/' );
is( 'ฆ' =~ /\p{InKhorakhang}/,1,' Match for "ฆ" =~ /\p{InKhorakhang}/' );
is( 'ง' =~ /\p{InNgongu}/,1,' Match for "ง" =~ /\p{InNgongu}/' );
is( 'จ' =~ /\p{InChochan}/,1,' Match for "จ" =~ /\p{InChochan}/' );
is( 'ฉ' =~ /\p{InChoching}/,1,' Match for "ฉ" =~ /\p{InChoching}/' );
is( 'ช' =~ /\p{InChochang}/,1,' Match for "ช" =~ /\p{InChochang}/' );
is( 'ซ' =~ /\p{InSoso}/,1,' Match for "ซ" =~ /\p{InSoso}/' );
is( 'ฌ' =~ /\p{InShochoe}/,1,' Match for "ฌ" =~ /\p{InShochoe}/' );
is( 'ญ' =~ /\p{InYoying}/,1,' Match for "ญ" =~ /\p{InYoying}/' );
is( 'ฎ' =~ /\p{InDochada}/,1,' Match for "ฎ" =~ /\p{InDochada}/' );
is( 'ฏ' =~ /\p{InTopatak}/,1,' Match for "ฏ" =~ /\p{InTopatak}/' );
is( 'ฐ' =~ /\p{InThothan}/,1,' Match for "ฐ" =~ /\p{InThothan}/' );
is( 'ฑ' =~ /\p{InThonangmontho}/,1,' Match for "ฑ" =~ /\p{InThonangmontho}/' );
is( 'ฒ' =~ /\p{InThophuthao}/,1,' Match for "ฒ" =~ /\p{InThophuthao}/' );
is( 'ณ' =~ /\p{InNonen}/,1,' Match for "ณ" =~ /\p{InNonen}/' );
is( 'ด' =~ /\p{InDodek}/,1,' Match for "ด" =~ /\p{InDodek}/' );
is( 'ต' =~ /\p{InTotao}/,1,' Match for "ต" =~ /\p{InTotao}/' );
is( 'ถ' =~ /\p{InThothung}/,1,' Match for "ถ" =~ /\p{InThothung}/' );
is( 'ท' =~ /\p{InThothahan}/,1,' Match for "ท" =~ /\p{InThothahan}/' );
is( 'ธ' =~ /\p{InThothong}/,1,' Match for "ธ" =~ /\p{InThothong}/' );
is( 'น' =~ /\p{InNonu}/,1,' Match for "น" =~ /\p{InNonu}/' );
is( 'บ' =~ /\p{InBobaimai}/,1,' Match for "บ" =~ /\p{InBobaimai}/' );
is( 'ป' =~ /\p{InPopla}/,1,' Match for "ป" =~ /\p{InPopla}/' );
is( 'ผ' =~ /\p{InPhophung}/,1,' Match for "ผ" =~ /\p{InPhophung}/' );
is( 'ฝ' =~ /\p{InFofa}/,1,' Match for "ฝ" =~ /\p{InFofa}/' );
is( 'พ' =~ /\p{InPhophan}/,1,' Match for "พ" =~ /\p{InPhophan}/' );
is( 'ฟ' =~ /\p{InFofan}/,1,' Match for "ฟ" =~ /\p{InFofan}/' );
is( 'ภ' =~ /\p{InPhosamphao}/,1,' Match for "ภ" =~ /\p{InPhosamphao}/' );
is( 'ม' =~ /\p{InMoma}/,1,' Match for "ม" =~ /\p{InMoma}/' );
is( 'ย' =~ /\p{InYoyak}/,1,' Match for "ย" =~ /\p{InYoyak}/' );
is( 'ร' =~ /\p{InRorua}/,1,' Match for "ร" =~ /\p{InRorua}/' );
is( 'ฤ' =~ /\p{InRu}/,1,' Match for "ฤ" =~ /\p{InRu}/' );
is( 'ล' =~ /\p{InLoling}/,1,' Match for "ล" =~ /\p{InLoling}/' );
is( 'ฦ' =~ /\p{InLu}/,1,' Match for "ฦ" =~ /\p{InLu}/' );
is( 'ว' =~ /\p{InWowaen}/,1,' Match for "ว" =~ /\p{InWowaen}/' );
is( 'ศ' =~ /\p{InSosala}/,1,' Match for "ศ" =~ /\p{InSosala}/' );
is( 'ษ' =~ /\p{InSorusi}/,1,' Match for "ษ" =~ /\p{InSorusi}/' );
is( 'ส' =~ /\p{InSosua}/,1,' Match for "ส" =~ /\p{InSosua}/' );
is( 'ห' =~ /\p{InHohip}/,1,' Match for "ห" =~ /\p{InHohip}/' );
is( 'ฬ' =~ /\p{InLochula}/,1,' Match for "ฬ" =~ /\p{InLochula}/' );
is( 'อ' =~ /\p{InOang}/,1,' Match for "อ" =~ /\p{InOang}/' );
is( 'ฮ' =~ /\p{InHonokhuk}/,1,' Match for "ฮ" =~ /\p{InHonokhuk}/' );
is( 'ฯ' =~ /\p{InPaiyannoi}/,1,' Match for "ฯ" =~ /\p{InPaiyannoi}/' );
is( 'ะ' =~ /\p{InSaraa}/,1,' Match for "ะ" =~ /\p{InSaraa}/' );
is( 'ั' =~ /\p{InMaihanakat}/,1,' Match for "ั" =~ /\p{InMaihanakat}/' );
is( 'า' =~ /\p{InSaraaa}/,1,' Match for "า" =~ /\p{InSaraaa}/' );
is( 'ำ' =~ /\p{InSaraam}/,1,' Match for "ำ" =~ /\p{InSaraam}/' );
is( 'ิ' =~ /\p{InSarai}/,1,' Match for "ิ" =~ /\p{InSarai}/' );
is( 'ี' =~ /\p{InSaraii}/,1,' Match for "ี" =~ /\p{InSaraii}/' );
is( 'ึ' =~ /\p{InSaraue}/,1,' Match for "ึ" =~ /\p{InSaraue}/' );
is( 'ื' =~ /\p{InSarauee}/,1,' Match for "ื" =~ /\p{InSarauee}/' );
is( 'ุ' =~ /\p{InSarau}/,1,' Match for "ุ" =~ /\p{InSarau}/' );
is( 'ู' =~ /\p{InSarauu}/,1,' Match for "ู" =~ /\p{InSarauu}/' );
is( 'ฺ' =~ /\p{InPhinthu}/,1,' Match for "ฺ" =~ /\p{InPhinthu}/' );
is( '฿' =~ /\p{InBaht}/,1,' Match for "฿" =~ /\p{InBaht}/' );
is( 'เ' =~ /\p{InSarae}/,1,' Match for "เ" =~ /\p{InSarae}/' );
is( 'แ' =~ /\p{InSaraae}/,1,' Match for "แ" =~ /\p{InSaraae}/' );
is( 'โ' =~ /\p{InSarao}/,1,' Match for "โ" =~ /\p{InSarao}/' );
is( 'ใ' =~ /\p{InSaraaimaimuan}/,1,' Match for "ใ" =~ /\p{InSaraaimaimuan}/' );
is( 'ไ' =~ /\p{InSaraaimaimalai}/,1,' Match for "ไ" =~ /\p{InSaraaimaimalai}/' );
is( 'ๅ' =~ /\p{InLakkhangyao}/,1,' Match for "ๅ" =~ /\p{InLakkhangyao}/' );
is( 'ๆ' =~ /\p{InMaiyamok}/,1,' Match for "ๆ" =~ /\p{InMaiyamok}/' );
is( '็' =~ /\p{InMaitaikhu}/,1,' Match for "็" =~ /\p{InMaitaikhu}/' );
is( '่' =~ /\p{InMaiek}/,1,' Match for "่" =~ /\p{InMaiek}/' );
is( '้' =~ /\p{InMaitho}/,1,' Match for "้" =~ /\p{InMaitho}/' );
is( '๊' =~ /\p{InMaitri}/,1,' Match for "๊" =~ /\p{InMaitri}/' );
is( '๋' =~ /\p{InMaichattawa}/,1,' Match for "๋" =~ /\p{InMaichattawa}/' );
is( '์' =~ /\p{InThanthakhat}/,1,' Match for "์" =~ /\p{InThanthakhat}/' );
is( '์' =~ /\p{InGaran}/,1,' Match for "์" =~ /\p{InGaran}/' );
is( 'ํ' =~ /\p{InNikhahit}/,1,' Match for "ํ" =~ /\p{InNikhahit}/' );
is( '๎' =~ /\p{InYamakkan}/,1,' Match for "๎" =~ /\p{InYamakkan}/' );
is( '๏' =~ /\p{InFongman}/,1,' Match for "๏" =~ /\p{InFongman}/' );
is( '๐' =~ /\p{InThZero}/,1,' Match for "๐" =~ /\p{InThZero}/' );
is( '๑' =~ /\p{InThOne}/,1,' Match for "๑" =~ /\p{InThOne}/' );
is( '๒' =~ /\p{InThTwo}/,1,' Match for "๒" =~ /\p{InThTwo}/' );
is( '๓' =~ /\p{InThThree}/,1,' Match for "๓" =~ /\p{InThThree}/' );
is( '๔' =~ /\p{InThFour}/,1,' Match for "๔" =~ /\p{InThFour}/' );
is( '๕' =~ /\p{InThFive}/,1,' Match for "๕" =~ /\p{InThFive}/' );
is( '๖' =~ /\p{InThSix}/,1,' Match for "๖" =~ /\p{InThSix}/' );
is( '๗' =~ /\p{InThSeven}/,1,' Match for "๗" =~ /\p{InThSeven}/' );
is( '๘' =~ /\p{InThEight}/,1,' Match for "๘" =~ /\p{InThEight}/' );
is( '๙' =~ /\p{InThNine}/,1,' Match for "๙" =~ /\p{InThNine}/' );
is( '๚' =~ /\p{InAngkhankhu}/,1,' Match for "๚" =~ /\p{InAngkhankhu}/' );
is( '๛ ' =~ /\p{InKhomut}/,1,' Match for "๛" =~ /\p{InKhomut}/' );

# ONE CHECK OF A CLASS COUNT
my @InThaiCompVowels = split(/\s+/, &InThaiCompVowel);
my $itcv = scalar @InThaiCompVowels;
is( $itcv,10,' Number of Thai Compounded Vowels' );
print "---------\nPre-Vowels: ";
      my @chars = split(/\n/,InThaiPreVowel);
      foreach my $char (@chars) {
	  chomp $char;
          print chr(hex($char));
      }

print "\n\nTesting finished.\n\n";

exit 0;
