package Stencil::Source::Awncorp;

use 5.014;

use strict;
use warnings;

our $VERSION = '0.01'; # VERSION

1;

=encoding utf8

=head1 NAME

Stencil::Source::Awncorp

=cut

=head1 ABSTRACT

Personal Perl 5 Stencil Generators

=cut

=head1 SYNOPSIS

  use Stencil::Source::Awncorp;

  1;

=cut

=head1 DESCRIPTION

This package provides Personal Perl 5 Stencil Generators.

=cut

=head1 SCENARIOS

This package supports the following scenarios:

=cut

=head2 classes

  use Stencil::Source::Awncorp::Class;

  Stencil::Source::Awncorp::Class->new

This package supports generating classes. See
L<Stencil::Source::Awncorp::Class>.

=cut

=head2 projects

  use Stencil::Source::Awncorp::Project;

  Stencil::Source::Awncorp::Project->new

This package supports generating projects. See
L<Stencil::Source::Awncorp::Project>.

=cut

=head2 roles

  use Stencil::Source::Awncorp::Role;

  Stencil::Source::Awncorp::Role->new

This package supports generating roles. See
L<Stencil::Source::Awncorp::Role>.

=cut

=head1 AUTHOR

Al Newkirk, C<awncorp@cpan.org>

=head1 LICENSE

Copyright (C) 2011-2019, Al Newkirk, et al.

This is free software; you can redistribute it and/or modify it under the terms
of the The Apache License, Version 2.0, as elucidated in the L<"license
file"|https://github.com/iamalnewkirk/stencil-source-awncorp/blob/master/LICENSE>.

=head1 PROJECT

L<Wiki|https://github.com/iamalnewkirk/stencil-source-awncorp/wiki>

L<Project|https://github.com/iamalnewkirk/stencil-source-awncorp>

L<Initiatives|https://github.com/iamalnewkirk/stencil-source-awncorp/projects>

L<Milestones|https://github.com/iamalnewkirk/stencil-source-awncorp/milestones>

L<Contributing|https://github.com/iamalnewkirk/stencil-source-awncorp/blob/master/CONTRIBUTE.md>

L<Issues|https://github.com/iamalnewkirk/stencil-source-awncorp/issues>

=cut

