package ArrayData::Lingua::Word::ID::KBBI::ByClass::Verb;

use strict;
use warnings;

use Role::Tiny::With;
#with 'ArrayDataRole::Spec::Basic';
with 'ArrayDataRole::Source::LinesInDATA';

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-11-19'; # DATE
our $DIST = 'ArrayData-Lingua-Word-ID-KBBI-ByClass-Verb'; # DIST
our $VERSION = '0.001'; # VERSION

# STATS

1;
# ABSTRACT: Indonesian verb words from KBBI (Kamus Besar Bahasa Indonesia)

=pod

=encoding UTF-8

=head1 NAME

ArrayData::Lingua::Word::ID::KBBI::ByClass::Verb - Indonesian verb words from KBBI (Kamus Besar Bahasa Indonesia)

=head1 VERSION

This document describes version 0.001 of ArrayData::Lingua::Word::ID::KBBI::ByClass::Verb (from Perl distribution ArrayData-Lingua-Word-ID-KBBI-ByClass-Verb), released on 2024-11-19.

=head1 SYNOPSIS

 use ArrayData::Lingua::Word::ID::KBBI::ByClass::Verb;

 my $ary = ArrayData::Lingua::Word::ID::KBBI::ByClass::Verb->new;

 # Iterate the elements
 $ary->reset_iterator;
 while ($ary->has_next_item) {
     my $element = $ary->get_next_item;
     ... # do something with the element
 }

 # Another way to iterate
 $ary->each_item(sub { my ($item, $obj, $pos) = @_; ... }); # return false in anonsub to exit early

 # Get elements by position (array index)
 my $element = $ary->get_item_at_pos(0);  # get the first element
 my $element = $ary->get_item_at_pos(90); # get the 91th element, will die if there is no element at that position.

 # Get number of elements in the list
 my $count = $ary->get_item_count;

 # Get all elements from the list
 my @all_elements = $ary->get_all_items;

 # Find an item (by iterating). See Role::TinyCommons::Collection::FindItem::Iterator for more details.
 $ary->apply_roles('FindItem::Iterator'); # or: $ary = ArrayData::Lingua::Word::ID::KBBI::ByClass::Verb->new->apply_roles(...);
 my @found = $ary->find_item(item => 'foo');
 my $has_item = $ary->has_item('foo'); # bool

 # Pick one or several random elements (apply one of these roles first: Role::TinyCommons::Collection::PickItems::{Iterator,RandomPos,RandomSeekLines})
 $ary->apply_roles('PickItems::Iterator'); # or: $ary = ArrayData::Lingua::Word::ID::KBBI::ByClass::Verb->new->apply_roles(...);
 my $element = $ary->pick_item;
 my @elements = $ary->pick_items(n=>3);

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/ArrayData-Lingua-Word-ID-KBBI-ByClass-Verb>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-ArrayData-Lingua-Word-ID-KBBI-ByClass-Verb>.

=head1 SEE ALSO

L<WordList::ID::KBBI::ByClass::Verb> contains the same data.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=ArrayData-Lingua-Word-ID-KBBI-ByClass-Verb>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut

__DATA__
(me)merosot
absen
abstain
abu
abuk
abus
acap
acu
ada-ada saja
adalah
adar, mengadar
adon, mengadon
adu domba
adu untung
aduk-adukan
agan
ainulyakin
ajuk
alah
alah-mengalahi
alap
alih fungsi, beralih fungsi
alup, mengalup
amat, mengamati
ambai, berambai-ambai
ambal
ambil
ambil alih
ambil-mengambil
amblas
ambrol
ambruk
ambul
ambyar
ampai
ampu
ampuni
amput, mengamput
ancai
ancam
ancuk
andak
andam
andok
anduh
anggap
anggar
anggit
anggul
angka
angkat
angkit
angkut
anglong, menganglong
angsu, mengangsu
angsur
anjak
anjal
anjang
anjlok
anjur
antamir, mengantamir
antar
antar-mengantar
antem, berantem
antih
anyam-menganyam
anyang
apkir
aplus
arak
arih, mengarih
arik
arsir
arung, mengarung
asese
aso, mengaso
asung, mengasung
atas-mengatasi
ateret
aur, mengaur
awat
awur, mengawur
awur-awuran
ayak, mengayak
ayum, mengayum
ayun-temayun
babak
babat
babit
baca
bacah
bacem
bacok
badasi
badik
bahas
bahu-membahu
bajak
bajar
bakalan
bakar
bakut
balas
balas dendam
balas-berbalas
balas-membalas
balela
baliu
bangkis
bangkit
bangkrut
bangun
banjir
banting
bantu
bantun
bantut
barbur
barut
basmi
basuh
baur
bawa
bayar
bayong
bebar
bebas tugas
beber
bebercak
bebrek
bebuyutan
becermin
bedal
bedel
bederma
bedol
bega
begadang
behandel
beka
bekam
bekap
bekerdom-kerdom
bekerja
bekerlip
bekernyut
bekernyutan
bekersik
bekertak-kertak
bekuk
belagu
belahak
belajar
belam
belandang
belangiran
belasut
belat-belit
belek
belelang
belendung
belengket
belesir
beleter
beli
belingkang
belok
belontang
belot
belu
beludak
belunjur
bembam
bencol, berbencol-bencol
bengkar
bengkelai
bengkos
bengong
bening
bentak
bentang
bentar
bentok
bentrok
bentus
benum
benyoh
beol
bepercikan
bepergian
beperkara
berabad-abad
berabang
berabarkan
berabjad
berabonemen
berabun-rabun
beracara
beracun
berada
berada-ada
beradab
beradak
beradaptasi
beradat
beradegan
beradik
beradik-berkakak
beradu
beradun
beraerobatik
berafiliasi
beraga
beragah-agah
beragak-agak
beragam
beragam-ragam
beragama
beragi
beragih
beragitasi
beragogo
beragustusan
berahasia
berair
beraja
beraja-raja
berajojing
berakad
berakal
berakan
berakar
berakhir
berakhirkan
berakibat
berakibatkan
berakikah
berakit
berakit-rakit
berakrobat
beraksara
beraksi
beraku
beraku-akuan
berakuk
berakumulasi
beralah
beralam
beralamat
beralang
beralangan
beralas
beralasan
beralaskan
beralat
beraliansi
beralih
beralih tugas
beralu-aluan
beralun
beralun-alun
beralur
beramah-ramah
beramah-ramahan
beramah-tamah
beramai-ramai
beramal
beramanat
berambai
berambau
berambil-ambil
berambin (lutut)
berambisi
berambu
berambut
berampus
beramuk
beramuk-amukan
beranak
berancang
berancang-ancang
berandai-randai
berandam
berandau
beraneh-aneh
berangan-angan
berangas
berangga
beranggapan
beranggar
beranggota
beranggotakan
berangguk
berangguk-angguk
berangin
berangin-angin
berangka
berangka-angka
berangka-angkaan
berangkai
berangkai-rangkai
berangkap
berangkat
berangkulan
berangsur
beranjang
beranjangkarya
beranjangsana
beranjung
berantai
berantai-rantai
berantara
berantas
beranting
berantisipasi
berantukan
berantun
berapat
berapi
berapit
berapresiasi
berapun
berapung-apung
berapungan
berarah
berarak-arakan
berarakan
berargumen
berargumentasi
beraris
berarisan
berariskan
berarti
berartikulasi
berasa
berasah
berasak
berasak-asak
berasak-asakan
berasal
berasap
berasap-asap
berasas
berasaskan
beraset
berasian
berasimilasi
berasing
berasing-asingan
berasio
berasmara
berasonansi
berasosiasi
beraspal
beraspirasi
berasrama
berastakona
berasuransi
beratap
beratapkan
beraturan
beraudiensi
berawa
berawa-rawa
berawak
berawal
berawalan
berawan
berawas
berawas-awas
berayah
berayal-ayalan
berayun
berayun-ayun
berazam
berbabil
berbadai
berbadan
berbadi
berbagai
berbagai-bagai
berbagat
berbagi
berbahana
berbahas-bahasan
berbahasa
berbahasan
berbahaya
berbaik
berbaik-baikan
berbaikan
berbait
berbait-bait
berbaja
berbaju
berbakat
berbakti
berbala-bala
berbalam
berbalapan
berbalas
berbalas-balasan
berbalik
berbalik-balik
berbalikan
berbaling
berbalung
berbandar
berbanding
berbangkit
berbangsa
berbanir
berbanjar
berbanjar-banjar
berbanjaran
berbantah
berbantah-bantah
berbantal
berbanyak
berbanyak-banyak
berbapak
berbarengan
berbarik-barik
berbaris
berbarut
berbasa-basi
berbasah-basah
berbasiskan
berbasut
berbatas
berbatasan
berbataskan
berbatin
berbatu
berbatuk
berbau
berbaur
berbawaan
berbawang
berbayang
berbayang-bayang
berbecak-becak
berbeda
berbeda-beda
berbedaan
berbedak
berbedil
berbedil-bedilan
berbega
berbega-bega
berbeka-beka
berbekal
berbekas
berbelah
berbelah-belah
berbelahan
berbelakang-belakangan
berbelang-belang
berbelanja
berbelaskasihan
berbelasungkawa
berbeli-beli
berbeli-belian
berbelian
berbelimbing
berbelintangan
berbelit
berbelit-belit
berbelok
berbelok-belok
berbelon
berbelongsong
berbenak
berbenang-benang
berbencah
berbencah-bencah
berbendi
berbenggil-benggil
berbengkung
berbenguk
berbenih
berbenjol
berbenteh
berbenteng
berbentol-bentol
berbentrok
berbentrokan
berbentuk
berberani-berani
berberat
berberita
berbesan
berbesar-besar
berbeta
berbeting
berbetulan
berbiak
berbicara
berbidan
berbiduk
berbiduk-biduk
berbiji
berbiku-biku
berbilik-bilik
berbimbingan
berbinar-binar
berbincang-bincang
berbingkah-bingkah
berbingkai
berbini
berbinikan
berbintang
berbintang-bintang
berbintik
berbintik-bintik
berbintil-bintil
berbiola
berbiras
berbisa
berbisik
berbisik-bisik
berbisu
berbisul
berblirik
berbobot
berboga
berbohong
berbolak-balik
berbolong-bolong
berboncengan
berbondong-bondong
berbongkah
berbongkah-bongkah
berborok
berboyong
berbuah
berbuai
berbuai-buai
berbual
berbual-bual
berbuat
berbucu
berbudak-budak
berbudaya
berbudi
berbugil
berbuih
berbuka
berbukan
berbukit
berbukit-bukit
berbukti
berbuku
berbulan
berbulang
berbulu
berbumbu
berbunga
berbunga-bunga
berbuntang
berbuntut
berbuntut-buntut
berbunuh-bunuhan
berbunyi
berburu-buru
berburuk-buruk
berbusa
berbusana
berbutir
berbutir-butir
bercabang
bercabang-cabang
bercabul
bercabut
bercacah
bercacah jiwa
bercacar
bercacat
bercaci-cacian
bercadar
bercadik
bercagak
bercahaya
bercakak
bercakap
bercakap-cakap
bercakar-cakaran
bercakrawala
bercalit
bercambang
bercampur
bercampur aduk
bercampur baur
bercampuran
bercangap
bercanggah
bercangkuk
bercantik-cantik
bercap
bercarang
bercari-cari
bercari-carian
bercarik-carik
bercarut
bercarut-carut
bercat
bercatur
bercatut
bercawak
bercawat
bercebar-cebur
bercedera
bercekah
bercekak
bercekakak cekikik
bercekakakan
bercekcok
bercekik merih
bercekikikan
bercela
bercelah
bercelak
bercelana
berceloteh
bercelur
bercemar
bercemas
bercemburu
bercemburuan
bercemetuk
bercencang
bercendawan
bercenduai
bercengkerama
bercengkih
bercepat-cepat
bercerai
bercerai-berai
bercerai-cerai
berceraian
berceramah
berceranggah
berceratukan
bercerita
bercermin
bercetak
berciap-ciap
bercinta
bercinta-cintaan
bercintakan
berciri
bercirikan
bercita-cita
berciut-ciut
bercoangan
bercompang-camping
berconteng-conteng
bercorak
bercoreng
bercoreng-coreng
bercoreng-moreng
bercucu
bercucuran
bercukai
bercuki
bercumbu
bercumbu-cumbu
bercumbu-cumbuan
bercunduk
bercuping
bercura
bercura-bura
bercuriga
bercuti
berdabus
berdada
berdada ruah
berdada-dadaan
berdadu
berdadung
berdagang
berdagang (diri)
berdaging
berdahak
berdahan
berdahanam
berdahulu-dahuluan
berdaki
berdakwa
berdakwah
berdalam-dalam
berdalih
berdalih-dalih
berdalil
berdamai
berdamar
berdambin
berdampak
berdamping
berdampingan
berdampung-dampung
berdandan
berdangdut
berdangkung
berdansa
berdansanak
berdarah
berdarmawisata
berdasar
berdasarkan
berdasi
berdatangan
berdatuk
berdaulat
berdaun
berdawai
berdawat
berdaya
berdaya guna
berdaya upaya
berdayung
berdebar-debar
berdebat
berdebu
berdebuk
berdebum
berdebur
berdebut
berdecak-decak
berdecap-decap
berdecit
berdecup
berdecup-decup
berdecut
berdecut-decut
berdedikasi
berdefile
berdegam
berdegap-degap
berdegar-degar
berdegum
berdeham
berdeham-deham
berdekap
berdekap-dekapan
berdekat
berdekat-dekat
berdekatan
berdeklamasi
berdekut
berdelan
berdembam
berdembun
berdembun-dembun
berdemonstrasi
berdempang-dempang
berdempet-dempet
berdempetan
berdencing-dencing
berdendam
berdendam-dendaman
berdendang
berdenging
berdengkang-dengkang
berdengki
berdengking
berdengkung
berdengkur
berdengkus
berdengung
berdengus
berdengut
berdengut-dengut
berdentam
berdentang
berdentang-dentang
berdenting
berdentum
berdentum-dentum
berdentuman
berdentung
berdentung-dentung
berdenyar-denyar
berdenyit
berdenyut
berdenyut-denyut
berdepak-depak
berdepan-depan
berderai
berderak
berderak-derak
berderam
berderam-deram
berderang
berderap
berderau
berderau-derau
berderet
berderik
berderik-derik
berdering
berdering-dering
berderis
berderit
berderuk
berderum
berderus-derus
berdesah
berdesain
berdesak
berdesak-desakan
berdesar
berdesau
berdesik-desik
berdesing
berdesing-desing
berdesingan
berdesir
berdesus
berdesus-desus
berdetak
berdetar
berdetas
berdetik
berdetus
berdialog
berdiam
berdiet
berdikari
berdikit-dikit
berdinas
berdinding
berdiplomasi
berdisiplin
berdiskusi
berdoa
berdogol
berdokar
berdomisili
berdosa
berdosis
berdua-dua
berduaan
berduel
berduet
berduit
berduka
berdukacita
berdukun
berduli
berdurasi
berdurhaka
berduri
berduru-duru
berdusta
berdwifungsi
bereaksi
berebab
berebana
berebut
berebut-rebut
berebut-rebutan
berebutan
beredel
berefraksi
beregang-regang
beregu
berekan
berekonomi
berekor
berekreasi
berekskursi
berekspansi
bereluk
beremas
berembuk
berembun
beremigrasi
berempap
berempati
berenak-enak
berenangan
berencana
berenceng
berenda
berenggil
berengkau
berengsaan
berengsel
berentang
berenteng-renteng
berentetan
berereksi
bererotan
beresa-esaan
beresah-resah
berevakuasi
berevolusi
berfaedah
berfalsafah
berfantasi
berfatwa
berfirman
berfitrah
berfluktuasi
berfokus
berfoto
berfungsi
berfusi
bergabung
bergadai
bergading
bergaduh
bergaduk
bergagap-gagap
bergairah
bergala
bergalah
bergalang
bergalat
bergalur-galur
bergambar
bergambuh
bergamitan
berganda
bergandeng
bergandengan
berganding
bergandingan
berganduh
bergandung
berganggang
berganjal
berganjur
berganjur-ganjur
berganti
berganti-ganti
bergantung
bergantungan
bergarah
bergarah-garah
bergaram
bergaransi
bergaris
bergasing
bergaun
bergaung
bergaya
bergaya-gaya
bergayung
bergayutan
bergegar
bergegas-gegas
bergejolak
bergelagaran
bergelambir
bergelang-gelang
bergelanggang
bergelantungan
bergelap-gelap
bergelar
bergelayutan
bergelegar
bergelembung
bergelemprang
bergelendotan
bergeleng
bergeleng-geleng
bergelimpangan
bergelombang
bergelora
bergelung
bergema
bergemar
bergembira
bergembok
bergembung
bergempa
bergendak
bergendakan
bergendang
bergengsi
bergenre
bergentar
bergentayangan
bergerak
bergerayangan
bergeretak
bergerilya
bergerincing
bergerocok
bergeseran
bergetah
bergetar
bergiat
bergigi
bergilir-gilir
bergiliran
bergincu
bergiwang
bergizi
bergolak-golak
bergolek-golek
bergolekan
bergolok
bergonjong
bergontokan
bergosip
bergosok
bergosokan
bergotong royong
bergoyah
bergoyang
bergoyang-goyang
bergranula
berguam
berguguran
bergugus-gugus
bergula
bergulat
bergulingan
bergulung
bergumam
bergumpal
berguna
berguncang
bergundu
bergunduk-gunduk
bergundul
bergunjing
bergunung-gunung
bergurau
bergurindam
berguru
berguselan
berguyub
berhabis
berhad
berhadap-hadapan
berhadapan (dng)
berhadiah
berhajat
berhaji
berhak
berhakim
berhal
berhala
berhalalbihalal
berhalangan
berhaluan
berhamba
berhampiran (dng)
berhamun-hamun
berhandai-handai
berhantam
berhantu
berhanyut
berhanyut-hanyut
berharap
berharapan
berharapkan
berharga
berhari
berharta
berhasil
berhasrat
berhati
berhati-hati
berhawa
berhektare-hektare
berhelai
berhelat
berhemat
berhenti
berhiaskan
berhidangan
berhidung
berhijau daun
berhikayat
berhikmah
berhilau-hilau
berhiliran
berhina
berhindu
berhingga
berhipotesis
berhitung
berhoki
berhormat
berhormat-hormat
berhubungan
berhujah
berhujan
berhujan-hujan
berhukum
berhulu
berhulukan
berhuma
berhura-hura
berhuruf
beri
beri tahu
beri-memberi
beria
beria-ia
beria-ria
beriak
beriak-riak
berias
beriba-iba
beribadah
beribadat
beribarat
beribu
beridentitas
berideologi
berigi-rigi
berihat
berihram
berijab
berijazah
berijmak
berijtihad
berikan
berikat
berikhtiar
beriklim
berikrar
beriktikad
berikut
berilah
berilmu
berima
beriman
berimankan
berimbang
berimbas
berimigrasi
berimpit-impit
berimpitan
berimplikasi
berimprovisasi
berinai
berinaian
berindikasi
berinduk
berinfiltrasi
berinfleksi
beringat
beringat-ingat
beringgit-ringgit
berinisial
berinisiatif
berinkarnasi
berinsang
berintegrasi
berinteraksi
berintik-rintik
berintrospeksi
berinvasi
berinvestasi
beripar
beripuh
berirama
beriring-iring
beriring-iringan
berisi
beristigfar
beristikharah
beristirahat
beristri
beristrikan
beriuran
beriwayat
berjaga
berjaga-jaga
berjagal
berjagung-jagung
berjahat
berjaipong
berjajan
berjajar
berjalan
berjalan-jalan
berjalar-jalar
berjalin-jalin
berjalinan
berjalur
berjalur-jalur
berjambar
berjambul
berjampi
berjamrah
berjamu
berjamur
berjangka
berjangkitan
berjanjang
berjanji
berjantan
berjantang
berjantung
berjarak
berjaram
berjari-jari
berjarum
berjasa
berjasad
berjatuh
berjatuhan
berjauh
berjauh-jauhan
berjauhan
berjawab
berjaya
berjeda
berjegal-jegalan
berjejak
berjejal-jejal
berjela-jela
berjelaga
berjelapakan
berjeluk
berjemaah
berjenaka
berjengkengan
berjengkot
berjenjang
berjentera
berjerawat
berjerih
berjermang
berjerumat
berjibun
berjihad
berjilid
berjilid-jilid
berjimak
berjimat
berjinak-jinak
berjingkat-jingkat
berjingkik-jingkik
berjingkrak-jingkrak
berjinjang
berjiran
berjiwa
berjodoh
berjogar
berjoget
berjompakan
berjongkok
berjongkok-jongkok
berjoran
berjotos
berjual
berjual beli
berjualan
berjubel-jubel
berjudi
berjudul
berjujut-jujutan
berjulai
berjulai-julai
berjulat
berjulo-julo
berjumat
berjumbai
berjumbaian
berjumlah
berjumpa
berjunjungan
berjuntai-juntai
berjurai
berjurai-jurai
berjuraian
berkabar
berkabu-kabu
berkabung
berkabut
berkaca
berkacamata
berkacau
berkafan
berkain
berkaing-kaing
berkait
berkait-kaitan
berkaitan
berkajang
berkakak
berkakakan
berkaki
berkala
berkala-kala
berkalang
berkaliber
berkalung
berkamar
berkambi
berkamit-kamit
berkampaian
berkampanye
berkampuh
berkamu
berkamuflase
berkandul
berkandung
berkandungan
berkang
berkanji
berkantong
berkantor
berkaok-kaok
berkapak
berkapal
berkapar
berkaparan
berkapas
berkapasitas
berkapitulasi
berkarang
berkaraoke
berkarat
berkarib
berkarier
berkarpet
berkarung
berkarya
berkasak-kusuk
berkasidah
berkasih
berkasih-kasihan
berkata
berkata-kata
berkatak-katak
berkategori
berkaul
berkaum
berkaus
berkaveling
berkawal
berkawan
berkawin
berkayu
berkayuh
berkeadilan
berkeahlian
berkeberatan
berkebetulan
berkebun
berkecai-kecai
berkecambah
berkecandan
berkecek-kecek
berkecenderungan
berkecepatan
berkeciak
berkecibakan
berkecil hati
berkecil-kecil
berkecil-kecilan
berkecimpung
berkecipak
berkecondongan
berkecuali
berkecukupan
berkecumik
berkedai
berkedal
berkedip
berkedip-kedip
berkedok
berkedudukan
berkedut
berkegiatan
berkehendak
berkeinginan
berkejang
berkejang-kejang
berkejap
berkejap-kejap
berkejar-kejaran
berkeji
berkeji diri
berkejut, kejut telinga
berkejutan
berkekalan
berkekurangan
berkeladak
berkelahi
berkelainan
berkelakar
berkelam
berkelambu
berkelamin
berkelana
berkelanjutan
berkelar
berkelar-kelar
berkelas
berkelebatan
berkelembapan
berkelepai-kelepai
berkeletah
berkelibangan
berkelijak
berkeliling
berkelim
berkelip
berkelip-kelip
berkelit-kelit
berkelok
berkelok-kelok
berkelompok
berkelompok-kelompok
berkelong
berkelopak
berkeluarga
berkeluh
berkeluk
berkelukuran
berkelumun
berkemah
berkemampuan
berkemas
berkemban
berkembang
berkembar
berkembur-kembur
berkemeja
berkemendang
berkemih
berkemudi
berkena-kenaan
berkenaan
berkenal-kenalan
berkenalan
berkencan
berkendara
berkendaraan
berkendur-kendur
berkenduri
berkentut
berkeok-keok
berkeokan
berkepak
berkepak-kepak
berkepala
berkepang
berkepentingan
berkeping-keping
berkepit
berkepuk
berkepul
berkepul-kepul
berkeputusan
berkerabat
berkerabu
berkerah
berkerak
berkeramas
berkerang
berkeras
berkeras-kerasan
berkereket
berkereta
berkereta api
berkericauan
berkering-kering
berkeringat
berkeriput
berkeris
berkerisik
berkeriuk
berkeriut
berkeriutan
berkeroncongan
berkerotak
berkerudung
berkeruh
berkeruit-keruit
berkerunyut
berkerut
berkerut-kerut
berkeruyuk
berkesampaian
berkesan
berkesempatan
berkesesuaian
berkeset
berkesimpulan
berkesinambungan
berkesudahan (dng)
berkesungguhan
berketak
berketak-ketak
berketak-ketik
berketakutan
berketam
berketap-ketip
berketar-ketar
berketentuan
berketepatan
berketetapan
berketua
berketuk
berketuk-ketak
berketul-ketul
berkewajiban
berkeyakinan
berkhalwat
berkhamir
berkhasiat
berkhayal
berkhianat
berkhidmat
berkhitan
berkhotbah
berkial
berkial-kial
berkias
berkias-kias
berkias-kiasan
berkibar-kibar
berkibaran
berkiblat
berkicau
berkicut
berkikir
berkilah
berkilah-kilah
berkilap
berkilap-kilap
berkilat
berkilat-kilat
berkilatan
berkilau
berkilau-kilauan
berkincir
berkinerja
berkinja-kinja
berkinte
berkipas
berkipas-kipas
berkiprah
berkira-kira
berkirai
berkirim-kiriman
berkiriman
berkisah
berkisar
berkisar-kisar
berkisaran
berkisi
berkitab
berkoak-koak
berkoalisi
berkoar-koar
berkobar-kobar
berkobok-kobok
berkocak
berkocak-kocak
berkokok
berkolaborasi
berkolek-kolek
berkolokasi
berkolusi
berkomat-kamit
berkombinasi
berkomentar
berkompanyon
berkomplot
berkompromi
berkomunikasi
berkongkalikong
berkongsi
berkonsultasi
berkontak
berkontemplasi
berkontraksi
berkooperasi
berkoordinasi
berkop
berkoperasi
berkoran
berkorban
berkorelasi
berkoreng
berkorespondensi
berkorong
berkostum
berkotak-kotak
berkotek
berkreasi
berkuah
berkuala
berkualifikasi
berkualitas
berkuasa
berkuat-kuat
berkuat-kuatan
berkubah
berkubak
berkubang
berkubu
berkubur
berkucak
berkuda
berkudis
berkudung
berkujut
berkuku
berkukuh
berkukus
berkulaian
berkulat
berkuli
berkuliah
berkulit
berkulup
berkumai
berkumandang
berkumis
berkumpai
berkumur-kumur
berkunang-kunang
berkundang
berkunjung-kunjungan
berkupak
berkuping
berkurai
berkurang
berkurap
berkurban
berkurik-kurik
berkurung
berkusuk
berkusut-kusut
berkuteks
berkutu
berkutu-kutuan
berkutub
berlaba
berlabel
berlabuh
berladang
berladung
berlaga
berlagak
berlagu
berlahar
berlain-lainan
berlaju-laju
berlajur
berlaki
berlakon
berlaku
berlaku lajak
berlalai-lalai
berlalu
berlalu lintas
berlambak
berlambak-lambak
berlambang
berlambangkan
berlambat
berlampang-lampang
berlamparan
berlampu
berlancang
berlancing
berlandasan
berlandaskan
berlangganan
berlanggar-langgar
berlangir
berlangkah
berlanglang
berlangsi
berlangsung
berlanjut
berlanjutan
berlantai
berlantas
berlantung
berlapik
berlapis
berlapis-lapis
berlapuk
berlarasan
berlarat-larat
berlari
berlari-lari
berlari-larian
berlarian
berlarik
berlarik-larik
berlauk
berlawak-lawak
berlawalata
berlawan
berlawanan
berlayap-layapan
berlayapan
berlayar
berlebaran
berlebih
berlecah
berlegung
berleha-leha
berlekas-lekasan
berlekat
berlekat-lekat
berlekatan
berlekuk
berlekuk-lekuk
berlela
berlelehan
berleleran
berlelewa
berleluasa
berlelucon
berlemak
berlembaga
berlempar-lemparan
berlempuk
berlena
berlena-lena
berlengah-lengah
berlenggak-lenggok
berlenggek
berlenggek-lenggek
berlenggok-lenggok
berlengkap
berlengkapan
berlengket
berlengkok
berlengkokan
berlenso
berlenting
berlepas
berlereng
berleret
berleret-leret
berlesehan
berlesir
berletih
berletih-letih
berleting
berlewatan
berlezat
berliang-liuk
berlibat-libat
berlibur
berlidah
berlik
berliku-liku
berlilit
berlimau
berlimpa
berlimpah-limpah
berlimpap-limpap
berlingkar
berlinyak
berlipat
berlipat ganda
berlipat-lipat
berlistrik
berliur
berlokakarya
berlokasi
berlomba
berlomba-lomba
berlompatan
berloncat-loncatan
berloncatan
berlonggok
berlonggoklonggok
berlontaran
berlopak-lopak
berlubang
berlubang-lubang
berludah
berluk
berluluk
berlulut
berlumpur
berlumuran
berlumus
berlumut
berlumutan
berlurah
berlutut
bermaaf-maafan
bermabuk-mabukan
bermadah
bermadat
bermadu
bermagang
bermahkota
bermain
bermain-main
bermakam
bermakmum
bermakna
bermakrifat
bermaksud
bermalaikan
bermalam
bermalam-malam
bermalas-malas
bermalu
bermamai
bermanah
bermandi
bermandikan
bermanfaat
bermanik-manik
bermanis
bermanis-manis
bermanja-manja
bermantel
bermanuver
bermara
bermarkas
bermartabat
bermasak-masak
bermasyarakat
bermata
bermatakan
bermatian
bermatikan
bermaulid
bermaulidurasul
bermayang
bermazhab
bermazmur
bermeditasi
bermegah
bermegah-megah
bermemek-memek
bermenantu
bermenantukan
bermengkal
bermenung-menung
bermerek
bermerger
bermesin
bermesra-mesraan
bermesraan
bermesum
bermeterai
bermewah-mewah
bermewah-mewahan
bermigrasi
bermimpi
berminat
bermini
berminta
berminta-minta
berminyak
berminyak-minyak
bermiripan
bermisai
bermitra
bermobil
bermodal
bermodalkan
bermohon
bermoncong
bermonolog
bermoral
bermotif
bermotor
bermuara
bermuatan
bermuda
bermuda-muda
bermudah-mudah
bermudarat
bermufakat
bermuka
bermuka-muka
bermukah
bermukim
bermula
bermuluk-muluk
bermulut
bermulut-mulut
bermunajat
bermunculan
bermuram
bermusik
bermusim
bermusuh
bermusuhan
bermusyawarah
bermutu
bermuwajahah
bernada
bernafiri
bernafsi-nafsi
bernafsu
bernalam
bernalar
bernama
bernanah
bernanti-nanti
bernantian
bernapas
bernapaskan
bernasib
bernazar
bernegara
berniaga
berniat
berniat-niat
bernilai
bernitrogen
bernoda
bernomor
bernostalgia
bernubuat
bernyala
bernyala-nyala
bernyali
bernyawa
berobat
beroda
berodi
berogak-ogak
beroksigen
berolah
berolahraga
berolak
beroleh
beroleng-oleng
berolok-olok
berombak
beromong-omong
beromzet
berona
berondok
berondong
berongga
beronggok-onggok
berongkol
berontak
beroperasi
beroplah
berorasi
berorganisasi
berorientasi
berotak
berotan
berotasi
berotonomi
beroyal-royal
berpacangan
berpacaran
berpacu
berpadan
berpadanan
berpadang
berpadi
berpadu
berpadu-padu
berpagar
berpagutan
berpahala
berpaham
berpahat
berpahit-pahit
berpair-pair
berpakaian
berpakan
berpakankan
berpakansi
berpakat
berpaku
berpal-pal
berpalit
berpalu-palu
berpalu-paluan
berpalut
berpaman
berpameran
berpamitan
berpamor
berpanas
berpanas-panas
berpancaran
berpancuran
berpandai-pandai
berpandang-pandangan
berpandangan
berpandu
berpandukan
berpangkal
berpangkal tolak
berpangkalan
berpangkat
berpangsa
berpangsi
berpantang
berpantun
berpantun-pantun
berparade
berparak
berparap
berpariwisata
berpartai
berpartisipasi
berpartner
berparut
berpasang
berpasang-pasangan
berpaspor
berpasrah
berpatam
berpatroli
berpatungan
berpatutan
berpautan (dng)
berpawai
berpaya
berpayah-payah
berpayudara
berpayung
berpecah
berpecah belah
berpecahan
berpedoman
berpegangan
berpelajaran
berpelana
berpelatuk
berpelepah
berpelitur
berpeluang
berpeluh
berpeluh-peluh
berpeluk
berpeluk-pelukan
berpelukan
berpematang
berpembawaan
berpembuluh
berpemerintahan
berpenampilan
berpenaruhan
berpenat-penat
berpencar-pencar
berpencaran
berpendar
berpendar-pendar
berpendaran
berpending
berpendirian
berpenerangan
berpenetrasi
berpengairan
berpengalaman
berpengantin
berpengaruh
berpengetahuan
berpenggal-penggal
berpenggalan
berpengharapan
berpenghuni
berpentas
berpentol
berpepat
berperahu
berperan
berperan serta
berperang
berperang-perangan
berperangai
berperawakan
berperi
berperikemanusiaan
berperistiwa
berperut
berpesan
berpesawat
berpesiar
berpesta
berpesta pora
berpesta-pesta
berpesuk-pesuk
berpetak
berpetam
berpetaruh
berpetuah
berpialang
berpiama
berpicing
berpidana
berpidato
berpihak
berpihak-pihak
berpijak
berpijar
berpijar-pijar
berpikir
berpikir-pikir
berpikiran
berpiknik
berpilih-pilih
berpilin
berpilin-pilin
berpilis
berpilu
berpinak
berpinar-pinar
berpindah
berpindah-pindah
berpinggang
berpinta
berpintal-pintal
berpirau-pirau
berpisah
berpisah-pisah
berpita
berpiuh
berpiuh-piuh
berpiutang
berpokok
berpola
berpolemik
berpoligami
berpolitik
berpondong
berpongah-pongah
berponi
berpontang-panting
berporah-porah
berpori
berpose
berpotensi
berpotong
berpotong-potong
berpotong-potongan
berpotret
berprakarsa
berpraktik
berprestasi
berprestise
berpretensi
berprinsip
berproduksi
berprofesi
berpropaganda
berproses
berpuak-puak
berpuaka
berpual-pual
berpuas diri
berpuasa
berpucuk
berpuing-puing
berpuisi
berpukas
berpukas-pukas
berpulang
berpulasan
berpunuk
berpunya
berpupur
berpuput
berpuru
berpusaka
berpusar
berpusar-pusar
berpusat
berpusing
berpusing-pusing
berpusu
berpusu-pusu
berputar
berputar lidah
berputar-putar
berputik
berputra
berputrakan
berpuyan
berrumpun-rumpun
bersabar
bersabda
bersabuk
bersabun
bersabung
bersado
bersafar
bersafari
bersagar
bersahabat
bersahap
bersahut
bersahut-sahutan
bersahutan
bersaingan
bersajak
bersakit-sakit
bersalah
bersalah-salahan
bersalahan
bersalai
bersalam
bersalam-salaman
bersalaman
bersalat
bersalin
bersalin-salin
bersalip-salipan
bersalju
bersalto
bersaluir
bersaluk
bersalung
bersalut
bersama
bersama-sama
bersamaan
bersambang
bersambar-sambaran
bersambung tangan
bersambungan
bersambut
bersambut-sambutan
bersambutan
bersampan
bersampan-sampan
bersamping
bersampingan
bersampiran
bersampuk
bersampul
bersanak
bersanat
bersandal
bersandar
bersandarkan
bersanding
bersandiwara
bersangga
bersanggakan
bersanggul
bersangka
bersangkak
bersangkal
bersangkar
bersangkut paut
bersangkutan
bersanksi
bersantai
bersantai-santai
bersapa
bersapa-sapaan
bersapaan
bersara
bersarak
bersarang
bersarang-sarang
bersarasehan
bersarung
bersasaran
bersatu
bersaudara
bersauh
bersawah
bersawala
bersayap
berseakan
bersebab
bersebadan
bersebambangan
bersebaran
bersebelahan
berseberangan
bersecepat
bersedan-sedan
bersedekah
bersedia
bersedia-sedia
bersedih
bersedu
bersedu-sedu
bersegeh
bersegel
bersegera
bersegi
bersegmen
bersehadap
bersejarah
bersejengket
bersejuk
bersejuk-sejuk
bersekat
bersekat-sekat
berseketiduran
bersekolah
bersekongkol
bersekresi
bersekutu
bersel
bersela
berselam
berselamatan
berselancar
berselang
berselang-selang
berselang-seli
berselang-seling
berselang-tenggang
berselaput
berselawat
berselekeh
berselekoh
berselempang
berselendang
berselera
berselesa
berselimut
berselimutkan
berselingkuh
berselisih
berselit sepit
berselit-selit
berseloka
berseloroh
berseloyong
berseluar
berselubung
berseluk
berseluk-beluk
berseluncur
berselurus
bersemadi
bersemak
bersemangat
bersemarak
bersembah
bersembahyang
bersembayan
bersembilan
bersemboyan
bersembunyi
bersembunyi-sembunyian
bersembur-semburan
bersemburan
bersemburit
bersememeh
bersemen
bersemenda
bersemi
bersemir
bersempadan, (- dng)
bersempang
bersempena
bersempit-sempit
bersemprong
bersemuka
bersenam
bersenandung
bersenang
bersenang-senang
bersenang-senangkan
bersenapan
bersenda gurau
bersenda-senda
bersendeng
bersendengan
bersendi
bersendi-sendi
bersendikan
bersendiri
bersendu
bersengaja
bersengat
bersenggang
bersenggang-senggang
bersenggat
bersenggayutan
bersenggolan
bersenggulung
bersengkela
bersengkelit
bersengketa
berseni
bersenjata
bersenjatakan
bersentosa
bersentuhan
bersenyawa
bersep (kpd)
bersepadan
bersepah-sepah
bersepaian
bersepak bola
bersepak-sepakan
bersepakat
bersepan
bersepatu
bersepeda
bersepi-sepi
bersepuh
berserabut
berseragam
berserakan
berserama
berseranjang
berserat
berseregang
berserenjang
berseri
berseri-seri
berserikat
berseru
berseru-seru
berserupa
bersesak-sesak
bersesal, sesal hati
bersesalan
bersesuai
bersesuaian
bersetekan
bersetelan
berseteru
bersetrika
bersetrip
bersetubuh
bersetuju
bersetujuan
bersetumpu
bersetunggang
bersia-sia
bersiaga
bersialang
bersiang
bersiap
bersiap sedia
bersiap-siap
bersiar-siar
bersiasat
bersibak
bersibar
bersibunuh
bersicakar
bersicengang
bersicepat
bersidahulu
bersidang
bersifat
bersigai
bersigap
bersijengket
bersijundai
bersikap
bersikejar
bersikeras
bersiku
bersikudidi
bersikut-sikutan
bersikutan
bersila
bersilaju
bersilang
bersilangan
bersilap
bersilat
bersilaturahmi
bersilih
bersilir-silir
bersimaharajalela
bersimbang
bersimbol
bersimbur-simburan
bersimpai
bersimpan
bersimpang
bersimpang siur
bersimpangan
bersimpati
bersimpuh
bersin
bersinambung
bersinar
bersinergi
bersinetron
bersinggah
bersirip
bersisa
bersisi
bersisian
bersisik
bersisir
bersistem
bersitabik
bersitegang
bersiteguh
bersiul
bersiung
bersiut
berskala
bersoal
bersobat
bersol
bersolek
bersombong
bersongkok
bersongsong
bersopan santun
bersopan-sopan
bersorak
bersorak-sorai
bersosialisasi
bersosok
berspekulasi
berspesialisasi
berstatus
berstempel
berstrata
berstruktur
bersuami
bersuap
bersuap-suapan
bersuar
bersuara
bersubang
bersubsidi
bersuci
bersudah
bersudah-sudah
bersudikan
bersugi
bersuh
bersuit
bersuji
bersujud
bersuka-suka
bersuka-sukaan
bersukacita
bersukaria
bersukat
bersuku-suku
bersulam
bersulap
bersuling
bersuluh
bersuluhkan
bersuluk
bersulur
bersumber
bersumbu
bersumpah
bersumur
bersunat
bersundal
bersundut
bersungguh-sungguh
bersungkawa
bersungkup
bersungut
bersungut-sungut
bersunting
bersuntingkan
bersunyi
bersunyi-sunyi
bersurai
bersurat
bersurih
bersuruk-surukan
bersurukan
bersusah
bersusah hati
bersusah payah
bersusah-susah
bersusila
bersusu
bersusuk
bersusuk-susuk
bersusuk-susukan
bersusun
bersutan
bersutan-sutan
bersyahadat
bersyair
bersyarah
bersyarat
bersyarikat
bersyubhat
bersyukur
bertabiat
bertabir
bertablig
bertabrakan
bertabur-tabur
bertaburan
bertaburkan
bertadah
bertadarus
bertafakur
bertagar
bertahajud
bertahak
bertahalul
bertahan
bertahan-tahan
bertahana
bertahap
bertaharah
bertahkim
bertahu-tahu
bertahuan
bertahukan
bertaji
bertajuk-tajuk
bertakdir
bertakhta
bertaki
bertakik
bertakik-takik
bertaklid
bertaklik
bertakuk
bertakwa
bertakziah
bertala-tala
bertali
bertali-tali
bertalian
bertalun-talun
bertamadun
bertamasya
bertambah
bertambah-tambah
bertambak
bertambatkan
bertambul
bertambun
bertampan
bertampar
bertampuk
bertampung
bertamsil
bertamu
bertanah
bertanda
bertanda tangan
bertanda-tandaan
bertandak
bertanding
bertandu
bertanduk
bertangan
bertangga
bertanggal
bertanggam
bertanggung jawab
bertangis-tangisan
bertangisan
bertangkup
bertani
bertanjak
bertanti
bertanya
bertanya-tanya 1
bertapa
bertapak
bertapakkan
bertara
bertaraf
bertarah
bertarak
bertarap
bertarawih
bertari
bertarik-tarikan
bertaruh
bertaruhan
bertaruk
bertarungan
bertasawuf
bertasbih
bertasyakur
bertasyhid
bertatahkan
bertatap-tatapan
bertatapan
bertatar
bertauliah
bertawakal
bertawar-tawaran
bertawaran
bertayamum
berteater
bertebu-tebu
bertedengan
berteduh
berteduhkan
bertegah
bertegak
berteguh
berteguh-teguh
berteguh-teguhan
berteguran
berteka-teki
bertekad
bertekak
bertekap
bertekat
bertekatkan
bertekstur
bertekuk
bertekun
bertekur
bertelabat
bertelangkup
bertelanjang
bertelau-telau
bertelempong
bertelepon
bertelepuk
bertelepukan
bertelinga
bertelur
bertemakan
berteman
bertembuk-tembuk
bertemin
bertempap
bertempat
bertemperamen
bertempiaran
bertempias
bertempik
bertempoh
bertemu
bertemu duga
bertenaga
bertenang-tenang
bertendensi
bertenggang
bertenggang-tenggangan
bertengkaran
bertengkelek
bertengking
bertengkuluk
bertentang
bertentangan
bertentu
bertenun
bertenung
bertepas
bertepat guna
bertepatan
bertepek-tepek
bertepi
bertepikan
bertepuk
bertepung
bertera
berterali
berteralikan
berterang-terang
berterang-terangan
berteras
berteraskan
berterawang
berteriak
berteriak-teriak
berterima
berterima kasih
bertertib
berterus terang
bertesmak
bertetakan
bertetangga
bertetesan
bertian
bertiang
bertiarap
bertikai
bertikam-tikaman
bertikas
bertilam
bertimba
bertimbakan
bertimbal
bertimbal-timbalan
bertimbang
bertimbangan
bertimbun
bertimbun-timbun
bertindak
bertindih
bertindihan
bertinggal
bertingkah
bertingkah-tingkah
bertingkat
bertingkat-tingkat
bertinjau-tinjauan
bertinju
bertipuan
bertiras-tiras
bertitah
bertitel
bertitik
bertitik-titik
bertiup
bertiwikrama
bertobat
bertoboh-toboh
bertogok
bertohor
bertoko
bertokoh
bertokok
bertolak
bertolak-tolak
bertolak-tolakan
bertoleransi
bertolong-tolongan
bertonase
bertongkat
bertonjol
bertonjol-tonjol
bertopang
bertopangkan
bertopeng
bertopi
bertopik
bertransmigrasi
bertua-tua
bertua-tuaan
bertuah
bertual-tual
bertualang
bertualangan
bertuam
bertuan
bertuang
bertuankan
bertubrukan
bertubuh
bertudung
bertugas
bertuhan
bertuhankan
bertujuan
bertukang
bertukar
bertukar-tukar
bertukar-tukaran
bertukaran
bertukuk
bertulang
bertumbuh
bertumbuhan
bertumbuk
bertumbukan
bertumis
bertumpak-tumpak
bertumpu
bertumpuk-tumpuk
bertumpukan
bertunas
bertunda
bertundangan
bertunggang
bertunjuk-tunjukan
bertuntun
berturap
berturun
berturut-turut
berturuti
bertutup
bertutur
bertutur-tutur
beruas-ruas
berubah-ubah
beruban
berucap
berudu
berufuk
berugi
berujar
beruji
berujud
berujung
berukup
berukuran
berulah
berulam
berulang
berulang tahun
berulang-alik
berulang-ulang
berulas
berulat
berulos
beruluk salam
berumah
berumah tangga
berumahkan
berumbai-rumbai
berumbi
berumpak
berumpama
berumpuk
berumpun
berumput
berumun
berumur
berundak-undak
berunding
berundung-undung
berunggun
berunggun-unggun
berungut
berungutan
beruniform
berunjuk rasa
berunsur
beruntai
beruntaian
beruntuk
beruntun
beruntung
beruntung-untung
berunyai-unyai
berupa
berupa-rupa
berupah
berupaya
berura-ura
berurai
berurap
beruras
berurat
berurine
beruris-uris
berurusan
berurut
berurut-urutan
berurutan
berusaha
berusak
berusali
berusia
berutang
berutas
bervakansi
bervariasi
berwaad
berwadahkan
berwajib
berwakaf
berwakil
berwaktu
berwarna
berwarna-warna
berwarna-warni
berwarung
berwasiat
berwaspada
berwaswas
berwatak
berwawancara
berwawanmuka
berwawanrembuk
berwibawa
berwiraswasta
berwiru-wiru
berwisata
berwudu
berwujud
berwukuf
beryang-yang
beryoga
berziarah
berzikir
berzina
beserban
beserbankan
beserdam
beserdawa
beserdih
besero
beserta
besuk
besut
beterbangan
beterjunan
beternak
betot
biak
biang, biang biut
biarpet
biau
bibit
bidasan
bidik
bikin
bila
bilah
bilang
bilas
bimbang
bimbing
bina
binayah
bisa
blokir
bobok
bocor
boikot
boko
bolak-balik
bolos, membolos
bombardir
bonceng
bongkar
bongkar-membongkar
bopong
borokan
borong
boyong
buang
buang-buang air
buat
bubar
bubul
bubung, membubung
bubut
budur
buk, mengebuk
buka
bumi hangus, membumihanguskan
bumpet
buni
bunting
buntu
bunuh
bunuh-membunuh
buru
busai
butuh
buyar
cabik-mencabik
cabut
cacah
cacingan
cahari
cakar-mencakar
cakup
cakup-mencakup
calang
campak
campur
campur aduk
campur baur
camuk
candak
candra, mencandrakan
cangak
cangcang
cangking
cangkum
cangkung
cangkup
canguk
cantol
cantum
caos
capai
capak
caplok
carak
cari
cari-carian
carter
cas
catat
catek
catuk
cebak
cebil, mencebil
cebir
cebis
cebok
cecah
cecap
cedera
cegah
cegat
cek
cekak, bercekak
cekal
cekam
cekau
cekcok
cekih
cekik
cekikikan
cekluk
cekuh
cekup
cekut
celaka
celam-celum
celampak
celang, mencelang
celas-celus
celat
celengkang
celik
celingak-celinguk
celinguk
celis
cemat
cemburuan
cemplung
cemuk
cencang
cengam
cengap
cengar-cengir
cengir-cengir
cengkeram
centang
ceplos
cerabut
ceracak, berceracak
cerai
cerak
cercah
cericau
cerkau
cerocos
ceroteh
cerowok
ceruk-menceruk
ceruk-meruk
ciar
cibir
cibit
cicik
cicil
cicip
cikar
cincang
cium
coak
coba
coblos
cocok tanam, bercocok tanam
coket
colong
comat-comot
comot
congak-cangit
conggah-canggih
coplok
copot
cuang
cuci
cucuh
cucup
cucut
cugat
cuil
cuit
cukur
culik
cundang, mencundangi
cuplik
curai
cureng
curi
cuti
dab, mengedab
dabung
daduh
dagel
dahar
dahulu-mendahului
daki
dampar
damprat
dandan
dangir
dangkung
danguk
daras
datang
datang-mendatangi
dayu
debak-debuk
debar
dedah
deder
dedes
deg, deg-degan
degap-degap
dekak
dekam
dekap
dekar
dembai
dempak
dempok
dengak
dengap
dengar
dengar-dengaran
dengking-mendengking
dengu
denguk
denyar
depang
deponir
derai
deres
derum
derung
desak
detasir
detikan
deutranopia
di bawah
di muka
diadang
diagak
diajuk
diajun
dialas
diam
diambak
diang
dianjak
diasak
dibakar
dibujurkan
dibusur
didiang
didik
didis
dieban
difirmankan
dihumasi
diiringkan
dijiplakkan
dijual
dikadang
dikajangi
dikandung
dikarenakan
dikati
dikecek
dikejar
dikemarikan
dikerkah
dilamun
dilapah
dilapih
dilayangkan
dilimbur
dimabuk
dimakan
dimaksud
dimaksudkan
dimejahijaukan
dimuntahkan
dipanggang
dipasteurisasi
diperbal
diperdanakan
diperdom
diperdomi
diperlelarkan
dipingpong
dipupuk
diri
diris
dirus
disapa
disapu
disekrup
disel
diserap
disigai
disisih
diskredit
disunahkan
ditanam
ditanjakkan
ditebuk
ditekik
ditimang
ditimpa
ditindih
dituai
dituang
diuji
diulas
dodos
dolanan
dompak
dompleng
dompol
donder, mendonder
dorong
dribel
dua
dua-duaan
dubelir
dublir
dudu
duduk
duduk-duduk
dudur
duga
dugang
dugas
dukung
dup, mengedup
ejawantah
eksit
ekspos
embat
embus
embut
empap
empas
empo
empoh
empos
enas, mengenaskan
encang
engget
enjak
enjut
enkode
entak
entas
enten
entit, mengentit
entot
fatur
forsir
gabai
gadai
gado
gagai
gagal
gagas
gagau
gahar
gaib
gail
gali
gamak-gamak
gamat
gamik
gamit
gampar
ganda-berganda
gandar
gandeng
ganding
ganduh
ganggu
ganggu gugat
ganggut
ganjak
ganjal-mengganjal
ganjar
gantel
gantung
ganyah
ganyang
gapai
gaplok
garang
garap
garuk
garut
gasab
gasak
gayuh
gayuk
gayun
gebah
gebok
gebos
gebot
gebrak
gebu
gebuk
gebyah-uyah, menggebyah-uyah
gecek
gedor
gegas
gegoakan
gejuju
gela
gelabur
geladi
gelakak
gelalar
gelandang
gelanting
gelar
gelatak
gelatuk
gelayangan
gelayut, bergelayut
geledah
gelek
gelekak
gelentang
gelepur
geletar
geletik
geleting
gelicik
geligit
gelinting
gelipar
gelocak
gelogok
gelompar
gelongsor
gelopak
gelosang
gelosok
gelotak
gelundung
gelup
gelut
gemak
geman
gemaung
gembar-gembor
gembol
gembung
gemelentam
gemeletak
gemeletap
gemeletek
gemeletuk
gemelugut
gementam
gemercak
gemercik
gemerencang
gemerencik
gemerencing
gemerencung
gemeresak
gemeresik
gemeretak
gemeretuk
gemeretup
gemertak
gemertuk
gemerusuk
gempul-gempul
gempur
gempur-menggempur
gencet
gendong
gengsi-gengsian
gengsot
genjot
genjot-genjotan
gera
geragapan
geragas
geragau
gerai
geram
geramus
gerapai
gerat
gerayah
gerayang
gerbas-gerbus
gerbus
gerecok
gerenyeng
gerenyet
gerenying
gerenyit
geret
geridip
gerinyau
gerising
germut
gerobok
gerobyakan
gerogot
gerojok, menggerojok
gerompok
geronyot
geropyok
gerowot
gerunyam
gerus
gesek
gesel
geser
getap
getik
getil
getu
gial-giul
gigih
gigit
gila-gilaan
gilas
gili
giling
gilir
gilir-bergilir
gingsir
giring
gisar
gisil
gites
gitik
glegek(an)
glidik
goak
gocoh
goda
godok
godot
goel
gogok
gogrok
gojek, bergojek
gojlok
golak
golak-galik
golek
goleng
golong
gombeng
gondol
gonggok
gonggong
gongseng
gonjak
gonjang, gonjang-ganjing
gonjlang, gonjlang-ganjling
gonjok
gonta-ganti
gontok
gontok-gontokan
gonyak
gonyeh
gonyoh
goreng
goroh
gorok
gotes
gotong
gotong royong
goyak
goyang
grambyang
grecok
gresek-gresek
gruwung
gubah
gubal
gubit
gubris
gugah
gugat
gugur
guit
guling
gulir
gulung-menggulung
gumelaran
gumul
gunyam
gurah
gurik
gurit
gusar
guselan
gusrek, menggusrek
gusur
gutik
gutuk
guyur
habis
hadir
hafal
haiking
hajar
halang
halau
hambat
hamil
hampar
hampirkan
hancur
hancur lebur
hancur-menghancurkan
hangus
hantam
hantar
hantir
hanyut
hapus
harap
harap-harapan
harus
hasut
heban
hela
hembalang
hempas
hengkang
hibob
hibur
hidang
hidu
hidup
hilang
hilang-hilang
himpun
hina-menghinakan
hinap
hindar
hinggap
hinggut
hirap
hirup
hitung
hitung-hitungan
hormat-menghormati
hujan angin, menghujananginkan
hujan panas, menghujanpanaskan
hunus
ibing, mengibing
ibrit
idap, mengidap
igau, mengigau
ihsas
ihtimal, mengihtimalkan
iktikaf
ikut serta
ikut-ikutan
imbang-imbangan
imbit
imkan
impas
impi, mengimpikan
impit
incar
incrit
indah
indap
indehoi
indekos
indik
inding
ingat-ingatan
ingau-ingauan
ingkah
ingkar
ingsar
ingsut
ingusan
insar
inslan
intai
internir
intip
inzar
iprit
iqra
isap
istianah
istinja
istirahat
iudisasi
jabat
jabat tangan
jadi
jaga
jahit
jaja
jajah
jajak
jajal
jalang
jalar
jalin
jalin-berjalin
jalin-menjalin
jamah
jambak-jambakan
jambret
jamin
jangkah
jangkir
jangkit
jangol, menjangol
jantang
jantungan
jatuh
jawil
jayeng
jebar
jeblok
jebluk
jebol
jebrol
jegal
jegal-jegalan
jegil
jeksi
jela
jelajah
jelalat, jelalatan
jelang
jelang-menjelang
jelangak
jelepak
jeling
jelujur
jelur-jelir
jempalitan
jemput
jemur
jengek
jenggotan
jenggut
jengit
jengkang
jengkek
jengkelit
jengkeng
jengket
jengkit
jengkoletan
jenguk
jentik
jepit
jepret
jeput
jerahap
jerang
jerangkak
jerap
jerawatan
jerba
jerbak
jerempak
jereng
jerongkok
jerukup
jerum, menjerum
jerumat
jerumus
jerungkis, menjerungkis
jewer
jibaku
jijit
jilat
jingau
jingkat
jingkik
jingkrak
jingu
jinjing
jinjit
jiplak
jirus
jitak
joging
jolek
jolok
jompak
jongkang-jangking
jongkar-jangkir
jongkat-jangkit
jongkok
jotos
jotos-jotosan
jotosan
juak
jual
jujut
julang
juluk
jumpa
jumpalit
jumpalitan
jumput
junam
junggang
jungkal
jungkang
jungkat
jungkir
jungkir balik
jungkit
junjung
juntai
jupang
kabruk
kabur
kacak, berkacak
kacir, mengacir
kada
kais
kakap
kalah
kamban
kambang
kambuh
kambuhan
kandas
kangen-kangenan
kanjar
kansel
kapalan
kapang
kapung
karam
karang
karangwulu
karau
karih
karu
kasak-kusuk
kasi
kasih
kaulan
kaut
kaver
kawin
ke muka
keairan
keanginan
kebanjiran
kebas
kebobolan
kebur
kebut
kebut-kebutan
kecam
kecamuk
kecanduan
kecantol
kecenaan
kecer
kecimik
kecipratan
kecolongan
kecopetan
kecurian
kedahuluan
kedang
kedapatan
kedekik
kedengaran
keduk
kedut
kedutan
kegelapan
kehabisan
kehujanan
kehujungan
kejaga-jagaan
kejai
kejam
kejan
kejangkitan
kejar
kejar-mengejar
kejatuhan
kejatuhan bulan
kejeblos
kejuju
kekol
kekotaan
kekurangan
kelabang, berkelabang
kelaluan
kelampauan
kelangkahan
kelantang
kelap-kelip
kelebat
kelejat
kelelap
kelelot
kelemban
kelempai
kelepat
kelepek
keleseh peseh
kelihatan
kelikik
kelilipan
kelimpahan
kelindungan
kelintar
kelintasan
kelis
kelocak
kelontang-kelantung
keloyak
keluar
keluna
kelupas
keluyur, berkeluyuran
keluyuran
kemalaman
kemalingan
kemaluan
kemam
kemari
kemaruk
kemasukan
kembali
kembang
kembang biak
kemik, kemak-kemik
kempas-kempis
kempit
kemplang
kemut
kena
kena-mengena
kenal
kenal-mengenal
kenamaan
kenang
kencing
kencing-mengencingi
kendangan
kendong
keningrat-ningratan
kensel
kenyam
kenyut
kepah
kepak
kepengapan
kepepet
kepergok
kepetangan
kepincuk
kepit
kepoh
kepot
keprek
kepret
kepris
kepruk
kepung
keracunan
kerai
kerakah
keramas
keranjingan
keras-mengerasi
kerbat
kerebok
kereceng
kerecik
keremus
kerepes
kerese pese
kerik
kerikit
keringanan
kerip
kerjap
kerkah
kerkau
kerlap
kerlip
kerobek
keroncongan
kerosi, mengerosi
keroyok
kertak-kertuk
kertap-kertap
kerubung
kerubut
kerugian
kerukut
kerumit
kerumun
kerumus
kerutak
kesak
kesampaian
kesamper
kesampukan
kesamunan
kesandung
kesang
kesangsang
kesap-kesip
kesasar
keseberangan
kesedakan
kesek
kesel
keselak
keselapan
kesemanan
kesenak-senakan
kesenakan
kesendalan
kesenggol
kesengsaman
kesengsem
kesenjaan
keserempet
keserimpet
keseruduk
keseser
kesetanan
kesetrum
kesiangan
kesinian
kesirep
kesisipan
kesiur
kesot
kesusahan
kesusupan
ketagihan
ketahuan
ketakar-keteker
ketam
ketamuan
ketangkapan
ketap
ketap-ketap
ketap-ketip
ketawa
ketempatan
ketempuhan
ketemu
keterepasan
keterjunan
keteteran
ketidur-tiduran
ketil
ketindihan
ketis
ketolongan
ketrek
ketrengginasan
ketuan-tuanan
ketubruk
ketulahan
ketularan
ketulusan
ketumbuhan
ketumpahan
ketur
kewalahan
khalas
khatam
khitan
kia
kiah
kial
kiat
kibar
kibas
kicuh, berkicuh
kicut
kijai
kikih
kikik
kikis
kilan
kilap
kilau-mengilau
kilik
kilik-kilik
kilir
kimbah
kimbang
kincah
kincak
kincit
kinja
kirai
kirap
kirik
kirim
kirim-berkirim
kirung
kisai
kitar
kitik
kiuk
klik-klikan
kluntang-klantung
koaksi
kobar
koboi-koboian
kobok
kobol
kocok
kocor
kodok
koit
kojol
kojor
kokang
kokol
kokot
kol
kolang-kaling
kolaps
komat-kamit
komisi
kompas
kondangan
kongko-kongko
kongkong, mengongkong
konstatir
kontang-kanting
konter, mengonter
kop, mengekop
kopak
kopek
kopokan
korengan
kosek
kosel
kotes
kover
kowek
kuadrisep
kuai
kuak
kuar
kubak
kubik
kubistik
kubit
kucek
kucing-kucingan
kudisan
kuis
kujut
kulub
kulum
kumpal
kumpar
kumpul
kumur
kuncup
kundang
kungkum
kunjung
kunyah
kupas
kupil
kuras
kusal
kusruk
kusuk
kutat
kutik
kuting
kutip
kuud
labang
labrak
labres
labur
lacak
laden
lagang
lahir
lais
lakak
laku lajak
lala
lalau
lalu
lalu lintas
lalu-lalang
lamar
lambung
laminating
lampan
lampar
lanang
lancur
lancut
landa
landau
langak-longok
langgan
langgar
langgar-melanggar
langgung
langkang
langkas
langkat
langkau
langkup
langsar
langsir
lanja-lanjaan
lanjak
lantah, melantah
lantak
lantik
lanting
lanus
lanyak
lapak
lapis
lapor
lapur
larai
larang
larap
larat
larau
larau, melarau
lari
lari-lari
lasah
lat
latam
latih
latis
lawat, melawat
layang
layas
layat
lecit
ledak, meledak
ledek
lego
legu
lekat-lekat
lelap
leleh
lempap
lempar
lempar-lemparan
lempit
lencit
lengat
lenggak
lenggak-lenggok
lenggok-lenggok
lenggut
lenggut-lenggut
lengseng
lengser
lengset
lenja
lentang
lentang-lentok
lentang-lentung
lenting
lenyeh
lenyut, melenyut
lepih
lepoh
lepur
lerah
lesap
lesehan
letup
letus
lever
liang-liut
libur
lihat
limasan
limbang
limpah
limpas, terlimpas
lindas
lindis
lingkung
lingkup
lingsir
linjak
linting
lipat
lipur
liput
lirik
loloh
lolos
lompat
longak-longok, melongak-longok
longok
longsor
lontang-lanting
lontang-lantung
lontar
luber
lucup
lukat
lukis
luluh
luluh lantak
lulum
lulus
lumas
lumus
lunas
luncur
lungsar
lungsur
lunjur
lunyah
lupa
lupa-lupaan
lupuh
luput
luruh
lurut
maaf-memaafkan
mabuh
mabuk-mabukan
madmadah
mafhum
main
main-main
majati
maju
makan
makan-makan
makantuh
maki
maklum
maktub
makzul
malagandang
malas-malasan
mamah
mampir
mampus
mandai
mandam
mandek
mandi
mandung
mangau, termangau
mangkat
mangu, termangu
manjau
manjeri
manufaktur
manunggal
mara
marah-marah
maras
martandang
masap
masuk
mat-matan
mati
mati-matian
mauludan
mazkur
megal-megol
mekar
melabai
melabakan
melabelkan
melabu
melabuh
melabuhkan
melacur
melacurkan
meladai
meladungkan
melafalkan
melaga
melagak
melagakan
melagakkan
melagangkan
melagu
melagui
melagukan
melahap
melahirkan
melaini
melainkan
melajang
melaju
melajukan
melakabkan
melaknat
melaknati
melaknatkan
melakoni
melakonkan
melaksanakan
melakukan
melakurkan
melalaikan
melalap
melali
melalui
melalukan
melamarkan
melambai
melambai-lambai
melambai-lambaikan
melambaikan
melambak
melambangkan
melambankan
melambat-lambatkan
melambatkan
melambuk
melambung
melambungi
melambungkan
melampai
melampam
melampang
melampas
melampau
melampaui
melampiaskan
melampini
melampirkan
melancar
melancarkan
melancip
melancipkan
melancung
melancungkan
melandai
melandakan
melandas
melandasi
melandaskan
melandung
melangahkan
melanggani
melanggar
melanggarkan
melangir
melangit
melangkah
melangkahi
melangkahkan
melangkapkan
melangkup
melanglang
melangsamkan
melangsi
melangsingkan
melangsungkan
melanjar
melanjurkan
melanjut
melanjutkan
melantai
melantaikan
melantakkan
melantamkan
melantangkan
melantas
melantaskan
melantingkan
melantung
melantunkan
melanturkan
melanyah
melanyau
melapangi
melapangkan
melaparkan
melapih
melapik
melapiki
melapikkan
melapis
melapisi
melapiskan
melapor
melaporkan
melapuk
melapun
melapur
melarah
melaraikan
melaram
melarangkan
melarasi
melaraskan
melarat
melarih
melarihi
melarik
melarikan
melarikkan
melariskan
melaru
melarut
melarutkan
melasikan
melatahkan
melatamkan
melatarbelakangi
melatari
melatih
melatur
melaun-laun
melaung
melaungkan
melaur
melauti
melautkan
melawa
melawak
melawak-lawak
melawan
melawani
melawankan
melawar
melayahkan
melayak
melayakkan
melayang
melayang-layang
melayangkan
melayankan
melayap
melayap-layap
melayap-layapkan
melayapi
melayapkan
melayari
melayarkan
melayaskan
melayu
melazimkan
melebar
melebarkan
melebat
melebih
melebih-lebihi
melebih-lebihkan
melebihi
melebihkan
melebuhkan
melebuk
melebun
melebur
meleburkan
meleceh
melecehkan
melecek
melecurkan
melecut
melecutkan
meledakkan
meledeki
meledungkan
melegakan
melegalisasi
melegalisasikan
melegalkan
melegenda
melegendaris
melegitimasikan
melejang
melejang-lejangkan
melejangkan
melejitkan
melek-melekan
melekap
melekapkan
melekari
melekaskan
melekat
melekati
melekatkan
melekokkan
melekuk
melekukkan
melela
melelahkan
melelaikan
melelakan
melelang
melelangkan
melelapkan
melelas
meleleh
meleleh-leleh
melelehkan
meleler
meleluasakan
melemahkan
melemang
melemaskan
melembaga
melembagakan
melembang
melembapkan
melembarkan
melembek
melembekkan
melembing
melembungkan
melembur
melembutkan
melempai
melempar
melemparkan
melempengkan
melempit
melencangkan
melendoti
melendung
melengah-lengah
melengahkan
melengangkan
melengas
melengaskan
melengat
melenggakkan
melenggut
melengkapi
melengkapkan
melengket
melengketkan
melengking
melengkung
melengkungi
melengkungkan
melengkur
melenguh
melentikkan
melenting
melentingkan
melentuk
melentukkan
melentung
melentur
melenturkan
melenyapkan
melepa
melepas
melepasi
melepaskan
melepih
melepoti
melepuh
melepuhkan
melepur
meler
meleraikan
melerak
melerakkan
melereng
meleret
meleretkan
melesapkan
melesek
melesing
melestarikan
meletakan
meletakkan
meleter
meleterkan
meletihkan
meletik
meletup
meletupkan
meletus
melewarkan
melewati
melewatkan
melezatkan
meliat
melibat
melibatkan
meliberalisasi
meliberalisasikan
meliburkan
melicinkan
melidahkan
melihat-lihat
melihati
melikas
melikuidasi
melikuidasikan
melikut
melilin
meliliti
melilitkan
melimaui
melimbaikan
melimpah-limpah
melimpahi
melimpahkan
melincah-lincah
melincirkan
melindang
melindangkan
melindap
melindungi
melindungkan
melinggis
melingkari
melingkarkan
melingkungi
melingkupi
melinglungkan
melingsirkan
melintang
melintangi
melintangkan
melintas
melintasi
melintup
melinyak
melipat
melipatgandakan
melipatkan
melipit
melipur
melipurkan
meliputi
melisankan
melisutkan
melitsus
meliuk
meliuk-liuk
meliuki
meliukkan
meliuri
meloak
meloakkan
melobi
melokalisasi
melokalkan
melokap
melolong
melolong-lolong
meloloskan
melombong
melompat
melompat-lompat
melompati
melompatkan
melompong
meloncat
meloncat-loncat
meloncati
meloncatkan
melonceng
meloncer
melondongkan
meloneng
melonggari
melonggarkan
melonggokkan
melonjak
melonjak-lonjak
melontari
melontarkan
melorongkan
melorotkan
melotrekan
melowongkan
meluahkan
meluaki
meluangkan
meluapkan
meluarkan
meluas
meluaskan
melubangi
meluber
melucu
melucup
melucuti
melucutkan
meludah
meludahi
meludahkan
meluhurkan
melukah
melukai
melukiskan
meluku
meluli
meluluhkan
meluluhlantakkan
meluluk
melulur
melulusi
meluluskan
melulut
melumangkan
melumari
melumatkan
melumer
melumerkan
melumpuhkan
melumur
melumuri
melumurkan
melunak
melunaki
melunakkan
melunasi
melunaskan
meluncungkan
meluncuri
meluncurkan
melunjurkan
meluntang
meluntur
melunturi
melunturkan
melupakan
meluputkan
melurubi
meluruh
meluruhkan
melurus
meluruskan
melusuh
melusuhkan
meluti
melutut
meluwengkan
meluweskan
meluyut
memaafi
memaafkan
memabukkan
memacak
memacak-macak
memacakkan
memacani
memacari
memacek
memacetkan
memacu
memacul
memada-madai
memadahkan
memadai
memadakan
memadami
memadamkan
memadan
memadan-madan
memadankan
memadat
memadati
memadatkan
memadu
memadui
memadukan
memafhumi
memagar
memagari
memagarkan
memagut
memahalkan
memahami
memahamkan
memahat
memahfuzkan
memahiri
memahirkan
memahitkan
memahkotai
memainkan
memairi
memajaki
memajalkan
memajangkan
memaju
memajuh
memajukan
memakai
memakaikan
memakal
memakamkan
memakan
memakani
memakankan
memakati
memakbulkan
memaki
memaki-maki
memaklumatkan
memaklumi
memaklumkan
memakmumi
memakmurkan
memaknakan
memaksa
memaksa-maksa
memaksakan
memaksimalkan
memaku
memakukan
memakzulkan
memalai
memalak
memalaki
memalam
memalamkan
memalang
memalangi
memalangkan
memalaskan
memaling
memalingkan
memalis
memaliskan
memalit
memalsu
memalsukan
memalu
memalui
memalukan
memalun
memalunkan
memalut
memamahkan
memamerkan
memamitkan
memampangkan
memampas
memampat
memampatkan
memanah
memanahi
memanahkan
memanajemeni
memanas
memanas-manasi
memanasi
memanaskan
memanau
memancang
memancangkan
memancar
memancarkan
memancing
memancit-mancitkan
memandai-mandai
memandakkan
memandang
memandangi
memandekkan
memandikan
memandori
memandu
memandukan
memandulkan
memanen
memanfaatkan
memanggakkan
memanggang
memanggil-manggil
memanggilkan
memanggung
memanggungkan
memangkah
memangkal
memangkalkan
memangkas
memangkatkan
memangku
memangkur
memangsa
memangsakan
memangur
memanifestasikan
memanipulasi
memanipulasikan
memanis
memanis-manis
memanisi
memaniskan
memanjakan
memanjang
memanjangkan
memanjat
memanjatkan
memanjingkan
memanjut-manjut
memanjutkan
memansukhkan
memantai
memantakkan
memantang
memantangkan
memantapkan
memantas
memantas-mantas diri
memantati
memantek
memantis
memantrai
memantrakan
memantulkan
memantuni
memantunkan
memanusiakan
memanusiawikan
memapah
memapak
memapan
memapani
memapar
memaparkan
memapas
memaraf
memarahi
memarahkan
memarak
memarakan
memarakkan
memarang
memarangkan
memarani
memarap
memaras
memarginalkan
memarinade
memarit
memarkahi
memarkir
memarodikan
memaruh
memarut
memasabodohkan
memasak
memasak-masak
memasakkan
memasalahkan
memasam
memasang
memasangkan
memasarkan
memaserasi
memaskotkan
memasok
memasokkan
memasrahkan
memastikan
memasuki
memasukkan
memasung
memasungkan
memasyarakat
memasyarakatkan
memasygulkan
memasyhurkan
memata-matai
mematah-matah
mematahkan
mematangkan
mematar
mematenkan
mematil
memating
mematok
mematokkan
mematri
mematrikan
mematuhi
mematuk
mematukan
mematung
mematungkan
mematut
mematut-matut
mematutkan
memau-mau
memaui
memaukan
memaut
memautkan
memayah-mayahkan (diri)
memayahkan
memayungi
memayungkan
membabarkan
membabat
membabati
membabatkan
membabi
membaca-baca
membacah-bacah
membacai
membacakan
membacokkan
membadai
membadi
membadik
membadut
membagar
membagi
membagi-bagikan
membaguskan
membahagiakan
membahan
membahana
membahas
membahasakan
membahayakan
membahu
membaiat
membaik
membaiki
membaikkan
membaja
membajai
membajak
membaji
membajui
membajul
membakalkan
membakari
membakarkan
membakat
membaksi
membaktikan
membakukan
membalah
membalam
membalap
membalapkan
membalas
membalas dendam
membalik
membalik-balik
membaliki
membalikkan
membalun
membalur
membalurkan
membalut
membalutkan
membancarkan
membancuh
membancuhkan
membandar
membandari
membandarkan
membandel
membandering
membanding
membandingi
membandingkan
membandit
membandul
membandut
membangatkan
membangga
membanggakan
membangirkan
membangkar
membangkit
membangkit-bangkit
membangkitkan
membangkrutkan
membangsa
membangsakan
membangun
membanguni
membangunkan
membaning
membanjarkan
membanjir
membanjiri
membantah
membantahi
membantahkan
membantai
membantalkan
membanter
membantingkan
membantu
membantukan
membantuni
membanyak
membanyaki
membanyakkan
membanyol
membaptis
membaptiskan
membara
membarah
membarak
membaratkan
membarengi
membarengkan
membaringkan
membariskan
membarui
membarukan
membarut
membarut-barut
membarutkan
membasahi
membasahkan
membasi
membasikan
membasuh
membasut
membatak
membatalkan
membatang
membatasi
membatik
membatin
membatu
membatui
membatukkan
membaui
membauni
membaur
membaurkan
membawa-bawa
membawahi
membawahkan
membawakan
membawangi
membayang
membayang-bayangi
membayang-bayangkan
membayangi
membayangkan
membayar
membayari
membayarkan
membayonet
membea
membebani
membebankan
membebaskan
membebasmurnikan
membebastugaskan
membebat
membebek
membeberkan
membeda-bedakan
membedah
membedakan
membedaki
membedakkan
membedal
membedil
membedili
membedol
membedung
membega
membegal
membegar
membeginikan
membegitukan
membejatkan
membeka
membekali
membekalkan
membekas
membekaskan
membeku
membekukan
membelah
membelai
membelai-belai
membelajarkan
membelakang
membelakangi
membelakangkan
membelalangkan
membelandakan
membelandangkan
membelanjai
membelanjakan
membelar
membelasah
membelaskan
membelat
membelau
membelenggu
membelengketkan
membelengkok
membelengkokkan
membelenting
membelentingkan
membeliakkan
membelikan
membelintangkan
membelit
membelit-belitkan
membelitkan
membelok
membelokkan
membelongsongi
membelu-belai
membelukar
membenahi
membenalu
membenam
membenamkan
membenang
membenar-benar
membenar-benari
membenarkan
membencah
membencanakan
membenci
membencikan
membendakan
membenderai
membendung
membengang
membengis
membengisi
membengkak
membengkalaikan
membengkel
membengkung
membenihkan
membeningkan
membentang
membentangi
membentangkan
membentari
membentarkan
membenteh
membentengi
membentrokkan
membentuk
membentur
membenturkan
membeo
memberahikan
memberai-beraikan
memberakan
memberandal
memberang
memberangi
memberangkatkan
memberangsangkan
memberangus
memberanikan
memberantakkan
memberati
memberatkan
memberdayakan
memberentangkan
membereskan
memberhalakan
memberhentikan
memberikan
memberitahukan
memberitakan
memberkas
memberkaskan
memberkati
memberlakukan
membermaknakan
memberolahragakan
memberongsong
memberontak
membersamakan
membersihkan
membersitkan
membersut
memberunguti
memberus
membesar
membesar-besar
membesar-besarkan
membesarkan
membeset
membesi
membesi tua
membesituakan
membestel
membesutkan
membetahkan
membetas
membeting
membeton
membetuli
membetulkan
membiadabi
membiak
membiaki
membiakkan
membiarkan
membias
membiasakan
membiaskan
membiawak
membiayai
membiayakan
membicarakan
membicu
membidai
membidangi
membidangkan
membidani
membidikkan
membiji
membikin
membikin-bikin
membilai
membilang
membilangi
membilangkan
membilas
membimbangkan
membimbing
membinasakan
membincangkan
membindu
membingas
membingkah
membingkahi
membingkai
membingkaikan
membingungkan
membintangi
membiru
membirukan
membisiki
membisikkan
membisingkan
membisu
membisul
membius
memblaster
memblokade
membobol
membobolkan
membobos
membocorkan
membodohkan
membohong
membohongi
membohongkan
membokong
membola
membolak-balikkan
membolehkan
memboncengkan
membondot
membonekakan
membongak
membonggoli
membongkahi
membongkar
membongkar-bangkir
membongkar-bongkar
membonsai
membonsaikan
membordir
memborgol
memborok
memborong
memborongkan
memboroskan
membosankan
membotak
membotaki
memboya
memboyong
membuahi
membuahkan
membual
membualkan
membuana
membuang
membuang-buang
membuangkan
membuas
membuat
membuat-buat
membuatkan
membuaya
membuayai
membubarkan
membubu
membubuhi
membubuhkan
membubuk
membubungkan
membubur
membubut
membudak
membudakkan
membudaya
membudayakan
membudidayakan
membugarkan
membugil
membuhul
membuih
membujang
membujuk
membujuki
membujur
membujurkan
membuka
membukai
membukakan
membukankan
membukit
membuktikan
membukukan
membulan
membulan-bulani
membulang
membulat
membulati
membulatkan
membuldoser
membului
membumbui
membumbun
membumi
membuncah
membuncahkan
membuncit
membuncitkan
membundak
membundar
membundarkan
membundel
membunga
membunga-bungai
membungai
membungakan
membungkam
membungkuk
membungkuk-bungkuk
membungkus
membunikan
membuntang
membuntangkan
membunting
membuntingi
membuntukan
membuntungkan
membuntut
membuntuti
membunyikan
membura
memburai
memburaikan
memburakan
memburas
memburaskan
memburit
memburu
memburu-buru
memburu-burukan
memburuh
memburuk
memburuk-burukkan
memburukkan
membusakan
membusuk
membusukkan
membusung
membusungkan
membusur
membusut
membuta
membutakan
membutir
membutuhi
membuyarkan
memecah
memecah belah
memecahbelahkan
memecahkan
memecakkan
memecatkan
memecut
memeda
memedang
memedaskan
memedihkan
memedomani
memedulikan
memegahkan
memegalkan
memegang
memegas
memejalkan
memejamkan
memek
memeka
memekakkan
memekarkan
memekatkan
memekik
memekikkan
memelana
memelankan
memelesetkan
memelet
memelihara
memeliharakan
memelintir-melintir
memelisit
memelitur
memelonco
memelopori
memelototi
memeluk
memeluki
memelupuh
memenangi
memenangkan
memenatkan
memencak-mencak
memencar
memencar-mencar
memencarkan
memencet
memencilkan
memendaki
memendamkan
memendek
memendekkan
memengap
memengapkan
memengaruhi
memengat
memenggal
memengkalkan
memengkol
memengos
memeningkan
memenjara
memenjarakan
memensiun
memensiunkan
mementaskan
mementegai
mementil
mementing
mementingkan
mementung
memenuhi
memenungkan
memepah
memepas
memepat
memepes
memepeti
memepetkan
memerah
memerahi
memerahkan
memerai
memeram
memerangi
memerangkap
memeranjatkan
memerankan
memeratakan
memerawani
memerban
memercayai
memercayakan
memercik
memercik-mercik
memerciki
memercikkan
memerdekakan
memeremkan (mata)
memereteli
memergol
memerhatikan
memerihkan
memerikan
memeriksa
memeriksai
memeriksakan
memerintah
memerintahi
memerintahkan
memerlahan
memerlahankan
memerli
memerlukan
memernis
memerosotkan
memersekoti
memersekusi
memerseni
memersenkan
memersepsikan
memersonanongratakan
memersonifikasi
memersuasi
memertamakan
memerukkan
memerum
memerun
memeruti
memesamkan
memesan
memesani
memesankan
memesatkan
memesona
memesonai
memesonakan
memesong
memesongkan
memesrakan
memestakan
memestikan
memesukkan
memesumi
memetahkan
memetak-metak
memetakan
memetang-metangkan
memeteraikan
memetiakan
memetieskan
memetikan
memetiki
memetikkan
memetir-metir
memetuahkan
memfaalkan
memfadihatkan
memfanakan
memfanatiki
memfantasikan
memfasakh
memfasihkan
memfasilitasi
memfatwakan
memfestivalkan
memfiat
memfilmkan
memfilter
memfitnah
memfitrahkan
memfokus
memfokuskan
memformulasikan
memfosil
memfotokopi
memfungsikan
memfusikan
memiagamkan
memialangkan
memiang
memiara
memiat
memicakan
memicikkan
memicing
memicingkan
memicu
memidana
memidatokan
memihak
memihaki
memihakkan
memijahkan
memijak
memijakkan
memijar
memijar-mijar
memijarkan
memikir
memikir-mikir
memikir-mikirkan
memikiri
memikirkan
memikul
memikulkan
memilih
memilih-milih
memilihkan
memiliki
memilin
memilin-milin
memilis
memiloti
memilukan
memimpikan
memimpin
meminati
memindah
memindahi
memindahkan
meminggir
meminggiri
meminggirkan
memingit
meminikan
meminimalkan
meminjami
meminjamkan
meminta-minta
memintai
memintakan
memintal
memintasi
memintaskan
meminum
meminumi
meminumkan
meminyaki
memipihkan
memipiskan
memirau
memiringkan
memisah
memisah-misahkan
memisahkan
memisalkan
memiskinkan
memistol
memitoskan
memiuh
memiutangi
memiutangkan
memobilisasi
memobilisasikan
memoces
memodali
memoderatori
memodernisasi
memodernkan
memodifikasi
memohon
memohonkan
memojok
memojokkan
memokoki
memokokkan
memokrolkan
memoles
memolesi
memoleskan
memolitikkan
memolok
memompa
memompakan
memoncongkan
memondok
memondokkan
memondong
memondongi
memongahi
memongahkan
memonitor
memonopoli
memonten
memopokkan
memopor
memopulerkan
memorahkan
memorak-perandakan
memorak-porandakan
memoroti
memosisikan
memositifkan
memotivasi
memotong
memotong-motong
memotongkan
memotori
memotret
mempan
mempanitiai
memparafrasakan
mempatroli
mempecundang
mempecundangi
mempekerjakan
mempelajari
memperabukan
memperadabkan
memperadik
memperadudombakan
memperadukan
memperagakan
memperalat
memperalati
memperalatkan
memperaman
memperamat
memperamat-amat
memperamat-amatkan
memperamatkan
memperanakkan
memperanginkan
memperantarai
memperapat
memperapikan
memperapitkan
memperasakan
memperawak
memperbabu
memperbagai-bagaikan
memperbagus
memperbahasakan
memperbaiki
memperbandingkan
memperbantahkan
memperbantal
memperbantukan
memperbanyak
memperbanyakkan
memperbarui
memperbaurkan
memperbedakan
memperbelakangkan
memperberat
memperbesar
memperbinikan
memperbodoh
memperbolehkan
memperboneka
memperbonekakan
memperbuat
memperbubungkan
memperbudak
memperbudikan
memperbulat
memperbungakan
mempercabangkan
mempercakap
mempercakapkan
mempercantik
mempercapak
mempercaruti
mempercekakkan
mempercekcokkan
mempercekikkan
mempercepat
mempercermin
mempercontohkan
mempercumakan
memperdagangkan
memperdahsyat
memperdakwakan
memperdalam
memperdamaikan
memperdapat
memperdaya
memperdayakan
memperdebatkan
memperdekap
memperdekat
memperdekatkan
memperdengarkan
memperdewa
memperdewakan
memperdua
memperduai
memperduakan
memperebutkan
memperedarkan
memperelok
memperembukkan
memperembunkan
memperempat
memperemping
memperenak
memperenggang
mempererat
memperfasih
memperganda-gandakan
mempergandakan
mempergandengkan
mempergandingkan
memperganduh-ganduhkan
memperganduhkan
mempergantungi
mempergarahkan
mempergauli
mempergaulkan
mempergegas
mempergelarkan
mempergembirakan
mempergesekkan
mempergiat
mempergiatkan
mempergilirkan
mempergontai
mempergosokkan
mempergunakan
mempergundah
mempergundik
mempergundikkan
mempergunjingkan
memperguraukan
memperhadapkan
memperhamba
memperhambakan
memperhambat
memperhebat
memperhentikan
memperhiasi
memperhidup
memperhinggakan
memperhitungkan
memperhubungkan
memperhujankan
memperhuma
memperikut
memperikutkan
memperimbang
memperimpit
memperimpit-impitkan
memperindah
memperingankan
memperingati
memperingatkan
memperingin
memperistri
memperistrikan
memperjamu
memperjarang
memperjelas
memperjerihkan
memperjodohkan
memperjualbelikan
memperjuangkan
memperjudikan
memperkaca
memperkacang
memperkacaukan
memperkalikan
memperkarai
memperkarakan
memperkasar
memperkatakan
memperkatupkan
memperkaya
memperkebuni
memperkebunkan
memperkecil
memperkecualikan
memperkedaikan
memperkedok
memperkelahikan
memperkembangkan
memperkenalkan
memperkenankan
memperkencang
memperkeras
memperketat
memperkirakan
memperkirapkan
memperkitarkan
memperkonon
memperkuat
memperkuda
memperkuda-kudakan
memperkukuh
memperladang
memperladangi
memperladangkan
memperlagakan
memperlain
memperlainkan
memperlaki
memperlakikan
memperlakukan
memperlalaikan
memperlamakan
memperlambat
memperlancar
memperlapang
memperlapangkan
memperlarat
memperlasah
memperlawankan
memperlebar
memperlekas
memperlelah
memperlelangkan
memperlelarkan
memperlemahkan
memperlengah
memperlengah-lengah
memperlengah-lengahkan
memperlenggekkan
memperlengkapi
memperlepas
memperlihatkan
memperlimpitkan
memperlindungi
memperlombakan
memperlonggar
memperluas
memperlunak
mempermacam-macamkan
mempermadukan
mempermahir
mempermainkan
mempermaklumkan
mempermalamkan
mempermalukan
mempermandikan
mempermanis
mempermanjakan
mempermasalahkan
mempermenangkan
mempermisikan
mempermuda
mempermudah
mempermulia
mempermulus
mempermurah
memperniagakan
memperolahkan
memperoleh
memperolok-olok
memperolok-olokkan
memperpadukan
memperpandak
memperpanjang
memperparah
memperpolitikkan
memperpotongkan
memperpukuli
memperpukulkan
memperpupuhkan
memperputarkan
mempersabar
mempersahabatkan
mempersahajakan
mempersaingkan
mempersakiti
mempersaksikan
mempersalahkan
mempersalin
mempersalini
mempersalinkan
mempersama-samakan
mempersamakan
mempersambungkan
mempersampahkan
mempersandangkan
mempersandingkan
mempersangat
mempersangatkan
mempersangkutkan
mempersatai
mempersatukan
mempersatupadukan
mempersaudarakan
mempersediakan
mempersedikitkan
mempersegar
mempersegera
memperseimbangkan
memperselangi
memperselangkan
memperselendang
memperselendangkan
memperselir
memperselirkan
memperselisihkan
memperselukkan
mempersemaikan
mempersembahkan
mempersempit
mempersenang
mempersenangkan
mempersendakan
mempersendikan
mempersengketakan
mempersenjatai
mempersetan
mempersetankan
memperseterukan
mempersetujukan
mempersewakan
mempersiang
mempersiangi
mempersiapkan
mempersilakan
mempersilangkan
mempersisipkan
mempersolek
mempersuakan
mempersuami
mempersuamikan
mempersudah
mempersudikan
mempersukar
mempersulit
mempersumpahkan
mempersungguhi
mempersunting
mempersusah
mempertahankan
mempertajam
mempertakut
mempertalikan
mempertampan
mempertanak
mempertandingkan
mempertangguhkan
mempertanggungjawabkan
mempertanggungkan
mempertangis
mempertanyakan
mempertapakan
mempertaruhkan
mempertarungkan
mempertautkan
mempertebal
mempertebarkan
mempertegas
memperteguh
memperteguhkan
mempertempurkan
mempertemukan
mempertenggangkan
mempertengkarkan
mempertentangkan
mempertetap
mempertetapkan
mempertiadakan
mempertidak
mempertidakkan
mempertiga
mempertikaikan
mempertimbangkan
mempertinggi
mempertontonkan
mempertopeng
mempertuan
mempertuankan
mempertubi-tubi
mempertubi-tubikan
mempertubikan
mempertuhan
mempertuhankan
mempertukarkan
mempertumbuhkan
mempertunangkan
mempertunggangkan
mempertunjukkan
memperturunkan
memperturut-turutkan
memperturutkan
mempertuturkan
memperubahkan (dng)
memperulur
memperumahkan
memperumum
memperuncing
memperundikan
memperundingkan
memperundungkan
memperuntukkan
memperurutkan
memperusuh
memperutangi
memperutangkan
memperwalikan
memperwujudkan
memperyahudikan
mempesertakan
memplombir
memprakarsai
mempraktikkan
mempraperadilankan
memprediksi
memprediksikan
mempresentasikan
mempribadikan
mempribumikan
memprioritaskan
memprivatisasikan
memproduksi
memprogram
memproklamasikan
mempromosikan
mempropagandakan
memprosakan
memproses
memprotes
memproyeksikan
mempunyai
mempunyakan
memuai
memuakkan
memualkan
memuaskan
memuat
memuati
memuatkan
memubazirkan
memublikasikan
memucat
memudahkan
memudakan
memudar
memudarkan
memudik
memudikan
memudikkan
memudur
memuduri
memudurkan
memufakati
memufakatkan
memugari
memugarkan
memuingkan
memuisikan
memuja
memuja-muja
memuji
memujikan
memujuk
memukabalahkan
memukal
memukang-mukang
memukat
memukau
memukimkan
memukul
memukuli
memukulkan
memukulratakan
memula
memulakan
memulangi
memulangkan
memulas
memulaukan
memuliakan
memulihkan
memulun-mulun
memulung
memuluskan
memulut
memumikan
memumpun
memunahkan
memuncak
memuncratkan
memunculkan
memundi-mundi
memundi-mundikan
memundurkan
memunggal
memunggung
memunggungkan
memungkari
memungkinkan
memungkiri
memungli
memunguti
memungutkan
memunjungi
memunjut
memuntahi
memuntahkan
memuntal
memuntung
memuntungkan
memupuh
memupuk
memupur
memupuri
memupurkan
memupus
memupuskan
memuput
memurahkan
memuramkan
memurkai
memurnikan
memurtadkan
memusakai
memusakakan
memusar
memusatkan
memuseumkan
memusiki
memusikkan
memusing
memusingkan
memuskilkan
memusnahkan
memusokan
memustahilkan
memusuhi
memusut
memusyawarahkan
memutalaah
memutalaahkan
memutar
memutar balik
memutar-mutar
memutarbalikkan
memutarkan
memutasikan
memutih
memutihkan
memutrakan
memutus
memutuskan
memuyengkan
memvaksinasi
memvariasikan
memveto
memvisualisasikan
memvisualkan
memvitalkan
memvonis
menaati
menabahkan
menabalkan
menabelkan
menabik
menabiri
menabligkan
menabrak
menabuh
menabukan
menabulasi
menabung
menabungkan
menabur
menaburi
menaburkan
menadah
menadahkan
menadbirkan
menafahus
menafakurkan
menafikan
menafkahi
menafkahkan
menafsirkan
menagak-nagak
menahan
menahani
menahankan
menahapkan
menaharkan
menahkikkan
menahun
menaik
menaiki
menaikkan
menaikkelaskan
menajak
menajamkan
menajin
menajinkan
menajiskan
menajuk
menakah
menakak
menakali
menakar
menakari
menakbirkan
menakdirkan
menakdiskan
menakhodai
menakhsiskan
menakhtakan
menaki
menakik
menakjubi
menakjubkan
menaklukkan
menakma
menakrifkan
menaksikan
menaksir
menaksirkan
menakuk
menakung
menakur
menakurkan
menakut-nakuti
menakuti
menakutkan
menakwilkan
menakzimkan
menakzirkan
menala
menalak
menalakan
menalamkan
menalang
menalangi
menalarkan
menalkinkan
menamai
menamakan
menamatkan
menambah
menambahi
menambahkan
menambak
menambal
menambalkan
menambang
menambangkan
menambari
menambat
menambuhkan
menambul
menambun
menambungi
menambunkan
menamengi
menampak
menampakkan
menampal
menampali
menampalkan
menampan
menampang
menampar
menampari
menamparkan
menampas
menampilkan
menampin
menampun
menampung
menampungkan
menamsilkan
menamu
menamui
menamyizkan
menanah
menanai
menanak
menanam
menanami
menanamkan
menanap
menanarkan
menancap
menancapkan
menandai
menandak
menandakan
menandangi
menandaskan
menandatangani
menanding
menandingi
menandu
menanduk
menandukkan
menanduskan
menang
menangani
menangas
menanggali
menanggalkan
menanggam
menanggang
menanggap
menanggapi
menanggapkan
menangguhkan
menangguk
menanggul
menanggung
menanggungjawabi
menanggungkan
menangis
menangisi
menangiskan
menangkalkan
menangkap
menangkapkan
menangkaskan
menangkul
menangkup
menangkupkan
menangkuptelentangkan
menangsel
menanjak
menanjakkan
menanjul
menanjuli
menanjung
menanjur
menanjur-nanjur
menanti
menanti-nanti
menantikan
menanwinkan
menanya
menanyai
menanyakan
menapai
menapak
menapak tilas
menapaki
menapakkan
menapaktilasi
menapaskan
menapis
menarafkan
menarah
menarakan
menarbiahkan
menargetkan
menari
menarifkan
menarik
menarikan
menarikhkan
menaris
menaruh
menaruhi
menaruhkan
menarung
menarungkan
menarupi
menasak
menasarufkan
menasdikkan
menashih
menashihkan
menasihati
menasihatkan
menasional
menasionalisasi
menasionalisasikan
menasionalkan
menaskan
menasrifkan
menasyhidkan
menasyrihkan
menata
menatah
menataki
menatap
menatapi
menatih
menato
menaturalisasi
menauhidkan
menauliahkan
menaungi
menautkan
menawar
menawari
menawarkan
menayang
menayangkan
menazamkan
menazarkan
mencabang
mencabangkan
mencabarkan
mencabau
mencabik
mencabik-cabik
mencabik-cabikkan
mencabikkan
mencabul
mencabuli
mencabuti
mencabutkan
mencacah
mencacah jiwa
mencacah-cacah
mencacak
mencacakkan
mencacap
mencacapi
mencacar
mencacat
mencacati
mencaci
mencaci maki
mencadangkan
mencadung
mencagak
mencagarkan
mencahar
mencahayakan
mencaing-caing
mencair
mencairkan
mencak
mencak-mencak
mencakah
mencakar
mencakupi
mencalak
mencalarkan
mencalit
mencalitkan
mencalonkan
mencambuk
mencambuki
mencamkan
mencampak
mencampakkan
mencampang
mencampung
mencampur
mencampuradukkan
mencampurbaurkan
mencampuri
mencampurkan
mencanai
mencanangkan
mencancutkan
mencandu
mencandui
mencandukan
mencangam
mencanggungkan
mencangkelkan
mencangklong
mencangkok
mencangkuk
mencangkul
mencangkuli
mencangkung
mencantikkan
mencantum
mencantumkan
mencapak
mencapak-capak
mencarah
mencarahkan
mencarang
mencari
mencari-cari
mencarik
mencarik-carik
mencarik-carikkan
mencarikan
mencaruk
mencarut-carut
mencatatkan
mencatu
mencatut
mencatutkan
mencawatkan
mencebak
mencebikkan
menceboki
mencebur
menceburkan
mencecah
mencecahkan
mencedera
mencederai
mencederakan
mencedok
mencegah
mencekah
mencekak
mencekakkan
mencekal
mencekalkan
mencekam
mencekcoki
menceker
mencekok
mencekoki
mencekokkan
mencekukan
mencela
mencelak
mencelakai
mencelakakan
mencelaki
mencelangakkan
mencelep
mencelikkan
mencelung
mencelungkan
mencelup
mencelupkan
mencelur
mencelus
mencema
mencemari
mencemarkan
mencemaskan
mencemburui
mencemburukan
mencemeehkan
mencemerlangkan
mencemeti
mencemooh
mencemoohkan
mencemplungkan
mencempung
mencempungi
mencempungkan
mencencang
mencendekiakan
mencengangkan
mencengis-cengis
mencengkam
mencengkamkan
mencengkeram
mencengkeramkan
mencentang
mencentong
mencepak-cepak
mencepat
mencepatkan
mencepol
mencepuk
mencepuk-cepuk
mencerahkan
mencerai
mencerai-beraikan
menceraikan
menceramahkan
mencerap
mencerat
menceratuk
mencerca
mencercai
mencerdaskan
menceret
mencereweti
menceriakan
menceritai
menceritakan
mencerlang
mencermati
mencermatkan
mencermini
mencerminkan
mencerna
mencernakan
menceroboh
mencerobohi
mencerucup
menceruh
menceruk
mencerup
mencetai-cetai
mencetak
mencetakkan
menceti
mencetus
mencetuskan
menciak
menciak-ciak
menciap-ciap
mencibirkan
mencicipi
mencicit
menciduk
mencina
mencinta
mencintai
mencintakan
mencipta
menciptakan
mencirikan
mencirit
menciritkan
mencita-citakan
mencitrakan
mencium
mencium-cium
menciumi
menciumkan
menciut
menciut-ciut
menciutkan
menclok
mencoang
mencoangkan
mencoba
mencoba-coba
mencobai
mencobakan
mencocok
mencocok-cocok
mencocokkan
mencocolkan
mencocor
mencodakkan
mencogok
mencokek
mencokolkan
mencolek
mencolek-colek
mencolok
mencoloki
mencomel
mencomeli
mencondongkan
mencongak
mencongakkan
menconggokkan
menconteng
menconteng-conteng
mencontengkan
mencontoh
mencontohi
mencontohkan
mencopet
mencopot
mencopoti
mencopotkan
mencorek
mencoreng
mencorengkan
mencoret
mencoreti
mencoretkan
mencorong
mencorongkan
mencorotkan
mencotok
mencuaikan
mencuarkan
mencubit
mencubit-cubit
mencuca
mencuci
mencucikan
mencucuh-cucuh
mencucuh-cucuhkan
mencucuri
mencucurkan
mencuik
mencuil
mencuit
mencukai
mencukil
mencukongi
mencukupi
mencukupkan
mencukur
mencumbu
mencumbui
mencunam
mencundang
mencungap
mencungkil
mencupaikan
mencupak
mencupang
mencupar
mencurah
mencurahi
mencurahkan
mencuraikan
mencuram
mencurangi
mencurat
mencuri-curi
mencurigai
mencurigakan
mendabung
mendacin
mendada
mendaduhkan
mendadung
mendadungkan
mendaftar
mendaftarhitamkan
mendaftarkan
mendaga
mendagangkan
mendagi
mendaging
mendahaga
mendahak
mendahan
mendahsyat
mendahsyatkan
mendahului
mendahulukan
mendaifkan
mendak
mendakikan
mendakwa
mendakwah
mendakwahi
mendakwai
mendakwakan
mendalam
mendalami
mendalamkan
mendalang
mendalangi
mendalangkan
mendalih
mendalihkan
mendalilkan
mendamaikan
mendamak
mendamar
mendambakan
mendampak
mendamparkan
mendampilkan
mendampingi
mendampingkan
mendanai
mendandani
mendangkalkan
mendanguk
mendap
mendapat
mendapati
mendapatkan
mendarab
mendarah
mendarahi
mendarat
mendaratkan
mendarmabaktikan
mendaruratkan
mendasar
mendasari
mendasarkan
mendasun
mendata
mendatakan
mendatang
mendatangi
mendatangkan
mendatar
mendatarkan
mendaulat
mendaur ulang
mendayagunakan
mendayung
mendayungkan
mendayus
mendebah
mendebarkan
mendebat
mendebik
mendebitkan
mendebu
mendebur
mendecap-decap
mendecit
mendecur
mendedas
mendedel
mendederkan
mendefinisikan
mendegam
mendegam-degam
mendegil
mendeham
mendekam
mendekap
mendekapkan
mendekat
mendekati
mendekatkan
mendeklamasikan
mendeklarasikan
mendekolonisasi
mendekretkan
mendekus
mendekut
mendelegasikan
mendemah
mendemiliterisasi
mendemo
mendemobilisasi
mendemokrasikan
mendemonstrasi
mendemonstrasikan
mendempetkan
mendempul
mendenda
mendendam
mendendami
mendendamkan
mendendangkan
mendendeng
mendengar
mendengar-dengar
mendengarkan
mendenging
mendengking
mendengking-dengking
mendengkul
mendengkung
mendengkur
mendengkus
mendengu
mendenguk
mendengung
mendengungkan
mendengus
mendengus-dengus
mendengut
mendengut-dengut
mendenting
mendenyut
mendepa
mendepakan
mendepakkan (lidah)
mendepangkan
mendepolitisasi
mendeportasi
mendeportasikan
mendepositokan
mendepun
mendera
menderai-deraikan
menderaikan
menderak-derakkan
menderam
menderang
menderap
menderapkan
menderas
menderau
menderau-derau
menderek
menderetkan
mendering
menderis
menderit
menderita
mendermakan
menderu
menderu-deru
menderum
menderumkan
mendesah
mendesain
mendesak
mendesakkan
mendesar
mendesas-desuskan
mendesau
mendesing
mendesir
mendesis
mendeskripsikan
mendestabilisasi
mendesus-desus
mendesuskan
mendesut
mendetak
mendetap-detap
mendetar
mendeteksi
mendetik
mendevaluasi
mendevaluasikan
mendewa-dewakan
mendewakan
mendewasakan
mendewatakan
mendiagnosis
mendiakan
mendiami
mendiamkan
mendiang
mendiani
mendiatkan
mendidihkan
mendigulkan
mendikte
mendiktekan
mendinamiskan
mendinamit
mendinaskan
mendinding
mendindingi
mendingin
mendinginkan
mendirikan
mendiruskan
mendisiplinkan
mendiskriminasi
mendiskualifikasikan
mendiskusikan
mendistribusi
mendistribusikan
mendiversifikasi
mendoa
mendoakan
mendobrak
mendokumentasikan
mendolarkan
mendominasi
mendompak
mendondangkan
mendongakkan
mendongeng
mendongengi
mendongengkan
mendongkel
mendongkolkan
mendongkrak
mendornai
mendua
menduai
menduakan
mendubeskan
mendudu-dudu
menduduki
mendudukkan
menduga-duga
mendugalkan
mendukacitakan
mendukakan
mendukung
mendukunkan
mendulag
mendulang
mendupai
mendurhaka
mendurhakai
menduri
mendusta
mendustai
mendustakan
mendwigandakan
meneaterkan
menebahkan
menebak
menebal
menebalkan
meneban
menebang
menebangi
menebar
menebari
menebarkan
menebasi
menebaskan
menebat
menebeng
menebengkan
menebing
menebu-nebu
menebuk
meneduh
meneduhi
meneduhkan
menegah
menegahkan
menegakkan
menegang
menegangi
menegangkan
menegapkan
menegara
menegarkan
menegas
menegaskan
menegosiasikan
meneguhkan
menegun
menegur
menegur-neguri
meneguri
meneja
menekak
menekan
menekang
menekankan
menekap
menekapi
menekapkan
menekat
meneken
meneker
menekuk
menekuni
menekunkan
menekur
menekuri
menekurkan (kepala)
menelaah
meneladan
meneladani
menelangkai
menelangkupkan
menelanjangi
menelanjangkan
menelantarkan
menelap
meneledorkan
menelegram
menelempap
menelengkan
menelentang
menelentangkan
menelepon
menelik
menelinga
meneliti
menelungkup
menelungkupkan
menelur
menelurkan
menelus
menemani
menembaga
menembak
menembaki
menembakkan
menembang
menemberang
menembok
menembuk
menembung
menembusi
menemin
menempah
menempap
menempati
menempatkan
menempel
menempelak
menempelakkan
menempeleng
menempeli
menempelkan
menempias
menempikkan
menempohkan
menempuh
menempuhkan
menempulingi
menempur
menemu
menemu duga
menemudugai
menemui
menemukan
menenagai
menenang
menenangkan
menenarkan
menendang
menendas
menenderkan
menengadah
menengadahkan
menengah
menengahi
menengarai
menenggala
menenggang
menenggangkan
menenggara
menenggek
menenggekkan
menenggelamkan
menengil
menengkarapkan
menengkari
menengkarkan
menengkel
menengking
menengkurap
menengkurapkan
menengok
menengoki
menentang
menentangi
menentangkan
menenteramkan
menentu
menentui
menentukan
menenun
menenung
menep
menepak
menepak-nepak
menepak-nepakkan
menepakkan
menepas
menepasi
menepat
menepati
menepatkan
menepek
menepikan
menepuk
menepung
menepungtawari
menera
menerakakan
menerakan
menerampilkan
menerang
menerangi
menerangkan
menerap
menerapkan
meneratak
menerawang
menerbangi
menerbangkan
menerbankan
menerbitkan
meneriaki
meneriakkan
menerikkan
menerima
menerimakan
menerindili
menerjang
menerjangkan
menerjuni
menerjunkan
menerka
menerkup
menerkupkan
menernakkan
meneropong
meneropongi
meneror
menertawai
menertawakan
menertibkan
menerumkan
menerungku
menerungkukan
menerus
meneruskan
menetakkan
menetal
menetap
menetapi
menetapkan
menetaskan
menetek
meneteki
menetekkan
menetes
menetesi
meneteskan
menetralkan
menewaskan
mengabadi
mengabadikan
mengabahkan
mengabaikan
mengabar
mengabari
mengabarkan
mengabdi
mengabdikan
mengabet
mengabjad
mengabjadkan
mengabolisikan
mengabsahkan
mengabsen
mengabsorpsi
mengabstrakkan
mengabu
mengabui
mengabukan
mengabulkan
mengabung
mengabung-ngabung
mengabur
mengaburkan
mengaca
mengacah
mengacak
mengacapi
mengacapkan
mengacar
mengacara
mengacarakan
mengacau
mengacaubalaukan
mengacaukan
mengaci-acikan
mengacikan
mengacip
mengacu-acu
mengacuhkan
mengacukan
mengacungkan
mengada-ada
mengadabi
mengadakan
mengadang-adangi
mengadangi
mengadangkan
mengadaptasikan
mengadatkan
mengadem
mengadili
mengadimkan
mengadopsi
mengadreskan
mengadu
mengadudombakan
mengaduh
mengaduk-aduk
mengadukan
mengadukkan
mengadunkan
mengafani
mengafiatkan
mengafirkan
mengagah
mengagak-agak
mengagakan
mengagakkan
mengagamakan
mengagani
mengagas
mengagendakan
mengageni
mengagetkan
mengagih
mengagihkan
mengagitasi
mengagresi
mengagulkan
mengagumi
mengagumkan
mengagungkan
mengagunkan
mengahadkan
mengahlikan
mengaibkan
mengail
mengairi
mengais-ngais
mengaiskan
mengait
mengaitkan
mengajaibkan
mengajakkan
mengajangi
mengajar
mengajari
mengajarkan
mengaji
mengajikan
mengajun
mengakak
mengakali
mengakalkan
mengakan
mengakankan
mengakap
mengakar
mengakas
mengakhiri
mengakhirkan
mengaki
mengakibatkan
mengakikahkan (anak)
mengakomodasi
mengakrabi
mengakrabkan
mengakronimkan
mengaksentuasi
mengaksentuasikan
mengaksep
mengakses
mengaktifkan
mengaktualisasi
mengaktualisasikan
mengaktualkan
mengaku
mengakui
mengakuisisi
mengakukan
mengakumulasi
mengakurkan
mengalah
mengalahi
mengalahkan
mengalaikan
mengalamati
mengalamatkan
mengalang
mengalang-alangi
mengalangi
mengalangkan
mengalas
mengalasi
mengalaskan
mengalati
mengalatkan
mengalengkan
mengali-ali
mengalicaukan
mengalih
mengalihaksarakan
mengalihbahasakan
mengalihfungsikan
mengalihkan
mengalihtugaskan
mengalikan
mengalimantang
mengalir
mengaliri
mengalirkan
mengalit
mengalkulasi
mengalkulasikan
mengalokasikan
mengalpakan
mengalum
mengalun
mengalungkan
mengalunkan
mengalupi
mengalur-alur
mengalutkan
mengalutmalutkan
mengamalkan
mengamanahkan
mengamanati
mengamanatkan
mengamang-amang
mengamangi
mengamankan
mengamarkan
mengamat-amati
mengambai
mengambai-ambaikan
mengambang
mengambang-ambang
mengambekparamaartakan
mengambi
mengambil
mengambili
mengambilkan
mengambin
mengambinghitamkan
mengambrukkan
mengambung
mengambung-ambung
mengambung-ambungkan
mengamini
mengaminkan
mengamit-ngamitkan
mengamitkan
mengamkan
mengamortisasi
mengampai
mengampaikan
mengampanyekan
mengampas
mengampelas
mengampelasi
mengamplopi
mengamplopkan
mengampuh
mengampuhkan
mengampukan
mengampung
mengampuni
mengampunkan
mengamputasi
mengamuflase
mengamuk
mengamukkan
mengamus
mengamuskan
menganakemaskan
menganaktirikan
menganalisis
menganalogikan
menganan
menganankan
mengancai-ancaikan
mengancaikan
mengancak-ancak
mengancamkan
mengancang
mengancang-ancang
mengancar-ancar
mengancing
mengancingkan
mengandakkan
mengandalkan
mengandam
mengandamkan
mengandangkan
mengandarkan
mengandaskan
mengandidatkan
menganduhkan
mengandul
mengandung
mengandungi
menganehkan
menganekajeniskan
menganekakan
menganekaragamkan
menganeksasi
menganeksasikan
mengangakan
mengangan
mengangan-angan
mengangan-angankan
mengangankan
mengangeni
menganggali
menganggalkan
menganggap
menganggapkan
menganggarkan
menganggrekkan
mengangguk
mengangguk-angguk
menganggukkan
menganggul
menganggungkan
menganggur
menganggut
menganggut-anggut
mengangin
mengangin-anginkan
mengangini
menganginkan
mengangkakan
mengangkang
mengangkangi
mengangkangkan
mengangkasa
mengangkat
mengangkat-angkat
mengangkati
mengangkatkan
mengangkup
mengangkuti
mengangon
mengangop
mengangsur
mengangsurkan
mengani
menganiaya
menganiayai
menganjak
menganju
menganjung
menganjung-anjung
menganjung-anjungkan
menganjungkan
menganjur
menganjuri
menganjurkan
mengantang
mengantapkan
mengantar
mengantara
mengantarai
mengantari
mengantarkan
mengantepi
mengantikkan
menganting
mengantisipasi
mengantisipasikan
mengantongi
mengantre
mengantuk
mengantukkan
menganugerahi
menganugerahkan
menganuti
menganvaskan
menganyang
mengaoki
mengap
mengap-mengap
mengapa-apai
mengapai
mengapakan
mengapalkan
mengapam
mengaparkan
mengapi
mengapi-apikan
mengapikkan
mengapit
mengapkir
mengaplikasikan
mengaplus
mengapokkan
mengapresiasi
mengapteni
mengapung
mengapungkan
mengapur
mengarah
mengarah-arahi
mengarahkan
mengarak
mengaram
mengaramkan
mengarang
mengarang-ngarang
mengarangkan
mengaransemen
mengarantinakan
mengaras
mengarau
mengarbida
mengarbol
mengares
mengari
mengarib
mengaribi
mengaribkan
mengarifi
mengarifkan
mengarih-arih
mengarihkan
mengarit
mengaron
mengarsipkan
mengartikan
mengartikelkan
mengartukan
mengartumerahkan
mengarungi
mengaruniai
mengaruniakan
mengarus
mengarut
mengarwahkan
mengaryakan
mengasa
mengasadkan
mengasah
mengasak
mengasakan
mengasakkan
mengasalkan
mengasam
mengasami
mengasamkan
mengasap
mengasapi
mengasari
mengasarkan
mengasaskan
mengasetkan
mengasi
mengasidahkan
mengasih
mengasihani
mengasihi
mengasim
mengasing
mengasingkan
mengasini
mengasinkan
mengasisteni
mengasongkan
mengasosiasikan
mengasramakan
mengastrasi
mengasumsikan
mengasuransikan
mengasyiki
mengasyikkan
mengata
mengata-ngatai
mengatai
mengatak
mengatakan
mengatalisasi
mengatalisit
mengatalogkan
mengatap
mengatapi
mengatari
mengatas
mengatasi
mengataskan
mengatasnamakan
mengategorikan
mengati
mengatrol
mengatup
mengatup-ngatupkan
mengatupkan
mengatur
mengaturkan
mengatus
mengatuskan
mengaudit
mengaulkan
mengaum
mengaum-aum
mengaum-aumkan
mengaung
mengaus
mengausi
mengauskan
mengautopsi
mengaveling
mengawabekukan
mengawahamakan
mengawaki
mengawal
mengawali
mengawamkan
mengawan
mengawang
mengawani
mengawasi
mengawaskan
mengawatkan
mengawetkan
mengawih
mengawin
mengawini
mengawinkan
mengawuri
mengawurkan
mengayakan
mengayau
mengayuh
mengayuhkan
mengayun
mengayunkan
mengazab
mengazabkan
mengazamkan
mengazankan
mengebal
mengebalkan
mengebaskan
mengebat
mengebatkan
mengebel
mengebelakangkan
mengebiri
mengebiskan
mengebom
mengebon
mengebor
mengebumikan
mengebuti
mengecambahkan
mengecamkan
mengecap
mengecapkan
mengecas
mengecaskan
mengecat
mengecek
mengecekkan
mengeceng
mengecengkan
mengecerkan
mengecewakan
mengecil
mengecilkan
mengecimus
mengecoh
mengecohkan
mengecu
mengecualikan
mengecundang
mengecundangi
mengecup
mengecut
mengecutkan
mengedaikan
mengedangkan
mengedar
mengedari
mengedarkan
mengedepankan
mengedik
mengedikkan
mengedipkan
mengedor
mengedot
mengedrel
mengedril
mengeduk
mengedumkan
mengedut
mengedutkan
mengefektifkan
mengefisienkan
mengegolkan
mengegosi
mengegoskan
mengegungkan
mengejai
mengejam
mengejami
mengejamkan
mengejan-ejan
mengejang
mengejangkan
mengejap
mengejapkan
mengejar
mengejar-ngejar
mengejarkan
mengejawantahkan
mengejikan
mengejut
mengejut-ngejuti
mengejuti
mengejutkan
mengekalkan
mengekang
mengekar
mengekarkan
mengekek
mengeker
mengekir
mengekirkan
mengeklirkan
mengekor
mengeksamen
mengeksklusifkan
mengeksploitasi
mengeksplorasi
mengekspor
mengekspresikan
mengekstrak
mengekstraksi
mengelabang
mengelaborasi
mengelabui
mengelah
mengelai-ngelai
mengelak
mengelakkan
mengelam
mengelamini
mengelamkan
mengelana
mengelap
mengelapkan
mengelar
mengelarai
mengelas
mengelaskan
mengelebatkan
mengelebekkan
mengelebukan
mengelektrifikasi
mengelelotkan
mengelem
mengelepai
mengelepik-ngelepik
mengelibat
mengelih
mengelik
mengelikkan
mengelilingi
mengelilingkan
mengelim
mengeliminasi
mengeling
mengelip-ngelip
mengelirukan
mengelit
mengelite
mengelitkan
mengelodan
mengelok
mengelokkan
mengelompok
mengelompokkan
mengelopak
mengeloskan
mengelu-elukan
mengeluani
mengeluarkan
mengeluh
mengeluhkan
mengelumuni
mengelupaskan
mengelus-elus
mengeluyur
mengemam
mengemas
mengemasi
mengemaskan
mengemat
mengembalikan
mengemban
mengembang
mengembangbiakkan
mengembangkan
mengembarai
mengembargo
mengembari
mengembarkan
mengembatkan
mengembik
mengembun
mengembungkan
mengembuni
mengembunkan
mengembur
mengembus
mengembuskan
mengembut-embut
mengemendang
mengemohi
mengempa
mengempang
mengempapkan
mengempas-empaskan
mengempaskan
mengempat puluh hari
mengemping
mengempis
mengempiskan
mengempohi
mengempos
mengemprit
mengempu
mengempukkan
mengemudiankan
mengemudikan
mengemuka
mengemukakan
mengemuli
mengena
mengenakan
mengenakkan
mengenal
mengenali
mengenangkan
mengenap
mengenap-enapkan
mengenaskan
mengencangkan
mengencani
mengencerkan
mengencingi
mengencongkan
mengencreng
mengendalakan
mengendalikan
mengendap
mengendap-endap
mengendapkan
mengendarai
mengendur
mengendurkan
mengeneskan
mengenggankan
mengengkeng
mengenjak-enjak
mengenkripsi
mengentak-entakkan
mengental
mengentalkan
mengentarakan
mengentaskan
mengentengkan
mengentuti
mengenyahkan
mengenyakkan
mengenyal
mengenyangkan
mengeong
mengepak
mengepak-ngepak
mengepak-ngepakkan
mengepakkan
mengepal
mengepal-ngepalkan
mengepalai
mengepalakan
mengepalkan
mengepang
mengepas
mengepaskan
mengepel
mengepil
mengepilkan
mengeping
mengepit
mengepos
mengepres
mengepukkan
mengepul
mengepulkan
mengepung
mengerabik
mengerabikkan
mengerabu
mengerahkan
mengerakahi
mengerakali
mengeramasi
mengeramatkan
mengerami
mengeramkan
mengerang
mengerapkan
mengeras
mengerasi
mengeraskan
mengerat
mengeratkan
mengerawang
mengerdomkan
mengerek
mengerem
mengereng
mengerepas
mengeri
mengeriap
mengericau
mengerih
mengerik
mengerikan
mengerikil
mengerikili
mengering
mengeringi
mengeringkan
mengeris
mengerisik
mengerising
mengerit
mengeriting
mengeritingi
mengeritingkan
mengeritkan
mengerjakan
mengerjang
mengerjap-ngerjap
mengerlap
mengerling
mengerling-ngerling
mengerlip
mengerneti
mengernyih
mengernyit
mengernyitkan
mengernyut
mengerok
mengeroncongkan
mengeropeng
mengerosong
mengerotkan
mengerpus
mengersik
mengertangkan
mengerti
mengertikan
mengerubungi
mengerucut
mengerudungi
mengeruh
mengeruhkan
mengeruk
mengerukkan
mengerukutkan
mengerul
mengerumukkan
mengerumuni
mengeruntungkan
mengerut
mengerutkan
mengesah
mengesahkan
mengesak
mengesakan
mengesakkan
mengesalkan
mengesampingkan
mengesan
mengesankan
mengesat
mengesinikan
mengesip
mengesir
mengesisikan
mengesokkan
mengesol
mengesolkan
mengesom
mengesot
mengesot-esot
mengesumba
mengesun
mengesup
mengetahui
mengetam
mengetamkan
mengetanahkan
mengetap
mengetatkan
mengeteki
mengetem
mengetemui
mengetemukan
mengeteng
mengetengahi
mengetengahkan
mengetengi
mengetengkan
mengetepikan
mengetes
mengetesi
mengetik
mengetil
mengeting
mengetip
mengetok
mengetop
mengetos
mengetrek
mengetsa
mengetuai
mengetuk
mengetulkan
mengevakuasi
mengevaluasi
menggaba-gabai
menggabak
menggabas
menggabrukkan
menggabung
menggabungkan
menggabus
menggacok
menggada
menggadai
menggadaikan
menggadang
menggading
menggadis
menggaduh
menggaduhkan
menggaduk
menggaduki
menggaet
menggagah
menggagahi
menggagahkan
menggagalkan
menggagap
menggaham
menggaib
menggairahkan
menggajah
menggaji
menggala
menggalahkan
menggalak
menggalakkan
menggalang
menggalangi
menggalangkan
menggalas
menggali-gali
menggalibkan
menggalur-galur
menggalurkan
menggamak-gamak
menggamat
menggambar
menggambari
menggambarkan
menggamit
menggamit-gamitkan
menggampangkan
mengganas
menggancu
menggandakan
menggandar
menggandeng
menggandengkan
menggandrungi
menggandrungkan
menggandul
mengganduli
menggandung
mengganggang
mengganggangkan
menggangsi
menggangsir
mengganjak
mengganjakkan
mengganjal
mengganjali
mengganjari
mengganjarkan
mengganjil
mengganjilkan
mengganjur
mengganjuri
menggantang
mengganti
menggantikan
menggantol
menggantung
menggantungi
menggantungkan
menggaok
menggapai
menggapai-gapai
menggapai-gapaikan
menggapil
menggapit
menggaploki
menggaram
menggarami
menggaramkan
menggarang
menggarangkan
menggari
menggaris
menggarisbawahi
menggarisi
menggariskan
menggarit
menggaritkan
menggarong
menggaru
menggaruk
menggaruk-garuk
menggarukkan
menggarung
menggasak
menggasakkan
menggatalkan
menggatra
menggaul
menggauli
menggaulkan
menggaung
menggawat
menggaya
menggayakan
menggayung
menggayuti
menggayutkan
menggebu-gebu
menggebuki
menggecarkan
menggegar
menggegarkan
menggegas
menggegaskan
menggeger
menggegerkan
menggejala
menggejolak
menggejos
menggejoskan
menggelakkan
menggelamai
menggelandang
menggelanggang
menggelantung
menggelap
menggelapkan
menggelar
menggelari
menggelas
menggelasir
menggeleber
menggeledahi
menggelegak
menggelegakkan
menggelegar
menggelekkan
menggelembung
menggelendong
menggelendot
menggeleng
menggeleng-gelengkan
menggelengkan
menggelepar
menggelepar-gelepar
menggelepar-geleparkan
menggelepur
menggeleserkan
menggeletakkan
menggeli
menggeliang
menggeliang-geliutkan
menggeliat
menggelikan
menggelimangi
menggelimuni
menggelincirkan
menggelinding
menggelinding-gelinding
menggelindingkan
menggelingsir
menggelisahi
menggelisahkan
menggelitik
menggelombang
menggelora
menggelorakan
menggelugut
menggelundung
menggelundungkan
menggelung
menggelungkan
menggelut
menggeluti
menggema
menggemai
menggemak-gemak
menggemakan
menggemal
menggemari
menggemarkan
menggemaskan
menggembalakan
menggembar-gemborkan
menggembirakan
menggembok
menggembosi
menggemboskan
menggembungkan
menggemburkan
menggembut
menggemeretakkan
menggempakan
menggemparkan
menggemukkan
menggemulai
menggenang
menggenangi
menggenapi
menggenapkan
menggencar
menggencarkan
menggencat
menggencet
menggendaki
menggendalakan
menggenduti
menggendutkan
menggeneralisasi
menggenggam
menggenggamkan
menggenta
menggentar
menggentari
menggentarkan
menggentas
menggentel
menggenteli
menggentingkan
menggeprak
menggerabakkan
menggeragai
menggerak-gerakkan
menggerakkan
menggeram
menggeramkan
menggerang
menggerantang
menggerawatkan
menggerayangi
menggerbangkan
menggerecoki
menggerek
menggerekkan
menggerendel
menggergaji
menggericau
menggerinda
menggerinjam
menggerisik
menggermang
menggermut
menggermuti
menggerobok
menggerodak
menggeronggang
menggerpol
menggertak
menggertakkan
menggeru
menggeruh
menggeruit
menggerung
menggerunkan
menggerupukkan
menggerus
menggerutu
menggesa
menggesa-gesakan
menggesek
menggesekkan
menggesel
menggeser
menggetah
menggetang
menggetap
menggetar
menggetarkan
menggiatkan
menggidikkan
menggigih
menggigiti
menggila
menggilakan
menggilapkan
menggili-gili
menggincu
menggirangkan
mengglasir
mengglobal
menggobek
menggocoh
menggodai
menggodak
menggodam
menggodot-godot
menggojloki
menggolak-galikkan
menggolek
menggolekkan
menggolok
menggolong
menggolongkan
menggondokkan
menggonggongi
menggontai
menggorek-gorek
menggoreng-goreng
menggores
menggoreskan
menggosipkan
menggosok
menggosok-gosok
menggosokkan
menggoyahkan
menggoyang
menggoyang-goyangkan
menggoyangkan
menggranat
menggrataki
menggratiskan
menggraver
menggudangkan
menggugat
menggugupkan
menggugurkan
mengguit-guit
menggula
menggulai
mengguling
menggulingkan
menggulir
menggulirkan
menggulung
menggulut
menggumalkan
menggumam
menggumpal
menggumuli
menggunakan
mengguncangkan
menggundahkan
menggundul
menggunduli
menggundulkan
menggunggung
menggunjing
menggunjingkan
menggunting
mengguntung
mengguntur
menggunturkan
menggunung
menggurah
mengguram
menggurat
mengguraukan
menggurdi
menggurita
mengguruh
menggurui
menggusari
menggusarkan
mengguyurkan
menghabisi
menghabiskan
menghablur
menghablurkan
menghadap
menghadapi
menghadapkan
menghadiahkan
menghadiri
menghadirkan
menghadkan
menghafal
menghafalkan
menghajati
menghajatkan
menghajikan
menghaki
menghakimi
menghakkan
menghalai-balaikan
menghalakan
menghalalkan
menghalang-halangi
menghalangi
menghalusi
menghaluskan
menghamba
menghambai
menghambakan
menghambur
menghambur-hamburkan
menghamburi
menghamburkan
menghamili
menghamilkan
menghampakan
menghampari
menghamparkan
menghampiri
menghampirkan
menghamuni
menghancurkan
menghancurleburkan
menghancurluluhkan
menghangat
menghangati
menghangatkan
menghangus
menghanguskan
menghantam
menghantamkan
menghantar
menghantarkan
menghantu
menghantui
menghanyutkan
menghapus
menghapuskan
mengharamkan
mengharap
mengharapkan
menghardik
menghargai
menghargakan
mengharimau
mengharmonikan
mengharmoniskan
mengharu
mengharu biru
mengharubirukan
mengharukan
mengharum
mengharumi
mengharumkan
mengharuskan
menghasilkan
menghasratkan
menghasta
menghasud
menghauskan
menghawa
menghawakan
menghayati
menghebat
menghebatkan
menghebohkan
menghelakan
menghelat
menghemat
menghembalangkan
menghempapkan
menghempaskan
menghendaki
mengheningkan
menghentikan
mengherani
mengherankan
menghias
menghiasi
menghibahkan
menghidrogenasi
menghidrolisis
menghidroponikkan
menghidung
menghidupi
menghidupkan
menghierarkikan
menghijau
menghijaukan
menghijrahkan
menghikayatkan
menghilang
menghilangkan
menghilir
menghiliri
menghilirkan
menghimpun
menghimpunkan
menghina
menghinadinakan
menghinakan
menghindari
menghindarkan
menghinggakan
menghinggapi
menghinggut
menghipnosis
menghipotesiskan
menghirap
menghiruk
menghirukkan
menghisab
menghisabkan
menghitam
menghitam-memutihkan
menghitami
menghitamkan
menghitamputihkan
menghitung
menghitung-hitung
menghitungi
menghitungkan
menghomoi
menghonori
menghormat
menghormati
menghubung-hubungkan
menghubungi
menghubungkan
menghujan
menghujan-hujankan
menghujani
menghujankan
menghujat
menghukum
menghukumkan
menghulu
menghulukan
menghuni
menghunikan
menghunjamkan
menghutan
menghutankan
mengiahkan
mengiakan
mengialkan
mengiang
mengiang-ngiang
mengias
mengiasi
mengiaskan
mengibai
mengibakan
mengibar-ngibarkan
mengibaratkan
mengibarkan
mengibas-ngibas
mengibas-ngibaskan
mengibaskan
mengiblatkan
mengibuli
mengicu
mengidah
mengidahkan
mengidam
mengidam-idamkan
mengidamkan
mengidapkan
mengidas
mengidealisasikan
mengidealkan
mengidentifikasi
mengidentikkan
mengidolakan
mengidung
mengidungkan
mengigaukan
mengijabkan
mengijing
mengijmalkan
mengijuk
mengikal
mengikat
mengikatkan
mengikhlaskan
mengikhtiarkan
mengikhtisarkan
mengikik
mengikir
mengikis
mengiklankan
mengikrarkan
mengiktikadkan
mengikut
mengikuti
mengikutkan
mengikutsertakan
mengilah
mengilah-ngilahkan
mengilai-ilai
mengilan
mengilang
mengilap
mengilapkan
mengilas
mengilat
mengilat-ngilatkan
mengilatkan
mengilau
mengiler
mengiles
mengilhami
mengilhamkan
mengili
mengilik-ngilik
mengilir
mengilmiahkan
mengilmukan
mengilo
mengilokan
mengilustrasikan
mengimak-imak
mengimami
mengimani
mengimbal
mengimbali
mengimbalkan
mengimbang
mengimbangi
mengimbangkan
mengimbas
mengimbasi
mengimbuh
mengimbuhi
mengiming-iming
mengimitasi
mengimlakan
mengimpal
mengimpas
mengimpaskan
mengimpit
mengimpitkan
mengimplementasikan
mengimplikasikan
mengimplisitkan
mengimpor
mengimprovisasikan
menginai
menginang
menginap
menginapkan
mengincar
mengincitkan
mengincup
mengindahkan
mengindang
mengindekoskan
mengindikasikan
mengindoktrinasi
mengindonesiakan
mengindra
menginduk
menginduksi
mengindustrikan
menginfakkan
menginfeksi
menginfiltrasi
menginfiltrasikan
menginformasikan
menginfus
mengingari
mengingarkan
mengingat
mengingati
mengingatkan
mengingaukan
mengingini
menginginkan
mengingkari
mengingsut
mengingsutkan
mengingusi
menginisiasikan
menginjak
menginjak-injak
menginjakkan
menginjap
menginjeksi
menginjil
menginkorporasikan
menginovasikan
menginsafi
menginsafkan
menginsinuasi
menginspeksi
menginspirasi
menginspirasikan
menginstruksikan
mengintaikan
mengintegrasikan
mengintensifkan
menginterlokal
menginternasional
menginternasionalkan
menginterogasi
menginterpretasikan
menginterupsi
mengintervensi
menginterviu
mengintil
mengintimi
mengintimidasi
mengintroduksi
mengintroduksikan
mengintrospeksi
menginvasi
menginventarisasi
menginventarisasikan
menginvestasikan
mengionkan
mengipas
mengipas-ngipas
mengipasi
mengipaskan
mengira
mengira-ngira
mengira-ngirakan
mengirabkan
mengirai
mengiraikan
mengiramakan
mengirapkan
mengiras
mengiras-iras
mengiras-irasi
mengiri
mengirikan
mengirim
mengirimi
mengirimkan
mengiring
mengiringi
mengiringkan
mengiris
mengiris-iris
mengiriskan
mengirit
mengisa
mengisahkan
mengisapkan
mengisar
mengisarkan
mengisas
mengisatkan
mengisbatkan
mengisengi
mengisi
mengisikan
mengislahkan
mengislamkan
mengisolasi
mengisolasikan
mengisruhkan
mengistiadatkan
mengistikmalkan
mengistilahkan
mengistimewakan
mengistirahatkan
mengisukan
mengisut
mengisutkan
mengisyaratkan
mengitar
mengitar-ngitar
mengitari
mengitarkan
mengitik-ngitik
mengizinkan
mengkaji
mengkeret
mengkhalayak
mengkhasiati
mengkhatamkan
mengkhawatirkan
mengkhayal
mengkhayalkan
mengkhianat
mengkhianati
mengkhitan
mengkhitankan
mengkhotbahkan
mengkhusus
mengkhususkan
mengkis
mengklaim
mengklakson
mengklarifikasi
mengklasifikasi
mengklasifikasikan
mengkliring
mengklise
mengklonakan
mengkredit
mengkreditkan
mengkrisis
mengkristal
mengkristenkan
mengkritik
mengkritis
mengnyinergikan
mengobarkan
mengobati
mengobatkan
mengobjek
mengobjekkan
mengobok
mengobor
mengobori
mengobral
mengobralkan
mengobrolkan
mengobservasi
mengocak
mengocakkan
mengocok
mengocong
mengocongkan
mengodekan
mengodifikasikan
mengodol-odol
mengogel
mengojek
mengojekkan
mengokot
mengoksidasi
mengolah
mengolahragakan
mengolak
mengolak-alik
mengolak-alikkan
mengolang-aling
mengolang-alingkan
mengoleksi
mengoleng
mengoleng-oleng
mengoleskan
mengolok-olok
mengomando
mengomandokan
mengombak
mengombang-ambingkan
mengombinasikan
mengomeli
mengomentari
mengomersialkan
mengomidikan
mengomisi
mengomong
mengomongkan
mengompol
mengompori
mengompos
mengompreng
mengompres
mengomputerkan
mengomunikasikan
mengomuniskan
mengonarkan
mengonde
mengondensasikan
mengondisikan
mengonferensikan
mengonfirmasikan
mengonggokkan
mengongkoki
mengongkong
mengongkosi
mengononkan
mengonsentrasikan
mengonsep
mengonslah
mengonsolidasikan
mengonsumsi
mengontak
mengontaminasi
mengontan
mengontrak
mengontrakkan
mengontraskan
mengontrol
mengonvergensikan
mengonversikan
mengonyokkan
mengooptasi
mengoordinasi
mengoordinasikan
mengopak
mengopek
mengopeletkan
mengoperasi
mengoperasikan
mengoperkan
mengopi
mengoposisi
mengoptimalkan
mengoptimumkan
mengorak-arik
mengorangkan
mengorankan
mengorat-oret
mengorbankan
mengorbit
mengorbitkan
mengored
mengorek
mengorek-ngorek
mengoreksi
mengorelasikan
mengoret-oret
mengorganisasi
mengorkestrasikan
mengornamenkan
mengorok
mengorok-orok
mengorting
mengorup
mengorupsi
mengosongkan
mengota
mengotak
mengotak-ngatikkan
mengotak-ngotakkan
mengotaki
mengotomatiskan
mengotonomikan
mengotori
mengotorkan
mengotot
mengoyak
mengoyak-ngoyak
mengoyak-ngoyakkan
mengoyak-oyak
mengoyok
mengqasar
menguahi
menguahkan
menguak
menguakkan
mengualifikasikan
menguankan
menguap
menguapi
menguapkan
menguar-nguarkan
menguar-uarkan
menguarkan
menguasai
menguasakan
menguat
menguati
menguatkan
mengubah
mengubahkan
mengubak
menguban
mengubangkan
mengubani
menguber-uber
mengubrakan
mengububi
mengubui
mengubung
mengubungkan
mengubur
menguburkan
mengucak
mengucap
mengucapkan
mengucar-ngacirkan
mengucek-ucek
mengucilkan
mengucur
mengucuri
mengucurkan
mengudap
mengudar
mengudara
mengudarakan
mengudari
mengudarkan
mengudeta
mengudian
mengudiankan
mengudung
mengudungkan
menguduskan
mengufurkan
mengugut
menguik
menguik-uik
menguit
mengujarkan
menguji
mengujud
mengujudkan
mengujung
mengujut
mengukir
mengukiri
mengukirkan
mengukuhi
mengukuhkan
mengukupi
mengukur
mengukus
mengulang
mengulang-ulang
mengulangi
mengulas
mengulasi
mengulek
menguli
menguliahi
mengulit
mengulit-ulit
menguliti
mengulitkan
mengultuskan
mengulum-ngulum
mengulur-ulur
mengulurkan
mengumai
mengumaikan
mengumalkan
menguman-uman
mengumandang
mengumandangkan
mengumbang
mengumbuk
mengumbut
mengumpak
mengumpak-umpak
mengumpamai
mengumpamakan
mengumpan
mengumpani
mengumpankan
mengumpat
mengumpulkan
mengumuhkan
mengumumkan
mengumun
mengumunkan
mengunci
menguncikan
menguncup
menguncupkan
mengundai
mengundangkan
mengundi
mengundur
mengundurkan
mengunggas
mengungguli
mengunggun
mengunggunkan
mengunggut
mengungkang
mengungkapi
mengungkapkan
mengungkit
mengungkit-ungkit
mengungkung
mengungsikan
menguning
menguningkan
mengunjukkan
mengunjungi
mengunjur
mengunjurkan
mengunjutkan
menguntai
menguntal
mengunting
menguntiti
menguntukkan
menguntum
menguntungkan
mengunyahkan
mengunyai
mengupa-upa
mengupah
mengupahi
mengupahkan
mengupak
menguparkan
mengupaskan
mengupayakan
mengupil
menguping
mengupingi
mengurai
menguraikan
mengurang
mengurangi
mengurangkan
mengurap
mengurapi
menguras
mengurasi
menguraskan
mengurbankan
menguret
mengurik-urik
mengursus
mengursuskan
menguruk
mengurung
mengurungkan
mengurus
mengurusi
menguruskan
mengurut
mengurutkan
mengusa
mengusahakan
mengusai
mengusaikan
mengusaki
mengusang
mengusik
mengusil-usil
mengusil-usilkan
mengusrukkan
mengusuk
mengusul
mengusuli
mengusulkan
mengusung
mengusut
mengusutkan
mengutak-atik
mengutak-ngatikkan
mengutamakan
mengutangi
mengutangkan
mengutara
mengutik
mengutik-ngutik
mengutuhkan
mengutui
mengutuk
mengutuki
menguyuh
menguyuhi
menguyup
menguyupkan
meniada
meniadakan
meniaga
meniagakan
meniangpancangi
meniani
meniapkan
meniarap
meniarapkan
meniatkan
menidakkan
meniduri
menidurkan
meniga
menigari
menihilkan
menika-nika
menikah
menikahi
menikahkan
menikai
menikam
menikamkan
menikmati
menikus
menilai
menilang
menilik
menimang-nimang
menimangkan
menimba
menimbal
menimbali
menimbang
menimbang-nimbang
menimbangi
menimbangkan
menimbel
menimbul
menimbulkan
menimbun
menimbun-nimbun
menimbuni
menimbunkan
menimbusi
menimpa
menimpakan
menimpang
menimpang-nimpangkan
menimpangkan
menimpuki
menimur
meninabobokan
menindak
menindakkan
menindaklanjuti
menindan
menindih
menindik
meninggal
meninggali
meninggalkan
meninggam
meninggi
meninggikan
meninggung
meningkah
meningkahi
meningkap
meningkat
meningkat-ningkat
meningkatkan
meningratkan
meninju
meninjukan
menintai
menipis
menipiskan
menipu
meniris
meniriskan
meniru-niru
menirukan
menirus
menisbikan
menisiki
menista
menistakan
menitahkan
menitar-nitarkan
menitik
menitikberatkan
menitiki
menitikkan
menitipkan
menitir
menitis
menitiskan
meniup
meniup-niup
meniupkan
meniwahkan
menjadi
menjadi-jadi
menjadi-jadikan
menjadikan
menjadwalkan
menjaga
menjagakan
menjagal
menjagoi
menjagokan
menjagung
menjahanamkan
menjahar
menjahati
menjahatkan
menjahili
menjahit
menjaili
menjaja
menjajahi
menjajakan
menjajar
menjajarkan
menjala
menjalakan
menjalang
menjalani
menjalankan
menjalar
menjalari
menjalarkan
menjalin
menjalinkan
menjalu
menjamak
menjamakkan
menjambak
menjampi
menjampikan
menjamu
menjamukan
menjamur
menjanda
menjangak
menjangankan
menjangat
menjangati
menjanggalkan
menjangka
menjangkakan
menjangkang
menjangkau
menjangki
menjangkit
menjangkitkan
menjanjikan
menjantani
menjantung
menjantur
menjara
menjarah
menjarak
menjaraki
menjarakkan
menjaram
menjarang
menjarangkan
menjaras
menjari
menjaring
menjaringkan
menjarum
menjatah
menjatuhi
menjatuhkan
menjauh
menjauhi
menjauhkan
menjawab
menjawat
menjawikan
menjayakan
menjebak
menjebol
menjebolkan
menjebrolkan
menjebur
menjeburkan
menjedot-jedotkan
menjejak
menjejaki
menjejakkan
menjejal
menjejali
menjejalkan
menjelajahi
menjelangi
menjelaskan
menjelejeh
menjelek-jelekkan
menjelekkan
menjelijih
menjelmakan
menjeluak
menjelujuri
menjelum
menjeluskan
menjemaahkan
menjembatani
menjempalit
menjemput
menjemukan
menjemur
menjenangi
menjenengkan
menjengek-jengek
menjengeki
menjengit-jengit
menjengkal
menjengkali
menjengkang
menjengkeli
menjengkelkan
menjengkeng
menjengket
menjengkot
menjengukkan
menjenis
menjenuhkan
menjerakan
menjeramah
menjerambah
menjerangkang
menjerat
menjerauskan
menjerempak
menjeriau
menjerihkan
menjerit
menjerit-jerit
menjerkah
menjernihkan
menjeruki
menjidari
menjijikkan
menjilat-jilat
menjilid
menjimak
menjinaki
menjinakkan
menjinjingkan
menjitukan
menjiwai
menjodohkan
menjoget
menjolak
menjompak
menjoreng
menjorokkan
menjotos
menjuak
menjuakkan
menjual
menjualbelikan
menjuali
menjualkan
menjuarai
menjubeli
menjudikan
menjujah
menjujuh
menjujuri
menjulai
menjulat
menjuling
menjulurkan
menjumbai
menjumlah
menjumlahkan
menjumpai
menjumputi
menjungkalkan
menjungkat-jungkit
menjungkir
menjungkirbalikkan
menjungur
menjunjungkan
menjuntai
menjuntaikan
menjurubicarai
menjurus
menjuruskan
menjustifikasikan
menobak
menobatkan
menodai
menodongkan
menogelkan
menohok
menohokkan
menohorkan
menokoh
menokohi
menokohkan
menokok
menokong
menolak
menolakkan
menoleh
menolehkan
menoleransi
menolok
menolong
menomboki
menominasikan
menomori
menonaktifkan
menonggokkan
menongkah
menongkat
menongkatkan
menongkrongi
menonjok
menonjol
menonjol-nonjolkan
menonjolkan
menontonkan
menopang
menopengi
menopikkan
menormalisasikan
menormalkan
menorpedo
menotal
menskedulkan
menskemakan
menskenariokan
mensketsa
menskor
mensmokel
mensosialisasikan
menspekulasikan
menspion
mensponsori
menstabilkan
menstandarkan
menstarter
menstarterkan
menstempel
menstensil
mensterilkan
menstimulasi
menstratakan
menstrukturkan
menswastakan
mensyaki
mensyarahkan
mensyaratkan
mensyariatkan
mensyarikat
mensyirikkan
mensyukuri
mensyurkan
mental
mentradisi
mentradisikan
mentraktor
mentransfer
mentransformasikan
mentranskripsikan
mentransmigrasikan
mentransmisikan
mentransmutasikan
mentransplantasikan
mentranspor
mentrompetkan
menua
menuahi
menuahkan
menuai
menuakan
menual
menuam
menuami
menuang
menuangi
menuangkan
menuani
menuankan
menuanrumahi
menuas
menuba
menubai
menubikan
menubruk
menubrukkan
menubuatkan
menubuhkan
menuding
menuding-nuding
menudingkan
menuduhkan
menudung
menudungi
menudungkan
menugal
menugalkan
menugasi
menugaskan
menuguri
menuhankan
menuil
menuilkan
menujahkan
menuju
menujuhbulani
menujui
menujukan
menujum
menujumkan
menukangi
menukar
menukari
menukarkan
menukas
menukasi
menukik
menukikkan
menukilkan
menukul
menulahi
menulangi
menulari
menularkan
menulikan
menulikan telinga
menulis
menulisi
menuliskan
menumangkan
menumbang
menumbangkan
menumbuh
menumbuhi
menumbuhkan
menumbuk
menumbukkan
menumis
menumisi
menumpah-numpahkan
menumpahi
menumpahkan
menumpang
menumpangi
menumpangkan
menumpangsarikan
menumpas
menumpaskan
menumpat
menumpatkan
menumpil
menumplakkan
menumpu
menumpuk
menumpukan
menumpukkan
menumpulkan
menumpur
menumpurkan
menunaikan
menunangi
menunangkan
menunas
menunasi
menunda
menunda-nunda
menundakan
menunduk
menunduk-nunduk
menundukkan
menunggak
menunggal
menunggalkan
menunggang
menunggangi
menunggangkan
menungganglanggangkan
menunggik
menunggikkan
menunggingkan
menunggu
menunggui
menunggukan
menungkai
menungkup
menungkupkan
menungkus
menunjangkan
menunjuk
menunjuki
menunjukkan
menuntaskan
menuntun
menunukan
menurap
menurbakan
menurun
menuruni
menurunkan
menurus
menuruskan
menurut
menuruti
menurutkan
menusuk
menusuk-nusuk
menusukkan
menutuli
menutulkan
menutup
menutupi
menutupkan
menuturkan
menyabak
menyabarkan
menyabdakan
menyabit
menyabitkan
menyablon
menyabun
menyabung
menyabungkan
menyabuni
menyabunkan
menyabur
menyaburkan
menyadaikan
menyadar
menyadari
menyadarkan
menyadau
menyadikkan
menyadur
menyagang
menyagar
menyagu
menyahaja
menyahajakan
menyahap
menyahihkan
menyahut
menyahuti
menyaingi
menyairkan
menyajak
menyajakkan
menyajikan
menyakal
menyakar
menyakiti
menyakitkan
menyaksikan
menyaktikan
menyakukan
menyala
menyala-nyala
menyalah
menyalahartikan
menyalahi
menyalahkan
menyalai
menyalak
menyalakan
menyalam
menyalami
menyalang
menyalangkan
menyalatkan
menyalep
menyalib
menyalibkan
menyalin
menyalini
menyalinkan
menyalju
menyaluir
menyalut
menyaluti
menyama-nyama
menyama-nyamai
menyamai
menyamak
menyamakan
menyamakkan
menyaman
menyamankan
menyamar
menyamaratakan
menyamarkan
menyambal
menyambalewa
menyambalewakan
menyambang
menyambangi
menyambar
menyambar-nyambar
menyambat
menyambilkan
menyambillalukan
menyambiti
menyambung
menyambungkan
menyambut
menyamir
menyampah
menyampai
menyampaikan
menyampak
menyamper
menyamperi
menyamping
menyampingi
menyampingkan
menyampo
menyampu
menyampukkan
menyampul
menyampuli
menyamun
menyamuni
menyanak
menyandakan
menyandang
menyandangkan
menyandar
menyandari
menyandarkan
menyandera
menyanderakan
menyanding
menyandingi
menyandingkan
menyandiwarakan
menyangai
menyangatkan
menyangga
menyanggit
menyanggrah
menyanggul
menyanggulkan
menyanggupi
menyanggupkan
menyangka
menyangkakan
menyangkaki
menyangkal
menyangkarkan
menyangkut
menyangkut-nyangkutkan
menyangkutkan
menyangkutpautkan
menyanglingkan
menyangsikan
menyanjung-nyanjung
menyanjung-nyanjungkan
menyantakkan
menyantap
menyantet
menyantun
menyantung
menyantuni
menyanyi
menyanyikan
menyapa
menyapu
menyapu-nyapu
menyapukan
menyaput
menyaputi
menyara
menyarai
menyarak
menyarangkan
menyarani
menyarankan
menyarap
menyarapi
menyarasehankan
menyarat
menyarat-nyarat
menyarati
menyaraukan
menyarikan
menyaringkan
menyaripatikan
menyaru
menyarukan
menyarung
menyarungkan
menyasak
menyasarkan
menyatai
menyatakan
menyatu
menyatukan
menyatupadukan
menyauk
menyaur
menyauri
menyawah
menyawar
menyayang
menyayangi
menyayangkan
menyayat
menyayat-nyayat
menyayati
menyayembarakan
menyayukan
menyayung
menyayur
menyearahkan
menyeba
menyebabkan
menyebadani
menyebalkan
menyebar
menyebarkan
menyebelah
menyebelahi
menyebelahkan
menyeberang
menyeberangi
menyeberangkan
menyebu
menyebukan
menyebutkan
menyedang
menyedang-nyedang
menyedang-nyedangkan
menyedangkan
menyedapkan
menyedekahi
menyedekahkan
menyederajatkan
menyederhanakan
menyediakan
menyedihkan
menyedikit
menyedikiti
menyedikitkan
menyeduai
menyeduakan
menyegani
menyegarkan
menyegehi
menyegel
menyegerakan
menyehatkan
menyeimbangkan
menyejahterakan
menyejajarkan
menyejarah
menyejarahkan
menyejatkan
menyejuk
menyejukkan
menyeka
menyekai
menyekakan
menyekang
menyekar
menyekat
menyekati
menyekolahkan
menyekresi
menyekrup
menyekutui
menyekutukan
menyela
menyeladang
menyelak
menyelakkan
menyelam
menyelamati
menyelamatkan
menyelami
menyelamkan
menyelampai
menyelampaikan
menyelampitkan
menyelang
menyelang-nyelangkan
menyelang-nyeling
menyelang-nyelingkan
menyelangi
menyelangkan
menyelap
menyelapi
menyelaput
menyelar
menyelara
menyelaraskan
menyelarkan
menyelat
menyelatkan
menyelawat
menyelekehi
menyelekoh
menyeleksi
menyelempangkan
menyelendang
menyelendangi
menyelendangkan
menyelenggarakan
menyelentingkan
menyelesaikan
menyelewengkan
menyelidik
menyelidiki
menyeligi
menyelimuti
menyelimutkan
menyelinapkan
menyeling
menyelingi
menyelingkan
menyelingkit
menyelingkuhkan
menyelingkupi
menyelipi
menyelipkan
menyelisihkan
menyelitkan
menyelongsongi
menyelot
menyelubung
menyelubungi
menyelubungkan
menyeludupkan
menyelukat
menyelundupi
menyelundupkan
menyelungkupi
menyeluruh
menyeluruhi
menyelusupkan
menyelusuri
menyelusurkan
menyemah
menyemahkan
menyemai
menyemaikan
menyemakkan
menyemangati
menyemangatkan
menyemarak
menyemarakkan
menyemat
menyematkan
menyemayamkan
menyembah
menyembahkan
menyembahyangi
menyembahyangkan
menyembamkan
menyembarangi
menyemboyankan
menyembronokan
menyembuhkan
menyembulkan
menyembunyikan
menyembur
menyemburi
menyemburkan
menyemen
menyemir
menyempadani
menyempal
menyempali
menyempang
menyempat
menyempati
menyempatkan
menyempenakan
menyempit
menyempitkan
menyemprit
menyemprot
menyemproti
menyemprotkan
menyempurnakan
menyemu
menyemui
menyemukakan
menyemukan
menyemur
menyemut
menyenak
menyenak-nyenak
menyenakkan
menyenandungkan
menyenangi
menyenangkan
menyenaraikan
menyendal
menyendalkan
menyendat
menyendeng
menyendengkan
menyendi
menyendi-nyendi
menyendikan
menyendiri
menyendirikan
menyendok
menyengaja
menyengajakan
menyengal
menyengap
menyengapkan
menyengar
menyengat
menyengau
menyengaukan
menyenget
menyengetkan
menyenggaki
menyenggangkan
menyenggat
menyenggau
menyenggihkan
menyenggol
menyengit
menyengkang
menyengkela
menyengkelangkan
menyengkeling
menyengkelit
menyengsarakan
menyenguk
menyeni
menyensus
menyentak-nyentak
menyentakkan
menyentalkan
menyentengi
menyentengkan
menyenteri
menyentosakan
menyentralisasi
menyentralkan
menyentuh
menyentuh-nyentuh
menyentuhkan
menyenyumi
menyepadan
menyepah
menyepak
menyepak-nyepakkan
menyepakati
menyepakkan
menyepan
menyepatui
menyepelekan
menyeperah
menyepi
menyepikan
menyepit
menyepuh
menyeragamkan
menyerah
menyerahi
menyerahkan
menyerahterimakan
menyerak
menyerak-nyerakkan
menyerakkan
menyeramkan
menyerampang
menyeranah
menyerandang
menyeranggung
menyerangkaikan
menyeranikan
menyerap
menyerapahi
menyerasikan
menyeratakan
menyeratkan
menyeratus
menyeraya
menyerayakan
menyerbakkan
menyerbeti
menyerbuk
menyerbukan
menyerbuki
menyerbukkan
menyerempak
menyerendeng
menyerendengkan
menyerentakkan
menyerepi
menyerepkan
menyeret
menyeret-nyeret
menyergah
menyeribu (hari)
menyerikan
menyerikati
menyerikatkan
menyerimpung
menyerindaikan
menyering
menyeringai
menyeringing
menyeringkan
menyerit
menyeriusi
menyerkah
menyerkap
menyerkapi
menyerkup
menyerkupkan
menyerok
menyerong
menyerongkan
menyeronokkan
menyerot
menyerpih
menyertai
menyertakan
menyertifikatkan
menyeru
menyeru-nyerukan
menyerudi
menyeruit
menyerukan
menyerum
menyerumahkan
menyerupai
menyerupakan
menyerut
menyervis
menyesah
menyesak
menyesakkan
menyesal
menyesali
menyesalkan
menyesap
menyesarkan
menyesatkan
menyeser
menyesuaikan
menyetan
menyetarafkan
menyetarakan
menyetel-nyetel
menyetelengkan
menyetem
menyeterui
menyetik
menyetimbangkan
menyetip
menyetir
menyetop
menyetorkan
menyetrap
menyetrika
menyetrip
menyetrum
menyetubuhi
menyetui
menyetujui
menyetujukan
menyetum
menyetup
menyewa
menyewakan
menyia-nyiakan
menyiagakan
menyiah
menyiahkan
menyialkan
menyiang
menyiangi
menyiapkan
menyiar
menyiasat
menyiasati
menyiasatkan
menyibak
menyibak-nyibak
menyibakkan
menyibukkan
menyibur
menyidai
menyidaikan
menyidangkan
menyidik
menyiduk
menyifatkan
menyigai
menyigapkan
menyigar
menyigi
menyihir
menyihiri
menyihirkan
menyikapi
menyikat
menyiksa
menyiksai
menyiku
menyikukan
menyikut
menyilakan
menyilam
menyilamkan
menyilang
menyilangi
menyilangkan
menyilap
menyilat
menyilaukan
menyilet
menyilih
menyilukan
menyimbah
menyimbahkan
menyimbang
menyimbolkan
menyimbur
menyimburi
menyimburkan
menyimpai
menyimpaikan
menyimpan
menyimpang
menyimpangkan
menyimpani
menyimpankan
menyimpul
menyimpulkan
menyimulasi
menyimulasikan
menyinambungkan
menyinar
menyinari
menyinarkan
menyinden
menyindir
menyindirkan
menyinetronkan
menyinggahi
menyinggahkan
menyinggang
menyinggit
menyinggung
menyingkap
menyingkapkan
menyingkat
menyingkatkan
menyingkiri
menyingkirkan
menyingkur
menyingsetkan
menyingsingkan
menyinkronkan
menyinter
menyintesis
menyintuk
menyintukkan
menyipat
menyipati
menyipatkan
menyipi
menyipitkan
menyiram
menyirami
menyiramkan
menyirat
menyiratkan
menyirep
menyirepi
menyirih
menyirihkan
menyirip
menyirnakan
menyisai
menyisakan
menyisi
menyisihkan
menyisik
menyisikan
menyisiki
menyisipkan
menyisir
menyistemkan
menyita
menyitat
menyiulkan
menyoal
menyoalkan
menyobat
menyobati
menyobek
menyobek-nyobek
menyobeki
menyodok
menyodomi
menyoga
menyogok
menyoja
menyokom
menyokomkan
menyokong
menyokongkan
menyolder
menyolidkan
menyombong
menyombongi
menyombongkan
menyondong
menyongket
menyongsong
menyopani
menyopankan
menyopir
menyopiri
menyoraki
menyorakkan
menyorong
menyorong-nyorongkan
menyorongkan
menyorot
menyoroti
menyosoh
menyosok
menyoyak
menyoyaknyoyak
menyuakakan
menyuap
menyuapi
menyuapkan
menyuar
menyuarakan
menyuarangkan
menyuarkan
menyuasanai
menyubal
menyubang
menyublim
menyubordinasikan
menyubsider
menyuburkan
menyubversikan
menyucihamakan
menyucikan
menyudahi
menyudahkan
menyudi
menyudikan
menyudip
menyudu
menyudut
menyudutkan
menyugi
menyuguhkan
menyugun
menyugunkan
menyuji
menyukai
menyukakan
menyukarkan
menyukat
menyukseskan
menyula
menyulam
menyulang
menyulangi
menyulangkan
menyulap
menyulih
menyulihi
menyuling
menyulingkan
menyulitkan
menyuluh
menyuluhi
menyulur
menyulut
menyumba
menyumbang
menyumbangkan
menyumbar
menyumbat
menyumbui
menyumirkan
menyumpah
menyumpahi
menyumpal
menyumpalkan
menyumpit
menyumsum
menyunahkan
menyunamkan
menyunat
menyunati
menyunatkan
menyunatrasulkan
menyundal
menyunduk
menyunduki
menyundut
menyungga
menyungging
menyunggingkan
menyungguh-nyungguhi
menyungguhkan
menyungkahkan
menyungkal
menyungkem
menyungkit
menyungkup
menyungkupi
menyungkupkan
menyungkur
menyungsang
menyungsangkan
menyuntikkan
menyuntingkan
menyuplai
menyurai
menyuram
menyuramkan
menyurat
menyurati
menyuratkan
menyurih
menyurihkan
menyuruh
menyuruhkan
menyuruk
menyuruk-nyuruk
menyuruki
menyurukkan
menyuruti
menyurutkan
menyurvei
menyusahi
menyusahkan
menyusu
menyusui
menyusuk
menyusukan
menyusuli
menyusulkan
menyusun
menyusunkan
menyusup
menyusupkan
menyusur
menyusuri
menyusut
menyusuti
menyusutkan
menyuwir
menzalimi
menzalimkan
menzarah
menziarahi
menzinai
mepersegerakan
meraba
meraba-raba
merabai
merabak
meraban
merabas
merabat
merabit
merabuk
merabuki
merabung
merabuni
merabunkan
merabut
meracik
meracun
meracuni
meradak
meradakkan
meradang
meradangkan
meradikalkan
meradiokan
meradukan
meraga
meragakan
meragam
meragamkan
meragi
meragikan
meraguk
meragukan
merahap
merahapkan
merahasiakan
merahimi
meraih
meraja
merajah
merajai
merajakan
merajinkan
merajuki
merajut
merakat
merakit
meraksasa
meraksi
merakyatkan
meralat
meramahi
meramaikan
meramal
meramalkan
merambah
merambahi
merambakkan
merambang
merambang-rambang
merambatkan
merambut
meraminkan
merampai
merampaikan
merampak
merampas
merampasi
merampatkan
meramping
merampingkan
merampok
merampungkan
merampus
meramu
meramus
meranap
merancang
merancangkan
merancap
merancukan
merancung
meranda
merandat
merandatkan
merandaukan
merangah
merangak
meranggas
meranggikan
meranggitkan
meranggung
merangkai
merangkaikan
merangkak-rangkak
merangkakan
merangkaki
merangkakkan
merangkap
merangkapkan
merangkum
merangkumkan
merangkup
merangsang
merangsangkan
meranjangkan
meransum
merantai
merantas
merantau
meranting
merantukkan
meranyah
merapat
merapati
merapatkan
merapik
merapikan
meraporkan
merapuhkan
merapun
merapungkan
merarasi
merasa
merasa-rasai
merasai
merasaikan
merasakan
merasani
merasi
merasiankan
merasikan
merasionalisasi
merasionalkan
merata
merata-ratakan
meratah
meratai
meratakan
meratapi
meratib
meratibkan
meratifikasi
meratus
meraum
meraun
meraung
meraung-raung
meraung-raungkan
merawai
merawak
merawan
merawankan
merawat
merawatkan
merawi
merawikan
merayahi
merayakan
merayap
merayapi
merayau-rayau
merayu
merayu-rayu
merayukan
mercak-mercik
mereaksi
merealisasi
merebah
merebeh
merebuk
merebung
merebut
merebutkan
merecik
merecok
merecoki
merecup
mereda
meredai
meredakan
meredam
meredamkan
meredih
meredik
mereduksi
meredup
meredupkan
meredut
mereekspor
merefleksikan
meregang
meregangkan
mereguk
merehab
merehabilitasi
merehabilitasikan
merejahkan
mereka cipta
mereka-reka
merekam
merekamkan
merekan
merekatkan
merekayasa
merekes
mereklamasikan
merekomendasi
merekonstruksi
merekrut
merelai
merelakan
merelang
merelap
merelap-relap
merelevansi
merelokasi
merelung
meremah-remah
meremahkan
meremajakan
meremang
meremangkan
meremas-remas
merembesi
merembet
merembetkan
merembukkan
meremehkan, meremeh-temehkan
merempah
merempah-rempah
merempah-rempahi
merempahi
meremukkan
merenangi
merenangkan
merencanakan
merenda
merendah
merendahkan
merendai
merendam
merendami
merendamkan
merendang
merendengkan
merengas
merengatkan
merengek-rengek
merengeki
merenggang
merenggangi
merenggangkan
merengkah
merengsa
merenik-renik
merenjis
merenjiskan
merenovasi
merentak
merentan
merentang
merentangi
merentangkan
merentapkan
merenteng
merenungi
merenungkan
merenyah
merenyai-renyai
merenyuk
merenyukkan
merepang
mereparasi
merepatriasi
mereportasekan
merepotkan
mereproduksi
mererak
mererot
meresah
meresahkan
meresan
meresapi
meresapkan
meresepkan
meresmikan
meresosialisasi
merespons
merestorasi
merestrukturisasi
merestui
meresumekan
meretak
meretakkan
meretas
meretur
merevisi
meriangkan
meriap
meriapkan
merias
meribut
meributkan
mericik
meridai
merikuhkan
merimaskan
merimba
merimbas
merimbun
merimpuhkan
merimpung
merinaikan
merincukan
merindang
merindingkan
merindu
merindukan
meringankan
meringgiti
meringkai
meringkaikan
meringkaskan
meringkukkan
merintang
merintang-rintang
merintangi
merintangkan
merintik-rintik
merintis
merisau
merisaukan
meriset
merisikkan
meriwayatkan
merobek
merobek-robek
merobohkan
merodong
merodongkan
merokok
meromantisisme
merombak
merombengkan
merompongkan
meromusakan
merondok
merondokkan
merongga
meronggeng
merongseng
meronta-ronta
merontgen
merontokkan
meronyok
merosokkan
merosot
merosotkan
merotan
meroyan
mertamu
merua
meruahkan
meruang
meruap
meruap-ruap
meruban
merudal
merugi
merugikan
meruing
merujuk
merujuki
meruku
merukuk
merukunkan
merumahkan
merumahsakitkan
merumbu
merumitkan
merumponkan
merumpun
merumput
merumputi
merumuskan
meruncing
meruncingkan
merundingkan
merundukkan
merungguhkan
merungkup
merungus-rungus
merungut
merungut-rungut
merungutkan
merunjung
meruntuh
meruntuhkan
meruntunkan
merunut
merunuti
merunyamkan
merupa
merupai
merupakan
merusak
merusaki
merusakkan
merusuh
merusuhi
merusuhkan
merusuk
merutinkan
meruwat
meruwetkan
meruyak
meruyupkan (mata)
merwatin
mesem
meta
mewabah
mewadahi
mewahyukan
mewajibkan
mewakafkan
mewakili
mewakilkan
mewalikan
mewangi
mewangikan
mewantek
mewanti-wanti
mewarganegarakan
mewari
mewarisi
mewariskan
mewarna-warnikan
mewarnai
mewarnakan
mewartakan
mewasiatkan
mewasiti
mewaspadai
mewaspadakan
mewataki
mewatasi
mewawancarai
mewayangkan
mewedel
mewejang
mewek
mewilayahi
mewiraswastakan
mewiru
mewismakan
mewisuda
mewujud
mewujudkan
meyakin-yakini
meyakini
meyakinkan
midar
milir
mimik
mimisan
mindring
minggat
minggir
minta-minta
minum
mirik
miskram
modar
mogok
mohon
molor
mondar-mandir
mondong
monggol
mongkok
muai
muat
mudik
mudun
mulai
mulazamah
mumbul
muncrat, memuncrat
muncul
mundur
mungkir
muntah
muntup
muring
murka
murtad
murus
musikan
musiman
musnah
mutu
mutung
muwajahah
muwari
nafar
naik
naik kelas
naik turun, menaikturunkan
naka
nakal-nakalan
nanap
nangkring
nanti
nanti-nantian
nasib-nasiban
naung, bernaung
nebeng
nenen
nenes
nerak sarak
ngebut
ngeceng
ngeden
ngenas
ngoyo
nimbrung
nobat
nomplok
nongol
nukil
nunut
nuzul
nyana
nyanyah, menyanyah
nyanyi
nyapnyap
nyentrik
nyerocos
nyolnyolan
nyungsung
nyunyut
nyureng
nyut-nyutan
obral
olah
olang-aling
ondok
opak
oplos, mengoplos
orak
pacaran
pacuk, memacuk
pacul
paes
pagut
pajan
pajang
pakai
paksa
palar
palis
palu-memalu
pamer
pamit
pampang
pana, terpana
pancal
pancar
pancar terus
pancit
panco
pancung
pandang-memandang
pandu
panggang
panggil
pangkas
pangku
pangkung
pangpet
panguk, memanguk
panjat
pantak
pantau
pantik
pantul
papah
papak
papas
papras
parih
parkir
parun
pasang
pasang-memasang
pasrah
patik
patungan
pauk
paut-memaut
payang
pecah
pecah belah
pecal
pecat
peduli
pegang
pegaraman
pegat
pei
pejam
pekik-pekuk
pelan-pelan
pelancar
pelas
peleh
pelesiran
pelesit
pelihara
pelintir
pelorot, memeloroti
peluk
pencar
pencet
pendam
peneman
penembakan
penerima
pengambrukan
pengasongan
pengeboman
pengesetan
pengetik
penggal
pengguntingan
pengin
pengkis
pengotaan
penodongan
pentang
pentil
pentung-pentungan
penumbuhan
pepak
peper
pepet
perai
peram
peras
peras-perus
perbal
perburuk
percaya
percul
perdua
perengut
perenyak
peretel
pergi
periksa
perinci
peringis, memeringis
perkosa, memerkosa
perleng
perling
perlup
permak
perogol
perpisahan
persegi
persekusi
perselingkuhan
persenan
pertal
pertempuran
perusa
perusuh
pesiar
petik
petilasan
piara
pica
picit
pijat
pijit
pikat
pikau
piknik
pilah
pilih
pilih-pilih
pilin-memilin
pimpin
pinang
pincuk
pinda
pindah
pindah tangan
pindah tugas, memindahtugaskan
pingit
pingsan
pinjam
pinjam-meminjam
pintal
pintang
pintas
pipil
pipis
pipis, memipis
pirau
pirau, berpirau
pirik
pis
pisit
pitar, memitar
piting
piting-memiting
pocok, memocok
pohon
pokrol-pokrolan
polang, polang-paling
poldan
polok
pompong
pondong
poser
potel
potong-memotong
prakira
prangas
pretel
procot
puasa
puatang
pugak
pugar
pugas
pujut
pukah
pukul-memukul
pulang
pulas
pulih
pulung
punggah
punggung-memunggung
pungut v, memungut
puntal
puntir
punya
pupur
puput
purik
pusing
pusing-pusing
putar
putar balik
putar lidah
putar-putar
puter
putus
raba
raba-rabaan
rabak
rabet
rabut
racik
racuh
rada
radak
ragang
ragut, meragut
rahasia-rahasiaan
rahat
raib
raih
rajah
rajang
rambah
rambeh
rambeh-rambeh
rames
rampas
rampat
rampung
ramu
rancang
randa-rondo
randak, merandak
randau, merandau
randuk
randung
rangai
ranggung
rangkaian
rangkak
rangkang, merangkang
rangkap, merangkap
rangket
rangkul
rangkul-merangkul
rangkung
rangkup
rangkus
rangkut
rangsangan
rantam
rantuk
ranyah
ranyau
ranyun
rapah
rapai
rapal
rapung
rapus
rarak
rasan
rasuk
ratap
raun
raun-raun
raup
raut
rawat
rayah
rayap
rayau
rebah
rebah-rebah
rebah-rebahan
rebak
rebas
rebat
rebus
rebut
recet
recik
reda
redusir
regah
regas
regup
rejah
rejan
rejang
rejeng
rejuk
rekah
rekanan
rekat
reken
rekurs
rela
relai
relaksasi
relas
remas
rembah-rembih
rembes
rembut
remet
rempah
rempuh
remuk
renang
rencah
rendam
rengeh
rengeng
renggut
rengkudah
rengkuh
rentak
renyeh
repormir
resan
resonan
retur
riap
rias
riba
ricau
ricik
rihat
rileks
rilis
rinai
ringis
ringkik
ringking
ringkuk
ringkus
ringsing
rintang
rintas
rintih
risak
ritul
robekan
robok
rodok
rodong
rogoh
rogok
rogol
rojeng
rombak
romok, meromok
rompak
ronda
rondok
roneo
rongkok
rongrong
ronta, meronta
rontok
ronyeh
rorod
rosok
rosot
rotok
rowot
royak
ruah
ruak
ruat
rubu, merubu
rubung
rudu
rujah
rujuk
rumbu
rumuk
runduk
rundung
runggas
runggu-rangga
runggut
runjang
runti
runtuh
runtun
rurut
rutuk
ruwat
ruyak
sabak
sabat
sabet
sabot
sabung
sabung-menyabung
sadai
sadap
sadau
sadran
sagang
sahur
sahut-menyahut
saing, bersaing
saing-menyaing
sakap
sakat
sakit-sakitan
salah guna, menyalahgunakan
salin
salip
sama rata
samapta
sambang
sambar
sambar-menyambar
sambat
sambit
sambung
sambung-bersambung
sambung-menyambung
sambut
sambut-menyambut
sampai
sampang
samper
samping-menyamping
sampir
samplok
sampuk
samun
sandar
sandar-menyandar
sandung
sanggah
sanggam
sanggama
sanggang
sanggat
sanggit
sanggrah
sanggup
sangka
sangkak
sangkal
sangkil
sangkut-menyangkut
sangrai
sanjung
santak
santap
santase
sapa-menyapa
sapih
sapu, menyapu
sarap, menyarap
saring
sarju
saruk
sarut
sasak
sasap
sasar
satai, menyatai
sauk-menyauk
sauna
sawer
sebambang
sebar
sebar luas
sebat
sebaur, menyebaurkan
seberang-menyeberang
sebit
sebut
sedang-menyedang
sedapat
sedia
sedot
seduh
segan-menyegan
segan-menyegani
seia
sejingkat
seka
sekap
sekedudukan
sekrap
sela-menyela
selam
selang tenggang
selang-seli
selang-seling
selangkup
selap
selebar
selenggara
selesai
selia
selip
selir-menyelir
selonjor
selonjoran
seloyongan
seluk-semeluk
seman
semangkuk
semati
semau
sembelih
sembuh
sembunyi
sembunyi-sembunyian
sembur-sembur
semenda-menyemenda
sempal
sempat
sengaja
sengam
sengap
sengar-sengir
sengau-sengauan
senggak-sengguk
senggang-tenggang
senggau
senggol
senggol-menyenggol
sengkak
sengkeling
sental
sentil, tersentil
sentuh
sepai
sepel
sepencapai
sepuk
sepulang
serah
serak
serampang
serampuk
serana
serang
serang-menyerang
serang-serangan
seranggung
serangsang
serap
seraya-menyeraya
serbu
serempak
serempet
seret
sergap
seri
serkai
serlah
serobok
serobot
serondol
serondong
serong-menyerong
seropot
serot
serta
serta-menyertai
serta-serta
sertu
seruduk
serunda
serundang
seruput
seruyuk
sesah
sesaing
sesak-menyesak
sesal-menyesali
sesambat
sesampai
sesap
sesar
set
setel
setempuh
setiar
setiba
setop
setor
setoter
sewat
siaga
siah
siam
siap
siap sedia
siap siaga
siar
siat
sibak
sidai
sidik
sigi
sigung
sikut-sikutan
sila
silakanlah
silalah
silang
silang-menyilang
silih
silik
silir-semilir
silvikultur
simak
simbur
simpak
simpan
simpang siur
simpir
sinambung
sinar-menyinar
sinar-seminar
sinar-suminar
sindir-menyindir
singgah
singgah-menyinggah
singgir
singgit
singgul
singgung
singkap
singkir
sinian
sintuk
sir-siran
siram
sirap
sisih
sisip
sisir
sitir
siuh
siur
sodet
sodok
sodok-sodokan
sombol
songel
sontek
sorong
sortir
sosoh
sosor, menyosor
sparing
stilir
suak
sublim
sudet, menyudet
sudi
sugar
sujud
sulam
sulang
sulang-menyulang
suling
sulut
sumbang
sumbi
sundul
sundut-bersundut
sunggit
sungkap
sungkem
sungkit
sungkuk
sungkur
suntik
sunting
sunting-menyunting
surai
surat-menyurat
suruk
suruk-surukan
surup
susuk
susul
susul-menyusul
susup
suten
tabok
tabrak
tabrak-tubruk
tabun
tabun-menabun
tabur
tabzir
tadung
tafakuran
tagak
tagan
tagih
tahajud
tahan
tahar
tahbis
tahu
tahu-menahu
tahun
taja
takak
takarub
takjil
taklik
takluk
taksiran
takung
talar
tali-bertali
talu, bertalu-talu
talun-temalun
tamat
tambal
tambang, bertambangan
tambat
tambuh
tambul
tampak
tampak-tampak
tampar
tampel
tampi
tampik
tampil
tampung
tanai
tanak
tanak-tanakan
tanam
tanam-tanaman
tanang
tancang
tancap
tandur
tangas
tanggal
tangguh, bertangguh
tanggung
tanggung-menanggung
tangkal
tangkap
tangkar
tangkis
tangkup telentang
tantang
tanwujud
tapa
tapuk
tapung
tapus
tarang
tarik
tarik-menarik
taris
tarjih, bertajih
tartil
taruk
tarung
tasrih
tasyakuran
tatah
tatai
tatal
tatang
tatap
tatar
tatih
tating
taut
tawadu
tawaf
tawakal
tawan
tawar
tawar-menawar
tawaruk
tayang
tebah
tebak
tebang
tebar
tebas
tebeng
tebersit
tebok
tebus
tecerna
tegar
tegerbang-gerbang
teguk
tegun
tekad
tekan
tekek
tekel
teken
tekerjakan
tekersik
tekik
tekuk
tekur
telah
telan
telangkai
telanjang
telanjur
telantar
telap
tele
telekan
teleku
telentung
telikung
telingkah
telungkup
telusur
telut
temabur
temangga
temas
tembak
tembak-menembak
tembakan
tembok
tembung
tembus
tempa
tempel
temperas
temperau
tempiar
tempoh
tempong
tempuh
tempur
temu
temut-temut
tendang
tengadah
tenggak
tenggang-menenggang
tenggehem
tenggelam
tengger
tengkurap
tengok
tengok-menengok
tenteng
tepam
tepercik
tepercit
teperdaya
tepergok
tepik
tepis
teraba
teraba-raba
terabai
terabaikan
terabar
teradat
teradili
teradu domba
teraduh
teraduk
teragak
teraih
terajam
terajun
terajut
terakuk
terakumulasi
teralahkan
teralang
teralang-alang
teralienasi
teralih
teralun
terambah
terambang
terambang-ambang
terambau
terambil
terambung-ambung
terampai
terampuni
teramputasi
teran
terancam
terandal
terandalkan
terandam
teranduh
terang jelas, menerangjelaskan
terangguk-angguk
teranggul-anggul
terangin
terangin-angin
terangkat
terangkup
terangkup-angkup
terangsang
teraniaya
teranjur
terantai
terantar
terantuk
terap
terapung
terapung-apung
terarah
terasa
terasak
terasakan
terasing
teraspal
teratasi
teratung-atung
teratur
terawai
terawasi
terawat
terayan-rayan
terayap-rayap
terayomi
terbabar
terbabas
terbabit
terbaca
terbagi
terbakar
terbalik
terbambang
terban
terbang
terbangkit
terbantahkan
terbantun
terbantut
terbaring
terbasmi
terbatuk-batuk
terbau
terbaur
terbawa
terbayang
terbayang-bayang
terbebar
terbebas
terbedol
terbeka
terbelahak
terbelalak
terbelangah
terbelenggu
terbeli
terbeliak
terbelintang
terbelit
terbenam
terbendung
terbengong-bengong
terbentang
terbentuk
terbentur
terberanikan
terberkas
terbeting
terbiasa
terbikin
terbilang
terbirit
terbirit-birit
terbit
terbius
terbongkar
terbuai
terbuai-buai
terbuang
terbuang-buang
terbuat
terbujur
terbuka
terbukti
terbulang
terbuncang
terbungkuk-bungkuk
terbuni
terbuntang
terburai
terburu
terburu-buru
terbusung
tercabik
tercabut
tercacak
tercacat
tercagak
tercakup
tercalar
tercampak
tercampung
tercampur
tercanang
tercancang
tercangah
tercangak-cangak
tercangkel
tercantum
tercapai
tercapak
tercaplok
tercari
tercatat
tercebur
tercecah
tercedera
tercegah
tercekam
tercekih
tercekik
tercela
tercelampak
tercelapak
tercelentang
tercelomok
tercelus
tercema
tercemar
tercemplung
tercengang
tercengang-cengang
tercengut
tercerai
tercerap
tercermin
tercetus
terciduk
tercilap-cilap
tercinta
terciprat
tercipta
tercirit
tercium
tercoang
tercocok
tercogok
tercolok
terconggok
terconteng
tercoreng
tercoreng-moreng
tercuar
tercuci
tercundang
tercungap
tercupai
tercurah
terdaftar
terdaging
terdaki
terdamaikan
terdampar
terdanguk
terdapat
terdedah
terdempok
terdengar
terdengih-dengih
terdenguk
terderita
terdesak
terdeteksi
terdiam
terdinding
terdiri
terdistribusi
terdongkrak
terdorong
terduduk
terduga
terduga-duga
terebut
terefleksikan
terekspos
terelakkan
terembut-embut
terempang
terempap
terempas
terempas-empas
terencah
terendam
terendapkan
terengah-engah
terentak
terentang
terentas
terentaskan
terepas
teresak
teresak-esak
teresap
terfokus
tergabung
tergadai
tergagap-gagap
tergagau
tergagau-gagau
tergalang
tergamak
tergamang
tergambar
tergampar
terganggu
terganjak
terganjal
tergantung
tergapai
tergapai-gapai
tergarap
tergaruk
tergedor
tergegar
tergegas
tergegas-gegas
tergelak
tergelak-gelak
tergelangsar
tergelecik
tergeleng-geleng
tergeletak
tergeliat
tergelimpang
tergelincir
tergelingsir
tergelitik
tergelung-gelung
tergembleng
tergembok
tergeming
tergenang
tergencet
tergenggam
tergerai
tergerai-gerai
tergerak
tergerenyeng-gerenyeng
tergerung
tergerus
tergetah
tergial
tergigit
tergilas
tergiling
tergiur
tergoda
tergolek
tergolek-golek
tergolok
tergolong
tergontai-gontai
tergores
tergoyahkan
tergoyang
tergugah
tergugat
terguguk
terguling
terguling-guling
tergulir
tergulung
terguncang
tergurat
tergusur
terguyur
terhabiskan
terhad
terhal
terhalang
terhambat
terhambat-hambat
terhambur
terhampar
terhantar
terhanyut
terhapus
terharap-harap
terharu
terharu biru
terhasrat
terhasut
terhembalang
terhempap
terhempas
terhenti
terhentikan
terhias
terhibur
terhidang
terhimpun
terhina
terhindar
terhingga
terhinggut-hinggut
terhisab
terhitung
terhukum
terhuni
terhunjam
terhunus
terigau
terigau-igau
terijuk
terikat
terikut
terima
terimbas
terimbau
terimpi-impi
terimpit
terimplikasi
terincit
terincut-incut
terindang
teringat
teringat-ingat
terinjak
terinjak-injak
terinspirasi
terintang
terintervensi
terintrusi
terion
terisak-isak
terisi
teritik
terizinkan
terjabarkan
terjadi
terjadwal
terjaga
terjajah
terjajar
terjala
terjali
terjalin
terjamah
terjamin
terjang
terjangkau
terjangkiti
terjantur
terjarak
terjaring
terjatuh
terjebak
terjeblok
terjeblos
terjegil
terjela
terjelapak
terjelaskan
terjelengar
terjelepok
terjelma
terjemah
terjembak-jembak
terjembatani
terjemur
terjepret
terjerahap
terjerang
terjerangkang
terjerat
terjerembap
terjerempak
terjerit-jerit
terjerojol
terjerongkang
terjerongkong
terjerumus
terjinjing
terjotos
terjual
terjulai
terjulur
terjumlah
terjumpa
terjun
terjunam
terjungkal
terjungkir
terjungkit
terjuntai
terjurai
terka
terkaan
terkabar
terkabul
terkacau
terkagum-kagum
terkail
terkait
terkaji
terkakak-kakak
terkalahkan
terkalang
terkam
terkampai
terkancah
terkancing
terkandas
terkandung
terkangkang
terkanjar-kanjar
terkantuk
terkantuk-kantuk
terkap
terkapar
terkatakan
terkategori
terkatup
terkayuhkan
terkebat
terkebiri
terkecap-kecap
terkecewa
terkecoh
terkecuali
terkecundang
terkedai
terkedek-kedek
terkedik
terkedip
terkedip-kedip
terkejam
terkejar
terkejar-kejar
terkejut
terkekang
terkekau-kekau
terkelap
terkelepai
terkelepet
terkelik
terkelip-kelip
terkelola
terkelopak
terkeloyak
terkelu
terkeluk
terkelupas
terkempa
terkempul-kempul
terkemut-kemut
terkena
terkenal
terkenang
terkencing
terkencing-kencing
terkendali
terkentut
terkentut-kentut
terkepak-kepak
terkepal
terkepil
terkepoh
terkepung
terkerak
terkerangka
terkerat
terkereseng
terkerunyut
terkerut
terkesan
terketuk
terkhusus
terkial-kial
terkibuli
terkicu
terkikik-kikik
terkikis
terkilas
terkilat
terkimah
terkinja-kinja
terkira
terkirai-kirai
terkirakan
terkirim
terkirimkan
terkisah
terkitar-kitar
terkobar
terkobarkan
terkocak
terkokot
terkongkong
terkontaminasi
terkontrol
terkooptasi
terkoordinasi
terkotak
terkotak-kotak
terkuak
terkuasai
terkubak
terkubu
terkubur
terkucai
terkucak
terkucil
terkudian
terkujut
terkulai
terkumpul
terkunci
terkungkung
terkuntum
terkunyah
terkupas
terkuras
terkurung
terkutuk
terlacak
terlahir
terlaksana
terlalah
terlalai
terlalaikan
terlambak
terlambat
terlampai
terlampaui
terlampir
terlanda
terlangah
terlanggar
terlangkahkan
terlangkaui
terlangsung
terlanjur
terlantan
terlantas
terlanting
terlantung-lantung
terlarang
terlarut
terlawan
terlayah
terlayang
terlayang-layang
terlayap
terlecah
terledakkan
terlekat
terlelap
terlempai
terlena
terlengah
terlengar
terlengket
terlengkung
terlentang
terlentuk
terlepas
terleraikan
terletak
terlewat
terlewati
terlibat
terlihat
terlincah-lincah
terlincir
terlindung
terlingkar
terlingkung
terlingkup
terlintang
terlintas
terliput
terliuk
terliuk-liuk
terlokalisasi
terlolong
terlolong-lolong
terlompat
terlonggok
terlonjak
terlucut
terluka
terlukis
terlukiskan
terluncur
terlunjur
terlupa
terluput
termakan
termaksud
termandam
termangu-mangu
termanifestasi
termanja-manja
termasuk
termenung
termenung-menung
termesra
termeterai
termilik
termimpi-mimpi
terminum
termodifikasi
termotivasi
termuat
ternama
ternanar
ternanti-nanti
ternganga
terngiang
terngiang-ngiang
terniat
ternilai
terninabobo
ternoda
ternukil
ternyana
ternyata
ternyatakan
terobat
terobati
terobos
terobsesi
teroka
teroksidasi
teroleng-oleng
terombang-ambing
terorak
terorganisasi
terpa
terpacak
terpacul
terpada
terpadu
terpahami
terpajan
terpakai
terpaksa
terpaku
terpalis
terpalit
terpalit-palit
terpalut
terpampang
terpampat
terpanasi
terpancang
terpancar
terpancing
terpandang
terpandang-pandang
terpanggil
terpantau
terpantek
terpanting
terparkir
terpasak
terpasang
terpatri
terpaut
terpecah
terpecah-pecah
terpejam
terpekak
terpekik
terpekik-pekik
terpelajar
terpelesat
terpeleset
terpelihara
terpelintir
terpeluk
terpencil
terpendam
terpengaruh
terpenggal
terpenjara
terpentang
terpenting
terpenuhi
terpeper
terpepet
terperangah
terperangkap
terperenyak
terperikan
terperinci
terperintah
terperohong
terperuk
terpesona
terpesong
terpeta
terpetik
terpicing
terpico
terpidana
terpijak-pijak
terpijit
terpikat
terpikau-pikau
terpikir
terpikirkan
terpilah
terpilah-pilah
terpilih
terpimpin
terpinggirkan
terpinta
terpintal
terpisah
terpisahkan
terpiuh
terpojok
terpojokkan
terpontang-panting
terpotong
terprogram
terprovokasi
terpublikasi
terpujuk
terpukau
terpukul
terpulang
terpulut
terpumpun
terpupuk
terpupus
terpuruk
terpusing-pusing
terputar
terputarbalikkan
terputus
terputuskan
tersabet
tersabung
tersabur
tersadai
tersadap
tersadar
tersagang
tersaingi
tersaji
tersakat
tersaku
tersalah
tersalai
tersalur
tersalurkan
tersalut
tersamai
tersambar
tersambil
tersambit
tersampai
tersampaikan
tersampang
tersamping
tersampir
tersampuk
tersandar
tersandung
tersangai
tersangat
tersangka
tersangkut
tersangsang
tersanjung
tersapa
tersapu
tersaput
tersara bara
tersaripatikan
tersaruk
tersaruk-saruk
tersarung
tersasar
tersaur
tersayang (akan)
tersayat
tersebab
tersebar
tersebar luas
terseberang
tersebut
tersedan-sedan
tersedia
tersedih-sedih
tersedot
tersedu-sedu
tersekang
tersekap
tersekat
terselak
terselam
terselami
terselap
terselat
terselenggara
terselesaikan
terselip
terselip (ke luar)
terselit
terselubung
terselusur
tersemai
tersemat
tersembam
tersembul
tersembunyi
tersembur
tersempal
tersempil
tersemu
tersenak
tersendal
tersendat
tersendat-sendat
tersendeng-sendeng
tersendiri
tersendok
tersendorong
tersengal-sengal
tersengat
tersenggol
tersengguk
tersengguk-sengguk
tersengih
tersengkang
tersentak
tersentralisasi
tersentuh
tersenyawa
tersenyum
tersepah
tersepai
tersepit
tersepuh
tersepuk
terserah
terserak
terserak-serak
terserampang
terserampuk
terserang
terserap
terserempak
terserempet
terseret
terserimpung
terseringing
terserobok
terserok
terserondong
terserot
terseruduk
terserunda
tersesak
tersesap
tersesat
tersesuaikan
tersetai-setai
tersetrum
tersiah
tersiar
tersifatkan
tersihir
tersiksa
tersila
tersilang
tersilau
tersimbah
tersimbur
tersimpai
tersimpan
tersimpul
tersindir
tersinggung
tersingit
tersingkap
tersingkir
tersingsing
tersipi
tersirap
tersirat
tersirep
tersisa
tersisih
tersisihkan
tersisip
tersobok
tersohor
tersoja-soja
tersomplok
tersorong
terstruktur
tersua
tersuar
tersubstitusikan
tersudu
tersudut
tersuguh
tersujud
tersuling
tersumbat
tersumpal
tersumpit
tersundak
tersundul
tersungging
tersungkuk-sungkuk
tersungkum
tersungkup
tersungkur
tersunting
tersuntuk
tersurat
tersuruk
tersuruk-suruk
tersurut
tersuspensi
tersusul
tersusun
tertabrak
tertabur
tertagak-tagak
tertahan
tertahan-tahan
tertakung
tertambat
tertambus
tertampak
tertamsilkan
tertanam
tertancap
tertanda
tertandatangani
tertangani
tertanggal
tertangguh
tertangguhkan
tertangguk
tertanggung
tertangkal
tertangkap
tertangkis
tertangkup
tertanjul
tertantang
tertara
tertarik
tertarung
tertatih-tatih
tertawa
tertawan
tertayang
tertebar
tertegak
terteguk
tertegun
tertegun-tegun
tertekan
tertekan-tekan
tertekun
tertelan
tertelentang
tertelungkup
tertembak
tertembus
tertempuh
tertemukan
tertendang
tertendang-tendang
tertenggan
tertenggang
tertenggek
tertentang
tertera
tertiarap
tertidur
tertikam
tertilang
tertimba
tertimbakan
tertimbun
tertimbus
tertimpa
tertindas
tertindih
tertinggal
tertitar-titar
tertiup
tertolak
tertolong
tertonjol
tertransmisikan
tertubruk
tertuduh
tertudung
tertuju
tertukar
tertulang
tertulari
tertulis
tertumbuk
tertumpah
tertumpang
tertumpat
tertumpu
tertumpuk
tertunda
tertunggang
tertunggik
tertungkup
tertunjang
tertuntung
tertunu
tertusuk
tertutup
tertutur
teruapkan
terubah
terubus
teruit
teruji
terukir
terulang
terulur
terumbang-ambing
terumbang-umbang
terungkap
terungkap-ungkap
terunjur
teruntai
teruntuk
terupa
terupam
terupaya
terurai
terurus
terus
terus terang
terusik
terusir
terwadahi
terwakili
terwalak
terwaralaba
terwujud
teserbu
tesergap
teserlah
teserling
tetak
tetap
tetar
tetas
tetesan
tetirah
tewas
tiada
tiarap
tiba
tidur
tidur-tidur
tidur-tiduran
tiduran
tikam
tikam-menikam
tikas
tikung
tilap
tilik-menilik
tim
timang
timbang-menimbang
timbau
timbul
timbus
timpa
timpa-menimpa
timpuh
tindak lanjut
tindan
tindas
tindih-bertindih
tindih-menindih
tindik
tinggal
tinggung
tingkuh
tinjau
tinjau-meninjau
tinju-meninju
tinting
tip
tirah
tirakat
tirakatan
tiru
tiru-tiruan
tisik
titar
titi
titip
titis
tiup
tobat
todong
togan
tokak
tokok-menokok
tolak
tolak-menolak
toleh
tolong
tolong-menolong
tomang
tombok
tonggak
tonggok
tongkah
tongkor
tongkrong
tongol
tonjok
tonton
topang
toreh
towel
toyor
traktir
transfer
tuang
tuding
tuduh
tujah
tuju
tukang-menukang
tukar
tukar-menukar
tukas
tukik
tulis
tulis-menulis
tumbang
tumbuh
tumpah
tumpang
tumpang sari
tumpang-tindih
tumplak
tumungkul
tunda
tunduk
tundung
tunggang
tunggang-tunggik
tunggang-tunggit
tungging
tunggu
tunjang
tunjangan
tunjuk
tunjuk-menunjuk
tuntun
tuntung
tuntut
turba
turne
turun
turun-temurun
turut
turut-menurut
tusir, menusir
tusuk
ubah bentuk
ubrak-abrik
ulang kali, berulang kali
ulas
uleman
uluk salam
umbang-ambing
umbar
umbut
umpet
umpil
uncang-uncit
undang
undur
unggang-anggit
unggul-mengungguli
unggut, berunggut-unggut
ungkap
ungkil
ungkit
unjuk
untang-anting
upah-mengupah
upawasa
urup-urupan
usul
usut
utara, mengutarakan
vide
wafat
wajib
waleh
wara-wiri
warid
wawas diri
wira-wiri
wisata
wudu
