#!/usr/bin/perl -w -I ../../../lib

use 5.018;

use strict;

use Carp;

{ package Audio::Signal::Effect::Fade;

    use Moose;
    use Moose::Util::TypeConstraints;

    extends 'Audio::Signal::Effect';
    
    enum 'Form', [qw(quarter half triangular logarithmic parabola)];
    
    our %gencmd_form = ('quarter' => 'q','half' => 'h','triangular' => 't','logarithmic' => 'l','parabola' => 'p');
    
    has 'in' => (
        is => 'rw',
        isa => 'Num',
    );
    
    has 'out' => (
        is => 'rw',
        isa => 'Num',
    );
    
    has 'form' => (
        is => 'rw',
        isa => 'Form',
    );
    
    sub gencmd {
        my $self = shift;
        my $ret = sprintf("%s %s %s 0 %s",$self->fx,$Audio::Signal::Effect::Fade::gencmd_form{$self->form},$self->in,$self->out);
        return($ret);
    }
}

1;
