/*    Locale.h
 *
 *    $Id: Locale.h,v 1.1.1.1 2000/12/13 02:15:03 bstell Exp $
 *
 *    Copyright (c) 2000 Brian Stell
 *
 *    This package is free software and is provided ``as is'' without
 *    express or implied warranty. It may be used, redistributed and/or
 *    modified under the terms of the Perl Artistic License
 *    (see http://www.perl.com/perl/misc/Artistic.html)
 *
 */

extern char *Locale_class_string;
#define IS_LOCALE_OBJECT(x) \
        sv_derived_from((x), Locale_class_string)

//
// We need a separate class here because
// some Locale objects are created locally; eg: new Locale()
// and
// some Locale objects are global; eg: Locale::getDefault(), etc.
//
// This class remembers if we should delete the class on DESTROY()
//
class Picu_Locale {
    public:
        Picu_Locale(const Locale*, int);
        ~Picu_Locale();
        const Locale *getIcuLocale();
        int getIsLocallyAllocated();
    private:
    protected:
        const Locale *mIcuLocale;
        int           mIsLocallyAllocated;
};

