/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeReaderVariable;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.IsoTypeWriterVariable;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.googlecode.mp4parser.RequiresParseDetailAspect;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackFragmentRandomAccessBox
extends AbstractFullBox {
    public static final String TYPE = "tfra";
    private long trackId;
    private int reserved;
    private int lengthSizeOfTrafNum = 2;
    private int lengthSizeOfTrunNum = 2;
    private int lengthSizeOfSampleNum = 2;
    private List<Entry> entries = Collections.emptyList();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;

    public TrackFragmentRandomAccessBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        long contentSize = 4L;
        contentSize += 12L;
        contentSize = this.getVersion() == 1 ? (contentSize += (long)(16 * this.entries.size())) : (contentSize += (long)(8 * this.entries.size()));
        contentSize += (long)(this.lengthSizeOfTrafNum * this.entries.size());
        contentSize += (long)(this.lengthSizeOfTrunNum * this.entries.size());
        return contentSize += (long)(this.lengthSizeOfSampleNum * this.entries.size());
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.trackId = IsoTypeReader.readUInt32(content);
        long temp = IsoTypeReader.readUInt32(content);
        this.reserved = (int)(temp >> 6);
        this.lengthSizeOfTrafNum = ((int)(temp & 0x3FL) >> 4) + 1;
        this.lengthSizeOfTrunNum = ((int)(temp & 0xCL) >> 2) + 1;
        this.lengthSizeOfSampleNum = (int)(temp & 3L) + 1;
        long numberOfEntries = IsoTypeReader.readUInt32(content);
        this.entries = new ArrayList<Entry>();
        int i = 0;
        while ((long)i < numberOfEntries) {
            Entry entry = new Entry();
            if (this.getVersion() == 1) {
                entry.time = IsoTypeReader.readUInt64(content);
                entry.moofOffset = IsoTypeReader.readUInt64(content);
            } else {
                entry.time = IsoTypeReader.readUInt32(content);
                entry.moofOffset = IsoTypeReader.readUInt32(content);
            }
            entry.trafNumber = IsoTypeReaderVariable.read(content, this.lengthSizeOfTrafNum);
            entry.trunNumber = IsoTypeReaderVariable.read(content, this.lengthSizeOfTrunNum);
            entry.sampleNumber = IsoTypeReaderVariable.read(content, this.lengthSizeOfSampleNum);
            this.entries.add(entry);
            ++i;
        }
    }

    @Override
    protected void getContent(ByteBuffer bb) throws IOException {
        this.writeVersionAndFlags(bb);
        IsoTypeWriter.writeUInt32(bb, this.trackId);
        long temp = this.reserved << 6;
        temp |= (long)((this.lengthSizeOfTrafNum - 1 & 3) << 4);
        temp |= (long)((this.lengthSizeOfTrunNum - 1 & 3) << 2);
        IsoTypeWriter.writeUInt32(bb, temp |= (long)(this.lengthSizeOfSampleNum - 1 & 3));
        IsoTypeWriter.writeUInt32(bb, this.entries.size());
        for (Entry entry : this.entries) {
            if (this.getVersion() == 1) {
                IsoTypeWriter.writeUInt64(bb, entry.time);
                IsoTypeWriter.writeUInt64(bb, entry.moofOffset);
            } else {
                IsoTypeWriter.writeUInt32(bb, entry.time);
                IsoTypeWriter.writeUInt32(bb, entry.moofOffset);
            }
            IsoTypeWriterVariable.write(entry.trafNumber, bb, this.lengthSizeOfTrafNum);
            IsoTypeWriterVariable.write(entry.trunNumber, bb, this.lengthSizeOfTrunNum);
            IsoTypeWriterVariable.write(entry.sampleNumber, bb, this.lengthSizeOfSampleNum);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTrackId(long l) {
        void trackId;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, (Object)this, (Object)this, Conversions.longObject(l2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.trackId = trackId;
    }

    /*
     * WARNING - void declaration
     */
    public void setLengthSizeOfTrafNum(int n) {
        void lengthSizeOfTrafNum;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, Conversions.intObject(n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.lengthSizeOfTrafNum = lengthSizeOfTrafNum;
    }

    /*
     * WARNING - void declaration
     */
    public void setLengthSizeOfTrunNum(int n) {
        void lengthSizeOfTrunNum;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, (Object)this, (Object)this, Conversions.intObject(n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.lengthSizeOfTrunNum = lengthSizeOfTrunNum;
    }

    /*
     * WARNING - void declaration
     */
    public void setLengthSizeOfSampleNum(int n) {
        void lengthSizeOfSampleNum;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, Conversions.intObject(n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.lengthSizeOfSampleNum = lengthSizeOfSampleNum;
    }

    public long getTrackId() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.trackId;
    }

    public int getReserved() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.reserved;
    }

    public int getLengthSizeOfTrafNum() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_6, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.lengthSizeOfTrafNum;
    }

    public int getLengthSizeOfTrunNum() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_7, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.lengthSizeOfTrunNum;
    }

    public int getLengthSizeOfSampleNum() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_8, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.lengthSizeOfSampleNum;
    }

    public long getNumberOfEntries() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_9, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries.size();
    }

    public List<Entry> getEntries() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_10, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return Collections.unmodifiableList(this.entries);
    }

    /*
     * WARNING - void declaration
     */
    public void setEntries(List<Entry> list) {
        void entries;
        List<Entry> list2 = list;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_11, (Object)this, (Object)this, list2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.entries = entries;
    }

    static {
        TrackFragmentRandomAccessBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TrackFragmentRandomAccessBox.java", TrackFragmentRandomAccessBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setTrackId", "com.coremedia.iso.boxes.fragment.TrackFragmentRandomAccessBox", "long", "trackId", "", "void"), 144);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLengthSizeOfTrafNum", "com.coremedia.iso.boxes.fragment.TrackFragmentRandomAccessBox", "int", "lengthSizeOfTrafNum", "", "void"), 148);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEntries", "com.coremedia.iso.boxes.fragment.TrackFragmentRandomAccessBox", "", "", "", "java.util.List"), 184);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEntries", "com.coremedia.iso.boxes.fragment.TrackFragmentRandomAccessBox", "java.util.List", "entries", "", "void"), 188);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLengthSizeOfTrunNum", "com.coremedia.iso.boxes.fragment.TrackFragmentRandomAccessBox", "int", "lengthSizeOfTrunNum", "", "void"), 152);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setLengthSizeOfSampleNum", "com.coremedia.iso.boxes.fragment.TrackFragmentRandomAccessBox", "int", "lengthSizeOfSampleNum", "", "void"), 156);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTrackId", "com.coremedia.iso.boxes.fragment.TrackFragmentRandomAccessBox", "", "", "", "long"), 160);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getReserved", "com.coremedia.iso.boxes.fragment.TrackFragmentRandomAccessBox", "", "", "", "int"), 164);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLengthSizeOfTrafNum", "com.coremedia.iso.boxes.fragment.TrackFragmentRandomAccessBox", "", "", "", "int"), 168);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLengthSizeOfTrunNum", "com.coremedia.iso.boxes.fragment.TrackFragmentRandomAccessBox", "", "", "", "int"), 172);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLengthSizeOfSampleNum", "com.coremedia.iso.boxes.fragment.TrackFragmentRandomAccessBox", "", "", "", "int"), 176);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNumberOfEntries", "com.coremedia.iso.boxes.fragment.TrackFragmentRandomAccessBox", "", "", "", "long"), 180);
    }

    public static class Entry {
        private long time;
        private long moofOffset;
        private long trafNumber;
        private long trunNumber;
        private long sampleNumber;

        public Entry() {
        }

        public Entry(long time, long moofOffset, long trafNumber, long trunNumber, long sampleNumber) {
            this.moofOffset = moofOffset;
            this.sampleNumber = sampleNumber;
            this.time = time;
            this.trafNumber = trafNumber;
            this.trunNumber = trunNumber;
        }

        public long getTime() {
            return this.time;
        }

        public long getMoofOffset() {
            return this.moofOffset;
        }

        public long getTrafNumber() {
            return this.trafNumber;
        }

        public long getTrunNumber() {
            return this.trunNumber;
        }

        public long getSampleNumber() {
            return this.sampleNumber;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void setMoofOffset(long moofOffset) {
            this.moofOffset = moofOffset;
        }

        public void setTrafNumber(long trafNumber) {
            this.trafNumber = trafNumber;
        }

        public void setTrunNumber(long trunNumber) {
            this.trunNumber = trunNumber;
        }

        public void setSampleNumber(long sampleNumber) {
            this.sampleNumber = sampleNumber;
        }

        public String toString() {
            return "Entry{time=" + this.time + ", moofOffset=" + this.moofOffset + ", trafNumber=" + this.trafNumber + ", trunNumber=" + this.trunNumber + ", sampleNumber=" + this.sampleNumber + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.moofOffset != entry.moofOffset) {
                return false;
            }
            if (this.sampleNumber != entry.sampleNumber) {
                return false;
            }
            if (this.time != entry.time) {
                return false;
            }
            if (this.trafNumber != entry.trafNumber) {
                return false;
            }
            return this.trunNumber == entry.trunNumber;
        }

        public int hashCode() {
            int result = (int)(this.time ^ this.time >>> 32);
            result = 31 * result + (int)(this.moofOffset ^ this.moofOffset >>> 32);
            result = 31 * result + (int)(this.trafNumber ^ this.trafNumber >>> 32);
            result = 31 * result + (int)(this.trunNumber ^ this.trunNumber >>> 32);
            result = 31 * result + (int)(this.sampleNumber ^ this.sampleNumber >>> 32);
            return result;
        }
    }
}

