#!/usr/bin/perl

package eBay::API::XML::DataType::BuyingGuideDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BuyingGuideDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::BuyingGuideDetailsType

=head1 DESCRIPTION

Information about zero or more buying guides and the site's buying guide hub.
Buying guides contain content about particular product areas, categories, or subjects
to help buyers decide which type of item to purchase based on their particular interests.
Multiple buying guides can be returned. See the eBay Web Services Guide for additional information.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::BuyingGuideDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::BuyingGuideType;


my @gaProperties = ( [ 'BuyingGuide', 'ns:BuyingGuideType', '1'
	     ,'eBay::API::XML::DataType::BuyingGuideType', '1' ]
	, [ 'BuyingGuideHub', 'xs:anyURI', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBuyingGuide()

Information that identifies a buying guide. A buying guide contains content about particular
product areas, categories, or subjects to help buyers decide which type of item
to purchase based on their particular interests.
Buying guides are useful to buyers who do not have a specific product in mind.
For example, a digital camera buying guide could help a buyer determine what kind of
digital camera is right for them.

#    Argument: reference to an array  
                      of 'ns:BuyingGuideType'

=cut

sub setBuyingGuide {
  my $self = shift;
  $self->{'BuyingGuide'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getBuyingGuide()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetCategoryListings
  Returned: Conditionally

  Calls: GetProducts
  Returned: Conditionally
  MaxOccurs: 5

#    Returns: reference to an array  
                      of 'ns:BuyingGuideType'

=cut

sub getBuyingGuide {
  my $self = shift;
  return $self->_getDataTypeArray('BuyingGuide');
}


=head2 setBuyingGuideHub()

URL of the buying guide home page for the site being searched.
Your application can present this URL as a link. Optionally,
you can use a value like "See all buying guides" as the link's
display name. GetProducts returns this URL even when no guides
are available for the product.

#    Argument: 'xs:anyURI'

=cut

sub setBuyingGuideHub {
  my $self = shift;
  $self->{'BuyingGuideHub'} = shift
}

=head2 getBuyingGuideHub()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetCategoryListings
  Returned: Conditionally

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'xs:anyURI'

=cut

sub getBuyingGuideHub {
  my $self = shift;
  return $self->{'BuyingGuideHub'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
