use strict;

use lib "lib";

use AI::NaiveBayes;
use AI::NaiveBayes::Classification;
use AI::NaiveBayes::Learner;

# AI::NaiveBayes objects are created by AI::NaiveBayes::Learner
# but for quick start you can use the 'train' class method
# that is a shortcut using default AI::NaiveBayes::Learner settings
 
my $classifier = AI::NaiveBayes->train( 
    {
        attributes => {
                sheep => 1, very => 1,  valuable => 1, farming => 1
        },
        labels => ['farming']
    },
    {
        attributes => {
            vampires => 1, cannot => 1, see => 1, their => 1,
            images => 1, mirrors => 1
        },
        labels => ['vampire']
    },
);
 
# Classify a feature vector
my $result = $classifier->classify({sheep => 3, blurp => 2});
 
# $result is now a AI::NaiveBayes::Classification object
 
my $best_category = $result->best_category;
print "The best category is: $best_category\n";

