# $Id: 20-write.t,v 1.2 2004/10/17 02:50:20 asc Exp $

use strict;
use Test::More;

plan tests => 7;

my $res = qq(<?xml version='1.0' encoding='UTF-8'?><rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#' xmlns:geo='http://www.w3.org/2003/01/geo/wgs84_pos#' xmlns:foaf='http://xmlns.com/foaf/0.1/' xmlns:vCard='http://www.w3.org/2001/vcard-rdf/3.0#'><rdf:Description rdf:about='t/Senzala.vcf'><vCard:CLASS>PUBLIC</vCard:CLASS><vCard:FN>Senzala</vCard:FN><vCard:PHOTO><rdf:Bag><rdf:li rdf:resource='http://www.senzala.com/photo/accueil.jpg' /><rdf:li rdf:parseType='Resource'><rdf:type rdf:resource='http://www.w3.org/2001/vcard-rdf/3.0#base64' /><vCard:ENCODING>b</vCard:ENCODING><rdf:value rdf:parseType='Literal'><![CDATA[LzlqLzRBQVFTa1pKUmdBQkFnRUFTQUJJQUFELzdSWXFVR2h2ZEc5emFHOXdJRE11TUFBNFFrbE5B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]]></rdf:value></rdf:li></rdf:Bag></vCard:PHOTO><vCard:ADR rdf:parseType='Resource'><rdf:type rdf:resource='http://www.w3.org/2001/vcard-rdf/3.0#pref' /><rdf:type rdf:resource='http://www.w3.org/2001/vcard-rdf/3.0#work' /><vCard:Street>177 Bernard o.</vCard:Street><vCard:Locality>Montreal</vCard:Locality><vCard:Region>Quebec</vCard:Region><vCard:Country>Canada</vCard:Country></vCard:ADR><vCard:TEL rdf:parseType='Resource'><rdf:type rdf:resource='http://www.w3.org/2001/vcard-rdf/3.0#pref' /><rdf:type rdf:resource='http://www.w3.org/2001/vcard-rdf/3.0#work' /><rdf:value>514/274-1464</rdf:value></vCard:TEL><vCard:GEO rdf:parseType='Resource'><geo:lat>45.5249</geo:lat><geo:lon>-73.6043</geo:lon></vCard:GEO><vCard:ORG rdf:parseType='Resource'><vCard:Orgnam>Senzala</vCard:Orgnam></vCard:ORG><vCard:CATEGORIES><rdf:Seq><rdf:li>montreal</rdf:li></rdf:Seq></vCard:CATEGORIES><vCard:NOTE rdf:parseType='Literal'><![CDATA[I had breakfast here with Maciej - the food is good, the coffee not so]]></vCard:NOTE></rdf:Description></rdf:RDF>);

SKIP: {
  eval { 
    require XML::SAX::Writer;
  };

  if ($@) {
    skip("XML::SAX::Writer not installed", 7);
  }

  use_ok("XML::Generator::vCard::RDF");
  use_ok("XML::SAX::Writer");
  
  #
  
  my $vcard = "t/Senzala.vcf";
  ok((-f $vcard),"found $vcard");
  
  #
  
  my $str_xml = "";
  my $writer  = XML::SAX::Writer->new(Output=>\$str_xml);
  isa_ok($writer,"XML::Filter::BufferText");
  
  #
  
  my $parser = XML::Generator::vCard::RDF->new(Handler=>$writer);
  isa_ok($parser,"XML::Generator::vCard::RDF");
  
  #
  
  ok($parser->parse_files($vcard),"parsed $vcard");

  cmp_ok($str_xml,"eq",$res,"output ok");
}
