## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(DFBA)

## -----------------------------------------------------------------------------
set.seed(1)
example_A1 <- dfba_sim_data(n = 80,
                           model = "normal",
                           design = "paired",
                           delta = 0.4,
                           shape2 = 2)

example_A1

## -----------------------------------------------------------------------------
example_A1$E

## -----------------------------------------------------------------------------
example_A1$C

## ----fig.height = 4, fig.width = 7--------------------------------------------
plot(example_A1)

## -----------------------------------------------------------------------------
set.seed(2)

example_A2 <- dfba_sim_data(n = 80,
                            model = "normal",
                            design = "paired",
                            delta = 0.4,
                            shape2 = 2)

example_A2$E

example_A2$C

## -----------------------------------------------------------------------------
set.seed(1)

example_B1 <- dfba_sim_data(n = 100,
                            model = "cauchy",
                            design = "paired",
                            delta = 0.5)

example_B1

## -----------------------------------------------------------------------------
example_B1$E

## -----------------------------------------------------------------------------
example_B1$C

## ----fig.height = 4, fig.width = 7--------------------------------------------
plot(example_B1)

## -----------------------------------------------------------------------------
set.seed(2)

example_B2 <- dfba_sim_data(n = 100,
                            model = "cauchy",
                            design = "paired",
                            delta = 0.5)

example_B2$E

example_B2$C

