/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;

public class CachedPointSet
extends PointSet {
    protected PointSet P;
    protected double[][] x;

    public CachedPointSet(PointSet pointSet, int n, int n2) {
        this.init(pointSet, n, n2);
    }

    private void init(PointSet pointSet, int n, int n2) {
        this.numPoints = n;
        this.dim = n2;
        if (pointSet.getNumPoints() < n) {
            throw new IllegalArgumentException("Cannot cache more points than in point set P.");
        }
        if (pointSet.getDimension() < n2) {
            throw new IllegalArgumentException("Cannot cache points with more coordinates than the dimension.");
        }
        this.P = pointSet;
        PointSetIterator pointSetIterator = pointSet.iterator();
        this.x = new double[this.numPoints][n2];
        for (int i = 0; i < this.numPoints; ++i) {
            pointSetIterator.nextPoint(this.x[i], n2);
        }
    }

    public CachedPointSet(PointSet pointSet) {
        this.numPoints = pointSet.getNumPoints();
        this.dim = pointSet.getDimension();
        if (this.numPoints == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot cache infinite number of points");
        }
        if (this.dim == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot cache infinite dimensional points");
        }
        this.init(pointSet, this.numPoints, this.dim);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Cached point set\n");
        stringBuffer.append(super.toString());
        stringBuffer.append("\nCached point set information {\n");
        stringBuffer.append(this.P.toString());
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    public double getCoordinate(int n, int n2) {
        return this.x[n][n2];
    }
}

