/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Statistical_Models.ModelQuad;

import java.io.FileNotFoundException;
import java.io.IOException;
import keel.Algorithms.Shared.ClassicalOptim.GCQuad;
import keel.Algorithms.Shared.Parsing.ProcessConfig;
import keel.Algorithms.Shared.Parsing.ProcessDataset;
import org.core.Randomize;

public class ModelPolQuadraticLMS {
    static Randomize rand;

    private static void quadraticModel(boolean tty, ProcessConfig pc) {
        try {
            String line = new String();
            ProcessDataset pd = new ProcessDataset();
            line = (String)ProcessConfig.parInputData.get(0);
            if (ProcessConfig.parNewFormat) {
                pd.processModelDataset(line, true);
            } else {
                pd.oldClassificationProcess(line);
            }
            int nData = pd.getNdata();
            int nVariables = pd.getNvariables();
            int nInputs = pd.getNinputs();
            int nOutputs = 1;
            double[][] X = pd.getX();
            double[] Y = pd.getY();
            double[] Yt = new double[Y.length];
            pd.showDatasetStatistics();
            double[][] Y1 = new double[Y.length][1];
            for (int i = 0; i < nData; ++i) {
                Y1[i][0] = Y[i];
            }
            double[] maxInput = pd.getImaximum();
            double[] minInput = pd.getIminimum();
            double maxOutput = pd.getOmaximum();
            double minOutput = pd.getOminimum();
            int dimWeights = (nInputs * nInputs + nInputs) * nOutputs + nInputs + nOutputs;
            double[] pesos = new double[dimWeights];
            GCQuad gcn = new GCQuad();
            double error = gcn.cuatrain(nInputs, 1, X, Y1, rand);
            for (int i = 0; i < Yt.length; ++i) {
                double[] output = gcn.cuaoutput(X[i]);
                Yt[i] = output[0];
            }
            pc.trainingResults(Y, Yt);
            ProcessDataset pdt = new ProcessDataset();
            line = (String)ProcessConfig.parInputData.get(2);
            if (ProcessConfig.parNewFormat) {
                pdt.processModelDataset(line, false);
            } else {
                pdt.oldClassificationProcess(line);
            }
            int nTest = pdt.getNdata();
            int npVariables = pdt.getNvariables();
            int npInputs = pdt.getNinputs();
            pdt.showDatasetStatistics();
            if (npInputs != nInputs) {
                throw new IOException("IOERR Test file");
            }
            double[][] Xp = pdt.getX();
            double[] Yp = pdt.getY();
            double[] Yo = new double[Yp.length];
            double RMS = 0.0;
            for (int i = 0; i < nTest; ++i) {
                double[] salida = gcn.cuaoutput(Xp[i]);
                RMS += (salida[0] - Yp[i]) * (salida[0] - Yp[i]);
                Yo[i] = salida[0];
            }
            System.out.println("ECM Test = " + (RMS /= (double)nTest));
            pc.results(Yp, Yo);
        }
        catch (FileNotFoundException e) {
            System.err.println(e + " File not found");
        }
        catch (IOException e) {
            System.err.println(e + " Read Error");
        }
    }

    public static void main(String[] args) {
        boolean tty = false;
        ProcessConfig pc = new ProcessConfig();
        System.out.println("Reading configuration file: " + args[0]);
        if (pc.fileProcess(args[0]) < 0) {
            return;
        }
        int algorithm = ProcessConfig.parAlgorithmType;
        rand = new Randomize();
        Randomize.setSeed(ProcessConfig.parSeed);
        ModelPolQuadraticLMS cp = new ModelPolQuadraticLMS();
        ModelPolQuadraticLMS.quadraticModel(tty, pc);
    }
}

