/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.BernoulliDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGenInt;
import umontreal.iro.lecuyer.rng.RandomStream;

public class BernoulliGen
extends RandomVariateGenInt {
    protected double p;

    public BernoulliGen(RandomStream s, double p) {
        super(s, new BernoulliDist(p));
        this.setParams(p);
    }

    public BernoulliGen(RandomStream s, BernoulliDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getP());
        }
    }

    public static int nextInt(RandomStream s, double p) {
        return BernoulliDist.inverseF(p, s.nextDouble());
    }

    public double getP() {
        return this.p;
    }

    protected void setParams(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in range [0, 1]");
        }
        this.p = p;
    }
}

