/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost;

import choco.cp.solver.constraints.global.Geost_Constraint;
import choco.cp.solver.constraints.global.geost.Constants;
import choco.cp.solver.constraints.global.geost.dataStructures.HeapAscending;
import choco.cp.solver.constraints.global.geost.dataStructures.HeapDescending;
import choco.cp.solver.constraints.global.geost.externalConstraints.ExternalConstraint;
import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.model.constraints.geost.GeostOptions;
import choco.kernel.model.variables.geost.ShiftedBox;
import choco.kernel.solver.propagation.PropagationEngine;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public final class Setup {
    private static final Logger LOGGER = ChocoLogging.getEngineLogger();
    private final Constants cst;
    public GeostOptions opt = new GeostOptions();
    public final PropagationEngine propagationEngine;
    public final Geost_Constraint g_constraint;
    public final Hashtable<Integer, List<ShiftedBox>> shapes = new Hashtable();
    public final Hashtable<Integer, Obj> objects = new Hashtable();
    private final List<ExternalConstraint> constraints = new ArrayList<ExternalConstraint>();
    private final transient HeapAscending ictrMinHeap = new HeapAscending();
    private final transient HeapDescending ictrMaxHeap = new HeapDescending();

    public Setup(Constants c, PropagationEngine propagationEngine, Geost_Constraint constraint) {
        this.cst = c;
        this.propagationEngine = propagationEngine;
        this.g_constraint = constraint;
    }

    public void insertShape(int sid, List<ShiftedBox> shiftedBoxes) {
        this.shapes.put(sid, shiftedBoxes);
    }

    public void insertObject(int oid, Obj o) {
        this.objects.put(oid, o);
    }

    public List<ShiftedBox> getShape(int sid) {
        return this.shapes.get(sid);
    }

    public Obj getObject(int oid) {
        return this.objects.get(oid);
    }

    public int getNbOfObjects() {
        return this.objects.size();
    }

    public int getNbOfShapes() {
        return this.shapes.size();
    }

    public int getNbOfDomainVariables() {
        int originOfObjects = this.getNbOfObjects() * this.cst.getDIM();
        int otherVariables = this.getNbOfObjects() * 4;
        return originOfObjects + otherVariables;
    }

    public void SetupTheProblem(List<Obj> objects, List<ShiftedBox> shiftedBoxes, List<ExternalConstraint> ectr) {
        int i;
        for (i = 0; i < objects.size(); ++i) {
            this.addObject(objects.get(i));
        }
        for (i = 0; i < shiftedBoxes.size(); ++i) {
            this.addShiftedBox(shiftedBoxes.get(i));
        }
        for (i = 0; i < ectr.size(); ++i) {
            this.addConstraint(ectr.get(i));
            for (int j = 0; j < ectr.get(i).getObjectIds().length; ++j) {
                this.getObject(ectr.get(i).getObjectIds()[j]).addRelatedExternalConstraint(ectr.get(i));
            }
        }
    }

    void addConstraint(ExternalConstraint ectr) {
        this.constraints.add(ectr);
    }

    public List<ExternalConstraint> getConstraints() {
        return this.constraints;
    }

    public HeapAscending getIctrMinHeap() {
        return this.ictrMinHeap;
    }

    public HeapDescending getIctrMaxHeap() {
        return this.ictrMaxHeap;
    }

    void addShiftedBox(ShiftedBox sb) {
        if (this.shapes.containsKey(sb.getShapeId())) {
            this.shapes.get(sb.getShapeId()).add(sb);
        } else {
            ArrayList<ShiftedBox> v = new ArrayList<ShiftedBox>();
            v.add(sb);
            this.shapes.put(sb.getShapeId(), v);
        }
    }

    void addObject(Obj o) {
        if (this.objects.containsKey(o.getObjectId())) {
            LOGGER.info("Trying to add an already existing object. In addObject in Setup");
        } else {
            this.objects.put(o.getObjectId(), o);
        }
    }

    public Enumeration<Integer> getObjectKeys() {
        return this.objects.keys();
    }

    public Enumeration<Integer> getShapeKeys() {
        return this.shapes.keys();
    }

    public Set<Integer> getObjectKeySet() {
        return this.objects.keySet();
    }

    public Set<Integer> getShapeKeySet() {
        return this.shapes.keySet();
    }

    public void print() {
        int i;
        for (int id : this.objects.keySet()) {
            Obj o = this.objects.get(id);
            LOGGER.info("object id: " + id);
            LOGGER.info("    shape id: " + o.getShapeId().getInf());
            for (i = 0; i < this.cst.getDIM(); ++i) {
                LOGGER.info("    Coords x" + i + " : " + o.getCoord(i).getInf() + "    " + o.getCoord(i).getSup());
            }
        }
        for (int sid : this.shapes.keySet()) {
            List<ShiftedBox> sb = this.shapes.get(sid);
            LOGGER.info("shape id: " + sid);
            for (i = 0; i < sb.size(); ++i) {
                StringBuilder offset = new StringBuilder();
                StringBuilder size = new StringBuilder();
                for (int j = 0; j < this.cst.getDIM(); ++j) {
                    offset.append(sb.get(i).getOffset(j)).append("  ");
                    size.append(sb.get(i).getSize(j)).append("  ");
                }
                LOGGER.info("    sb" + i + ": ");
                LOGGER.info("       Offset: " + offset.toString());
                LOGGER.info("       Size: " + size.toString());
            }
        }
    }

    public boolean printToFileHumanFormat(String path) {
        try {
            int i;
            BufferedWriter out = new BufferedWriter(new FileWriter(path));
            for (int id : this.objects.keySet()) {
                Obj o = this.objects.get(id);
                out.write("object id: " + id + '\n');
                out.write("    shape id: " + o.getShapeId().getInf() + '\n');
                for (i = 0; i < this.cst.getDIM(); ++i) {
                    out.write("    Coords x" + i + " : " + o.getCoord(i).getInf() + "    " + o.getCoord(i).getSup() + '\n');
                }
            }
            for (int sid : this.shapes.keySet()) {
                List<ShiftedBox> sb = this.shapes.get(sid);
                out.write("shape id: " + sid + '\n');
                for (i = 0; i < sb.size(); ++i) {
                    StringBuilder offset = new StringBuilder();
                    StringBuilder size = new StringBuilder();
                    for (int j = 0; j < this.cst.getDIM(); ++j) {
                        offset.append(sb.get(i).getOffset(j)).append("  ");
                        size.append(sb.get(i).getSize(j)).append("  ");
                    }
                    out.write("    sb" + i + ": " + '\n');
                    out.write("       Offset: " + offset.toString() + '\n');
                    out.write("       Size: " + size.toString() + '\n');
                }
            }
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public boolean printToFileInputFormat(String path) {
        try {
            int sid;
            int i;
            BufferedWriter out = new BufferedWriter(new FileWriter(path));
            Iterator<Integer> itr = this.objects.keySet().iterator();
            out.write("Objects\n");
            while (itr.hasNext()) {
                int id = itr.next();
                Obj o = this.objects.get(id);
                out.write(id + " ");
                out.write(o.getShapeId().getInf() + " " + o.getShapeId().getSup() + " ");
                for (i = 0; i < this.cst.getDIM(); ++i) {
                    out.write(o.getCoord(i).getInf() + " " + o.getCoord(i).getSup() + " ");
                }
                out.write("1 1 1 1 1 1\n");
            }
            itr = this.shapes.keySet().iterator();
            out.write("Shapes\n");
            while (itr.hasNext()) {
                sid = itr.next();
                out.write(sid + "" + '\n');
            }
            itr = this.shapes.keySet().iterator();
            out.write("ShiftedBoxes\n");
            while (itr.hasNext()) {
                sid = itr.next();
                List<ShiftedBox> sb = this.shapes.get(sid);
                for (i = 0; i < sb.size(); ++i) {
                    StringBuilder offset = new StringBuilder();
                    StringBuilder size = new StringBuilder();
                    for (int j = 0; j < this.cst.getDIM(); ++j) {
                        offset.append(sb.get(i).getOffset(j)).append(" ");
                        size.append(sb.get(i).getSize(j)).append(" ");
                    }
                    out.write(sid + " ");
                    out.write(offset.toString() + size.toString() + '\n');
                }
            }
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public void clear() {
        this.shapes.clear();
        this.objects.clear();
        this.constraints.clear();
        this.ictrMinHeap.clear();
        this.ictrMaxHeap.clear();
    }
}

