/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.speciation;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.tree.FlexibleTree;
import dr.evolution.tree.MutableTree;
import dr.evolution.tree.MutableTreeListener;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.SimpleNode;
import dr.evolution.tree.SimpleTree;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.MutableTaxonListListener;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evomodel.alloppnet.operators.MulTreeNodeSlide;
import dr.evomodel.alloppnet.speciation.MulSpeciesBindings;
import dr.evomodel.alloppnet.util.AlloppMisc;
import dr.evomodel.coalescent.VDdemographicFunction;
import dr.evomodel.tree.TreeLogger;
import dr.inference.loggers.LogColumn;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.Scalable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.HeapSort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import jebl.util.FixedBitSet;

public class MulSpeciesTreeModel
extends AbstractModel
implements MutableTree,
Citable,
TreeTraitProvider,
TreeLogger.LogUpon,
Scalable {
    private final SimpleTree spTree;
    private final MulSpeciesBindings mulspb;
    private final Map<NodeRef, NodeProperties> props = new HashMap<NodeRef, NodeProperties>();
    public final Parameter sppSplitPopulations;
    private int[] singleStartPoints;
    private int[] pairStartPoints;
    private final Parameter coalPointsPops;
    private final Parameter coalPointsIndicator;
    private boolean nodePropsReady;
    private final NodeRef[] children;
    private final double[] heights;
    private boolean anyChange;
    private boolean treeChanged;
    private final String spIndexAttrName = "spi";
    private final boolean bmp;
    private final boolean nonConstRootPopulation;
    private final boolean constantPopulation;
    public static final boolean DBUGTUNE = false;
    private static MulTreeNodeSlide internalTreeOP = null;
    private final boolean verbose = false;
    String previousTopology = null;
    TreeTrait dmt = new TreeTrait.DA(){

        @Override
        public String getTraitName() {
            return "dmt";
        }

        @Override
        public TreeTrait.Intent getIntent() {
            return TreeTrait.Intent.NODE;
        }

        @Override
        public double[] getTrait(Tree tree, NodeRef nodeRef) {
            assert (tree == MulSpeciesTreeModel.this);
            VDdemographicFunction vDdemographicFunction = (VDdemographicFunction)MulSpeciesTreeModel.this.getNodeDemographic(nodeRef);
            return vDdemographicFunction.times();
        }
    };
    TreeTrait dmv = new TreeTrait.DA(){

        @Override
        public String getTraitName() {
            return "dmv";
        }

        @Override
        public TreeTrait.Intent getIntent() {
            return TreeTrait.Intent.NODE;
        }

        @Override
        public double[] getTrait(Tree tree, NodeRef nodeRef) {
            assert (tree == MulSpeciesTreeModel.this);
            VDdemographicFunction vDdemographicFunction = (VDdemographicFunction)MulSpeciesTreeModel.this.getNodeDemographic(nodeRef);
            return vDdemographicFunction.values();
        }
    };

    public MulSpeciesTreeModel(MulSpeciesBindings mulSpeciesBindings, Parameter parameter, Parameter parameter2, Parameter parameter3, Tree tree, boolean bl, boolean bl2, boolean bl3) {
        super("mulSpeciesTree");
        int n;
        int n2;
        this.mulspb = mulSpeciesBindings;
        this.sppSplitPopulations = parameter;
        this.coalPointsPops = parameter2;
        this.coalPointsIndicator = parameter3;
        this.bmp = bl;
        this.nonConstRootPopulation = bl2;
        this.constantPopulation = bl3;
        this.addVariable(parameter);
        this.addModel(mulSpeciesBindings);
        if (parameter2 != null) {
            assert (parameter3 != null);
            assert (!bl3);
            this.addVariable(parameter2);
            this.addVariable(parameter3);
            double[][] dArray = mulSpeciesBindings.getPopTimesSingle();
            n2 = 0;
            this.singleStartPoints = new int[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.singleStartPoints[i] = n2;
                n2 += dArray[i].length;
            }
            if (!bl) {
                double[][] dArray2 = mulSpeciesBindings.getPopTimesPair();
                this.pairStartPoints = new int[dArray2.length];
                for (n = 0; n < dArray2.length; ++n) {
                    this.pairStartPoints[n] = n2;
                    n2 += dArray2[n].length;
                }
            }
        }
        this.spTree = this.compatibleUninformedSpeciesTree(tree);
        assert (TreeUtils.isBinary(this.spTree));
        int n3 = this.spTree.getNodeCount();
        this.heights = new double[n3];
        this.children = new NodeRef[2 * n3 + 1];
        for (n2 = 0; n2 < this.getExternalNodeCount(); ++n2) {
            NodeRef nodeRef = this.getExternalNode(n2);
            n = (Integer)this.getNodeAttribute(nodeRef, "spi");
            NodeProperties nodeProperties = new NodeProperties(n);
            this.props.put(nodeRef, nodeProperties);
            nodeProperties.spSet.set(n);
        }
        for (n2 = 0; n2 < this.getInternalNodeCount(); ++n2) {
            NodeRef nodeRef = this.getInternalNode(n2);
            this.props.put(nodeRef, new NodeProperties(-1));
        }
        this.nodePropsReady = false;
        n2 = this.spTree.getAttribute("check") != null ? 1 : 0;
        this.spTree.setAttribute("check", null);
        if (n2 != 0) {
            for (MulSpeciesBindings.GeneTreeInfo geneTreeInfo : mulSpeciesBindings.getGeneTrees()) {
                if (this.isCompatible(geneTreeInfo)) continue;
                mulSpeciesBindings.makeCompatible(this.spTree.getRootHeight());
                for (MulSpeciesBindings.GeneTreeInfo geneTreeInfo2 : mulSpeciesBindings.getGeneTrees()) {
                    assert (this.isCompatible(geneTreeInfo2));
                }
                this.anyChange = false;
                break;
            }
        }
        Logger.getLogger("dr.evomodel.speciation.allopolyploid").info("\tConstructing a multiply labelled tree, please cite:\n" + Citable.Utils.getCitationString(this));
    }

    private String nodeAsText(NodeRef nodeRef, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder, Locale.US);
        if (this.spTree.isExternal(nodeRef)) {
            formatter.format("%s ", this.spTree.getNodeTaxon(nodeRef));
        } else {
            formatter.format("%s ", "+");
        }
        while (stringBuilder.length() < 20 - n) {
            formatter.format("%s", " ");
        }
        formatter.format("%s ", AlloppMisc.nonnegIn8Chars(this.spTree.getNodeHeight(nodeRef)));
        return stringBuilder.toString();
    }

    private String subtreeAsText(NodeRef nodeRef, String string, Stack<Integer> stack, int n, String string2) {
        int n2;
        Integer[] integerArray = stack.toArray(new Integer[stack.size()]);
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append("  ");
        }
        for (n2 = 0; n2 < integerArray.length; ++n2) {
            stringBuffer.replace(2 * integerArray[n2], 2 * integerArray[n2] + 1, "|");
        }
        if (string2.length() > 0) {
            stringBuffer.replace(stringBuffer.length() - string2.length(), stringBuffer.length(), string2);
        }
        string = string + stringBuffer;
        string = string + this.nodeAsText(nodeRef, stringBuffer.length());
        string = string + System.getProperty("line.separator");
        String string3 = "";
        if (!this.spTree.isExternal(nodeRef)) {
            stack.push(n);
            string3 = string3 + this.subtreeAsText(this.spTree.getChild(nodeRef, 0), "", stack, n + 1, "-");
            stack.pop();
            string3 = string3 + this.subtreeAsText(this.spTree.getChild(nodeRef, 1), "", stack, n + 1, "`-");
        }
        return string + string3;
    }

    public String asText() {
        String string = "topology             height" + System.getProperty("line.separator");
        String string2 = "";
        Stack<Integer> stack = new Stack<Integer>();
        return string + this.subtreeAsText(this.spTree.getRoot(), string2, stack, 0, "");
    }

    @Override
    public String toString() {
        int n = this.mulspb.numberOfGeneTrees();
        String string = System.getProperty("line.separator");
        String string2 = string + this.asText() + string;
        for (int i = 0; i < n; ++i) {
            string2 = string2 + "Gene tree " + i + string;
            string2 = string2 + this.mulspb.genetreeAsText(i) + string;
            string2 = string2 + this.mulspb.seqassignsAsText(i) + string;
        }
        string2 = string2 + string;
        return string2;
    }

    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = new LogColumn[]{new LogColumn.Default("    MUL-tree and gene trees", this)};
        return logColumnArray;
    }

    public boolean constPopulation() {
        return this.constantPopulation;
    }

    public boolean isCompatible(MulSpeciesBindings.GeneTreeInfo geneTreeInfo) {
        if (!this.nodePropsReady) {
            this.setSPsets(this.getRoot());
        }
        return this.isSubtreeCompatible(this.getRoot(), geneTreeInfo.getCoalInfo(), 0) >= 0;
    }

    private int isSubtreeCompatible(NodeRef nodeRef, MulSpeciesBindings.CoalInfo[] coalInfoArray, int n) {
        if (!this.isExternal(nodeRef)) {
            int n2 = -1;
            for (int i = 0; i < this.getChildCount(nodeRef); ++i) {
                int n3 = this.isSubtreeCompatible(this.getChild(nodeRef, i), coalInfoArray, n);
                if (n3 < 0) {
                    return -1;
                }
                assert (n2 == -1 || n3 == n2);
                n2 = n3;
            }
            n = n2;
            assert (coalInfoArray[n].ctime >= this.getNodeHeight(nodeRef));
        }
        if (nodeRef == this.getRoot()) {
            return coalInfoArray.length;
        }
        FixedBitSet fixedBitSet = this.props.get((Object)nodeRef).spSet;
        double d = this.getNodeHeight(this.getParent(nodeRef));
        while (n < coalInfoArray.length) {
            MulSpeciesBindings.CoalInfo coalInfo = coalInfoArray[n];
            if (coalInfo.ctime >= d) break;
            boolean bl = true;
            boolean bl2 = true;
            for (int i = 0; i < 2; ++i) {
                FixedBitSet fixedBitSet2 = coalInfo.sinfo[i];
                int n4 = fixedBitSet2.intersectCardinality(fixedBitSet);
                if (n4 > 0) {
                    bl2 = false;
                }
                if (fixedBitSet2.cardinality() == n4) continue;
                bl = false;
            }
            if (!bl && !bl2) {
                return -1;
            }
            ++n;
        }
        return n;
    }

    private static double fp(double d, double d2, double[][] dArray, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n == dArray[i].length || d <= dArray[i][n]) {
                --n;
                while (n >= 0 && d <= dArray[i][n]) {
                    --n;
                }
                assert ((n < 0 || dArray[i][n] < d) && (n + 1 == dArray[i].length || d <= dArray[i][n + 1]));
                if (n < 0) continue;
                d2 = Math.max(d2, dArray[i][n]);
                continue;
            }
            ++n;
            while (n < dArray[i].length && d > dArray[i][n]) {
                ++n;
            }
            assert (dArray[i][n - 1] < d && (n == dArray[i].length || d <= dArray[i][n]));
            d2 = Math.max(d2, dArray[i][n - 1]);
        }
        return d2;
    }

    RawPopulationHelper getPopulationHelper() {
        return new RawPopulationHelper();
    }

    private NodeProperties setSPsets(NodeRef nodeRef) {
        NodeProperties nodeProperties = this.props.get(nodeRef);
        if (!this.isExternal(nodeRef)) {
            nodeProperties.spSet = new FixedBitSet(this.mulspb.nSpSeqs());
            for (int i = 0; i < this.getChildCount(nodeRef); ++i) {
                NodeProperties nodeProperties2 = this.setSPsets(this.getChild(nodeRef, i));
                nodeProperties.spSet.union(nodeProperties2.spSet);
            }
        }
        return nodeProperties;
    }

    private int ti2f(int n, int n2) {
        return n == 0 ? n2 : 2 * n + n2 + 1;
    }

    private VDdemographicFunction bestLinearFit(double[] dArray, double[] dArray2, boolean[] blArray) {
        int n;
        int n2;
        assert (dArray.length + 1 == dArray2.length);
        assert (dArray2.length == blArray.length + 2 || dArray2.length == blArray.length + 1);
        int n3 = dArray2.length;
        if (n3 == 2) {
            return new VDdemographicFunction(dArray, dArray2, this.getUnits());
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
        arrayList.add(0);
        for (int i = 0; i < n3 - 2; ++i) {
            if (!blArray[i]) continue;
            arrayList.add(i + 1);
        }
        arrayList.add(n3 - 1);
        double[] dArray3 = new double[dArray.length + 1];
        dArray3[0] = 0.0;
        System.arraycopy(dArray, 0, dArray3, 1, dArray.length);
        int n4 = arrayList.size();
        double[] dArray4 = new double[3 * n4];
        double[] dArray5 = new double[n4];
        for (n2 = 0; n2 < n4 - 1; ++n2) {
            int n5 = (Integer)arrayList.get(n2);
            n = (Integer)arrayList.get(n2 + 1);
            double d = dArray3[n5];
            double d2 = dArray3[n] - dArray3[n5];
            if (n == n3 - 1) {
                ++n;
            }
            int n6 = this.ti2f(n2, n2);
            int n7 = this.ti2f(n2 + 1, n2);
            for (int i = n5; i < n; ++i) {
                double d3 = dArray3[i];
                double d4 = dArray2[i];
                double d5 = (d3 - d) / d2;
                int n8 = n2;
                dArray5[n8] = dArray5[n8] + d4 * (1.0 - d5);
                int n9 = n6;
                dArray4[n9] = dArray4[n9] + (1.0 - d5) * (1.0 - d5);
                int n10 = n6 + 1;
                dArray4[n10] = dArray4[n10] + d5 * (1.0 - d5);
                int n11 = n7;
                dArray4[n11] = dArray4[n11] + d5 * (1.0 - d5);
                int n12 = n7 + 1;
                dArray4[n12] = dArray4[n12] + d5 * d5;
                int n13 = n2 + 1;
                dArray5[n13] = dArray5[n13] + d4 * d5;
            }
        }
        for (n2 = 0; n2 < n4 - 1; ++n2) {
            double d = dArray4[this.ti2f(n2 + 1, n2)] / dArray4[this.ti2f(n2, n2)];
            for (int i = n2; i < n2 + 3; ++i) {
                int n14 = this.ti2f(n2 + 1, i);
                dArray4[n14] = dArray4[n14] - dArray4[this.ti2f(n2, i)] * d;
            }
            int n15 = n2 + 1;
            dArray5[n15] = dArray5[n15] - dArray5[n2] * d;
        }
        double[] dArray6 = new double[n4];
        for (int i = n4 - 1; i > 0; --i) {
            dArray6[i] = dArray5[i] / dArray4[this.ti2f(i, i)];
            int n16 = i - 1;
            dArray5[n16] = dArray5[n16] - dArray4[this.ti2f(i - 1, i)] * dArray6[i];
        }
        dArray6[0] = dArray5[0] / dArray4[this.ti2f(0, 0)];
        double[] dArray7 = new double[arrayList.size() - 1];
        for (n = 0; n < dArray7.length; ++n) {
            dArray7[n] = dArray3[(Integer)arrayList.get(n + 1)];
        }
        return new VDdemographicFunction(dArray7, dArray6, this.getUnits());
    }

    private NodeProperties getDemographicPoints(NodeRef nodeRef, Args args, Points[][] pointsArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        NodeProperties nodeProperties = this.props.get(nodeRef);
        int n6 = this.mulspb.nSpSeqs();
        if (!this.isExternal(nodeRef)) {
            nodeProperties.spSet = new FixedBitSet(n6);
            for (int i = 0; i < this.getChildCount(nodeRef); ++i) {
                NodeProperties nodeProperties2 = this.getDemographicPoints(this.getChild(nodeRef, i), args, pointsArray);
                nodeProperties.spSet.union(nodeProperties2.spSet);
            }
        }
        if (args == null) {
            return nodeProperties;
        }
        double d = nodeRef != this.getRoot() ? this.getNodeHeight(this.getParent(nodeRef)) : Double.MAX_VALUE;
        ArrayList<Points> arrayList = new ArrayList<Points>(5);
        if (this.bmp) {
            n5 = nodeProperties.spSet.nextOnBit(0);
            while (n5 >= 0) {
                double[] dArray = args.cps[n5];
                n4 = this.singleStartPoints[n5];
                for (n3 = args.iSingle[n5]; n3 < dArray.length && dArray[n3] < d; ++n3) {
                    arrayList.add(new Points(dArray[n3], args.indicators[n4 + n3] > 0.0));
                }
                args.iSingle[n5] = n3;
                n5 = nodeProperties.spSet.nextOnBit(n5 + 1);
            }
        } else {
            n5 = nodeProperties.spSet.nextOnBit(0);
            while (n5 >= 0) {
                double d2 = this.spTree.getNodeHeight(nodeRef);
                double[] dArray = args.cps[n5];
                int n7 = this.singleStartPoints[n5];
                for (n2 = args.iSingle[n5]; n2 < dArray.length && dArray[n2] < d; ++n2) {
                    if (!(args.indicators[n7 + n2] > 0.0)) continue;
                    args.iSingle[n5] = n2;
                    double d3 = args.findPrev(dArray[n2], d2);
                    double d4 = (d3 + dArray[n2]) / 2.0;
                    assert (d2 < d4);
                    arrayList.add(new Points(d4, args.pops[n7 + n2]));
                }
                args.iSingle[n5] = n2;
                n3 = n5 * (2 * n6 - n5 - 3) / 2 - 1;
                n7 = nodeProperties.spSet.nextOnBit(n5 + 1);
                while (n7 >= 0) {
                    assert (n5 < n7);
                    n2 = n3 + n7;
                    double[] dArray2 = args.cpp[n2];
                    int n8 = this.pairStartPoints[n2];
                    for (n = args.iPair[n2]; n < dArray2.length && dArray2[n] < d; ++n) {
                        if (!(args.indicators[n8 + n] > 0.0)) continue;
                        args.iPair[n2] = n;
                        double d5 = args.findPrev(dArray2[n], d2);
                        double d6 = (d5 + dArray2[n]) / 2.0;
                        assert (d2 < d6);
                        arrayList.add(new Points(d6, args.pops[n8 + n]));
                    }
                    args.iPair[n2] = n;
                    n7 = nodeProperties.spSet.nextOnBit(n7 + 1);
                }
                n5 = nodeProperties.spSet.nextOnBit(n5 + 1);
            }
        }
        Comparable[] comparableArray = null;
        if (arrayList.size() > 0) {
            comparableArray = arrayList.toArray(new Points[arrayList.size()]);
            if (comparableArray.length > 1) {
                HeapSort.sort(comparableArray);
            }
            int n9 = comparableArray.length;
            if (this.bmp) {
                n4 = 0;
                while (n4 + 1 < n9) {
                    double d7 = ((Points)comparableArray[n4]).time;
                    if (d7 == ((Points)comparableArray[n4 + 1]).time) {
                        boolean bl;
                        boolean bl2 = bl = ((Points)comparableArray[n4]).use || ((Points)comparableArray[n4 + 1]).use;
                        for (n2 = n4 + 2; n2 < n9 && d7 == ((Points)comparableArray[n2]).time; ++n2) {
                            bl = bl || ((Points)comparableArray[n2]).use;
                        }
                        n = n2 - n4 - 1;
                        comparableArray[n4] = new Points(d7, bl);
                        for (int i = n4 + 1; i < n9 - n; ++i) {
                            comparableArray[i] = comparableArray[i + n];
                        }
                        n9 -= n;
                    }
                    ++n4;
                }
            } else {
                n4 = 0;
                while (n4 + 1 < n9) {
                    double d8 = ((Points)comparableArray[n4]).time;
                    if (d8 == ((Points)comparableArray[n4 + 1]).time) {
                        double d9 = ((Points)comparableArray[n4]).population + ((Points)comparableArray[n4 + 1]).population;
                        for (n2 = n4 + 2; n2 < n9 && d8 == ((Points)comparableArray[n2]).time; ++n2) {
                            d9 += ((Points)comparableArray[n2]).population;
                        }
                        int n10 = n2 - n4 - 1;
                        comparableArray[n4] = new Points(d8, d9 / (double)(n10 + 1));
                        for (int i = n4 + 1; i < n9 - n10; ++i) {
                            comparableArray[i] = comparableArray[i + n10];
                        }
                        n9 -= n10;
                    }
                    ++n4;
                }
            }
            if (n9 != comparableArray.length) {
                Points[] pointsArray2 = new Points[n9];
                System.arraycopy(comparableArray, 0, pointsArray2, 0, n9);
                comparableArray = pointsArray2;
            }
            if (this.bmp) {
                for (Comparable comparable : comparableArray) {
                    double d10 = ((Points)comparable).time;
                    assert (((Points)comparable).population == 0.0);
                    int n11 = nodeProperties.spSet.nextOnBit(0);
                    while (n11 >= 0) {
                        SimpleDemographicFunction simpleDemographicFunction = args.dms[n11];
                        if (d10 <= simpleDemographicFunction.upperBound()) {
                            ((Points)comparable).population += simpleDemographicFunction.population(d10);
                        }
                        n11 = nodeProperties.spSet.nextOnBit(n11 + 1);
                    }
                }
            }
        }
        pointsArray[nodeRef.getNumber()] = comparableArray;
        return nodeProperties;
    }

    private int setDemographics(NodeRef nodeRef, int n, int n2, double[] dArray, Points[][] pointsArray) {
        int n3;
        double d;
        int n4;
        int n5 = this.mulspb.nSpSeqs();
        NodeProperties nodeProperties = this.props.get(nodeRef);
        if (this.isExternal(nodeRef)) {
            n4 = nodeProperties.speciesIndex;
            d = dArray[n4];
            n3 = n;
        } else {
            int n6;
            assert (this.getChildCount(nodeRef) == 2);
            n4 = this.setDemographics(this.getChild(nodeRef, 0), n, 0, dArray, pointsArray);
            n3 = this.setDemographics(this.getChild(nodeRef, 1), n4 + 1, 1, dArray, pointsArray);
            if (this.constantPopulation) {
                n6 = n5 + n4;
                d = dArray[n6];
            } else {
                n6 = n5 + n4 * 2;
                d = dArray[n6] + dArray[n6 + 1];
            }
        }
        if (this.constantPopulation) {
            double[] dArray2 = new double[]{};
            double[] dArray3 = new double[]{d};
            nodeProperties.demogf = new VDdemographicFunction(dArray2, dArray3, this.getUnits());
        } else {
            int n7;
            boolean bl;
            double d2 = this.getNodeHeight(nodeRef);
            Points[] pointsArray2 = pointsArray != null ? pointsArray[nodeRef.getNumber()] : null;
            int n8 = pointsArray2 == null ? 0 : pointsArray2.length;
            boolean bl2 = nodeRef == this.getRoot();
            boolean bl3 = bl = this.bmp && pointsArray != null;
            int n9 = n8 + (bl ? (!bl2 ? 1 : 0) : 1);
            double[] dArray4 = new double[n9];
            double[] dArray5 = new double[n9 + 1];
            boolean[] blArray = new boolean[n9];
            dArray5[0] = d;
            for (n7 = 0; n7 < n8; ++n7) {
                dArray4[n7] = pointsArray2[n7].time - d2;
                dArray5[n7 + 1] = pointsArray2[n7].population;
                blArray[n7] = pointsArray2[n7].use;
            }
            if (!bl2) {
                double d3;
                n7 = n2 == 0 ? n3 : n - 1;
                double d4 = dArray[n5 + n7 * 2 + n2];
                dArray4[dArray4.length - 1] = d3 = this.getBranchLength(nodeRef);
                dArray5[dArray5.length - 1] = d4;
            }
            if (bl) {
                nodeProperties.demogf = this.bestLinearFit(dArray4, dArray5, blArray);
            } else {
                if (bl2) {
                    double d5;
                    double d6 = -1.0;
                    for (MulSpeciesBindings.GeneTreeInfo geneTreeInfo : this.mulspb.getGeneTrees()) {
                        d6 = Math.max(d6, geneTreeInfo.tree.getNodeHeight(geneTreeInfo.tree.getRoot()));
                    }
                    dArray4[dArray4.length - 1] = d5 = d6 - d2;
                    dArray5[dArray5.length - 1] = pointsArray != null ? dArray5[dArray5.length - 2] : (this.nonConstRootPopulation ? dArray[dArray.length - 1] : dArray5[dArray5.length - 2]);
                }
                nodeProperties.demogf = new VDdemographicFunction(dArray4, dArray5, this.getUnits());
            }
        }
        return n3;
    }

    private void setNodeProperties() {
        Points[][] pointsArray = null;
        if (this.coalPointsPops != null) {
            Args args = new Args(this.bmp);
            pointsArray = new Points[this.getNodeCount()][];
            this.getDemographicPoints(this.getRoot(), args, pointsArray);
        } else {
            this.getDemographicPoints(this.getRoot(), null, null);
        }
        this.setDemographics(this.getRoot(), 0, -1, ((Parameter.Default)this.sppSplitPopulations).inspectParameterValues(), pointsArray);
    }

    private Map<NodeRef, NodeProperties> getProps() {
        if (!this.nodePropsReady) {
            this.setNodeProperties();
            this.nodePropsReady = true;
        }
        return this.props;
    }

    public DemographicFunction getNodeDemographic(NodeRef nodeRef) {
        return this.getProps().get((Object)nodeRef).demogf;
    }

    public FixedBitSet spSet(NodeRef nodeRef) {
        return this.getProps().get((Object)nodeRef).spSet;
    }

    public int speciesIndex(NodeRef nodeRef) {
        assert (this.isExternal(nodeRef));
        return this.props.get(nodeRef).speciesIndex;
    }

    private Double setInitialSplitPopulations(FlexibleTree flexibleTree, NodeRef nodeRef, int[] nArray) {
        Object object;
        if (!flexibleTree.isExternal(nodeRef)) {
            int n = -1;
            for (int i = 0; i < flexibleTree.getChildCount(nodeRef); ++i) {
                object = this.setInitialSplitPopulations(flexibleTree, flexibleTree.getChild(nodeRef, i), nArray);
                if (!this.constantPopulation && i == 0) {
                    n = nArray[0];
                    nArray[0] = nArray[0] + 1;
                }
                if (object == null || this.constantPopulation) continue;
                this.sppSplitPopulations.setParameterValueQuietly(this.mulspb.nSpSeqs() + 2 * n + i, (Double)object);
            }
        }
        String string = (String)flexibleTree.getNodeAttribute(nodeRef, "comment");
        Double d = null;
        if (string != null) {
            object = new StringTokenizer(string);
            d = Double.parseDouble(((StringTokenizer)object).nextToken());
            if (flexibleTree.isExternal(nodeRef)) {
                int n = (Integer)flexibleTree.getNodeAttribute(nodeRef, "spi");
                this.sppSplitPopulations.setParameterValueQuietly(n, d);
            } else if (this.constantPopulation) {
                this.sppSplitPopulations.setParameterValueQuietly(this.mulspb.nSpSeqs() + nArray[0], d);
                nArray[0] = nArray[0] + 1;
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                d = Double.parseDouble(((StringTokenizer)object).nextToken());
            }
        }
        return !this.constantPopulation ? d : null;
    }

    private SimpleTree compatibleUninformedSpeciesTree(Tree tree) {
        int n;
        double d;
        double d2 = Double.MAX_VALUE;
        for (MulSpeciesBindings.GeneTreeInfo geneTreeInfo : this.mulspb.getGeneTrees()) {
            d2 = Math.min(d2, geneTreeInfo.getCoalInfo()[0].ctime);
        }
        if (tree != null) {
            // empty if block
        }
        int n2 = this.mulspb.nSpSeqs();
        double d3 = d = d2 / (double)(n2 + 1);
        ArrayList<SimpleNode> arrayList = new ArrayList<SimpleNode>(n2);
        for (int i = 0; i < n2; ++i) {
            SimpleNode simpleNode = new SimpleNode();
            n = this.mulspb.spseqindex2sp(i);
            int n3 = this.mulspb.spseqindex2seq(i);
            String string = this.mulspb.apspeciesName(n) + n3;
            simpleNode.setTaxon(new Taxon(string));
            arrayList.add(simpleNode);
            simpleNode.setAttribute("spi", i);
        }
        while (arrayList.size() > 1) {
            SimpleNode simpleNode = new SimpleNode();
            int n4 = 0;
            n = 1;
            simpleNode.addChild((SimpleNode)arrayList.get(n4));
            simpleNode.addChild((SimpleNode)arrayList.get(n));
            simpleNode.setHeight(d3);
            d3 += d;
            arrayList.set(n, simpleNode);
            arrayList.remove(n4);
        }
        return new SimpleTree((SimpleNode)arrayList.get(0));
    }

    public void setPreorderIndices(int[] nArray) {
        this.setPreorderIndices(this.getRoot(), 0, nArray);
    }

    private int setPreorderIndices(NodeRef nodeRef, int n, int[] nArray) {
        if (!this.isExternal(nodeRef)) {
            int n2;
            nArray[nodeRef.getNumber()] = n2 = this.setPreorderIndices(this.getChild(nodeRef, 0), n, nArray);
            n = this.setPreorderIndices(this.getChild(nodeRef, 1), n2 + 1, nArray);
        }
        return n;
    }

    @Override
    public String getName() {
        return this.getModelName();
    }

    @Override
    public int scale(double d, int n, boolean bl) {
        assert (d > 0.0);
        if (n <= 0) {
            this.beginTreeEdit();
            int n2 = this.getInternalNodeCount();
            for (int i = 0; i < n2; ++i) {
                NodeRef nodeRef = this.getInternalNode(i);
                this.setNodeHeight(nodeRef, this.getNodeHeight(nodeRef) * d);
            }
            this.endTreeEdit();
            this.fireModelChanged(this, 1);
            return n2;
        }
        if (n != 1) {
            throw new UnsupportedOperationException("not implemented for count != 1");
        }
        if (internalTreeOP == null) {
            internalTreeOP = new MulTreeNodeSlide(this, this.mulspb, 1.0);
        }
        internalTreeOP.operateOneNode(d);
        this.fireModelChanged(this, 1);
        return n;
    }

    @Override
    public boolean testBounds() {
        return true;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.nodePropsReady = false;
        this.anyChange = true;
        this.fireModelChanged();
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.nodePropsReady = false;
        this.anyChange = true;
    }

    @Override
    protected void storeState() {
        assert (!this.treeChanged);
        assert (!this.anyChange);
    }

    @Override
    protected void restoreState() {
        if (this.treeChanged) {
            this.spTree.beginTreeEdit();
            for (int i = 0; i < this.getInternalNodeCount(); ++i) {
                NodeRef nodeRef = this.getInternalNode(i);
                int n = nodeRef.getNumber();
                double d = this.heights[n];
                if (this.getNodeHeight(nodeRef) != d) {
                    this.setNodeHeight(nodeRef, d);
                }
                for (int j = 0; j < 2; ++j) {
                    NodeRef nodeRef2;
                    NodeRef nodeRef3 = this.getChild(nodeRef, j);
                    if (nodeRef3 != (nodeRef2 = this.children[2 * n + j])) {
                        this.replaceChild(nodeRef, nodeRef3, nodeRef2);
                    }
                    assert (this.getParent(nodeRef2) == nodeRef);
                }
            }
            this.setRoot(this.children[this.children.length - 1]);
            this.spTree.endTreeEdit();
        }
        if (this.treeChanged || this.anyChange) {
            this.setNodeProperties();
        }
        this.treeChanged = false;
        this.anyChange = false;
    }

    @Override
    protected void acceptState() {
        this.treeChanged = false;
        this.anyChange = false;
    }

    @Override
    public boolean logNow(long l) {
        String string = TreeUtils.uniqueNewick(this.spTree, this.spTree.getRoot());
        if (l == 0L || !string.equals(this.previousTopology)) {
            this.previousTopology = string;
            return true;
        }
        return false;
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return new TreeTrait[]{this.dmt, this.dmv};
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        if (string.equals(this.dmt.getTraitName())) {
            return this.dmt;
        }
        if (string.equals(this.dmv.getTraitName())) {
            return this.dmv;
        }
        throw new IllegalArgumentException();
    }

    public SimpleTree getSimpleTree() {
        return this.spTree;
    }

    @Override
    public Tree getCopy() {
        return this.spTree.getCopy();
    }

    @Override
    public Units.Type getUnits() {
        return this.spTree.getUnits();
    }

    @Override
    public void setUnits(Units.Type type) {
        this.spTree.setUnits(type);
    }

    @Override
    public int getNodeCount() {
        return this.spTree.getNodeCount();
    }

    @Override
    public boolean hasNodeHeights() {
        return this.spTree.hasNodeHeights();
    }

    @Override
    public double getNodeHeight(NodeRef nodeRef) {
        return this.spTree.getNodeHeight(nodeRef);
    }

    @Override
    public double getNodeRate(NodeRef nodeRef) {
        return this.spTree.getNodeRate(nodeRef);
    }

    @Override
    public Taxon getNodeTaxon(NodeRef nodeRef) {
        return this.spTree.getNodeTaxon(nodeRef);
    }

    @Override
    public int getChildCount(NodeRef nodeRef) {
        return this.spTree.getChildCount(nodeRef);
    }

    @Override
    public boolean isExternal(NodeRef nodeRef) {
        return this.spTree.isExternal(nodeRef);
    }

    @Override
    public boolean isRoot(NodeRef nodeRef) {
        return this.spTree.isRoot(nodeRef);
    }

    @Override
    public NodeRef getChild(NodeRef nodeRef, int n) {
        return this.spTree.getChild(nodeRef, n);
    }

    @Override
    public NodeRef getParent(NodeRef nodeRef) {
        return this.spTree.getParent(nodeRef);
    }

    @Override
    public boolean hasBranchLengths() {
        return this.spTree.hasBranchLengths();
    }

    @Override
    public double getBranchLength(NodeRef nodeRef) {
        return this.spTree.getBranchLength(nodeRef);
    }

    @Override
    public void setBranchLength(NodeRef nodeRef, double d) {
        this.spTree.setBranchLength(nodeRef, d);
    }

    @Override
    public NodeRef getExternalNode(int n) {
        return this.spTree.getExternalNode(n);
    }

    @Override
    public NodeRef getInternalNode(int n) {
        return this.spTree.getInternalNode(n);
    }

    @Override
    public NodeRef getNode(int n) {
        return this.spTree.getNode(n);
    }

    @Override
    public int getExternalNodeCount() {
        return this.spTree.getExternalNodeCount();
    }

    @Override
    public int getInternalNodeCount() {
        return this.spTree.getInternalNodeCount();
    }

    @Override
    public NodeRef getRoot() {
        return this.spTree.getRoot();
    }

    @Override
    public void setRoot(NodeRef nodeRef) {
        this.spTree.setRoot(nodeRef);
    }

    @Override
    public void addChild(NodeRef nodeRef, NodeRef nodeRef2) {
        this.spTree.addChild(nodeRef, nodeRef2);
    }

    @Override
    public void removeChild(NodeRef nodeRef, NodeRef nodeRef2) {
        this.spTree.removeChild(nodeRef, nodeRef2);
    }

    @Override
    public void replaceChild(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
        this.spTree.replaceChild(nodeRef, nodeRef2, nodeRef3);
    }

    @Override
    public boolean beginTreeEdit() {
        boolean bl = this.spTree.beginTreeEdit();
        if (!bl) {
            for (int i = 0; i < this.getInternalNodeCount(); ++i) {
                NodeRef nodeRef = this.getInternalNode(i);
                int n = nodeRef.getNumber();
                this.children[2 * n] = this.getChild(nodeRef, 0);
                this.children[2 * n + 1] = this.getChild(nodeRef, 1);
                this.heights[n] = this.getNodeHeight(nodeRef);
            }
            this.children[this.children.length - 1] = this.getRoot();
            this.treeChanged = true;
            this.nodePropsReady = false;
        }
        return bl;
    }

    @Override
    public void endTreeEdit() {
        this.spTree.endTreeEdit();
        this.fireModelChanged();
    }

    @Override
    public void setNodeHeight(NodeRef nodeRef, double d) {
        this.spTree.setNodeHeight(nodeRef, d);
    }

    @Override
    public void setNodeRate(NodeRef nodeRef, double d) {
        this.spTree.setNodeRate(nodeRef, d);
    }

    @Override
    public void setNodeAttribute(NodeRef nodeRef, String string, Object object) {
        this.spTree.setNodeAttribute(nodeRef, string, object);
    }

    @Override
    public Object getNodeAttribute(NodeRef nodeRef, String string) {
        return this.spTree.getNodeAttribute(nodeRef, string);
    }

    @Override
    public Iterator getNodeAttributeNames(NodeRef nodeRef) {
        return this.spTree.getNodeAttributeNames(nodeRef);
    }

    @Override
    public int getTaxonCount() {
        return this.spTree.getTaxonCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        return this.spTree.getTaxon(n);
    }

    @Override
    public String getTaxonId(int n) {
        return this.spTree.getTaxonId(n);
    }

    @Override
    public int getTaxonIndex(String string) {
        return this.spTree.getTaxonIndex(string);
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        return this.getTaxonIndex(taxon.getId());
    }

    @Override
    public List<Taxon> asList() {
        return this.spTree.asList();
    }

    @Override
    public Iterator<Taxon> iterator() {
        return this.spTree.iterator();
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        return this.spTree.getTaxonAttribute(n, string);
    }

    @Override
    public int addTaxon(Taxon taxon) {
        return this.spTree.addTaxon(taxon);
    }

    @Override
    public boolean removeTaxon(Taxon taxon) {
        return this.spTree.removeTaxon(taxon);
    }

    @Override
    public void setTaxonId(int n, String string) {
        this.spTree.setTaxonId(n, string);
    }

    @Override
    public void setTaxonAttribute(int n, String string, Object object) {
        this.spTree.setTaxonAttribute(n, string, object);
    }

    @Override
    public String getId() {
        return this.spTree.getId();
    }

    @Override
    public void setId(String string) {
        this.spTree.setId(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.spTree.setAttribute(string, object);
    }

    @Override
    public Object getAttribute(String string) {
        return this.spTree.getAttribute(string);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        return this.spTree.getAttributeNames();
    }

    @Override
    public void addMutableTreeListener(MutableTreeListener mutableTreeListener) {
        this.spTree.addMutableTreeListener(mutableTreeListener);
    }

    @Override
    public void addMutableTaxonListListener(MutableTaxonListListener mutableTaxonListListener) {
        this.spTree.addMutableTaxonListListener(mutableTaxonListListener);
    }

    public static Parameter createCoalPointsPopParameter(MulSpeciesBindings mulSpeciesBindings, Double d, Boolean bl) {
        int n = 0;
        for (double[] dArray : mulSpeciesBindings.getPopTimesSingle()) {
            n += dArray.length;
        }
        if (!bl.booleanValue()) {
            for (double[] dArray : mulSpeciesBindings.getPopTimesPair()) {
                n += dArray.length;
            }
        }
        return new Parameter.Default(n, (double)d);
    }

    public static Parameter createSplitPopulationsParameter(MulSpeciesBindings mulSpeciesBindings, double d, boolean bl, boolean bl2) {
        int n = bl2 ? 2 * mulSpeciesBindings.nSpSeqs() - 1 : 3 * mulSpeciesBindings.nSpSeqs() - 2 + (bl ? 1 : 0);
        return new Parameter.Default(n, d);
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SPECIES_MODELS;
    }

    @Override
    public String getDescription() {
        return "Multiply labelled species tree";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(new Citation(new Author[]{new Author("GR", "Jones")}, Citation.Status.IN_PREPARATION));
    }

    private static class Points
    implements Comparable<Points> {
        final double time;
        double population;
        final boolean use;

        Points(double d, double d2) {
            this.time = d;
            this.population = d2;
            this.use = true;
        }

        Points(double d, boolean bl) {
            this.time = d;
            this.population = 0.0;
            this.use = bl;
        }

        @Override
        public int compareTo(Points points) {
            return this.time < points.time ? -1 : (this.time > points.time ? 1 : 0);
        }
    }

    class RawPopulationHelper {
        final int[] preOrderIndices;
        final double[] pops;
        final int nsp;
        final Args args;

        RawPopulationHelper() {
            this.preOrderIndices = new int[MulSpeciesTreeModel.this.getNodeCount()];
            this.pops = ((Parameter.Default)MulSpeciesTreeModel.this.sppSplitPopulations).inspectParameterValues();
            this.nsp = MulSpeciesTreeModel.this.mulspb.nSpSeqs();
            this.args = MulSpeciesTreeModel.this.coalPointsPops != null ? new Args(MulSpeciesTreeModel.this.bmp) : null;
            MulSpeciesTreeModel.this.setPreorderIndices(this.preOrderIndices);
        }

        public void getPopulations(NodeRef nodeRef, int n, double[] dArray) {
            dArray[1] = this.pops[this.nsp + 2 * this.preOrderIndices[nodeRef.getNumber()] + n];
            NodeRef nodeRef2 = MulSpeciesTreeModel.this.getChild(nodeRef, n);
            if (MulSpeciesTreeModel.this.isExternal(nodeRef2)) {
                dArray[0] = this.pops[((NodeProperties)MulSpeciesTreeModel.this.props.get(nodeRef2)).speciesIndex];
            } else {
                int n2 = this.nsp + 2 * this.preOrderIndices[nodeRef2.getNumber()];
                dArray[0] = this.pops[n2] + this.pops[n2 + 1];
            }
        }

        public double tipPopulation(NodeRef nodeRef) {
            return this.pops[((NodeProperties)MulSpeciesTreeModel.this.props.get(nodeRef)).speciesIndex];
        }

        public boolean perSpeciesPopulation() {
            return this.args != null;
        }

        public double[] getTimes(int n) {
            return ((PLSD)this.args.dms[n]).times;
        }

        public double[] getPops(int n) {
            return ((PLSD)this.args.dms[n]).pops;
        }

        public void getRootPopulations(double[] dArray) {
            int n = this.nsp + 2 * this.preOrderIndices[MulSpeciesTreeModel.this.getRoot().getNumber()];
            dArray[0] = this.pops[n] + this.pops[n + 1];
            dArray[1] = MulSpeciesTreeModel.this.nonConstRootPopulation ? this.pops[this.pops.length - 1] : dArray[0];
        }

        public double geneTreesRootHeight() {
            double d = -1.0;
            for (MulSpeciesBindings.GeneTreeInfo geneTreeInfo : MulSpeciesTreeModel.this.mulspb.getGeneTrees()) {
                d = Math.max(d, geneTreeInfo.tree.getNodeHeight(geneTreeInfo.tree.getRoot()));
            }
            return d;
        }
    }

    private class Args {
        final double[][] cps;
        final double[][] cpp;
        final int[] iSingle;
        final int[] iPair;
        final double[] indicators;
        final double[] pops;
        final SimpleDemographicFunction[] dms;

        Args(Boolean bl) {
            this.cps = MulSpeciesTreeModel.this.mulspb.getPopTimesSingle();
            this.iSingle = new int[this.cps.length];
            this.indicators = ((Parameter.Default)MulSpeciesTreeModel.this.coalPointsIndicator).inspectParameterValues();
            this.pops = ((Parameter.Default)MulSpeciesTreeModel.this.coalPointsPops).inspectParameterValues();
            if (!bl.booleanValue()) {
                this.cpp = MulSpeciesTreeModel.this.mulspb.getPopTimesPair();
                this.iPair = new int[this.cpp.length];
                this.dms = null;
            } else {
                this.cpp = null;
                this.iPair = null;
                int n = this.cps.length;
                this.dms = new SimpleDemographicFunction[n];
                for (int i = 0; i < n; ++i) {
                    int n2 = MulSpeciesTreeModel.this.singleStartPoints[i];
                    int n3 = i < n - 1 ? MulSpeciesTreeModel.this.singleStartPoints[i + 1] : this.pops.length;
                    double[] dArray = new double[1 + n3 - n2];
                    dArray[0] = MulSpeciesTreeModel.this.sppSplitPopulations.getParameterValue(i);
                    for (int j = 0; j < n3 - n2; ++j) {
                        dArray[j + 1] = this.pops[n2 + j];
                    }
                    this.dms[i] = new PLSD(dArray, this.cps[i]);
                }
            }
        }

        private double findPrev(double d, double d2) {
            d2 = MulSpeciesTreeModel.fp(d, d2, this.cps, this.iSingle);
            d2 = MulSpeciesTreeModel.fp(d, d2, this.cpp, this.iPair);
            return d2;
        }
    }

    private class PLSD
    implements SimpleDemographicFunction {
        private final double[] pops;
        private final double[] times;

        public PLSD(double[] dArray, double[] dArray2) {
            assert (dArray.length == dArray2.length + 1);
            this.pops = dArray;
            this.times = dArray2;
        }

        @Override
        public double population(double d) {
            if (d >= this.upperBound()) {
                return this.pops[this.pops.length - 1];
            }
            int n = 0;
            while (d > this.times[n]) {
                d -= this.times[n];
                ++n;
            }
            double d2 = d / (this.times[n] - (n > 0 ? this.times[n - 1] : 0.0));
            return d2 * this.pops[n] + (1.0 - d2) * this.pops[n + 1];
        }

        @Override
        public double upperBound() {
            return this.times[this.times.length - 1];
        }
    }

    private static interface SimpleDemographicFunction {
        public double population(double var1);

        public double upperBound();
    }

    private class NodeProperties {
        private final int speciesIndex;
        public VDdemographicFunction demogf;
        FixedBitSet spSet;

        public NodeProperties(int n) {
            this.speciesIndex = n;
            this.demogf = null;
            this.spSet = new FixedBitSet(MulSpeciesTreeModel.this.mulspb.nSpSeqs());
        }
    }
}

