/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tbyte;

import cern.colt.PersistentObject;
import cern.colt.buffer.tbyte.ByteBuffer2DConsumer;
import cern.colt.list.tbyte.ByteArrayList;

public class ByteBuffer2D
extends PersistentObject
implements ByteBuffer2DConsumer {
    private static final long serialVersionUID = 1L;
    protected ByteBuffer2DConsumer target;
    protected byte[] xElements;
    protected byte[] yElements;
    protected ByteArrayList xList;
    protected ByteArrayList yList;
    protected int capacity;
    protected int size;

    public ByteBuffer2D(ByteBuffer2DConsumer byteBuffer2DConsumer, int n) {
        this.target = byteBuffer2DConsumer;
        this.capacity = n;
        this.xElements = new byte[n];
        this.yElements = new byte[n];
        this.xList = new ByteArrayList(this.xElements);
        this.yList = new ByteArrayList(this.yElements);
        this.size = 0;
    }

    public void add(byte by, byte by2) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = by;
        this.yElements[this.size++] = by2;
    }

    public void addAllOf(ByteArrayList byteArrayList, ByteArrayList byteArrayList2) {
        int n = byteArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(byteArrayList, byteArrayList2);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList);
            this.size = 0;
        }
    }
}

