/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.SGP;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class SGPGenerator
extends PrototypeGenerator {
    private int method;
    protected int Rmin;
    protected int Rmis;
    protected int numberOfClass;

    public SGPGenerator(PrototypeSet _trainingDataSet, int method, int Rmin, int Rmis) {
        super(_trainingDataSet);
        this.algorithmName = "SGP";
        this.method = method;
        this.Rmin = Rmin;
        this.Rmis = Rmis;
    }

    void intercambiar(PrototypeSet[] v, int pos1, int pos2) {
        PrototypeSet aux = v[pos2];
        v[pos2] = v[pos1];
        v[pos1] = aux;
    }

    public SGPGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "SGP";
        this.method = parameters.getNextAsInt();
        this.Rmin = parameters.getNextAsInt();
        this.Rmis = parameters.getNextAsInt();
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        System.out.println("Isaac dice: method SGP" + this.method + " Rmin = " + this.Rmin + " Rmis= " + this.Rmis);
        System.out.println("Number of class= " + this.numberOfClass);
    }

    @Override
    public PrototypeSet reduceSet() {
        System.out.print("\nThe algorithm is starting...\n Computing...\n");
        System.out.println("Number of class " + this.numberOfClass);
        PrototypeSet[] G = new PrototypeSet[this.numberOfClass * 100];
        PrototypeSet outputDataSet = new PrototypeSet(this.numberOfClass * 5000);
        for (int i = 0; i < this.numberOfClass; ++i) {
            G[i] = new PrototypeSet(this.trainingDataSet.getFromClass(i));
            if (G[i].size() <= 0) continue;
            outputDataSet.add(G[i].avg());
        }
        PrototypeSet nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(outputDataSet);
        System.out.println("Initial Accuracy % " + SGPGenerator.accuracy(nominalPopulation, this.trainingDataSet));
        System.out.println("Initial reduction % " + (100.0 - (double)outputDataSet.size() * 100.0 / (double)this.trainingDataSet.size()));
        int k = 0;
        int M = outputDataSet.size();
        boolean cambio = true;
        while (cambio) {
            int i;
            int j;
            double[][] distance = new double[G[k].size()][];
            double min = Double.MAX_VALUE;
            int[] indexNN = new int[M];
            int[][] pkNN = new int[G[k].size()][];
            for (j = 0; j < M; ++j) {
                indexNN[j] = k;
            }
            for (j = 0; j < G[k].size(); ++j) {
                distance[j] = new double[M];
                pkNN[j] = new int[M];
                Prototype xj = (Prototype)G[k].get(j);
                min = Double.MAX_VALUE;
                for (i = 0; i < M; ++i) {
                    if (outputDataSet.get(i) != null) {
                        distance[j][i] = Distance.d(xj.formatear(), ((Prototype)outputDataSet.get(i)).formatear());
                        if (!(distance[j][i] < min)) continue;
                        min = distance[j][i];
                        indexNN[k] = j;
                        pkNN[j][k] = i;
                        continue;
                    }
                    distance[j][i] = Double.MAX_VALUE;
                }
            }
            boolean continuar = false;
            for (int i2 = 0; i2 < G[k].size() && !continuar; ++i2) {
                if (pkNN[i2][k] == k) continue;
                continuar = true;
            }
            boolean paso7 = true;
            if (continuar) {
                for (i = 0; i < G[k].size() && paso7; ++i) {
                    paso7 = ((Prototype)outputDataSet.get(k)).getOutput(0) != ((Prototype)outputDataSet.get(pkNN[i][k])).getOutput(0) && G[k].size() > 1;
                }
                if (paso7) {
                    int i3;
                    paso7 = true;
                    Prototype mean = G[k].avg();
                    PrototypeSet zi = new PrototypeSet(G[k].size());
                    for (int l = 0; l < G[k].size(); ++l) {
                        zi.add(((Prototype)G[k].get(l)).sub(mean));
                    }
                    double[] autoval = new double[((Prototype)G[k].get(0)).numberOfInputs()];
                    double[] output = new double[]{0.0};
                    Prototype alpha2 = new Prototype(autoval, output);
                    PrototypeSet removed = new PrototypeSet();
                    for (int l = 0; l < G[k].size(); ++l) {
                        if (!(alpha2.mulEscalar((Prototype)zi.get(l)) > 0.0)) continue;
                        removed.add(G[k].get(l));
                    }
                    for (i3 = 0; i3 < removed.size(); ++i3) {
                        G[k].remove((Prototype)removed.get(i3));
                    }
                    if (removed.size() > this.Rmin) {
                        G[M] = new PrototypeSet(removed.size());
                        for (i3 = 0; i3 < removed.size(); ++i3) {
                            G[M].add(removed.get(i3));
                        }
                        outputDataSet.set(k, G[k].avg());
                        outputDataSet.add(G[M].avg());
                        ((Prototype)outputDataSet.get(M)).setFirstOutput(((Prototype)outputDataSet.get(k)).getOutput(0));
                        ++M;
                    } else {
                        paso7 = false;
                    }
                }
                if (!paso7 && G[k].size() > 1) {
                    int i4;
                    int i5;
                    PrototypeSet removed = new PrototypeSet();
                    boolean paso8 = false;
                    for (i5 = 0; i5 < G[k].size(); ++i5) {
                        if (((Prototype)outputDataSet.get(k)).getOutput(0) != ((Prototype)outputDataSet.get(pkNN[i5][k])).getOutput(0) || pkNN[i5][k] == k) continue;
                        paso8 = true;
                        removed.add(G[k].get(i5));
                        G[pkNN[i5][k]].add(G[k].get(i5));
                        outputDataSet.set(pkNN[i5][k], G[pkNN[i5][k]].avg());
                    }
                    for (i5 = 0; i5 < removed.size(); ++i5) {
                        G[k].remove((Prototype)removed.get(i5));
                    }
                    if (paso8) {
                        outputDataSet.set(k, G[k].avg());
                    }
                    removed = new PrototypeSet();
                    boolean paso9 = false;
                    for (i4 = 0; i4 < G[k].size(); ++i4) {
                        if (((Prototype)outputDataSet.get(k)).getOutput(0) == ((Prototype)outputDataSet.get(pkNN[i4][k])).getOutput(0) || pkNN[i4][k] == k) continue;
                        paso9 = true;
                        removed.add(G[k].get(i4));
                    }
                    if (removed.size() < G[k].size()) {
                        for (i4 = 0; i4 < removed.size(); ++i4) {
                            G[k].remove((Prototype)removed.get(i4));
                        }
                        if (paso9) {
                            G[M] = new PrototypeSet();
                            for (i4 = 0; i4 < removed.size(); ++i4) {
                                G[M].add(removed.get(i4));
                            }
                            outputDataSet.set(k, G[k].avg());
                            outputDataSet.add(M, G[M].avg());
                            ++M;
                        }
                    }
                }
            }
            if (!paso7 || !continuar) {
                if (k == M - 1) {
                    cambio = false;
                } else if (k != M - 1) {
                    ++k;
                    cambio = true;
                }
            }
            if (this.method != 2) continue;
            System.out.println("Method SGP2");
            for (int i6 = 0; i6 < outputDataSet.size(); ++i6) {
                for (int j2 = 0; j2 < outputDataSet.size(); ++j2) {
                    int m;
                    if (i6 == j2 || ((Prototype)outputDataSet.get(i6)).getOutput(0) != ((Prototype)outputDataSet.get(j2)).getOutput(0)) continue;
                    boolean continuar2 = true;
                    for (m = 0; m < G[i6].size() && continuar2; ++m) {
                        int indexSNN = outputDataSet.IndexSecondNearestTo((Prototype)G[i6].get(m));
                        if (indexSNN == j2) continue;
                        continuar2 = false;
                    }
                    if (!continuar2) continue;
                    System.out.println("Pre-Merging");
                    for (m = 0; m < G[i6].size() && continuar2; ++m) {
                        int indexSNN = outputDataSet.IndexSecondNearestTo((Prototype)G[j2].get(m));
                        if (indexSNN == i6) continue;
                        continuar2 = false;
                    }
                    if (!continuar2) continue;
                    System.out.println("Merging");
                    G[i6].add(G[j2]);
                    ((Prototype)outputDataSet.get(i6)).set(G[i6].avg());
                    this.intercambiar(G, j2, M - 1);
                    --M;
                }
            }
        }
        PrototypeSet realoutput = new PrototypeSet(M);
        for (int i = 0; i < M; ++i) {
            if (outputDataSet.get(i) == null) continue;
            realoutput.add(outputDataSet.get(i));
        }
        nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(realoutput);
        System.out.println("Accuracy % " + SGPGenerator.accuracy(nominalPopulation, this.trainingDataSet));
        System.out.println("Reduction % " + (100.0 - (double)realoutput.size() * 100.0 / (double)this.trainingDataSet.size()));
        return nominalPopulation;
    }

    public static void main(String[] args) {
        Parameters.setUse("SGP", "<seed> <Number of neighbors>\n<Swarm size>\n<Particle Size>\n<MaxIter>\n<DistanceFunction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        SGPGenerator.setSeed(seed);
        SGPGenerator generator = new SGPGenerator(training, 1, 1, 1);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

