/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.memory.structure.PartiallyStoredIntVector;
import choco.kernel.memory.structure.PartiallyStoredVector;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.event.VarEvent;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;

public abstract class AbstractBijectiveVar
extends AbstractVar
implements IntDomainVar {
    final IntDomainVar variable;

    public AbstractBijectiveVar(Solver solver, String name, IntDomainVar variable) {
        super(solver, name, null);
        this.variable = variable;
    }

    @Override
    public void wipeOut() throws ContradictionException {
        this.variable.wipeOut();
    }

    @Override
    public int fastNextDomainValue(int i) {
        return this.variable.getNextDomainValue(i);
    }

    @Override
    public int fastPrevDomainValue(int i) {
        return this.variable.getPrevDomainValue(i);
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return this.variable.hasEnumeratedDomain();
    }

    @Override
    public boolean hasBooleanDomain() {
        return this.variable.hasBooleanDomain();
    }

    @Override
    public IntDomain getDomain() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canBeEqualTo(IntDomainVar x) {
        if (x.getInf() <= this.getSup()) {
            if (this.getInf() <= x.getSup()) {
                if (!this.hasEnumeratedDomain() || !x.hasEnumeratedDomain()) {
                    return true;
                }
                DisposableIntIterator it = this.getDomain().getIterator();
                while (it.hasNext()) {
                    int v = it.next();
                    if (!x.canBeInstantiatedTo(v)) continue;
                    return true;
                }
                it.dispose();
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public int getDomainSize() {
        return this.variable.getDomainSize();
    }

    @Override
    public boolean isInstantiated() {
        return this.variable.isInstantiated();
    }

    @Override
    public VarEvent<? extends Var> getEvent() {
        return this.variable.getEvent();
    }

    @Override
    public SConstraint getConstraint(int i) {
        return this.variable.getConstraint(i);
    }

    @Override
    public int getNbConstraints() {
        return this.variable.getNbConstraints();
    }

    @Override
    public PartiallyStoredVector<? extends SConstraint> getConstraintVector() {
        return this.variable.getConstraintVector();
    }

    @Override
    public PartiallyStoredIntVector getIndexVector() {
        return this.variable.getIndexVector();
    }

    @Override
    public int getVarIndex(int constraintIndex) {
        return this.variable.getVarIndex(constraintIndex);
    }

    @Override
    public void eraseConstraint(SConstraint c) {
        ((AbstractVar)((Object)this.variable)).eraseConstraint(c);
    }

    @Override
    public int addConstraint(SConstraint c, int varIdx, boolean dynamicAddition) {
        return this.variable.addConstraint(c, varIdx, dynamicAddition);
    }

    @Override
    public DisposableIterator<SConstraint> getConstraintsIterator() {
        return this.variable.getConstraintsIterator();
    }
}

