/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver;

import choco.kernel.solver.Solver;
import choco.kernel.solver.search.limit.AbstractGlobalSearchLimit;
import choco.kernel.solver.search.measure.IMeasures;
import choco.kernel.solver.search.measure.ISearchMeasures;
import choco.kernel.solver.search.measure.MeasuresBean;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.real.RealInterval;
import choco.kernel.solver.variables.real.RealVar;
import choco.kernel.solver.variables.set.SetVar;
import java.util.LinkedList;
import java.util.List;

public class Solution {
    public static final int NULL = Integer.MAX_VALUE;
    protected Solver solver;
    protected int[] intVarValues;
    protected RealInterval[] realVarValues;
    protected int[][] setVarValues;
    protected int objectiveIntValue = Integer.MAX_VALUE;
    protected double objectiveRealValue = Double.POSITIVE_INFINITY;
    protected final MeasuresBean measures;
    private List<AbstractGlobalSearchLimit> solutionLimits;

    public Solution(Solver solver) {
        this.solver = solver;
        this.intVarValues = new int[solver.getNbIntVars()];
        this.setVarValues = new int[solver.getNbSetVars()][];
        this.realVarValues = new RealInterval[solver.getNbRealVars()];
        this.solutionLimits = new LinkedList<AbstractGlobalSearchLimit>();
        this.measures = new MeasuresBean();
    }

    public void setSolver(Solver s) {
        this.solver = s;
        this.solutionLimits.clear();
        if (this.solver.getNbIntVars() > this.intVarValues.length) {
            this.intVarValues = new int[this.solver.getNbIntVars()];
        }
        if (this.solver.getNbSetVars() > this.setVarValues.length) {
            this.setVarValues = new int[this.solver.getNbSetVars()][];
        }
        if (this.solver.getNbRealVars() > this.realVarValues.length) {
            this.realVarValues = new RealInterval[this.solver.getNbRealVars()];
        }
    }

    public Solver getSolver() {
        return this.solver;
    }

    public final IMeasures getMeasures() {
        return this.measures;
    }

    public final int getObjectiveValue() {
        return this.objectiveIntValue;
    }

    public final void recordSolutionCount(int solutionCount) {
        this.measures.setSolutionCount(solutionCount);
    }

    public final void recordIntValues() {
        int n = this.solver.getNbIntVars();
        for (int i = 0; i < n; ++i) {
            IntDomainVar v = this.solver.getIntVarQuick(i);
            this.intVarValues[i] = v.isInstantiated() ? v.getVal() : Integer.MAX_VALUE;
        }
    }

    public final void recordSetValues() {
        int n = this.solver.getNbSetVars();
        for (int i = 0; i < n; ++i) {
            SetVar v = this.solver.getSetVarQuick(i);
            this.setVarValues[i] = v.isInstantiated() ? v.getValue() : null;
        }
    }

    public final void recordRealValues() {
        int n = this.solver.getNbRealVars();
        for (int i = 0; i < n; ++i) {
            RealVar v = this.solver.getRealVarQuick(i);
            this.realVarValues[i] = v.getValue();
        }
    }

    public final void recordIntValue(int intVarIndex, int intVarValue) {
        this.intVarValues[intVarIndex] = intVarValue;
    }

    public final void recordSetValue(int setVarIndex, int[] setVarValue) {
        this.setVarValues[setVarIndex] = setVarValue;
    }

    public final void recordRealValue(int realVarIndex, RealInterval realVarValue) {
        this.realVarValues[realVarIndex] = realVarValue;
    }

    public final void recordIntObjective(int objectiveIntValue) {
        this.measures.setObjectiveIntValue(objectiveIntValue);
    }

    public final void recordRealObjective(double objectiveRealValue) {
        this.measures.setObjectiveRealValue(objectiveRealValue);
    }

    public final void recordSearchMeasures(ISearchMeasures measures) {
        this.measures.setSearchMeasures(measures);
    }

    public final int getIntValue(int varIndex) {
        return this.intVarValues[varIndex];
    }

    public final int[] getSetValue(int varIndex) {
        return this.setVarValues[varIndex];
    }

    public final RealInterval getRealValue(int varIndex) {
        return this.realVarValues[varIndex];
    }
}

