/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import com.qarks.util.Cancellable;
import com.qarks.util.CancellableImpl;
import com.qarks.util.stream.FileHelper;
import com.qarks.util.stream.StreamCopyListener;
import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import com.qarks.util.ui.swing.FileLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class FileDownloader
extends JDialog {
    private JProgressBar progress;
    private JButton cancel;
    private JLabel errorLabel;
    private DownloadingThread downloadingThread;
    private Cancellable cancellable;

    public FileDownloader(Window window, URL uRL, String string, File file) {
        super(window, ResourceManager.getString((Object)ResourceKey.DOWNLOADING_FILE), Dialog.ModalityType.APPLICATION_MODAL);
        super.setDefaultCloseOperation(0);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(jPanel);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.progress = new JProgressBar();
        this.errorLabel = new JLabel();
        this.cancel = new JButton(ResourceManager.getString((Object)ResourceKey.CANCEL));
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileDownloader.this.cancel();
            }
        });
        this.cancellable = new CancellableImpl();
        jPanel.add((Component)this.progress, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)jPanel2, "South");
        jPanel2.add((Component)this.cancel, "Center");
        jPanel2.add((Component)this.errorLabel, "South");
        this.progress.setPreferredSize(new Dimension(200, 25));
        this.pack();
        this.downloadingThread = new DownloadingThread(uRL, string, file);
        this.downloadingThread.start();
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void cancel() {
        this.cancellable.cancel();
        this.dispose();
    }

    private void setProgress(int n) {
        this.progress.setValue(n);
    }

    private void openFile(File file) {
        try {
            Desktop.getDesktop().open(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            FileLauncher.systemLaunchLine(file.getAbsolutePath());
        }
        this.dispose();
    }

    private void onException(Exception exception) {
        this.errorLabel.setText("<html><font color=\"#FF0000\" face=\"Verdana\">" + exception.getMessage() + "</font></html>");
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.cancel.setText("Close");
    }

    private class DownloadingThread
    extends Thread
    implements StreamCopyListener {
        private URL fileUrl;
        private String originalName;
        private File tempFolder;

        public DownloadingThread(URL uRL, String string, File file) {
            this.fileUrl = uRL;
            this.originalName = string;
            this.tempFolder = file;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(300L);
                File file = FileHelper.download(this.fileUrl, this.originalName, this, this.tempFolder, FileDownloader.this.cancellable);
                if (!FileDownloader.this.cancellable.isCancelled()) {
                    Thread.sleep(300L);
                    FileDownloader.this.openFile(file);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileDownloader.this.onException(exception);
                    }
                });
            }
        }

        @Override
        public void onFileCopyStart(File file) {
        }

        @Override
        public void onLengthChanged(long l) {
        }

        @Override
        public void onLengthChanged(final long l, final long l2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n = (int)((double)l * 100.0 / (double)l2);
                    FileDownloader.this.setProgress(n);
                }
            });
        }

        @Override
        public void onFileCopyEnded(File file) {
        }

        @Override
        public void onFileCopyEnding(File file) {
        }
    }
}

