/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.io.IOException;
import java.util.List;
import org.dmg.pmml.DataType;
import org.jpmml.rexp.RBooleanVector;
import org.jpmml.rexp.RDataOutput;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpUtil;
import org.jpmml.rexp.RFactorVector;
import org.jpmml.rexp.RIntegerVector;
import org.jpmml.rexp.RNumberVector;
import org.jpmml.rexp.RPair;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.RVector;

public class RGenericVector
extends RVector<RExp> {
    private List<RExp> values = null;

    public RGenericVector(List<RExp> values, RPair attributes) {
        super(attributes);
        this.setValues(values);
    }

    @Override
    int type() {
        return 19;
    }

    @Override
    void writeValues(RDataOutput output) throws IOException {
        List<RExp> values = this.getValues();
        int length = values.size();
        output.writeInt(length);
        for (int i = 0; i < length; ++i) {
            RExp value = values.get(i);
            value.write(output);
        }
    }

    @Override
    public DataType getDataType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public RExp getValue(int index) {
        return this.values.get(index);
    }

    public RDoubleVector getDoubleValue(int index) {
        return this.getVectorValue(RDoubleVector.class, index);
    }

    public RFactorVector getFactorValue(int index) {
        return this.getVectorValue(RFactorVector.class, index);
    }

    public RGenericVector getGenericValue(int index) {
        return this.getVectorValue(RGenericVector.class, index);
    }

    public RIntegerVector getIntegerValue(int index) {
        return this.getVectorValue(RIntegerVector.class, index);
    }

    public RNumberVector<?> getNumericValue(int index) {
        return this.getVectorValue(RNumberVector.class, index);
    }

    public RStringVector getStringValue(int index) {
        return this.getVectorValue(RStringVector.class, index);
    }

    public RVector<?> getVectorValue(int index) {
        return this.getVectorValue(RVector.class, index);
    }

    private <V extends RVector<E>, E> V getVectorValue(Class<V> clazz, int index) {
        RExp rexp = this.getValue(index);
        try {
            return (V)((RVector)clazz.cast(rexp));
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Invalid value on position " + (index + 1) + ". Expected " + RExpUtil.getVectorType(clazz) + ", got " + RExpUtil.getVectorType(rexp.getClass()));
        }
    }

    public RBooleanVector getBooleanElement(String name) {
        return this.getBooleanElement(name, true);
    }

    public RBooleanVector getBooleanElement(String name, boolean required) {
        return this.getVectorElement(RBooleanVector.class, name, required);
    }

    public RDoubleVector getDoubleElement(String name) {
        return this.getDoubleElement(name, true);
    }

    public RDoubleVector getDoubleElement(String name, boolean required) {
        return this.getVectorElement(RDoubleVector.class, name, required);
    }

    public RFactorVector getFactorElement(String name) {
        return this.getFactorElement(name, true);
    }

    public RFactorVector getFactorElement(String name, boolean required) {
        return this.getVectorElement(RFactorVector.class, name, required);
    }

    public RGenericVector getGenericElement(String name) {
        return this.getGenericElement(name, true);
    }

    public RGenericVector getGenericElement(String name, boolean required) {
        return this.getVectorElement(RGenericVector.class, name, required);
    }

    public RIntegerVector getIntegerElement(String name) {
        return this.getIntegerElement(name, true);
    }

    public RIntegerVector getIntegerElement(String name, boolean required) {
        return this.getVectorElement(RIntegerVector.class, name, required);
    }

    public RNumberVector<?> getNumericElement(String name) {
        return this.getNumericElement(name, true);
    }

    public RNumberVector<?> getNumericElement(String name, boolean required) {
        return this.getVectorElement(RNumberVector.class, name, required);
    }

    public RStringVector getStringElement(String name) {
        return this.getStringElement(name, true);
    }

    public RStringVector getStringElement(String name, boolean required) {
        return this.getVectorElement(RStringVector.class, name, required);
    }

    public RVector<?> getVectorElement(String name) {
        return this.getVectorElement(name, true);
    }

    public RVector<?> getVectorElement(String name, boolean required) {
        return this.getVectorElement(RVector.class, name, required);
    }

    private <V extends RVector<E>, E> V getVectorElement(Class<V> clazz, String name, boolean required) {
        RExp rexp = (RExp)this.getElement(name, required);
        try {
            return (V)((RVector)clazz.cast(rexp));
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Invalid '" + name + "' element. Expected " + RExpUtil.getVectorType(clazz) + ", got " + RExpUtil.getVectorType(rexp.getClass()));
        }
    }

    @Override
    public List<RExp> getValues() {
        return this.values;
    }

    private void setValues(List<RExp> values) {
        this.values = values;
    }
}

