/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;
import java.util.ArrayList;
import java.util.Collections;

public class PiecewiseConstantPopulation
extends DemographicFunction.Abstract {
    ArrayList<Double> cif = null;
    ArrayList<Double> endTime = null;
    final boolean cacheCumulativeIntensities = true;
    private boolean intensitiesKnown = false;
    double[] intervals;
    double[] thetas;

    public PiecewiseConstantPopulation(Units.Type type) {
        super(type);
    }

    public PiecewiseConstantPopulation(double[] dArray, double[] dArray2, Units.Type type) {
        super(type);
        this.setIntervals(dArray, dArray2);
    }

    public void setIntervals(double[] dArray, double[] dArray2) {
        if (dArray2 == null || dArray == null) {
            throw new IllegalArgumentException();
        }
        if (dArray2.length != dArray.length + 1) {
            throw new IllegalArgumentException();
        }
        this.intervals = dArray;
        this.thetas = dArray2;
        this.cif = new ArrayList(dArray.length);
        this.endTime = new ArrayList(dArray.length);
        this.cif.add(this.getIntensity(0));
        this.endTime.add(dArray[0]);
        for (int i = 1; i < dArray.length; ++i) {
            this.cif.add(this.getIntensity(i) + this.cif.get(i - 1));
            this.endTime.add(dArray[i] + this.endTime.get(i - 1));
        }
        this.intensitiesKnown = true;
    }

    @Override
    public double getDemographic(double d) {
        int n = 0;
        double d2 = d;
        while (d2 > this.getEpochDuration(n)) {
            d2 -= this.getEpochDuration(n);
            ++n;
        }
        return this.getDemographic(n, d2);
    }

    @Override
    public double getIntensity(double d) {
        if (this.cif != null) {
            int n;
            if (!this.intensitiesKnown) {
                this.setIntervals(this.intervals, this.thetas);
            }
            if ((n = Collections.binarySearch(this.endTime, d)) < 0) {
                if ((n = -n - 1) > 0) {
                    return this.cif.get(n - 1) + this.getIntensity(n, d - this.endTime.get(n - 1));
                }
                assert (n == 0);
                return this.getIntensity(0, d);
            }
            return this.cif.get(n);
        }
        double d2 = 0.0;
        int n = 0;
        double d3 = d;
        while (d3 > this.getEpochDuration(n)) {
            d3 -= this.getEpochDuration(n);
            d2 += this.getIntensity(n);
            ++n;
        }
        return d2 += this.getIntensity(n, d3);
    }

    @Override
    public double getInverseIntensity(double d) {
        double d2;
        double d3 = 0.0;
        int n = 0;
        for (d2 = d; d2 > this.getIntensity(n); d2 -= this.getIntensity(n)) {
            if (++n != this.intervals.length) continue;
        }
        return d3 += this.getEpochDuration(n) + d2 * this.getEpochDemographic(n + 1);
    }

    @Override
    public double getUpperBound(int n) {
        return 1.0E9;
    }

    @Override
    public double getLowerBound(int n) {
        return Double.MIN_VALUE;
    }

    @Override
    public int getNumArguments() {
        return this.thetas.length;
    }

    @Override
    public String getArgumentName(int n) {
        return "theta" + n;
    }

    @Override
    public double getArgument(int n) {
        return this.thetas[n];
    }

    @Override
    public void setArgument(int n, double d) {
        this.thetas[n] = d;
        this.intensitiesKnown = false;
    }

    public DemographicFunction getCopy() {
        PiecewiseConstantPopulation piecewiseConstantPopulation = new PiecewiseConstantPopulation(new double[this.intervals.length], new double[this.thetas.length], this.getUnits());
        System.arraycopy(this.intervals, 0, piecewiseConstantPopulation.intervals, 0, this.intervals.length);
        System.arraycopy(this.thetas, 0, piecewiseConstantPopulation.thetas, 0, this.thetas.length);
        piecewiseConstantPopulation.setIntervals(this.intervals, this.thetas);
        return piecewiseConstantPopulation;
    }

    protected double getDemographic(int n, double d) {
        return this.getEpochDemographic(n);
    }

    protected double getIntensity(int n) {
        return this.getEpochDuration(n) / this.getEpochDemographic(n);
    }

    protected double getIntensity(int n, double d) {
        assert (0.0 <= d && d <= this.getEpochDuration(n));
        return d / this.getEpochDemographic(n);
    }

    public double getEpochDuration(int n) {
        if (n == this.intervals.length) {
            return Double.POSITIVE_INFINITY;
        }
        return this.intervals[n];
    }

    public void setEpochDuration(int n, double d) {
        if (n < 0 || n >= this.intervals.length) {
            throw new IllegalArgumentException("epoch must be between 0 and " + (this.intervals.length - 1));
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("duration must be positive.");
        }
        this.intervals[n] = d;
    }

    public final double getEpochDemographic(int n) {
        if (n < 0 || n >= this.thetas.length) {
            throw new IllegalArgumentException();
        }
        return this.thetas[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.thetas[0]);
        for (int i = 1; i < this.thetas.length; ++i) {
            stringBuffer.append("\t").append(this.thetas[i]);
        }
        return stringBuffer.toString();
    }
}

