/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.geo.color.ChannelColorScheme;
import dr.geo.color.ColorScheme;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class TIFFWriter {
    public static final short MAXROWS = 6000;
    public static final short MAXCOLUMNS = 3000;
    public static final short GOOD_WRITE = 0;
    public static final short BAD_WRITE = 1;
    public static final short BAD_READ = 2;
    public static final short MEMORY_ERROR = 3;
    public static final short WRONG_BITS = 4;
    public static final short RGB_RED = 0;
    public static final short RGB_GREEN = 1;
    public static final short RGB_BLUE = 2;
    public static final short RGB_SIZE = 3;
    public static final short TIFFbyte = 1;
    public static final short TIFFascii = 2;
    public static final short TIFFshort = 3;
    public static final short TIFFlong = 4;
    public static final short TIFFrational = 5;
    public static final short NewSubFile = 254;
    public static final short SubFileType = 255;
    public static final short ImageWidth = 256;
    public static final short ImageLength = 257;
    public static final short RowsPerStrip = 278;
    public static final short StripOffsets = 273;
    public static final short StripByteCounts = 279;
    public static final short SamplesPerPixel = 277;
    public static final short BitsPerSample = 258;
    public static final short Compression = 259;
    public static final short PlanarConfiguration = 284;
    public static final short Group3Options = 292;
    public static final short Group4Options = 293;
    public static final short FillOrder = 266;
    public static final short Threshholding = 263;
    public static final short CellWidth = 264;
    public static final short CellLength = 265;
    public static final short MinSampleValue = 280;
    public static final short MaxSampleValue = 281;
    public static final short PhotoMetricInterp = 262;
    public static final short GrayResponseUnit = 290;
    public static final short GrayResponseCurve = 291;
    public static final short ColorResponseUnit = 300;
    public static final short ColorResponseCurves = 301;
    public static final short XResolution = 282;
    public static final short YResolution = 283;
    public static final short ResolutionUnit = 296;
    public static final short Orientation = 274;
    public static final short DocumentName = 269;
    public static final short PageName = 285;
    public static final short XPosition = 286;
    public static final short YPosition = 287;
    public static final short PageNumber = 297;
    public static final short ImageDescription = 270;
    public static final short Make = 271;
    public static final short Model = 272;
    public static final short FreeOffsets = 288;
    public static final short FreeByteCounts = 289;
    public static final short ColorMap = 320;
    public static final short Artist = 315;
    public static final short DateTime = 306;
    public static final short HostComputer = 316;
    public static final short Software = 305;

    public static void writeDoubleArray(String string, double[][] dArray) {
        TIFFWriter.writeDoubleArray(string, dArray, "png", ColorScheme.HEATMAP);
    }

    public static void writeDoubleArrayMultiChannel(String string, List<double[][]> list, String string2, ChannelColorScheme channelColorScheme) {
        double d;
        int n;
        int n2 = list.get(0).length;
        int n3 = list.get(0)[0].length;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        int n4 = list.size();
        for (n = 0; n < n4; ++n) {
            double[][] dArray = list.get(n);
            double d2 = Double.NEGATIVE_INFINITY;
            d = Double.POSITIVE_INFINITY;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    double d3 = dArray[i][j];
                    if (d3 > d2) {
                        d2 = d3;
                        continue;
                    }
                    if (!(d3 < d)) continue;
                    d = d3;
                }
            }
            arrayList.add(d2);
            arrayList2.add(d);
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                for (int j = 0; j < n4; ++j) {
                    d = list.get(j)[n][i];
                    arrayList3.add(d);
                }
                bufferedImage.setRGB(n, i, channelColorScheme.getColor(arrayList3, arrayList2, arrayList).getRGB());
            }
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeDoubleArray(String string, double[][] dArray, String string2, ColorScheme colorScheme) {
        double d;
        int n;
        int n2;
        BufferedImage bufferedImage = new BufferedImage(dArray.length, dArray[0].length, 2);
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray[n2].length; ++n) {
                d = dArray[n2][n];
                if (d > d2) {
                    d2 = d;
                    continue;
                }
                if (!(d < d3)) continue;
                d3 = d;
            }
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray[n2].length; ++n) {
                d = dArray[n2][n];
                bufferedImage.setRGB(n2, n, colorScheme.getColor(d, d3, d2).getRGB());
            }
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeDoubleArray(DataOutputStream dataOutputStream, double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (n < 0 || n > 6000 || n2 < 0 || n2 > 3000) {
            throw new RuntimeException("Invalid # rows and # columns");
        }
        int n3 = 8 + n * n2;
        try {
            int n4 = 73;
            short s = (short)(n4 * 256 + n4);
            TIFFWriter.fputword(dataOutputStream, s);
            TIFFWriter.fputword(dataOutputStream, (short)42);
            TIFFWriter.fputlong(dataOutputStream, n3);
            for (n4 = 0; n4 < n; n4 = (int)((short)(n4 + 1))) {
                for (s = 0; s < n2; s = (short)(s + 1)) {
                    int n5 = (int)dArray[n4][s];
                    dataOutputStream.writeByte((byte)n5);
                }
            }
            TIFFWriter.fputword(dataOutputStream, (short)8);
            TIFFWriter.writetiftag(dataOutputStream, (short)255, (short)3, 1, 1);
            TIFFWriter.writetiftag(dataOutputStream, (short)256, (short)3, 1, n2);
            TIFFWriter.writetiftag(dataOutputStream, (short)257, (short)3, 1, n);
            TIFFWriter.writetiftag(dataOutputStream, (short)258, (short)3, 1, 8);
            TIFFWriter.writetiftag(dataOutputStream, (short)259, (short)3, 1, 1);
            TIFFWriter.writetiftag(dataOutputStream, (short)262, (short)3, 1, 1);
            TIFFWriter.writetiftag(dataOutputStream, (short)273, (short)4, 1, 8);
            TIFFWriter.writetiftag(dataOutputStream, (short)284, (short)3, 1, 1);
            TIFFWriter.fputlong(dataOutputStream, 0);
        }
        catch (IOException iOException) {
            System.out.println("Error occured while writing output file.");
        }
    }

    static void writetiftag(DataOutputStream dataOutputStream, short s, short s2, int n, int n2) {
        TIFFWriter.fputword(dataOutputStream, s);
        TIFFWriter.fputword(dataOutputStream, s2);
        TIFFWriter.fputlong(dataOutputStream, n);
        TIFFWriter.fputlong(dataOutputStream, n2);
    }

    static void fputword(DataOutputStream dataOutputStream, short s) {
        try {
            dataOutputStream.writeByte((byte)s);
            dataOutputStream.writeByte((byte)(s >> 8));
        }
        catch (IOException iOException) {
            System.out.println("Error occured while writing output file.");
        }
    }

    static void fputlong(DataOutputStream dataOutputStream, int n) {
        try {
            dataOutputStream.writeByte((byte)n);
            dataOutputStream.writeByte((byte)(n >> 8));
            dataOutputStream.writeByte((byte)(n >> 16));
            dataOutputStream.writeByte((byte)(n >> 24));
        }
        catch (IOException iOException) {
            System.out.println("Error occured while writing output file.");
        }
    }
}

