library(CARMS)

SaDiode1<-carms.make(title="Assembly        Diode Config 1", diagram_grid=c(11,12) )
SaDiode1<-carms.state(SaDiode1, prob=1, name="All good",size=8, h2w=16/31,  position=c(2,5))
SaDiode1<-carms.state(SaDiode1, prob=0, name="1 of 4 opened",size=8,  h2w=16/31, position=c(4,2))
SaDiode1<-carms.state(SaDiode1, prob=0, name="1 of 4 shorted",size=8,  h2w=16/31, position=c(4,8))
SaDiode1<-carms.state(SaDiode1, prob=0, name="1 diode left",size=8,  h2w=16/31, position=c(7,4))
SaDiode1<-carms.state(SaDiode1, prob=0, name="2 diodes left",size=8,  h2w=16/31, position=c(8,10))
SaDiode1<-carms.state(SaDiode1, prob=0, name="failed state",size=8,  h2w=16/31, position=c(10,6))

# usage: carms.base(x, value, time_units=NULL, base_label=NULL, description="")
SaDiode1<-carms.base(SaDiode1, 1e-6, time_units= "thousand Hours",base_label="Open",description="Open failure rate")
SaDiode1<-carms.base(SaDiode1, 5e-7, base_label="Short", description="Short failure rate")

# carms.arrow<-(x, from, to, rate, arc=0.35, arrow.position=0.5, label="")
SaDiode1<-carms.arrow(SaDiode1, 1, 2, rate="4*Open", label="4*Open", arc=.2)
SaDiode1<-carms.arrow(SaDiode1, 2, 4, rate= "2*Short", label="2*Short", arc= .2)
SaDiode1<-carms.arrow(SaDiode1, 2, 6, rate="2*Open", label="2*Open", arc=.45)
SaDiode1<-carms.arrow(SaDiode1, 1, 3, rate="4*Short", label="4*Short", arc=- .2)
SaDiode1<-carms.arrow(SaDiode1, 3, 5, rate="2*Short", label="2*Short", arc=-.3)
SaDiode1<-carms.arrow(SaDiode1, 5, 6, rate="2*Short", label="2*Short", arc= -.2)
SaDiode1<-carms.arrow(SaDiode1, 4, 6, rate="Open+Short", label="Open+Short", arc=.2)
SaDiode1<-carms.arrow(SaDiode1, 5, 4, rate="2*Open", label="2*Open", arc= -.1)
SaDiode1<-carms.arrow(SaDiode1, 3, 4, rate="2*Open", label="2*Open", arc=.1)
SaDiode1<-carms.arrow(SaDiode1, 3, 2, rate="Open", label="Open", arc=0)
SaDiode1<-carms.arrow(SaDiode1, 3, 6, rate="Open", label="Open", arrow.position=0.4, arc=- .2)
	dev.new(width=12, height=8, unit="in")
	diagram(SaDiode1)
# usage: simulate.carms(x, solution, mission_time, intervals=50, cycles=2000)
SaDiode1<-simulate.carms(SaDiode1, "rk", mission_time=2*10e5, 50)
plot.carms(SaDiode1, smooth_curve=T)
