## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(SIHR)

## -----------------------------------------------------------------------------
set.seed(0)
n <- 200
p <- 150
X <- matrix(rnorm(n * p), nrow = n, ncol = p)
y <- -0.5 + X %*% c(0.5, rep(1, 4), rep(0, p - 5))

## -----------------------------------------------------------------------------
loading1 <- c(1, rep(0, p - 1)) # for 1st objective, true value = 0.5
loading2 <- c(1, 1, rep(0, p - 2)) # for 2nd objective, true value = 1.5
loading.mat <- cbind(loading1, loading2)

## -----------------------------------------------------------------------------
Est <- LF(X, y, loading.mat, model = "linear", intercept = TRUE, intercept.loading = FALSE, verbose = TRUE)

## -----------------------------------------------------------------------------
ci(Est)
summary(Est)

## -----------------------------------------------------------------------------
G <- c(1:4) # 3rd objective, true value = 3.25

## -----------------------------------------------------------------------------
Est <- QF(X, y, G, A = NULL, model = "linear", intercept = TRUE, verbose = TRUE)

## -----------------------------------------------------------------------------
ci(Est)

## -----------------------------------------------------------------------------
summary(Est)

## -----------------------------------------------------------------------------
set.seed(1)
n <- 200
p <- 120
X <- matrix(rnorm(n * p), nrow = n, ncol = p)
val <- -1.5 + X[, 1] * 0.5 + X[, 2] * 1
prob <- exp(val) / (1 + exp(val))
y <- rbinom(n, 1, prob)

## -----------------------------------------------------------------------------
loading1 <- c(1, 1, rep(0, p - 2)) # for 1st objective, true value = 1.5
loading2 <- c(-0.5, -1, rep(0, p - 2)) # for 2nd objective, true value = -1.25
loading.mat <- cbind(loading1, loading2)

## -----------------------------------------------------------------------------
Est <- LF(X, y, loading.mat, model = "logistic", verbose = TRUE)

## -----------------------------------------------------------------------------
ci(Est)
summary(Est)

## -----------------------------------------------------------------------------
set.seed(0)
n <- 400
p <- 120
X <- matrix(rnorm(n * p), nrow = n, ncol = p)
val <- -1.5 + X[, 1] * 0.5 + X[, 2] * 1
prob <- exp(val) / (1 + exp(val))
y <- rbinom(n, 1, prob)
G <- c(1:3) # 3rd objective, true value = 1.25

## -----------------------------------------------------------------------------
Est <- QF(X, y, G, A = NULL, model = "logistic_alter", intercept = TRUE, verbose = TRUE)

## -----------------------------------------------------------------------------
ci(Est)

## -----------------------------------------------------------------------------
summary(Est)

